// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_dialog/cr_dialog.js";import"./diagnostics_shared.css.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{CanvasDrawingProvider}from"./drawing_provider.js";import{getTemplate}from"./touchpad_tester.html.js";const TouchpadTesterElementBase=I18nMixin(PolymerElement);export class TouchpadTesterElement extends TouchpadTesterElementBase{constructor(){super(...arguments);this.drawingProvider=null;this.touchpad=null}static get is(){return"touchpad-tester"}static get template(){return getTemplate()}static get properties(){return{}}connectedCallback(){super.connectedCallback();const ctx=this.$.testerCanvas.getContext("2d");assert(!!ctx);this.drawingProvider=new CanvasDrawingProvider(ctx)}close(){this.$.touchpadTesterDialog.close();this.touchpad=null}isOpen(){assert(!!this.$.touchpadTesterDialog);return this.$.touchpadTesterDialog.open}show(touchpad){assert(!!touchpad);this.touchpad=touchpad;this.$.touchpadTesterDialog.showModal()}onTouchEvent(event){assert(event);event.touchData.forEach((touch=>this.drawTouchPoint(touch)))}drawTouchPoint(touchPoint){assert(!!this.drawingProvider);this.drawingProvider.drawTrailMark(touchPoint.positionX,touchPoint.positionY)}getDrawingProviderForTesting(){assert(this.drawingProvider);return this.drawingProvider}}customElements.define(TouchpadTesterElement.is,TouchpadTesterElement);