// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_dialog/cr_dialog.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{assert}from"chrome://resources/js/assert.js";import{EventTracker}from"chrome://resources/js/event_tracker.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{CanvasDrawingProvider}from"./drawing_provider.js";import{TabletModeObserverReceiver}from"./input_data_provider.mojom-webui.js";import{getInputDataProvider}from"./mojo_interface_provider.js";import{getTemplate}from"./touchscreen_tester.html.js";export const SCREEN_MAX_LENGTH=9999;export var DialogType;(function(DialogType){DialogType["INTRO"]="intro-dialog";DialogType["CANVAS"]="canvas-dialog"})(DialogType||(DialogType={}));export var TouchEventType;(function(TouchEventType){TouchEventType["START"]="touchstart";TouchEventType["MOVE"]="touchmove";TouchEventType["END"]="touchend"})(TouchEventType||(TouchEventType={}));const TouchscreenTesterElementBase=I18nMixin(PolymerElement);export class TouchscreenTesterElement extends TouchscreenTesterElementBase{constructor(){super(...arguments);this.touches=new Map;this.isTabletMode=false;this.eventTracker=new EventTracker;this.receiver=null;this.inputDataProvider=getInputDataProvider()}static get is(){return"touchscreen-tester"}static get template(){return getTemplate()}static get properties(){return{touchscreenIdUnderTesting:{type:Number,value:-1,notify:true}}}getDrawingProvider(){return this.drawingProvider}getTouches(){return this.touches}getIsTabletMode(){return this.isTabletMode}getEventTracker(){return this.eventTracker}getDialog(dialogId){const dialog=this.shadowRoot.getElementById(dialogId);assert(dialog);return dialog}async showTester(evdevId){this.inputDataProvider.moveAppToTestingScreen(evdevId);this.receiver=new TabletModeObserverReceiver(this);const{isTabletMode:isTabletMode}=await this.inputDataProvider.observeTabletMode(this.receiver.$.bindNewPipeAndPassRemote());this.isTabletMode=isTabletMode;const introDialog=this.getDialog(DialogType.INTRO);await introDialog.requestFullscreen();introDialog.showModal();this.addListeners()}addListeners(){this.eventTracker.add(document,"fullscreenchange",(e=>{e.preventDefault();if(!document.fullscreenElement&&this.touchscreenIdUnderTesting!==-1){this.closeTester();this.inputDataProvider.moveAppBackToPreviousScreen()}}));this.eventTracker.add(window,"keydown",(e=>{if(e.key==="AudioVolumeUp"&&this.isTabletMode){document.exitFullscreen()}}))}closeTester(){this.getDialog(DialogType.INTRO).close();this.getDialog(DialogType.CANVAS).close();this.eventTracker.removeAll();this.inputDataProvider.setA11yTouchPassthrough(false);this.touchscreenIdUnderTesting=-1;if(document.fullscreenElement){document.exitFullscreen()}if(this.receiver){this.receiver.$.close()}}onStartClick(){this.getDialog(DialogType.INTRO).close();this.getDialog(DialogType.CANVAS).showModal();this.setupCanvas();this.inputDataProvider.setA11yTouchPassthrough(true)}setupCanvas(){const canvas=this.shadowRoot.querySelector("canvas");assert(canvas);canvas.width=SCREEN_MAX_LENGTH;canvas.height=SCREEN_MAX_LENGTH;const topContainer=this.getDialog(DialogType.CANVAS).shadowRoot.querySelector(".top-container");topContainer.style.display="none";const ctx=canvas.getContext("2d");assert(ctx);this.drawingProvider=new CanvasDrawingProvider(ctx);this.observeDataSource(canvas)}observeDataSource(canvas){for(const eventType of[TouchEventType.START,TouchEventType.MOVE,TouchEventType.END]){this.eventTracker.add(canvas,eventType,(e=>{e.preventDefault();for(let i=0;i<e.changedTouches.length;i++){const currentTouch=e.changedTouches[i];const touchPt={x:currentTouch.pageX-canvas.offsetLeft,y:currentTouch.pageY-canvas.offsetTop};if(eventType===TouchEventType.START){this.onDrawStart(currentTouch.identifier,touchPt,currentTouch.force)}else if(eventType===TouchEventType.MOVE){this.onDraw(currentTouch.identifier,touchPt,currentTouch.force)}else if(eventType===TouchEventType.END){this.onDrawEnd(currentTouch.identifier,touchPt)}}}))}}onDrawStart(touchId,touchPt,pressure){this.touches.set(touchId,touchPt);this.drawingProvider.drawTrailMark(touchPt.x,touchPt.y);this.drawingProvider.drawTrail(touchPt.x-1,touchPt.y,touchPt.x,touchPt.y,pressure)}onDraw(touchId,touchPt,pressure){const previousPt=this.touches.get(touchId);if(previousPt){this.drawingProvider.drawTrail(previousPt.x,previousPt.y,touchPt.x,touchPt.y,pressure)}this.touches.set(touchId,touchPt)}onDrawEnd(touchId,touchPt){this.drawingProvider.drawTrailMark(touchPt.x,touchPt.y);this.touches.delete(touchId)}onTabletModeChanged(isTabletMode){this.isTabletMode=isTabletMode}}customElements.define(TouchscreenTesterElement.is,TouchscreenTesterElement);