// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./data_point.js";import"./diagnostics_shared.css.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{loadTimeData}from"chrome://resources/ash/common/load_time_data.m.js";import{assertNotReached}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getSignalStrength}from"./diagnostics_utils.js";import{convertFrequencyToChannel}from"./frequency_channel_utils.js";import{SecurityType}from"./network_health_provider.mojom-webui.js";import{getTemplate}from"./wifi_info.html.js";const WifiInfoElementBase=I18nMixin(PolymerElement);export class WifiInfoElement extends WifiInfoElementBase{static get is(){return"wifi-info"}static get template(){return getTemplate()}static get properties(){return{network:{type:Object},security:{type:String,computed:"computeSecurity(network.typeProperties.wifi.security)"},signalStrength:{type:String,computed:"computeSignalStrength(network.typeProperties.wifi.signalStrength)"}}}getChannelDescription(frequency){if(!frequency||frequency===0){return""}const channel=convertFrequencyToChannel(frequency);const ghz=(frequency/1e3).toFixed(3);return`${channel||"?"} (${ghz} GHz)`}computeSecurity(){if(!this.network.typeProperties){return""}switch(this.network.typeProperties?.wifi?.security){case SecurityType.kNone:return loadTimeData.getString("networkSecurityNoneLabel");case SecurityType.kWep8021x:return loadTimeData.getString("networkSecurityWep8021xLabel");case SecurityType.kWepPsk:return loadTimeData.getString("networkSecurityWepPskLabel");case SecurityType.kWpaEap:return loadTimeData.getString("networkSecurityWpaEapLabel");case SecurityType.kWpaPsk:return loadTimeData.getString("networkSecurityWpaPskLabel")}assertNotReached()}computeSignalStrength(){if(this.network.typeProperties&&this.network.typeProperties.wifi){return getSignalStrength(this.network.typeProperties.wifi.signalStrength)}return""}}customElements.define(WifiInfoElement.is,WifiInfoElement);