import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="diagnostics-shared">.remove-stroke{--iron-icon-stroke-color:none}</style>
<diagnostics-card>
  <div id="cardTitle" slot="title" aria-describedby="batteryStatusChipInfo">
    [[i18n('batteryTitle')]]
  </div>
  <div id="batteryStatusChipInfo" slot="chip" class="diagnostics-chip"
      aria-hidden="true">
    [[getDesignedFullCharge(batteryHealth.chargeFullDesignMilliampHours)]]
  </div>
  <iron-icon slot="icon" icon="[[batteryIcon]]" class$="[[iconClass]]">
  </iron-icon>
  <percent-bar-chart slot="left-panel" header="[[powerTimeString]]"
      value="[[batteryChargeStatus.chargeNowMilliampHours]]"
      max="[[batteryHealth.chargeFullNowMilliampHours]]">
  </percent-bar-chart>
  <data-point slot="body" id="batteryHealth"
      header="[[i18n('batteryHealthLabel')]]"
      value="[[getBatteryHealth(batteryHealth.batteryWearPercentage)]]"
      tooltip-text="[[i18n('batteryHealthTooltipText')]]"
      class="data-point-margin-start">
  </data-point>
  <div slot="body" class="divider"></div>
  <data-point slot="body" id="cycleCount" header="[[i18n('cycleCount')]]"
      value="[[batteryHealth.cycleCount]]"
      tooltip-text="[[i18n('cycleCountTooltipText')]]">
  </data-point>
  <div slot="body" class="divider"></div>
  <data-point slot="body" id="currentNow" header="[[i18n('currentNowLabel')]]"
      value="[[getCurrentNow(batteryChargeStatus.currentNowMilliamps)]]"
      tooltip-text="[[i18n('currentNowTooltipText')]]"
      class="data-point-margin-end">
  </data-point>
  <routine-section slot="routines" routines="[[routines]]"
      routine-runtime="{{getEstimateRuntimeInMinutes(routines)}}"
      test-suite-status="{{testSuiteStatus}}"
      is-power-routine
      run-tests-button-text="[[getRunTestsButtonText(
        batteryChargeStatus.powerAdapterStatus
      )]]"
      additional-message="[[getRunTestsAdditionalMessage(
        batteryChargeStatus.chargeNowMilliampHours,
        batteryHealth.chargeFullNowMilliampHours)]]"
      learn-more-link-section="battery"
      is-active="[[isActive]]">
  </routine-section>
</diagnostics-card>
<!--_html_template_end_-->`;
}
