import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="diagnostics-shared"></style>
<diagnostics-card>
  <div id="cardTitle" slot="title" aria-describedby="cpuChipInfo">
    [[i18n('cpuTitle')]]
  </div>
  <div id="cpuChipInfo" slot="chip" class="diagnostics-chip" aria-hidden="true">
    [[cpuChipInfo]]
  </div>
  <iron-icon slot="icon" icon="diagnostics:cpu"></iron-icon>
  <realtime-cpu-chart slot="left-panel" id="realtimeCpuChart"
      user="[[cpuUsage.percentUsageUser]]"
      system="[[cpuUsage.percentUsageSystem]]">
  </realtime-cpu-chart>
  <data-point slot="body" id="cpuUsageUser"
      header="[[i18n('cpuUsageLabel')]]"
      value="[[getCurrentlyUsing(cpuUsage.percentUsageSystem,
        cpuUsage.percentUsageUser)]]"
      tooltip-text="[[getCpuUsageTooltipText()]]"
      class="data-point-margin-start">
  </data-point>
  <div slot="body" class="divider"></div>
  <data-point slot="body" id="cpuTemp" header="[[i18n('cpuTempLabel')]]"
      value="[[getCpuTemp(cpuUsage.averageCpuTempCelsius)]]">
  </data-point>
  <div slot="body" class="divider"></div>
  <data-point slot="body" id="cpuSpeed" class="data-point-margin-end"
      header="[[i18n('cpuSpeedLabel')]]"
      value="[[getCurrentCpuSpeed(cpuUsage.scalingCurrentFrequencyKhz)]]">
  </data-point>
  <routine-section slot="routines" routines="[[routines]]"
      routine-runtime="{{getEstimateRuntimeInMinutes(routines)}}"
      test-suite-status="{{testSuiteStatus}}"
      run-tests-button-text="[[i18n('runCpuTestText')]]"
      banner-message="[[i18n('cpuBannerMessage')]]"
      learn-more-link-section="cpu"
      is-active="[[isActive]]"
      hide-vertical-lines
      additional-message="[[getRunTestsAdditionalMessage(
      memoryUsage.availableMemoryKib)]]">
  </routine-section>
</diagnostics-card>
<!--_html_template_end_-->`;
}
