// ash/webui/diagnostics_ui/mojom/input_data_provider.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { ConnectionTypeSpec as ash_diagnostics_mojom_ConnectionTypeSpec, KeyboardInfoSpec as ash_diagnostics_mojom_KeyboardInfoSpec } from './input.mojom-webui.js';
export const KeyEventTypeSpec = { $: mojo.internal.Enum() };
export var KeyEventType;
(function (KeyEventType) {
    KeyEventType[KeyEventType["MIN_VALUE"] = 0] = "MIN_VALUE";
    KeyEventType[KeyEventType["MAX_VALUE"] = 1] = "MAX_VALUE";
    KeyEventType[KeyEventType["kPress"] = 0] = "kPress";
    KeyEventType[KeyEventType["kRelease"] = 1] = "kRelease";
})(KeyEventType || (KeyEventType = {}));
export const TouchDeviceTypeSpec = { $: mojo.internal.Enum() };
export var TouchDeviceType;
(function (TouchDeviceType) {
    TouchDeviceType[TouchDeviceType["MIN_VALUE"] = 0] = "MIN_VALUE";
    TouchDeviceType[TouchDeviceType["MAX_VALUE"] = 1] = "MAX_VALUE";
    TouchDeviceType[TouchDeviceType["kDirect"] = 0] = "kDirect";
    TouchDeviceType[TouchDeviceType["kPointer"] = 1] = "kPointer";
})(TouchDeviceType || (TouchDeviceType = {}));
export class KeyboardObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.diagnostics.mojom.KeyboardObserver', scope);
    }
}
export class KeyboardObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(KeyboardObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onKeyEvent(event) {
        this.proxy.sendMessage(0, KeyboardObserver_OnKeyEvent_ParamsSpec.$, null, [
            event
        ], false);
    }
    onKeyEventsPaused() {
        this.proxy.sendMessage(1, KeyboardObserver_OnKeyEventsPaused_ParamsSpec.$, null, [], false);
    }
    onKeyEventsResumed() {
        this.proxy.sendMessage(2, KeyboardObserver_OnKeyEventsResumed_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the KeyboardObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class KeyboardObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, KeyboardObserver_OnKeyEvent_ParamsSpec.$, null, impl.onKeyEvent.bind(impl), false);
        this.helper_internal_.registerHandler(1, KeyboardObserver_OnKeyEventsPaused_ParamsSpec.$, null, impl.onKeyEventsPaused.bind(impl), false);
        this.helper_internal_.registerHandler(2, KeyboardObserver_OnKeyEventsResumed_ParamsSpec.$, null, impl.onKeyEventsResumed.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class KeyboardObserver {
    static get $interfaceName() {
        return "ash.diagnostics.mojom.KeyboardObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new KeyboardObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the KeyboardObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class KeyboardObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onKeyEvent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, KeyboardObserver_OnKeyEvent_ParamsSpec.$, null, this.onKeyEvent.createReceiverHandler(false /* expectsResponse */), false);
        this.onKeyEventsPaused =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, KeyboardObserver_OnKeyEventsPaused_ParamsSpec.$, null, this.onKeyEventsPaused.createReceiverHandler(false /* expectsResponse */), false);
        this.onKeyEventsResumed =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, KeyboardObserver_OnKeyEventsResumed_ParamsSpec.$, null, this.onKeyEventsResumed.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class InternalDisplayPowerStateObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.diagnostics.mojom.InternalDisplayPowerStateObserver', scope);
    }
}
export class InternalDisplayPowerStateObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(InternalDisplayPowerStateObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onInternalDisplayPowerStateChanged(isDisplayOn) {
        this.proxy.sendMessage(0, InternalDisplayPowerStateObserver_OnInternalDisplayPowerStateChanged_ParamsSpec.$, null, [
            isDisplayOn
        ], false);
    }
}
;
/**
 * An object which receives request messages for the InternalDisplayPowerStateObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class InternalDisplayPowerStateObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(InternalDisplayPowerStateObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, InternalDisplayPowerStateObserver_OnInternalDisplayPowerStateChanged_ParamsSpec.$, null, impl.onInternalDisplayPowerStateChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class InternalDisplayPowerStateObserver {
    static get $interfaceName() {
        return "ash.diagnostics.mojom.InternalDisplayPowerStateObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new InternalDisplayPowerStateObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the InternalDisplayPowerStateObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class InternalDisplayPowerStateObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(InternalDisplayPowerStateObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onInternalDisplayPowerStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, InternalDisplayPowerStateObserver_OnInternalDisplayPowerStateChanged_ParamsSpec.$, null, this.onInternalDisplayPowerStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class TabletModeObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.diagnostics.mojom.TabletModeObserver', scope);
    }
}
export class TabletModeObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(TabletModeObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onTabletModeChanged(isTabletMode) {
        this.proxy.sendMessage(0, TabletModeObserver_OnTabletModeChanged_ParamsSpec.$, null, [
            isTabletMode
        ], false);
    }
}
;
/**
 * An object which receives request messages for the TabletModeObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TabletModeObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TabletModeObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, TabletModeObserver_OnTabletModeChanged_ParamsSpec.$, null, impl.onTabletModeChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class TabletModeObserver {
    static get $interfaceName() {
        return "ash.diagnostics.mojom.TabletModeObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new TabletModeObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the TabletModeObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TabletModeObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TabletModeObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onTabletModeChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, TabletModeObserver_OnTabletModeChanged_ParamsSpec.$, null, this.onTabletModeChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class LidStateObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.diagnostics.mojom.LidStateObserver', scope);
    }
}
export class LidStateObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(LidStateObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onLidStateChanged(isLidOpen) {
        this.proxy.sendMessage(0, LidStateObserver_OnLidStateChanged_ParamsSpec.$, null, [
            isLidOpen
        ], false);
    }
}
;
/**
 * An object which receives request messages for the LidStateObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class LidStateObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(LidStateObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, LidStateObserver_OnLidStateChanged_ParamsSpec.$, null, impl.onLidStateChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class LidStateObserver {
    static get $interfaceName() {
        return "ash.diagnostics.mojom.LidStateObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new LidStateObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the LidStateObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class LidStateObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(LidStateObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onLidStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, LidStateObserver_OnLidStateChanged_ParamsSpec.$, null, this.onLidStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class ConnectedDevicesObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.diagnostics.mojom.ConnectedDevicesObserver', scope);
    }
}
export class ConnectedDevicesObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ConnectedDevicesObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onKeyboardConnected(newKeyboard) {
        this.proxy.sendMessage(0, ConnectedDevicesObserver_OnKeyboardConnected_ParamsSpec.$, null, [
            newKeyboard
        ], false);
    }
    onKeyboardDisconnected(id) {
        this.proxy.sendMessage(1, ConnectedDevicesObserver_OnKeyboardDisconnected_ParamsSpec.$, null, [
            id
        ], false);
    }
    onTouchDeviceConnected(newTouchDevice) {
        this.proxy.sendMessage(2, ConnectedDevicesObserver_OnTouchDeviceConnected_ParamsSpec.$, null, [
            newTouchDevice
        ], false);
    }
    onTouchDeviceDisconnected(id) {
        this.proxy.sendMessage(3, ConnectedDevicesObserver_OnTouchDeviceDisconnected_ParamsSpec.$, null, [
            id
        ], false);
    }
}
;
/**
 * An object which receives request messages for the ConnectedDevicesObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ConnectedDevicesObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ConnectedDevicesObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ConnectedDevicesObserver_OnKeyboardConnected_ParamsSpec.$, null, impl.onKeyboardConnected.bind(impl), false);
        this.helper_internal_.registerHandler(1, ConnectedDevicesObserver_OnKeyboardDisconnected_ParamsSpec.$, null, impl.onKeyboardDisconnected.bind(impl), false);
        this.helper_internal_.registerHandler(2, ConnectedDevicesObserver_OnTouchDeviceConnected_ParamsSpec.$, null, impl.onTouchDeviceConnected.bind(impl), false);
        this.helper_internal_.registerHandler(3, ConnectedDevicesObserver_OnTouchDeviceDisconnected_ParamsSpec.$, null, impl.onTouchDeviceDisconnected.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class ConnectedDevicesObserver {
    static get $interfaceName() {
        return "ash.diagnostics.mojom.ConnectedDevicesObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ConnectedDevicesObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ConnectedDevicesObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ConnectedDevicesObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ConnectedDevicesObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onKeyboardConnected =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ConnectedDevicesObserver_OnKeyboardConnected_ParamsSpec.$, null, this.onKeyboardConnected.createReceiverHandler(false /* expectsResponse */), false);
        this.onKeyboardDisconnected =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ConnectedDevicesObserver_OnKeyboardDisconnected_ParamsSpec.$, null, this.onKeyboardDisconnected.createReceiverHandler(false /* expectsResponse */), false);
        this.onTouchDeviceConnected =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, ConnectedDevicesObserver_OnTouchDeviceConnected_ParamsSpec.$, null, this.onTouchDeviceConnected.createReceiverHandler(false /* expectsResponse */), false);
        this.onTouchDeviceDisconnected =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, ConnectedDevicesObserver_OnTouchDeviceDisconnected_ParamsSpec.$, null, this.onTouchDeviceDisconnected.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class InputDataProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.diagnostics.mojom.InputDataProvider', scope);
    }
}
export class InputDataProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(InputDataProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getConnectedDevices() {
        return this.proxy.sendMessage(0, InputDataProvider_GetConnectedDevices_ParamsSpec.$, InputDataProvider_GetConnectedDevices_ResponseParamsSpec.$, [], false);
    }
    observeConnectedDevices(observer) {
        this.proxy.sendMessage(1, InputDataProvider_ObserveConnectedDevices_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeKeyEvents(id, observer) {
        this.proxy.sendMessage(2, InputDataProvider_ObserveKeyEvents_ParamsSpec.$, null, [
            id,
            observer
        ], false);
    }
    observeTabletMode(observer) {
        return this.proxy.sendMessage(3, InputDataProvider_ObserveTabletMode_ParamsSpec.$, InputDataProvider_ObserveTabletMode_ResponseParamsSpec.$, [
            observer
        ], false);
    }
    observeLidState(observer) {
        return this.proxy.sendMessage(4, InputDataProvider_ObserveLidState_ParamsSpec.$, InputDataProvider_ObserveLidState_ResponseParamsSpec.$, [
            observer
        ], false);
    }
    observeInternalDisplayPowerState(observer) {
        this.proxy.sendMessage(5, InputDataProvider_ObserveInternalDisplayPowerState_ParamsSpec.$, null, [
            observer
        ], false);
    }
    moveAppToTestingScreen(evdevId) {
        this.proxy.sendMessage(6, InputDataProvider_MoveAppToTestingScreen_ParamsSpec.$, null, [
            evdevId
        ], false);
    }
    moveAppBackToPreviousScreen() {
        this.proxy.sendMessage(7, InputDataProvider_MoveAppBackToPreviousScreen_ParamsSpec.$, null, [], false);
    }
    setA11yTouchPassthrough(enabled) {
        this.proxy.sendMessage(8, InputDataProvider_SetA11yTouchPassthrough_ParamsSpec.$, null, [
            enabled
        ], false);
    }
}
;
/**
 * An object which receives request messages for the InputDataProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class InputDataProviderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(InputDataProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, InputDataProvider_GetConnectedDevices_ParamsSpec.$, InputDataProvider_GetConnectedDevices_ResponseParamsSpec.$, impl.getConnectedDevices.bind(impl), false);
        this.helper_internal_.registerHandler(1, InputDataProvider_ObserveConnectedDevices_ParamsSpec.$, null, impl.observeConnectedDevices.bind(impl), false);
        this.helper_internal_.registerHandler(2, InputDataProvider_ObserveKeyEvents_ParamsSpec.$, null, impl.observeKeyEvents.bind(impl), false);
        this.helper_internal_.registerHandler(3, InputDataProvider_ObserveTabletMode_ParamsSpec.$, InputDataProvider_ObserveTabletMode_ResponseParamsSpec.$, impl.observeTabletMode.bind(impl), false);
        this.helper_internal_.registerHandler(4, InputDataProvider_ObserveLidState_ParamsSpec.$, InputDataProvider_ObserveLidState_ResponseParamsSpec.$, impl.observeLidState.bind(impl), false);
        this.helper_internal_.registerHandler(5, InputDataProvider_ObserveInternalDisplayPowerState_ParamsSpec.$, null, impl.observeInternalDisplayPowerState.bind(impl), false);
        this.helper_internal_.registerHandler(6, InputDataProvider_MoveAppToTestingScreen_ParamsSpec.$, null, impl.moveAppToTestingScreen.bind(impl), false);
        this.helper_internal_.registerHandler(7, InputDataProvider_MoveAppBackToPreviousScreen_ParamsSpec.$, null, impl.moveAppBackToPreviousScreen.bind(impl), false);
        this.helper_internal_.registerHandler(8, InputDataProvider_SetA11yTouchPassthrough_ParamsSpec.$, null, impl.setA11yTouchPassthrough.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class InputDataProvider {
    static get $interfaceName() {
        return "ash.diagnostics.mojom.InputDataProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new InputDataProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the InputDataProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class InputDataProviderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(InputDataProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getConnectedDevices =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, InputDataProvider_GetConnectedDevices_ParamsSpec.$, InputDataProvider_GetConnectedDevices_ResponseParamsSpec.$, this.getConnectedDevices.createReceiverHandler(true /* expectsResponse */), false);
        this.observeConnectedDevices =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, InputDataProvider_ObserveConnectedDevices_ParamsSpec.$, null, this.observeConnectedDevices.createReceiverHandler(false /* expectsResponse */), false);
        this.observeKeyEvents =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, InputDataProvider_ObserveKeyEvents_ParamsSpec.$, null, this.observeKeyEvents.createReceiverHandler(false /* expectsResponse */), false);
        this.observeTabletMode =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, InputDataProvider_ObserveTabletMode_ParamsSpec.$, InputDataProvider_ObserveTabletMode_ResponseParamsSpec.$, this.observeTabletMode.createReceiverHandler(true /* expectsResponse */), false);
        this.observeLidState =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, InputDataProvider_ObserveLidState_ParamsSpec.$, InputDataProvider_ObserveLidState_ResponseParamsSpec.$, this.observeLidState.createReceiverHandler(true /* expectsResponse */), false);
        this.observeInternalDisplayPowerState =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, InputDataProvider_ObserveInternalDisplayPowerState_ParamsSpec.$, null, this.observeInternalDisplayPowerState.createReceiverHandler(false /* expectsResponse */), false);
        this.moveAppToTestingScreen =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, InputDataProvider_MoveAppToTestingScreen_ParamsSpec.$, null, this.moveAppToTestingScreen.createReceiverHandler(false /* expectsResponse */), false);
        this.moveAppBackToPreviousScreen =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, InputDataProvider_MoveAppBackToPreviousScreen_ParamsSpec.$, null, this.moveAppBackToPreviousScreen.createReceiverHandler(false /* expectsResponse */), false);
        this.setA11yTouchPassthrough =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, InputDataProvider_SetA11yTouchPassthrough_ParamsSpec.$, null, this.setA11yTouchPassthrough.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const KeyEventSpec = { $: {} };
export const TouchDeviceInfoSpec = { $: {} };
export const KeyboardObserver_OnKeyEvent_ParamsSpec = { $: {} };
export const KeyboardObserver_OnKeyEventsPaused_ParamsSpec = { $: {} };
export const KeyboardObserver_OnKeyEventsResumed_ParamsSpec = { $: {} };
export const InternalDisplayPowerStateObserver_OnInternalDisplayPowerStateChanged_ParamsSpec = { $: {} };
export const TabletModeObserver_OnTabletModeChanged_ParamsSpec = { $: {} };
export const LidStateObserver_OnLidStateChanged_ParamsSpec = { $: {} };
export const ConnectedDevicesObserver_OnKeyboardConnected_ParamsSpec = { $: {} };
export const ConnectedDevicesObserver_OnKeyboardDisconnected_ParamsSpec = { $: {} };
export const ConnectedDevicesObserver_OnTouchDeviceConnected_ParamsSpec = { $: {} };
export const ConnectedDevicesObserver_OnTouchDeviceDisconnected_ParamsSpec = { $: {} };
export const InputDataProvider_GetConnectedDevices_ParamsSpec = { $: {} };
export const InputDataProvider_GetConnectedDevices_ResponseParamsSpec = { $: {} };
export const InputDataProvider_ObserveConnectedDevices_ParamsSpec = { $: {} };
export const InputDataProvider_ObserveKeyEvents_ParamsSpec = { $: {} };
export const InputDataProvider_ObserveTabletMode_ParamsSpec = { $: {} };
export const InputDataProvider_ObserveTabletMode_ResponseParamsSpec = { $: {} };
export const InputDataProvider_ObserveLidState_ParamsSpec = { $: {} };
export const InputDataProvider_ObserveLidState_ResponseParamsSpec = { $: {} };
export const InputDataProvider_ObserveInternalDisplayPowerState_ParamsSpec = { $: {} };
export const InputDataProvider_MoveAppToTestingScreen_ParamsSpec = { $: {} };
export const InputDataProvider_MoveAppBackToPreviousScreen_ParamsSpec = { $: {} };
export const InputDataProvider_SetA11yTouchPassthrough_ParamsSpec = { $: {} };
mojo.internal.Struct(KeyEventSpec.$, 'KeyEvent', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('type', 4, 0, KeyEventTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('keyCode', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('scanCode', 12, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('topRowPosition', 16, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(TouchDeviceInfoSpec.$, 'TouchDeviceInfo', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('connectionType', 4, 0, ash_diagnostics_mojom_ConnectionTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('type', 8, 0, TouchDeviceTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('testable', 12, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(KeyboardObserver_OnKeyEvent_ParamsSpec.$, 'KeyboardObserver_OnKeyEvent_Params', [
    mojo.internal.StructField('event', 0, 0, KeyEventSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(KeyboardObserver_OnKeyEventsPaused_ParamsSpec.$, 'KeyboardObserver_OnKeyEventsPaused_Params', [], [[0, 8],]);
mojo.internal.Struct(KeyboardObserver_OnKeyEventsResumed_ParamsSpec.$, 'KeyboardObserver_OnKeyEventsResumed_Params', [], [[0, 8],]);
mojo.internal.Struct(InternalDisplayPowerStateObserver_OnInternalDisplayPowerStateChanged_ParamsSpec.$, 'InternalDisplayPowerStateObserver_OnInternalDisplayPowerStateChanged_Params', [
    mojo.internal.StructField('isDisplayOn', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TabletModeObserver_OnTabletModeChanged_ParamsSpec.$, 'TabletModeObserver_OnTabletModeChanged_Params', [
    mojo.internal.StructField('isTabletMode', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(LidStateObserver_OnLidStateChanged_ParamsSpec.$, 'LidStateObserver_OnLidStateChanged_Params', [
    mojo.internal.StructField('isLidOpen', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ConnectedDevicesObserver_OnKeyboardConnected_ParamsSpec.$, 'ConnectedDevicesObserver_OnKeyboardConnected_Params', [
    mojo.internal.StructField('newKeyboard', 0, 0, ash_diagnostics_mojom_KeyboardInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ConnectedDevicesObserver_OnKeyboardDisconnected_ParamsSpec.$, 'ConnectedDevicesObserver_OnKeyboardDisconnected_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ConnectedDevicesObserver_OnTouchDeviceConnected_ParamsSpec.$, 'ConnectedDevicesObserver_OnTouchDeviceConnected_Params', [
    mojo.internal.StructField('newTouchDevice', 0, 0, TouchDeviceInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ConnectedDevicesObserver_OnTouchDeviceDisconnected_ParamsSpec.$, 'ConnectedDevicesObserver_OnTouchDeviceDisconnected_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDataProvider_GetConnectedDevices_ParamsSpec.$, 'InputDataProvider_GetConnectedDevices_Params', [], [[0, 8],]);
mojo.internal.Struct(InputDataProvider_GetConnectedDevices_ResponseParamsSpec.$, 'InputDataProvider_GetConnectedDevices_ResponseParams', [
    mojo.internal.StructField('keyboards', 0, 0, mojo.internal.Array(ash_diagnostics_mojom_KeyboardInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('touchDevices', 8, 0, mojo.internal.Array(TouchDeviceInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(InputDataProvider_ObserveConnectedDevices_ParamsSpec.$, 'InputDataProvider_ObserveConnectedDevices_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(ConnectedDevicesObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDataProvider_ObserveKeyEvents_ParamsSpec.$, 'InputDataProvider_ObserveKeyEvents_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('observer', 4, 0, mojo.internal.InterfaceProxy(KeyboardObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(InputDataProvider_ObserveTabletMode_ParamsSpec.$, 'InputDataProvider_ObserveTabletMode_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(TabletModeObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDataProvider_ObserveTabletMode_ResponseParamsSpec.$, 'InputDataProvider_ObserveTabletMode_ResponseParams', [
    mojo.internal.StructField('isTabletMode', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDataProvider_ObserveLidState_ParamsSpec.$, 'InputDataProvider_ObserveLidState_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(LidStateObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDataProvider_ObserveLidState_ResponseParamsSpec.$, 'InputDataProvider_ObserveLidState_ResponseParams', [
    mojo.internal.StructField('isLidOpen', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDataProvider_ObserveInternalDisplayPowerState_ParamsSpec.$, 'InputDataProvider_ObserveInternalDisplayPowerState_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(InternalDisplayPowerStateObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDataProvider_MoveAppToTestingScreen_ParamsSpec.$, 'InputDataProvider_MoveAppToTestingScreen_Params', [
    mojo.internal.StructField('evdevId', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(InputDataProvider_MoveAppBackToPreviousScreen_ParamsSpec.$, 'InputDataProvider_MoveAppBackToPreviousScreen_Params', [], [[0, 8],]);
mojo.internal.Struct(InputDataProvider_SetA11yTouchPassthrough_ParamsSpec.$, 'InputDataProvider_SetA11yTouchPassthrough_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
