// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { assert } from 'chrome://resources/js/assert.js';
import { InputDataProvider } from './input_data_provider.mojom-webui.js';
import { NetworkHealthProvider } from './network_health_provider.mojom-webui.js';
import { SystemDataProvider } from './system_data_provider.mojom-webui.js';
import { SystemRoutineController } from './system_routine_controller.mojom-webui.js';
/**
 * @fileoverview
 * Provides singleton access to mojo interfaces with the ability
 * to override them with test/fake implementations.
 */
/**
 * These variables are bound to real mojo services when running
 * in a live environment and set to fake services when testing.
 */
let systemDataProvider = null;
let systemRoutineController = null;
let networkHealthProvider = null;
let inputDataProvider = null;
export function setSystemDataProviderForTesting(testProvider) {
    systemDataProvider = testProvider;
}
export function getSystemDataProvider() {
    if (!systemDataProvider) {
        systemDataProvider = SystemDataProvider.getRemote();
    }
    assert(!!systemDataProvider);
    return systemDataProvider;
}
export function setSystemRoutineControllerForTesting(testController) {
    systemRoutineController = testController;
}
export function getSystemRoutineController() {
    if (!systemRoutineController) {
        systemRoutineController = SystemRoutineController.getRemote();
    }
    assert(!!systemRoutineController);
    return systemRoutineController;
}
export function setNetworkHealthProviderForTesting(testProvider) {
    networkHealthProvider = testProvider;
}
export function getNetworkHealthProvider() {
    if (!networkHealthProvider) {
        networkHealthProvider = NetworkHealthProvider.getRemote();
    }
    assert(!!networkHealthProvider);
    return networkHealthProvider;
}
export function setInputDataProviderForTesting(testProvider) {
    inputDataProvider = testProvider;
}
export function getInputDataProvider() {
    if (!inputDataProvider) {
        inputDataProvider = InputDataProvider.getRemote();
    }
    assert(!!inputDataProvider);
    return inputDataProvider;
}
