import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="diagnostics-shared">.animation-1{animation:1s fadeInLine1;animation-fill-mode:forwards;visibility:hidden}.animation-2{animation:1s fadeInLine2;animation-delay:100ms;animation-fill-mode:forwards;visibility:hidden}.animation-3{animation:1s fadeInLine3;animation-delay:200ms;animation-fill-mode:forwards;visibility:hidden}.badge-container{align-items:flex-start;display:flex;flex-direction:column;width:auto}.entry-row{align-items:center;column-gap:16px;display:grid;grid-template-columns:minmax(56px,auto) 1fr;height:40px}.line{height:5px;margin:2px 16px}.line-container{margin-top:17px;position:absolute}.green{border-inline-start:1px dashed var(--cros-color-positive)}.red{border-inline-start:1px dashed var(--cros-color-alert);position:relative}.yellow{border-inline-start:1px dashed var(--cros-color-warning)}#routine{align-items:center;color:var(--cros-text-color-primary);display:inline-flex;font-family:var(--diagnostics-roboto-font-family);font-size:13px;font-weight:var(--diagnostics-regular-font-weight)}.failed-test-text-container{margin-inline-start:8px}#status{z-index:1}#failed-test-text{color:var(--cros-text-color-secondary);margin-inline-start:12px}@keyframes fadeInLine1{0%{opacity:0}100%{opacity:1;visibility:visible}}@keyframes fadeInLine2{0%{opacity:0}100%{opacity:1;visibility:visible}}@keyframes fadeInLine3{0%{opacity:0}100%{opacity:1;visibility:visible}}</style>
<div class="entry-row">
  <div class="badge-container">
    <text-badge id="status" badge-type="[[badgeType]]" value="[[badgeText]]"
        aria-labelledby="routine">
    </text-badge>
  <template is="dom-if" if="[[!shouldHideLines(testCompleted)]]">
    <div class="line-container" id="lineContainer"
        hidden$="[[hideVerticalLines]]">
      <div class$="[[getLineClassName(1, badgeType)]]"></div>
      <div class$="[[getLineClassName(2, badgeType)]]"></div>
      <div class$="[[getLineClassName(3, badgeType)]]"></div>
    </div>
  </template>
 </div>
  <div id="routine" aria-hidden="true">
    <span tabindex="0">[[routineType]]</span>
    <span id="failed-test-text" class="failed-test-text-container"
        hidden$="[[!item.failedTest]]"
        tabindex="0">
      [[computeFailedTestText(item.failedTest)]]
    </span>
  </div>
</div>
<!--_html_template_end_-->`;
}
