import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="diagnostics-shared">:host-context(body.jelly-enabled) #additionalMessage{font:var(--cros-body-2-font)}:host-context(body.jelly-enabled) #testStatusText{font:var(--cros-body-2-font)}#additionalMessage{color:var(--cros-text-color-primary);font-family:var(--diagnostics-roboto-font-family);font-size:13px;font-weight:var(--diagnostics-regular-font-weight)}.button-container{padding:8px 0 4px}.learn-more-button{border-radius:4px;height:32px;margin-top:12px;padding:8px 16px}:host-context(body.jelly-enabled) .button-container,:host-context(body.jelly-enabled) .learn-more-button{font:var(--cros-button-2-font)}.button-container,.learn-more-button{font-family:var(--diagnostics-roboto-font-family);font-size:13px;font-weight:var(--diagnostics-medium-font-weight)}#messageIcon{--iron-icon-height:20px;--iron-icon-width:20px;fill:var(--cros-icon-color-secondary);margin-inline-end:8px}.result-list{margin:20px 0}.routine-container{display:flex;justify-content:space-between}.routine-section-container{display:flex;flex-direction:column}.routine-status-container{display:flex;flex-direction:column}#testStatusBadge{margin-bottom:4px}#testStatusText{color:var(--cros-text-color-secondary);font-family:var(--diagnostics-roboto-font-family);font-size:13px;font-weight:var(--diagnostics-regular-font-weight);padding-inline-start:6px}#toggleReportButton{margin-inline-end:8px}:host([hide-routine-status]) .container-spacing{padding-inline:20px}:host(:not([hide-routine-status])) .container-spacing{margin-bottom:16px;margin-top:12px;padding-inline:20px}</style>
<div class="routine-section-container container-spacing"
    hidden$="[[hideRoutineSection(routines.*)]]">
  <div id="routineSection" class="routine-container">
    <div class="routine-status-container" hidden$="[[hideRoutineStatus]]">
      <text-badge id="testStatusBadge" badge-type="[[badgeType]]"
          hidden="[[isStatusHidden(executionStatus)]]"
          value="[[badgeText]]">
      </text-badge>
      <span id="testStatusText"
          hidden$="[[isStatusHidden(executionStatus)]]">
        [[statusText]]
        <span id="learnMoreText" class="link-text"
            hidden$="[[isLearnMoreHidden(executionStatus)]]"
            on-click="onLearnMoreClicked">
          [[i18n('learnMoreShort')]]
        </span>
      </span>
    </div>
    <div class="button-container" hidden$="[[hideRoutineStatus]]">
        <iron-icon id="messageIcon" icon="diagnostics:info"
            hidden$="[[isAdditionalMessageHidden(additionalMessage)]]">
        </iron-icon>
        <paper-tooltip for="messageIcon" aria-hidden="true" id="additionalMessage">
          [[additionalMessage]]
        </paper-tooltip>
      <cr-button id="toggleReportButton" on-click="onToggleReportClicked"
          hidden="[[isResultButtonHidden(executionStatus, routines.*)]]">
        [[getReportToggleButtonText(opened)]]
      </cr-button>
      <cr-button id="runTestsButton"
          hidden$="[[isRunTestsButtonHidden(testSuiteStatus,
              executionStatus)]]"
          on-click="runTests"
          disabled="[[isRunTestsButtonDisabled(testSuiteStatus,
                                                additionalMessage)]]">
        [[runTestsButtonText]]
      </cr-button>
      <cr-button id="stopTestsButton"
          hidden$="[[isStopTestsButtonHidden(executionStatus)]]"
          on-click="stopTests">
        [[i18n('stopTestButtonText')]]
      </cr-button>
    </div>
  </div>
  <iron-collapse id="collapse" opened="{{opened}}">
    <div class="result-list">
      <routine-result-list id="resultList"
          hide-vertical-lines="[[hideVerticalLines]]"
          using-routine-groups="[[usingRoutineGroups]]">
      </routine-result-list>
    </div>
    <cr-button id="learnMoreButton" class="learn-more-button"
        on-click="onLearnMoreClicked"
        hidden$="[[isLearnMoreButtonHidden(isLoggedIn, hideRoutineStatus)]]">
      [[i18n('learnMore')]]
    </cr-button>
  </iron-collapse>
</div>
<!--_html_template_end_-->`;
}
