// ash/webui/diagnostics_ui/mojom/system_data_provider.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { String16Spec as mojoBase_mojom_String16Spec } from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
export const ExternalPowerSourceSpec = { $: mojo.internal.Enum() };
export var ExternalPowerSource;
(function (ExternalPowerSource) {
    ExternalPowerSource[ExternalPowerSource["MIN_VALUE"] = 0] = "MIN_VALUE";
    ExternalPowerSource[ExternalPowerSource["MAX_VALUE"] = 2] = "MAX_VALUE";
    ExternalPowerSource[ExternalPowerSource["kAc"] = 0] = "kAc";
    ExternalPowerSource[ExternalPowerSource["kUsb"] = 1] = "kUsb";
    ExternalPowerSource[ExternalPowerSource["kDisconnected"] = 2] = "kDisconnected";
})(ExternalPowerSource || (ExternalPowerSource = {}));
export const BatteryStateSpec = { $: mojo.internal.Enum() };
export var BatteryState;
(function (BatteryState) {
    BatteryState[BatteryState["MIN_VALUE"] = 0] = "MIN_VALUE";
    BatteryState[BatteryState["MAX_VALUE"] = 2] = "MAX_VALUE";
    BatteryState[BatteryState["kCharging"] = 0] = "kCharging";
    BatteryState[BatteryState["kDischarging"] = 1] = "kDischarging";
    BatteryState[BatteryState["kFull"] = 2] = "kFull";
})(BatteryState || (BatteryState = {}));
export class BatteryChargeStatusObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.diagnostics.mojom.BatteryChargeStatusObserver', scope);
    }
}
export class BatteryChargeStatusObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(BatteryChargeStatusObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onBatteryChargeStatusUpdated(batteryChargeStatus) {
        this.proxy.sendMessage(0, BatteryChargeStatusObserver_OnBatteryChargeStatusUpdated_ParamsSpec.$, null, [
            batteryChargeStatus
        ], false);
    }
}
;
/**
 * An object which receives request messages for the BatteryChargeStatusObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BatteryChargeStatusObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(BatteryChargeStatusObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, BatteryChargeStatusObserver_OnBatteryChargeStatusUpdated_ParamsSpec.$, null, impl.onBatteryChargeStatusUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class BatteryChargeStatusObserver {
    static get $interfaceName() {
        return "ash.diagnostics.mojom.BatteryChargeStatusObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new BatteryChargeStatusObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the BatteryChargeStatusObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BatteryChargeStatusObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(BatteryChargeStatusObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onBatteryChargeStatusUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, BatteryChargeStatusObserver_OnBatteryChargeStatusUpdated_ParamsSpec.$, null, this.onBatteryChargeStatusUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class BatteryHealthObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.diagnostics.mojom.BatteryHealthObserver', scope);
    }
}
export class BatteryHealthObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(BatteryHealthObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onBatteryHealthUpdated(batteryHealth) {
        this.proxy.sendMessage(0, BatteryHealthObserver_OnBatteryHealthUpdated_ParamsSpec.$, null, [
            batteryHealth
        ], false);
    }
}
;
/**
 * An object which receives request messages for the BatteryHealthObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class BatteryHealthObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(BatteryHealthObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, BatteryHealthObserver_OnBatteryHealthUpdated_ParamsSpec.$, null, impl.onBatteryHealthUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class BatteryHealthObserver {
    static get $interfaceName() {
        return "ash.diagnostics.mojom.BatteryHealthObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new BatteryHealthObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the BatteryHealthObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class BatteryHealthObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(BatteryHealthObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onBatteryHealthUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, BatteryHealthObserver_OnBatteryHealthUpdated_ParamsSpec.$, null, this.onBatteryHealthUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class MemoryUsageObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.diagnostics.mojom.MemoryUsageObserver', scope);
    }
}
export class MemoryUsageObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(MemoryUsageObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onMemoryUsageUpdated(memoryUsage) {
        this.proxy.sendMessage(0, MemoryUsageObserver_OnMemoryUsageUpdated_ParamsSpec.$, null, [
            memoryUsage
        ], false);
    }
}
;
/**
 * An object which receives request messages for the MemoryUsageObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MemoryUsageObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MemoryUsageObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, MemoryUsageObserver_OnMemoryUsageUpdated_ParamsSpec.$, null, impl.onMemoryUsageUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class MemoryUsageObserver {
    static get $interfaceName() {
        return "ash.diagnostics.mojom.MemoryUsageObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new MemoryUsageObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the MemoryUsageObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MemoryUsageObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MemoryUsageObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onMemoryUsageUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, MemoryUsageObserver_OnMemoryUsageUpdated_ParamsSpec.$, null, this.onMemoryUsageUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class CpuUsageObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.diagnostics.mojom.CpuUsageObserver', scope);
    }
}
export class CpuUsageObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(CpuUsageObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onCpuUsageUpdated(cpuUsage) {
        this.proxy.sendMessage(0, CpuUsageObserver_OnCpuUsageUpdated_ParamsSpec.$, null, [
            cpuUsage
        ], false);
    }
}
;
/**
 * An object which receives request messages for the CpuUsageObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CpuUsageObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CpuUsageObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, CpuUsageObserver_OnCpuUsageUpdated_ParamsSpec.$, null, impl.onCpuUsageUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class CpuUsageObserver {
    static get $interfaceName() {
        return "ash.diagnostics.mojom.CpuUsageObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new CpuUsageObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the CpuUsageObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CpuUsageObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(CpuUsageObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onCpuUsageUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, CpuUsageObserver_OnCpuUsageUpdated_ParamsSpec.$, null, this.onCpuUsageUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class SystemDataProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.diagnostics.mojom.SystemDataProvider', scope);
    }
}
export class SystemDataProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(SystemDataProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getSystemInfo() {
        return this.proxy.sendMessage(0, SystemDataProvider_GetSystemInfo_ParamsSpec.$, SystemDataProvider_GetSystemInfo_ResponseParamsSpec.$, [], false);
    }
    getBatteryInfo() {
        return this.proxy.sendMessage(1, SystemDataProvider_GetBatteryInfo_ParamsSpec.$, SystemDataProvider_GetBatteryInfo_ResponseParamsSpec.$, [], false);
    }
    observeBatteryChargeStatus(observer) {
        this.proxy.sendMessage(2, SystemDataProvider_ObserveBatteryChargeStatus_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeBatteryHealth(observer) {
        this.proxy.sendMessage(3, SystemDataProvider_ObserveBatteryHealth_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeMemoryUsage(observer) {
        this.proxy.sendMessage(4, SystemDataProvider_ObserveMemoryUsage_ParamsSpec.$, null, [
            observer
        ], false);
    }
    observeCpuUsage(observer) {
        this.proxy.sendMessage(5, SystemDataProvider_ObserveCpuUsage_ParamsSpec.$, null, [
            observer
        ], false);
    }
}
;
/**
 * An object which receives request messages for the SystemDataProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SystemDataProviderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SystemDataProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, SystemDataProvider_GetSystemInfo_ParamsSpec.$, SystemDataProvider_GetSystemInfo_ResponseParamsSpec.$, impl.getSystemInfo.bind(impl), false);
        this.helper_internal_.registerHandler(1, SystemDataProvider_GetBatteryInfo_ParamsSpec.$, SystemDataProvider_GetBatteryInfo_ResponseParamsSpec.$, impl.getBatteryInfo.bind(impl), false);
        this.helper_internal_.registerHandler(2, SystemDataProvider_ObserveBatteryChargeStatus_ParamsSpec.$, null, impl.observeBatteryChargeStatus.bind(impl), false);
        this.helper_internal_.registerHandler(3, SystemDataProvider_ObserveBatteryHealth_ParamsSpec.$, null, impl.observeBatteryHealth.bind(impl), false);
        this.helper_internal_.registerHandler(4, SystemDataProvider_ObserveMemoryUsage_ParamsSpec.$, null, impl.observeMemoryUsage.bind(impl), false);
        this.helper_internal_.registerHandler(5, SystemDataProvider_ObserveCpuUsage_ParamsSpec.$, null, impl.observeCpuUsage.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class SystemDataProvider {
    static get $interfaceName() {
        return "ash.diagnostics.mojom.SystemDataProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new SystemDataProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the SystemDataProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SystemDataProviderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SystemDataProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getSystemInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, SystemDataProvider_GetSystemInfo_ParamsSpec.$, SystemDataProvider_GetSystemInfo_ResponseParamsSpec.$, this.getSystemInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.getBatteryInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, SystemDataProvider_GetBatteryInfo_ParamsSpec.$, SystemDataProvider_GetBatteryInfo_ResponseParamsSpec.$, this.getBatteryInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.observeBatteryChargeStatus =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, SystemDataProvider_ObserveBatteryChargeStatus_ParamsSpec.$, null, this.observeBatteryChargeStatus.createReceiverHandler(false /* expectsResponse */), false);
        this.observeBatteryHealth =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, SystemDataProvider_ObserveBatteryHealth_ParamsSpec.$, null, this.observeBatteryHealth.createReceiverHandler(false /* expectsResponse */), false);
        this.observeMemoryUsage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, SystemDataProvider_ObserveMemoryUsage_ParamsSpec.$, null, this.observeMemoryUsage.createReceiverHandler(false /* expectsResponse */), false);
        this.observeCpuUsage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, SystemDataProvider_ObserveCpuUsage_ParamsSpec.$, null, this.observeCpuUsage.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const DeviceCapabilitiesSpec = { $: {} };
export const VersionInfoSpec = { $: {} };
export const SystemInfoSpec = { $: {} };
export const BatteryInfoSpec = { $: {} };
export const BatteryChargeStatusSpec = { $: {} };
export const BatteryHealthSpec = { $: {} };
export const MemoryUsageSpec = { $: {} };
export const CpuUsageSpec = { $: {} };
export const BatteryChargeStatusObserver_OnBatteryChargeStatusUpdated_ParamsSpec = { $: {} };
export const BatteryHealthObserver_OnBatteryHealthUpdated_ParamsSpec = { $: {} };
export const MemoryUsageObserver_OnMemoryUsageUpdated_ParamsSpec = { $: {} };
export const CpuUsageObserver_OnCpuUsageUpdated_ParamsSpec = { $: {} };
export const SystemDataProvider_GetSystemInfo_ParamsSpec = { $: {} };
export const SystemDataProvider_GetSystemInfo_ResponseParamsSpec = { $: {} };
export const SystemDataProvider_GetBatteryInfo_ParamsSpec = { $: {} };
export const SystemDataProvider_GetBatteryInfo_ResponseParamsSpec = { $: {} };
export const SystemDataProvider_ObserveBatteryChargeStatus_ParamsSpec = { $: {} };
export const SystemDataProvider_ObserveBatteryHealth_ParamsSpec = { $: {} };
export const SystemDataProvider_ObserveMemoryUsage_ParamsSpec = { $: {} };
export const SystemDataProvider_ObserveCpuUsage_ParamsSpec = { $: {} };
mojo.internal.Struct(DeviceCapabilitiesSpec.$, 'DeviceCapabilities', [
    mojo.internal.StructField('hasBattery', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(VersionInfoSpec.$, 'VersionInfo', [
    mojo.internal.StructField('milestoneVersion', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('fullVersionString', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(SystemInfoSpec.$, 'SystemInfo', [
    mojo.internal.StructField('boardName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('marketingName', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('cpuModelName', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('totalMemoryKib', 24, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('cpuThreadsCount', 28, 0, mojo.internal.Uint16, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('cpuMaxClockSpeedKhz', 32, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('versionInfo', 40, 0, VersionInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('deviceCapabilities', 48, 0, DeviceCapabilitiesSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 64],]);
mojo.internal.Struct(BatteryInfoSpec.$, 'BatteryInfo', [
    mojo.internal.StructField('manufacturer', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('chargeFullDesignMilliampHours', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(BatteryChargeStatusSpec.$, 'BatteryChargeStatus', [
    mojo.internal.StructField('powerTime', 0, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('currentNowMilliamps', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('chargeNowMilliampHours', 12, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('batteryState', 16, 0, BatteryStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('powerAdapterStatus', 20, 0, ExternalPowerSourceSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(BatteryHealthSpec.$, 'BatteryHealth', [
    mojo.internal.StructField('chargeFullNowMilliampHours', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('chargeFullDesignMilliampHours', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('cycleCount', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('batteryWearPercentage', 12, 0, mojo.internal.Int8, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(MemoryUsageSpec.$, 'MemoryUsage', [
    mojo.internal.StructField('totalMemoryKib', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('availableMemoryKib', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('freeMemoryKib', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CpuUsageSpec.$, 'CpuUsage', [
    mojo.internal.StructField('percentUsageUser', 0, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('percentUsageSystem', 1, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('percentUsageFree', 2, 0, mojo.internal.Uint8, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('averageCpuTempCelsius', 4, 0, mojo.internal.Uint16, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('scalingCurrentFrequencyKhz', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(BatteryChargeStatusObserver_OnBatteryChargeStatusUpdated_ParamsSpec.$, 'BatteryChargeStatusObserver_OnBatteryChargeStatusUpdated_Params', [
    mojo.internal.StructField('batteryChargeStatus', 0, 0, BatteryChargeStatusSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(BatteryHealthObserver_OnBatteryHealthUpdated_ParamsSpec.$, 'BatteryHealthObserver_OnBatteryHealthUpdated_Params', [
    mojo.internal.StructField('batteryHealth', 0, 0, BatteryHealthSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MemoryUsageObserver_OnMemoryUsageUpdated_ParamsSpec.$, 'MemoryUsageObserver_OnMemoryUsageUpdated_Params', [
    mojo.internal.StructField('memoryUsage', 0, 0, MemoryUsageSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(CpuUsageObserver_OnCpuUsageUpdated_ParamsSpec.$, 'CpuUsageObserver_OnCpuUsageUpdated_Params', [
    mojo.internal.StructField('cpuUsage', 0, 0, CpuUsageSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SystemDataProvider_GetSystemInfo_ParamsSpec.$, 'SystemDataProvider_GetSystemInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(SystemDataProvider_GetSystemInfo_ResponseParamsSpec.$, 'SystemDataProvider_GetSystemInfo_ResponseParams', [
    mojo.internal.StructField('systemInfo', 0, 0, SystemInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SystemDataProvider_GetBatteryInfo_ParamsSpec.$, 'SystemDataProvider_GetBatteryInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(SystemDataProvider_GetBatteryInfo_ResponseParamsSpec.$, 'SystemDataProvider_GetBatteryInfo_ResponseParams', [
    mojo.internal.StructField('batteryInfo', 0, 0, BatteryInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SystemDataProvider_ObserveBatteryChargeStatus_ParamsSpec.$, 'SystemDataProvider_ObserveBatteryChargeStatus_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(BatteryChargeStatusObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SystemDataProvider_ObserveBatteryHealth_ParamsSpec.$, 'SystemDataProvider_ObserveBatteryHealth_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(BatteryHealthObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SystemDataProvider_ObserveMemoryUsage_ParamsSpec.$, 'SystemDataProvider_ObserveMemoryUsage_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(MemoryUsageObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SystemDataProvider_ObserveCpuUsage_ParamsSpec.$, 'SystemDataProvider_ObserveCpuUsage_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(CpuUsageObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
