import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style diagnostics-shared">:host-context(body.jelly-enabled) #header{font:var(--cros-title-1-font)}#diagnosticsContainer{align-items:center;box-sizing:border-box;display:flex;flex-direction:column;height:inherit;position:relative}#download-icon{--iron-icon-fill-color:currentColor;--iron-icon-height:20px;--iron-icon-width:20px;right:4px}#header{align-self:flex-start;color:var(--cros-text-color-primary);font-family:var(--diagnostics-roboto-font-family);font-size:16px;font-weight:var(--diagnostics-medium-font-weight);margin-bottom:10px;margin-inline-start:22px}.overview-container{margin-bottom:10px}.session-log-container{display:flex;justify-content:center;margin:20px 0}#toast{bottom:0;left:0}</style>
<div id="diagnosticsContainer" hidden="[[!systemInfoReceived]]">
  <div class="overview-container">
    <overview-card id="overviewCard"></overview-card>
  </div>
  <div class$="diagnostics-cards-container-nav">
    <template is="dom-if" if="[[showBatteryStatusCard]]" restamp>
      <div class="card-width">
        <battery-status-card id="batteryStatusCard"
            test-suite-status="{{testSuiteStatus}}"
            is-active="[[isActive]]">
        </battery-status-card>
      </div>
    </template>
    <div class="card-width">
      <cpu-card id="cpuCard"
          test-suite-status="{{testSuiteStatus}}"
          is-active="[[isActive]]">
      </cpu-card>
    </div>
    <div class="card-width">
      <memory-card id="memoryCard"
          test-suite-status="{{testSuiteStatus}}"
          is-active="[[isActive]]">
      </memory-card>
    </div>
  </div>
  <cr-toast id="toast" duration="2500">
    <span>[[toastText]]</span>
  </cr-toast>
</div>
<!--_html_template_end_-->`;
}
