// ash/webui/eche_app_ui/mojom/eche_app.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('ash.echeApp.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.echeApp.mojom.ScreenBacklightStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.echeApp.mojom.ScreenBacklightState = {
  
  ON: 0,
  OFF: 1,
  OFF_AUTO: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.echeApp.mojom.WebNotificationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.echeApp.mojom.WebNotificationType = {
  
  APP_CRAHSED: 0,
  AUTHORIZATION_NEEDED: 1,
  CONNECTION_FAILED: 2,
  CONNECTION_LOST: 3,
  DEVICE_IDLE: 4,
  INITIALIZATION_ERROR: 5,
  INVALID_NOTIFICATION: 6,
  NOTIFICATION_ACTION_NOT_LAUNCHED: 7,
  LAUNCH_NOTIFICATION_FAILED: 8,
  TABLET_MODE: 9,
  WIFI_NOT_READY: 10,
  DIFFERENT_WIFI_NETWORKS: 11,
  REMOTE_DEVICE_ON_CELLULAR: 12,
  MIN_VALUE: 0,
  MAX_VALUE: 12,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.echeApp.mojom.StreamStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.echeApp.mojom.StreamStatus = {
  
  kStreamStatusUnknown: 0,
  kStreamStatusInitializing: 1,
  kStreamStatusStarted: 2,
  kStreamStatusStopped: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.echeApp.mojom.StreamActionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.echeApp.mojom.StreamAction = {
  
  kStreamActionClose: 0,
  kStreamActionGoBack: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.echeApp.mojom.ConnectionStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.echeApp.mojom.ConnectionStatus = {
  
  kConnectionStatusDisconnected: 0,
  kConnectionStatusConnecting: 1,
  kConnectionStatusConnected: 2,
  kConnectionStatusFailed: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
ash.echeApp.mojom.AppStreamLaunchEntryPointSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
ash.echeApp.mojom.AppStreamLaunchEntryPoint = {
  
  APPS_LIST: 0,
  NOTIFICATION: 1,
  RECENT_APPS: 2,
  UNKNOWN: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.echeApp.mojom.SignalingMessageExchangerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.echeApp.mojom.SignalingMessageExchanger.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.echeApp.mojom.SignalingMessageExchangerInterface }
 */
ash.echeApp.mojom.SignalingMessageExchangerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.echeApp.mojom.SignalingMessageExchangerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.echeApp.mojom.SignalingMessageExchangerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.echeApp.mojom.SignalingMessageExchangerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!number> } signal
   */

  sendSignalingMessage(
      signal) {
    this.proxy.sendMessage(
        0,
        ash.echeApp.mojom.SignalingMessageExchanger_SendSignalingMessage_ParamsSpec.$,
        null,
        [
          signal
        ],
        false);
  }

  
  /**
   * @param { !ash.echeApp.mojom.SignalingMessageObserverRemote } observer
   */

  setSignalingMessageObserver(
      observer) {
    this.proxy.sendMessage(
        1,
        ash.echeApp.mojom.SignalingMessageExchanger_SetSignalingMessageObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   */

  tearDownSignaling() {
    this.proxy.sendMessage(
        2,
        ash.echeApp.mojom.SignalingMessageExchanger_TearDownSignaling_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SignalingMessageExchanger
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.echeApp.mojom.SignalingMessageExchangerReceiver = class {
  /**
   * @param {!ash.echeApp.mojom.SignalingMessageExchangerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.echeApp.mojom.SignalingMessageExchangerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.echeApp.mojom.SignalingMessageExchangerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.SignalingMessageExchangerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.SignalingMessageExchanger_SendSignalingMessage_ParamsSpec.$,
        null,
        impl.sendSignalingMessage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.echeApp.mojom.SignalingMessageExchanger_SetSignalingMessageObserver_ParamsSpec.$,
        null,
        impl.setSignalingMessageObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ash.echeApp.mojom.SignalingMessageExchanger_TearDownSignaling_ParamsSpec.$,
        null,
        impl.tearDownSignaling.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.echeApp.mojom.SignalingMessageExchanger = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.SignalingMessageExchanger";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.echeApp.mojom.SignalingMessageExchangerRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.echeApp.mojom.SignalingMessageExchangerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SignalingMessageExchanger
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.echeApp.mojom.SignalingMessageExchangerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.echeApp.mojom.SignalingMessageExchangerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.SignalingMessageExchangerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendSignalingMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.SignalingMessageExchanger_SendSignalingMessage_ParamsSpec.$,
        null,
        this.sendSignalingMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSignalingMessageObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.echeApp.mojom.SignalingMessageExchanger_SetSignalingMessageObserver_ParamsSpec.$,
        null,
        this.setSignalingMessageObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.tearDownSignaling =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ash.echeApp.mojom.SignalingMessageExchanger_TearDownSignaling_ParamsSpec.$,
        null,
        this.tearDownSignaling.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.echeApp.mojom.SignalingMessageObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.echeApp.mojom.SignalingMessageObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.echeApp.mojom.SignalingMessageObserverInterface }
 */
ash.echeApp.mojom.SignalingMessageObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.echeApp.mojom.SignalingMessageObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.echeApp.mojom.SignalingMessageObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.echeApp.mojom.SignalingMessageObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!number> } signal
   */

  onReceivedSignalingMessage(
      signal) {
    this.proxy.sendMessage(
        0,
        ash.echeApp.mojom.SignalingMessageObserver_OnReceivedSignalingMessage_ParamsSpec.$,
        null,
        [
          signal
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SignalingMessageObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.echeApp.mojom.SignalingMessageObserverReceiver = class {
  /**
   * @param {!ash.echeApp.mojom.SignalingMessageObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.echeApp.mojom.SignalingMessageObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.echeApp.mojom.SignalingMessageObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.SignalingMessageObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.SignalingMessageObserver_OnReceivedSignalingMessage_ParamsSpec.$,
        null,
        impl.onReceivedSignalingMessage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.echeApp.mojom.SignalingMessageObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.SignalingMessageObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.echeApp.mojom.SignalingMessageObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.echeApp.mojom.SignalingMessageObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SignalingMessageObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.echeApp.mojom.SignalingMessageObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.echeApp.mojom.SignalingMessageObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.SignalingMessageObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReceivedSignalingMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.SignalingMessageObserver_OnReceivedSignalingMessage_ParamsSpec.$,
        null,
        this.onReceivedSignalingMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.echeApp.mojom.SystemInfoProviderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.echeApp.mojom.SystemInfoProvider.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.echeApp.mojom.SystemInfoProviderInterface }
 */
ash.echeApp.mojom.SystemInfoProviderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.echeApp.mojom.SystemInfoProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.echeApp.mojom.SystemInfoProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.echeApp.mojom.SystemInfoProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        systemInfo: !string,
   *  }>}
   */

  getSystemInfo() {
    return this.proxy.sendMessage(
        0,
        ash.echeApp.mojom.SystemInfoProvider_GetSystemInfo_ParamsSpec.$,
        ash.echeApp.mojom.SystemInfoProvider_GetSystemInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !ash.echeApp.mojom.SystemInfoObserverRemote } observer
   */

  setSystemInfoObserver(
      observer) {
    this.proxy.sendMessage(
        1,
        ash.echeApp.mojom.SystemInfoProvider_SetSystemInfoObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SystemInfoProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.echeApp.mojom.SystemInfoProviderReceiver = class {
  /**
   * @param {!ash.echeApp.mojom.SystemInfoProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.echeApp.mojom.SystemInfoProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.echeApp.mojom.SystemInfoProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.SystemInfoProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.SystemInfoProvider_GetSystemInfo_ParamsSpec.$,
        ash.echeApp.mojom.SystemInfoProvider_GetSystemInfo_ResponseParamsSpec.$,
        impl.getSystemInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.echeApp.mojom.SystemInfoProvider_SetSystemInfoObserver_ParamsSpec.$,
        null,
        impl.setSystemInfoObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.echeApp.mojom.SystemInfoProvider = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.SystemInfoProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.echeApp.mojom.SystemInfoProviderRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.echeApp.mojom.SystemInfoProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SystemInfoProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.echeApp.mojom.SystemInfoProviderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.echeApp.mojom.SystemInfoProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.SystemInfoProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSystemInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.SystemInfoProvider_GetSystemInfo_ParamsSpec.$,
        ash.echeApp.mojom.SystemInfoProvider_GetSystemInfo_ResponseParamsSpec.$,
        this.getSystemInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSystemInfoObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.echeApp.mojom.SystemInfoProvider_SetSystemInfoObserver_ParamsSpec.$,
        null,
        this.setSystemInfoObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.echeApp.mojom.SystemInfoObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.echeApp.mojom.SystemInfoObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.echeApp.mojom.SystemInfoObserverInterface }
 */
ash.echeApp.mojom.SystemInfoObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.echeApp.mojom.SystemInfoObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.echeApp.mojom.SystemInfoObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.echeApp.mojom.SystemInfoObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ash.echeApp.mojom.ScreenBacklightState } state
   */

  onScreenBacklightStateChanged(
      state) {
    this.proxy.sendMessage(
        0,
        ash.echeApp.mojom.SystemInfoObserver_OnScreenBacklightStateChanged_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }

  
  /**
   * @param { !boolean } isTabletMode
   */

  onReceivedTabletModeChanged(
      isTabletMode) {
    this.proxy.sendMessage(
        1,
        ash.echeApp.mojom.SystemInfoObserver_OnReceivedTabletModeChanged_ParamsSpec.$,
        null,
        [
          isTabletMode
        ],
        false);
  }

  
  /**
   * @param { !boolean } isDifferentNetwork
   * @param { !boolean } androidDeviceOnCellular
   */

  onAndroidDeviceNetworkInfoChanged(
      isDifferentNetwork,
      androidDeviceOnCellular) {
    this.proxy.sendMessage(
        2,
        ash.echeApp.mojom.SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_ParamsSpec.$,
        null,
        [
          isDifferentNetwork,
          androidDeviceOnCellular
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SystemInfoObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.echeApp.mojom.SystemInfoObserverReceiver = class {
  /**
   * @param {!ash.echeApp.mojom.SystemInfoObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.echeApp.mojom.SystemInfoObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.echeApp.mojom.SystemInfoObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.SystemInfoObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.SystemInfoObserver_OnScreenBacklightStateChanged_ParamsSpec.$,
        null,
        impl.onScreenBacklightStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.echeApp.mojom.SystemInfoObserver_OnReceivedTabletModeChanged_ParamsSpec.$,
        null,
        impl.onReceivedTabletModeChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ash.echeApp.mojom.SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_ParamsSpec.$,
        null,
        impl.onAndroidDeviceNetworkInfoChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.echeApp.mojom.SystemInfoObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.SystemInfoObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.echeApp.mojom.SystemInfoObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.echeApp.mojom.SystemInfoObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SystemInfoObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.echeApp.mojom.SystemInfoObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.echeApp.mojom.SystemInfoObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.SystemInfoObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onScreenBacklightStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.SystemInfoObserver_OnScreenBacklightStateChanged_ParamsSpec.$,
        null,
        this.onScreenBacklightStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReceivedTabletModeChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.echeApp.mojom.SystemInfoObserver_OnReceivedTabletModeChanged_ParamsSpec.$,
        null,
        this.onReceivedTabletModeChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAndroidDeviceNetworkInfoChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ash.echeApp.mojom.SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_ParamsSpec.$,
        null,
        this.onAndroidDeviceNetworkInfoChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.echeApp.mojom.AccessibilityProviderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.echeApp.mojom.AccessibilityProvider.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.echeApp.mojom.AccessibilityProviderInterface }
 */
ash.echeApp.mojom.AccessibilityProviderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.echeApp.mojom.AccessibilityProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.echeApp.mojom.AccessibilityProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.echeApp.mojom.AccessibilityProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!number> } serializedProto
   */

  handleAccessibilityEventReceived(
      serializedProto) {
    this.proxy.sendMessage(
        0,
        ash.echeApp.mojom.AccessibilityProvider_HandleAccessibilityEventReceived_ParamsSpec.$,
        null,
        [
          serializedProto
        ],
        false);
  }

  
  /**
   * @param { !ash.echeApp.mojom.AccessibilityObserverRemote } observer
   */

  setAccessibilityObserver(
      observer) {
    this.proxy.sendMessage(
        1,
        ash.echeApp.mojom.AccessibilityProvider_SetAccessibilityObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        enabled: !boolean,
   *  }>}
   */

  isAccessibilityEnabled() {
    return this.proxy.sendMessage(
        2,
        ash.echeApp.mojom.AccessibilityProvider_IsAccessibilityEnabled_ParamsSpec.$,
        ash.echeApp.mojom.AccessibilityProvider_IsAccessibilityEnabled_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AccessibilityProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.echeApp.mojom.AccessibilityProviderReceiver = class {
  /**
   * @param {!ash.echeApp.mojom.AccessibilityProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.echeApp.mojom.AccessibilityProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.echeApp.mojom.AccessibilityProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.AccessibilityProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.AccessibilityProvider_HandleAccessibilityEventReceived_ParamsSpec.$,
        null,
        impl.handleAccessibilityEventReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.echeApp.mojom.AccessibilityProvider_SetAccessibilityObserver_ParamsSpec.$,
        null,
        impl.setAccessibilityObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ash.echeApp.mojom.AccessibilityProvider_IsAccessibilityEnabled_ParamsSpec.$,
        ash.echeApp.mojom.AccessibilityProvider_IsAccessibilityEnabled_ResponseParamsSpec.$,
        impl.isAccessibilityEnabled.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.echeApp.mojom.AccessibilityProvider = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.AccessibilityProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.echeApp.mojom.AccessibilityProviderRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.echeApp.mojom.AccessibilityProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AccessibilityProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.echeApp.mojom.AccessibilityProviderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.echeApp.mojom.AccessibilityProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.AccessibilityProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.handleAccessibilityEventReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.AccessibilityProvider_HandleAccessibilityEventReceived_ParamsSpec.$,
        null,
        this.handleAccessibilityEventReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAccessibilityObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.echeApp.mojom.AccessibilityProvider_SetAccessibilityObserver_ParamsSpec.$,
        null,
        this.setAccessibilityObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isAccessibilityEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ash.echeApp.mojom.AccessibilityProvider_IsAccessibilityEnabled_ParamsSpec.$,
        ash.echeApp.mojom.AccessibilityProvider_IsAccessibilityEnabled_ResponseParamsSpec.$,
        this.isAccessibilityEnabled.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.echeApp.mojom.AccessibilityObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.echeApp.mojom.AccessibilityObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.echeApp.mojom.AccessibilityObserverInterface }
 */
ash.echeApp.mojom.AccessibilityObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.echeApp.mojom.AccessibilityObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.echeApp.mojom.AccessibilityObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.echeApp.mojom.AccessibilityObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } enable
   */

  enableAccessibilityTreeStreaming(
      enable) {
    this.proxy.sendMessage(
        0,
        ash.echeApp.mojom.AccessibilityObserver_EnableAccessibilityTreeStreaming_ParamsSpec.$,
        null,
        [
          enable
        ],
        false);
  }

  
  /**
   * @param { !boolean } enable
   */

  enableExploreByTouch(
      enable) {
    this.proxy.sendMessage(
        1,
        ash.echeApp.mojom.AccessibilityObserver_EnableExploreByTouch_ParamsSpec.$,
        null,
        [
          enable
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } serializedProto
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  performAction(
      serializedProto) {
    return this.proxy.sendMessage(
        2,
        ash.echeApp.mojom.AccessibilityObserver_PerformAction_ParamsSpec.$,
        ash.echeApp.mojom.AccessibilityObserver_PerformAction_ResponseParamsSpec.$,
        [
          serializedProto
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } refreshDataProto
   * @return {!Promise<{
        textLocationProto: ?Array<!number>,
   *  }>}
   */

  refreshWithExtraData(
      refreshDataProto) {
    return this.proxy.sendMessage(
        3,
        ash.echeApp.mojom.AccessibilityObserver_RefreshWithExtraData_ParamsSpec.$,
        ash.echeApp.mojom.AccessibilityObserver_RefreshWithExtraData_ResponseParamsSpec.$,
        [
          refreshDataProto
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AccessibilityObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.echeApp.mojom.AccessibilityObserverReceiver = class {
  /**
   * @param {!ash.echeApp.mojom.AccessibilityObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.echeApp.mojom.AccessibilityObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.echeApp.mojom.AccessibilityObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.AccessibilityObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.AccessibilityObserver_EnableAccessibilityTreeStreaming_ParamsSpec.$,
        null,
        impl.enableAccessibilityTreeStreaming.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.echeApp.mojom.AccessibilityObserver_EnableExploreByTouch_ParamsSpec.$,
        null,
        impl.enableExploreByTouch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ash.echeApp.mojom.AccessibilityObserver_PerformAction_ParamsSpec.$,
        ash.echeApp.mojom.AccessibilityObserver_PerformAction_ResponseParamsSpec.$,
        impl.performAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ash.echeApp.mojom.AccessibilityObserver_RefreshWithExtraData_ParamsSpec.$,
        ash.echeApp.mojom.AccessibilityObserver_RefreshWithExtraData_ResponseParamsSpec.$,
        impl.refreshWithExtraData.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.echeApp.mojom.AccessibilityObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.AccessibilityObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.echeApp.mojom.AccessibilityObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.echeApp.mojom.AccessibilityObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AccessibilityObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.echeApp.mojom.AccessibilityObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.echeApp.mojom.AccessibilityObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.AccessibilityObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableAccessibilityTreeStreaming =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.AccessibilityObserver_EnableAccessibilityTreeStreaming_ParamsSpec.$,
        null,
        this.enableAccessibilityTreeStreaming.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableExploreByTouch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.echeApp.mojom.AccessibilityObserver_EnableExploreByTouch_ParamsSpec.$,
        null,
        this.enableExploreByTouch.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.performAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ash.echeApp.mojom.AccessibilityObserver_PerformAction_ParamsSpec.$,
        ash.echeApp.mojom.AccessibilityObserver_PerformAction_ResponseParamsSpec.$,
        this.performAction.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.refreshWithExtraData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ash.echeApp.mojom.AccessibilityObserver_RefreshWithExtraData_ParamsSpec.$,
        ash.echeApp.mojom.AccessibilityObserver_RefreshWithExtraData_ResponseParamsSpec.$,
        this.refreshWithExtraData.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.echeApp.mojom.UidGeneratorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.echeApp.mojom.UidGenerator.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.echeApp.mojom.UidGeneratorInterface }
 */
ash.echeApp.mojom.UidGeneratorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.echeApp.mojom.UidGeneratorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.echeApp.mojom.UidGeneratorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.echeApp.mojom.UidGeneratorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        localUid: !string,
   *  }>}
   */

  getUid() {
    return this.proxy.sendMessage(
        0,
        ash.echeApp.mojom.UidGenerator_GetUid_ParamsSpec.$,
        ash.echeApp.mojom.UidGenerator_GetUid_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the UidGenerator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.echeApp.mojom.UidGeneratorReceiver = class {
  /**
   * @param {!ash.echeApp.mojom.UidGeneratorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.echeApp.mojom.UidGeneratorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.echeApp.mojom.UidGeneratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.UidGeneratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.UidGenerator_GetUid_ParamsSpec.$,
        ash.echeApp.mojom.UidGenerator_GetUid_ResponseParamsSpec.$,
        impl.getUid.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.echeApp.mojom.UidGenerator = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.UidGenerator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.echeApp.mojom.UidGeneratorRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.echeApp.mojom.UidGeneratorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the UidGenerator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.echeApp.mojom.UidGeneratorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.echeApp.mojom.UidGeneratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.UidGeneratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getUid =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.UidGenerator_GetUid_ParamsSpec.$,
        ash.echeApp.mojom.UidGenerator_GetUid_ResponseParamsSpec.$,
        this.getUid.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.echeApp.mojom.NotificationGeneratorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.echeApp.mojom.NotificationGenerator.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.echeApp.mojom.NotificationGeneratorInterface }
 */
ash.echeApp.mojom.NotificationGeneratorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.echeApp.mojom.NotificationGeneratorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.echeApp.mojom.NotificationGeneratorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.echeApp.mojom.NotificationGeneratorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } title
   * @param { !mojoBase.mojom.String16 } message
   * @param { !ash.echeApp.mojom.WebNotificationType } type
   */

  showNotification(
      title,
      message,
      type) {
    this.proxy.sendMessage(
        0,
        ash.echeApp.mojom.NotificationGenerator_ShowNotification_ParamsSpec.$,
        null,
        [
          title,
          message,
          type
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.String16 } text
   */

  showToast(
      text) {
    this.proxy.sendMessage(
        1,
        ash.echeApp.mojom.NotificationGenerator_ShowToast_ParamsSpec.$,
        null,
        [
          text
        ],
        false);
  }
};

/**
 * An object which receives request messages for the NotificationGenerator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.echeApp.mojom.NotificationGeneratorReceiver = class {
  /**
   * @param {!ash.echeApp.mojom.NotificationGeneratorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.echeApp.mojom.NotificationGeneratorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.echeApp.mojom.NotificationGeneratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.NotificationGeneratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.NotificationGenerator_ShowNotification_ParamsSpec.$,
        null,
        impl.showNotification.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.echeApp.mojom.NotificationGenerator_ShowToast_ParamsSpec.$,
        null,
        impl.showToast.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.echeApp.mojom.NotificationGenerator = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.NotificationGenerator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.echeApp.mojom.NotificationGeneratorRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.echeApp.mojom.NotificationGeneratorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the NotificationGenerator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.echeApp.mojom.NotificationGeneratorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.echeApp.mojom.NotificationGeneratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.NotificationGeneratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showNotification =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.NotificationGenerator_ShowNotification_ParamsSpec.$,
        null,
        this.showNotification.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showToast =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.echeApp.mojom.NotificationGenerator_ShowToast_ParamsSpec.$,
        null,
        this.showToast.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.echeApp.mojom.DisplayStreamHandlerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.echeApp.mojom.DisplayStreamHandler.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.echeApp.mojom.DisplayStreamHandlerInterface }
 */
ash.echeApp.mojom.DisplayStreamHandlerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.echeApp.mojom.DisplayStreamHandlerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.echeApp.mojom.DisplayStreamHandlerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.echeApp.mojom.DisplayStreamHandlerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  startStreaming() {
    this.proxy.sendMessage(
        0,
        ash.echeApp.mojom.DisplayStreamHandler_StartStreaming_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !ash.echeApp.mojom.StreamStatus } status
   */

  onStreamStatusChanged(
      status) {
    this.proxy.sendMessage(
        1,
        ash.echeApp.mojom.DisplayStreamHandler_OnStreamStatusChanged_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   * @param { !ash.echeApp.mojom.StreamActionObserverRemote } observer
   */

  setStreamActionObserver(
      observer) {
    this.proxy.sendMessage(
        2,
        ash.echeApp.mojom.DisplayStreamHandler_SetStreamActionObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the DisplayStreamHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.echeApp.mojom.DisplayStreamHandlerReceiver = class {
  /**
   * @param {!ash.echeApp.mojom.DisplayStreamHandlerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.echeApp.mojom.DisplayStreamHandlerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.echeApp.mojom.DisplayStreamHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.DisplayStreamHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.DisplayStreamHandler_StartStreaming_ParamsSpec.$,
        null,
        impl.startStreaming.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.echeApp.mojom.DisplayStreamHandler_OnStreamStatusChanged_ParamsSpec.$,
        null,
        impl.onStreamStatusChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ash.echeApp.mojom.DisplayStreamHandler_SetStreamActionObserver_ParamsSpec.$,
        null,
        impl.setStreamActionObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.echeApp.mojom.DisplayStreamHandler = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.DisplayStreamHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.echeApp.mojom.DisplayStreamHandlerRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.echeApp.mojom.DisplayStreamHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the DisplayStreamHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.echeApp.mojom.DisplayStreamHandlerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.echeApp.mojom.DisplayStreamHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.DisplayStreamHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startStreaming =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.DisplayStreamHandler_StartStreaming_ParamsSpec.$,
        null,
        this.startStreaming.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStreamStatusChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.echeApp.mojom.DisplayStreamHandler_OnStreamStatusChanged_ParamsSpec.$,
        null,
        this.onStreamStatusChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setStreamActionObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ash.echeApp.mojom.DisplayStreamHandler_SetStreamActionObserver_ParamsSpec.$,
        null,
        this.setStreamActionObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.echeApp.mojom.StreamActionObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.echeApp.mojom.StreamActionObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.echeApp.mojom.StreamActionObserverInterface }
 */
ash.echeApp.mojom.StreamActionObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.echeApp.mojom.StreamActionObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.echeApp.mojom.StreamActionObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.echeApp.mojom.StreamActionObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ash.echeApp.mojom.StreamAction } action
   */

  onStreamAction(
      action) {
    this.proxy.sendMessage(
        0,
        ash.echeApp.mojom.StreamActionObserver_OnStreamAction_ParamsSpec.$,
        null,
        [
          action
        ],
        false);
  }
};

/**
 * An object which receives request messages for the StreamActionObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.echeApp.mojom.StreamActionObserverReceiver = class {
  /**
   * @param {!ash.echeApp.mojom.StreamActionObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.echeApp.mojom.StreamActionObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.echeApp.mojom.StreamActionObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.StreamActionObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.StreamActionObserver_OnStreamAction_ParamsSpec.$,
        null,
        impl.onStreamAction.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.echeApp.mojom.StreamActionObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.StreamActionObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.echeApp.mojom.StreamActionObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.echeApp.mojom.StreamActionObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the StreamActionObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.echeApp.mojom.StreamActionObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.echeApp.mojom.StreamActionObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.StreamActionObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStreamAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.StreamActionObserver_OnStreamAction_ParamsSpec.$,
        null,
        this.onStreamAction.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.echeApp.mojom.StreamOrientationObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.echeApp.mojom.StreamOrientationObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.echeApp.mojom.StreamOrientationObserverInterface }
 */
ash.echeApp.mojom.StreamOrientationObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.echeApp.mojom.StreamOrientationObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.echeApp.mojom.StreamOrientationObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.echeApp.mojom.StreamOrientationObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } isLandscape
   */

  onStreamOrientationChanged(
      isLandscape) {
    this.proxy.sendMessage(
        0,
        ash.echeApp.mojom.StreamOrientationObserver_OnStreamOrientationChanged_ParamsSpec.$,
        null,
        [
          isLandscape
        ],
        false);
  }
};

/**
 * An object which receives request messages for the StreamOrientationObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.echeApp.mojom.StreamOrientationObserverReceiver = class {
  /**
   * @param {!ash.echeApp.mojom.StreamOrientationObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.echeApp.mojom.StreamOrientationObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.echeApp.mojom.StreamOrientationObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.StreamOrientationObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.StreamOrientationObserver_OnStreamOrientationChanged_ParamsSpec.$,
        null,
        impl.onStreamOrientationChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.echeApp.mojom.StreamOrientationObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.StreamOrientationObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.echeApp.mojom.StreamOrientationObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.echeApp.mojom.StreamOrientationObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the StreamOrientationObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.echeApp.mojom.StreamOrientationObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.echeApp.mojom.StreamOrientationObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.StreamOrientationObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStreamOrientationChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.StreamOrientationObserver_OnStreamOrientationChanged_ParamsSpec.$,
        null,
        this.onStreamOrientationChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.echeApp.mojom.ConnectionStatusObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.echeApp.mojom.ConnectionStatusObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.echeApp.mojom.ConnectionStatusObserverInterface }
 */
ash.echeApp.mojom.ConnectionStatusObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.echeApp.mojom.ConnectionStatusObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.echeApp.mojom.ConnectionStatusObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.echeApp.mojom.ConnectionStatusObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ash.echeApp.mojom.ConnectionStatus } status
   */

  onConnectionStatusChanged(
      status) {
    this.proxy.sendMessage(
        0,
        ash.echeApp.mojom.ConnectionStatusObserver_OnConnectionStatusChanged_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ConnectionStatusObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.echeApp.mojom.ConnectionStatusObserverReceiver = class {
  /**
   * @param {!ash.echeApp.mojom.ConnectionStatusObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.echeApp.mojom.ConnectionStatusObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.echeApp.mojom.ConnectionStatusObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.ConnectionStatusObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.ConnectionStatusObserver_OnConnectionStatusChanged_ParamsSpec.$,
        null,
        impl.onConnectionStatusChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.echeApp.mojom.ConnectionStatusObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.ConnectionStatusObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.echeApp.mojom.ConnectionStatusObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.echeApp.mojom.ConnectionStatusObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the ConnectionStatusObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.echeApp.mojom.ConnectionStatusObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.echeApp.mojom.ConnectionStatusObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.ConnectionStatusObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onConnectionStatusChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.ConnectionStatusObserver_OnConnectionStatusChanged_ParamsSpec.$,
        null,
        this.onConnectionStatusChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.echeApp.mojom.KeyboardLayoutHandlerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.echeApp.mojom.KeyboardLayoutHandler.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.echeApp.mojom.KeyboardLayoutHandlerInterface }
 */
ash.echeApp.mojom.KeyboardLayoutHandlerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.echeApp.mojom.KeyboardLayoutHandlerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.echeApp.mojom.KeyboardLayoutHandlerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.echeApp.mojom.KeyboardLayoutHandlerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  requestCurrentKeyboardLayout() {
    this.proxy.sendMessage(
        0,
        ash.echeApp.mojom.KeyboardLayoutHandler_RequestCurrentKeyboardLayout_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !ash.echeApp.mojom.KeyboardLayoutObserverRemote } observer
   */

  setKeyboardLayoutObserver(
      observer) {
    this.proxy.sendMessage(
        1,
        ash.echeApp.mojom.KeyboardLayoutHandler_SetKeyboardLayoutObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
};

/**
 * An object which receives request messages for the KeyboardLayoutHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.echeApp.mojom.KeyboardLayoutHandlerReceiver = class {
  /**
   * @param {!ash.echeApp.mojom.KeyboardLayoutHandlerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.echeApp.mojom.KeyboardLayoutHandlerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.echeApp.mojom.KeyboardLayoutHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.KeyboardLayoutHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.KeyboardLayoutHandler_RequestCurrentKeyboardLayout_ParamsSpec.$,
        null,
        impl.requestCurrentKeyboardLayout.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.echeApp.mojom.KeyboardLayoutHandler_SetKeyboardLayoutObserver_ParamsSpec.$,
        null,
        impl.setKeyboardLayoutObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.echeApp.mojom.KeyboardLayoutHandler = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.KeyboardLayoutHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.echeApp.mojom.KeyboardLayoutHandlerRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.echeApp.mojom.KeyboardLayoutHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the KeyboardLayoutHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.echeApp.mojom.KeyboardLayoutHandlerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.echeApp.mojom.KeyboardLayoutHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.KeyboardLayoutHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestCurrentKeyboardLayout =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.KeyboardLayoutHandler_RequestCurrentKeyboardLayout_ParamsSpec.$,
        null,
        this.requestCurrentKeyboardLayout.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setKeyboardLayoutObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.echeApp.mojom.KeyboardLayoutHandler_SetKeyboardLayoutObserver_ParamsSpec.$,
        null,
        this.setKeyboardLayoutObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.echeApp.mojom.KeyboardLayoutObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.echeApp.mojom.KeyboardLayoutObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.echeApp.mojom.KeyboardLayoutObserverInterface }
 */
ash.echeApp.mojom.KeyboardLayoutObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.echeApp.mojom.KeyboardLayoutObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.echeApp.mojom.KeyboardLayoutObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.echeApp.mojom.KeyboardLayoutObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } id
   * @param { !string } longName
   * @param { !string } shortName
   * @param { !string } layoutTag
   */

  onKeyboardLayoutChanged(
      id,
      longName,
      shortName,
      layoutTag) {
    this.proxy.sendMessage(
        0,
        ash.echeApp.mojom.KeyboardLayoutObserver_OnKeyboardLayoutChanged_ParamsSpec.$,
        null,
        [
          id,
          longName,
          shortName,
          layoutTag
        ],
        false);
  }
};

/**
 * An object which receives request messages for the KeyboardLayoutObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.echeApp.mojom.KeyboardLayoutObserverReceiver = class {
  /**
   * @param {!ash.echeApp.mojom.KeyboardLayoutObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.echeApp.mojom.KeyboardLayoutObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.echeApp.mojom.KeyboardLayoutObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.KeyboardLayoutObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.KeyboardLayoutObserver_OnKeyboardLayoutChanged_ParamsSpec.$,
        null,
        impl.onKeyboardLayoutChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.echeApp.mojom.KeyboardLayoutObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.KeyboardLayoutObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.echeApp.mojom.KeyboardLayoutObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.echeApp.mojom.KeyboardLayoutObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the KeyboardLayoutObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.echeApp.mojom.KeyboardLayoutObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.echeApp.mojom.KeyboardLayoutObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.echeApp.mojom.KeyboardLayoutObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onKeyboardLayoutChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.echeApp.mojom.KeyboardLayoutObserver_OnKeyboardLayoutChanged_ParamsSpec.$,
        null,
        this.onKeyboardLayoutChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.SignalingMessageExchanger_SendSignalingMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.SignalingMessageExchanger_SetSignalingMessageObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.SignalingMessageExchanger_TearDownSignaling_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.SignalingMessageObserver_OnReceivedSignalingMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.SystemInfoProvider_GetSystemInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.SystemInfoProvider_GetSystemInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.SystemInfoProvider_SetSystemInfoObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.SystemInfoObserver_OnScreenBacklightStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.SystemInfoObserver_OnReceivedTabletModeChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.AccessibilityProvider_HandleAccessibilityEventReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.AccessibilityProvider_SetAccessibilityObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.AccessibilityProvider_IsAccessibilityEnabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.AccessibilityProvider_IsAccessibilityEnabled_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.AccessibilityObserver_EnableAccessibilityTreeStreaming_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.AccessibilityObserver_EnableExploreByTouch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.AccessibilityObserver_PerformAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.AccessibilityObserver_PerformAction_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.AccessibilityObserver_RefreshWithExtraData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.AccessibilityObserver_RefreshWithExtraData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.UidGenerator_GetUid_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.UidGenerator_GetUid_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.NotificationGenerator_ShowNotification_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.NotificationGenerator_ShowToast_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.DisplayStreamHandler_StartStreaming_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.DisplayStreamHandler_OnStreamStatusChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.DisplayStreamHandler_SetStreamActionObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.StreamActionObserver_OnStreamAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.StreamOrientationObserver_OnStreamOrientationChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.ConnectionStatusObserver_OnConnectionStatusChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.KeyboardLayoutHandler_RequestCurrentKeyboardLayout_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.KeyboardLayoutHandler_SetKeyboardLayoutObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.echeApp.mojom.KeyboardLayoutObserver_OnKeyboardLayoutChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ash.echeApp.mojom.SignalingMessageExchanger_SendSignalingMessage_ParamsSpec.$,
    'SignalingMessageExchanger_SendSignalingMessage_Params',
    [
      mojo.internal.StructField(
        'signal', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.SignalingMessageExchanger_SendSignalingMessage_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.signal;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.SignalingMessageExchanger_SetSignalingMessageObserver_ParamsSpec.$,
    'SignalingMessageExchanger_SetSignalingMessageObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(ash.echeApp.mojom.SignalingMessageObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.SignalingMessageExchanger_SetSignalingMessageObserver_Params = class {
  constructor() {
    /** @export { !ash.echeApp.mojom.SignalingMessageObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.SignalingMessageExchanger_TearDownSignaling_ParamsSpec.$,
    'SignalingMessageExchanger_TearDownSignaling_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.echeApp.mojom.SignalingMessageExchanger_TearDownSignaling_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.SignalingMessageObserver_OnReceivedSignalingMessage_ParamsSpec.$,
    'SignalingMessageObserver_OnReceivedSignalingMessage_Params',
    [
      mojo.internal.StructField(
        'signal', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.SignalingMessageObserver_OnReceivedSignalingMessage_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.signal;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.SystemInfoProvider_GetSystemInfo_ParamsSpec.$,
    'SystemInfoProvider_GetSystemInfo_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.echeApp.mojom.SystemInfoProvider_GetSystemInfo_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.SystemInfoProvider_GetSystemInfo_ResponseParamsSpec.$,
    'SystemInfoProvider_GetSystemInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'systemInfo', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.SystemInfoProvider_GetSystemInfo_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.systemInfo;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.SystemInfoProvider_SetSystemInfoObserver_ParamsSpec.$,
    'SystemInfoProvider_SetSystemInfoObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(ash.echeApp.mojom.SystemInfoObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.SystemInfoProvider_SetSystemInfoObserver_Params = class {
  constructor() {
    /** @export { !ash.echeApp.mojom.SystemInfoObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.SystemInfoObserver_OnScreenBacklightStateChanged_ParamsSpec.$,
    'SystemInfoObserver_OnScreenBacklightStateChanged_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        ash.echeApp.mojom.ScreenBacklightStateSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.SystemInfoObserver_OnScreenBacklightStateChanged_Params = class {
  constructor() {
    /** @export { !ash.echeApp.mojom.ScreenBacklightState } */
    this.state;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.SystemInfoObserver_OnReceivedTabletModeChanged_ParamsSpec.$,
    'SystemInfoObserver_OnReceivedTabletModeChanged_Params',
    [
      mojo.internal.StructField(
        'isTabletMode', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.SystemInfoObserver_OnReceivedTabletModeChanged_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.isTabletMode;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_ParamsSpec.$,
    'SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Params',
    [
      mojo.internal.StructField(
        'isDifferentNetwork', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'androidDeviceOnCellular', 0,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.isDifferentNetwork;
    /** @export { !boolean } */
    this.androidDeviceOnCellular;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.AccessibilityProvider_HandleAccessibilityEventReceived_ParamsSpec.$,
    'AccessibilityProvider_HandleAccessibilityEventReceived_Params',
    [
      mojo.internal.StructField(
        'serializedProto', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.AccessibilityProvider_HandleAccessibilityEventReceived_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.serializedProto;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.AccessibilityProvider_SetAccessibilityObserver_ParamsSpec.$,
    'AccessibilityProvider_SetAccessibilityObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(ash.echeApp.mojom.AccessibilityObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.AccessibilityProvider_SetAccessibilityObserver_Params = class {
  constructor() {
    /** @export { !ash.echeApp.mojom.AccessibilityObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.AccessibilityProvider_IsAccessibilityEnabled_ParamsSpec.$,
    'AccessibilityProvider_IsAccessibilityEnabled_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.echeApp.mojom.AccessibilityProvider_IsAccessibilityEnabled_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.AccessibilityProvider_IsAccessibilityEnabled_ResponseParamsSpec.$,
    'AccessibilityProvider_IsAccessibilityEnabled_ResponseParams',
    [
      mojo.internal.StructField(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.AccessibilityProvider_IsAccessibilityEnabled_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.enabled;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.AccessibilityObserver_EnableAccessibilityTreeStreaming_ParamsSpec.$,
    'AccessibilityObserver_EnableAccessibilityTreeStreaming_Params',
    [
      mojo.internal.StructField(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.AccessibilityObserver_EnableAccessibilityTreeStreaming_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.enable;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.AccessibilityObserver_EnableExploreByTouch_ParamsSpec.$,
    'AccessibilityObserver_EnableExploreByTouch_Params',
    [
      mojo.internal.StructField(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.AccessibilityObserver_EnableExploreByTouch_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.enable;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.AccessibilityObserver_PerformAction_ParamsSpec.$,
    'AccessibilityObserver_PerformAction_Params',
    [
      mojo.internal.StructField(
        'serializedProto', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.AccessibilityObserver_PerformAction_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.serializedProto;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.AccessibilityObserver_PerformAction_ResponseParamsSpec.$,
    'AccessibilityObserver_PerformAction_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.AccessibilityObserver_PerformAction_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.result;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.AccessibilityObserver_RefreshWithExtraData_ParamsSpec.$,
    'AccessibilityObserver_RefreshWithExtraData_Params',
    [
      mojo.internal.StructField(
        'refreshDataProto', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.AccessibilityObserver_RefreshWithExtraData_Params = class {
  constructor() {
    /** @export { !Array<!number> } */
    this.refreshDataProto;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.AccessibilityObserver_RefreshWithExtraData_ResponseParamsSpec.$,
    'AccessibilityObserver_RefreshWithExtraData_ResponseParams',
    [
      mojo.internal.StructField(
        'textLocationProto', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.AccessibilityObserver_RefreshWithExtraData_ResponseParams = class {
  constructor() {
    /** @export { (Array<!number>|undefined) } */
    this.textLocationProto;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.UidGenerator_GetUid_ParamsSpec.$,
    'UidGenerator_GetUid_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.echeApp.mojom.UidGenerator_GetUid_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.UidGenerator_GetUid_ResponseParamsSpec.$,
    'UidGenerator_GetUid_ResponseParams',
    [
      mojo.internal.StructField(
        'localUid', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.UidGenerator_GetUid_ResponseParams = class {
  constructor() {
    /** @export { !string } */
    this.localUid;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.NotificationGenerator_ShowNotification_ParamsSpec.$,
    'NotificationGenerator_ShowNotification_Params',
    [
      mojo.internal.StructField(
        'title', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 16,
        0,
        ash.echeApp.mojom.WebNotificationTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
ash.echeApp.mojom.NotificationGenerator_ShowNotification_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.title;
    /** @export { !mojoBase.mojom.String16 } */
    this.message;
    /** @export { !ash.echeApp.mojom.WebNotificationType } */
    this.type;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.NotificationGenerator_ShowToast_ParamsSpec.$,
    'NotificationGenerator_ShowToast_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.NotificationGenerator_ShowToast_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.String16 } */
    this.text;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.DisplayStreamHandler_StartStreaming_ParamsSpec.$,
    'DisplayStreamHandler_StartStreaming_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.echeApp.mojom.DisplayStreamHandler_StartStreaming_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.DisplayStreamHandler_OnStreamStatusChanged_ParamsSpec.$,
    'DisplayStreamHandler_OnStreamStatusChanged_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        ash.echeApp.mojom.StreamStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.DisplayStreamHandler_OnStreamStatusChanged_Params = class {
  constructor() {
    /** @export { !ash.echeApp.mojom.StreamStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.DisplayStreamHandler_SetStreamActionObserver_ParamsSpec.$,
    'DisplayStreamHandler_SetStreamActionObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(ash.echeApp.mojom.StreamActionObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.DisplayStreamHandler_SetStreamActionObserver_Params = class {
  constructor() {
    /** @export { !ash.echeApp.mojom.StreamActionObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.StreamActionObserver_OnStreamAction_ParamsSpec.$,
    'StreamActionObserver_OnStreamAction_Params',
    [
      mojo.internal.StructField(
        'action', 0,
        0,
        ash.echeApp.mojom.StreamActionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.StreamActionObserver_OnStreamAction_Params = class {
  constructor() {
    /** @export { !ash.echeApp.mojom.StreamAction } */
    this.action;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.StreamOrientationObserver_OnStreamOrientationChanged_ParamsSpec.$,
    'StreamOrientationObserver_OnStreamOrientationChanged_Params',
    [
      mojo.internal.StructField(
        'isLandscape', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.StreamOrientationObserver_OnStreamOrientationChanged_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.isLandscape;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.ConnectionStatusObserver_OnConnectionStatusChanged_ParamsSpec.$,
    'ConnectionStatusObserver_OnConnectionStatusChanged_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        ash.echeApp.mojom.ConnectionStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.ConnectionStatusObserver_OnConnectionStatusChanged_Params = class {
  constructor() {
    /** @export { !ash.echeApp.mojom.ConnectionStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.KeyboardLayoutHandler_RequestCurrentKeyboardLayout_ParamsSpec.$,
    'KeyboardLayoutHandler_RequestCurrentKeyboardLayout_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.echeApp.mojom.KeyboardLayoutHandler_RequestCurrentKeyboardLayout_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.KeyboardLayoutHandler_SetKeyboardLayoutObserver_ParamsSpec.$,
    'KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(ash.echeApp.mojom.KeyboardLayoutObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.echeApp.mojom.KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params = class {
  constructor() {
    /** @export { !ash.echeApp.mojom.KeyboardLayoutObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    ash.echeApp.mojom.KeyboardLayoutObserver_OnKeyboardLayoutChanged_ParamsSpec.$,
    'KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'longName', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'shortName', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'layoutTag', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
ash.echeApp.mojom.KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params = class {
  constructor() {
    /** @export { !string } */
    this.id;
    /** @export { !string } */
    this.longName;
    /** @export { !string } */
    this.shortName;
    /** @export { !string } */
    this.layoutTag;
  }
};

