// ash/webui/eche_app_ui/mojom/eche_app.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ash/webui/eche_app_ui/mojom/eche_app.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ash.echeApp.mojom');
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../mojo/public/mojom/base/string16.mojom.js');
  }


  var ScreenBacklightState = {};
  ScreenBacklightState.ON = 0;
  ScreenBacklightState.OFF = 1;
  ScreenBacklightState.OFF_AUTO = 2;
  ScreenBacklightState.MIN_VALUE = 0;
  ScreenBacklightState.MAX_VALUE = 2;

  ScreenBacklightState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  ScreenBacklightState.toKnownEnumValue = function(value) {
    return value;
  };

  ScreenBacklightState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var WebNotificationType = {};
  WebNotificationType.APP_CRAHSED = 0;
  WebNotificationType.AUTHORIZATION_NEEDED = 1;
  WebNotificationType.CONNECTION_FAILED = 2;
  WebNotificationType.CONNECTION_LOST = 3;
  WebNotificationType.DEVICE_IDLE = 4;
  WebNotificationType.INITIALIZATION_ERROR = 5;
  WebNotificationType.INVALID_NOTIFICATION = 6;
  WebNotificationType.NOTIFICATION_ACTION_NOT_LAUNCHED = 7;
  WebNotificationType.LAUNCH_NOTIFICATION_FAILED = 8;
  WebNotificationType.TABLET_MODE = 9;
  WebNotificationType.WIFI_NOT_READY = 10;
  WebNotificationType.DIFFERENT_WIFI_NETWORKS = 11;
  WebNotificationType.REMOTE_DEVICE_ON_CELLULAR = 12;
  WebNotificationType.MIN_VALUE = 0;
  WebNotificationType.MAX_VALUE = 12;

  WebNotificationType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
      return true;
    }
    return false;
  };

  WebNotificationType.toKnownEnumValue = function(value) {
    return value;
  };

  WebNotificationType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var StreamStatus = {};
  StreamStatus.kStreamStatusUnknown = 0;
  StreamStatus.kStreamStatusInitializing = 1;
  StreamStatus.kStreamStatusStarted = 2;
  StreamStatus.kStreamStatusStopped = 3;
  StreamStatus.MIN_VALUE = 0;
  StreamStatus.MAX_VALUE = 3;

  StreamStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  StreamStatus.toKnownEnumValue = function(value) {
    return value;
  };

  StreamStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var StreamAction = {};
  StreamAction.kStreamActionClose = 0;
  StreamAction.kStreamActionGoBack = 1;
  StreamAction.MIN_VALUE = 0;
  StreamAction.MAX_VALUE = 1;

  StreamAction.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  StreamAction.toKnownEnumValue = function(value) {
    return value;
  };

  StreamAction.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ConnectionStatus = {};
  ConnectionStatus.kConnectionStatusDisconnected = 0;
  ConnectionStatus.kConnectionStatusConnecting = 1;
  ConnectionStatus.kConnectionStatusConnected = 2;
  ConnectionStatus.kConnectionStatusFailed = 3;
  ConnectionStatus.MIN_VALUE = 0;
  ConnectionStatus.MAX_VALUE = 3;

  ConnectionStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  ConnectionStatus.toKnownEnumValue = function(value) {
    return value;
  };

  ConnectionStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AppStreamLaunchEntryPoint = {};
  AppStreamLaunchEntryPoint.APPS_LIST = 0;
  AppStreamLaunchEntryPoint.NOTIFICATION = 1;
  AppStreamLaunchEntryPoint.RECENT_APPS = 2;
  AppStreamLaunchEntryPoint.UNKNOWN = 3;
  AppStreamLaunchEntryPoint.MIN_VALUE = 0;
  AppStreamLaunchEntryPoint.MAX_VALUE = 3;

  AppStreamLaunchEntryPoint.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  AppStreamLaunchEntryPoint.toKnownEnumValue = function(value) {
    return value;
  };

  AppStreamLaunchEntryPoint.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function SignalingMessageExchanger_SendSignalingMessage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SignalingMessageExchanger_SendSignalingMessage_Params.prototype.initDefaults_ = function() {
    this.signal = null;
  };
  SignalingMessageExchanger_SendSignalingMessage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SignalingMessageExchanger_SendSignalingMessage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SignalingMessageExchanger_SendSignalingMessage_Params.signal
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SignalingMessageExchanger_SendSignalingMessage_Params.encodedSize = codec.kStructHeaderSize + 8;

  SignalingMessageExchanger_SendSignalingMessage_Params.decode = function(decoder) {
    var packed;
    var val = new SignalingMessageExchanger_SendSignalingMessage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.signal =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  SignalingMessageExchanger_SendSignalingMessage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SignalingMessageExchanger_SendSignalingMessage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.signal);
  };
  function SignalingMessageExchanger_SetSignalingMessageObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SignalingMessageExchanger_SetSignalingMessageObserver_Params.prototype.initDefaults_ = function() {
    this.observer = new SignalingMessageObserverPtr();
  };
  SignalingMessageExchanger_SetSignalingMessageObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SignalingMessageExchanger_SetSignalingMessageObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SignalingMessageExchanger_SetSignalingMessageObserver_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SignalingMessageExchanger_SetSignalingMessageObserver_Params.encodedSize = codec.kStructHeaderSize + 8;

  SignalingMessageExchanger_SetSignalingMessageObserver_Params.decode = function(decoder) {
    var packed;
    var val = new SignalingMessageExchanger_SetSignalingMessageObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observer =
        decoder.decodeStruct(new codec.Interface(SignalingMessageObserverPtr));
    return val;
  };

  SignalingMessageExchanger_SetSignalingMessageObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SignalingMessageExchanger_SetSignalingMessageObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(SignalingMessageObserverPtr), val.observer);
  };
  function SignalingMessageExchanger_TearDownSignaling_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SignalingMessageExchanger_TearDownSignaling_Params.prototype.initDefaults_ = function() {
  };
  SignalingMessageExchanger_TearDownSignaling_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SignalingMessageExchanger_TearDownSignaling_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SignalingMessageExchanger_TearDownSignaling_Params.encodedSize = codec.kStructHeaderSize + 0;

  SignalingMessageExchanger_TearDownSignaling_Params.decode = function(decoder) {
    var packed;
    var val = new SignalingMessageExchanger_TearDownSignaling_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SignalingMessageExchanger_TearDownSignaling_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SignalingMessageExchanger_TearDownSignaling_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SignalingMessageObserver_OnReceivedSignalingMessage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SignalingMessageObserver_OnReceivedSignalingMessage_Params.prototype.initDefaults_ = function() {
    this.signal = null;
  };
  SignalingMessageObserver_OnReceivedSignalingMessage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SignalingMessageObserver_OnReceivedSignalingMessage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SignalingMessageObserver_OnReceivedSignalingMessage_Params.signal
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SignalingMessageObserver_OnReceivedSignalingMessage_Params.encodedSize = codec.kStructHeaderSize + 8;

  SignalingMessageObserver_OnReceivedSignalingMessage_Params.decode = function(decoder) {
    var packed;
    var val = new SignalingMessageObserver_OnReceivedSignalingMessage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.signal =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  SignalingMessageObserver_OnReceivedSignalingMessage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SignalingMessageObserver_OnReceivedSignalingMessage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.signal);
  };
  function SystemInfoProvider_GetSystemInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SystemInfoProvider_GetSystemInfo_Params.prototype.initDefaults_ = function() {
  };
  SystemInfoProvider_GetSystemInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SystemInfoProvider_GetSystemInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SystemInfoProvider_GetSystemInfo_Params.encodedSize = codec.kStructHeaderSize + 0;

  SystemInfoProvider_GetSystemInfo_Params.decode = function(decoder) {
    var packed;
    var val = new SystemInfoProvider_GetSystemInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SystemInfoProvider_GetSystemInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SystemInfoProvider_GetSystemInfo_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SystemInfoProvider_GetSystemInfo_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SystemInfoProvider_GetSystemInfo_ResponseParams.prototype.initDefaults_ = function() {
    this.systemInfo = null;
  };
  SystemInfoProvider_GetSystemInfo_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SystemInfoProvider_GetSystemInfo_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SystemInfoProvider_GetSystemInfo_ResponseParams.systemInfo
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SystemInfoProvider_GetSystemInfo_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  SystemInfoProvider_GetSystemInfo_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new SystemInfoProvider_GetSystemInfo_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.systemInfo =
        decoder.decodeStruct(codec.String);
    return val;
  };

  SystemInfoProvider_GetSystemInfo_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SystemInfoProvider_GetSystemInfo_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.systemInfo);
  };
  function SystemInfoProvider_SetSystemInfoObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SystemInfoProvider_SetSystemInfoObserver_Params.prototype.initDefaults_ = function() {
    this.observer = new SystemInfoObserverPtr();
  };
  SystemInfoProvider_SetSystemInfoObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SystemInfoProvider_SetSystemInfoObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SystemInfoProvider_SetSystemInfoObserver_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SystemInfoProvider_SetSystemInfoObserver_Params.encodedSize = codec.kStructHeaderSize + 8;

  SystemInfoProvider_SetSystemInfoObserver_Params.decode = function(decoder) {
    var packed;
    var val = new SystemInfoProvider_SetSystemInfoObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observer =
        decoder.decodeStruct(new codec.Interface(SystemInfoObserverPtr));
    return val;
  };

  SystemInfoProvider_SetSystemInfoObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SystemInfoProvider_SetSystemInfoObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(SystemInfoObserverPtr), val.observer);
  };
  function SystemInfoObserver_OnScreenBacklightStateChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SystemInfoObserver_OnScreenBacklightStateChanged_Params.prototype.initDefaults_ = function() {
    this.state = 0;
  };
  SystemInfoObserver_OnScreenBacklightStateChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SystemInfoObserver_OnScreenBacklightStateChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SystemInfoObserver_OnScreenBacklightStateChanged_Params.state
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ScreenBacklightState);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SystemInfoObserver_OnScreenBacklightStateChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  SystemInfoObserver_OnScreenBacklightStateChanged_Params.decode = function(decoder) {
    var packed;
    var val = new SystemInfoObserver_OnScreenBacklightStateChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.state =
        decoder.decodeStruct(new codec.Enum(ScreenBacklightState));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SystemInfoObserver_OnScreenBacklightStateChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SystemInfoObserver_OnScreenBacklightStateChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.state);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SystemInfoObserver_OnReceivedTabletModeChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SystemInfoObserver_OnReceivedTabletModeChanged_Params.prototype.initDefaults_ = function() {
    this.isTabletMode = false;
  };
  SystemInfoObserver_OnReceivedTabletModeChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SystemInfoObserver_OnReceivedTabletModeChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  SystemInfoObserver_OnReceivedTabletModeChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  SystemInfoObserver_OnReceivedTabletModeChanged_Params.decode = function(decoder) {
    var packed;
    var val = new SystemInfoObserver_OnReceivedTabletModeChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isTabletMode = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SystemInfoObserver_OnReceivedTabletModeChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SystemInfoObserver_OnReceivedTabletModeChanged_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isTabletMode & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Params.prototype.initDefaults_ = function() {
    this.isDifferentNetwork = false;
    this.androidDeviceOnCellular = false;
  };
  SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Params.decode = function(decoder) {
    var packed;
    var val = new SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isDifferentNetwork = (packed >> 0) & 1 ? true : false;
    val.androidDeviceOnCellular = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isDifferentNetwork & 1) << 0
    packed |= (val.androidDeviceOnCellular & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AccessibilityProvider_HandleAccessibilityEventReceived_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AccessibilityProvider_HandleAccessibilityEventReceived_Params.prototype.initDefaults_ = function() {
    this.serializedProto = null;
  };
  AccessibilityProvider_HandleAccessibilityEventReceived_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AccessibilityProvider_HandleAccessibilityEventReceived_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AccessibilityProvider_HandleAccessibilityEventReceived_Params.serializedProto
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AccessibilityProvider_HandleAccessibilityEventReceived_Params.encodedSize = codec.kStructHeaderSize + 8;

  AccessibilityProvider_HandleAccessibilityEventReceived_Params.decode = function(decoder) {
    var packed;
    var val = new AccessibilityProvider_HandleAccessibilityEventReceived_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.serializedProto =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  AccessibilityProvider_HandleAccessibilityEventReceived_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AccessibilityProvider_HandleAccessibilityEventReceived_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.serializedProto);
  };
  function AccessibilityProvider_SetAccessibilityObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AccessibilityProvider_SetAccessibilityObserver_Params.prototype.initDefaults_ = function() {
    this.observer = new AccessibilityObserverPtr();
  };
  AccessibilityProvider_SetAccessibilityObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AccessibilityProvider_SetAccessibilityObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AccessibilityProvider_SetAccessibilityObserver_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AccessibilityProvider_SetAccessibilityObserver_Params.encodedSize = codec.kStructHeaderSize + 8;

  AccessibilityProvider_SetAccessibilityObserver_Params.decode = function(decoder) {
    var packed;
    var val = new AccessibilityProvider_SetAccessibilityObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observer =
        decoder.decodeStruct(new codec.Interface(AccessibilityObserverPtr));
    return val;
  };

  AccessibilityProvider_SetAccessibilityObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AccessibilityProvider_SetAccessibilityObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(AccessibilityObserverPtr), val.observer);
  };
  function AccessibilityProvider_IsAccessibilityEnabled_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AccessibilityProvider_IsAccessibilityEnabled_Params.prototype.initDefaults_ = function() {
  };
  AccessibilityProvider_IsAccessibilityEnabled_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AccessibilityProvider_IsAccessibilityEnabled_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AccessibilityProvider_IsAccessibilityEnabled_Params.encodedSize = codec.kStructHeaderSize + 0;

  AccessibilityProvider_IsAccessibilityEnabled_Params.decode = function(decoder) {
    var packed;
    var val = new AccessibilityProvider_IsAccessibilityEnabled_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  AccessibilityProvider_IsAccessibilityEnabled_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AccessibilityProvider_IsAccessibilityEnabled_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function AccessibilityProvider_IsAccessibilityEnabled_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AccessibilityProvider_IsAccessibilityEnabled_ResponseParams.prototype.initDefaults_ = function() {
    this.enabled = false;
  };
  AccessibilityProvider_IsAccessibilityEnabled_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AccessibilityProvider_IsAccessibilityEnabled_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  AccessibilityProvider_IsAccessibilityEnabled_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AccessibilityProvider_IsAccessibilityEnabled_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AccessibilityProvider_IsAccessibilityEnabled_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.enabled = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AccessibilityProvider_IsAccessibilityEnabled_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AccessibilityProvider_IsAccessibilityEnabled_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.enabled & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AccessibilityObserver_EnableAccessibilityTreeStreaming_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AccessibilityObserver_EnableAccessibilityTreeStreaming_Params.prototype.initDefaults_ = function() {
    this.enable = false;
  };
  AccessibilityObserver_EnableAccessibilityTreeStreaming_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AccessibilityObserver_EnableAccessibilityTreeStreaming_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  AccessibilityObserver_EnableAccessibilityTreeStreaming_Params.encodedSize = codec.kStructHeaderSize + 8;

  AccessibilityObserver_EnableAccessibilityTreeStreaming_Params.decode = function(decoder) {
    var packed;
    var val = new AccessibilityObserver_EnableAccessibilityTreeStreaming_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.enable = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AccessibilityObserver_EnableAccessibilityTreeStreaming_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AccessibilityObserver_EnableAccessibilityTreeStreaming_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.enable & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AccessibilityObserver_EnableExploreByTouch_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AccessibilityObserver_EnableExploreByTouch_Params.prototype.initDefaults_ = function() {
    this.enable = false;
  };
  AccessibilityObserver_EnableExploreByTouch_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AccessibilityObserver_EnableExploreByTouch_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  AccessibilityObserver_EnableExploreByTouch_Params.encodedSize = codec.kStructHeaderSize + 8;

  AccessibilityObserver_EnableExploreByTouch_Params.decode = function(decoder) {
    var packed;
    var val = new AccessibilityObserver_EnableExploreByTouch_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.enable = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AccessibilityObserver_EnableExploreByTouch_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AccessibilityObserver_EnableExploreByTouch_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.enable & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AccessibilityObserver_PerformAction_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AccessibilityObserver_PerformAction_Params.prototype.initDefaults_ = function() {
    this.serializedProto = null;
  };
  AccessibilityObserver_PerformAction_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AccessibilityObserver_PerformAction_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AccessibilityObserver_PerformAction_Params.serializedProto
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AccessibilityObserver_PerformAction_Params.encodedSize = codec.kStructHeaderSize + 8;

  AccessibilityObserver_PerformAction_Params.decode = function(decoder) {
    var packed;
    var val = new AccessibilityObserver_PerformAction_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.serializedProto =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  AccessibilityObserver_PerformAction_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AccessibilityObserver_PerformAction_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.serializedProto);
  };
  function AccessibilityObserver_PerformAction_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AccessibilityObserver_PerformAction_ResponseParams.prototype.initDefaults_ = function() {
    this.result = false;
  };
  AccessibilityObserver_PerformAction_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AccessibilityObserver_PerformAction_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  AccessibilityObserver_PerformAction_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AccessibilityObserver_PerformAction_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AccessibilityObserver_PerformAction_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.result = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AccessibilityObserver_PerformAction_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AccessibilityObserver_PerformAction_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.result & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AccessibilityObserver_RefreshWithExtraData_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AccessibilityObserver_RefreshWithExtraData_Params.prototype.initDefaults_ = function() {
    this.refreshDataProto = null;
  };
  AccessibilityObserver_RefreshWithExtraData_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AccessibilityObserver_RefreshWithExtraData_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AccessibilityObserver_RefreshWithExtraData_Params.refreshDataProto
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AccessibilityObserver_RefreshWithExtraData_Params.encodedSize = codec.kStructHeaderSize + 8;

  AccessibilityObserver_RefreshWithExtraData_Params.decode = function(decoder) {
    var packed;
    var val = new AccessibilityObserver_RefreshWithExtraData_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.refreshDataProto =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  AccessibilityObserver_RefreshWithExtraData_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AccessibilityObserver_RefreshWithExtraData_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.refreshDataProto);
  };
  function AccessibilityObserver_RefreshWithExtraData_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AccessibilityObserver_RefreshWithExtraData_ResponseParams.prototype.initDefaults_ = function() {
    this.textLocationProto = null;
  };
  AccessibilityObserver_RefreshWithExtraData_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AccessibilityObserver_RefreshWithExtraData_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AccessibilityObserver_RefreshWithExtraData_ResponseParams.textLocationProto
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 1, codec.Uint8, true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AccessibilityObserver_RefreshWithExtraData_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AccessibilityObserver_RefreshWithExtraData_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AccessibilityObserver_RefreshWithExtraData_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.textLocationProto =
        decoder.decodeArrayPointer(codec.Uint8);
    return val;
  };

  AccessibilityObserver_RefreshWithExtraData_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AccessibilityObserver_RefreshWithExtraData_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(codec.Uint8, val.textLocationProto);
  };
  function UidGenerator_GetUid_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UidGenerator_GetUid_Params.prototype.initDefaults_ = function() {
  };
  UidGenerator_GetUid_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UidGenerator_GetUid_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UidGenerator_GetUid_Params.encodedSize = codec.kStructHeaderSize + 0;

  UidGenerator_GetUid_Params.decode = function(decoder) {
    var packed;
    var val = new UidGenerator_GetUid_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  UidGenerator_GetUid_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UidGenerator_GetUid_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function UidGenerator_GetUid_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UidGenerator_GetUid_ResponseParams.prototype.initDefaults_ = function() {
    this.localUid = null;
  };
  UidGenerator_GetUid_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UidGenerator_GetUid_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UidGenerator_GetUid_ResponseParams.localUid
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UidGenerator_GetUid_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  UidGenerator_GetUid_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new UidGenerator_GetUid_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.localUid =
        decoder.decodeStruct(codec.String);
    return val;
  };

  UidGenerator_GetUid_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UidGenerator_GetUid_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.localUid);
  };
  function NotificationGenerator_ShowNotification_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NotificationGenerator_ShowNotification_Params.prototype.initDefaults_ = function() {
    this.title = null;
    this.message = null;
    this.type = 0;
  };
  NotificationGenerator_ShowNotification_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NotificationGenerator_ShowNotification_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NotificationGenerator_ShowNotification_Params.title
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NotificationGenerator_ShowNotification_Params.message
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NotificationGenerator_ShowNotification_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, WebNotificationType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NotificationGenerator_ShowNotification_Params.encodedSize = codec.kStructHeaderSize + 24;

  NotificationGenerator_ShowNotification_Params.decode = function(decoder) {
    var packed;
    var val = new NotificationGenerator_ShowNotification_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.title =
        decoder.decodeStructPointer(string16$.String16);
    val.message =
        decoder.decodeStructPointer(string16$.String16);
    val.type =
        decoder.decodeStruct(new codec.Enum(WebNotificationType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  NotificationGenerator_ShowNotification_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NotificationGenerator_ShowNotification_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.title);
    encoder.encodeStructPointer(string16$.String16, val.message);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NotificationGenerator_ShowToast_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NotificationGenerator_ShowToast_Params.prototype.initDefaults_ = function() {
    this.text = null;
  };
  NotificationGenerator_ShowToast_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NotificationGenerator_ShowToast_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NotificationGenerator_ShowToast_Params.text
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NotificationGenerator_ShowToast_Params.encodedSize = codec.kStructHeaderSize + 8;

  NotificationGenerator_ShowToast_Params.decode = function(decoder) {
    var packed;
    var val = new NotificationGenerator_ShowToast_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStructPointer(string16$.String16);
    return val;
  };

  NotificationGenerator_ShowToast_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NotificationGenerator_ShowToast_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.text);
  };
  function DisplayStreamHandler_StartStreaming_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DisplayStreamHandler_StartStreaming_Params.prototype.initDefaults_ = function() {
  };
  DisplayStreamHandler_StartStreaming_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DisplayStreamHandler_StartStreaming_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DisplayStreamHandler_StartStreaming_Params.encodedSize = codec.kStructHeaderSize + 0;

  DisplayStreamHandler_StartStreaming_Params.decode = function(decoder) {
    var packed;
    var val = new DisplayStreamHandler_StartStreaming_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  DisplayStreamHandler_StartStreaming_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DisplayStreamHandler_StartStreaming_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function DisplayStreamHandler_OnStreamStatusChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DisplayStreamHandler_OnStreamStatusChanged_Params.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  DisplayStreamHandler_OnStreamStatusChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DisplayStreamHandler_OnStreamStatusChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DisplayStreamHandler_OnStreamStatusChanged_Params.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, StreamStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DisplayStreamHandler_OnStreamStatusChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  DisplayStreamHandler_OnStreamStatusChanged_Params.decode = function(decoder) {
    var packed;
    var val = new DisplayStreamHandler_OnStreamStatusChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(StreamStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DisplayStreamHandler_OnStreamStatusChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DisplayStreamHandler_OnStreamStatusChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DisplayStreamHandler_SetStreamActionObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DisplayStreamHandler_SetStreamActionObserver_Params.prototype.initDefaults_ = function() {
    this.observer = new StreamActionObserverPtr();
  };
  DisplayStreamHandler_SetStreamActionObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DisplayStreamHandler_SetStreamActionObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DisplayStreamHandler_SetStreamActionObserver_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DisplayStreamHandler_SetStreamActionObserver_Params.encodedSize = codec.kStructHeaderSize + 8;

  DisplayStreamHandler_SetStreamActionObserver_Params.decode = function(decoder) {
    var packed;
    var val = new DisplayStreamHandler_SetStreamActionObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observer =
        decoder.decodeStruct(new codec.Interface(StreamActionObserverPtr));
    return val;
  };

  DisplayStreamHandler_SetStreamActionObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DisplayStreamHandler_SetStreamActionObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(StreamActionObserverPtr), val.observer);
  };
  function StreamActionObserver_OnStreamAction_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StreamActionObserver_OnStreamAction_Params.prototype.initDefaults_ = function() {
    this.action = 0;
  };
  StreamActionObserver_OnStreamAction_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StreamActionObserver_OnStreamAction_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate StreamActionObserver_OnStreamAction_Params.action
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, StreamAction);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  StreamActionObserver_OnStreamAction_Params.encodedSize = codec.kStructHeaderSize + 8;

  StreamActionObserver_OnStreamAction_Params.decode = function(decoder) {
    var packed;
    var val = new StreamActionObserver_OnStreamAction_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.action =
        decoder.decodeStruct(new codec.Enum(StreamAction));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  StreamActionObserver_OnStreamAction_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StreamActionObserver_OnStreamAction_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.action);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function StreamOrientationObserver_OnStreamOrientationChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  StreamOrientationObserver_OnStreamOrientationChanged_Params.prototype.initDefaults_ = function() {
    this.isLandscape = false;
  };
  StreamOrientationObserver_OnStreamOrientationChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  StreamOrientationObserver_OnStreamOrientationChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  StreamOrientationObserver_OnStreamOrientationChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  StreamOrientationObserver_OnStreamOrientationChanged_Params.decode = function(decoder) {
    var packed;
    var val = new StreamOrientationObserver_OnStreamOrientationChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isLandscape = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  StreamOrientationObserver_OnStreamOrientationChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(StreamOrientationObserver_OnStreamOrientationChanged_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isLandscape & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ConnectionStatusObserver_OnConnectionStatusChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ConnectionStatusObserver_OnConnectionStatusChanged_Params.prototype.initDefaults_ = function() {
    this.status = 0;
  };
  ConnectionStatusObserver_OnConnectionStatusChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ConnectionStatusObserver_OnConnectionStatusChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ConnectionStatusObserver_OnConnectionStatusChanged_Params.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, ConnectionStatus);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ConnectionStatusObserver_OnConnectionStatusChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  ConnectionStatusObserver_OnConnectionStatusChanged_Params.decode = function(decoder) {
    var packed;
    var val = new ConnectionStatusObserver_OnConnectionStatusChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(ConnectionStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ConnectionStatusObserver_OnConnectionStatusChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ConnectionStatusObserver_OnConnectionStatusChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function KeyboardLayoutHandler_RequestCurrentKeyboardLayout_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  KeyboardLayoutHandler_RequestCurrentKeyboardLayout_Params.prototype.initDefaults_ = function() {
  };
  KeyboardLayoutHandler_RequestCurrentKeyboardLayout_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  KeyboardLayoutHandler_RequestCurrentKeyboardLayout_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  KeyboardLayoutHandler_RequestCurrentKeyboardLayout_Params.encodedSize = codec.kStructHeaderSize + 0;

  KeyboardLayoutHandler_RequestCurrentKeyboardLayout_Params.decode = function(decoder) {
    var packed;
    var val = new KeyboardLayoutHandler_RequestCurrentKeyboardLayout_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  KeyboardLayoutHandler_RequestCurrentKeyboardLayout_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(KeyboardLayoutHandler_RequestCurrentKeyboardLayout_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params.prototype.initDefaults_ = function() {
    this.observer = new KeyboardLayoutObserverPtr();
  };
  KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params.encodedSize = codec.kStructHeaderSize + 8;

  KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params.decode = function(decoder) {
    var packed;
    var val = new KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observer =
        decoder.decodeStruct(new codec.Interface(KeyboardLayoutObserverPtr));
    return val;
  };

  KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(KeyboardLayoutObserverPtr), val.observer);
  };
  function KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params.prototype.initDefaults_ = function() {
    this.id = null;
    this.longName = null;
    this.shortName = null;
    this.layoutTag = null;
  };
  KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params.longName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params.shortName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params.layoutTag
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params.encodedSize = codec.kStructHeaderSize + 32;

  KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params.decode = function(decoder) {
    var packed;
    var val = new KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.String);
    val.longName =
        decoder.decodeStruct(codec.String);
    val.shortName =
        decoder.decodeStruct(codec.String);
    val.layoutTag =
        decoder.decodeStruct(codec.String);
    return val;
  };

  KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.id);
    encoder.encodeStruct(codec.String, val.longName);
    encoder.encodeStruct(codec.String, val.shortName);
    encoder.encodeStruct(codec.String, val.layoutTag);
  };
  var kSignalingMessageExchanger_SendSignalingMessage_Name = 0;
  var kSignalingMessageExchanger_SetSignalingMessageObserver_Name = 1;
  var kSignalingMessageExchanger_TearDownSignaling_Name = 2;

  function SignalingMessageExchangerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SignalingMessageExchanger,
                                                   handleOrPtrInfo);
  }

  function SignalingMessageExchangerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SignalingMessageExchanger, associatedInterfacePtrInfo);
  }

  SignalingMessageExchangerAssociatedPtr.prototype =
      Object.create(SignalingMessageExchangerPtr.prototype);
  SignalingMessageExchangerAssociatedPtr.prototype.constructor =
      SignalingMessageExchangerAssociatedPtr;

  function SignalingMessageExchangerProxy(receiver) {
    this.receiver_ = receiver;
  }
  SignalingMessageExchangerPtr.prototype.sendSignalingMessage = function() {
    return SignalingMessageExchangerProxy.prototype.sendSignalingMessage
        .apply(this.ptr.getProxy(), arguments);
  };

  SignalingMessageExchangerProxy.prototype.sendSignalingMessage = function(signal) {
    var params_ = new SignalingMessageExchanger_SendSignalingMessage_Params();
    params_.signal = signal;
    var builder = new codec.MessageV0Builder(
        kSignalingMessageExchanger_SendSignalingMessage_Name,
        codec.align(SignalingMessageExchanger_SendSignalingMessage_Params.encodedSize));
    builder.encodeStruct(SignalingMessageExchanger_SendSignalingMessage_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SignalingMessageExchangerPtr.prototype.setSignalingMessageObserver = function() {
    return SignalingMessageExchangerProxy.prototype.setSignalingMessageObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  SignalingMessageExchangerProxy.prototype.setSignalingMessageObserver = function(observer) {
    var params_ = new SignalingMessageExchanger_SetSignalingMessageObserver_Params();
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kSignalingMessageExchanger_SetSignalingMessageObserver_Name,
        codec.align(SignalingMessageExchanger_SetSignalingMessageObserver_Params.encodedSize));
    builder.encodeStruct(SignalingMessageExchanger_SetSignalingMessageObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SignalingMessageExchangerPtr.prototype.tearDownSignaling = function() {
    return SignalingMessageExchangerProxy.prototype.tearDownSignaling
        .apply(this.ptr.getProxy(), arguments);
  };

  SignalingMessageExchangerProxy.prototype.tearDownSignaling = function() {
    var params_ = new SignalingMessageExchanger_TearDownSignaling_Params();
    var builder = new codec.MessageV0Builder(
        kSignalingMessageExchanger_TearDownSignaling_Name,
        codec.align(SignalingMessageExchanger_TearDownSignaling_Params.encodedSize));
    builder.encodeStruct(SignalingMessageExchanger_TearDownSignaling_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SignalingMessageExchangerStub(delegate) {
    this.delegate_ = delegate;
  }
  SignalingMessageExchangerStub.prototype.sendSignalingMessage = function(signal) {
    return this.delegate_ && this.delegate_.sendSignalingMessage && this.delegate_.sendSignalingMessage(signal);
  }
  SignalingMessageExchangerStub.prototype.setSignalingMessageObserver = function(observer) {
    return this.delegate_ && this.delegate_.setSignalingMessageObserver && this.delegate_.setSignalingMessageObserver(observer);
  }
  SignalingMessageExchangerStub.prototype.tearDownSignaling = function() {
    return this.delegate_ && this.delegate_.tearDownSignaling && this.delegate_.tearDownSignaling();
  }

  SignalingMessageExchangerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSignalingMessageExchanger_SendSignalingMessage_Name:
      var params = reader.decodeStruct(SignalingMessageExchanger_SendSignalingMessage_Params);
      this.sendSignalingMessage(params.signal);
      return true;
    case kSignalingMessageExchanger_SetSignalingMessageObserver_Name:
      var params = reader.decodeStruct(SignalingMessageExchanger_SetSignalingMessageObserver_Params);
      this.setSignalingMessageObserver(params.observer);
      return true;
    case kSignalingMessageExchanger_TearDownSignaling_Name:
      var params = reader.decodeStruct(SignalingMessageExchanger_TearDownSignaling_Params);
      this.tearDownSignaling();
      return true;
    default:
      return false;
    }
  };

  SignalingMessageExchangerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSignalingMessageExchangerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSignalingMessageExchanger_SendSignalingMessage_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SignalingMessageExchanger_SendSignalingMessage_Params;
      break;
      case kSignalingMessageExchanger_SetSignalingMessageObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SignalingMessageExchanger_SetSignalingMessageObserver_Params;
      break;
      case kSignalingMessageExchanger_TearDownSignaling_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SignalingMessageExchanger_TearDownSignaling_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSignalingMessageExchangerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SignalingMessageExchanger = {
    name: 'ash.eche_app.mojom.SignalingMessageExchanger',
    kVersion: 0,
    ptrClass: SignalingMessageExchangerPtr,
    proxyClass: SignalingMessageExchangerProxy,
    stubClass: SignalingMessageExchangerStub,
    validateRequest: validateSignalingMessageExchangerRequest,
    validateResponse: null,
  };
  SignalingMessageExchangerStub.prototype.validator = validateSignalingMessageExchangerRequest;
  SignalingMessageExchangerProxy.prototype.validator = null;
  var kSignalingMessageObserver_OnReceivedSignalingMessage_Name = 0;

  function SignalingMessageObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SignalingMessageObserver,
                                                   handleOrPtrInfo);
  }

  function SignalingMessageObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SignalingMessageObserver, associatedInterfacePtrInfo);
  }

  SignalingMessageObserverAssociatedPtr.prototype =
      Object.create(SignalingMessageObserverPtr.prototype);
  SignalingMessageObserverAssociatedPtr.prototype.constructor =
      SignalingMessageObserverAssociatedPtr;

  function SignalingMessageObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  SignalingMessageObserverPtr.prototype.onReceivedSignalingMessage = function() {
    return SignalingMessageObserverProxy.prototype.onReceivedSignalingMessage
        .apply(this.ptr.getProxy(), arguments);
  };

  SignalingMessageObserverProxy.prototype.onReceivedSignalingMessage = function(signal) {
    var params_ = new SignalingMessageObserver_OnReceivedSignalingMessage_Params();
    params_.signal = signal;
    var builder = new codec.MessageV0Builder(
        kSignalingMessageObserver_OnReceivedSignalingMessage_Name,
        codec.align(SignalingMessageObserver_OnReceivedSignalingMessage_Params.encodedSize));
    builder.encodeStruct(SignalingMessageObserver_OnReceivedSignalingMessage_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SignalingMessageObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  SignalingMessageObserverStub.prototype.onReceivedSignalingMessage = function(signal) {
    return this.delegate_ && this.delegate_.onReceivedSignalingMessage && this.delegate_.onReceivedSignalingMessage(signal);
  }

  SignalingMessageObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSignalingMessageObserver_OnReceivedSignalingMessage_Name:
      var params = reader.decodeStruct(SignalingMessageObserver_OnReceivedSignalingMessage_Params);
      this.onReceivedSignalingMessage(params.signal);
      return true;
    default:
      return false;
    }
  };

  SignalingMessageObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSignalingMessageObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSignalingMessageObserver_OnReceivedSignalingMessage_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SignalingMessageObserver_OnReceivedSignalingMessage_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSignalingMessageObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SignalingMessageObserver = {
    name: 'ash.eche_app.mojom.SignalingMessageObserver',
    kVersion: 0,
    ptrClass: SignalingMessageObserverPtr,
    proxyClass: SignalingMessageObserverProxy,
    stubClass: SignalingMessageObserverStub,
    validateRequest: validateSignalingMessageObserverRequest,
    validateResponse: null,
  };
  SignalingMessageObserverStub.prototype.validator = validateSignalingMessageObserverRequest;
  SignalingMessageObserverProxy.prototype.validator = null;
  var kSystemInfoProvider_GetSystemInfo_Name = 0;
  var kSystemInfoProvider_SetSystemInfoObserver_Name = 1;

  function SystemInfoProviderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SystemInfoProvider,
                                                   handleOrPtrInfo);
  }

  function SystemInfoProviderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SystemInfoProvider, associatedInterfacePtrInfo);
  }

  SystemInfoProviderAssociatedPtr.prototype =
      Object.create(SystemInfoProviderPtr.prototype);
  SystemInfoProviderAssociatedPtr.prototype.constructor =
      SystemInfoProviderAssociatedPtr;

  function SystemInfoProviderProxy(receiver) {
    this.receiver_ = receiver;
  }
  SystemInfoProviderPtr.prototype.getSystemInfo = function() {
    return SystemInfoProviderProxy.prototype.getSystemInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  SystemInfoProviderProxy.prototype.getSystemInfo = function() {
    var params_ = new SystemInfoProvider_GetSystemInfo_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kSystemInfoProvider_GetSystemInfo_Name,
          codec.align(SystemInfoProvider_GetSystemInfo_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(SystemInfoProvider_GetSystemInfo_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(SystemInfoProvider_GetSystemInfo_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  SystemInfoProviderPtr.prototype.setSystemInfoObserver = function() {
    return SystemInfoProviderProxy.prototype.setSystemInfoObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  SystemInfoProviderProxy.prototype.setSystemInfoObserver = function(observer) {
    var params_ = new SystemInfoProvider_SetSystemInfoObserver_Params();
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kSystemInfoProvider_SetSystemInfoObserver_Name,
        codec.align(SystemInfoProvider_SetSystemInfoObserver_Params.encodedSize));
    builder.encodeStruct(SystemInfoProvider_SetSystemInfoObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SystemInfoProviderStub(delegate) {
    this.delegate_ = delegate;
  }
  SystemInfoProviderStub.prototype.getSystemInfo = function() {
    return this.delegate_ && this.delegate_.getSystemInfo && this.delegate_.getSystemInfo();
  }
  SystemInfoProviderStub.prototype.setSystemInfoObserver = function(observer) {
    return this.delegate_ && this.delegate_.setSystemInfoObserver && this.delegate_.setSystemInfoObserver(observer);
  }

  SystemInfoProviderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSystemInfoProvider_SetSystemInfoObserver_Name:
      var params = reader.decodeStruct(SystemInfoProvider_SetSystemInfoObserver_Params);
      this.setSystemInfoObserver(params.observer);
      return true;
    default:
      return false;
    }
  };

  SystemInfoProviderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSystemInfoProvider_GetSystemInfo_Name:
      var params = reader.decodeStruct(SystemInfoProvider_GetSystemInfo_Params);
      this.getSystemInfo().then(function(response) {
        var responseParams =
            new SystemInfoProvider_GetSystemInfo_ResponseParams();
        responseParams.systemInfo = response.systemInfo;
        var builder = new codec.MessageV1Builder(
            kSystemInfoProvider_GetSystemInfo_Name,
            codec.align(SystemInfoProvider_GetSystemInfo_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(SystemInfoProvider_GetSystemInfo_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateSystemInfoProviderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSystemInfoProvider_GetSystemInfo_Name:
        if (message.expectsResponse())
          paramsClass = SystemInfoProvider_GetSystemInfo_Params;
      break;
      case kSystemInfoProvider_SetSystemInfoObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SystemInfoProvider_SetSystemInfoObserver_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSystemInfoProviderResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kSystemInfoProvider_GetSystemInfo_Name:
        if (message.isResponse())
          paramsClass = SystemInfoProvider_GetSystemInfo_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var SystemInfoProvider = {
    name: 'ash.eche_app.mojom.SystemInfoProvider',
    kVersion: 0,
    ptrClass: SystemInfoProviderPtr,
    proxyClass: SystemInfoProviderProxy,
    stubClass: SystemInfoProviderStub,
    validateRequest: validateSystemInfoProviderRequest,
    validateResponse: validateSystemInfoProviderResponse,
  };
  SystemInfoProviderStub.prototype.validator = validateSystemInfoProviderRequest;
  SystemInfoProviderProxy.prototype.validator = validateSystemInfoProviderResponse;
  var kSystemInfoObserver_OnScreenBacklightStateChanged_Name = 0;
  var kSystemInfoObserver_OnReceivedTabletModeChanged_Name = 1;
  var kSystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Name = 2;

  function SystemInfoObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SystemInfoObserver,
                                                   handleOrPtrInfo);
  }

  function SystemInfoObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SystemInfoObserver, associatedInterfacePtrInfo);
  }

  SystemInfoObserverAssociatedPtr.prototype =
      Object.create(SystemInfoObserverPtr.prototype);
  SystemInfoObserverAssociatedPtr.prototype.constructor =
      SystemInfoObserverAssociatedPtr;

  function SystemInfoObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  SystemInfoObserverPtr.prototype.onScreenBacklightStateChanged = function() {
    return SystemInfoObserverProxy.prototype.onScreenBacklightStateChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  SystemInfoObserverProxy.prototype.onScreenBacklightStateChanged = function(state) {
    var params_ = new SystemInfoObserver_OnScreenBacklightStateChanged_Params();
    params_.state = state;
    var builder = new codec.MessageV0Builder(
        kSystemInfoObserver_OnScreenBacklightStateChanged_Name,
        codec.align(SystemInfoObserver_OnScreenBacklightStateChanged_Params.encodedSize));
    builder.encodeStruct(SystemInfoObserver_OnScreenBacklightStateChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SystemInfoObserverPtr.prototype.onReceivedTabletModeChanged = function() {
    return SystemInfoObserverProxy.prototype.onReceivedTabletModeChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  SystemInfoObserverProxy.prototype.onReceivedTabletModeChanged = function(isTabletMode) {
    var params_ = new SystemInfoObserver_OnReceivedTabletModeChanged_Params();
    params_.isTabletMode = isTabletMode;
    var builder = new codec.MessageV0Builder(
        kSystemInfoObserver_OnReceivedTabletModeChanged_Name,
        codec.align(SystemInfoObserver_OnReceivedTabletModeChanged_Params.encodedSize));
    builder.encodeStruct(SystemInfoObserver_OnReceivedTabletModeChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SystemInfoObserverPtr.prototype.onAndroidDeviceNetworkInfoChanged = function() {
    return SystemInfoObserverProxy.prototype.onAndroidDeviceNetworkInfoChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  SystemInfoObserverProxy.prototype.onAndroidDeviceNetworkInfoChanged = function(isDifferentNetwork, androidDeviceOnCellular) {
    var params_ = new SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Params();
    params_.isDifferentNetwork = isDifferentNetwork;
    params_.androidDeviceOnCellular = androidDeviceOnCellular;
    var builder = new codec.MessageV0Builder(
        kSystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Name,
        codec.align(SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Params.encodedSize));
    builder.encodeStruct(SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SystemInfoObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  SystemInfoObserverStub.prototype.onScreenBacklightStateChanged = function(state) {
    return this.delegate_ && this.delegate_.onScreenBacklightStateChanged && this.delegate_.onScreenBacklightStateChanged(state);
  }
  SystemInfoObserverStub.prototype.onReceivedTabletModeChanged = function(isTabletMode) {
    return this.delegate_ && this.delegate_.onReceivedTabletModeChanged && this.delegate_.onReceivedTabletModeChanged(isTabletMode);
  }
  SystemInfoObserverStub.prototype.onAndroidDeviceNetworkInfoChanged = function(isDifferentNetwork, androidDeviceOnCellular) {
    return this.delegate_ && this.delegate_.onAndroidDeviceNetworkInfoChanged && this.delegate_.onAndroidDeviceNetworkInfoChanged(isDifferentNetwork, androidDeviceOnCellular);
  }

  SystemInfoObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSystemInfoObserver_OnScreenBacklightStateChanged_Name:
      var params = reader.decodeStruct(SystemInfoObserver_OnScreenBacklightStateChanged_Params);
      this.onScreenBacklightStateChanged(params.state);
      return true;
    case kSystemInfoObserver_OnReceivedTabletModeChanged_Name:
      var params = reader.decodeStruct(SystemInfoObserver_OnReceivedTabletModeChanged_Params);
      this.onReceivedTabletModeChanged(params.isTabletMode);
      return true;
    case kSystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Name:
      var params = reader.decodeStruct(SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Params);
      this.onAndroidDeviceNetworkInfoChanged(params.isDifferentNetwork, params.androidDeviceOnCellular);
      return true;
    default:
      return false;
    }
  };

  SystemInfoObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSystemInfoObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSystemInfoObserver_OnScreenBacklightStateChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SystemInfoObserver_OnScreenBacklightStateChanged_Params;
      break;
      case kSystemInfoObserver_OnReceivedTabletModeChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SystemInfoObserver_OnReceivedTabletModeChanged_Params;
      break;
      case kSystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSystemInfoObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SystemInfoObserver = {
    name: 'ash.eche_app.mojom.SystemInfoObserver',
    kVersion: 0,
    ptrClass: SystemInfoObserverPtr,
    proxyClass: SystemInfoObserverProxy,
    stubClass: SystemInfoObserverStub,
    validateRequest: validateSystemInfoObserverRequest,
    validateResponse: null,
  };
  SystemInfoObserverStub.prototype.validator = validateSystemInfoObserverRequest;
  SystemInfoObserverProxy.prototype.validator = null;
  var kAccessibilityProvider_HandleAccessibilityEventReceived_Name = 0;
  var kAccessibilityProvider_SetAccessibilityObserver_Name = 1;
  var kAccessibilityProvider_IsAccessibilityEnabled_Name = 2;

  function AccessibilityProviderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AccessibilityProvider,
                                                   handleOrPtrInfo);
  }

  function AccessibilityProviderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AccessibilityProvider, associatedInterfacePtrInfo);
  }

  AccessibilityProviderAssociatedPtr.prototype =
      Object.create(AccessibilityProviderPtr.prototype);
  AccessibilityProviderAssociatedPtr.prototype.constructor =
      AccessibilityProviderAssociatedPtr;

  function AccessibilityProviderProxy(receiver) {
    this.receiver_ = receiver;
  }
  AccessibilityProviderPtr.prototype.handleAccessibilityEventReceived = function() {
    return AccessibilityProviderProxy.prototype.handleAccessibilityEventReceived
        .apply(this.ptr.getProxy(), arguments);
  };

  AccessibilityProviderProxy.prototype.handleAccessibilityEventReceived = function(serializedProto) {
    var params_ = new AccessibilityProvider_HandleAccessibilityEventReceived_Params();
    params_.serializedProto = serializedProto;
    var builder = new codec.MessageV0Builder(
        kAccessibilityProvider_HandleAccessibilityEventReceived_Name,
        codec.align(AccessibilityProvider_HandleAccessibilityEventReceived_Params.encodedSize));
    builder.encodeStruct(AccessibilityProvider_HandleAccessibilityEventReceived_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AccessibilityProviderPtr.prototype.setAccessibilityObserver = function() {
    return AccessibilityProviderProxy.prototype.setAccessibilityObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  AccessibilityProviderProxy.prototype.setAccessibilityObserver = function(observer) {
    var params_ = new AccessibilityProvider_SetAccessibilityObserver_Params();
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kAccessibilityProvider_SetAccessibilityObserver_Name,
        codec.align(AccessibilityProvider_SetAccessibilityObserver_Params.encodedSize));
    builder.encodeStruct(AccessibilityProvider_SetAccessibilityObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AccessibilityProviderPtr.prototype.isAccessibilityEnabled = function() {
    return AccessibilityProviderProxy.prototype.isAccessibilityEnabled
        .apply(this.ptr.getProxy(), arguments);
  };

  AccessibilityProviderProxy.prototype.isAccessibilityEnabled = function() {
    var params_ = new AccessibilityProvider_IsAccessibilityEnabled_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAccessibilityProvider_IsAccessibilityEnabled_Name,
          codec.align(AccessibilityProvider_IsAccessibilityEnabled_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AccessibilityProvider_IsAccessibilityEnabled_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AccessibilityProvider_IsAccessibilityEnabled_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function AccessibilityProviderStub(delegate) {
    this.delegate_ = delegate;
  }
  AccessibilityProviderStub.prototype.handleAccessibilityEventReceived = function(serializedProto) {
    return this.delegate_ && this.delegate_.handleAccessibilityEventReceived && this.delegate_.handleAccessibilityEventReceived(serializedProto);
  }
  AccessibilityProviderStub.prototype.setAccessibilityObserver = function(observer) {
    return this.delegate_ && this.delegate_.setAccessibilityObserver && this.delegate_.setAccessibilityObserver(observer);
  }
  AccessibilityProviderStub.prototype.isAccessibilityEnabled = function() {
    return this.delegate_ && this.delegate_.isAccessibilityEnabled && this.delegate_.isAccessibilityEnabled();
  }

  AccessibilityProviderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAccessibilityProvider_HandleAccessibilityEventReceived_Name:
      var params = reader.decodeStruct(AccessibilityProvider_HandleAccessibilityEventReceived_Params);
      this.handleAccessibilityEventReceived(params.serializedProto);
      return true;
    case kAccessibilityProvider_SetAccessibilityObserver_Name:
      var params = reader.decodeStruct(AccessibilityProvider_SetAccessibilityObserver_Params);
      this.setAccessibilityObserver(params.observer);
      return true;
    default:
      return false;
    }
  };

  AccessibilityProviderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAccessibilityProvider_IsAccessibilityEnabled_Name:
      var params = reader.decodeStruct(AccessibilityProvider_IsAccessibilityEnabled_Params);
      this.isAccessibilityEnabled().then(function(response) {
        var responseParams =
            new AccessibilityProvider_IsAccessibilityEnabled_ResponseParams();
        responseParams.enabled = response.enabled;
        var builder = new codec.MessageV1Builder(
            kAccessibilityProvider_IsAccessibilityEnabled_Name,
            codec.align(AccessibilityProvider_IsAccessibilityEnabled_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AccessibilityProvider_IsAccessibilityEnabled_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateAccessibilityProviderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAccessibilityProvider_HandleAccessibilityEventReceived_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AccessibilityProvider_HandleAccessibilityEventReceived_Params;
      break;
      case kAccessibilityProvider_SetAccessibilityObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AccessibilityProvider_SetAccessibilityObserver_Params;
      break;
      case kAccessibilityProvider_IsAccessibilityEnabled_Name:
        if (message.expectsResponse())
          paramsClass = AccessibilityProvider_IsAccessibilityEnabled_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAccessibilityProviderResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kAccessibilityProvider_IsAccessibilityEnabled_Name:
        if (message.isResponse())
          paramsClass = AccessibilityProvider_IsAccessibilityEnabled_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var AccessibilityProvider = {
    name: 'ash.eche_app.mojom.AccessibilityProvider',
    kVersion: 0,
    ptrClass: AccessibilityProviderPtr,
    proxyClass: AccessibilityProviderProxy,
    stubClass: AccessibilityProviderStub,
    validateRequest: validateAccessibilityProviderRequest,
    validateResponse: validateAccessibilityProviderResponse,
  };
  AccessibilityProviderStub.prototype.validator = validateAccessibilityProviderRequest;
  AccessibilityProviderProxy.prototype.validator = validateAccessibilityProviderResponse;
  var kAccessibilityObserver_EnableAccessibilityTreeStreaming_Name = 0;
  var kAccessibilityObserver_EnableExploreByTouch_Name = 1;
  var kAccessibilityObserver_PerformAction_Name = 2;
  var kAccessibilityObserver_RefreshWithExtraData_Name = 3;

  function AccessibilityObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AccessibilityObserver,
                                                   handleOrPtrInfo);
  }

  function AccessibilityObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AccessibilityObserver, associatedInterfacePtrInfo);
  }

  AccessibilityObserverAssociatedPtr.prototype =
      Object.create(AccessibilityObserverPtr.prototype);
  AccessibilityObserverAssociatedPtr.prototype.constructor =
      AccessibilityObserverAssociatedPtr;

  function AccessibilityObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  AccessibilityObserverPtr.prototype.enableAccessibilityTreeStreaming = function() {
    return AccessibilityObserverProxy.prototype.enableAccessibilityTreeStreaming
        .apply(this.ptr.getProxy(), arguments);
  };

  AccessibilityObserverProxy.prototype.enableAccessibilityTreeStreaming = function(enable) {
    var params_ = new AccessibilityObserver_EnableAccessibilityTreeStreaming_Params();
    params_.enable = enable;
    var builder = new codec.MessageV0Builder(
        kAccessibilityObserver_EnableAccessibilityTreeStreaming_Name,
        codec.align(AccessibilityObserver_EnableAccessibilityTreeStreaming_Params.encodedSize));
    builder.encodeStruct(AccessibilityObserver_EnableAccessibilityTreeStreaming_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AccessibilityObserverPtr.prototype.enableExploreByTouch = function() {
    return AccessibilityObserverProxy.prototype.enableExploreByTouch
        .apply(this.ptr.getProxy(), arguments);
  };

  AccessibilityObserverProxy.prototype.enableExploreByTouch = function(enable) {
    var params_ = new AccessibilityObserver_EnableExploreByTouch_Params();
    params_.enable = enable;
    var builder = new codec.MessageV0Builder(
        kAccessibilityObserver_EnableExploreByTouch_Name,
        codec.align(AccessibilityObserver_EnableExploreByTouch_Params.encodedSize));
    builder.encodeStruct(AccessibilityObserver_EnableExploreByTouch_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AccessibilityObserverPtr.prototype.performAction = function() {
    return AccessibilityObserverProxy.prototype.performAction
        .apply(this.ptr.getProxy(), arguments);
  };

  AccessibilityObserverProxy.prototype.performAction = function(serializedProto) {
    var params_ = new AccessibilityObserver_PerformAction_Params();
    params_.serializedProto = serializedProto;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAccessibilityObserver_PerformAction_Name,
          codec.align(AccessibilityObserver_PerformAction_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AccessibilityObserver_PerformAction_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AccessibilityObserver_PerformAction_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AccessibilityObserverPtr.prototype.refreshWithExtraData = function() {
    return AccessibilityObserverProxy.prototype.refreshWithExtraData
        .apply(this.ptr.getProxy(), arguments);
  };

  AccessibilityObserverProxy.prototype.refreshWithExtraData = function(refreshDataProto) {
    var params_ = new AccessibilityObserver_RefreshWithExtraData_Params();
    params_.refreshDataProto = refreshDataProto;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAccessibilityObserver_RefreshWithExtraData_Name,
          codec.align(AccessibilityObserver_RefreshWithExtraData_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AccessibilityObserver_RefreshWithExtraData_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AccessibilityObserver_RefreshWithExtraData_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function AccessibilityObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  AccessibilityObserverStub.prototype.enableAccessibilityTreeStreaming = function(enable) {
    return this.delegate_ && this.delegate_.enableAccessibilityTreeStreaming && this.delegate_.enableAccessibilityTreeStreaming(enable);
  }
  AccessibilityObserverStub.prototype.enableExploreByTouch = function(enable) {
    return this.delegate_ && this.delegate_.enableExploreByTouch && this.delegate_.enableExploreByTouch(enable);
  }
  AccessibilityObserverStub.prototype.performAction = function(serializedProto) {
    return this.delegate_ && this.delegate_.performAction && this.delegate_.performAction(serializedProto);
  }
  AccessibilityObserverStub.prototype.refreshWithExtraData = function(refreshDataProto) {
    return this.delegate_ && this.delegate_.refreshWithExtraData && this.delegate_.refreshWithExtraData(refreshDataProto);
  }

  AccessibilityObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAccessibilityObserver_EnableAccessibilityTreeStreaming_Name:
      var params = reader.decodeStruct(AccessibilityObserver_EnableAccessibilityTreeStreaming_Params);
      this.enableAccessibilityTreeStreaming(params.enable);
      return true;
    case kAccessibilityObserver_EnableExploreByTouch_Name:
      var params = reader.decodeStruct(AccessibilityObserver_EnableExploreByTouch_Params);
      this.enableExploreByTouch(params.enable);
      return true;
    default:
      return false;
    }
  };

  AccessibilityObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAccessibilityObserver_PerformAction_Name:
      var params = reader.decodeStruct(AccessibilityObserver_PerformAction_Params);
      this.performAction(params.serializedProto).then(function(response) {
        var responseParams =
            new AccessibilityObserver_PerformAction_ResponseParams();
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kAccessibilityObserver_PerformAction_Name,
            codec.align(AccessibilityObserver_PerformAction_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AccessibilityObserver_PerformAction_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kAccessibilityObserver_RefreshWithExtraData_Name:
      var params = reader.decodeStruct(AccessibilityObserver_RefreshWithExtraData_Params);
      this.refreshWithExtraData(params.refreshDataProto).then(function(response) {
        var responseParams =
            new AccessibilityObserver_RefreshWithExtraData_ResponseParams();
        responseParams.textLocationProto = response.textLocationProto;
        var builder = new codec.MessageV1Builder(
            kAccessibilityObserver_RefreshWithExtraData_Name,
            codec.align(AccessibilityObserver_RefreshWithExtraData_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AccessibilityObserver_RefreshWithExtraData_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateAccessibilityObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAccessibilityObserver_EnableAccessibilityTreeStreaming_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AccessibilityObserver_EnableAccessibilityTreeStreaming_Params;
      break;
      case kAccessibilityObserver_EnableExploreByTouch_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AccessibilityObserver_EnableExploreByTouch_Params;
      break;
      case kAccessibilityObserver_PerformAction_Name:
        if (message.expectsResponse())
          paramsClass = AccessibilityObserver_PerformAction_Params;
      break;
      case kAccessibilityObserver_RefreshWithExtraData_Name:
        if (message.expectsResponse())
          paramsClass = AccessibilityObserver_RefreshWithExtraData_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAccessibilityObserverResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kAccessibilityObserver_PerformAction_Name:
        if (message.isResponse())
          paramsClass = AccessibilityObserver_PerformAction_ResponseParams;
        break;
      case kAccessibilityObserver_RefreshWithExtraData_Name:
        if (message.isResponse())
          paramsClass = AccessibilityObserver_RefreshWithExtraData_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var AccessibilityObserver = {
    name: 'ash.eche_app.mojom.AccessibilityObserver',
    kVersion: 0,
    ptrClass: AccessibilityObserverPtr,
    proxyClass: AccessibilityObserverProxy,
    stubClass: AccessibilityObserverStub,
    validateRequest: validateAccessibilityObserverRequest,
    validateResponse: validateAccessibilityObserverResponse,
  };
  AccessibilityObserverStub.prototype.validator = validateAccessibilityObserverRequest;
  AccessibilityObserverProxy.prototype.validator = validateAccessibilityObserverResponse;
  var kUidGenerator_GetUid_Name = 0;

  function UidGeneratorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(UidGenerator,
                                                   handleOrPtrInfo);
  }

  function UidGeneratorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        UidGenerator, associatedInterfacePtrInfo);
  }

  UidGeneratorAssociatedPtr.prototype =
      Object.create(UidGeneratorPtr.prototype);
  UidGeneratorAssociatedPtr.prototype.constructor =
      UidGeneratorAssociatedPtr;

  function UidGeneratorProxy(receiver) {
    this.receiver_ = receiver;
  }
  UidGeneratorPtr.prototype.getUid = function() {
    return UidGeneratorProxy.prototype.getUid
        .apply(this.ptr.getProxy(), arguments);
  };

  UidGeneratorProxy.prototype.getUid = function() {
    var params_ = new UidGenerator_GetUid_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kUidGenerator_GetUid_Name,
          codec.align(UidGenerator_GetUid_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(UidGenerator_GetUid_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(UidGenerator_GetUid_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function UidGeneratorStub(delegate) {
    this.delegate_ = delegate;
  }
  UidGeneratorStub.prototype.getUid = function() {
    return this.delegate_ && this.delegate_.getUid && this.delegate_.getUid();
  }

  UidGeneratorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  UidGeneratorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kUidGenerator_GetUid_Name:
      var params = reader.decodeStruct(UidGenerator_GetUid_Params);
      this.getUid().then(function(response) {
        var responseParams =
            new UidGenerator_GetUid_ResponseParams();
        responseParams.localUid = response.localUid;
        var builder = new codec.MessageV1Builder(
            kUidGenerator_GetUid_Name,
            codec.align(UidGenerator_GetUid_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(UidGenerator_GetUid_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateUidGeneratorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kUidGenerator_GetUid_Name:
        if (message.expectsResponse())
          paramsClass = UidGenerator_GetUid_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateUidGeneratorResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kUidGenerator_GetUid_Name:
        if (message.isResponse())
          paramsClass = UidGenerator_GetUid_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var UidGenerator = {
    name: 'ash.eche_app.mojom.UidGenerator',
    kVersion: 0,
    ptrClass: UidGeneratorPtr,
    proxyClass: UidGeneratorProxy,
    stubClass: UidGeneratorStub,
    validateRequest: validateUidGeneratorRequest,
    validateResponse: validateUidGeneratorResponse,
  };
  UidGeneratorStub.prototype.validator = validateUidGeneratorRequest;
  UidGeneratorProxy.prototype.validator = validateUidGeneratorResponse;
  var kNotificationGenerator_ShowNotification_Name = 0;
  var kNotificationGenerator_ShowToast_Name = 1;

  function NotificationGeneratorPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(NotificationGenerator,
                                                   handleOrPtrInfo);
  }

  function NotificationGeneratorAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        NotificationGenerator, associatedInterfacePtrInfo);
  }

  NotificationGeneratorAssociatedPtr.prototype =
      Object.create(NotificationGeneratorPtr.prototype);
  NotificationGeneratorAssociatedPtr.prototype.constructor =
      NotificationGeneratorAssociatedPtr;

  function NotificationGeneratorProxy(receiver) {
    this.receiver_ = receiver;
  }
  NotificationGeneratorPtr.prototype.showNotification = function() {
    return NotificationGeneratorProxy.prototype.showNotification
        .apply(this.ptr.getProxy(), arguments);
  };

  NotificationGeneratorProxy.prototype.showNotification = function(title, message, type) {
    var params_ = new NotificationGenerator_ShowNotification_Params();
    params_.title = title;
    params_.message = message;
    params_.type = type;
    var builder = new codec.MessageV0Builder(
        kNotificationGenerator_ShowNotification_Name,
        codec.align(NotificationGenerator_ShowNotification_Params.encodedSize));
    builder.encodeStruct(NotificationGenerator_ShowNotification_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  NotificationGeneratorPtr.prototype.showToast = function() {
    return NotificationGeneratorProxy.prototype.showToast
        .apply(this.ptr.getProxy(), arguments);
  };

  NotificationGeneratorProxy.prototype.showToast = function(text) {
    var params_ = new NotificationGenerator_ShowToast_Params();
    params_.text = text;
    var builder = new codec.MessageV0Builder(
        kNotificationGenerator_ShowToast_Name,
        codec.align(NotificationGenerator_ShowToast_Params.encodedSize));
    builder.encodeStruct(NotificationGenerator_ShowToast_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function NotificationGeneratorStub(delegate) {
    this.delegate_ = delegate;
  }
  NotificationGeneratorStub.prototype.showNotification = function(title, message, type) {
    return this.delegate_ && this.delegate_.showNotification && this.delegate_.showNotification(title, message, type);
  }
  NotificationGeneratorStub.prototype.showToast = function(text) {
    return this.delegate_ && this.delegate_.showToast && this.delegate_.showToast(text);
  }

  NotificationGeneratorStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kNotificationGenerator_ShowNotification_Name:
      var params = reader.decodeStruct(NotificationGenerator_ShowNotification_Params);
      this.showNotification(params.title, params.message, params.type);
      return true;
    case kNotificationGenerator_ShowToast_Name:
      var params = reader.decodeStruct(NotificationGenerator_ShowToast_Params);
      this.showToast(params.text);
      return true;
    default:
      return false;
    }
  };

  NotificationGeneratorStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateNotificationGeneratorRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kNotificationGenerator_ShowNotification_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NotificationGenerator_ShowNotification_Params;
      break;
      case kNotificationGenerator_ShowToast_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = NotificationGenerator_ShowToast_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateNotificationGeneratorResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var NotificationGenerator = {
    name: 'ash.eche_app.mojom.NotificationGenerator',
    kVersion: 0,
    ptrClass: NotificationGeneratorPtr,
    proxyClass: NotificationGeneratorProxy,
    stubClass: NotificationGeneratorStub,
    validateRequest: validateNotificationGeneratorRequest,
    validateResponse: null,
  };
  NotificationGeneratorStub.prototype.validator = validateNotificationGeneratorRequest;
  NotificationGeneratorProxy.prototype.validator = null;
  var kDisplayStreamHandler_StartStreaming_Name = 0;
  var kDisplayStreamHandler_OnStreamStatusChanged_Name = 1;
  var kDisplayStreamHandler_SetStreamActionObserver_Name = 2;

  function DisplayStreamHandlerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(DisplayStreamHandler,
                                                   handleOrPtrInfo);
  }

  function DisplayStreamHandlerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        DisplayStreamHandler, associatedInterfacePtrInfo);
  }

  DisplayStreamHandlerAssociatedPtr.prototype =
      Object.create(DisplayStreamHandlerPtr.prototype);
  DisplayStreamHandlerAssociatedPtr.prototype.constructor =
      DisplayStreamHandlerAssociatedPtr;

  function DisplayStreamHandlerProxy(receiver) {
    this.receiver_ = receiver;
  }
  DisplayStreamHandlerPtr.prototype.startStreaming = function() {
    return DisplayStreamHandlerProxy.prototype.startStreaming
        .apply(this.ptr.getProxy(), arguments);
  };

  DisplayStreamHandlerProxy.prototype.startStreaming = function() {
    var params_ = new DisplayStreamHandler_StartStreaming_Params();
    var builder = new codec.MessageV0Builder(
        kDisplayStreamHandler_StartStreaming_Name,
        codec.align(DisplayStreamHandler_StartStreaming_Params.encodedSize));
    builder.encodeStruct(DisplayStreamHandler_StartStreaming_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DisplayStreamHandlerPtr.prototype.onStreamStatusChanged = function() {
    return DisplayStreamHandlerProxy.prototype.onStreamStatusChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  DisplayStreamHandlerProxy.prototype.onStreamStatusChanged = function(status) {
    var params_ = new DisplayStreamHandler_OnStreamStatusChanged_Params();
    params_.status = status;
    var builder = new codec.MessageV0Builder(
        kDisplayStreamHandler_OnStreamStatusChanged_Name,
        codec.align(DisplayStreamHandler_OnStreamStatusChanged_Params.encodedSize));
    builder.encodeStruct(DisplayStreamHandler_OnStreamStatusChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DisplayStreamHandlerPtr.prototype.setStreamActionObserver = function() {
    return DisplayStreamHandlerProxy.prototype.setStreamActionObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  DisplayStreamHandlerProxy.prototype.setStreamActionObserver = function(observer) {
    var params_ = new DisplayStreamHandler_SetStreamActionObserver_Params();
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kDisplayStreamHandler_SetStreamActionObserver_Name,
        codec.align(DisplayStreamHandler_SetStreamActionObserver_Params.encodedSize));
    builder.encodeStruct(DisplayStreamHandler_SetStreamActionObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function DisplayStreamHandlerStub(delegate) {
    this.delegate_ = delegate;
  }
  DisplayStreamHandlerStub.prototype.startStreaming = function() {
    return this.delegate_ && this.delegate_.startStreaming && this.delegate_.startStreaming();
  }
  DisplayStreamHandlerStub.prototype.onStreamStatusChanged = function(status) {
    return this.delegate_ && this.delegate_.onStreamStatusChanged && this.delegate_.onStreamStatusChanged(status);
  }
  DisplayStreamHandlerStub.prototype.setStreamActionObserver = function(observer) {
    return this.delegate_ && this.delegate_.setStreamActionObserver && this.delegate_.setStreamActionObserver(observer);
  }

  DisplayStreamHandlerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kDisplayStreamHandler_StartStreaming_Name:
      var params = reader.decodeStruct(DisplayStreamHandler_StartStreaming_Params);
      this.startStreaming();
      return true;
    case kDisplayStreamHandler_OnStreamStatusChanged_Name:
      var params = reader.decodeStruct(DisplayStreamHandler_OnStreamStatusChanged_Params);
      this.onStreamStatusChanged(params.status);
      return true;
    case kDisplayStreamHandler_SetStreamActionObserver_Name:
      var params = reader.decodeStruct(DisplayStreamHandler_SetStreamActionObserver_Params);
      this.setStreamActionObserver(params.observer);
      return true;
    default:
      return false;
    }
  };

  DisplayStreamHandlerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateDisplayStreamHandlerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kDisplayStreamHandler_StartStreaming_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DisplayStreamHandler_StartStreaming_Params;
      break;
      case kDisplayStreamHandler_OnStreamStatusChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DisplayStreamHandler_OnStreamStatusChanged_Params;
      break;
      case kDisplayStreamHandler_SetStreamActionObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DisplayStreamHandler_SetStreamActionObserver_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateDisplayStreamHandlerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var DisplayStreamHandler = {
    name: 'ash.eche_app.mojom.DisplayStreamHandler',
    kVersion: 0,
    ptrClass: DisplayStreamHandlerPtr,
    proxyClass: DisplayStreamHandlerProxy,
    stubClass: DisplayStreamHandlerStub,
    validateRequest: validateDisplayStreamHandlerRequest,
    validateResponse: null,
  };
  DisplayStreamHandlerStub.prototype.validator = validateDisplayStreamHandlerRequest;
  DisplayStreamHandlerProxy.prototype.validator = null;
  var kStreamActionObserver_OnStreamAction_Name = 0;

  function StreamActionObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(StreamActionObserver,
                                                   handleOrPtrInfo);
  }

  function StreamActionObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        StreamActionObserver, associatedInterfacePtrInfo);
  }

  StreamActionObserverAssociatedPtr.prototype =
      Object.create(StreamActionObserverPtr.prototype);
  StreamActionObserverAssociatedPtr.prototype.constructor =
      StreamActionObserverAssociatedPtr;

  function StreamActionObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  StreamActionObserverPtr.prototype.onStreamAction = function() {
    return StreamActionObserverProxy.prototype.onStreamAction
        .apply(this.ptr.getProxy(), arguments);
  };

  StreamActionObserverProxy.prototype.onStreamAction = function(action) {
    var params_ = new StreamActionObserver_OnStreamAction_Params();
    params_.action = action;
    var builder = new codec.MessageV0Builder(
        kStreamActionObserver_OnStreamAction_Name,
        codec.align(StreamActionObserver_OnStreamAction_Params.encodedSize));
    builder.encodeStruct(StreamActionObserver_OnStreamAction_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function StreamActionObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  StreamActionObserverStub.prototype.onStreamAction = function(action) {
    return this.delegate_ && this.delegate_.onStreamAction && this.delegate_.onStreamAction(action);
  }

  StreamActionObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kStreamActionObserver_OnStreamAction_Name:
      var params = reader.decodeStruct(StreamActionObserver_OnStreamAction_Params);
      this.onStreamAction(params.action);
      return true;
    default:
      return false;
    }
  };

  StreamActionObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateStreamActionObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kStreamActionObserver_OnStreamAction_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = StreamActionObserver_OnStreamAction_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateStreamActionObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var StreamActionObserver = {
    name: 'ash.eche_app.mojom.StreamActionObserver',
    kVersion: 0,
    ptrClass: StreamActionObserverPtr,
    proxyClass: StreamActionObserverProxy,
    stubClass: StreamActionObserverStub,
    validateRequest: validateStreamActionObserverRequest,
    validateResponse: null,
  };
  StreamActionObserverStub.prototype.validator = validateStreamActionObserverRequest;
  StreamActionObserverProxy.prototype.validator = null;
  var kStreamOrientationObserver_OnStreamOrientationChanged_Name = 0;

  function StreamOrientationObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(StreamOrientationObserver,
                                                   handleOrPtrInfo);
  }

  function StreamOrientationObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        StreamOrientationObserver, associatedInterfacePtrInfo);
  }

  StreamOrientationObserverAssociatedPtr.prototype =
      Object.create(StreamOrientationObserverPtr.prototype);
  StreamOrientationObserverAssociatedPtr.prototype.constructor =
      StreamOrientationObserverAssociatedPtr;

  function StreamOrientationObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  StreamOrientationObserverPtr.prototype.onStreamOrientationChanged = function() {
    return StreamOrientationObserverProxy.prototype.onStreamOrientationChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  StreamOrientationObserverProxy.prototype.onStreamOrientationChanged = function(isLandscape) {
    var params_ = new StreamOrientationObserver_OnStreamOrientationChanged_Params();
    params_.isLandscape = isLandscape;
    var builder = new codec.MessageV0Builder(
        kStreamOrientationObserver_OnStreamOrientationChanged_Name,
        codec.align(StreamOrientationObserver_OnStreamOrientationChanged_Params.encodedSize));
    builder.encodeStruct(StreamOrientationObserver_OnStreamOrientationChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function StreamOrientationObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  StreamOrientationObserverStub.prototype.onStreamOrientationChanged = function(isLandscape) {
    return this.delegate_ && this.delegate_.onStreamOrientationChanged && this.delegate_.onStreamOrientationChanged(isLandscape);
  }

  StreamOrientationObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kStreamOrientationObserver_OnStreamOrientationChanged_Name:
      var params = reader.decodeStruct(StreamOrientationObserver_OnStreamOrientationChanged_Params);
      this.onStreamOrientationChanged(params.isLandscape);
      return true;
    default:
      return false;
    }
  };

  StreamOrientationObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateStreamOrientationObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kStreamOrientationObserver_OnStreamOrientationChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = StreamOrientationObserver_OnStreamOrientationChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateStreamOrientationObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var StreamOrientationObserver = {
    name: 'ash.eche_app.mojom.StreamOrientationObserver',
    kVersion: 0,
    ptrClass: StreamOrientationObserverPtr,
    proxyClass: StreamOrientationObserverProxy,
    stubClass: StreamOrientationObserverStub,
    validateRequest: validateStreamOrientationObserverRequest,
    validateResponse: null,
  };
  StreamOrientationObserverStub.prototype.validator = validateStreamOrientationObserverRequest;
  StreamOrientationObserverProxy.prototype.validator = null;
  var kConnectionStatusObserver_OnConnectionStatusChanged_Name = 0;

  function ConnectionStatusObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ConnectionStatusObserver,
                                                   handleOrPtrInfo);
  }

  function ConnectionStatusObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ConnectionStatusObserver, associatedInterfacePtrInfo);
  }

  ConnectionStatusObserverAssociatedPtr.prototype =
      Object.create(ConnectionStatusObserverPtr.prototype);
  ConnectionStatusObserverAssociatedPtr.prototype.constructor =
      ConnectionStatusObserverAssociatedPtr;

  function ConnectionStatusObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  ConnectionStatusObserverPtr.prototype.onConnectionStatusChanged = function() {
    return ConnectionStatusObserverProxy.prototype.onConnectionStatusChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  ConnectionStatusObserverProxy.prototype.onConnectionStatusChanged = function(status) {
    var params_ = new ConnectionStatusObserver_OnConnectionStatusChanged_Params();
    params_.status = status;
    var builder = new codec.MessageV0Builder(
        kConnectionStatusObserver_OnConnectionStatusChanged_Name,
        codec.align(ConnectionStatusObserver_OnConnectionStatusChanged_Params.encodedSize));
    builder.encodeStruct(ConnectionStatusObserver_OnConnectionStatusChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ConnectionStatusObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  ConnectionStatusObserverStub.prototype.onConnectionStatusChanged = function(status) {
    return this.delegate_ && this.delegate_.onConnectionStatusChanged && this.delegate_.onConnectionStatusChanged(status);
  }

  ConnectionStatusObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kConnectionStatusObserver_OnConnectionStatusChanged_Name:
      var params = reader.decodeStruct(ConnectionStatusObserver_OnConnectionStatusChanged_Params);
      this.onConnectionStatusChanged(params.status);
      return true;
    default:
      return false;
    }
  };

  ConnectionStatusObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateConnectionStatusObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kConnectionStatusObserver_OnConnectionStatusChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ConnectionStatusObserver_OnConnectionStatusChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateConnectionStatusObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ConnectionStatusObserver = {
    name: 'ash.eche_app.mojom.ConnectionStatusObserver',
    kVersion: 0,
    ptrClass: ConnectionStatusObserverPtr,
    proxyClass: ConnectionStatusObserverProxy,
    stubClass: ConnectionStatusObserverStub,
    validateRequest: validateConnectionStatusObserverRequest,
    validateResponse: null,
  };
  ConnectionStatusObserverStub.prototype.validator = validateConnectionStatusObserverRequest;
  ConnectionStatusObserverProxy.prototype.validator = null;
  var kKeyboardLayoutHandler_RequestCurrentKeyboardLayout_Name = 0;
  var kKeyboardLayoutHandler_SetKeyboardLayoutObserver_Name = 1;

  function KeyboardLayoutHandlerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(KeyboardLayoutHandler,
                                                   handleOrPtrInfo);
  }

  function KeyboardLayoutHandlerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        KeyboardLayoutHandler, associatedInterfacePtrInfo);
  }

  KeyboardLayoutHandlerAssociatedPtr.prototype =
      Object.create(KeyboardLayoutHandlerPtr.prototype);
  KeyboardLayoutHandlerAssociatedPtr.prototype.constructor =
      KeyboardLayoutHandlerAssociatedPtr;

  function KeyboardLayoutHandlerProxy(receiver) {
    this.receiver_ = receiver;
  }
  KeyboardLayoutHandlerPtr.prototype.requestCurrentKeyboardLayout = function() {
    return KeyboardLayoutHandlerProxy.prototype.requestCurrentKeyboardLayout
        .apply(this.ptr.getProxy(), arguments);
  };

  KeyboardLayoutHandlerProxy.prototype.requestCurrentKeyboardLayout = function() {
    var params_ = new KeyboardLayoutHandler_RequestCurrentKeyboardLayout_Params();
    var builder = new codec.MessageV0Builder(
        kKeyboardLayoutHandler_RequestCurrentKeyboardLayout_Name,
        codec.align(KeyboardLayoutHandler_RequestCurrentKeyboardLayout_Params.encodedSize));
    builder.encodeStruct(KeyboardLayoutHandler_RequestCurrentKeyboardLayout_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  KeyboardLayoutHandlerPtr.prototype.setKeyboardLayoutObserver = function() {
    return KeyboardLayoutHandlerProxy.prototype.setKeyboardLayoutObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  KeyboardLayoutHandlerProxy.prototype.setKeyboardLayoutObserver = function(observer) {
    var params_ = new KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params();
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kKeyboardLayoutHandler_SetKeyboardLayoutObserver_Name,
        codec.align(KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params.encodedSize));
    builder.encodeStruct(KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function KeyboardLayoutHandlerStub(delegate) {
    this.delegate_ = delegate;
  }
  KeyboardLayoutHandlerStub.prototype.requestCurrentKeyboardLayout = function() {
    return this.delegate_ && this.delegate_.requestCurrentKeyboardLayout && this.delegate_.requestCurrentKeyboardLayout();
  }
  KeyboardLayoutHandlerStub.prototype.setKeyboardLayoutObserver = function(observer) {
    return this.delegate_ && this.delegate_.setKeyboardLayoutObserver && this.delegate_.setKeyboardLayoutObserver(observer);
  }

  KeyboardLayoutHandlerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kKeyboardLayoutHandler_RequestCurrentKeyboardLayout_Name:
      var params = reader.decodeStruct(KeyboardLayoutHandler_RequestCurrentKeyboardLayout_Params);
      this.requestCurrentKeyboardLayout();
      return true;
    case kKeyboardLayoutHandler_SetKeyboardLayoutObserver_Name:
      var params = reader.decodeStruct(KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params);
      this.setKeyboardLayoutObserver(params.observer);
      return true;
    default:
      return false;
    }
  };

  KeyboardLayoutHandlerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateKeyboardLayoutHandlerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kKeyboardLayoutHandler_RequestCurrentKeyboardLayout_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = KeyboardLayoutHandler_RequestCurrentKeyboardLayout_Params;
      break;
      case kKeyboardLayoutHandler_SetKeyboardLayoutObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateKeyboardLayoutHandlerResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var KeyboardLayoutHandler = {
    name: 'ash.eche_app.mojom.KeyboardLayoutHandler',
    kVersion: 0,
    ptrClass: KeyboardLayoutHandlerPtr,
    proxyClass: KeyboardLayoutHandlerProxy,
    stubClass: KeyboardLayoutHandlerStub,
    validateRequest: validateKeyboardLayoutHandlerRequest,
    validateResponse: null,
  };
  KeyboardLayoutHandlerStub.prototype.validator = validateKeyboardLayoutHandlerRequest;
  KeyboardLayoutHandlerProxy.prototype.validator = null;
  var kKeyboardLayoutObserver_OnKeyboardLayoutChanged_Name = 0;

  function KeyboardLayoutObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(KeyboardLayoutObserver,
                                                   handleOrPtrInfo);
  }

  function KeyboardLayoutObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        KeyboardLayoutObserver, associatedInterfacePtrInfo);
  }

  KeyboardLayoutObserverAssociatedPtr.prototype =
      Object.create(KeyboardLayoutObserverPtr.prototype);
  KeyboardLayoutObserverAssociatedPtr.prototype.constructor =
      KeyboardLayoutObserverAssociatedPtr;

  function KeyboardLayoutObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  KeyboardLayoutObserverPtr.prototype.onKeyboardLayoutChanged = function() {
    return KeyboardLayoutObserverProxy.prototype.onKeyboardLayoutChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  KeyboardLayoutObserverProxy.prototype.onKeyboardLayoutChanged = function(id, longName, shortName, layoutTag) {
    var params_ = new KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params();
    params_.id = id;
    params_.longName = longName;
    params_.shortName = shortName;
    params_.layoutTag = layoutTag;
    var builder = new codec.MessageV0Builder(
        kKeyboardLayoutObserver_OnKeyboardLayoutChanged_Name,
        codec.align(KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params.encodedSize));
    builder.encodeStruct(KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function KeyboardLayoutObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  KeyboardLayoutObserverStub.prototype.onKeyboardLayoutChanged = function(id, longName, shortName, layoutTag) {
    return this.delegate_ && this.delegate_.onKeyboardLayoutChanged && this.delegate_.onKeyboardLayoutChanged(id, longName, shortName, layoutTag);
  }

  KeyboardLayoutObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kKeyboardLayoutObserver_OnKeyboardLayoutChanged_Name:
      var params = reader.decodeStruct(KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params);
      this.onKeyboardLayoutChanged(params.id, params.longName, params.shortName, params.layoutTag);
      return true;
    default:
      return false;
    }
  };

  KeyboardLayoutObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateKeyboardLayoutObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kKeyboardLayoutObserver_OnKeyboardLayoutChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateKeyboardLayoutObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var KeyboardLayoutObserver = {
    name: 'ash.eche_app.mojom.KeyboardLayoutObserver',
    kVersion: 0,
    ptrClass: KeyboardLayoutObserverPtr,
    proxyClass: KeyboardLayoutObserverProxy,
    stubClass: KeyboardLayoutObserverStub,
    validateRequest: validateKeyboardLayoutObserverRequest,
    validateResponse: null,
  };
  KeyboardLayoutObserverStub.prototype.validator = validateKeyboardLayoutObserverRequest;
  KeyboardLayoutObserverProxy.prototype.validator = null;
  exports.ScreenBacklightState = ScreenBacklightState;
  exports.WebNotificationType = WebNotificationType;
  exports.StreamStatus = StreamStatus;
  exports.StreamAction = StreamAction;
  exports.ConnectionStatus = ConnectionStatus;
  exports.AppStreamLaunchEntryPoint = AppStreamLaunchEntryPoint;
  exports.SignalingMessageExchanger = SignalingMessageExchanger;
  exports.SignalingMessageExchangerPtr = SignalingMessageExchangerPtr;
  exports.SignalingMessageExchangerAssociatedPtr = SignalingMessageExchangerAssociatedPtr;
  exports.SignalingMessageObserver = SignalingMessageObserver;
  exports.SignalingMessageObserverPtr = SignalingMessageObserverPtr;
  exports.SignalingMessageObserverAssociatedPtr = SignalingMessageObserverAssociatedPtr;
  exports.SystemInfoProvider = SystemInfoProvider;
  exports.SystemInfoProviderPtr = SystemInfoProviderPtr;
  exports.SystemInfoProviderAssociatedPtr = SystemInfoProviderAssociatedPtr;
  exports.SystemInfoObserver = SystemInfoObserver;
  exports.SystemInfoObserverPtr = SystemInfoObserverPtr;
  exports.SystemInfoObserverAssociatedPtr = SystemInfoObserverAssociatedPtr;
  exports.AccessibilityProvider = AccessibilityProvider;
  exports.AccessibilityProviderPtr = AccessibilityProviderPtr;
  exports.AccessibilityProviderAssociatedPtr = AccessibilityProviderAssociatedPtr;
  exports.AccessibilityObserver = AccessibilityObserver;
  exports.AccessibilityObserverPtr = AccessibilityObserverPtr;
  exports.AccessibilityObserverAssociatedPtr = AccessibilityObserverAssociatedPtr;
  exports.UidGenerator = UidGenerator;
  exports.UidGeneratorPtr = UidGeneratorPtr;
  exports.UidGeneratorAssociatedPtr = UidGeneratorAssociatedPtr;
  exports.NotificationGenerator = NotificationGenerator;
  exports.NotificationGeneratorPtr = NotificationGeneratorPtr;
  exports.NotificationGeneratorAssociatedPtr = NotificationGeneratorAssociatedPtr;
  exports.DisplayStreamHandler = DisplayStreamHandler;
  exports.DisplayStreamHandlerPtr = DisplayStreamHandlerPtr;
  exports.DisplayStreamHandlerAssociatedPtr = DisplayStreamHandlerAssociatedPtr;
  exports.StreamActionObserver = StreamActionObserver;
  exports.StreamActionObserverPtr = StreamActionObserverPtr;
  exports.StreamActionObserverAssociatedPtr = StreamActionObserverAssociatedPtr;
  exports.StreamOrientationObserver = StreamOrientationObserver;
  exports.StreamOrientationObserverPtr = StreamOrientationObserverPtr;
  exports.StreamOrientationObserverAssociatedPtr = StreamOrientationObserverAssociatedPtr;
  exports.ConnectionStatusObserver = ConnectionStatusObserver;
  exports.ConnectionStatusObserverPtr = ConnectionStatusObserverPtr;
  exports.ConnectionStatusObserverAssociatedPtr = ConnectionStatusObserverAssociatedPtr;
  exports.KeyboardLayoutHandler = KeyboardLayoutHandler;
  exports.KeyboardLayoutHandlerPtr = KeyboardLayoutHandlerPtr;
  exports.KeyboardLayoutHandlerAssociatedPtr = KeyboardLayoutHandlerAssociatedPtr;
  exports.KeyboardLayoutObserver = KeyboardLayoutObserver;
  exports.KeyboardLayoutObserverPtr = KeyboardLayoutObserverPtr;
  exports.KeyboardLayoutObserverAssociatedPtr = KeyboardLayoutObserverAssociatedPtr;
})();