// ash/webui/eche_app_ui/mojom/eche_app.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../mojo/public/mojom/base/string16.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ScreenBacklightStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ScreenBacklightState = {
  
  ON: 0,
  OFF: 1,
  OFF_AUTO: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const WebNotificationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const WebNotificationType = {
  
  APP_CRAHSED: 0,
  AUTHORIZATION_NEEDED: 1,
  CONNECTION_FAILED: 2,
  CONNECTION_LOST: 3,
  DEVICE_IDLE: 4,
  INITIALIZATION_ERROR: 5,
  INVALID_NOTIFICATION: 6,
  NOTIFICATION_ACTION_NOT_LAUNCHED: 7,
  LAUNCH_NOTIFICATION_FAILED: 8,
  TABLET_MODE: 9,
  WIFI_NOT_READY: 10,
  DIFFERENT_WIFI_NETWORKS: 11,
  REMOTE_DEVICE_ON_CELLULAR: 12,
  MIN_VALUE: 0,
  MAX_VALUE: 12,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const StreamStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const StreamStatus = {
  
  kStreamStatusUnknown: 0,
  kStreamStatusInitializing: 1,
  kStreamStatusStarted: 2,
  kStreamStatusStopped: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const StreamActionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const StreamAction = {
  
  kStreamActionClose: 0,
  kStreamActionGoBack: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ConnectionStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ConnectionStatus = {
  
  kConnectionStatusDisconnected: 0,
  kConnectionStatusConnecting: 1,
  kConnectionStatusConnected: 2,
  kConnectionStatusFailed: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AppStreamLaunchEntryPointSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AppStreamLaunchEntryPoint = {
  
  APPS_LIST: 0,
  NOTIFICATION: 1,
  RECENT_APPS: 2,
  UNKNOWN: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SignalingMessageExchangerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.eche_app.mojom.SignalingMessageExchanger', scope);
  }
}

/** @interface */
export class SignalingMessageExchangerInterface {
  
  /**
   * @param { !Array<!number> } signal
   */

  sendSignalingMessage(signal) {}
  
  /**
   * @param { !SignalingMessageObserverRemote } observer
   */

  setSignalingMessageObserver(observer) {}
  
  /**
   */

  tearDownSignaling() {}
}

/**
 * @implements { SignalingMessageExchangerInterface }
 */
export class SignalingMessageExchangerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SignalingMessageExchangerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SignalingMessageExchangerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SignalingMessageExchangerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!number> } signal
   */

  sendSignalingMessage(
      signal) {
    this.proxy.sendMessage(
        0,
        SignalingMessageExchanger_SendSignalingMessage_ParamsSpec.$,
        null,
        [
          signal
        ],
        false);
  }

  
  /**
   * @param { !SignalingMessageObserverRemote } observer
   */

  setSignalingMessageObserver(
      observer) {
    this.proxy.sendMessage(
        1,
        SignalingMessageExchanger_SetSignalingMessageObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   */

  tearDownSignaling() {
    this.proxy.sendMessage(
        2,
        SignalingMessageExchanger_TearDownSignaling_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SignalingMessageExchanger
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SignalingMessageExchangerReceiver {
  /**
   * @param {!SignalingMessageExchangerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SignalingMessageExchangerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SignalingMessageExchangerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SignalingMessageExchangerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SignalingMessageExchanger_SendSignalingMessage_ParamsSpec.$,
        null,
        impl.sendSignalingMessage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SignalingMessageExchanger_SetSignalingMessageObserver_ParamsSpec.$,
        null,
        impl.setSignalingMessageObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SignalingMessageExchanger_TearDownSignaling_ParamsSpec.$,
        null,
        impl.tearDownSignaling.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SignalingMessageExchanger {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.SignalingMessageExchanger";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SignalingMessageExchangerRemote}
   */
  static getRemote() {
    let remote = new SignalingMessageExchangerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SignalingMessageExchanger
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SignalingMessageExchangerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SignalingMessageExchangerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SignalingMessageExchangerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendSignalingMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SignalingMessageExchanger_SendSignalingMessage_ParamsSpec.$,
        null,
        this.sendSignalingMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSignalingMessageObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SignalingMessageExchanger_SetSignalingMessageObserver_ParamsSpec.$,
        null,
        this.setSignalingMessageObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.tearDownSignaling =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SignalingMessageExchanger_TearDownSignaling_ParamsSpec.$,
        null,
        this.tearDownSignaling.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SignalingMessageObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.eche_app.mojom.SignalingMessageObserver', scope);
  }
}

/** @interface */
export class SignalingMessageObserverInterface {
  
  /**
   * @param { !Array<!number> } signal
   */

  onReceivedSignalingMessage(signal) {}
}

/**
 * @implements { SignalingMessageObserverInterface }
 */
export class SignalingMessageObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SignalingMessageObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SignalingMessageObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SignalingMessageObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!number> } signal
   */

  onReceivedSignalingMessage(
      signal) {
    this.proxy.sendMessage(
        0,
        SignalingMessageObserver_OnReceivedSignalingMessage_ParamsSpec.$,
        null,
        [
          signal
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SignalingMessageObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SignalingMessageObserverReceiver {
  /**
   * @param {!SignalingMessageObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SignalingMessageObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SignalingMessageObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SignalingMessageObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SignalingMessageObserver_OnReceivedSignalingMessage_ParamsSpec.$,
        null,
        impl.onReceivedSignalingMessage.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SignalingMessageObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.SignalingMessageObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SignalingMessageObserverRemote}
   */
  static getRemote() {
    let remote = new SignalingMessageObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SignalingMessageObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SignalingMessageObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SignalingMessageObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SignalingMessageObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReceivedSignalingMessage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SignalingMessageObserver_OnReceivedSignalingMessage_ParamsSpec.$,
        null,
        this.onReceivedSignalingMessage.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SystemInfoProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.eche_app.mojom.SystemInfoProvider', scope);
  }
}

/** @interface */
export class SystemInfoProviderInterface {
  
  /**
   * @return {!Promise<{
        systemInfo: !string,
   *  }>}
   */

  getSystemInfo() {}
  
  /**
   * @param { !SystemInfoObserverRemote } observer
   */

  setSystemInfoObserver(observer) {}
}

/**
 * @implements { SystemInfoProviderInterface }
 */
export class SystemInfoProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SystemInfoProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SystemInfoProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SystemInfoProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        systemInfo: !string,
   *  }>}
   */

  getSystemInfo() {
    return this.proxy.sendMessage(
        0,
        SystemInfoProvider_GetSystemInfo_ParamsSpec.$,
        SystemInfoProvider_GetSystemInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !SystemInfoObserverRemote } observer
   */

  setSystemInfoObserver(
      observer) {
    this.proxy.sendMessage(
        1,
        SystemInfoProvider_SetSystemInfoObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SystemInfoProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SystemInfoProviderReceiver {
  /**
   * @param {!SystemInfoProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SystemInfoProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SystemInfoProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SystemInfoProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SystemInfoProvider_GetSystemInfo_ParamsSpec.$,
        SystemInfoProvider_GetSystemInfo_ResponseParamsSpec.$,
        impl.getSystemInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SystemInfoProvider_SetSystemInfoObserver_ParamsSpec.$,
        null,
        impl.setSystemInfoObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SystemInfoProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.SystemInfoProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SystemInfoProviderRemote}
   */
  static getRemote() {
    let remote = new SystemInfoProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SystemInfoProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SystemInfoProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SystemInfoProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SystemInfoProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSystemInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SystemInfoProvider_GetSystemInfo_ParamsSpec.$,
        SystemInfoProvider_GetSystemInfo_ResponseParamsSpec.$,
        this.getSystemInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSystemInfoObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SystemInfoProvider_SetSystemInfoObserver_ParamsSpec.$,
        null,
        this.setSystemInfoObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SystemInfoObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.eche_app.mojom.SystemInfoObserver', scope);
  }
}

/** @interface */
export class SystemInfoObserverInterface {
  
  /**
   * @param { !ScreenBacklightState } state
   */

  onScreenBacklightStateChanged(state) {}
  
  /**
   * @param { !boolean } isTabletMode
   */

  onReceivedTabletModeChanged(isTabletMode) {}
  
  /**
   * @param { !boolean } isDifferentNetwork
   * @param { !boolean } androidDeviceOnCellular
   */

  onAndroidDeviceNetworkInfoChanged(isDifferentNetwork, androidDeviceOnCellular) {}
}

/**
 * @implements { SystemInfoObserverInterface }
 */
export class SystemInfoObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SystemInfoObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SystemInfoObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SystemInfoObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ScreenBacklightState } state
   */

  onScreenBacklightStateChanged(
      state) {
    this.proxy.sendMessage(
        0,
        SystemInfoObserver_OnScreenBacklightStateChanged_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }

  
  /**
   * @param { !boolean } isTabletMode
   */

  onReceivedTabletModeChanged(
      isTabletMode) {
    this.proxy.sendMessage(
        1,
        SystemInfoObserver_OnReceivedTabletModeChanged_ParamsSpec.$,
        null,
        [
          isTabletMode
        ],
        false);
  }

  
  /**
   * @param { !boolean } isDifferentNetwork
   * @param { !boolean } androidDeviceOnCellular
   */

  onAndroidDeviceNetworkInfoChanged(
      isDifferentNetwork,
      androidDeviceOnCellular) {
    this.proxy.sendMessage(
        2,
        SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_ParamsSpec.$,
        null,
        [
          isDifferentNetwork,
          androidDeviceOnCellular
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SystemInfoObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SystemInfoObserverReceiver {
  /**
   * @param {!SystemInfoObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SystemInfoObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SystemInfoObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SystemInfoObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SystemInfoObserver_OnScreenBacklightStateChanged_ParamsSpec.$,
        null,
        impl.onScreenBacklightStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SystemInfoObserver_OnReceivedTabletModeChanged_ParamsSpec.$,
        null,
        impl.onReceivedTabletModeChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_ParamsSpec.$,
        null,
        impl.onAndroidDeviceNetworkInfoChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SystemInfoObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.SystemInfoObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SystemInfoObserverRemote}
   */
  static getRemote() {
    let remote = new SystemInfoObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SystemInfoObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SystemInfoObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SystemInfoObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SystemInfoObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onScreenBacklightStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SystemInfoObserver_OnScreenBacklightStateChanged_ParamsSpec.$,
        null,
        this.onScreenBacklightStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReceivedTabletModeChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SystemInfoObserver_OnReceivedTabletModeChanged_ParamsSpec.$,
        null,
        this.onReceivedTabletModeChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAndroidDeviceNetworkInfoChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_ParamsSpec.$,
        null,
        this.onAndroidDeviceNetworkInfoChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AccessibilityProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.eche_app.mojom.AccessibilityProvider', scope);
  }
}

/** @interface */
export class AccessibilityProviderInterface {
  
  /**
   * @param { !Array<!number> } serializedProto
   */

  handleAccessibilityEventReceived(serializedProto) {}
  
  /**
   * @param { !AccessibilityObserverRemote } observer
   */

  setAccessibilityObserver(observer) {}
  
  /**
   * @return {!Promise<{
        enabled: !boolean,
   *  }>}
   */

  isAccessibilityEnabled() {}
}

/**
 * @implements { AccessibilityProviderInterface }
 */
export class AccessibilityProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AccessibilityProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AccessibilityProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AccessibilityProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!number> } serializedProto
   */

  handleAccessibilityEventReceived(
      serializedProto) {
    this.proxy.sendMessage(
        0,
        AccessibilityProvider_HandleAccessibilityEventReceived_ParamsSpec.$,
        null,
        [
          serializedProto
        ],
        false);
  }

  
  /**
   * @param { !AccessibilityObserverRemote } observer
   */

  setAccessibilityObserver(
      observer) {
    this.proxy.sendMessage(
        1,
        AccessibilityProvider_SetAccessibilityObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        enabled: !boolean,
   *  }>}
   */

  isAccessibilityEnabled() {
    return this.proxy.sendMessage(
        2,
        AccessibilityProvider_IsAccessibilityEnabled_ParamsSpec.$,
        AccessibilityProvider_IsAccessibilityEnabled_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AccessibilityProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AccessibilityProviderReceiver {
  /**
   * @param {!AccessibilityProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AccessibilityProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AccessibilityProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AccessibilityProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AccessibilityProvider_HandleAccessibilityEventReceived_ParamsSpec.$,
        null,
        impl.handleAccessibilityEventReceived.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AccessibilityProvider_SetAccessibilityObserver_ParamsSpec.$,
        null,
        impl.setAccessibilityObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AccessibilityProvider_IsAccessibilityEnabled_ParamsSpec.$,
        AccessibilityProvider_IsAccessibilityEnabled_ResponseParamsSpec.$,
        impl.isAccessibilityEnabled.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AccessibilityProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.AccessibilityProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AccessibilityProviderRemote}
   */
  static getRemote() {
    let remote = new AccessibilityProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AccessibilityProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AccessibilityProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AccessibilityProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AccessibilityProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.handleAccessibilityEventReceived =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AccessibilityProvider_HandleAccessibilityEventReceived_ParamsSpec.$,
        null,
        this.handleAccessibilityEventReceived.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAccessibilityObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AccessibilityProvider_SetAccessibilityObserver_ParamsSpec.$,
        null,
        this.setAccessibilityObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isAccessibilityEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AccessibilityProvider_IsAccessibilityEnabled_ParamsSpec.$,
        AccessibilityProvider_IsAccessibilityEnabled_ResponseParamsSpec.$,
        this.isAccessibilityEnabled.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AccessibilityObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.eche_app.mojom.AccessibilityObserver', scope);
  }
}

/** @interface */
export class AccessibilityObserverInterface {
  
  /**
   * @param { !boolean } enable
   */

  enableAccessibilityTreeStreaming(enable) {}
  
  /**
   * @param { !boolean } enable
   */

  enableExploreByTouch(enable) {}
  
  /**
   * @param { !Array<!number> } serializedProto
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  performAction(serializedProto) {}
  
  /**
   * @param { !Array<!number> } refreshDataProto
   * @return {!Promise<{
        textLocationProto: ?Array<!number>,
   *  }>}
   */

  refreshWithExtraData(refreshDataProto) {}
}

/**
 * @implements { AccessibilityObserverInterface }
 */
export class AccessibilityObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AccessibilityObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AccessibilityObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AccessibilityObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } enable
   */

  enableAccessibilityTreeStreaming(
      enable) {
    this.proxy.sendMessage(
        0,
        AccessibilityObserver_EnableAccessibilityTreeStreaming_ParamsSpec.$,
        null,
        [
          enable
        ],
        false);
  }

  
  /**
   * @param { !boolean } enable
   */

  enableExploreByTouch(
      enable) {
    this.proxy.sendMessage(
        1,
        AccessibilityObserver_EnableExploreByTouch_ParamsSpec.$,
        null,
        [
          enable
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } serializedProto
   * @return {!Promise<{
        result: !boolean,
   *  }>}
   */

  performAction(
      serializedProto) {
    return this.proxy.sendMessage(
        2,
        AccessibilityObserver_PerformAction_ParamsSpec.$,
        AccessibilityObserver_PerformAction_ResponseParamsSpec.$,
        [
          serializedProto
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } refreshDataProto
   * @return {!Promise<{
        textLocationProto: ?Array<!number>,
   *  }>}
   */

  refreshWithExtraData(
      refreshDataProto) {
    return this.proxy.sendMessage(
        3,
        AccessibilityObserver_RefreshWithExtraData_ParamsSpec.$,
        AccessibilityObserver_RefreshWithExtraData_ResponseParamsSpec.$,
        [
          refreshDataProto
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AccessibilityObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AccessibilityObserverReceiver {
  /**
   * @param {!AccessibilityObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AccessibilityObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AccessibilityObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AccessibilityObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AccessibilityObserver_EnableAccessibilityTreeStreaming_ParamsSpec.$,
        null,
        impl.enableAccessibilityTreeStreaming.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AccessibilityObserver_EnableExploreByTouch_ParamsSpec.$,
        null,
        impl.enableExploreByTouch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AccessibilityObserver_PerformAction_ParamsSpec.$,
        AccessibilityObserver_PerformAction_ResponseParamsSpec.$,
        impl.performAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        AccessibilityObserver_RefreshWithExtraData_ParamsSpec.$,
        AccessibilityObserver_RefreshWithExtraData_ResponseParamsSpec.$,
        impl.refreshWithExtraData.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AccessibilityObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.AccessibilityObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AccessibilityObserverRemote}
   */
  static getRemote() {
    let remote = new AccessibilityObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AccessibilityObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AccessibilityObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AccessibilityObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AccessibilityObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableAccessibilityTreeStreaming =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AccessibilityObserver_EnableAccessibilityTreeStreaming_ParamsSpec.$,
        null,
        this.enableAccessibilityTreeStreaming.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableExploreByTouch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AccessibilityObserver_EnableExploreByTouch_ParamsSpec.$,
        null,
        this.enableExploreByTouch.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.performAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AccessibilityObserver_PerformAction_ParamsSpec.$,
        AccessibilityObserver_PerformAction_ResponseParamsSpec.$,
        this.performAction.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.refreshWithExtraData =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        AccessibilityObserver_RefreshWithExtraData_ParamsSpec.$,
        AccessibilityObserver_RefreshWithExtraData_ResponseParamsSpec.$,
        this.refreshWithExtraData.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class UidGeneratorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.eche_app.mojom.UidGenerator', scope);
  }
}

/** @interface */
export class UidGeneratorInterface {
  
  /**
   * @return {!Promise<{
        localUid: !string,
   *  }>}
   */

  getUid() {}
}

/**
 * @implements { UidGeneratorInterface }
 */
export class UidGeneratorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!UidGeneratorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          UidGeneratorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!UidGeneratorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        localUid: !string,
   *  }>}
   */

  getUid() {
    return this.proxy.sendMessage(
        0,
        UidGenerator_GetUid_ParamsSpec.$,
        UidGenerator_GetUid_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the UidGenerator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UidGeneratorReceiver {
  /**
   * @param {!UidGeneratorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!UidGeneratorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        UidGeneratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UidGeneratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        UidGenerator_GetUid_ParamsSpec.$,
        UidGenerator_GetUid_ResponseParamsSpec.$,
        impl.getUid.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class UidGenerator {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.UidGenerator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!UidGeneratorRemote}
   */
  static getRemote() {
    let remote = new UidGeneratorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the UidGenerator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UidGeneratorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      UidGeneratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UidGeneratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getUid =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        UidGenerator_GetUid_ParamsSpec.$,
        UidGenerator_GetUid_ResponseParamsSpec.$,
        this.getUid.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NotificationGeneratorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.eche_app.mojom.NotificationGenerator', scope);
  }
}

/** @interface */
export class NotificationGeneratorInterface {
  
  /**
   * @param { !mojoBase_mojom_String16 } title
   * @param { !mojoBase_mojom_String16 } message
   * @param { !WebNotificationType } type
   */

  showNotification(title, message, type) {}
  
  /**
   * @param { !mojoBase_mojom_String16 } text
   */

  showToast(text) {}
}

/**
 * @implements { NotificationGeneratorInterface }
 */
export class NotificationGeneratorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NotificationGeneratorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NotificationGeneratorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NotificationGeneratorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_String16 } title
   * @param { !mojoBase_mojom_String16 } message
   * @param { !WebNotificationType } type
   */

  showNotification(
      title,
      message,
      type) {
    this.proxy.sendMessage(
        0,
        NotificationGenerator_ShowNotification_ParamsSpec.$,
        null,
        [
          title,
          message,
          type
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_String16 } text
   */

  showToast(
      text) {
    this.proxy.sendMessage(
        1,
        NotificationGenerator_ShowToast_ParamsSpec.$,
        null,
        [
          text
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NotificationGenerator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NotificationGeneratorReceiver {
  /**
   * @param {!NotificationGeneratorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NotificationGeneratorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NotificationGeneratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NotificationGeneratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NotificationGenerator_ShowNotification_ParamsSpec.$,
        null,
        impl.showNotification.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        NotificationGenerator_ShowToast_ParamsSpec.$,
        null,
        impl.showToast.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NotificationGenerator {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.NotificationGenerator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NotificationGeneratorRemote}
   */
  static getRemote() {
    let remote = new NotificationGeneratorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NotificationGenerator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NotificationGeneratorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NotificationGeneratorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NotificationGeneratorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showNotification =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NotificationGenerator_ShowNotification_ParamsSpec.$,
        null,
        this.showNotification.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showToast =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        NotificationGenerator_ShowToast_ParamsSpec.$,
        null,
        this.showToast.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DisplayStreamHandlerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.eche_app.mojom.DisplayStreamHandler', scope);
  }
}

/** @interface */
export class DisplayStreamHandlerInterface {
  
  /**
   */

  startStreaming() {}
  
  /**
   * @param { !StreamStatus } status
   */

  onStreamStatusChanged(status) {}
  
  /**
   * @param { !StreamActionObserverRemote } observer
   */

  setStreamActionObserver(observer) {}
}

/**
 * @implements { DisplayStreamHandlerInterface }
 */
export class DisplayStreamHandlerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DisplayStreamHandlerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DisplayStreamHandlerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DisplayStreamHandlerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  startStreaming() {
    this.proxy.sendMessage(
        0,
        DisplayStreamHandler_StartStreaming_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !StreamStatus } status
   */

  onStreamStatusChanged(
      status) {
    this.proxy.sendMessage(
        1,
        DisplayStreamHandler_OnStreamStatusChanged_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   * @param { !StreamActionObserverRemote } observer
   */

  setStreamActionObserver(
      observer) {
    this.proxy.sendMessage(
        2,
        DisplayStreamHandler_SetStreamActionObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DisplayStreamHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DisplayStreamHandlerReceiver {
  /**
   * @param {!DisplayStreamHandlerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DisplayStreamHandlerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DisplayStreamHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DisplayStreamHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DisplayStreamHandler_StartStreaming_ParamsSpec.$,
        null,
        impl.startStreaming.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DisplayStreamHandler_OnStreamStatusChanged_ParamsSpec.$,
        null,
        impl.onStreamStatusChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        DisplayStreamHandler_SetStreamActionObserver_ParamsSpec.$,
        null,
        impl.setStreamActionObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DisplayStreamHandler {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.DisplayStreamHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DisplayStreamHandlerRemote}
   */
  static getRemote() {
    let remote = new DisplayStreamHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DisplayStreamHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DisplayStreamHandlerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DisplayStreamHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DisplayStreamHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startStreaming =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DisplayStreamHandler_StartStreaming_ParamsSpec.$,
        null,
        this.startStreaming.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStreamStatusChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DisplayStreamHandler_OnStreamStatusChanged_ParamsSpec.$,
        null,
        this.onStreamStatusChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setStreamActionObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        DisplayStreamHandler_SetStreamActionObserver_ParamsSpec.$,
        null,
        this.setStreamActionObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class StreamActionObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.eche_app.mojom.StreamActionObserver', scope);
  }
}

/** @interface */
export class StreamActionObserverInterface {
  
  /**
   * @param { !StreamAction } action
   */

  onStreamAction(action) {}
}

/**
 * @implements { StreamActionObserverInterface }
 */
export class StreamActionObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!StreamActionObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          StreamActionObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!StreamActionObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !StreamAction } action
   */

  onStreamAction(
      action) {
    this.proxy.sendMessage(
        0,
        StreamActionObserver_OnStreamAction_ParamsSpec.$,
        null,
        [
          action
        ],
        false);
  }
}

/**
 * An object which receives request messages for the StreamActionObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class StreamActionObserverReceiver {
  /**
   * @param {!StreamActionObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!StreamActionObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        StreamActionObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!StreamActionObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        StreamActionObserver_OnStreamAction_ParamsSpec.$,
        null,
        impl.onStreamAction.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class StreamActionObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.StreamActionObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!StreamActionObserverRemote}
   */
  static getRemote() {
    let remote = new StreamActionObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the StreamActionObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class StreamActionObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      StreamActionObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!StreamActionObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStreamAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        StreamActionObserver_OnStreamAction_ParamsSpec.$,
        null,
        this.onStreamAction.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class StreamOrientationObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.eche_app.mojom.StreamOrientationObserver', scope);
  }
}

/** @interface */
export class StreamOrientationObserverInterface {
  
  /**
   * @param { !boolean } isLandscape
   */

  onStreamOrientationChanged(isLandscape) {}
}

/**
 * @implements { StreamOrientationObserverInterface }
 */
export class StreamOrientationObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!StreamOrientationObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          StreamOrientationObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!StreamOrientationObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } isLandscape
   */

  onStreamOrientationChanged(
      isLandscape) {
    this.proxy.sendMessage(
        0,
        StreamOrientationObserver_OnStreamOrientationChanged_ParamsSpec.$,
        null,
        [
          isLandscape
        ],
        false);
  }
}

/**
 * An object which receives request messages for the StreamOrientationObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class StreamOrientationObserverReceiver {
  /**
   * @param {!StreamOrientationObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!StreamOrientationObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        StreamOrientationObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!StreamOrientationObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        StreamOrientationObserver_OnStreamOrientationChanged_ParamsSpec.$,
        null,
        impl.onStreamOrientationChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class StreamOrientationObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.StreamOrientationObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!StreamOrientationObserverRemote}
   */
  static getRemote() {
    let remote = new StreamOrientationObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the StreamOrientationObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class StreamOrientationObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      StreamOrientationObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!StreamOrientationObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStreamOrientationChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        StreamOrientationObserver_OnStreamOrientationChanged_ParamsSpec.$,
        null,
        this.onStreamOrientationChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ConnectionStatusObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.eche_app.mojom.ConnectionStatusObserver', scope);
  }
}

/** @interface */
export class ConnectionStatusObserverInterface {
  
  /**
   * @param { !ConnectionStatus } status
   */

  onConnectionStatusChanged(status) {}
}

/**
 * @implements { ConnectionStatusObserverInterface }
 */
export class ConnectionStatusObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ConnectionStatusObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ConnectionStatusObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ConnectionStatusObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ConnectionStatus } status
   */

  onConnectionStatusChanged(
      status) {
    this.proxy.sendMessage(
        0,
        ConnectionStatusObserver_OnConnectionStatusChanged_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ConnectionStatusObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ConnectionStatusObserverReceiver {
  /**
   * @param {!ConnectionStatusObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ConnectionStatusObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ConnectionStatusObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ConnectionStatusObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ConnectionStatusObserver_OnConnectionStatusChanged_ParamsSpec.$,
        null,
        impl.onConnectionStatusChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ConnectionStatusObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.ConnectionStatusObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ConnectionStatusObserverRemote}
   */
  static getRemote() {
    let remote = new ConnectionStatusObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ConnectionStatusObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ConnectionStatusObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ConnectionStatusObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ConnectionStatusObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onConnectionStatusChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ConnectionStatusObserver_OnConnectionStatusChanged_ParamsSpec.$,
        null,
        this.onConnectionStatusChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class KeyboardLayoutHandlerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.eche_app.mojom.KeyboardLayoutHandler', scope);
  }
}

/** @interface */
export class KeyboardLayoutHandlerInterface {
  
  /**
   */

  requestCurrentKeyboardLayout() {}
  
  /**
   * @param { !KeyboardLayoutObserverRemote } observer
   */

  setKeyboardLayoutObserver(observer) {}
}

/**
 * @implements { KeyboardLayoutHandlerInterface }
 */
export class KeyboardLayoutHandlerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!KeyboardLayoutHandlerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          KeyboardLayoutHandlerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!KeyboardLayoutHandlerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  requestCurrentKeyboardLayout() {
    this.proxy.sendMessage(
        0,
        KeyboardLayoutHandler_RequestCurrentKeyboardLayout_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !KeyboardLayoutObserverRemote } observer
   */

  setKeyboardLayoutObserver(
      observer) {
    this.proxy.sendMessage(
        1,
        KeyboardLayoutHandler_SetKeyboardLayoutObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the KeyboardLayoutHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class KeyboardLayoutHandlerReceiver {
  /**
   * @param {!KeyboardLayoutHandlerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!KeyboardLayoutHandlerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        KeyboardLayoutHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!KeyboardLayoutHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        KeyboardLayoutHandler_RequestCurrentKeyboardLayout_ParamsSpec.$,
        null,
        impl.requestCurrentKeyboardLayout.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        KeyboardLayoutHandler_SetKeyboardLayoutObserver_ParamsSpec.$,
        null,
        impl.setKeyboardLayoutObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class KeyboardLayoutHandler {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.KeyboardLayoutHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!KeyboardLayoutHandlerRemote}
   */
  static getRemote() {
    let remote = new KeyboardLayoutHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the KeyboardLayoutHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class KeyboardLayoutHandlerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      KeyboardLayoutHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!KeyboardLayoutHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestCurrentKeyboardLayout =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        KeyboardLayoutHandler_RequestCurrentKeyboardLayout_ParamsSpec.$,
        null,
        this.requestCurrentKeyboardLayout.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setKeyboardLayoutObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        KeyboardLayoutHandler_SetKeyboardLayoutObserver_ParamsSpec.$,
        null,
        this.setKeyboardLayoutObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class KeyboardLayoutObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.eche_app.mojom.KeyboardLayoutObserver', scope);
  }
}

/** @interface */
export class KeyboardLayoutObserverInterface {
  
  /**
   * @param { !string } id
   * @param { !string } longName
   * @param { !string } shortName
   * @param { !string } layoutTag
   */

  onKeyboardLayoutChanged(id, longName, shortName, layoutTag) {}
}

/**
 * @implements { KeyboardLayoutObserverInterface }
 */
export class KeyboardLayoutObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!KeyboardLayoutObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          KeyboardLayoutObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!KeyboardLayoutObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } id
   * @param { !string } longName
   * @param { !string } shortName
   * @param { !string } layoutTag
   */

  onKeyboardLayoutChanged(
      id,
      longName,
      shortName,
      layoutTag) {
    this.proxy.sendMessage(
        0,
        KeyboardLayoutObserver_OnKeyboardLayoutChanged_ParamsSpec.$,
        null,
        [
          id,
          longName,
          shortName,
          layoutTag
        ],
        false);
  }
}

/**
 * An object which receives request messages for the KeyboardLayoutObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class KeyboardLayoutObserverReceiver {
  /**
   * @param {!KeyboardLayoutObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!KeyboardLayoutObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        KeyboardLayoutObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!KeyboardLayoutObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        KeyboardLayoutObserver_OnKeyboardLayoutChanged_ParamsSpec.$,
        null,
        impl.onKeyboardLayoutChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class KeyboardLayoutObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.eche_app.mojom.KeyboardLayoutObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!KeyboardLayoutObserverRemote}
   */
  static getRemote() {
    let remote = new KeyboardLayoutObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the KeyboardLayoutObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class KeyboardLayoutObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      KeyboardLayoutObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!KeyboardLayoutObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onKeyboardLayoutChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        KeyboardLayoutObserver_OnKeyboardLayoutChanged_ParamsSpec.$,
        null,
        this.onKeyboardLayoutChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SignalingMessageExchanger_SendSignalingMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SignalingMessageExchanger_SetSignalingMessageObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SignalingMessageExchanger_TearDownSignaling_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SignalingMessageObserver_OnReceivedSignalingMessage_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SystemInfoProvider_GetSystemInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SystemInfoProvider_GetSystemInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SystemInfoProvider_SetSystemInfoObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SystemInfoObserver_OnScreenBacklightStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SystemInfoObserver_OnReceivedTabletModeChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AccessibilityProvider_HandleAccessibilityEventReceived_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AccessibilityProvider_SetAccessibilityObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AccessibilityProvider_IsAccessibilityEnabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AccessibilityProvider_IsAccessibilityEnabled_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AccessibilityObserver_EnableAccessibilityTreeStreaming_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AccessibilityObserver_EnableExploreByTouch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AccessibilityObserver_PerformAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AccessibilityObserver_PerformAction_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AccessibilityObserver_RefreshWithExtraData_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AccessibilityObserver_RefreshWithExtraData_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UidGenerator_GetUid_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UidGenerator_GetUid_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NotificationGenerator_ShowNotification_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NotificationGenerator_ShowToast_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DisplayStreamHandler_StartStreaming_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DisplayStreamHandler_OnStreamStatusChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DisplayStreamHandler_SetStreamActionObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StreamActionObserver_OnStreamAction_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const StreamOrientationObserver_OnStreamOrientationChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ConnectionStatusObserver_OnConnectionStatusChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const KeyboardLayoutHandler_RequestCurrentKeyboardLayout_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const KeyboardLayoutHandler_SetKeyboardLayoutObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const KeyboardLayoutObserver_OnKeyboardLayoutChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SignalingMessageExchanger_SendSignalingMessage_ParamsSpec.$,
    'SignalingMessageExchanger_SendSignalingMessage_Params',
    [
      mojo.internal.StructField(
        'signal', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SignalingMessageExchanger_SendSignalingMessage_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.signal;
  }
}



mojo.internal.Struct(
    SignalingMessageExchanger_SetSignalingMessageObserver_ParamsSpec.$,
    'SignalingMessageExchanger_SetSignalingMessageObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(SignalingMessageObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SignalingMessageExchanger_SetSignalingMessageObserver_Params {
  constructor() {
    /** @type { !SignalingMessageObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    SignalingMessageExchanger_TearDownSignaling_ParamsSpec.$,
    'SignalingMessageExchanger_TearDownSignaling_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SignalingMessageExchanger_TearDownSignaling_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SignalingMessageObserver_OnReceivedSignalingMessage_ParamsSpec.$,
    'SignalingMessageObserver_OnReceivedSignalingMessage_Params',
    [
      mojo.internal.StructField(
        'signal', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SignalingMessageObserver_OnReceivedSignalingMessage_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.signal;
  }
}



mojo.internal.Struct(
    SystemInfoProvider_GetSystemInfo_ParamsSpec.$,
    'SystemInfoProvider_GetSystemInfo_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class SystemInfoProvider_GetSystemInfo_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    SystemInfoProvider_GetSystemInfo_ResponseParamsSpec.$,
    'SystemInfoProvider_GetSystemInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'systemInfo', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SystemInfoProvider_GetSystemInfo_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.systemInfo;
  }
}



mojo.internal.Struct(
    SystemInfoProvider_SetSystemInfoObserver_ParamsSpec.$,
    'SystemInfoProvider_SetSystemInfoObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(SystemInfoObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SystemInfoProvider_SetSystemInfoObserver_Params {
  constructor() {
    /** @type { !SystemInfoObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    SystemInfoObserver_OnScreenBacklightStateChanged_ParamsSpec.$,
    'SystemInfoObserver_OnScreenBacklightStateChanged_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        ScreenBacklightStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SystemInfoObserver_OnScreenBacklightStateChanged_Params {
  constructor() {
    /** @type { !ScreenBacklightState } */
    this.state;
  }
}



mojo.internal.Struct(
    SystemInfoObserver_OnReceivedTabletModeChanged_ParamsSpec.$,
    'SystemInfoObserver_OnReceivedTabletModeChanged_Params',
    [
      mojo.internal.StructField(
        'isTabletMode', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SystemInfoObserver_OnReceivedTabletModeChanged_Params {
  constructor() {
    /** @type { !boolean } */
    this.isTabletMode;
  }
}



mojo.internal.Struct(
    SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_ParamsSpec.$,
    'SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Params',
    [
      mojo.internal.StructField(
        'isDifferentNetwork', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'androidDeviceOnCellular', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SystemInfoObserver_OnAndroidDeviceNetworkInfoChanged_Params {
  constructor() {
    /** @type { !boolean } */
    this.isDifferentNetwork;
    /** @type { !boolean } */
    this.androidDeviceOnCellular;
  }
}



mojo.internal.Struct(
    AccessibilityProvider_HandleAccessibilityEventReceived_ParamsSpec.$,
    'AccessibilityProvider_HandleAccessibilityEventReceived_Params',
    [
      mojo.internal.StructField(
        'serializedProto', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AccessibilityProvider_HandleAccessibilityEventReceived_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.serializedProto;
  }
}



mojo.internal.Struct(
    AccessibilityProvider_SetAccessibilityObserver_ParamsSpec.$,
    'AccessibilityProvider_SetAccessibilityObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(AccessibilityObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AccessibilityProvider_SetAccessibilityObserver_Params {
  constructor() {
    /** @type { !AccessibilityObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    AccessibilityProvider_IsAccessibilityEnabled_ParamsSpec.$,
    'AccessibilityProvider_IsAccessibilityEnabled_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AccessibilityProvider_IsAccessibilityEnabled_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AccessibilityProvider_IsAccessibilityEnabled_ResponseParamsSpec.$,
    'AccessibilityProvider_IsAccessibilityEnabled_ResponseParams',
    [
      mojo.internal.StructField(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AccessibilityProvider_IsAccessibilityEnabled_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.enabled;
  }
}



mojo.internal.Struct(
    AccessibilityObserver_EnableAccessibilityTreeStreaming_ParamsSpec.$,
    'AccessibilityObserver_EnableAccessibilityTreeStreaming_Params',
    [
      mojo.internal.StructField(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AccessibilityObserver_EnableAccessibilityTreeStreaming_Params {
  constructor() {
    /** @type { !boolean } */
    this.enable;
  }
}



mojo.internal.Struct(
    AccessibilityObserver_EnableExploreByTouch_ParamsSpec.$,
    'AccessibilityObserver_EnableExploreByTouch_Params',
    [
      mojo.internal.StructField(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AccessibilityObserver_EnableExploreByTouch_Params {
  constructor() {
    /** @type { !boolean } */
    this.enable;
  }
}



mojo.internal.Struct(
    AccessibilityObserver_PerformAction_ParamsSpec.$,
    'AccessibilityObserver_PerformAction_Params',
    [
      mojo.internal.StructField(
        'serializedProto', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AccessibilityObserver_PerformAction_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.serializedProto;
  }
}



mojo.internal.Struct(
    AccessibilityObserver_PerformAction_ResponseParamsSpec.$,
    'AccessibilityObserver_PerformAction_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AccessibilityObserver_PerformAction_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.result;
  }
}



mojo.internal.Struct(
    AccessibilityObserver_RefreshWithExtraData_ParamsSpec.$,
    'AccessibilityObserver_RefreshWithExtraData_Params',
    [
      mojo.internal.StructField(
        'refreshDataProto', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AccessibilityObserver_RefreshWithExtraData_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.refreshDataProto;
  }
}



mojo.internal.Struct(
    AccessibilityObserver_RefreshWithExtraData_ResponseParamsSpec.$,
    'AccessibilityObserver_RefreshWithExtraData_ResponseParams',
    [
      mojo.internal.StructField(
        'textLocationProto', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AccessibilityObserver_RefreshWithExtraData_ResponseParams {
  constructor() {
    /** @type { (Array<!number>|undefined) } */
    this.textLocationProto;
  }
}



mojo.internal.Struct(
    UidGenerator_GetUid_ParamsSpec.$,
    'UidGenerator_GetUid_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class UidGenerator_GetUid_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    UidGenerator_GetUid_ResponseParamsSpec.$,
    'UidGenerator_GetUid_ResponseParams',
    [
      mojo.internal.StructField(
        'localUid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UidGenerator_GetUid_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.localUid;
  }
}



mojo.internal.Struct(
    NotificationGenerator_ShowNotification_ParamsSpec.$,
    'NotificationGenerator_ShowNotification_Params',
    [
      mojo.internal.StructField(
        'title', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 16,
        0,
        WebNotificationTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NotificationGenerator_ShowNotification_Params {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.title;
    /** @type { !mojoBase_mojom_String16 } */
    this.message;
    /** @type { !WebNotificationType } */
    this.type;
  }
}



mojo.internal.Struct(
    NotificationGenerator_ShowToast_ParamsSpec.$,
    'NotificationGenerator_ShowToast_Params',
    [
      mojo.internal.StructField(
        'text', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NotificationGenerator_ShowToast_Params {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.text;
  }
}



mojo.internal.Struct(
    DisplayStreamHandler_StartStreaming_ParamsSpec.$,
    'DisplayStreamHandler_StartStreaming_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DisplayStreamHandler_StartStreaming_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    DisplayStreamHandler_OnStreamStatusChanged_ParamsSpec.$,
    'DisplayStreamHandler_OnStreamStatusChanged_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        StreamStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DisplayStreamHandler_OnStreamStatusChanged_Params {
  constructor() {
    /** @type { !StreamStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    DisplayStreamHandler_SetStreamActionObserver_ParamsSpec.$,
    'DisplayStreamHandler_SetStreamActionObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(StreamActionObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DisplayStreamHandler_SetStreamActionObserver_Params {
  constructor() {
    /** @type { !StreamActionObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    StreamActionObserver_OnStreamAction_ParamsSpec.$,
    'StreamActionObserver_OnStreamAction_Params',
    [
      mojo.internal.StructField(
        'action', 0,
        0,
        StreamActionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StreamActionObserver_OnStreamAction_Params {
  constructor() {
    /** @type { !StreamAction } */
    this.action;
  }
}



mojo.internal.Struct(
    StreamOrientationObserver_OnStreamOrientationChanged_ParamsSpec.$,
    'StreamOrientationObserver_OnStreamOrientationChanged_Params',
    [
      mojo.internal.StructField(
        'isLandscape', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class StreamOrientationObserver_OnStreamOrientationChanged_Params {
  constructor() {
    /** @type { !boolean } */
    this.isLandscape;
  }
}



mojo.internal.Struct(
    ConnectionStatusObserver_OnConnectionStatusChanged_ParamsSpec.$,
    'ConnectionStatusObserver_OnConnectionStatusChanged_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        ConnectionStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ConnectionStatusObserver_OnConnectionStatusChanged_Params {
  constructor() {
    /** @type { !ConnectionStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    KeyboardLayoutHandler_RequestCurrentKeyboardLayout_ParamsSpec.$,
    'KeyboardLayoutHandler_RequestCurrentKeyboardLayout_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class KeyboardLayoutHandler_RequestCurrentKeyboardLayout_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    KeyboardLayoutHandler_SetKeyboardLayoutObserver_ParamsSpec.$,
    'KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(KeyboardLayoutObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class KeyboardLayoutHandler_SetKeyboardLayoutObserver_Params {
  constructor() {
    /** @type { !KeyboardLayoutObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    KeyboardLayoutObserver_OnKeyboardLayoutChanged_ParamsSpec.$,
    'KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'longName', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'shortName', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'layoutTag', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class KeyboardLayoutObserver_OnKeyboardLayoutChanged_Params {
  constructor() {
    /** @type { !string } */
    this.id;
    /** @type { !string } */
    this.longName;
    /** @type { !string } */
    this.shortName;
    /** @type { !string } */
    this.layoutTag;
  }
}

