// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{FakeObservables}from"chrome://resources/ash/common/fake_observables.js";import{PromiseResolver}from"chrome://resources/ash/common/promise_resolver.js";import{assert}from"chrome://resources/js/assert.js";import{fakeDeviceRequest,fakeFirmwareUpdates,fakeInstallationProgress,fakeInstallationProgressFailure,fakeInstallationProgressWithRequest,fakeInstallationProgressWithRequestAndFailure}from"./fake_data.js";import{UpdateState}from"./firmware_update.mojom-webui.js";import{getUpdateProvider,setUseFakeProviders}from"./mojo_interface_provider.js";export const ON_PROGRESS_CHANGED="UpdateProgressObserver_onStatusChanged";export const ON_DEVICE_REQUEST="DeviceRequestObserver_onDeviceRequest";export class FakeUpdateController{constructor(){this.observables=new FakeObservables;this.completedFirmwareUpdates=new Set;this.startUpdatePromise=null;this.deviceId="";this.isUpdateInProgress=false;this.updateIntervalInMs=1e3;this.updateCompletedPromise=null;setUseFakeProviders(true);this.registerObservables()}addDeviceRequestObserver(remote){this.observables.observe(ON_DEVICE_REQUEST,(request=>{remote.onDeviceRequest(request)}))}addUpdateProgressObserver(remote){this.isUpdateInProgress=true;this.updateCompletedPromise=new PromiseResolver;this.startUpdatePromise=this.observeWithArg(ON_PROGRESS_CHANGED,this.deviceId,(update=>{remote.onStatusChanged(update);if(update.state===UpdateState.kSuccess||update.state===UpdateState.kFailed){this.isUpdateInProgress=false;this.completedFirmwareUpdates.add(this.deviceId);this.updateDeviceList();this.observables.stopTriggerOnIntervalWithArg(ON_PROGRESS_CHANGED,this.deviceId);assert(this.updateCompletedPromise);this.updateCompletedPromise.resolve()}}))}beginUpdate(deviceId,path){assert(deviceId);assert(path);assert(this.startUpdatePromise);if(deviceId=="4"){this.triggerProgressChangedObserverForInstallationProgress(fakeInstallationProgressWithRequest)}else if(deviceId=="5"){this.triggerProgressChangedObserverForInstallationProgress(fakeInstallationProgressWithRequestAndFailure)}else{this.triggerProgressChangedObserver()}}setDeviceIdForUpdateInProgress(deviceId){this.deviceId=deviceId}setFakeInstallationProgress(deviceId,installationProgress){this.observables.setObservableDataForArg(ON_PROGRESS_CHANGED,deviceId,installationProgress)}getStartUpdatePromiseForTesting(){return this.startUpdatePromise}async triggerProgressChangedObserverForInstallationProgress(allProgress){for(const progress of allProgress){this.observables.triggerWithArg(ON_PROGRESS_CHANGED,this.deviceId);if(progress.state===UpdateState.kWaitingForUser){this.observables.trigger(ON_DEVICE_REQUEST);await this.wait(this.updateIntervalInMs*2)}await this.wait(this.updateIntervalInMs)}}async wait(timeoutMs){return new Promise((resolve=>setTimeout((()=>resolve()),timeoutMs)))}triggerProgressChangedObserver(){this.observables.startTriggerOnIntervalWithArg(ON_PROGRESS_CHANGED,this.deviceId,this.updateIntervalInMs)}registerObservables(){this.observables.registerObservableWithArg(ON_PROGRESS_CHANGED);this.observables.register(ON_DEVICE_REQUEST);fakeFirmwareUpdates.flat().forEach((({deviceId:deviceId})=>{if(deviceId==="3"){this.setFakeInstallationProgress(deviceId,fakeInstallationProgressFailure)}else if(deviceId==="4"){this.observables.setObservableData(ON_DEVICE_REQUEST,[fakeDeviceRequest]);this.setFakeInstallationProgress(deviceId,fakeInstallationProgressWithRequest)}else if(deviceId==="5"){this.observables.setObservableData(ON_DEVICE_REQUEST,[fakeDeviceRequest]);this.setFakeInstallationProgress(deviceId,fakeInstallationProgressWithRequestAndFailure)}else{this.setFakeInstallationProgress(deviceId,fakeInstallationProgress)}}))}reset(){this.stopTriggerIntervals();this.observables=new FakeObservables;this.completedFirmwareUpdates.clear();this.deviceId="";this.isUpdateInProgress=false;this.registerObservables()}stopTriggerIntervals(){this.observables.stopAllTriggerIntervals()}observeWithArg(methodName,arg,callback){return new Promise((resolve=>{this.observables.observeWithArg(methodName,arg,callback);resolve()}))}getIsUpdateInProgressForTesting(){return this.isUpdateInProgress}setUpdateIntervalInMs(intervalMs){this.updateIntervalInMs=intervalMs}updateDeviceList(){const updatedFakeFirmwareUpdates=fakeFirmwareUpdates.flat().filter((u=>!this.completedFirmwareUpdates.has(u.deviceId)));const provider=getUpdateProvider();provider.setFakeFirmwareUpdates([updatedFakeFirmwareUpdates]);provider.triggerDeviceAddedObserver()}getUpdateCompletedPromiseForTesting(){assert(this.updateCompletedPromise!=null);return this.updateCompletedPromise.promise}getCompletedFirmwareUpdatesForTesting(){return this.completedFirmwareUpdates}}