// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{FilePathSpec as mojoBase_mojom_FilePathSpec}from"//resources/mojo/mojo/public/mojom/base/file_path.mojom-webui.js";import{String16Spec as mojoBase_mojom_String16Spec}from"//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js";export const UpdatePrioritySpec={$:mojo.internal.Enum()};export var UpdatePriority;(function(UpdatePriority){UpdatePriority[UpdatePriority["MIN_VALUE"]=0]="MIN_VALUE";UpdatePriority[UpdatePriority["MAX_VALUE"]=3]="MAX_VALUE";UpdatePriority[UpdatePriority["kLow"]=0]="kLow";UpdatePriority[UpdatePriority["kMedium"]=1]="kMedium";UpdatePriority[UpdatePriority["kHigh"]=2]="kHigh";UpdatePriority[UpdatePriority["kCritical"]=3]="kCritical"})(UpdatePriority||(UpdatePriority={}));export const UpdateStateSpec={$:mojo.internal.Enum()};export var UpdateState;(function(UpdateState){UpdateState[UpdateState["MIN_VALUE"]=0]="MIN_VALUE";UpdateState[UpdateState["MAX_VALUE"]=6]="MAX_VALUE";UpdateState[UpdateState["kUnknown"]=0]="kUnknown";UpdateState[UpdateState["kIdle"]=1]="kIdle";UpdateState[UpdateState["kUpdating"]=2]="kUpdating";UpdateState[UpdateState["kRestarting"]=3]="kRestarting";UpdateState[UpdateState["kFailed"]=4]="kFailed";UpdateState[UpdateState["kSuccess"]=5]="kSuccess";UpdateState[UpdateState["kWaitingForUser"]=6]="kWaitingForUser"})(UpdateState||(UpdateState={}));export const DeviceRequestIdSpec={$:mojo.internal.Enum()};export var DeviceRequestId;(function(DeviceRequestId){DeviceRequestId[DeviceRequestId["MIN_VALUE"]=0]="MIN_VALUE";DeviceRequestId[DeviceRequestId["MAX_VALUE"]=6]="MAX_VALUE";DeviceRequestId[DeviceRequestId["kDoNotPowerOff"]=0]="kDoNotPowerOff";DeviceRequestId[DeviceRequestId["kReplugInstall"]=1]="kReplugInstall";DeviceRequestId[DeviceRequestId["kInsertUSBCable"]=2]="kInsertUSBCable";DeviceRequestId[DeviceRequestId["kRemoveUSBCable"]=3]="kRemoveUSBCable";DeviceRequestId[DeviceRequestId["kPressUnlock"]=4]="kPressUnlock";DeviceRequestId[DeviceRequestId["kRemoveReplug"]=5]="kRemoveReplug";DeviceRequestId[DeviceRequestId["kReplugPower"]=6]="kReplugPower"})(DeviceRequestId||(DeviceRequestId={}));export const DeviceRequestKindSpec={$:mojo.internal.Enum()};export var DeviceRequestKind;(function(DeviceRequestKind){DeviceRequestKind[DeviceRequestKind["MIN_VALUE"]=0]="MIN_VALUE";DeviceRequestKind[DeviceRequestKind["MAX_VALUE"]=2]="MAX_VALUE";DeviceRequestKind[DeviceRequestKind["kUnknown"]=0]="kUnknown";DeviceRequestKind[DeviceRequestKind["kPost"]=1]="kPost";DeviceRequestKind[DeviceRequestKind["kImmediate"]=2]="kImmediate"})(DeviceRequestKind||(DeviceRequestKind={}));export class UpdateObserverPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.firmware_update.mojom.UpdateObserver",scope)}}export class UpdateObserverRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(UpdateObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onUpdateListChanged(firmwareUpdates){this.proxy.sendMessage(0,UpdateObserver_OnUpdateListChanged_ParamsSpec.$,null,[firmwareUpdates],false)}}export class UpdateObserverReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UpdateObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,UpdateObserver_OnUpdateListChanged_ParamsSpec.$,null,impl.onUpdateListChanged.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class UpdateObserver{static get $interfaceName(){return"ash.firmware_update.mojom.UpdateObserver"}static getRemote(){let remote=new UpdateObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class UpdateObserverCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UpdateObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onUpdateListChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,UpdateObserver_OnUpdateListChanged_ParamsSpec.$,null,this.onUpdateListChanged.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class DeviceRequestObserverPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.firmware_update.mojom.DeviceRequestObserver",scope)}}export class DeviceRequestObserverRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(DeviceRequestObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onDeviceRequest(request){this.proxy.sendMessage(0,DeviceRequestObserver_OnDeviceRequest_ParamsSpec.$,null,[request],false)}}export class DeviceRequestObserverReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DeviceRequestObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,DeviceRequestObserver_OnDeviceRequest_ParamsSpec.$,null,impl.onDeviceRequest.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class DeviceRequestObserver{static get $interfaceName(){return"ash.firmware_update.mojom.DeviceRequestObserver"}static getRemote(){let remote=new DeviceRequestObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class DeviceRequestObserverCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(DeviceRequestObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onDeviceRequest=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,DeviceRequestObserver_OnDeviceRequest_ParamsSpec.$,null,this.onDeviceRequest.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class UpdateProgressObserverPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.firmware_update.mojom.UpdateProgressObserver",scope)}}export class UpdateProgressObserverRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(UpdateProgressObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onStatusChanged(update){this.proxy.sendMessage(0,UpdateProgressObserver_OnStatusChanged_ParamsSpec.$,null,[update],false)}}export class UpdateProgressObserverReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UpdateProgressObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,UpdateProgressObserver_OnStatusChanged_ParamsSpec.$,null,impl.onStatusChanged.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class UpdateProgressObserver{static get $interfaceName(){return"ash.firmware_update.mojom.UpdateProgressObserver"}static getRemote(){let remote=new UpdateProgressObserverRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class UpdateProgressObserverCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UpdateProgressObserverRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onStatusChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,UpdateProgressObserver_OnStatusChanged_ParamsSpec.$,null,this.onStatusChanged.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class UpdateProviderPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.firmware_update.mojom.UpdateProvider",scope)}}export class UpdateProviderRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(UpdateProviderPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}observePeripheralUpdates(observer){this.proxy.sendMessage(0,UpdateProvider_ObservePeripheralUpdates_ParamsSpec.$,null,[observer],false)}prepareForUpdate(deviceId){return this.proxy.sendMessage(1,UpdateProvider_PrepareForUpdate_ParamsSpec.$,UpdateProvider_PrepareForUpdate_ResponseParamsSpec.$,[deviceId],false)}fetchInProgressUpdate(){return this.proxy.sendMessage(2,UpdateProvider_FetchInProgressUpdate_ParamsSpec.$,UpdateProvider_FetchInProgressUpdate_ResponseParamsSpec.$,[],false)}}export class UpdateProviderReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UpdateProviderRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,UpdateProvider_ObservePeripheralUpdates_ParamsSpec.$,null,impl.observePeripheralUpdates.bind(impl),false);this.helper_internal_.registerHandler(1,UpdateProvider_PrepareForUpdate_ParamsSpec.$,UpdateProvider_PrepareForUpdate_ResponseParamsSpec.$,impl.prepareForUpdate.bind(impl),false);this.helper_internal_.registerHandler(2,UpdateProvider_FetchInProgressUpdate_ParamsSpec.$,UpdateProvider_FetchInProgressUpdate_ResponseParamsSpec.$,impl.fetchInProgressUpdate.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class UpdateProvider{static get $interfaceName(){return"ash.firmware_update.mojom.UpdateProvider"}static getRemote(){let remote=new UpdateProviderRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class UpdateProviderCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UpdateProviderRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.observePeripheralUpdates=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,UpdateProvider_ObservePeripheralUpdates_ParamsSpec.$,null,this.observePeripheralUpdates.createReceiverHandler(false),false);this.prepareForUpdate=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,UpdateProvider_PrepareForUpdate_ParamsSpec.$,UpdateProvider_PrepareForUpdate_ResponseParamsSpec.$,this.prepareForUpdate.createReceiverHandler(true),false);this.fetchInProgressUpdate=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,UpdateProvider_FetchInProgressUpdate_ParamsSpec.$,UpdateProvider_FetchInProgressUpdate_ResponseParamsSpec.$,this.fetchInProgressUpdate.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class InstallControllerPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.firmware_update.mojom.InstallController",scope)}}export class InstallControllerRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(InstallControllerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}beginUpdate(deviceId,filepath){this.proxy.sendMessage(0,InstallController_BeginUpdate_ParamsSpec.$,null,[deviceId,filepath],false)}addDeviceRequestObserver(observer){this.proxy.sendMessage(1,InstallController_AddDeviceRequestObserver_ParamsSpec.$,null,[observer],false)}addUpdateProgressObserver(observer){this.proxy.sendMessage(2,InstallController_AddUpdateProgressObserver_ParamsSpec.$,null,[observer],false)}}export class InstallControllerReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(InstallControllerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,InstallController_BeginUpdate_ParamsSpec.$,null,impl.beginUpdate.bind(impl),false);this.helper_internal_.registerHandler(1,InstallController_AddDeviceRequestObserver_ParamsSpec.$,null,impl.addDeviceRequestObserver.bind(impl),false);this.helper_internal_.registerHandler(2,InstallController_AddUpdateProgressObserver_ParamsSpec.$,null,impl.addUpdateProgressObserver.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class InstallController{static get $interfaceName(){return"ash.firmware_update.mojom.InstallController"}static getRemote(){let remote=new InstallControllerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class InstallControllerCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(InstallControllerRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.beginUpdate=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,InstallController_BeginUpdate_ParamsSpec.$,null,this.beginUpdate.createReceiverHandler(false),false);this.addDeviceRequestObserver=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,InstallController_AddDeviceRequestObserver_ParamsSpec.$,null,this.addDeviceRequestObserver.createReceiverHandler(false),false);this.addUpdateProgressObserver=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,InstallController_AddUpdateProgressObserver_ParamsSpec.$,null,this.addUpdateProgressObserver.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class SystemUtilsPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.firmware_update.mojom.SystemUtils",scope)}}export class SystemUtilsRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(SystemUtilsPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}restart(){this.proxy.sendMessage(0,SystemUtils_Restart_ParamsSpec.$,null,[],false)}}export class SystemUtilsReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SystemUtilsRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,SystemUtils_Restart_ParamsSpec.$,null,impl.restart.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class SystemUtils{static get $interfaceName(){return"ash.firmware_update.mojom.SystemUtils"}static getRemote(){let remote=new SystemUtilsRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class SystemUtilsCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SystemUtilsRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.restart=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,SystemUtils_Restart_ParamsSpec.$,null,this.restart.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const FirmwareUpdateSpec={$:{}};export const InstallationProgressSpec={$:{}};export const DeviceRequestSpec={$:{}};export const UpdateObserver_OnUpdateListChanged_ParamsSpec={$:{}};export const DeviceRequestObserver_OnDeviceRequest_ParamsSpec={$:{}};export const UpdateProgressObserver_OnStatusChanged_ParamsSpec={$:{}};export const UpdateProvider_ObservePeripheralUpdates_ParamsSpec={$:{}};export const UpdateProvider_PrepareForUpdate_ParamsSpec={$:{}};export const UpdateProvider_PrepareForUpdate_ResponseParamsSpec={$:{}};export const UpdateProvider_FetchInProgressUpdate_ParamsSpec={$:{}};export const UpdateProvider_FetchInProgressUpdate_ResponseParamsSpec={$:{}};export const InstallController_BeginUpdate_ParamsSpec={$:{}};export const InstallController_AddDeviceRequestObserver_ParamsSpec={$:{}};export const InstallController_AddUpdateProgressObserver_ParamsSpec={$:{}};export const SystemUtils_Restart_ParamsSpec={$:{}};mojo.internal.Struct(FirmwareUpdateSpec.$,"FirmwareUpdate",[mojo.internal.StructField("deviceId",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("deviceName",8,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("needsReboot",16,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("deviceVersion",24,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("deviceDescription",32,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("priority",20,0,UpdatePrioritySpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("filepath",40,0,mojoBase_mojom_FilePathSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("checksum",48,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,64]]);mojo.internal.Struct(InstallationProgressSpec.$,"InstallationProgress",[mojo.internal.StructField("percentage",0,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("state",4,0,UpdateStateSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(DeviceRequestSpec.$,"DeviceRequest",[mojo.internal.StructField("id",0,0,DeviceRequestIdSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("kind",4,0,DeviceRequestKindSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UpdateObserver_OnUpdateListChanged_ParamsSpec.$,"UpdateObserver_OnUpdateListChanged_Params",[mojo.internal.StructField("firmwareUpdates",0,0,mojo.internal.Array(FirmwareUpdateSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(DeviceRequestObserver_OnDeviceRequest_ParamsSpec.$,"DeviceRequestObserver_OnDeviceRequest_Params",[mojo.internal.StructField("request",0,0,DeviceRequestSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UpdateProgressObserver_OnStatusChanged_ParamsSpec.$,"UpdateProgressObserver_OnStatusChanged_Params",[mojo.internal.StructField("update",0,0,InstallationProgressSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UpdateProvider_ObservePeripheralUpdates_ParamsSpec.$,"UpdateProvider_ObservePeripheralUpdates_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(UpdateObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UpdateProvider_PrepareForUpdate_ParamsSpec.$,"UpdateProvider_PrepareForUpdate_Params",[mojo.internal.StructField("deviceId",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UpdateProvider_PrepareForUpdate_ResponseParamsSpec.$,"UpdateProvider_PrepareForUpdate_ResponseParams",[mojo.internal.StructField("controller",0,0,mojo.internal.InterfaceProxy(InstallControllerRemote),null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UpdateProvider_FetchInProgressUpdate_ParamsSpec.$,"UpdateProvider_FetchInProgressUpdate_Params",[],[[0,8]]);mojo.internal.Struct(UpdateProvider_FetchInProgressUpdate_ResponseParamsSpec.$,"UpdateProvider_FetchInProgressUpdate_ResponseParams",[mojo.internal.StructField("update",0,0,FirmwareUpdateSpec.$,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(InstallController_BeginUpdate_ParamsSpec.$,"InstallController_BeginUpdate_Params",[mojo.internal.StructField("deviceId",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("filepath",8,0,mojoBase_mojom_FilePathSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(InstallController_AddDeviceRequestObserver_ParamsSpec.$,"InstallController_AddDeviceRequestObserver_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(DeviceRequestObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(InstallController_AddUpdateProgressObserver_ParamsSpec.$,"InstallController_AddUpdateProgressObserver_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(UpdateProgressObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(SystemUtils_Restart_ParamsSpec.$,"SystemUtils_Restart_Params",[],[[0,8]]);