import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style include="firmware-shared-fonts firmware-shared">:host{--cr-dialog-width:416px}:host(:not([update-is-done])) ::part(wrapper){min-height:300px}:host(:not([update-is-done])) [slot='footer']{display:flex;flex:1;flex-direction:column;justify-content:flex-end;margin-bottom:4px}[slot='button-container']{display:flex;gap:10px;justify-content:flex-end}[slot='footer']{border:none}#updateDialogBody{min-height:100px}#progress{display:inline-block;margin:8px 0}paper-progress{--paper-progress-active-color:var(--cros-slider-color-active);--paper-progress-container-color:var(--cros-slider-track-color-active);--paper-progress-height:4px;border-radius:5px;display:inline-block;margin-bottom:8px;width:95%}</style>
<template is="dom-if"
    if="[[shouldShowUpdateDialog(installationProgress.*,
        isInitiallyInflight)]]" restamp>
  <cr-dialog id="updateDialog" show-on-attach
      on-close="closeDialog">
    <div slot="title" id="updateDialogTitle" class="firmware-dialog-title-font"
        aria-labelledby="updateDialogTitle" aria-live="polite">
      [[dialogContent.title]]
    </div>
    <div slot="body" class="firmware-dialog-body-font">
      <div id="updateDialogBody" aria-live="[[getDialogBodyAriaLive(installationProgress.*,
                                              lastDeviceRequestId)]]">
        [[dialogContent.body]]
      </div>
    </div>
    <div slot="footer"
        hidden$="[[!shouldShowProgressBar(installationProgress.*,
                   isInitiallyInflight, lastDeviceRequestId)]]">
      <label id="progress" class="firmware-dialog-installing-font"
          aria-live="polite">
        [[dialogContent.footer]]
      </label>
      <template is="dom-if"
          if="[[!isInIndeterminateState(installationProgress.*,
                lastDeviceRequestId)]]" restamp>
        <paper-progress id="updateProgressBar"
            value="[[computePercentageValue(installationProgress.percentage)]]"
            max="100" disabled="[[isProgressBarDisabled(installationProgress.*,
                                  lastDeviceRequestId)]]">
        </paper-progress>
      </template>
      <template is="dom-if"
          if="[[isInIndeterminateState(installationProgress.*,
                lastDeviceRequestId)]]" restamp>
        <paper-progress id="indeterminateProgressBar" indeterminate>
        </paper-progress>
      </template>
    </div>
    <div slot="button-container"
        hidden$="[[!isUpdateDone(installationProgress.state)]]">
      <template is="dom-if"
          if="[[!isUpdateSuccessfulAndRequiresReboot(updateIsDone)]]" restamp>
        <cr-button class="action-button"
            on-click="closeDialog"
            id="updateDoneButton">
          [[computeButtonText(installationProgress.state)]]
        </cr-button>
      </template>
      <template is="dom-if"
          if="[[isUpdateSuccessfulAndRequiresReboot(updateIsDone)]]" restamp>
        <cr-button class="cancel-button"
            on-click="closeDialog"
            id="restartLaterButton">
          [[i18n('restartLaterButton')]]
        </cr-button>
        <cr-button class="action-button"
            on-click="restartDevice"
            id="restartNowButton">
          [[i18n('restartNowButton')]]
        </cr-button>
      </template>
    </div>
  </cr-dialog>
</template>
<!--_html_template_end_-->`}