// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_dialog/cr_dialog.js";import"chrome://resources/mojo/mojo/public/mojom/base/big_buffer.mojom-webui.js";import"chrome://resources/mojo/mojo/public/mojom/base/file_path.mojom-webui.js";import"chrome://resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js";import"chrome://resources/polymer/v3_0/paper-progress/paper-progress.js";import"./firmware_shared.css.js";import"./firmware_shared_fonts.css.js";import"./firmware_update.mojom-webui.js";import"/strings.m.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{assert}from"chrome://resources/js/assert.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{DeviceRequestId,DeviceRequestKind,DeviceRequestObserverReceiver,UpdateProgressObserverReceiver,UpdateState}from"./firmware_update.mojom-webui.js";import{getTemplate}from"./firmware_update_dialog.html.js";import{isAppV2Enabled}from"./firmware_update_utils.js";import{getSystemUtils,getUpdateProvider}from"./mojo_interface_provider.js";const initialDialogContent={title:"",body:"",footer:""};const initialInstallationProgress={percentage:0,state:UpdateState.kIdle};const FirmwareUpdateDialogElementBase=I18nMixin(PolymerElement);export class FirmwareUpdateDialogElement extends FirmwareUpdateDialogElementBase{constructor(){super(...arguments);this.update=null;this.isInitiallyInflight=false;this.lastDeviceRequestId=null;this.dialogContent=initialDialogContent;this.updateProvider=getUpdateProvider();this.installController=null;this.updateProgressObserverReceiver=null;this.deviceRequestObserverReceiver=null;this.systemUtils=getSystemUtils();this.inactiveDialogStates=[UpdateState.kUnknown,UpdateState.kIdle]}static get is(){return"firmware-update-dialog"}static get template(){return getTemplate()}static get properties(){return{update:{type:Object},installationProgress:{type:Object,value:initialInstallationProgress,observer:FirmwareUpdateDialogElement.prototype.installationProgressChanged},isInitiallyInflight:{value:false},dialogContent:{type:Object,value:initialDialogContent,computed:"computeDialogContent(installationProgress.*,"+"isInitiallyInflight, lastDeviceRequestId)"},updateIsDone:{type:Boolean,value:false,computed:"isUpdateDone(installationProgress.state)",reflectToAttribute:true},lastDeviceRequestId:{type:Object,value:null}}}connectedCallback(){super.connectedCallback();if(!isAppV2Enabled()){this.inactiveDialogStates.push(UpdateState.kWaitingForUser)}window.addEventListener("open-update-dialog",(e=>this.onOpenUpdateDialog(e)))}onDeviceRequest(request){assert(isAppV2Enabled());if(request.kind!==DeviceRequestKind.kImmediate){return}this.lastDeviceRequestId=request.id}onStatusChanged(update){if(isAppV2Enabled()&&update.state!==UpdateState.kWaitingForUser&&this.installationProgress.state===UpdateState.kWaitingForUser){this.lastDeviceRequestId=null}if(update.state===UpdateState.kSuccess||update.state===UpdateState.kFailed){this.isInitiallyInflight=false}this.installationProgress=update}installationProgressChanged(prevProgress,currProgress){if(!currProgress||prevProgress.state==currProgress.state){return}assert(this.shadowRoot);const dialogTitle=this.shadowRoot.querySelector("#updateDialogTitle");if(dialogTitle){dialogTitle.focus()}}closeDialog(){this.isInitiallyInflight=false;this.installationProgress=initialInstallationProgress;this.update=null}async prepareForUpdate(){assert(this.update);const response=await this.updateProvider.prepareForUpdate(this.update.deviceId);if(!response.controller){return}this.installController=response.controller;this.bindReceiverAndMaybeStartUpdate()}bindReceiverAndMaybeStartUpdate(){this.updateProgressObserverReceiver=new UpdateProgressObserverReceiver(this);assert(this.installController);this.installController.addUpdateProgressObserver(this.updateProgressObserverReceiver.$.bindNewPipeAndPassRemote());if(isAppV2Enabled()){this.deviceRequestObserverReceiver=new DeviceRequestObserverReceiver(this);this.installController.addDeviceRequestObserver(this.deviceRequestObserverReceiver.$.bindNewPipeAndPassRemote())}if(!this.isInitiallyInflight){assert(this.update);this.installController.beginUpdate(this.update.deviceId,this.update.filepath)}}shouldShowUpdateDialog(){if(!this.update){return false}if(this.isInitiallyInflight){return true}const activeDialogStates=[UpdateState.kUpdating,UpdateState.kRestarting,UpdateState.kFailed,UpdateState.kSuccess];if(isAppV2Enabled()){activeDialogStates.push(UpdateState.kWaitingForUser)}return activeDialogStates.includes(this.installationProgress.state)||this.installationProgress.percentage>0}computePercentageValue(){if(this.installationProgress?.percentage){return this.installationProgress.percentage}return 0}isUpdateInProgress(){if(this.inactiveDialogStates.includes(this.installationProgress.state)){return this.installationProgress.percentage>0}return this.installationProgress.state===UpdateState.kUpdating}isDeviceRestarting(){return this.installationProgress.state===UpdateState.kRestarting}shouldShowProgressBar(){const showProgressBar=this.isUpdateInProgress()||this.isDeviceRestarting()||this.isWaitingForUserAction()||this.isInitiallyInflight;assert(this.shadowRoot);const progressIsActiveEl=this.shadowRoot.activeElement==this.shadowRoot.querySelector("#progress");const dialogTitle=this.shadowRoot.querySelector("#updateDialogTitle");if(progressIsActiveEl&&!showProgressBar&&dialogTitle){dialogTitle.focus()}return showProgressBar}isUpdateDone(){return this.installationProgress.state===UpdateState.kSuccess||this.installationProgress.state===UpdateState.kFailed}createRequestDialogContent(){assert(this.update);const{deviceName:deviceName}=this.update;const{percentage:percentage}=this.installationProgress;assert(this.lastDeviceRequestId!==null);const deviceNameString=deviceName;return{title:this.i18n("updating",deviceNameString),body:this.getI18nStringForDeviceRequestId(this.lastDeviceRequestId,deviceNameString),footer:this.i18n("waitingFooterText",percentage)}}createDialogContentObj(state){assert(this.update);const{deviceName:deviceName,deviceVersion:deviceVersion,needsReboot:needsReboot}=this.update;const{percentage:percentage}=this.installationProgress;const dialogContent=new Map([[UpdateState.kUpdating,{title:this.i18n("updating",deviceName),body:this.i18n("updatingInfo"),footer:this.i18n("installing",percentage)}],[UpdateState.kRestarting,{title:this.i18n("restartingTitleText",deviceName),body:this.i18n("restartingBodyText"),footer:this.i18n("restartingFooterText")}],[UpdateState.kFailed,{title:this.i18n("updateFailedTitleText",deviceName),body:this.i18n("updateFailedBodyText"),footer:""}]]);if(needsReboot){dialogContent.set(UpdateState.kSuccess,{title:this.i18n("deviceReadyToInstallUpdate",deviceName),body:this.i18n("deviceNeedsReboot",deviceName,deviceVersion),footer:""})}else{dialogContent.set(UpdateState.kSuccess,{title:this.i18n("deviceUpToDate",deviceName),body:this.i18n("hasBeenUpdated",deviceName,deviceVersion),footer:""})}assert(dialogContent.has(state));return dialogContent.get(state)}computeDialogContent(){if(!this.isInitiallyInflight&&!this.update){return initialDialogContent}if(this.inactiveDialogStates.includes(this.installationProgress.state)||this.isDeviceRestarting()){return this.createDialogContentObj(UpdateState.kRestarting)}if(this.isInitiallyInflight||this.isUpdateInProgress()){return this.createDialogContentObj(UpdateState.kUpdating)}if(isAppV2Enabled()&&this.installationProgress.state===UpdateState.kWaitingForUser){if(this.lastDeviceRequestId===null){return this.createDialogContentObj(UpdateState.kUpdating)}else{return this.createRequestDialogContent()}}if(this.isUpdateDone()){return this.createDialogContentObj(this.installationProgress.state)}return initialDialogContent}isInIndeterminateState(){if(this.installationProgress){return this.inactiveDialogStates.includes(this.installationProgress.state)||this.isDeviceRestarting()}return false}isProgressBarDisabled(){return this.isWaitingForUserAction()}isUpdateSuccessfulAndRequiresReboot(){assert(this.update);return this.installationProgress.state===UpdateState.kSuccess&&this.update.needsReboot}computeButtonText(){if(!this.isUpdateDone()){return""}return this.installationProgress.state===UpdateState.kSuccess?this.i18n("doneButton"):this.i18n("okButton")}restartDevice(){assert(this.isUpdateDone());this.systemUtils.restart();return}isDialogOpen(){assert(this.shadowRoot);return!!this.shadowRoot.querySelector("#updateDialog")}onOpenUpdateDialog(e){this.update=e.detail.update;this.isInitiallyInflight=e.detail.inflight;this.prepareForUpdate()}setIsInitiallyInflightForTesting(isInitiallyInflight){this.isInitiallyInflight=isInitiallyInflight}isWaitingForUserAction(){return isAppV2Enabled()&&this.lastDeviceRequestId!==null&&this.installationProgress.state===UpdateState.kWaitingForUser}getDialogBodyAriaLive(){return this.isWaitingForUserAction()?"assertive":""}getStringIdForDeviceRequestId(deviceRequestId){switch(deviceRequestId){case DeviceRequestId.kDoNotPowerOff:return"requestIdDoNotPowerOff";case DeviceRequestId.kReplugInstall:return"requestIdReplugInstall";case DeviceRequestId.kInsertUSBCable:return"requestIdInsertUsbCable";case DeviceRequestId.kRemoveUSBCable:return"requestIdRemoveUsbCable";case DeviceRequestId.kPressUnlock:return"requestIdPressUnlock";case DeviceRequestId.kRemoveReplug:return"requestIdRemoveReplug";case DeviceRequestId.kReplugPower:return"requestIdReplugPower"}}getI18nStringForDeviceRequestId(deviceRequestId,deviceName){const requestStringId=this.getStringIdForDeviceRequestId(deviceRequestId);if(deviceRequestId==DeviceRequestId.kDoNotPowerOff){return this.i18n(requestStringId)}return this.i18n(requestStringId,deviceName)}}customElements.define(FirmwareUpdateDialogElement.is,FirmwareUpdateDialogElement);