import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="firmware-shared-fonts firmware-shared">:host{--cr-dialog-width:416px;--disclaimer-icon-size:16px}#proceedText{white-space:pre-line}#disclaimer{align-items:center;display:flex;flex-direction:row;margin-bottom:16px}#disclaimer-icon{align-items:center;background:var(--cros-sys-warning_container);border-radius:8px;display:flex;flex:0 0 auto;height:24px;justify-content:center;margin-inline-end:8px;width:24px}#disclaimer-icon iron-icon{--iron-icon-fill-color:var(--cros-sys-on_warning_container);--iron-icon-height:var(--disclaimer-icon-size);--iron-icon-width:var(--disclaimer-icon-size)}#disclaimer-text{color:var(--cros-sys-on_warning_container);font:var(--cros-annotation-2-font);flex:1}</style>
<template is="dom-if" if="[[open]]" restamp>
  <cr-dialog id="confirmationDialog" on-close="closeDialog" show-on-attach>
    <div slot="title" id="updateDialogTitle" class="firmware-dialog-title-font">
      [[computeTitle(update.*)]]
    </div>
    <div slot="body" class="firmware-dialog-body-font">
      <div id="disclaimer">
        <div id="disclaimer-icon" aria-label="[[i18n('confirmationDisclaimerIconAriaLabel')]]">
          <iron-icon icon="firmware-updates:warning" aria-hidden="true"></iron-icon>
        </div>
        <div id="disclaimer-text">[[computeDisclaimer()]]</div>
      </div>
      <div id="updateDialogBody">
        [[computeDialog()]]
      </div>
      <div id="proceedText">
        [[i18n('proceedConfirmationText')]]
      </div>
    </div>
    <div slot="button-container">
      <cr-button class="cancel-button"
          on-click="closeDialog"
          id="cancelButton">
        [[i18n('cancelButton')]]
      </cr-button>
      <cr-button class="action-button"
          on-click="openUpdateDialog"
          id="nextButton">
        [[i18n('nextButton')]]
      </cr-button>
    </div>
  </cr-dialog>
</template>
<!--_html_template_end_-->`;
}
