import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="firmware-shared-fonts firmware-shared">#container{border-bottom:var(--cr-separator-height) solid var(--cros-separator-color);display:flex;justify-content:space-between;margin-bottom:12px}#description{margin-bottom:8px}#name{margin-bottom:2px}#version{margin-bottom:4px}#priorityText::before{content:'•';margin-inline:8px}.update-info{margin-inline-end:48px}.update-info>div{margin:8px 0}</style>
<div id="container">
  <div class="update-info">
    <div id="name" class="firmware-name-font" aria-hidden="true">
      [[computeDeviceName(update.deviceName)]]
    </div>
    <div id="version" class="firmware-version-font" aria-hidden="true">
      <span>[[computeVersionText(update.deviceVersion)]]</span>
      <span id ="priorityText"
          hidden$="[[!isCriticalUpdate(update.priority)]]">
        [[i18n('criticalUpdate')]]
      </span>
    </div>
  </div>
  <cr-button id="updateButton" on-click="onUpdateButtonClicked"
      disabled="[[disabled]]" aria-label="[[getUpdateButtonA11yLabel()]]">
    [[i18n('updateButton')]]
  </cr-button>
</div>
<!--_html_template_end_-->`;
}
