// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import 'chrome://resources/ash/common/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/mojo/mojo/public/mojom/base/big_buffer.mojom-webui.js';
import 'chrome://resources/mojo/mojo/public/mojom/base/file_path.mojom-webui.js';
import 'chrome://resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
import './firmware_shared.css.js';
import './firmware_shared_fonts.css.js';
import './firmware_update.mojom-webui.js';
import '/strings.m.js';
import { I18nMixin } from 'chrome://resources/ash/common/cr_elements/i18n_mixin.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { UpdatePriority } from './firmware_update.mojom-webui.js';
import { getTemplate } from './update_card.html.js';
/**
 * @fileoverview
 * 'update-card' displays information about a peripheral update.
 */
const UpdateCardElementBase = I18nMixin(PolymerElement);
export class UpdateCardElement extends UpdateCardElementBase {
    static get is() {
        return 'update-card';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            update: {
                type: Object,
            },
            disabled: {
                type: Boolean,
            },
        };
    }
    isCriticalUpdate() {
        return this.update.priority === UpdatePriority.kCritical;
    }
    onUpdateButtonClicked() {
        this.dispatchEvent(new CustomEvent('open-confirmation-dialog', { bubbles: true, composed: true, detail: { update: this.update } }));
    }
    computeVersionText() {
        if (!this.update.deviceVersion) {
            return '';
        }
        return this.i18n('versionText', this.update.deviceVersion);
    }
    computeDeviceName() {
        return this.update.deviceName;
    }
    getUpdateButtonA11yLabel() {
        const version = this.update.deviceVersion ?? '';
        return this.i18n('updateButtonA11yLabel', this.computeDeviceName(), version);
    }
}
customElements.define(UpdateCardElement.is, UpdateCardElement);
