// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{MediaClientReceiver,PlaybackState,TrackProvider}from"./focus_mode.mojom-webui.js";const UNTRUSTED_ORIGIN="chrome-untrusted://focus-mode-player";let clientInstance=null;let providerInstance=null;const reportConfig={intervalShort:10,intervalLong:40,intervalThreshold:40,intervalId:setInterval((()=>postQueryPlaybackStatusRequest()),2e3)};let playbackStatus=null;let currentTrack=null;let clientTimeLastReport;const validStates=["playing","paused","ended","switchedtonext"];function isValidPlaybackStatus(playbackStatus){return validStates.includes(playbackStatus.state)&&playbackStatus.position>=0&&playbackStatus.position<=18e3}function getPlaybackState(playbackStateString){switch(playbackStateString){case"playing":return PlaybackState.kPlaying;case"paused":return PlaybackState.kPaused;case"switchedtonext":return PlaybackState.kSwitchedToNext;case"ended":return PlaybackState.kEnded}return PlaybackState.kNone}function getDuration(oldPlaybackStatus,newPlaybackStatus){return[Math.floor(oldPlaybackStatus?.position??0),Math.floor(newPlaybackStatus?.position??0)]}function shouldReportPlayback(newPlaybackStatus){const[start,end]=getDuration(playbackStatus,newPlaybackStatus);const interval=end<=reportConfig.intervalThreshold?reportConfig.intervalShort:reportConfig.intervalLong;return start<end&&(end-start+1>=interval||newPlaybackStatus.state=="ended"||newPlaybackStatus.state=="switchedtonext")}function onReceiveNewPlaybackStatus(newPlaybackStatus){if(currentTrack==null||!currentTrack.enablePlaybackReporting||!isValidPlaybackStatus(newPlaybackStatus)){return}const clientCurrentTime=new Date;const playbackStartOffset=Math.floor((clientCurrentTime.getTime()-newPlaybackStatus.loadTime.getTime())/1e3);const initial=playbackStatus==null;if(shouldReportPlayback(newPlaybackStatus)){const[start,end]=getDuration(playbackStatus,newPlaybackStatus);getProvider().reportPlayback({state:getPlaybackState(newPlaybackStatus.state),title:currentTrack.title,url:currentTrack.mediaUrl,clientCurrentTime:clientCurrentTime,playbackStartOffset:playbackStartOffset,mediaTimeCurrent:newPlaybackStatus.position,mediaStart:start,mediaEnd:end,clientStartTime:initial?newPlaybackStatus.loadTime:clientTimeLastReport,initialPlayback:initial});playbackStatus=newPlaybackStatus;clientTimeLastReport=clientCurrentTime}if(newPlaybackStatus.state=="ended"||newPlaybackStatus.state=="switchedtonext"){currentTrack=null}}function isEventData(data){return data&&typeof data==="object"&&typeof data.cmd==="string"}function isNextTrackEventData(data){return isEventData(data)&&data.cmd=="gettrack"}function isPlaybackStatus(data){return isEventData(data)&&data.cmd=="replyplaybackstatus"&&typeof data.state==="string"&&typeof data.position==="number"&&typeof data.loadTime==="object"&&data.loadTime instanceof Date}function isMediaErrorEventData(data){return isEventData(data)&&data.cmd=="mediaErrorEvent"}function getProvider(){if(!providerInstance){providerInstance=TrackProvider.getRemote()}return providerInstance}function postPlayRequest(track){if(!track.mediaUrl.url){getProvider().reportPlayerError();return}const child=document.getElementById("child");if(child.contentWindow){playbackStatus=null;currentTrack=track;child.contentWindow.postMessage({cmd:"play",arg:{mediaUrl:track.mediaUrl.url,thumbnailUrl:track.thumbnailUrl.url,title:track.title,artist:track.artist}},UNTRUSTED_ORIGIN)}}function postQueryPlaybackStatusRequest(){if(currentTrack==null||!currentTrack.enablePlaybackReporting){return}const child=document.getElementById("child");if(child.contentWindow){child.contentWindow.postMessage({cmd:"queryplaybackstatus"},UNTRUSTED_ORIGIN)}}class MediaClientImpl{constructor(){this.receiver_=this.initReceiver_()}static init(){if(!clientInstance){clientInstance=new MediaClientImpl}}static shutdown(){if(clientInstance){clientInstance.receiver_.$.close();clientInstance=null}}startPlay(track){postPlayRequest(track)}initReceiver_(){const receiver=new MediaClientReceiver(this);getProvider().setMediaClient(receiver.$.bindNewPipeAndPassRemote());return receiver}}globalThis.addEventListener("load",(()=>{MediaClientImpl.init()}));let requestInProgress=false;globalThis.addEventListener("message",(async event=>{if(event.origin!=UNTRUSTED_ORIGIN){return}const data=event.data;if(isEventData(data)){if(isNextTrackEventData(data)){if(requestInProgress){return}requestInProgress=true;const result=await getProvider().getTrack();requestInProgress=false;postPlayRequest(result.track)}else if(isPlaybackStatus(data)){onReceiveNewPlaybackStatus({state:data.state,position:data.position,loadTime:data.loadTime})}else if(isMediaErrorEventData(data)){getProvider().reportPlayerError()}}}));