// ash/webui/focus_mode/mojom/focus_mode.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { JSTimeSpec as mojoBase_mojom_JSTimeSpec } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const PlaybackStateSpec = { $: mojo.internal.Enum() };
export var PlaybackState;
(function (PlaybackState) {
    PlaybackState[PlaybackState["MIN_VALUE"] = 0] = "MIN_VALUE";
    PlaybackState[PlaybackState["MAX_VALUE"] = 4] = "MAX_VALUE";
    PlaybackState[PlaybackState["kPlaying"] = 0] = "kPlaying";
    PlaybackState[PlaybackState["kPaused"] = 1] = "kPaused";
    PlaybackState[PlaybackState["kSwitchedToNext"] = 2] = "kSwitchedToNext";
    PlaybackState[PlaybackState["kEnded"] = 3] = "kEnded";
    PlaybackState[PlaybackState["kNone"] = 4] = "kNone";
})(PlaybackState || (PlaybackState = {}));
export class MediaClientPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.focus_mode.mojom.MediaClient', scope);
    }
}
export class MediaClientRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(MediaClientPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    startPlay(track) {
        this.proxy.sendMessage(0, MediaClient_StartPlay_ParamsSpec.$, null, [
            track
        ], false);
    }
}
;
/**
 * An object which receives request messages for the MediaClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaClientReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MediaClientRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, MediaClient_StartPlay_ParamsSpec.$, null, impl.startPlay.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class MediaClient {
    static get $interfaceName() {
        return "ash.focus_mode.mojom.MediaClient";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new MediaClientRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the MediaClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaClientCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MediaClientRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.startPlay =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, MediaClient_StartPlay_ParamsSpec.$, null, this.startPlay.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class TrackProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.focus_mode.mojom.TrackProvider', scope);
    }
}
export class TrackProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(TrackProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getTrack() {
        return this.proxy.sendMessage(0, TrackProvider_GetTrack_ParamsSpec.$, TrackProvider_GetTrack_ResponseParamsSpec.$, [], false);
    }
    setMediaClient(client) {
        this.proxy.sendMessage(1, TrackProvider_SetMediaClient_ParamsSpec.$, null, [
            client
        ], false);
    }
    reportPlayback(data) {
        this.proxy.sendMessage(2, TrackProvider_ReportPlayback_ParamsSpec.$, null, [
            data
        ], false);
    }
    reportPlayerError() {
        this.proxy.sendMessage(3, TrackProvider_ReportPlayerError_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the TrackProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TrackProviderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TrackProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, TrackProvider_GetTrack_ParamsSpec.$, TrackProvider_GetTrack_ResponseParamsSpec.$, impl.getTrack.bind(impl), false);
        this.helper_internal_.registerHandler(1, TrackProvider_SetMediaClient_ParamsSpec.$, null, impl.setMediaClient.bind(impl), false);
        this.helper_internal_.registerHandler(2, TrackProvider_ReportPlayback_ParamsSpec.$, null, impl.reportPlayback.bind(impl), false);
        this.helper_internal_.registerHandler(3, TrackProvider_ReportPlayerError_ParamsSpec.$, null, impl.reportPlayerError.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class TrackProvider {
    static get $interfaceName() {
        return "ash.focus_mode.mojom.TrackProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new TrackProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the TrackProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TrackProviderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TrackProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getTrack =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, TrackProvider_GetTrack_ParamsSpec.$, TrackProvider_GetTrack_ResponseParamsSpec.$, this.getTrack.createReceiverHandler(true /* expectsResponse */), false);
        this.setMediaClient =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, TrackProvider_SetMediaClient_ParamsSpec.$, null, this.setMediaClient.createReceiverHandler(false /* expectsResponse */), false);
        this.reportPlayback =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, TrackProvider_ReportPlayback_ParamsSpec.$, null, this.reportPlayback.createReceiverHandler(false /* expectsResponse */), false);
        this.reportPlayerError =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, TrackProvider_ReportPlayerError_ParamsSpec.$, null, this.reportPlayerError.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const TrackDefinitionSpec = { $: {} };
export const PlaybackDataSpec = { $: {} };
export const MediaClient_StartPlay_ParamsSpec = { $: {} };
export const TrackProvider_GetTrack_ParamsSpec = { $: {} };
export const TrackProvider_GetTrack_ResponseParamsSpec = { $: {} };
export const TrackProvider_SetMediaClient_ParamsSpec = { $: {} };
export const TrackProvider_ReportPlayback_ParamsSpec = { $: {} };
export const TrackProvider_ReportPlayerError_ParamsSpec = { $: {} };
mojo.internal.Struct(TrackDefinitionSpec.$, 'TrackDefinition', [
    mojo.internal.StructField('title', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('artist', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('thumbnailUrl', 16, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('mediaUrl', 24, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enablePlaybackReporting', 32, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(PlaybackDataSpec.$, 'PlaybackData', [
    mojo.internal.StructField('state', 0, 0, PlaybackStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 16, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('clientCurrentTime', 24, 0, mojoBase_mojom_JSTimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('playbackStartOffset', 4, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('mediaTimeCurrent', 32, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('mediaStart', 36, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('mediaEnd', 40, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('clientStartTime', 48, 0, mojoBase_mojom_JSTimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('initialPlayback', 44, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 64],]);
mojo.internal.Struct(MediaClient_StartPlay_ParamsSpec.$, 'MediaClient_StartPlay_Params', [
    mojo.internal.StructField('track', 0, 0, TrackDefinitionSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TrackProvider_GetTrack_ParamsSpec.$, 'TrackProvider_GetTrack_Params', [], [[0, 8],]);
mojo.internal.Struct(TrackProvider_GetTrack_ResponseParamsSpec.$, 'TrackProvider_GetTrack_ResponseParams', [
    mojo.internal.StructField('track', 0, 0, TrackDefinitionSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TrackProvider_SetMediaClient_ParamsSpec.$, 'TrackProvider_SetMediaClient_Params', [
    mojo.internal.StructField('client', 0, 0, mojo.internal.InterfaceProxy(MediaClientRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TrackProvider_ReportPlayback_ParamsSpec.$, 'TrackProvider_ReportPlayback_Params', [
    mojo.internal.StructField('data', 0, 0, PlaybackDataSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TrackProvider_ReportPlayerError_ParamsSpec.$, 'TrackProvider_ReportPlayerError_Params', [], [[0, 8],]);
