// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./graduation_error.js";import"./graduation_offline.js";import"./graduation_takeout_ui.js";import"./graduation_welcome.js";import"chrome://resources/ash/common/cr_elements/cros_color_overrides.css.js";import"chrome://resources/ash/common/cr_elements/cr_view_manager/cr_view_manager.js";import{ColorChangeUpdater}from"chrome://resources/cr_components/color_change_listener/colors_css_updater.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{GraduationScreen}from"../mojom/graduation_ui.mojom-webui.js";import{getTemplate}from"./graduation_app.html.js";import{getGraduationUiHandler}from"./graduation_ui_handler.js";export var Screens;(function(Screens){Screens["WELCOME"]="graduation-welcome";Screens["TAKEOUT_UI"]="graduation-takeout-ui";Screens["ERROR"]="graduation-error";Screens["OFFLINE"]="graduation-offline"})(Screens||(Screens={}));export var ScreenSwitchEvents;(function(ScreenSwitchEvents){ScreenSwitchEvents["SHOW_WELCOME"]="show-welcome-screen";ScreenSwitchEvents["SHOW_TAKEOUT_UI"]="show-takeout-screen";ScreenSwitchEvents["SHOW_ERROR"]="show-error-screen";ScreenSwitchEvents["ONLINE"]="online";ScreenSwitchEvents["OFFLINE"]="offline"})(ScreenSwitchEvents||(ScreenSwitchEvents={}));export const ScreenSwitchedEvent="on-screen-switched";export class GraduationApp extends PolymerElement{constructor(){super(...arguments);this.authResult=null}static get is(){return"graduation-app"}static get template(){return getTemplate()}ready(){super.ready();this.addEventListeners();if(!navigator.onLine){this.switchToScreen(Screens.OFFLINE);return}this.authenticate();this.switchToScreen(Screens.WELCOME)}async authenticate(){const authResult=await getGraduationUiHandler().authenticateWebview();this.authResult=authResult.result;this.shadowRoot.querySelector(Screens.TAKEOUT_UI).onAuthComplete(this.authResult)}getCurrentScreenForTest(){return this.currentScreen}addEventListeners(){this.addEventListener(ScreenSwitchEvents.SHOW_TAKEOUT_UI,(()=>{this.switchToScreen(Screens.TAKEOUT_UI)}));this.addEventListener(ScreenSwitchEvents.SHOW_WELCOME,(()=>{this.switchToScreen(Screens.WELCOME)}));this.addEventListener(ScreenSwitchEvents.SHOW_ERROR,(()=>{if(this.currentScreen===Screens.OFFLINE){return}this.switchToScreen(Screens.ERROR)}));window.addEventListener(ScreenSwitchEvents.ONLINE,(()=>{if(this.authResult===null){this.authenticate()}this.switchToScreen(Screens.WELCOME)}));window.addEventListener(ScreenSwitchEvents.OFFLINE,(()=>{this.switchToScreen(Screens.OFFLINE)}))}switchToScreen(screen){if(!this.canSwitchToScreen(screen)){return}this.currentScreen=screen;this.$.viewManager.switchView(this.currentScreen);this.onScreenSwitched(this.currentScreen)}canSwitchToScreen(screen){return this.currentScreen!==screen&&this.currentScreen!==Screens.ERROR}onScreenSwitched(screen){switch(screen){case Screens.WELCOME:getGraduationUiHandler().onScreenSwitched(GraduationScreen.kWelcome);break;case Screens.TAKEOUT_UI:getGraduationUiHandler().onScreenSwitched(GraduationScreen.kTakeoutUi);break;case Screens.ERROR:getGraduationUiHandler().onScreenSwitched(GraduationScreen.kError);break}this.shadowRoot.querySelector(screen).dispatchEvent(new CustomEvent(ScreenSwitchedEvent))}}customElements.define(GraduationApp.is,GraduationApp);ColorChangeUpdater.forDocument().start();