// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/ash/common/cr_elements/cr_shared_style.css.js";import"chrome://resources/ash/common/cr_elements/cros_color_overrides.css.js";import"chrome://resources/ash/common/cr_elements/icons.html.js";import"chrome://resources/polymer/v3_0/iron-icon/iron-icon.js";import"chrome://resources/polymer/v3_0/paper-spinner/paper-spinner-lite.js";import"/strings.m.js";import{isRTL}from"//resources/js/util.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{AuthResult}from"../mojom/graduation_ui.mojom-webui.js";import{ScreenSwitchedEvent,ScreenSwitchEvents}from"./graduation_app.js";import{getTemplate}from"./graduation_takeout_ui.html.js";import{getGraduationUiHandler}from"./graduation_ui_handler.js";var AuthStatus;(function(AuthStatus){AuthStatus[AuthStatus["IN_PROGRESS"]=0]="IN_PROGRESS";AuthStatus[AuthStatus["SUCCESS"]=1]="SUCCESS";AuthStatus[AuthStatus["ERROR"]=2]="ERROR"})(AuthStatus||(AuthStatus={}));const TAKEOUT_COMPLETED_BANNER_BASE_URL="https://www.gstatic.com/ac/takeout/migration/migration-banner";export class WebviewReloadHelper{constructor(){this.reloadCount=0;this.reloadDelay=WebviewReloadHelper.INITIAL_RELOAD_DELAY_IN_MS;this.reloadTimer=0}static{this.MAX_RELOAD_ATTEMPTS=3}static{this.INITIAL_RELOAD_DELAY_IN_MS=500}static{this.MAXIMUM_RELOAD_DELAY_IN_MS=2e3}static{this.BACKOFF_FACTOR=2}reset(){this.reloadCount=0;this.reloadDelay=WebviewReloadHelper.INITIAL_RELOAD_DELAY_IN_MS;window.clearTimeout(this.reloadTimer)}isReloadCountLimitReached(){return this.reloadCount===WebviewReloadHelper.MAX_RELOAD_ATTEMPTS}updateReloadDelay(){const multipliedReloadDelay=this.reloadDelay*WebviewReloadHelper.BACKOFF_FACTOR;this.reloadDelay=Math.min(multipliedReloadDelay,WebviewReloadHelper.MAXIMUM_RELOAD_DELAY_IN_MS)}scheduleReload(webview){if(this.isReloadCountLimitReached()){return}this.reloadCount++;window.clearTimeout(this.reloadTimer);this.reloadTimer=window.setTimeout(webview.reload.bind(this),this.reloadDelay);this.updateReloadDelay()}}export class GraduationTakeoutUi extends PolymerElement{constructor(){super(...arguments);this.authStatus=AuthStatus.IN_PROGRESS;this.isWebviewLoading=false}static get is(){return"graduation-takeout-ui"}static get template(){return getTemplate()}static get properties(){return{showLoadingScreen:{type:Boolean,computed:"computeShowLoadingScreen(authStatus, isWebviewLoading)"},takeoutFlowCompleted:{type:Boolean,value:false}}}ready(){super.ready();this.webview=this.shadowRoot.querySelector("webview");if(loadTimeData.getBoolean("isEmbeddedEndpointEnabled")){const userAgent=this.webview.getUserAgent();const webviewUserAgent=loadTimeData.getString("userAgentString");this.webview.setUserAgentOverride(`${userAgent} ${webviewUserAgent}`)}this.configureWebviewListeners();this.addEventListener(ScreenSwitchedEvent,(()=>{this.shadowRoot.querySelector("#backButton").focus()}));this.webviewReloadHelper=new WebviewReloadHelper;this.startTransferUrl=loadTimeData.getString("startTransferUrl").toString()}onAuthComplete(result){switch(result){case AuthResult.kSuccess:this.setIsWebviewLoading(true);this.authStatus=AuthStatus.SUCCESS;this.loadStartTransferPage();break;case AuthResult.kError:this.authStatus=AuthStatus.ERROR;this.triggerErrorScreen()}}computeShowLoadingScreen(authStatus,isWebviewLoading){return authStatus===AuthStatus.IN_PROGRESS||isWebviewLoading===true}configureWebviewListeners(){this.webview.addEventListener("contentload",(()=>{this.webviewReloadHelper.reset();this.setIsWebviewLoading(false)}));this.webview.addEventListener("loadabort",(()=>{this.onLoadAbort()}));this.webview.addEventListener("newwindow",(e=>{window.open(e.targetUrl)}));this.webview.request.onCompleted.addListener((details=>{if(details.statusCode===200&&details.url.startsWith(TAKEOUT_COMPLETED_BANNER_BASE_URL)){getGraduationUiHandler().onTransferComplete();this.takeoutFlowCompleted=true}}),{urls:["<all_urls>"]})}onLoadAbort(){if(this.authStatus!==AuthStatus.SUCCESS){return}if(!navigator.onLine){return}if(this.webviewReloadHelper.isReloadCountLimitReached()){this.webviewReloadHelper.reset();this.setIsWebviewLoading(false);this.triggerErrorScreen();return}this.setIsWebviewLoading(true);this.webviewReloadHelper.scheduleReload(this.webview)}setIsWebviewLoading(isWebviewLoading){this.isWebviewLoading=isWebviewLoading}triggerErrorScreen(){this.dispatchEvent(new CustomEvent(ScreenSwitchEvents.SHOW_ERROR,{bubbles:true,composed:true}))}triggerWelcomeScreen(){this.dispatchEvent(new CustomEvent(ScreenSwitchEvents.SHOW_WELCOME,{bubbles:true,composed:true}))}loadStartTransferPage(){if(this.webview.src!==this.startTransferUrl){this.webview.src=this.startTransferUrl;return}this.webview.reload()}getBackButtonIcon(){return isRTL()?"cr:chevron-right":"cr:chevron-left"}onBackClicked(){this.triggerWelcomeScreen();if(this.authStatus===AuthStatus.SUCCESS){this.webview.stop();this.webviewReloadHelper.reset();this.setIsWebviewLoading(true);this.loadStartTransferPage()}}onDoneClicked(){window.close()}}customElements.define(GraduationTakeoutUi.is,GraduationTakeoutUi);