// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"chrome://resources/mojo/mojo/public/js/bindings.js";import{UrlSpec}from"chrome://resources/mojo/url/mojom/url.mojom-webui.js";import{String16Spec}from"chrome://resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js";function serializeError(error){return{message:error.message||"",name:error.name||"",stack:error.stack||""}}class NativeResolver{resolve;reject;promise;constructor(){this.promise=new Promise(((resolve,reject)=>{this.resolve=resolve;this.reject=reject}))}}function assertCast(condition){if(!condition){throw new Error("Failed assertion")}return condition}var ReservedMessageTypes;(function(ReservedMessageTypes){ReservedMessageTypes["RESPONSE_TYPE"]="___response";ReservedMessageTypes["ERROR_TYPE"]="___error"})(ReservedMessageTypes||(ReservedMessageTypes={}));function isGeneratedMessage(messageType){return messageType.substr(0,3)==="___"}function throwIfReserved(messageType){if(isGeneratedMessage(messageType)){throw new Error(`Unexpected reserved message type: '${messageType}'`)}}class MessagePipe{target_;targetOrigin_;rethrowErrors;logClientError=object=>console.error(JSON.stringify(object));messageHandlers_=new Map;pendingMessages_=new Map;nextMessageId_=0;messageListener_=m=>this.receiveMessage_(m);constructor(targetOrigin,target,rethrowErrors=true){if(!target){const frame=document.querySelector(`iframe[src^='${targetOrigin}']`);if(!frame||!frame.contentWindow){throw new Error("Unable to locate target content window.")}target=assertCast(frame.contentWindow)}this.target_=target;this.targetOrigin_=targetOrigin;this.rethrowErrors=rethrowErrors;console.assert(this.target_!==window,"target !== window");window.addEventListener("message",this.messageListener_)}registerHandler(messageType,handler){throwIfReserved(messageType);if(this.messageHandlers_.has(messageType)){throw new Error(`A handler already exists for ${messageType}`)}this.messageHandlers_.set(messageType,handler)}async sendMessage(messageType,message={}){try{return await this.sendMessageImpl(messageType,message)}catch(errorResponse){const error=new Error(`${messageType}: ${errorResponse.message}`);error.name=errorResponse.name||"Unknown Error";error.stack+=`\nError from ${this.targetOrigin_}\n${errorResponse.stack}`;throw error}}async sendMessageImpl(messageType,message={}){throwIfReserved(messageType);const messageId=this.nextMessageId_++;const resolver=new NativeResolver;this.pendingMessages_.set(messageId,resolver);this.postToTarget_(messageType,message,messageId);return resolver.promise}detach(){window.removeEventListener("message",this.messageListener_)}handleMessageResponse_(messageType,message,messageId){const{RESPONSE_TYPE:RESPONSE_TYPE,ERROR_TYPE:ERROR_TYPE}=ReservedMessageTypes;const resolver=assertCast(this.pendingMessages_.get(messageId));if(messageType===RESPONSE_TYPE){resolver.resolve(message)}else if(messageType===ERROR_TYPE){this.logClientError(message);resolver.reject(message)}else{console.error(`Response for message ${messageId} received with invalid message type ${messageType}`)}this.pendingMessages_.delete(messageId)}async callHandlerForMessageType_(messageType,message,messageId){const{RESPONSE_TYPE:RESPONSE_TYPE,ERROR_TYPE:ERROR_TYPE}=ReservedMessageTypes;let response;let error=null;let sawError=false;try{const handler=assertCast(this.messageHandlers_.get(messageType));response=await handler(message)}catch(err){sawError=true;error=err;response=serializeError(err)}this.postToTarget_(sawError?ERROR_TYPE:RESPONSE_TYPE,response,messageId);if(sawError&&this.rethrowErrors){this.logClientError(error);throw error}}receiveMessage_(e){if(typeof e.data!=="object"||!e.data||typeof e.data.type!=="string"){return}const{messageId:messageId,type:type,message:message}=e.data;const{ERROR_TYPE:ERROR_TYPE}=ReservedMessageTypes;if(e.origin!==this.targetOrigin_&&this.targetOrigin_!=="*"){return}if(isGeneratedMessage(type)&&this.pendingMessages_.has(messageId)){this.handleMessageResponse_(type,message,messageId);return}if(isGeneratedMessage(type)){console.error(`Response with type ${type} for unknown message received.`);return}if(!this.messageHandlers_.has(type)){const error=new Error(`No handler registered for message type '${type}'`);const errorResponse=serializeError(error);this.postToTarget_(ERROR_TYPE,errorResponse,messageId);return}this.callHandlerForMessageType_(type,message,messageId)}postToTarget_(messageType,message,messageId){const messageWrapper={messageId:messageId,type:messageType,message:message||{}};this.target_.postMessage(messageWrapper,this.targetOrigin_)}}const ActionTypeIdSpec={$:mojo.internal.Enum()};var ActionTypeId;(function(ActionTypeId){ActionTypeId[ActionTypeId["MIN_VALUE"]=0]="MIN_VALUE";ActionTypeId[ActionTypeId["MAX_VALUE"]=10]="MAX_VALUE";ActionTypeId[ActionTypeId["INVALID"]=0]="INVALID";ActionTypeId[ActionTypeId["OPEN_CHROME"]=1]="OPEN_CHROME";ActionTypeId[ActionTypeId["OPEN_LAUNCHER"]=2]="OPEN_LAUNCHER";ActionTypeId[ActionTypeId["OPEN_PERSONALIZATION_APP"]=3]="OPEN_PERSONALIZATION_APP";ActionTypeId[ActionTypeId["OPEN_PLAY_STORE"]=4]="OPEN_PLAY_STORE";ActionTypeId[ActionTypeId["OPEN_GOOGLE_DOCS"]=5]="OPEN_GOOGLE_DOCS";ActionTypeId[ActionTypeId["OPEN_GOOGLE_PHOTOS"]=6]="OPEN_GOOGLE_PHOTOS";ActionTypeId[ActionTypeId["OPEN_SETTINGS_PRINTER"]=7]="OPEN_SETTINGS_PRINTER";ActionTypeId[ActionTypeId["OPEN_PHONE_HUB"]=8]="OPEN_PHONE_HUB";ActionTypeId[ActionTypeId["OPEN_YOUTUBE"]=9]="OPEN_YOUTUBE";ActionTypeId[ActionTypeId["OPEN_FILE_MANAGER"]=10]="OPEN_FILE_MANAGER"})(ActionTypeId||(ActionTypeId={}));const SettingsComponentSpec={$:mojo.internal.Enum()};var SettingsComponent;(function(SettingsComponent){SettingsComponent[SettingsComponent["MIN_VALUE"]=0]="MIN_VALUE";SettingsComponent[SettingsComponent["MAX_VALUE"]=13]="MAX_VALUE";SettingsComponent[SettingsComponent["HOME"]=0]="HOME";SettingsComponent[SettingsComponent["ACCESSIBILITY"]=1]="ACCESSIBILITY";SettingsComponent[SettingsComponent["BLUETOOTH"]=2]="BLUETOOTH";SettingsComponent[SettingsComponent["DISPLAY"]=3]="DISPLAY";SettingsComponent[SettingsComponent["INPUT"]=4]="INPUT";SettingsComponent[SettingsComponent["MULTI_DEVICE"]=5]="MULTI_DEVICE";SettingsComponent[SettingsComponent["PEOPLE"]=6]="PEOPLE";SettingsComponent[SettingsComponent["PER_DEVICE_KEYBOARD"]=7]="PER_DEVICE_KEYBOARD";SettingsComponent[SettingsComponent["PER_DEVICE_TOUCHPAD"]=8]="PER_DEVICE_TOUCHPAD";SettingsComponent[SettingsComponent["PERSONALIZATION"]=9]="PERSONALIZATION";SettingsComponent[SettingsComponent["PRINTING"]=10]="PRINTING";SettingsComponent[SettingsComponent["SECURITY_AND_SIGN_IN"]=11]="SECURITY_AND_SIGN_IN";SettingsComponent[SettingsComponent["TOUCHPAD_REVERSE_SCROLLING"]=12]="TOUCHPAD_REVERSE_SCROLLING";SettingsComponent[SettingsComponent["TOUCHPAD_SIMULATE_RIGHT_CLICK"]=13]="TOUCHPAD_SIMULATE_RIGHT_CLICK"})(SettingsComponent||(SettingsComponent={}));class PageHandlerFactoryPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.help_app.mojom.PageHandlerFactory",scope)}}class PageHandlerFactoryRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}createPageHandler(handler){this.proxy.sendMessage(0,PageHandlerFactory_CreatePageHandler_ParamsSpec.$,null,[handler],false)}}class PageHandlerFactory{static get $interfaceName(){return"ash.help_app.mojom.PageHandlerFactory"}static getRemote(){let remote=new PageHandlerFactoryRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}class PageHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.help_app.mojom.PageHandler",scope)}}class PageHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}openFeedbackDialog(){return this.proxy.sendMessage(0,PageHandler_OpenFeedbackDialog_ParamsSpec.$,PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$,[],false)}showOnDeviceAppControls(){this.proxy.sendMessage(1,PageHandler_ShowOnDeviceAppControls_ParamsSpec.$,null,[],false)}showParentalControls(){this.proxy.sendMessage(2,PageHandler_ShowParentalControls_ParamsSpec.$,null,[],false)}triggerWelcomeTipCallToAction(actionTypeId){this.proxy.sendMessage(3,PageHandler_TriggerWelcomeTipCallToAction_ParamsSpec.$,null,[actionTypeId],false)}isLauncherSearchEnabled(){return this.proxy.sendMessage(4,PageHandler_IsLauncherSearchEnabled_ParamsSpec.$,PageHandler_IsLauncherSearchEnabled_ResponseParamsSpec.$,[],false)}launchMicrosoft365Setup(){this.proxy.sendMessage(5,PageHandler_LaunchMicrosoft365Setup_ParamsSpec.$,null,[],false)}maybeShowReleaseNotesNotification(){this.proxy.sendMessage(6,PageHandler_MaybeShowReleaseNotesNotification_ParamsSpec.$,null,[],false)}getDeviceInfo(){return this.proxy.sendMessage(7,PageHandler_GetDeviceInfo_ParamsSpec.$,PageHandler_GetDeviceInfo_ResponseParamsSpec.$,[],false)}openUrlInBrowserAndTriggerInstallDialog(url){this.proxy.sendMessage(8,PageHandler_OpenUrlInBrowserAndTriggerInstallDialog_ParamsSpec.$,null,[url],false)}openSettings(component){this.proxy.sendMessage(9,PageHandler_OpenSettings_ParamsSpec.$,null,[component],false)}setHasCompletedNewDeviceChecklist(){this.proxy.sendMessage(10,PageHandler_SetHasCompletedNewDeviceChecklist_ParamsSpec.$,null,[],false)}setHasVisitedHowToPage(){this.proxy.sendMessage(11,PageHandler_SetHasVisitedHowToPage_ParamsSpec.$,null,[],false)}}const DeviceInfoSpec={$:{}};const PageHandlerFactory_CreatePageHandler_ParamsSpec={$:{}};const PageHandler_OpenFeedbackDialog_ParamsSpec={$:{}};const PageHandler_OpenFeedbackDialog_ResponseParamsSpec={$:{}};const PageHandler_ShowOnDeviceAppControls_ParamsSpec={$:{}};const PageHandler_ShowParentalControls_ParamsSpec={$:{}};const PageHandler_TriggerWelcomeTipCallToAction_ParamsSpec={$:{}};const PageHandler_IsLauncherSearchEnabled_ParamsSpec={$:{}};const PageHandler_IsLauncherSearchEnabled_ResponseParamsSpec={$:{}};const PageHandler_LaunchMicrosoft365Setup_ParamsSpec={$:{}};const PageHandler_MaybeShowReleaseNotesNotification_ParamsSpec={$:{}};const PageHandler_GetDeviceInfo_ParamsSpec={$:{}};const PageHandler_GetDeviceInfo_ResponseParamsSpec={$:{}};const PageHandler_OpenUrlInBrowserAndTriggerInstallDialog_ParamsSpec={$:{}};const PageHandler_OpenSettings_ParamsSpec={$:{}};const PageHandler_SetHasCompletedNewDeviceChecklist_ParamsSpec={$:{}};const PageHandler_SetHasVisitedHowToPage_ParamsSpec={$:{}};mojo.internal.Struct(DeviceInfoSpec.$,"DeviceInfo",[mojo.internal.StructField("board",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("model",8,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("userType",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("isSteamAllowed",24,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$,"PageHandlerFactory_CreatePageHandler_Params",[mojo.internal.StructField("handler",0,0,mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_OpenFeedbackDialog_ParamsSpec.$,"PageHandler_OpenFeedbackDialog_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$,"PageHandler_OpenFeedbackDialog_ResponseParams",[mojo.internal.StructField("errorMessage",0,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_ShowOnDeviceAppControls_ParamsSpec.$,"PageHandler_ShowOnDeviceAppControls_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_ShowParentalControls_ParamsSpec.$,"PageHandler_ShowParentalControls_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_TriggerWelcomeTipCallToAction_ParamsSpec.$,"PageHandler_TriggerWelcomeTipCallToAction_Params",[mojo.internal.StructField("actionTypeId",0,0,ActionTypeIdSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_IsLauncherSearchEnabled_ParamsSpec.$,"PageHandler_IsLauncherSearchEnabled_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_IsLauncherSearchEnabled_ResponseParamsSpec.$,"PageHandler_IsLauncherSearchEnabled_ResponseParams",[mojo.internal.StructField("enabled",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_LaunchMicrosoft365Setup_ParamsSpec.$,"PageHandler_LaunchMicrosoft365Setup_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_MaybeShowReleaseNotesNotification_ParamsSpec.$,"PageHandler_MaybeShowReleaseNotesNotification_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetDeviceInfo_ParamsSpec.$,"PageHandler_GetDeviceInfo_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetDeviceInfo_ResponseParamsSpec.$,"PageHandler_GetDeviceInfo_ResponseParams",[mojo.internal.StructField("deviceInfo",0,0,DeviceInfoSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_OpenUrlInBrowserAndTriggerInstallDialog_ParamsSpec.$,"PageHandler_OpenUrlInBrowserAndTriggerInstallDialog_Params",[mojo.internal.StructField("url",0,0,UrlSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_OpenSettings_ParamsSpec.$,"PageHandler_OpenSettings_Params",[mojo.internal.StructField("component",0,0,SettingsComponentSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_SetHasCompletedNewDeviceChecklist_ParamsSpec.$,"PageHandler_SetHasCompletedNewDeviceChecklist_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_SetHasVisitedHowToPage_ParamsSpec.$,"PageHandler_SetHasVisitedHowToPage_Params",[],[[0,8]]);const ResponseStatusSpec={$:mojo.internal.Enum()};var ResponseStatus;(function(ResponseStatus){ResponseStatus[ResponseStatus["MIN_VALUE"]=0]="MIN_VALUE";ResponseStatus[ResponseStatus["MAX_VALUE"]=3]="MAX_VALUE";ResponseStatus[ResponseStatus["kUnknownError"]=0]="kUnknownError";ResponseStatus[ResponseStatus["kSuccess"]=1]="kSuccess";ResponseStatus[ResponseStatus["kEmptyQuery"]=2]="kEmptyQuery";ResponseStatus[ResponseStatus["kEmptyIndex"]=3]="kEmptyIndex"})(ResponseStatus||(ResponseStatus={}));const ContentSpec={$:{}};const DataSpec={$:{}};const SearchParamsSpec={$:{}};const PositionSpec={$:{}};const ResultSpec={$:{}};mojo.internal.Struct(ContentSpec.$,"Content",[mojo.internal.StructField("id",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("content",8,0,String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("weight",16,0,mojo.internal.Double,1,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(DataSpec.$,"Data",[mojo.internal.StructField("id",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("contents",8,0,mojo.internal.Array(ContentSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("locale",16,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(SearchParamsSpec.$,"SearchParams",[mojo.internal.StructField("relevanceThreshold",0,0,mojo.internal.Double,.32,false,0,undefined,undefined),mojo.internal.StructField("prefixThreshold",8,0,mojo.internal.Double,.6,false,0,undefined,undefined),mojo.internal.StructField("fuzzyThreshold",16,0,mojo.internal.Double,.6,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(PositionSpec.$,"Position",[mojo.internal.StructField("contentId",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("start",8,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("length",12,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(ResultSpec.$,"Result",[mojo.internal.StructField("id",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("score",8,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("positions",16,0,mojo.internal.Array(PositionSpec.$,false),null,false,0,undefined,undefined)],[[0,32]]);class IndexPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.local_search_service.mojom.Index",scope)}}class IndexRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(IndexPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}getSize(){return this.proxy.sendMessage(0,Index_GetSize_ParamsSpec.$,Index_GetSize_ResponseParamsSpec.$,[],false)}addOrUpdate(data){return this.proxy.sendMessage(1,Index_AddOrUpdate_ParamsSpec.$,Index_AddOrUpdate_ResponseParamsSpec.$,[data],false)}delete(ids){return this.proxy.sendMessage(2,Index_Delete_ParamsSpec.$,Index_Delete_ResponseParamsSpec.$,[ids],false)}updateDocuments(data){return this.proxy.sendMessage(3,Index_UpdateDocuments_ParamsSpec.$,Index_UpdateDocuments_ResponseParamsSpec.$,[data],false)}find(query,maxResults){return this.proxy.sendMessage(4,Index_Find_ParamsSpec.$,Index_Find_ResponseParamsSpec.$,[query,maxResults],false)}clearIndex(){return this.proxy.sendMessage(5,Index_ClearIndex_ParamsSpec.$,Index_ClearIndex_ResponseParamsSpec.$,[],false)}setSearchParams(searchParams){return this.proxy.sendMessage(6,Index_SetSearchParams_ParamsSpec.$,Index_SetSearchParams_ResponseParamsSpec.$,[searchParams],false)}}class Index{static get $interfaceName(){return"ash.local_search_service.mojom.Index"}static getRemote(){let remote=new IndexRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}const Index_GetSize_ParamsSpec={$:{}};const Index_GetSize_ResponseParamsSpec={$:{}};const Index_AddOrUpdate_ParamsSpec={$:{}};const Index_AddOrUpdate_ResponseParamsSpec={$:{}};const Index_Delete_ParamsSpec={$:{}};const Index_Delete_ResponseParamsSpec={$:{}};const Index_UpdateDocuments_ParamsSpec={$:{}};const Index_UpdateDocuments_ResponseParamsSpec={$:{}};const Index_Find_ParamsSpec={$:{}};const Index_Find_ResponseParamsSpec={$:{}};const Index_ClearIndex_ParamsSpec={$:{}};const Index_ClearIndex_ResponseParamsSpec={$:{}};const Index_SetSearchParams_ParamsSpec={$:{}};const Index_SetSearchParams_ResponseParamsSpec={$:{}};mojo.internal.Struct(Index_GetSize_ParamsSpec.$,"Index_GetSize_Params",[],[[0,8]]);mojo.internal.Struct(Index_GetSize_ResponseParamsSpec.$,"Index_GetSize_ResponseParams",[mojo.internal.StructField("numItems",0,0,mojo.internal.Uint64,BigInt(0),false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Index_AddOrUpdate_ParamsSpec.$,"Index_AddOrUpdate_Params",[mojo.internal.StructField("data",0,0,mojo.internal.Array(DataSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Index_AddOrUpdate_ResponseParamsSpec.$,"Index_AddOrUpdate_ResponseParams",[],[[0,8]]);mojo.internal.Struct(Index_Delete_ParamsSpec.$,"Index_Delete_Params",[mojo.internal.StructField("ids",0,0,mojo.internal.Array(mojo.internal.String,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Index_Delete_ResponseParamsSpec.$,"Index_Delete_ResponseParams",[mojo.internal.StructField("numDeleted",0,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Index_UpdateDocuments_ParamsSpec.$,"Index_UpdateDocuments_Params",[mojo.internal.StructField("data",0,0,mojo.internal.Array(DataSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Index_UpdateDocuments_ResponseParamsSpec.$,"Index_UpdateDocuments_ResponseParams",[mojo.internal.StructField("numDeleted",0,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Index_Find_ParamsSpec.$,"Index_Find_Params",[mojo.internal.StructField("query",0,0,String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("maxResults",8,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(Index_Find_ResponseParamsSpec.$,"Index_Find_ResponseParams",[mojo.internal.StructField("status",0,0,ResponseStatusSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("results",8,0,mojo.internal.Array(ResultSpec.$,false),null,true,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(Index_ClearIndex_ParamsSpec.$,"Index_ClearIndex_Params",[],[[0,8]]);mojo.internal.Struct(Index_ClearIndex_ResponseParamsSpec.$,"Index_ClearIndex_ResponseParams",[],[[0,8]]);mojo.internal.Struct(Index_SetSearchParams_ParamsSpec.$,"Index_SetSearchParams_Params",[mojo.internal.StructField("searchParams",0,0,SearchParamsSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Index_SetSearchParams_ResponseParamsSpec.$,"Index_SetSearchParams_ResponseParams",[],[[0,8]]);var Message;(function(Message){Message["OPEN_FEEDBACK_DIALOG"]="open-feedback-dialog";Message["SHOW_ON_DEVICE_APP_CONTROLS"]="show-on-device-app-controls";Message["SHOW_PARENTAL_CONTROLS"]="show-parental-controls";Message["TRIGGER_WELCOME_TIP_CALL_TO_ACTION"]="trigger-welcome-tip-call-to-action";Message["ADD_OR_UPDATE_SEARCH_INDEX"]="add-or-update-search-index";Message["CLEAR_SEARCH_INDEX"]="clear-search-index";Message["FIND_IN_SEARCH_INDEX"]="find-in-search-index";Message["CLOSE_BACKGROUND_PAGE"]="close-background-page";Message["UPDATE_LAUNCHER_SEARCH_INDEX"]="update-launcher-search-index";Message["LAUNCH_MICROSOFT_365_SETUP"]="launch-microsoft-365-setup";Message["MAYBE_SHOW_RELEASE_NOTES_NOTIFICATION"]="maybe-show-release-notes-notification";Message["GET_DEVICE_INFO"]="get-device-info";Message["OPEN_SETTINGS"]="open-settings";Message["OPEN_URL_IN_BROWSER_AND_TRIGGER_INSTALL_DIALOG"]="open-url-in-browser-and-trigger-install-dialog";Message["SET_HAS_COMPLETED_NEW_DEVICE_CHECKLIST"]="set-has-completed-new-device-checklist";Message["SET_HAS_VISITED_HOW_TO_PAGE"]="set-has-visited-how-to-page";Message["OPEN_APP_MALL_PATH"]="open-app-mall-path"})(Message||(Message={}));class SearchResultsObserverPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.help_app.mojom.SearchResultsObserver",scope)}}class SearchResultsObserverRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(SearchResultsObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onSearchResultAvailabilityChanged(){this.proxy.sendMessage(0,SearchResultsObserver_OnSearchResultAvailabilityChanged_ParamsSpec.$,null,[],false)}}class SearchHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.help_app.mojom.SearchHandler",scope)}}class SearchHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(SearchHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}search(query,maxNumResults){return this.proxy.sendMessage(0,SearchHandler_Search_ParamsSpec.$,SearchHandler_Search_ResponseParamsSpec.$,[query,maxNumResults],false)}update(concepts){return this.proxy.sendMessage(1,SearchHandler_Update_ParamsSpec.$,SearchHandler_Update_ResponseParamsSpec.$,[concepts],false)}observe(observer){this.proxy.sendMessage(2,SearchHandler_Observe_ParamsSpec.$,null,[observer],false)}}class SearchHandler{static get $interfaceName(){return"ash.help_app.mojom.SearchHandler"}static getRemote(){let remote=new SearchHandlerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}const SearchResultSpec={$:{}};const SearchConceptSpec={$:{}};const SearchResultsObserver_OnSearchResultAvailabilityChanged_ParamsSpec={$:{}};const SearchHandler_Search_ParamsSpec={$:{}};const SearchHandler_Search_ResponseParamsSpec={$:{}};const SearchHandler_Update_ParamsSpec={$:{}};const SearchHandler_Update_ResponseParamsSpec={$:{}};const SearchHandler_Observe_ParamsSpec={$:{}};mojo.internal.Struct(SearchResultSpec.$,"SearchResult",[mojo.internal.StructField("id",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("title",8,0,String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("mainCategory",16,0,String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("urlPathWithParameters",24,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("locale",32,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("relevanceScore",40,0,mojo.internal.Double,0,false,0,undefined,undefined)],[[0,56]]);mojo.internal.Struct(SearchConceptSpec.$,"SearchConcept",[mojo.internal.StructField("id",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("title",8,0,String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("mainCategory",16,0,String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("tags",24,0,mojo.internal.Array(String16Spec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("tagLocale",32,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("urlPathWithParameters",40,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("locale",48,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,64]]);mojo.internal.Struct(SearchResultsObserver_OnSearchResultAvailabilityChanged_ParamsSpec.$,"SearchResultsObserver_OnSearchResultAvailabilityChanged_Params",[],[[0,8]]);mojo.internal.Struct(SearchHandler_Search_ParamsSpec.$,"SearchHandler_Search_Params",[mojo.internal.StructField("query",0,0,String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("maxNumResults",8,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(SearchHandler_Search_ResponseParamsSpec.$,"SearchHandler_Search_ResponseParams",[mojo.internal.StructField("results",0,0,mojo.internal.Array(SearchResultSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(SearchHandler_Update_ParamsSpec.$,"SearchHandler_Update_Params",[mojo.internal.StructField("concepts",0,0,mojo.internal.Array(SearchConceptSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(SearchHandler_Update_ResponseParamsSpec.$,"SearchHandler_Update_ResponseParams",[],[[0,8]]);mojo.internal.Struct(SearchHandler_Observe_ParamsSpec.$,"SearchHandler_Observe_Params",[mojo.internal.StructField("observer",0,0,mojo.internal.InterfaceProxy(SearchResultsObserverRemote),null,false,0,undefined,undefined)],[[0,16]]);const helpApp={handler:new PageHandlerRemote};PageHandlerFactory.getRemote().createPageHandler(helpApp.handler.$.bindNewPipeAndPassReceiver());const indexRemote=Index.getRemote();Object.assign(window,{indexRemote:indexRemote});const searchHandlerRemote=SearchHandler.getRemote();const GUEST_ORIGIN="chrome-untrusted://help-app";const MAX_STRING_LEN=9999;const guestFrame=document.createElement("iframe");guestFrame.src=`${GUEST_ORIGIN}${location.pathname}${location.search}`;document.body.appendChild(guestFrame);const isLauncherSearchEnabled=helpApp.handler.isLauncherSearchEnabled().then((result=>result.enabled));function toUrl(url){if(url===""||typeof url!=="string"){return{url:""}}return{url:url}}const TITLE_ID="title";const BODY_ID="body";const CATEGORY_ID="main-category";const SUBCATEGORY_ID="subcategory";const SUBHEADING_ID="subheading";const guestMessagePipe=new MessagePipe("chrome-untrusted://help-app",undefined,false);guestMessagePipe.registerHandler(Message.OPEN_FEEDBACK_DIALOG,(()=>helpApp.handler.openFeedbackDialog()));guestMessagePipe.registerHandler(Message.SHOW_ON_DEVICE_APP_CONTROLS,(()=>void helpApp.handler.showOnDeviceAppControls()));guestMessagePipe.registerHandler(Message.SHOW_PARENTAL_CONTROLS,(()=>void helpApp.handler.showParentalControls()));guestMessagePipe.registerHandler(Message.TRIGGER_WELCOME_TIP_CALL_TO_ACTION,(actionTypeId=>void helpApp.handler.triggerWelcomeTipCallToAction(actionTypeId)));guestMessagePipe.registerHandler(Message.ADD_OR_UPDATE_SEARCH_INDEX,(async data=>{const dataToSend=data.map((searchableItem=>{const contents=[{id:TITLE_ID,content:truncate(searchableItem.title),weight:1},{id:CATEGORY_ID,content:truncate(searchableItem.mainCategoryName),weight:.1}];if(searchableItem.subcategoryNames){for(let i=0;i<searchableItem.subcategoryNames.length;++i){const subcategoryName=searchableItem.subcategoryNames[i];contents.push({id:SUBCATEGORY_ID+i,content:truncate(subcategoryName),weight:.1})}}const subheadings=searchableItem.subheadings;if(subheadings){for(let i=0;i<subheadings.length;++i){const subheading=subheadings[i];if(!subheading)continue;contents.push({id:SUBHEADING_ID+i,content:truncate(subheading),weight:.4})}}else if(searchableItem.body){contents.push({id:BODY_ID,content:truncate(searchableItem.body),weight:.2})}return{id:searchableItem.id,contents:contents,locale:searchableItem.locale}}));return indexRemote.addOrUpdate(dataToSend)}));guestMessagePipe.registerHandler(Message.CLEAR_SEARCH_INDEX,(async()=>indexRemote.clearIndex()));guestMessagePipe.registerHandler(Message.FIND_IN_SEARCH_INDEX,(async dataFromApp=>{const response=await indexRemote.find(truncate(dataFromApp.query),dataFromApp.maxResults||50);if(response.status!==ResponseStatus.kSuccess||!response.results){return{results:null}}const searchResults=response.results;searchResults.sort(((a,b)=>b.score-a.score));const results=searchResults.map((result=>{const titlePositions=[];const bodyPositions=[];let bestSubheadingId="";const subheadingPosCounts={};for(const position of result.positions){if(position.contentId===TITLE_ID){titlePositions.push({length:position.length,start:position.start})}else if(position.contentId===BODY_ID){bodyPositions.push({length:position.length,start:position.start})}else if(position.contentId.startsWith(SUBHEADING_ID)){const newCount=(subheadingPosCounts[position.contentId]||0)+1;subheadingPosCounts[position.contentId]=newCount;if(!bestSubheadingId||newCount>(subheadingPosCounts[bestSubheadingId]??0)){bestSubheadingId=position.contentId}}}const subheadingPositions=[];if(bestSubheadingId){for(const position of result.positions){if(position.contentId===bestSubheadingId){subheadingPositions.push({start:position.start,length:position.length})}}subheadingPositions.sort(compareByStart)}titlePositions.sort(compareByStart);bodyPositions.sort(compareByStart);return{id:result.id,titlePositions:titlePositions,bodyPositions:bodyPositions,subheadingIndex:bestSubheadingId?Number(bestSubheadingId.substring(SUBHEADING_ID.length)):null,subheadingPositions:bestSubheadingId?subheadingPositions:null}}));return{results:results}}));guestMessagePipe.registerHandler(Message.CLOSE_BACKGROUND_PAGE,(async()=>{if(window.location.pathname!=="/background"){return}window.close();return}));guestMessagePipe.registerHandler(Message.UPDATE_LAUNCHER_SEARCH_INDEX,(async message=>{if(!await isLauncherSearchEnabled){return}const dataToSend=message.map((searchableItem=>({id:truncate(searchableItem.id),title:truncate(searchableItem.title),mainCategory:truncate(searchableItem.mainCategoryName),tags:searchableItem.tags.map((tag=>truncate(tag))).filter((tag=>tag.length>0)),tagLocale:searchableItem.tagLocale||"",urlPathWithParameters:truncate(searchableItem.urlPathWithParameters),locale:truncate(searchableItem.locale)})));const dataFiltered=dataToSend.filter((item=>{const valid=item.id&&item.title&&item.mainCategory&&item.tags.length>0&&item.urlPathWithParameters;if(!valid){window.chrome.metricsPrivate.recordSparseValueWithPersistentHash("Discover.LauncherSearch.InvalidConceptInUpdate",item.id)}return valid}));return searchHandlerRemote.update(dataFiltered)}));guestMessagePipe.registerHandler(Message.LAUNCH_MICROSOFT_365_SETUP,(()=>void helpApp.handler.launchMicrosoft365Setup()));guestMessagePipe.registerHandler(Message.MAYBE_SHOW_RELEASE_NOTES_NOTIFICATION,(()=>void helpApp.handler.maybeShowReleaseNotesNotification()));guestMessagePipe.registerHandler(Message.GET_DEVICE_INFO,(async()=>(await helpApp.handler.getDeviceInfo()).deviceInfo));guestMessagePipe.registerHandler(Message.OPEN_SETTINGS,(path=>void helpApp.handler.openSettings(path)));guestMessagePipe.registerHandler(Message.OPEN_URL_IN_BROWSER_AND_TRIGGER_INSTALL_DIALOG,(url=>{helpApp.handler.openUrlInBrowserAndTriggerInstallDialog(toUrl(url))}));guestMessagePipe.registerHandler(Message.SET_HAS_COMPLETED_NEW_DEVICE_CHECKLIST,(()=>void helpApp.handler.setHasCompletedNewDeviceChecklist()));guestMessagePipe.registerHandler(Message.SET_HAS_VISITED_HOW_TO_PAGE,(()=>void helpApp.handler.setHasVisitedHowToPage()));guestMessagePipe.registerHandler(Message.OPEN_APP_MALL_PATH,(({path:path})=>{window.open(`chrome://mall/${path}`)}));function compareByStart(a,b){return a.start-b.start}function truncate(s){if(typeof s!=="string"){return""}if(s.length<=MAX_STRING_LEN){return s}return s.substring(0,MAX_STRING_LEN)}const TEST_ONLY={guestMessagePipe:guestMessagePipe};export{TEST_ONLY};