// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";const impl={data_:{},set data(value){impl.data_=value},getValue:id=>impl.data_[id],getString:id=>impl.data_[id],getBoolean:id=>impl.data_[id],getInteger:id=>impl.data_[id],valueExists:id=>impl.data_[id]!==undefined};window["loadTimeData"]=impl;function assert(value,message){if(value){return}throw new Error("Assertion failed"+"")}class PageHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"color_change_listener.mojom.PageHandler",scope)}}class PageHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}setPage(page){this.proxy.sendMessage(0,PageHandler_SetPage_ParamsSpec.$,null,[page],false)}}class PageHandler{static get $interfaceName(){return"color_change_listener.mojom.PageHandler"}static getRemote(){let remote=new PageHandlerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}class PagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"color_change_listener.mojom.Page",scope)}}class PageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onColorProviderChanged(){this.proxy.sendMessage(0,Page_OnColorProviderChanged_ParamsSpec.$,null,[],false)}}class PageCallbackRouter{helper_internal_;$;router_;onColorProviderChanged;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onColorProviderChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,Page_OnColorProviderChanged_ParamsSpec.$,null,this.onColorProviderChanged.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}const PageHandler_SetPage_ParamsSpec={$:{}};const Page_OnColorProviderChanged_ParamsSpec={$:{}};mojo.internal.Struct(PageHandler_SetPage_ParamsSpec.$,"PageHandler_SetPage_Params",[mojo.internal.StructField("page",0,0,mojo.internal.InterfaceProxy(PageRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_OnColorProviderChanged_ParamsSpec.$,"Page_OnColorProviderChanged_Params",[],[[0,8]]);let instance=null;class BrowserProxy{callbackRouter;constructor(){this.callbackRouter=new PageCallbackRouter;const pageHandlerRemote=PageHandler.getRemote();pageHandlerRemote.setPage(this.callbackRouter.$.bindNewPipeAndPassRemote())}static getInstance(){return instance||(instance=new BrowserProxy)}static setInstance(newInstance){instance=newInstance}}const COLORS_CSS_SELECTOR="link[href*='//theme/colors.css']";let documentInstance=null;const COLOR_PROVIDER_CHANGED="color-provider-changed";class ColorChangeUpdater{listenerId_=null;root_;eventTarget=new EventTarget;constructor(root){assert(documentInstance===null||root!==document);this.root_=root}start(){if(this.listenerId_!==null){return}this.listenerId_=BrowserProxy.getInstance().callbackRouter.onColorProviderChanged.addListener(this.onColorProviderChanged.bind(this))}async onColorProviderChanged(){await this.refreshColorsCss();this.eventTarget.dispatchEvent(new CustomEvent(COLOR_PROVIDER_CHANGED))}async refreshColorsCss(){const colorCssNode=this.root_.querySelector(COLORS_CSS_SELECTOR);if(!colorCssNode){return false}const href=colorCssNode.getAttribute("href");if(!href){return false}const hrefURL=new URL(href,location.href);const params=new URLSearchParams(hrefURL.search);params.set("version",(new Date).getTime().toString());const newHref=`${hrefURL.origin}${hrefURL.pathname}?${params.toString()}`;const newColorsCssLink=document.createElement("link");newColorsCssLink.setAttribute("href",newHref);newColorsCssLink.rel="stylesheet";newColorsCssLink.type="text/css";const newColorsLoaded=new Promise((resolve=>{newColorsCssLink.onload=resolve}));if(this.root_===document){document.getElementsByTagName("body")[0].appendChild(newColorsCssLink)}else{this.root_.appendChild(newColorsCssLink)}await newColorsLoaded;const oldColorCssNode=document.querySelector(COLORS_CSS_SELECTOR);if(oldColorCssNode){oldColorCssNode.remove()}return true}static forDocument(){return documentInstance||(documentInstance=new ColorChangeUpdater(document))}}function serializeError(error){return{message:error.message||"",name:error.name||"",stack:error.stack||""}}class NativeResolver{resolve;reject;promise;constructor(){this.promise=new Promise(((resolve,reject)=>{this.resolve=resolve;this.reject=reject}))}}function assertCast(condition){if(!condition){throw new Error("Failed assertion")}return condition}var ReservedMessageTypes;(function(ReservedMessageTypes){ReservedMessageTypes["RESPONSE_TYPE"]="___response";ReservedMessageTypes["ERROR_TYPE"]="___error"})(ReservedMessageTypes||(ReservedMessageTypes={}));function isGeneratedMessage(messageType){return messageType.substr(0,3)==="___"}function throwIfReserved(messageType){if(isGeneratedMessage(messageType)){throw new Error(`Unexpected reserved message type: '${messageType}'`)}}class MessagePipe{target_;targetOrigin_;rethrowErrors;logClientError=object=>console.error(JSON.stringify(object));messageHandlers_=new Map;pendingMessages_=new Map;nextMessageId_=0;messageListener_=m=>this.receiveMessage_(m);constructor(targetOrigin,target,rethrowErrors=true){if(!target){const frame=document.querySelector(`iframe[src^='${targetOrigin}']`);if(!frame||!frame.contentWindow){throw new Error("Unable to locate target content window.")}target=assertCast(frame.contentWindow)}this.target_=target;this.targetOrigin_=targetOrigin;this.rethrowErrors=rethrowErrors;console.assert(this.target_!==window,"target !== window");window.addEventListener("message",this.messageListener_)}registerHandler(messageType,handler){throwIfReserved(messageType);if(this.messageHandlers_.has(messageType)){throw new Error(`A handler already exists for ${messageType}`)}this.messageHandlers_.set(messageType,handler)}async sendMessage(messageType,message={}){try{return await this.sendMessageImpl(messageType,message)}catch(errorResponse){const error=new Error(`${messageType}: ${errorResponse.message}`);error.name=errorResponse.name||"Unknown Error";error.stack+=`\nError from ${this.targetOrigin_}\n${errorResponse.stack}`;throw error}}async sendMessageImpl(messageType,message={}){throwIfReserved(messageType);const messageId=this.nextMessageId_++;const resolver=new NativeResolver;this.pendingMessages_.set(messageId,resolver);this.postToTarget_(messageType,message,messageId);return resolver.promise}detach(){window.removeEventListener("message",this.messageListener_)}handleMessageResponse_(messageType,message,messageId){const{RESPONSE_TYPE:RESPONSE_TYPE,ERROR_TYPE:ERROR_TYPE}=ReservedMessageTypes;const resolver=assertCast(this.pendingMessages_.get(messageId));if(messageType===RESPONSE_TYPE){resolver.resolve(message)}else if(messageType===ERROR_TYPE){this.logClientError(message);resolver.reject(message)}else{console.error(`Response for message ${messageId} received with invalid message type ${messageType}`)}this.pendingMessages_.delete(messageId)}async callHandlerForMessageType_(messageType,message,messageId){const{RESPONSE_TYPE:RESPONSE_TYPE,ERROR_TYPE:ERROR_TYPE}=ReservedMessageTypes;let response;let error=null;let sawError=false;try{const handler=assertCast(this.messageHandlers_.get(messageType));response=await handler(message)}catch(err){sawError=true;error=err;response=serializeError(err)}this.postToTarget_(sawError?ERROR_TYPE:RESPONSE_TYPE,response,messageId);if(sawError&&this.rethrowErrors){this.logClientError(error);throw error}}receiveMessage_(e){if(typeof e.data!=="object"||!e.data||typeof e.data.type!=="string"){return}const{messageId:messageId,type:type,message:message}=e.data;const{ERROR_TYPE:ERROR_TYPE}=ReservedMessageTypes;if(e.origin!==this.targetOrigin_&&this.targetOrigin_!=="*"){return}if(isGeneratedMessage(type)&&this.pendingMessages_.has(messageId)){this.handleMessageResponse_(type,message,messageId);return}if(isGeneratedMessage(type)){console.error(`Response with type ${type} for unknown message received.`);return}if(!this.messageHandlers_.has(type)){const error=new Error(`No handler registered for message type '${type}'`);const errorResponse=serializeError(error);this.postToTarget_(ERROR_TYPE,errorResponse,messageId);return}this.callHandlerForMessageType_(type,message,messageId)}postToTarget_(messageType,message,messageId){const messageWrapper={messageId:messageId,type:messageType,message:message||{}};this.target_.postMessage(messageWrapper,this.targetOrigin_)}}var Message;(function(Message){Message["OPEN_FEEDBACK_DIALOG"]="open-feedback-dialog";Message["SHOW_ON_DEVICE_APP_CONTROLS"]="show-on-device-app-controls";Message["SHOW_PARENTAL_CONTROLS"]="show-parental-controls";Message["TRIGGER_WELCOME_TIP_CALL_TO_ACTION"]="trigger-welcome-tip-call-to-action";Message["ADD_OR_UPDATE_SEARCH_INDEX"]="add-or-update-search-index";Message["CLEAR_SEARCH_INDEX"]="clear-search-index";Message["FIND_IN_SEARCH_INDEX"]="find-in-search-index";Message["CLOSE_BACKGROUND_PAGE"]="close-background-page";Message["UPDATE_LAUNCHER_SEARCH_INDEX"]="update-launcher-search-index";Message["LAUNCH_MICROSOFT_365_SETUP"]="launch-microsoft-365-setup";Message["MAYBE_SHOW_RELEASE_NOTES_NOTIFICATION"]="maybe-show-release-notes-notification";Message["GET_DEVICE_INFO"]="get-device-info";Message["OPEN_SETTINGS"]="open-settings";Message["OPEN_URL_IN_BROWSER_AND_TRIGGER_INSTALL_DIALOG"]="open-url-in-browser-and-trigger-install-dialog";Message["SET_HAS_COMPLETED_NEW_DEVICE_CHECKLIST"]="set-has-completed-new-device-checklist";Message["SET_HAS_VISITED_HOW_TO_PAGE"]="set-has-visited-how-to-page";Message["OPEN_APP_MALL_PATH"]="open-app-mall-path"})(Message||(Message={}));const parentMessagePipe=new MessagePipe("chrome://help-app",window.parent);const DELEGATE={async openFeedbackDialog(){const response=await parentMessagePipe.sendMessage(Message.OPEN_FEEDBACK_DIALOG);return response["errorMessage"]},showOnDeviceAppControls(){return parentMessagePipe.sendMessage(Message.SHOW_ON_DEVICE_APP_CONTROLS)},showParentalControls(){return parentMessagePipe.sendMessage(Message.SHOW_PARENTAL_CONTROLS)},triggerWelcomeTipCallToAction(actionTypeId){return parentMessagePipe.sendMessage(Message.TRIGGER_WELCOME_TIP_CALL_TO_ACTION,actionTypeId)},addOrUpdateSearchIndex(data){return parentMessagePipe.sendMessage(Message.ADD_OR_UPDATE_SEARCH_INDEX,data)},clearSearchIndex(){return parentMessagePipe.sendMessage(Message.CLEAR_SEARCH_INDEX)},findInSearchIndex(query,maxResults=50){return parentMessagePipe.sendMessage(Message.FIND_IN_SEARCH_INDEX,{query:query,maxResults:maxResults})},closeBackgroundPage(){parentMessagePipe.sendMessage(Message.CLOSE_BACKGROUND_PAGE)},updateLauncherSearchIndex(data){return parentMessagePipe.sendMessage(Message.UPDATE_LAUNCHER_SEARCH_INDEX,data)},launchMicrosoft365Setup(){return parentMessagePipe.sendMessage(Message.LAUNCH_MICROSOFT_365_SETUP)},maybeShowReleaseNotesNotification(){return parentMessagePipe.sendMessage(Message.MAYBE_SHOW_RELEASE_NOTES_NOTIFICATION)},getDeviceInfo(){return parentMessagePipe.sendMessage(Message.GET_DEVICE_INFO)},openSettings(path){parentMessagePipe.sendMessage(Message.OPEN_SETTINGS,path)},openUrlInBrowserAndTriggerInstallDialog(url){return parentMessagePipe.sendMessage(Message.OPEN_URL_IN_BROWSER_AND_TRIGGER_INSTALL_DIALOG,url)},setHasCompletedNewDeviceChecklist(){parentMessagePipe.sendMessage(Message.SET_HAS_COMPLETED_NEW_DEVICE_CHECKLIST)},setHasVisitedHowToPage(){parentMessagePipe.sendMessage(Message.SET_HAS_VISITED_HOW_TO_PAGE)},openAppMallPath(path){parentMessagePipe.sendMessage(Message.OPEN_APP_MALL_PATH,{path:path})}};window.customLaunchData={delegate:DELEGATE};window.addEventListener("DOMContentLoaded",(function(){ColorChangeUpdater.forDocument().start()}));window.addColorChangeListener=function(listener){ColorChangeUpdater.forDocument().eventTarget.addEventListener(COLOR_PROVIDER_CHANGED,listener)};window.removeColorChangeListener=function(listener){ColorChangeUpdater.forDocument().eventTarget.removeEventListener(COLOR_PROVIDER_CHANGED,listener)};const TEST_ONLY={parentMessagePipe:parentMessagePipe};export{TEST_ONLY};