// ash/webui/help_app_ui/help_app_ui.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { UrlSpec as url_mojom_UrlSpec } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export const ActionTypeIdSpec = { $: mojo.internal.Enum() };
export var ActionTypeId;
(function (ActionTypeId) {
    ActionTypeId[ActionTypeId["MIN_VALUE"] = 0] = "MIN_VALUE";
    ActionTypeId[ActionTypeId["MAX_VALUE"] = 10] = "MAX_VALUE";
    ActionTypeId[ActionTypeId["INVALID"] = 0] = "INVALID";
    ActionTypeId[ActionTypeId["OPEN_CHROME"] = 1] = "OPEN_CHROME";
    ActionTypeId[ActionTypeId["OPEN_LAUNCHER"] = 2] = "OPEN_LAUNCHER";
    ActionTypeId[ActionTypeId["OPEN_PERSONALIZATION_APP"] = 3] = "OPEN_PERSONALIZATION_APP";
    ActionTypeId[ActionTypeId["OPEN_PLAY_STORE"] = 4] = "OPEN_PLAY_STORE";
    ActionTypeId[ActionTypeId["OPEN_GOOGLE_DOCS"] = 5] = "OPEN_GOOGLE_DOCS";
    ActionTypeId[ActionTypeId["OPEN_GOOGLE_PHOTOS"] = 6] = "OPEN_GOOGLE_PHOTOS";
    ActionTypeId[ActionTypeId["OPEN_SETTINGS_PRINTER"] = 7] = "OPEN_SETTINGS_PRINTER";
    ActionTypeId[ActionTypeId["OPEN_PHONE_HUB"] = 8] = "OPEN_PHONE_HUB";
    ActionTypeId[ActionTypeId["OPEN_YOUTUBE"] = 9] = "OPEN_YOUTUBE";
    ActionTypeId[ActionTypeId["OPEN_FILE_MANAGER"] = 10] = "OPEN_FILE_MANAGER";
})(ActionTypeId || (ActionTypeId = {}));
export const SettingsComponentSpec = { $: mojo.internal.Enum() };
export var SettingsComponent;
(function (SettingsComponent) {
    SettingsComponent[SettingsComponent["MIN_VALUE"] = 0] = "MIN_VALUE";
    SettingsComponent[SettingsComponent["MAX_VALUE"] = 13] = "MAX_VALUE";
    SettingsComponent[SettingsComponent["HOME"] = 0] = "HOME";
    SettingsComponent[SettingsComponent["ACCESSIBILITY"] = 1] = "ACCESSIBILITY";
    SettingsComponent[SettingsComponent["BLUETOOTH"] = 2] = "BLUETOOTH";
    SettingsComponent[SettingsComponent["DISPLAY"] = 3] = "DISPLAY";
    SettingsComponent[SettingsComponent["INPUT"] = 4] = "INPUT";
    SettingsComponent[SettingsComponent["MULTI_DEVICE"] = 5] = "MULTI_DEVICE";
    SettingsComponent[SettingsComponent["PEOPLE"] = 6] = "PEOPLE";
    SettingsComponent[SettingsComponent["PER_DEVICE_KEYBOARD"] = 7] = "PER_DEVICE_KEYBOARD";
    SettingsComponent[SettingsComponent["PER_DEVICE_TOUCHPAD"] = 8] = "PER_DEVICE_TOUCHPAD";
    SettingsComponent[SettingsComponent["PERSONALIZATION"] = 9] = "PERSONALIZATION";
    SettingsComponent[SettingsComponent["PRINTING"] = 10] = "PRINTING";
    SettingsComponent[SettingsComponent["SECURITY_AND_SIGN_IN"] = 11] = "SECURITY_AND_SIGN_IN";
    SettingsComponent[SettingsComponent["TOUCHPAD_REVERSE_SCROLLING"] = 12] = "TOUCHPAD_REVERSE_SCROLLING";
    SettingsComponent[SettingsComponent["TOUCHPAD_SIMULATE_RIGHT_CLICK"] = 13] = "TOUCHPAD_SIMULATE_RIGHT_CLICK";
})(SettingsComponent || (SettingsComponent = {}));
export class PageHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.help_app.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "ash.help_app.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createPageHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.help_app.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    openFeedbackDialog() {
        return this.proxy.sendMessage(0, PageHandler_OpenFeedbackDialog_ParamsSpec.$, PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$, [], false);
    }
    showOnDeviceAppControls() {
        this.proxy.sendMessage(1, PageHandler_ShowOnDeviceAppControls_ParamsSpec.$, null, [], false);
    }
    showParentalControls() {
        this.proxy.sendMessage(2, PageHandler_ShowParentalControls_ParamsSpec.$, null, [], false);
    }
    triggerWelcomeTipCallToAction(actionTypeId) {
        this.proxy.sendMessage(3, PageHandler_TriggerWelcomeTipCallToAction_ParamsSpec.$, null, [
            actionTypeId
        ], false);
    }
    isLauncherSearchEnabled() {
        return this.proxy.sendMessage(4, PageHandler_IsLauncherSearchEnabled_ParamsSpec.$, PageHandler_IsLauncherSearchEnabled_ResponseParamsSpec.$, [], false);
    }
    launchMicrosoft365Setup() {
        this.proxy.sendMessage(5, PageHandler_LaunchMicrosoft365Setup_ParamsSpec.$, null, [], false);
    }
    maybeShowReleaseNotesNotification() {
        this.proxy.sendMessage(6, PageHandler_MaybeShowReleaseNotesNotification_ParamsSpec.$, null, [], false);
    }
    getDeviceInfo() {
        return this.proxy.sendMessage(7, PageHandler_GetDeviceInfo_ParamsSpec.$, PageHandler_GetDeviceInfo_ResponseParamsSpec.$, [], false);
    }
    openUrlInBrowserAndTriggerInstallDialog(url) {
        this.proxy.sendMessage(8, PageHandler_OpenUrlInBrowserAndTriggerInstallDialog_ParamsSpec.$, null, [
            url
        ], false);
    }
    openSettings(component) {
        this.proxy.sendMessage(9, PageHandler_OpenSettings_ParamsSpec.$, null, [
            component
        ], false);
    }
    setHasCompletedNewDeviceChecklist() {
        this.proxy.sendMessage(10, PageHandler_SetHasCompletedNewDeviceChecklist_ParamsSpec.$, null, [], false);
    }
    setHasVisitedHowToPage() {
        this.proxy.sendMessage(11, PageHandler_SetHasVisitedHowToPage_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_OpenFeedbackDialog_ParamsSpec.$, PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$, impl.openFeedbackDialog.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_ShowOnDeviceAppControls_ParamsSpec.$, null, impl.showOnDeviceAppControls.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_ShowParentalControls_ParamsSpec.$, null, impl.showParentalControls.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_TriggerWelcomeTipCallToAction_ParamsSpec.$, null, impl.triggerWelcomeTipCallToAction.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_IsLauncherSearchEnabled_ParamsSpec.$, PageHandler_IsLauncherSearchEnabled_ResponseParamsSpec.$, impl.isLauncherSearchEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(5, PageHandler_LaunchMicrosoft365Setup_ParamsSpec.$, null, impl.launchMicrosoft365Setup.bind(impl), false);
        this.helper_internal_.registerHandler(6, PageHandler_MaybeShowReleaseNotesNotification_ParamsSpec.$, null, impl.maybeShowReleaseNotesNotification.bind(impl), false);
        this.helper_internal_.registerHandler(7, PageHandler_GetDeviceInfo_ParamsSpec.$, PageHandler_GetDeviceInfo_ResponseParamsSpec.$, impl.getDeviceInfo.bind(impl), false);
        this.helper_internal_.registerHandler(8, PageHandler_OpenUrlInBrowserAndTriggerInstallDialog_ParamsSpec.$, null, impl.openUrlInBrowserAndTriggerInstallDialog.bind(impl), false);
        this.helper_internal_.registerHandler(9, PageHandler_OpenSettings_ParamsSpec.$, null, impl.openSettings.bind(impl), false);
        this.helper_internal_.registerHandler(10, PageHandler_SetHasCompletedNewDeviceChecklist_ParamsSpec.$, null, impl.setHasCompletedNewDeviceChecklist.bind(impl), false);
        this.helper_internal_.registerHandler(11, PageHandler_SetHasVisitedHowToPage_ParamsSpec.$, null, impl.setHasVisitedHowToPage.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "ash.help_app.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    openFeedbackDialog;
    showOnDeviceAppControls;
    showParentalControls;
    triggerWelcomeTipCallToAction;
    isLauncherSearchEnabled;
    launchMicrosoft365Setup;
    maybeShowReleaseNotesNotification;
    getDeviceInfo;
    openUrlInBrowserAndTriggerInstallDialog;
    openSettings;
    setHasCompletedNewDeviceChecklist;
    setHasVisitedHowToPage;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.openFeedbackDialog =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_OpenFeedbackDialog_ParamsSpec.$, PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$, this.openFeedbackDialog.createReceiverHandler(true /* expectsResponse */), false);
        this.showOnDeviceAppControls =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_ShowOnDeviceAppControls_ParamsSpec.$, null, this.showOnDeviceAppControls.createReceiverHandler(false /* expectsResponse */), false);
        this.showParentalControls =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_ShowParentalControls_ParamsSpec.$, null, this.showParentalControls.createReceiverHandler(false /* expectsResponse */), false);
        this.triggerWelcomeTipCallToAction =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_TriggerWelcomeTipCallToAction_ParamsSpec.$, null, this.triggerWelcomeTipCallToAction.createReceiverHandler(false /* expectsResponse */), false);
        this.isLauncherSearchEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_IsLauncherSearchEnabled_ParamsSpec.$, PageHandler_IsLauncherSearchEnabled_ResponseParamsSpec.$, this.isLauncherSearchEnabled.createReceiverHandler(true /* expectsResponse */), false);
        this.launchMicrosoft365Setup =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, PageHandler_LaunchMicrosoft365Setup_ParamsSpec.$, null, this.launchMicrosoft365Setup.createReceiverHandler(false /* expectsResponse */), false);
        this.maybeShowReleaseNotesNotification =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, PageHandler_MaybeShowReleaseNotesNotification_ParamsSpec.$, null, this.maybeShowReleaseNotesNotification.createReceiverHandler(false /* expectsResponse */), false);
        this.getDeviceInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, PageHandler_GetDeviceInfo_ParamsSpec.$, PageHandler_GetDeviceInfo_ResponseParamsSpec.$, this.getDeviceInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.openUrlInBrowserAndTriggerInstallDialog =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, PageHandler_OpenUrlInBrowserAndTriggerInstallDialog_ParamsSpec.$, null, this.openUrlInBrowserAndTriggerInstallDialog.createReceiverHandler(false /* expectsResponse */), false);
        this.openSettings =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, PageHandler_OpenSettings_ParamsSpec.$, null, this.openSettings.createReceiverHandler(false /* expectsResponse */), false);
        this.setHasCompletedNewDeviceChecklist =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, PageHandler_SetHasCompletedNewDeviceChecklist_ParamsSpec.$, null, this.setHasCompletedNewDeviceChecklist.createReceiverHandler(false /* expectsResponse */), false);
        this.setHasVisitedHowToPage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, PageHandler_SetHasVisitedHowToPage_ParamsSpec.$, null, this.setHasVisitedHowToPage.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const DeviceInfoSpec = { $: {} };
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_OpenFeedbackDialog_ParamsSpec = { $: {} };
export const PageHandler_OpenFeedbackDialog_ResponseParamsSpec = { $: {} };
export const PageHandler_ShowOnDeviceAppControls_ParamsSpec = { $: {} };
export const PageHandler_ShowParentalControls_ParamsSpec = { $: {} };
export const PageHandler_TriggerWelcomeTipCallToAction_ParamsSpec = { $: {} };
export const PageHandler_IsLauncherSearchEnabled_ParamsSpec = { $: {} };
export const PageHandler_IsLauncherSearchEnabled_ResponseParamsSpec = { $: {} };
export const PageHandler_LaunchMicrosoft365Setup_ParamsSpec = { $: {} };
export const PageHandler_MaybeShowReleaseNotesNotification_ParamsSpec = { $: {} };
export const PageHandler_GetDeviceInfo_ParamsSpec = { $: {} };
export const PageHandler_GetDeviceInfo_ResponseParamsSpec = { $: {} };
export const PageHandler_OpenUrlInBrowserAndTriggerInstallDialog_ParamsSpec = { $: {} };
export const PageHandler_OpenSettings_ParamsSpec = { $: {} };
export const PageHandler_SetHasCompletedNewDeviceChecklist_ParamsSpec = { $: {} };
export const PageHandler_SetHasVisitedHowToPage_ParamsSpec = { $: {} };
mojo.internal.Struct(DeviceInfoSpec.$, 'DeviceInfo', [
    mojo.internal.StructField('board', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('model', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('userType', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isSteamAllowed', 24, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('handler', 0, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OpenFeedbackDialog_ParamsSpec.$, 'PageHandler_OpenFeedbackDialog_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$, 'PageHandler_OpenFeedbackDialog_ResponseParams', [
    mojo.internal.StructField('errorMessage', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ShowOnDeviceAppControls_ParamsSpec.$, 'PageHandler_ShowOnDeviceAppControls_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_ShowParentalControls_ParamsSpec.$, 'PageHandler_ShowParentalControls_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_TriggerWelcomeTipCallToAction_ParamsSpec.$, 'PageHandler_TriggerWelcomeTipCallToAction_Params', [
    mojo.internal.StructField('actionTypeId', 0, 0, ActionTypeIdSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_IsLauncherSearchEnabled_ParamsSpec.$, 'PageHandler_IsLauncherSearchEnabled_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_IsLauncherSearchEnabled_ResponseParamsSpec.$, 'PageHandler_IsLauncherSearchEnabled_ResponseParams', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_LaunchMicrosoft365Setup_ParamsSpec.$, 'PageHandler_LaunchMicrosoft365Setup_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_MaybeShowReleaseNotesNotification_ParamsSpec.$, 'PageHandler_MaybeShowReleaseNotesNotification_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetDeviceInfo_ParamsSpec.$, 'PageHandler_GetDeviceInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetDeviceInfo_ResponseParamsSpec.$, 'PageHandler_GetDeviceInfo_ResponseParams', [
    mojo.internal.StructField('deviceInfo', 0, 0, DeviceInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OpenUrlInBrowserAndTriggerInstallDialog_ParamsSpec.$, 'PageHandler_OpenUrlInBrowserAndTriggerInstallDialog_Params', [
    mojo.internal.StructField('url', 0, 0, url_mojom_UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_OpenSettings_ParamsSpec.$, 'PageHandler_OpenSettings_Params', [
    mojo.internal.StructField('component', 0, 0, SettingsComponentSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetHasCompletedNewDeviceChecklist_ParamsSpec.$, 'PageHandler_SetHasCompletedNewDeviceChecklist_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_SetHasVisitedHowToPage_ParamsSpec.$, 'PageHandler_SetHasVisitedHowToPage_Params', [], [[0, 8],]);
