// ash/webui/help_app_ui/search/search.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { String16Spec as mojoBase_mojom_String16Spec } from '//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js';
export class SearchResultsObserverPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.help_app.mojom.SearchResultsObserver', scope);
    }
}
export class SearchResultsObserverRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(SearchResultsObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onSearchResultAvailabilityChanged() {
        this.proxy.sendMessage(0, SearchResultsObserver_OnSearchResultAvailabilityChanged_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the SearchResultsObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SearchResultsObserverReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SearchResultsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, SearchResultsObserver_OnSearchResultAvailabilityChanged_ParamsSpec.$, null, impl.onSearchResultAvailabilityChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class SearchResultsObserver {
    static get $interfaceName() {
        return "ash.help_app.mojom.SearchResultsObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new SearchResultsObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the SearchResultsObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SearchResultsObserverCallbackRouter {
    helper_internal_;
    $;
    router_;
    onSearchResultAvailabilityChanged;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SearchResultsObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onSearchResultAvailabilityChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, SearchResultsObserver_OnSearchResultAvailabilityChanged_ParamsSpec.$, null, this.onSearchResultAvailabilityChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class SearchHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.help_app.mojom.SearchHandler', scope);
    }
}
export class SearchHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(SearchHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    search(query, maxNumResults) {
        return this.proxy.sendMessage(0, SearchHandler_Search_ParamsSpec.$, SearchHandler_Search_ResponseParamsSpec.$, [
            query,
            maxNumResults
        ], false);
    }
    update(concepts) {
        return this.proxy.sendMessage(1, SearchHandler_Update_ParamsSpec.$, SearchHandler_Update_ResponseParamsSpec.$, [
            concepts
        ], false);
    }
    observe(observer) {
        this.proxy.sendMessage(2, SearchHandler_Observe_ParamsSpec.$, null, [
            observer
        ], false);
    }
}
;
/**
 * An object which receives request messages for the SearchHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SearchHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SearchHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, SearchHandler_Search_ParamsSpec.$, SearchHandler_Search_ResponseParamsSpec.$, impl.search.bind(impl), false);
        this.helper_internal_.registerHandler(1, SearchHandler_Update_ParamsSpec.$, SearchHandler_Update_ResponseParamsSpec.$, impl.update.bind(impl), false);
        this.helper_internal_.registerHandler(2, SearchHandler_Observe_ParamsSpec.$, null, impl.observe.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class SearchHandler {
    static get $interfaceName() {
        return "ash.help_app.mojom.SearchHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new SearchHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the SearchHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SearchHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    search;
    update;
    observe;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(SearchHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.search =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, SearchHandler_Search_ParamsSpec.$, SearchHandler_Search_ResponseParamsSpec.$, this.search.createReceiverHandler(true /* expectsResponse */), false);
        this.update =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, SearchHandler_Update_ParamsSpec.$, SearchHandler_Update_ResponseParamsSpec.$, this.update.createReceiverHandler(true /* expectsResponse */), false);
        this.observe =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, SearchHandler_Observe_ParamsSpec.$, null, this.observe.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const SearchResultSpec = { $: {} };
export const SearchConceptSpec = { $: {} };
export const SearchResultsObserver_OnSearchResultAvailabilityChanged_ParamsSpec = { $: {} };
export const SearchHandler_Search_ParamsSpec = { $: {} };
export const SearchHandler_Search_ResponseParamsSpec = { $: {} };
export const SearchHandler_Update_ParamsSpec = { $: {} };
export const SearchHandler_Update_ResponseParamsSpec = { $: {} };
export const SearchHandler_Observe_ParamsSpec = { $: {} };
mojo.internal.Struct(SearchResultSpec.$, 'SearchResult', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 8, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('mainCategory', 16, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('urlPathWithParameters', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('locale', 32, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('relevanceScore', 40, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(SearchConceptSpec.$, 'SearchConcept', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 8, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('mainCategory', 16, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tags', 24, 0, mojo.internal.Array(mojoBase_mojom_String16Spec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tagLocale', 32, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('urlPathWithParameters', 40, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('locale', 48, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 64],]);
mojo.internal.Struct(SearchResultsObserver_OnSearchResultAvailabilityChanged_ParamsSpec.$, 'SearchResultsObserver_OnSearchResultAvailabilityChanged_Params', [], [[0, 8],]);
mojo.internal.Struct(SearchHandler_Search_ParamsSpec.$, 'SearchHandler_Search_Params', [
    mojo.internal.StructField('query', 0, 0, mojoBase_mojom_String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('maxNumResults', 8, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(SearchHandler_Search_ResponseParamsSpec.$, 'SearchHandler_Search_ResponseParams', [
    mojo.internal.StructField('results', 0, 0, mojo.internal.Array(SearchResultSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SearchHandler_Update_ParamsSpec.$, 'SearchHandler_Update_Params', [
    mojo.internal.StructField('concepts', 0, 0, mojo.internal.Array(SearchConceptSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(SearchHandler_Update_ResponseParamsSpec.$, 'SearchHandler_Update_ResponseParams', [], [[0, 8],]);
mojo.internal.Struct(SearchHandler_Observe_ParamsSpec.$, 'SearchHandler_Observe_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(SearchResultsObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
