// ash/webui/media_app_ui/media_app_ui.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('ash.mediaAppUi.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.mediaAppUi.mojom.PageHandlerFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.mediaAppUi.mojom.PageHandlerFactory.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.mediaAppUi.mojom.PageHandlerFactoryInterface }
 */
ash.mediaAppUi.mojom.PageHandlerFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.mediaAppUi.mojom.PageHandlerFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.mediaAppUi.mojom.PageHandlerFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.mediaAppUi.mojom.PageHandlerFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ash.mediaAppUi.mojom.PageHandlerPendingReceiver } handler
   */

  createPageHandler(
      handler) {
    this.proxy.sendMessage(
        0,
        ash.mediaAppUi.mojom.PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.mediaAppUi.mojom.PageHandlerFactoryReceiver = class {
  /**
   * @param {!ash.mediaAppUi.mojom.PageHandlerFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.mediaAppUi.mojom.PageHandlerFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.mediaAppUi.mojom.PageHandlerFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.mediaAppUi.mojom.PageHandlerFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.mediaAppUi.mojom.PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.mediaAppUi.mojom.PageHandlerFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.media_app_ui.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.mediaAppUi.mojom.PageHandlerFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.mediaAppUi.mojom.PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.mediaAppUi.mojom.PageHandlerFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.mediaAppUi.mojom.PageHandlerFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.mediaAppUi.mojom.PageHandlerFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.mediaAppUi.mojom.PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.mediaAppUi.mojom.PageHandlerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.mediaAppUi.mojom.PageHandler.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.mediaAppUi.mojom.PageHandlerInterface }
 */
ash.mediaAppUi.mojom.PageHandlerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.mediaAppUi.mojom.PageHandlerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.mediaAppUi.mojom.PageHandlerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.mediaAppUi.mojom.PageHandlerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        errorMessage: ?string,
   *  }>}
   */

  openFeedbackDialog() {
    return this.proxy.sendMessage(
        0,
        ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  toggleBrowserFullscreenMode() {
    return this.proxy.sendMessage(
        1,
        ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  maybeTriggerPdfHats() {
    return this.proxy.sendMessage(
        2,
        ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } token
   * @return {!Promise<{
        writable: !boolean,
   *  }>}
   */

  isFileArcWritable(
      token) {
    return this.proxy.sendMessage(
        3,
        ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ResponseParamsSpec.$,
        [
          token
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } token
   * @return {!Promise<{
        writable: !boolean,
   *  }>}
   */

  isFileBrowserWritable(
      token) {
    return this.proxy.sendMessage(
        4,
        ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ResponseParamsSpec.$,
        [
          token
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } token
   * @param { !string } mimeType
   * @return {!Promise}
   */

  editInPhotos(
      token,
      mimeType) {
    return this.proxy.sendMessage(
        5,
        ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ResponseParamsSpec.$,
        [
          token,
          mimeType
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !Array<!number> } payload
   * @param { !string } header
   * @return {!Promise}
   */

  submitForm(
      url,
      payload,
      header) {
    return this.proxy.sendMessage(
        6,
        ash.mediaAppUi.mojom.PageHandler_SubmitForm_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_SubmitForm_ResponseParamsSpec.$,
        [
          url,
          payload,
          header
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.mediaAppUi.mojom.PageHandlerReceiver = class {
  /**
   * @param {!ash.mediaAppUi.mojom.PageHandlerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.mediaAppUi.mojom.PageHandlerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.mediaAppUi.mojom.PageHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.mediaAppUi.mojom.PageHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$,
        impl.openFeedbackDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ResponseParamsSpec.$,
        impl.toggleBrowserFullscreenMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ResponseParamsSpec.$,
        impl.maybeTriggerPdfHats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ResponseParamsSpec.$,
        impl.isFileArcWritable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ResponseParamsSpec.$,
        impl.isFileBrowserWritable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ResponseParamsSpec.$,
        impl.editInPhotos.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ash.mediaAppUi.mojom.PageHandler_SubmitForm_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_SubmitForm_ResponseParamsSpec.$,
        impl.submitForm.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.mediaAppUi.mojom.PageHandler = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.media_app_ui.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.mediaAppUi.mojom.PageHandlerRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.mediaAppUi.mojom.PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.mediaAppUi.mojom.PageHandlerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.mediaAppUi.mojom.PageHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.mediaAppUi.mojom.PageHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openFeedbackDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$,
        this.openFeedbackDialog.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.toggleBrowserFullscreenMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ResponseParamsSpec.$,
        this.toggleBrowserFullscreenMode.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.maybeTriggerPdfHats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ResponseParamsSpec.$,
        this.maybeTriggerPdfHats.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isFileArcWritable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ResponseParamsSpec.$,
        this.isFileArcWritable.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isFileBrowserWritable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ResponseParamsSpec.$,
        this.isFileBrowserWritable.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.editInPhotos =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ResponseParamsSpec.$,
        this.editInPhotos.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.submitForm =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ash.mediaAppUi.mojom.PageHandler_SubmitForm_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_SubmitForm_ResponseParamsSpec.$,
        this.submitForm.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandlerFactory_CreatePageHandler_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_SubmitForm_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_SubmitForm_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField(
        'handler', 0,
        0,
        mojo.internal.InterfaceRequest(ash.mediaAppUi.mojom.PageHandlerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.mediaAppUi.mojom.PageHandlerFactory_CreatePageHandler_Params = class {
  constructor() {
    /** @export { !ash.mediaAppUi.mojom.PageHandlerPendingReceiver } */
    this.handler;
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ParamsSpec.$,
    'PageHandler_OpenFeedbackDialog_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$,
    'PageHandler_OpenFeedbackDialog_ResponseParams',
    [
      mojo.internal.StructField(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ResponseParams = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.errorMessage;
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ParamsSpec.$,
    'PageHandler_ToggleBrowserFullscreenMode_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ResponseParamsSpec.$,
    'PageHandler_ToggleBrowserFullscreenMode_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ParamsSpec.$,
    'PageHandler_MaybeTriggerPdfHats_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ResponseParamsSpec.$,
    'PageHandler_MaybeTriggerPdfHats_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ParamsSpec.$,
    'PageHandler_IsFileArcWritable_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessTransferTokenRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessTransferTokenRemote } */
    this.token;
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ResponseParamsSpec.$,
    'PageHandler_IsFileArcWritable_ResponseParams',
    [
      mojo.internal.StructField(
        'writable', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.writable;
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ParamsSpec.$,
    'PageHandler_IsFileBrowserWritable_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessTransferTokenRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessTransferTokenRemote } */
    this.token;
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ResponseParamsSpec.$,
    'PageHandler_IsFileBrowserWritable_ResponseParams',
    [
      mojo.internal.StructField(
        'writable', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.writable;
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ParamsSpec.$,
    'PageHandler_EditInPhotos_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessTransferTokenRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mimeType', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_EditInPhotos_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessTransferTokenRemote } */
    this.token;
    /** @export { !string } */
    this.mimeType;
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ResponseParamsSpec.$,
    'PageHandler_EditInPhotos_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_SubmitForm_ParamsSpec.$,
    'PageHandler_SubmitForm_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'payload', 8,
        0,
        mojo.internal.Array(mojo.internal.Int8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'header', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_SubmitForm_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !Array<!number> } */
    this.payload;
    /** @export { !string } */
    this.header;
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_SubmitForm_ResponseParamsSpec.$,
    'PageHandler_SubmitForm_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_SubmitForm_ResponseParams = class {
  constructor() {
  }
};

