// ash/webui/media_app_ui/media_app_ui.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ash/webui/media_app_ui/media_app_ui.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ash.mediaAppUi.mojom');
  var file_system_access_transfer_token$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom', '../../../third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../url/mojom/url.mojom.js');
  }



  function PageHandlerFactory_CreatePageHandler_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageHandlerFactory_CreatePageHandler_Params.prototype.initDefaults_ = function() {
    this.handler = new bindings.InterfaceRequest();
  };
  PageHandlerFactory_CreatePageHandler_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageHandlerFactory_CreatePageHandler_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageHandlerFactory_CreatePageHandler_Params.handler
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageHandlerFactory_CreatePageHandler_Params.encodedSize = codec.kStructHeaderSize + 8;

  PageHandlerFactory_CreatePageHandler_Params.decode = function(decoder) {
    var packed;
    var val = new PageHandlerFactory_CreatePageHandler_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.handler =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PageHandlerFactory_CreatePageHandler_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageHandlerFactory_CreatePageHandler_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.handler);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PageHandler_OpenFeedbackDialog_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageHandler_OpenFeedbackDialog_Params.prototype.initDefaults_ = function() {
  };
  PageHandler_OpenFeedbackDialog_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageHandler_OpenFeedbackDialog_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageHandler_OpenFeedbackDialog_Params.encodedSize = codec.kStructHeaderSize + 0;

  PageHandler_OpenFeedbackDialog_Params.decode = function(decoder) {
    var packed;
    var val = new PageHandler_OpenFeedbackDialog_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PageHandler_OpenFeedbackDialog_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageHandler_OpenFeedbackDialog_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function PageHandler_OpenFeedbackDialog_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageHandler_OpenFeedbackDialog_ResponseParams.prototype.initDefaults_ = function() {
    this.errorMessage = null;
  };
  PageHandler_OpenFeedbackDialog_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageHandler_OpenFeedbackDialog_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageHandler_OpenFeedbackDialog_ResponseParams.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageHandler_OpenFeedbackDialog_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  PageHandler_OpenFeedbackDialog_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PageHandler_OpenFeedbackDialog_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PageHandler_OpenFeedbackDialog_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageHandler_OpenFeedbackDialog_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.errorMessage);
  };
  function PageHandler_ToggleBrowserFullscreenMode_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageHandler_ToggleBrowserFullscreenMode_Params.prototype.initDefaults_ = function() {
  };
  PageHandler_ToggleBrowserFullscreenMode_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageHandler_ToggleBrowserFullscreenMode_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageHandler_ToggleBrowserFullscreenMode_Params.encodedSize = codec.kStructHeaderSize + 0;

  PageHandler_ToggleBrowserFullscreenMode_Params.decode = function(decoder) {
    var packed;
    var val = new PageHandler_ToggleBrowserFullscreenMode_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PageHandler_ToggleBrowserFullscreenMode_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageHandler_ToggleBrowserFullscreenMode_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function PageHandler_ToggleBrowserFullscreenMode_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageHandler_ToggleBrowserFullscreenMode_ResponseParams.prototype.initDefaults_ = function() {
  };
  PageHandler_ToggleBrowserFullscreenMode_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageHandler_ToggleBrowserFullscreenMode_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageHandler_ToggleBrowserFullscreenMode_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  PageHandler_ToggleBrowserFullscreenMode_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PageHandler_ToggleBrowserFullscreenMode_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PageHandler_ToggleBrowserFullscreenMode_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageHandler_ToggleBrowserFullscreenMode_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function PageHandler_MaybeTriggerPdfHats_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageHandler_MaybeTriggerPdfHats_Params.prototype.initDefaults_ = function() {
  };
  PageHandler_MaybeTriggerPdfHats_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageHandler_MaybeTriggerPdfHats_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageHandler_MaybeTriggerPdfHats_Params.encodedSize = codec.kStructHeaderSize + 0;

  PageHandler_MaybeTriggerPdfHats_Params.decode = function(decoder) {
    var packed;
    var val = new PageHandler_MaybeTriggerPdfHats_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PageHandler_MaybeTriggerPdfHats_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageHandler_MaybeTriggerPdfHats_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function PageHandler_MaybeTriggerPdfHats_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageHandler_MaybeTriggerPdfHats_ResponseParams.prototype.initDefaults_ = function() {
  };
  PageHandler_MaybeTriggerPdfHats_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageHandler_MaybeTriggerPdfHats_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageHandler_MaybeTriggerPdfHats_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  PageHandler_MaybeTriggerPdfHats_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PageHandler_MaybeTriggerPdfHats_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PageHandler_MaybeTriggerPdfHats_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageHandler_MaybeTriggerPdfHats_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function PageHandler_IsFileArcWritable_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageHandler_IsFileArcWritable_Params.prototype.initDefaults_ = function() {
    this.token = new file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr();
  };
  PageHandler_IsFileArcWritable_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageHandler_IsFileArcWritable_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageHandler_IsFileArcWritable_Params.token
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageHandler_IsFileArcWritable_Params.encodedSize = codec.kStructHeaderSize + 8;

  PageHandler_IsFileArcWritable_Params.decode = function(decoder) {
    var packed;
    var val = new PageHandler_IsFileArcWritable_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr));
    return val;
  };

  PageHandler_IsFileArcWritable_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageHandler_IsFileArcWritable_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr), val.token);
  };
  function PageHandler_IsFileArcWritable_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageHandler_IsFileArcWritable_ResponseParams.prototype.initDefaults_ = function() {
    this.writable = false;
  };
  PageHandler_IsFileArcWritable_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageHandler_IsFileArcWritable_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PageHandler_IsFileArcWritable_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  PageHandler_IsFileArcWritable_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PageHandler_IsFileArcWritable_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.writable = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PageHandler_IsFileArcWritable_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageHandler_IsFileArcWritable_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.writable & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PageHandler_IsFileBrowserWritable_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageHandler_IsFileBrowserWritable_Params.prototype.initDefaults_ = function() {
    this.token = new file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr();
  };
  PageHandler_IsFileBrowserWritable_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageHandler_IsFileBrowserWritable_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageHandler_IsFileBrowserWritable_Params.token
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageHandler_IsFileBrowserWritable_Params.encodedSize = codec.kStructHeaderSize + 8;

  PageHandler_IsFileBrowserWritable_Params.decode = function(decoder) {
    var packed;
    var val = new PageHandler_IsFileBrowserWritable_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr));
    return val;
  };

  PageHandler_IsFileBrowserWritable_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageHandler_IsFileBrowserWritable_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr), val.token);
  };
  function PageHandler_IsFileBrowserWritable_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageHandler_IsFileBrowserWritable_ResponseParams.prototype.initDefaults_ = function() {
    this.writable = false;
  };
  PageHandler_IsFileBrowserWritable_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageHandler_IsFileBrowserWritable_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PageHandler_IsFileBrowserWritable_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  PageHandler_IsFileBrowserWritable_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PageHandler_IsFileBrowserWritable_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.writable = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PageHandler_IsFileBrowserWritable_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageHandler_IsFileBrowserWritable_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.writable & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PageHandler_EditInPhotos_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageHandler_EditInPhotos_Params.prototype.initDefaults_ = function() {
    this.token = new file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr();
    this.mimeType = null;
  };
  PageHandler_EditInPhotos_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageHandler_EditInPhotos_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageHandler_EditInPhotos_Params.token
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageHandler_EditInPhotos_Params.mimeType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageHandler_EditInPhotos_Params.encodedSize = codec.kStructHeaderSize + 16;

  PageHandler_EditInPhotos_Params.decode = function(decoder) {
    var packed;
    var val = new PageHandler_EditInPhotos_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr));
    val.mimeType =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PageHandler_EditInPhotos_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageHandler_EditInPhotos_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(file_system_access_transfer_token$.FileSystemAccessTransferTokenPtr), val.token);
    encoder.encodeStruct(codec.String, val.mimeType);
  };
  function PageHandler_EditInPhotos_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageHandler_EditInPhotos_ResponseParams.prototype.initDefaults_ = function() {
  };
  PageHandler_EditInPhotos_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageHandler_EditInPhotos_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageHandler_EditInPhotos_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  PageHandler_EditInPhotos_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PageHandler_EditInPhotos_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PageHandler_EditInPhotos_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageHandler_EditInPhotos_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function PageHandler_SubmitForm_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageHandler_SubmitForm_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.payload = null;
    this.header = null;
  };
  PageHandler_SubmitForm_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageHandler_SubmitForm_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageHandler_SubmitForm_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageHandler_SubmitForm_Params.payload
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Int8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageHandler_SubmitForm_Params.header
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageHandler_SubmitForm_Params.encodedSize = codec.kStructHeaderSize + 24;

  PageHandler_SubmitForm_Params.decode = function(decoder) {
    var packed;
    var val = new PageHandler_SubmitForm_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.payload =
        decoder.decodeArrayPointer(codec.Int8);
    val.header =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PageHandler_SubmitForm_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageHandler_SubmitForm_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeArrayPointer(codec.Int8, val.payload);
    encoder.encodeStruct(codec.String, val.header);
  };
  function PageHandler_SubmitForm_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageHandler_SubmitForm_ResponseParams.prototype.initDefaults_ = function() {
  };
  PageHandler_SubmitForm_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageHandler_SubmitForm_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageHandler_SubmitForm_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  PageHandler_SubmitForm_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PageHandler_SubmitForm_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PageHandler_SubmitForm_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageHandler_SubmitForm_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  var kPageHandlerFactory_CreatePageHandler_Name = 0;

  function PageHandlerFactoryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PageHandlerFactory,
                                                   handleOrPtrInfo);
  }

  function PageHandlerFactoryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PageHandlerFactory, associatedInterfacePtrInfo);
  }

  PageHandlerFactoryAssociatedPtr.prototype =
      Object.create(PageHandlerFactoryPtr.prototype);
  PageHandlerFactoryAssociatedPtr.prototype.constructor =
      PageHandlerFactoryAssociatedPtr;

  function PageHandlerFactoryProxy(receiver) {
    this.receiver_ = receiver;
  }
  PageHandlerFactoryPtr.prototype.createPageHandler = function() {
    return PageHandlerFactoryProxy.prototype.createPageHandler
        .apply(this.ptr.getProxy(), arguments);
  };

  PageHandlerFactoryProxy.prototype.createPageHandler = function(handler) {
    var params_ = new PageHandlerFactory_CreatePageHandler_Params();
    params_.handler = handler;
    var builder = new codec.MessageV0Builder(
        kPageHandlerFactory_CreatePageHandler_Name,
        codec.align(PageHandlerFactory_CreatePageHandler_Params.encodedSize));
    builder.encodeStruct(PageHandlerFactory_CreatePageHandler_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function PageHandlerFactoryStub(delegate) {
    this.delegate_ = delegate;
  }
  PageHandlerFactoryStub.prototype.createPageHandler = function(handler) {
    return this.delegate_ && this.delegate_.createPageHandler && this.delegate_.createPageHandler(handler);
  }

  PageHandlerFactoryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPageHandlerFactory_CreatePageHandler_Name:
      var params = reader.decodeStruct(PageHandlerFactory_CreatePageHandler_Params);
      this.createPageHandler(params.handler);
      return true;
    default:
      return false;
    }
  };

  PageHandlerFactoryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validatePageHandlerFactoryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPageHandlerFactory_CreatePageHandler_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PageHandlerFactory_CreatePageHandler_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePageHandlerFactoryResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var PageHandlerFactory = {
    name: 'ash.media_app_ui.mojom.PageHandlerFactory',
    kVersion: 0,
    ptrClass: PageHandlerFactoryPtr,
    proxyClass: PageHandlerFactoryProxy,
    stubClass: PageHandlerFactoryStub,
    validateRequest: validatePageHandlerFactoryRequest,
    validateResponse: null,
  };
  PageHandlerFactoryStub.prototype.validator = validatePageHandlerFactoryRequest;
  PageHandlerFactoryProxy.prototype.validator = null;
  var kPageHandler_OpenFeedbackDialog_Name = 0;
  var kPageHandler_ToggleBrowserFullscreenMode_Name = 1;
  var kPageHandler_MaybeTriggerPdfHats_Name = 2;
  var kPageHandler_IsFileArcWritable_Name = 3;
  var kPageHandler_IsFileBrowserWritable_Name = 4;
  var kPageHandler_EditInPhotos_Name = 5;
  var kPageHandler_SubmitForm_Name = 6;

  function PageHandlerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PageHandler,
                                                   handleOrPtrInfo);
  }

  function PageHandlerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PageHandler, associatedInterfacePtrInfo);
  }

  PageHandlerAssociatedPtr.prototype =
      Object.create(PageHandlerPtr.prototype);
  PageHandlerAssociatedPtr.prototype.constructor =
      PageHandlerAssociatedPtr;

  function PageHandlerProxy(receiver) {
    this.receiver_ = receiver;
  }
  PageHandlerPtr.prototype.openFeedbackDialog = function() {
    return PageHandlerProxy.prototype.openFeedbackDialog
        .apply(this.ptr.getProxy(), arguments);
  };

  PageHandlerProxy.prototype.openFeedbackDialog = function() {
    var params_ = new PageHandler_OpenFeedbackDialog_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPageHandler_OpenFeedbackDialog_Name,
          codec.align(PageHandler_OpenFeedbackDialog_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PageHandler_OpenFeedbackDialog_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PageHandler_OpenFeedbackDialog_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PageHandlerPtr.prototype.toggleBrowserFullscreenMode = function() {
    return PageHandlerProxy.prototype.toggleBrowserFullscreenMode
        .apply(this.ptr.getProxy(), arguments);
  };

  PageHandlerProxy.prototype.toggleBrowserFullscreenMode = function() {
    var params_ = new PageHandler_ToggleBrowserFullscreenMode_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPageHandler_ToggleBrowserFullscreenMode_Name,
          codec.align(PageHandler_ToggleBrowserFullscreenMode_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PageHandler_ToggleBrowserFullscreenMode_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PageHandler_ToggleBrowserFullscreenMode_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PageHandlerPtr.prototype.maybeTriggerPdfHats = function() {
    return PageHandlerProxy.prototype.maybeTriggerPdfHats
        .apply(this.ptr.getProxy(), arguments);
  };

  PageHandlerProxy.prototype.maybeTriggerPdfHats = function() {
    var params_ = new PageHandler_MaybeTriggerPdfHats_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPageHandler_MaybeTriggerPdfHats_Name,
          codec.align(PageHandler_MaybeTriggerPdfHats_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PageHandler_MaybeTriggerPdfHats_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PageHandler_MaybeTriggerPdfHats_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PageHandlerPtr.prototype.isFileArcWritable = function() {
    return PageHandlerProxy.prototype.isFileArcWritable
        .apply(this.ptr.getProxy(), arguments);
  };

  PageHandlerProxy.prototype.isFileArcWritable = function(token) {
    var params_ = new PageHandler_IsFileArcWritable_Params();
    params_.token = token;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPageHandler_IsFileArcWritable_Name,
          codec.align(PageHandler_IsFileArcWritable_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PageHandler_IsFileArcWritable_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PageHandler_IsFileArcWritable_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PageHandlerPtr.prototype.isFileBrowserWritable = function() {
    return PageHandlerProxy.prototype.isFileBrowserWritable
        .apply(this.ptr.getProxy(), arguments);
  };

  PageHandlerProxy.prototype.isFileBrowserWritable = function(token) {
    var params_ = new PageHandler_IsFileBrowserWritable_Params();
    params_.token = token;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPageHandler_IsFileBrowserWritable_Name,
          codec.align(PageHandler_IsFileBrowserWritable_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PageHandler_IsFileBrowserWritable_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PageHandler_IsFileBrowserWritable_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PageHandlerPtr.prototype.editInPhotos = function() {
    return PageHandlerProxy.prototype.editInPhotos
        .apply(this.ptr.getProxy(), arguments);
  };

  PageHandlerProxy.prototype.editInPhotos = function(token, mimeType) {
    var params_ = new PageHandler_EditInPhotos_Params();
    params_.token = token;
    params_.mimeType = mimeType;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPageHandler_EditInPhotos_Name,
          codec.align(PageHandler_EditInPhotos_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PageHandler_EditInPhotos_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PageHandler_EditInPhotos_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PageHandlerPtr.prototype.submitForm = function() {
    return PageHandlerProxy.prototype.submitForm
        .apply(this.ptr.getProxy(), arguments);
  };

  PageHandlerProxy.prototype.submitForm = function(url, payload, header) {
    var params_ = new PageHandler_SubmitForm_Params();
    params_.url = url;
    params_.payload = payload;
    params_.header = header;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPageHandler_SubmitForm_Name,
          codec.align(PageHandler_SubmitForm_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PageHandler_SubmitForm_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PageHandler_SubmitForm_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function PageHandlerStub(delegate) {
    this.delegate_ = delegate;
  }
  PageHandlerStub.prototype.openFeedbackDialog = function() {
    return this.delegate_ && this.delegate_.openFeedbackDialog && this.delegate_.openFeedbackDialog();
  }
  PageHandlerStub.prototype.toggleBrowserFullscreenMode = function() {
    return this.delegate_ && this.delegate_.toggleBrowserFullscreenMode && this.delegate_.toggleBrowserFullscreenMode();
  }
  PageHandlerStub.prototype.maybeTriggerPdfHats = function() {
    return this.delegate_ && this.delegate_.maybeTriggerPdfHats && this.delegate_.maybeTriggerPdfHats();
  }
  PageHandlerStub.prototype.isFileArcWritable = function(token) {
    return this.delegate_ && this.delegate_.isFileArcWritable && this.delegate_.isFileArcWritable(token);
  }
  PageHandlerStub.prototype.isFileBrowserWritable = function(token) {
    return this.delegate_ && this.delegate_.isFileBrowserWritable && this.delegate_.isFileBrowserWritable(token);
  }
  PageHandlerStub.prototype.editInPhotos = function(token, mimeType) {
    return this.delegate_ && this.delegate_.editInPhotos && this.delegate_.editInPhotos(token, mimeType);
  }
  PageHandlerStub.prototype.submitForm = function(url, payload, header) {
    return this.delegate_ && this.delegate_.submitForm && this.delegate_.submitForm(url, payload, header);
  }

  PageHandlerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  PageHandlerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPageHandler_OpenFeedbackDialog_Name:
      var params = reader.decodeStruct(PageHandler_OpenFeedbackDialog_Params);
      this.openFeedbackDialog().then(function(response) {
        var responseParams =
            new PageHandler_OpenFeedbackDialog_ResponseParams();
        responseParams.errorMessage = response.errorMessage;
        var builder = new codec.MessageV1Builder(
            kPageHandler_OpenFeedbackDialog_Name,
            codec.align(PageHandler_OpenFeedbackDialog_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PageHandler_OpenFeedbackDialog_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kPageHandler_ToggleBrowserFullscreenMode_Name:
      var params = reader.decodeStruct(PageHandler_ToggleBrowserFullscreenMode_Params);
      this.toggleBrowserFullscreenMode().then(function(response) {
        var responseParams =
            new PageHandler_ToggleBrowserFullscreenMode_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kPageHandler_ToggleBrowserFullscreenMode_Name,
            codec.align(PageHandler_ToggleBrowserFullscreenMode_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PageHandler_ToggleBrowserFullscreenMode_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kPageHandler_MaybeTriggerPdfHats_Name:
      var params = reader.decodeStruct(PageHandler_MaybeTriggerPdfHats_Params);
      this.maybeTriggerPdfHats().then(function(response) {
        var responseParams =
            new PageHandler_MaybeTriggerPdfHats_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kPageHandler_MaybeTriggerPdfHats_Name,
            codec.align(PageHandler_MaybeTriggerPdfHats_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PageHandler_MaybeTriggerPdfHats_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kPageHandler_IsFileArcWritable_Name:
      var params = reader.decodeStruct(PageHandler_IsFileArcWritable_Params);
      this.isFileArcWritable(params.token).then(function(response) {
        var responseParams =
            new PageHandler_IsFileArcWritable_ResponseParams();
        responseParams.writable = response.writable;
        var builder = new codec.MessageV1Builder(
            kPageHandler_IsFileArcWritable_Name,
            codec.align(PageHandler_IsFileArcWritable_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PageHandler_IsFileArcWritable_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kPageHandler_IsFileBrowserWritable_Name:
      var params = reader.decodeStruct(PageHandler_IsFileBrowserWritable_Params);
      this.isFileBrowserWritable(params.token).then(function(response) {
        var responseParams =
            new PageHandler_IsFileBrowserWritable_ResponseParams();
        responseParams.writable = response.writable;
        var builder = new codec.MessageV1Builder(
            kPageHandler_IsFileBrowserWritable_Name,
            codec.align(PageHandler_IsFileBrowserWritable_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PageHandler_IsFileBrowserWritable_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kPageHandler_EditInPhotos_Name:
      var params = reader.decodeStruct(PageHandler_EditInPhotos_Params);
      this.editInPhotos(params.token, params.mimeType).then(function(response) {
        var responseParams =
            new PageHandler_EditInPhotos_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kPageHandler_EditInPhotos_Name,
            codec.align(PageHandler_EditInPhotos_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PageHandler_EditInPhotos_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kPageHandler_SubmitForm_Name:
      var params = reader.decodeStruct(PageHandler_SubmitForm_Params);
      this.submitForm(params.url, params.payload, params.header).then(function(response) {
        var responseParams =
            new PageHandler_SubmitForm_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kPageHandler_SubmitForm_Name,
            codec.align(PageHandler_SubmitForm_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PageHandler_SubmitForm_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validatePageHandlerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPageHandler_OpenFeedbackDialog_Name:
        if (message.expectsResponse())
          paramsClass = PageHandler_OpenFeedbackDialog_Params;
      break;
      case kPageHandler_ToggleBrowserFullscreenMode_Name:
        if (message.expectsResponse())
          paramsClass = PageHandler_ToggleBrowserFullscreenMode_Params;
      break;
      case kPageHandler_MaybeTriggerPdfHats_Name:
        if (message.expectsResponse())
          paramsClass = PageHandler_MaybeTriggerPdfHats_Params;
      break;
      case kPageHandler_IsFileArcWritable_Name:
        if (message.expectsResponse())
          paramsClass = PageHandler_IsFileArcWritable_Params;
      break;
      case kPageHandler_IsFileBrowserWritable_Name:
        if (message.expectsResponse())
          paramsClass = PageHandler_IsFileBrowserWritable_Params;
      break;
      case kPageHandler_EditInPhotos_Name:
        if (message.expectsResponse())
          paramsClass = PageHandler_EditInPhotos_Params;
      break;
      case kPageHandler_SubmitForm_Name:
        if (message.expectsResponse())
          paramsClass = PageHandler_SubmitForm_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePageHandlerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kPageHandler_OpenFeedbackDialog_Name:
        if (message.isResponse())
          paramsClass = PageHandler_OpenFeedbackDialog_ResponseParams;
        break;
      case kPageHandler_ToggleBrowserFullscreenMode_Name:
        if (message.isResponse())
          paramsClass = PageHandler_ToggleBrowserFullscreenMode_ResponseParams;
        break;
      case kPageHandler_MaybeTriggerPdfHats_Name:
        if (message.isResponse())
          paramsClass = PageHandler_MaybeTriggerPdfHats_ResponseParams;
        break;
      case kPageHandler_IsFileArcWritable_Name:
        if (message.isResponse())
          paramsClass = PageHandler_IsFileArcWritable_ResponseParams;
        break;
      case kPageHandler_IsFileBrowserWritable_Name:
        if (message.isResponse())
          paramsClass = PageHandler_IsFileBrowserWritable_ResponseParams;
        break;
      case kPageHandler_EditInPhotos_Name:
        if (message.isResponse())
          paramsClass = PageHandler_EditInPhotos_ResponseParams;
        break;
      case kPageHandler_SubmitForm_Name:
        if (message.isResponse())
          paramsClass = PageHandler_SubmitForm_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var PageHandler = {
    name: 'ash.media_app_ui.mojom.PageHandler',
    kVersion: 0,
    ptrClass: PageHandlerPtr,
    proxyClass: PageHandlerProxy,
    stubClass: PageHandlerStub,
    validateRequest: validatePageHandlerRequest,
    validateResponse: validatePageHandlerResponse,
  };
  PageHandlerStub.prototype.validator = validatePageHandlerRequest;
  PageHandlerProxy.prototype.validator = validatePageHandlerResponse;
  exports.PageHandlerFactory = PageHandlerFactory;
  exports.PageHandlerFactoryPtr = PageHandlerFactoryPtr;
  exports.PageHandlerFactoryAssociatedPtr = PageHandlerFactoryAssociatedPtr;
  exports.PageHandler = PageHandler;
  exports.PageHandlerPtr = PageHandlerPtr;
  exports.PageHandlerAssociatedPtr = PageHandlerAssociatedPtr;
})();