// ash/webui/media_app_ui/media_app_ui.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../mojo/public/js/bindings.js';

import {
  FileSystemAccessTransferTokenRemote as blink_mojom_FileSystemAccessTransferTokenRemote,
  FileSystemAccessTransferTokenPendingReceiver as blink_mojom_FileSystemAccessTransferTokenPendingReceiver
} from '../../../third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../url/mojom/url.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PageHandlerFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.media_app_ui.mojom.PageHandlerFactory', scope);
  }
}

/** @interface */
export class PageHandlerFactoryInterface {
  
  /**
   * @param { !PageHandlerPendingReceiver } handler
   */

  createPageHandler(handler) {}
}

/**
 * @implements { PageHandlerFactoryInterface }
 */
export class PageHandlerFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PageHandlerFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PageHandlerFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !PageHandlerPendingReceiver } handler
   */

  createPageHandler(
      handler) {
    this.proxy.sendMessage(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          handler
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
  /**
   * @param {!PageHandlerFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PageHandlerFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PageHandlerFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandlerFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.media_app_ui.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PageHandlerFactoryRemote}
   */
  static getRemote() {
    let remote = new PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PageHandlerFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class PageHandlerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ash.media_app_ui.mojom.PageHandler', scope);
  }
}

/** @interface */
export class PageHandlerInterface {
  
  /**
   * @return {!Promise<{
        errorMessage: ?string,
   *  }>}
   */

  openFeedbackDialog() {}
  
  /**
   * @return {!Promise}
   */

  toggleBrowserFullscreenMode() {}
  
  /**
   * @return {!Promise}
   */

  maybeTriggerPdfHats() {}
  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } token
   * @return {!Promise<{
        writable: !boolean,
   *  }>}
   */

  isFileArcWritable(token) {}
  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } token
   * @return {!Promise<{
        writable: !boolean,
   *  }>}
   */

  isFileBrowserWritable(token) {}
  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } token
   * @param { !string } mimeType
   * @return {!Promise}
   */

  editInPhotos(token, mimeType) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !Array<!number> } payload
   * @param { !string } header
   * @return {!Promise}
   */

  submitForm(url, payload, header) {}
}

/**
 * @implements { PageHandlerInterface }
 */
export class PageHandlerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!PageHandlerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!PageHandlerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        errorMessage: ?string,
   *  }>}
   */

  openFeedbackDialog() {
    return this.proxy.sendMessage(
        0,
        PageHandler_OpenFeedbackDialog_ParamsSpec.$,
        PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  toggleBrowserFullscreenMode() {
    return this.proxy.sendMessage(
        1,
        PageHandler_ToggleBrowserFullscreenMode_ParamsSpec.$,
        PageHandler_ToggleBrowserFullscreenMode_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  maybeTriggerPdfHats() {
    return this.proxy.sendMessage(
        2,
        PageHandler_MaybeTriggerPdfHats_ParamsSpec.$,
        PageHandler_MaybeTriggerPdfHats_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } token
   * @return {!Promise<{
        writable: !boolean,
   *  }>}
   */

  isFileArcWritable(
      token) {
    return this.proxy.sendMessage(
        3,
        PageHandler_IsFileArcWritable_ParamsSpec.$,
        PageHandler_IsFileArcWritable_ResponseParamsSpec.$,
        [
          token
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } token
   * @return {!Promise<{
        writable: !boolean,
   *  }>}
   */

  isFileBrowserWritable(
      token) {
    return this.proxy.sendMessage(
        4,
        PageHandler_IsFileBrowserWritable_ParamsSpec.$,
        PageHandler_IsFileBrowserWritable_ResponseParamsSpec.$,
        [
          token
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_FileSystemAccessTransferTokenRemote } token
   * @param { !string } mimeType
   * @return {!Promise}
   */

  editInPhotos(
      token,
      mimeType) {
    return this.proxy.sendMessage(
        5,
        PageHandler_EditInPhotos_ParamsSpec.$,
        PageHandler_EditInPhotos_ResponseParamsSpec.$,
        [
          token,
          mimeType
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !Array<!number> } payload
   * @param { !string } header
   * @return {!Promise}
   */

  submitForm(
      url,
      payload,
      header) {
    return this.proxy.sendMessage(
        6,
        PageHandler_SubmitForm_ParamsSpec.$,
        PageHandler_SubmitForm_ResponseParamsSpec.$,
        [
          url,
          payload,
          header
        ],
        false);
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  /**
   * @param {!PageHandlerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!PageHandlerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PageHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_OpenFeedbackDialog_ParamsSpec.$,
        PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$,
        impl.openFeedbackDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_ToggleBrowserFullscreenMode_ParamsSpec.$,
        PageHandler_ToggleBrowserFullscreenMode_ResponseParamsSpec.$,
        impl.toggleBrowserFullscreenMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_MaybeTriggerPdfHats_ParamsSpec.$,
        PageHandler_MaybeTriggerPdfHats_ResponseParamsSpec.$,
        impl.maybeTriggerPdfHats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_IsFileArcWritable_ParamsSpec.$,
        PageHandler_IsFileArcWritable_ResponseParamsSpec.$,
        impl.isFileArcWritable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_IsFileBrowserWritable_ParamsSpec.$,
        PageHandler_IsFileBrowserWritable_ResponseParamsSpec.$,
        impl.isFileBrowserWritable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_EditInPhotos_ParamsSpec.$,
        PageHandler_EditInPhotos_ResponseParamsSpec.$,
        impl.editInPhotos.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_SubmitForm_ParamsSpec.$,
        PageHandler_SubmitForm_ResponseParamsSpec.$,
        impl.submitForm.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.media_app_ui.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!PageHandlerRemote}
   */
  static getRemote() {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!PageHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openFeedbackDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_OpenFeedbackDialog_ParamsSpec.$,
        PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$,
        this.openFeedbackDialog.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.toggleBrowserFullscreenMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_ToggleBrowserFullscreenMode_ParamsSpec.$,
        PageHandler_ToggleBrowserFullscreenMode_ResponseParamsSpec.$,
        this.toggleBrowserFullscreenMode.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.maybeTriggerPdfHats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_MaybeTriggerPdfHats_ParamsSpec.$,
        PageHandler_MaybeTriggerPdfHats_ResponseParamsSpec.$,
        this.maybeTriggerPdfHats.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isFileArcWritable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_IsFileArcWritable_ParamsSpec.$,
        PageHandler_IsFileArcWritable_ResponseParamsSpec.$,
        this.isFileArcWritable.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isFileBrowserWritable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_IsFileBrowserWritable_ParamsSpec.$,
        PageHandler_IsFileBrowserWritable_ResponseParamsSpec.$,
        this.isFileBrowserWritable.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.editInPhotos =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_EditInPhotos_ParamsSpec.$,
        PageHandler_EditInPhotos_ResponseParamsSpec.$,
        this.editInPhotos.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.submitForm =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_SubmitForm_ParamsSpec.$,
        PageHandler_SubmitForm_ResponseParamsSpec.$,
        this.submitForm.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageHandlerFactory_CreatePageHandler_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageHandler_OpenFeedbackDialog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageHandler_OpenFeedbackDialog_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageHandler_ToggleBrowserFullscreenMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageHandler_ToggleBrowserFullscreenMode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageHandler_MaybeTriggerPdfHats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageHandler_MaybeTriggerPdfHats_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageHandler_IsFileArcWritable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageHandler_IsFileArcWritable_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageHandler_IsFileBrowserWritable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageHandler_IsFileBrowserWritable_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageHandler_EditInPhotos_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageHandler_EditInPhotos_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageHandler_SubmitForm_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const PageHandler_SubmitForm_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField(
        'handler', 0,
        0,
        mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PageHandlerFactory_CreatePageHandler_Params {
  constructor() {
    /** @type { !PageHandlerPendingReceiver } */
    this.handler;
  }
}



mojo.internal.Struct(
    PageHandler_OpenFeedbackDialog_ParamsSpec.$,
    'PageHandler_OpenFeedbackDialog_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PageHandler_OpenFeedbackDialog_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$,
    'PageHandler_OpenFeedbackDialog_ResponseParams',
    [
      mojo.internal.StructField(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PageHandler_OpenFeedbackDialog_ResponseParams {
  constructor() {
    /** @type { (string|undefined) } */
    this.errorMessage;
  }
}



mojo.internal.Struct(
    PageHandler_ToggleBrowserFullscreenMode_ParamsSpec.$,
    'PageHandler_ToggleBrowserFullscreenMode_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PageHandler_ToggleBrowserFullscreenMode_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PageHandler_ToggleBrowserFullscreenMode_ResponseParamsSpec.$,
    'PageHandler_ToggleBrowserFullscreenMode_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PageHandler_ToggleBrowserFullscreenMode_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    PageHandler_MaybeTriggerPdfHats_ParamsSpec.$,
    'PageHandler_MaybeTriggerPdfHats_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PageHandler_MaybeTriggerPdfHats_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    PageHandler_MaybeTriggerPdfHats_ResponseParamsSpec.$,
    'PageHandler_MaybeTriggerPdfHats_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PageHandler_MaybeTriggerPdfHats_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    PageHandler_IsFileArcWritable_ParamsSpec.$,
    'PageHandler_IsFileArcWritable_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessTransferTokenRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PageHandler_IsFileArcWritable_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessTransferTokenRemote } */
    this.token;
  }
}



mojo.internal.Struct(
    PageHandler_IsFileArcWritable_ResponseParamsSpec.$,
    'PageHandler_IsFileArcWritable_ResponseParams',
    [
      mojo.internal.StructField(
        'writable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PageHandler_IsFileArcWritable_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.writable;
  }
}



mojo.internal.Struct(
    PageHandler_IsFileBrowserWritable_ParamsSpec.$,
    'PageHandler_IsFileBrowserWritable_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessTransferTokenRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PageHandler_IsFileBrowserWritable_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessTransferTokenRemote } */
    this.token;
  }
}



mojo.internal.Struct(
    PageHandler_IsFileBrowserWritable_ResponseParamsSpec.$,
    'PageHandler_IsFileBrowserWritable_ResponseParams',
    [
      mojo.internal.StructField(
        'writable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class PageHandler_IsFileBrowserWritable_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.writable;
  }
}



mojo.internal.Struct(
    PageHandler_EditInPhotos_ParamsSpec.$,
    'PageHandler_EditInPhotos_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_FileSystemAccessTransferTokenRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mimeType', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class PageHandler_EditInPhotos_Params {
  constructor() {
    /** @type { !blink_mojom_FileSystemAccessTransferTokenRemote } */
    this.token;
    /** @type { !string } */
    this.mimeType;
  }
}



mojo.internal.Struct(
    PageHandler_EditInPhotos_ResponseParamsSpec.$,
    'PageHandler_EditInPhotos_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PageHandler_EditInPhotos_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    PageHandler_SubmitForm_ParamsSpec.$,
    'PageHandler_SubmitForm_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'payload', 8,
        0,
        mojo.internal.Array(mojo.internal.Int8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'header', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class PageHandler_SubmitForm_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !Array<!number> } */
    this.payload;
    /** @type { !string } */
    this.header;
  }
}



mojo.internal.Struct(
    PageHandler_SubmitForm_ResponseParamsSpec.$,
    'PageHandler_SubmitForm_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class PageHandler_SubmitForm_ResponseParams {
  constructor() {
  }
}

