import 'chrome://media-app/strings.m.js';
import { loadTimeData } from 'chrome://resources/ash/common/load_time_data.m.js';

// mojo/public/mojom/base/unguessable_token.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit



mojo.internal.exportModule('mojoBase.mojom');







/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mojoBase.mojom.UnguessableTokenSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    mojoBase.mojom.UnguessableTokenSpec.$,
    'UnguessableToken',
    [
      mojo.internal.StructField(
        'high', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'low', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
mojoBase.mojom.UnguessableToken = class {
  constructor() {
    /** @export { !bigint } */
    this.high;
    /** @export { !bigint } */
    this.low;
  }
};

// third_party/blink/public/mojom/file_system_access/file_system_access_transfer_token.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit



mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.FileSystemAccessTransferTokenPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.FileSystemAccessTransferToken.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.FileSystemAccessTransferTokenInterface }
 */
blink.mojom.FileSystemAccessTransferTokenRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.FileSystemAccessTransferTokenPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.FileSystemAccessTransferTokenPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.FileSystemAccessTransferTokenPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        id: !mojoBase.mojom.UnguessableToken,
   *  }>}
   */

  getInternalID() {
    return this.proxy.sendMessage(
        0,
        blink.mojom.FileSystemAccessTransferToken_GetInternalID_ParamsSpec.$,
        blink.mojom.FileSystemAccessTransferToken_GetInternalID_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenPendingReceiver } tokenClone
   */

  clone(
      tokenClone) {
    this.proxy.sendMessage(
        1,
        blink.mojom.FileSystemAccessTransferToken_Clone_ParamsSpec.$,
        null,
        [
          tokenClone
        ],
        false);
  }
};

/**
 * An object which receives request messages for the FileSystemAccessTransferToken
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.FileSystemAccessTransferTokenReceiver = class {
  /**
   * @param {!blink.mojom.FileSystemAccessTransferTokenInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.FileSystemAccessTransferTokenRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.FileSystemAccessTransferTokenRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessTransferTokenRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessTransferToken_GetInternalID_ParamsSpec.$,
        blink.mojom.FileSystemAccessTransferToken_GetInternalID_ResponseParamsSpec.$,
        impl.getInternalID.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessTransferToken_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.FileSystemAccessTransferToken = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.FileSystemAccessTransferToken";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.FileSystemAccessTransferTokenRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.FileSystemAccessTransferTokenRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the FileSystemAccessTransferToken
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.FileSystemAccessTransferTokenCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.FileSystemAccessTransferTokenRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.FileSystemAccessTransferTokenRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getInternalID =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.FileSystemAccessTransferToken_GetInternalID_ParamsSpec.$,
        blink.mojom.FileSystemAccessTransferToken_GetInternalID_ResponseParamsSpec.$,
        this.getInternalID.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.FileSystemAccessTransferToken_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessTransferToken_GetInternalID_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessTransferToken_GetInternalID_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.FileSystemAccessTransferToken_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.FileSystemAccessTransferToken_GetInternalID_ParamsSpec.$,
    'FileSystemAccessTransferToken_GetInternalID_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.FileSystemAccessTransferToken_GetInternalID_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessTransferToken_GetInternalID_ResponseParamsSpec.$,
    'FileSystemAccessTransferToken_GetInternalID_ResponseParams',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FileSystemAccessTransferToken_GetInternalID_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.id;
  }
};



mojo.internal.Struct(
    blink.mojom.FileSystemAccessTransferToken_Clone_ParamsSpec.$,
    'FileSystemAccessTransferToken_Clone_Params',
    [
      mojo.internal.StructField(
        'tokenClone', 0,
        0,
        mojo.internal.InterfaceRequest(blink.mojom.FileSystemAccessTransferTokenPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.FileSystemAccessTransferToken_Clone_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessTransferTokenPendingReceiver } */
    this.tokenClone;
  }
};

// url/mojom/url.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit



mojo.internal.exportModule('url.mojom');




/**
 * @const { !number }
 * @export
 */
url.mojom.MAX_URL_CHARS = 2097152;




/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
url.mojom.UrlSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    url.mojom.UrlSpec.$,
    'Url',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
url.mojom.Url = class {
  constructor() {
    /** @export { !string } */
    this.url;
  }
};

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The Object placed in MessageData.message (and thrown by the Promise returned
 * by sendMessage) if an exception is caught on the receiving end.
 * Note this must be a class (not an interface) whilst there are .js files
 * importing `GenericErrorResponse`, otherwise the export is invisible.
 */
/**
 * To handle generic errors such as `DOMException` not being an `Error`
 * defensively assign '' if the attribute is undefined. Without explicitly
 * extracting fields, `Errors` are sent as `{}` across the pipe.
 */
function serializeError(error) {
    return {
        message: error.message || '',
        name: error.name || '',
        stack: error.stack || '',
    };
}
/**
 * Creates a new JavaScript native Promise and captures its resolve and reject
 * callbacks. The promise, resolve, and reject are available as properties.
 * Inspired by goog.promise.NativeResolver.
 */
class NativeResolver {
    resolve;
    reject;
    promise;
    constructor() {
        this.promise = new Promise((resolve, reject) => {
            this.resolve = resolve;
            this.reject = reject;
        });
    }
}
/**
 * A simplified "assert" that casts away null types. Assumes preconditions that
 * satisfy the assert have already been checked.
 * TODO(b/150650426): consolidate this better.
 */
function assertCast(condition) {
    if (!condition) {
        throw new Error('Failed assertion');
    }
    return condition;
}
/**
 * Enum for reserved message types used in generated messages.
 */
var ReservedMessageTypes;
(function (ReservedMessageTypes) {
    /**
     * Indicates a autogenerated response message for a previously received
     * message.
     */
    ReservedMessageTypes["RESPONSE_TYPE"] = "___response";
    /**
     * Indicates a autogenerated error message for a previously received
     * message.
     */
    ReservedMessageTypes["ERROR_TYPE"] = "___error";
})(ReservedMessageTypes || (ReservedMessageTypes = {}));
/**
 * Checks if a provided message type indicates a generated message.
 */
function isGeneratedMessage(messageType) {
    // Any message type with three underscores before it should only be used
    // in generated messages.
    return messageType.substr(0, 3) === '___';
}
/**
 * Checks a message type is not reserved by generated messages, if it is, throws
 * a error indicating this to the user.
 */
function throwIfReserved(messageType) {
    if (isGeneratedMessage(messageType)) {
        throw new Error(`Unexpected reserved message type: '${messageType}'`);
    }
}
/**
 * The message pipe allows two windows to communicate in 1 direction without
 * having to handle the internals. The caller can send messages to the other
 * window and receive async responses.
 */
class MessagePipe {
    target_;
    targetOrigin_;
    /**
     * If true any errors thrown in a handler during message handling will be
     * thrown again in addition to being sent over the pipe to the message
     * sender. true by default.
     */
    rethrowErrors;
    /**
     * Client error logger. Mockable for tests that check for errors. This is
     * only used to log errors generated from handlers. Logging occurs on both
     * sides of the message pipe if rethrowErrors is set, otherwise only on
     * the side that sent the message.
     */
    logClientError = (object) => console.error(JSON.stringify(object));
    /**
     * Maps a message type to a message handler, a function which takes in
     * the message and returns a response message or a promise which resolves
     * with a response message.
     */
    messageHandlers_ = new Map();
    /**
     * Maps a message id to a resolver.
     */
    pendingMessages_ = new Map();
    /**
     * The id the next message the object sends will have.
     */
    nextMessageId_ = 0;
    /**
     * The message listener we attach to the window. We need a reference to the
     * function for later removal.
     */
    messageListener_ = (m) => this.receiveMessage_(m);
    /**
     * Constructs a new message pipe to the `target` window which has the
     * `targetOrigin` origin.
     *
     * @param target If not specified, the document tree will be
     *     queried for a iframe with src `targetOrigin` to target.
     */
    constructor(targetOrigin, target, rethrowErrors = true) {
        if (!target) {
            const frame = document.querySelector(`iframe[src^='${targetOrigin}']`);
            if (!frame || !frame.contentWindow) {
                throw new Error('Unable to locate target content window.');
            }
            target = assertCast(frame.contentWindow);
        }
        this.target_ = target;
        this.targetOrigin_ = targetOrigin;
        this.rethrowErrors = rethrowErrors;
        // Make sure we aren't trying to send messages to ourselves.
        console.assert(this.target_ !== window, 'target !== window');
        window.addEventListener('message', this.messageListener_);
    }
    /**
     * Registers a handler to be called when a message of type `messageType` is
     * received. The return value of this handler will automatically be sent to
     * the message source as a response message. If the handler should throw an
     * error while handling a message, the error message will be caught and sent
     * to the message source automatically.
     * NOTE: The message type can not be prefixed with 3 underscores as that is
     * reserved for generated messages. i.e `___hello` is disallowed.
     *
     */
    registerHandler(messageType, handler) {
        throwIfReserved(messageType);
        if (this.messageHandlers_.has(messageType)) {
            throw new Error(`A handler already exists for ${messageType}`);
        }
        this.messageHandlers_.set(messageType, handler);
    }
    /**
     * Wraps `sendMessageImpl()` catching errors from the target context to throw
     * more useful errors with the current context stacktrace attached.
     */
    async sendMessage(messageType, message = {}) {
        try {
            return await this.sendMessageImpl(messageType, message);
        }
        catch (errorResponse) {
            // Create an error with the name of the IPC function invoked, append the
            // stacktrace from the target context (origin of the error) with the
            // stacktrace of the current context.
            const error = new Error(`${messageType}: ${errorResponse.message}`);
            error.name = errorResponse.name || 'Unknown Error';
            error.stack +=
                `\nError from ${this.targetOrigin_}\n${errorResponse.stack}`;
            // TODO(b/156205603): use internal `chrome.crashReportPrivate.reportError`
            // to log this error.
            throw error;
        }
    }
    /**
     * Sends a message to the target window and return a Promise that will resolve
     * on response. If the target handler does not send a response the promise
     * will resolve with a empty object.
     */
    async sendMessageImpl(messageType, message = {}) {
        throwIfReserved(messageType);
        const messageId = this.nextMessageId_++;
        const resolver = new NativeResolver();
        this.pendingMessages_.set(messageId, resolver);
        this.postToTarget_(messageType, message, messageId);
        return resolver.promise;
    }
    /**
     * Removes all listeners this object attaches to window in preparation for
     * destruction.
     */
    detach() {
        window.removeEventListener('message', this.messageListener_);
    }
    /**
     * Handles a message which represents the targets response to a previously
     * sent message.
     */
    handleMessageResponse_(messageType, message, messageId) {
        const { RESPONSE_TYPE, ERROR_TYPE } = ReservedMessageTypes;
        const resolver = assertCast(this.pendingMessages_.get(messageId));
        if (messageType === RESPONSE_TYPE) {
            resolver.resolve(message);
        }
        else if (messageType === ERROR_TYPE) {
            this.logClientError(message);
            resolver.reject(message);
        }
        else {
            console.error(`Response for message ${messageId} received with invalid message type ${messageType}`);
        }
        this.pendingMessages_.delete(messageId);
    }
    /**
     * Calls the relevant handler for a received message and generates the right
     * response message to send back to the source.
     */
    async callHandlerForMessageType_(messageType, message, messageId) {
        const { RESPONSE_TYPE, ERROR_TYPE } = ReservedMessageTypes;
        let response;
        let error = null;
        let sawError = false;
        try {
            const handler = assertCast(this.messageHandlers_.get(messageType));
            response = await handler(message);
        }
        catch (err) {
            // If an error happened capture the error and send it back.
            sawError = true;
            error = err;
            response = serializeError(err);
        }
        this.postToTarget_(sawError ? ERROR_TYPE : RESPONSE_TYPE, response, messageId);
        if (sawError && this.rethrowErrors) {
            // Rethrow the error so the current frame has visibility on its handler
            // failures.
            this.logClientError(error);
            throw error;
        }
    }
    receiveMessage_(e) {
        // Ignore message events missing a type.
        if (typeof e.data !== 'object' || !e.data ||
            typeof e.data.type !== 'string') {
            return;
        }
        const { messageId, type, message } = e.data;
        const { ERROR_TYPE } = ReservedMessageTypes;
        // Ignore any messages that are not from the target origin unless we are
        // explicitly accepting messages from any origin.
        if (e.origin !== this.targetOrigin_ && this.targetOrigin_ !== '*') {
            return;
        }
        // The case that the message is a response to a previously sent message.
        if (isGeneratedMessage(type) && this.pendingMessages_.has(messageId)) {
            this.handleMessageResponse_(type, message, messageId);
            return;
        }
        if (isGeneratedMessage(type)) {
            // Currently all generated messages are only sent in a response, so should
            // have been handled above.
            console.error(`Response with type ${type} for unknown message received.`);
            return;
        }
        if (!this.messageHandlers_.has(type)) {
            // If there is no listener for this event send a error message to source.
            const error = new Error(`No handler registered for message type '${type}'`);
            const errorResponse = serializeError(error);
            this.postToTarget_(ERROR_TYPE, errorResponse, messageId);
            return;
        }
        this.callHandlerForMessageType_(type, message, messageId);
    }
    postToTarget_(messageType, message, messageId) {
        const messageWrapper = {
            messageId,
            type: messageType,
            message: message || {},
        };
        // The next line should probably be passing a transfer argument, but that
        // causes Chrome to send a "null" message. The transfer seems to work
        // without the third argument (but inefficiently, perhaps).
        this.target_.postMessage(messageWrapper, this.targetOrigin_);
    }
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const PRODUCT_NAME = 'ChromeOS_MediaApp';
/**
 * Handles reporting errors creating a new Error() to get a stacktrace. If > 1
 * arguments are provided, builds up the error message using the other [1, n-1]
 * errors and appends that to the first error.
 */
function reportCrashError(...errors) {
    if (errors.length === 0) {
        return;
    }
    // Build up the error message using errors[1, n-1].
    let message = '';
    for (let i = 1; i < errors.length; i++) {
        const errorArg = errors[i];
        if (errorArg !== undefined) {
            if (errorArg instanceof Error) {
                message += `\n${errorArg.name}: ${errorArg.message}`;
            }
            else if (typeof errorArg === 'string') {
                message += ', ' + errorArg;
            }
            else {
                try {
                    message += '\n' + JSON.stringify(errorArg);
                }
                catch (e) {
                    message += '<object loop?>';
                }
            }
        }
    }
    // Base the error on the first error.
    let firstError = errors[0];
    let errorObject = undefined;
    let errorMessage;
    let prefix = '';
    // Parse out the reason for the error.
    if (firstError instanceof PromiseRejectionEvent) {
        prefix = 'Unhandled rejection: ';
        firstError = firstError.reason;
    }
    else if (typeof firstError === 'object' && firstError !== null &&
        firstError.constructor) {
        prefix = firstError.constructor.name + ': ';
    }
    const maybeError = firstError;
    if (firstError instanceof Error || firstError instanceof ErrorEvent ||
        firstError instanceof DOMException) {
        // Note: `ErrorEvent` doesn't have a name field, `DOMException`s are routed
        // through 'onerror' and treated as `ErrorEvents`, we can also have
        // `DOMExceptions` inside a unhandled rejection.
        errorMessage = `[${maybeError.name ?? ''}] ${firstError.message}`;
        errorObject = maybeError;
        // Events and exceptions won't have stacks. Make one.
        if (!errorObject?.stack) {
            errorObject.stack = new Error().stack;
        }
    }
    else {
        // Should just be a regular object.
        try {
            errorMessage = `Unexpected: ${JSON.stringify(firstError)}`;
        }
        catch (e) {
            errorMessage = `Unexpected: <object loop?>`;
        }
    }
    if (!errorObject) {
        // Create a new error to get a stacktrace.
        errorObject = new Error();
    }
    const params = {
        product: PRODUCT_NAME,
        url: self.location.href,
        message: prefix + errorMessage + message,
        lineNumber: errorObject?.lineNumber || 0,
        stackTrace: errorObject?.stack || '',
        columnNumber: errorObject?.columnNumber || 0,
    };
    // TODO(crbug.com/40641337): Add useful callback when the error is reported,
    // handle if it crashes while reporting an error.
    chrome.crashReportPrivate.reportError(params, () => { });
}
/**
 * Redirect calls to `console.error` to also call `report` so we can report
 * console.errors. Pass `realConsoleError` into this so we can mock it out for
 * testing.
 */
function captureConsoleErrors(realConsoleError, report) {
    console.error = (...errors) => {
        // Still call real console.error.
        realConsoleError(...errors);
        // Send to error reporter.
        report(...errors, '(from console)');
    };
}
captureConsoleErrors(console.error, reportCrashError);
window.addEventListener('error', reportCrashError);
window.addEventListener('unhandledrejection', reportCrashError);
const TEST_ONLY$1 = {
    reportCrashError,
    captureConsoleErrors,
};

var error_reporter = /*#__PURE__*/Object.freeze({
  __proto__: null,
  TEST_ONLY: TEST_ONLY$1
});

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * Message definitions passed over the MediaApp privileged/unprivileged pipe.
 */
/** Enum for message types. */
var Message;
(function (Message) {
    Message["DELETE_FILE"] = "delete-file";
    Message["EDIT_IN_PHOTOS"] = "edit-in-photos";
    Message["IFRAME_READY"] = "iframe-ready";
    Message["IS_FILE_ARC_WRITABLE"] = "is-file-arc-writable";
    Message["IS_FILE_BROWSER_WRITABLE"] = "is-file-browser-writable";
    Message["LOAD_EXTRA_FILES"] = "load-extra-files";
    Message["LOAD_FILES"] = "load-files";
    Message["MAYBE_TRIGGER_PDF_HATS"] = "maybe-trigger-pdf-hats";
    Message["NAVIGATE"] = "navigate";
    Message["NOTIFY_CURRENT_FILE"] = "notify-current-file";
    Message["OPEN_ALLOWED_FILE"] = "open-allowed-file";
    Message["OPEN_FEEDBACK_DIALOG"] = "open-feedback-dialog";
    Message["OPEN_FILES_WITH_PICKER"] = "open-files-with-picker";
    Message["OPEN_IN_SANDBOXED_VIEWER"] = "open-in-sandboxed-viewer";
    Message["OVERWRITE_FILE"] = "overwrite-file";
    Message["RELOAD_MAIN_FRAME"] = "reload-main-frame";
    Message["RENAME_FILE"] = "rename-file";
    Message["REQUEST_SAVE_FILE"] = "request-save-file";
    Message["SAVE_AS"] = "save-as";
    Message["SUBMIT_FORM"] = "submit-form";
    Message["TOGGLE_BROWSER_FULLSCREEN_MODE"] = "toggle-browser-fullscreen-mode";
})(Message || (Message = {}));
/** Enum for results of renaming a file. */
var RenameResult;
(function (RenameResult) {
    RenameResult[RenameResult["FILE_NO_LONGER_IN_LAST_OPENED_DIRECTORY"] = -1] = "FILE_NO_LONGER_IN_LAST_OPENED_DIRECTORY";
    RenameResult[RenameResult["SUCCESS"] = 0] = "SUCCESS";
    RenameResult[RenameResult["FILE_EXISTS"] = 1] = "FILE_EXISTS";
})(RenameResult || (RenameResult = {}));

// ash/webui/media_app_ui/media_app_ui.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit



mojo.internal.exportModule('ash.mediaAppUi.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.mediaAppUi.mojom.PageHandlerFactoryPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.mediaAppUi.mojom.PageHandlerFactory.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.mediaAppUi.mojom.PageHandlerFactoryInterface }
 */
ash.mediaAppUi.mojom.PageHandlerFactoryRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.mediaAppUi.mojom.PageHandlerFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.mediaAppUi.mojom.PageHandlerFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.mediaAppUi.mojom.PageHandlerFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ash.mediaAppUi.mojom.PageHandlerPendingReceiver } handler
   */

  createPageHandler(
      handler) {
    this.proxy.sendMessage(
        0,
        ash.mediaAppUi.mojom.PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.mediaAppUi.mojom.PageHandlerFactoryReceiver = class {
  /**
   * @param {!ash.mediaAppUi.mojom.PageHandlerFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.mediaAppUi.mojom.PageHandlerFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.mediaAppUi.mojom.PageHandlerFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.mediaAppUi.mojom.PageHandlerFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.mediaAppUi.mojom.PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.mediaAppUi.mojom.PageHandlerFactory = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.media_app_ui.mojom.PageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.mediaAppUi.mojom.PageHandlerFactoryRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.mediaAppUi.mojom.PageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.mediaAppUi.mojom.PageHandlerFactoryCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.mediaAppUi.mojom.PageHandlerFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.mediaAppUi.mojom.PageHandlerFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.mediaAppUi.mojom.PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ash.mediaAppUi.mojom.PageHandlerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ash.mediaAppUi.mojom.PageHandler.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { ash.mediaAppUi.mojom.PageHandlerInterface }
 */
ash.mediaAppUi.mojom.PageHandlerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ash.mediaAppUi.mojom.PageHandlerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ash.mediaAppUi.mojom.PageHandlerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ash.mediaAppUi.mojom.PageHandlerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        errorMessage: ?string,
   *  }>}
   */

  openFeedbackDialog() {
    return this.proxy.sendMessage(
        0,
        ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  toggleBrowserFullscreenMode() {
    return this.proxy.sendMessage(
        1,
        ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  maybeTriggerPdfHats() {
    return this.proxy.sendMessage(
        2,
        ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } token
   * @return {!Promise<{
        writable: !boolean,
   *  }>}
   */

  isFileArcWritable(
      token) {
    return this.proxy.sendMessage(
        3,
        ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ResponseParamsSpec.$,
        [
          token
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } token
   * @return {!Promise<{
        writable: !boolean,
   *  }>}
   */

  isFileBrowserWritable(
      token) {
    return this.proxy.sendMessage(
        4,
        ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ResponseParamsSpec.$,
        [
          token
        ],
        false);
  }

  
  /**
   * @param { !blink.mojom.FileSystemAccessTransferTokenRemote } token
   * @param { !string } mimeType
   * @return {!Promise}
   */

  editInPhotos(
      token,
      mimeType) {
    return this.proxy.sendMessage(
        5,
        ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ResponseParamsSpec.$,
        [
          token,
          mimeType
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } url
   * @param { !Array<!number> } payload
   * @param { !string } header
   * @return {!Promise}
   */

  submitForm(
      url,
      payload,
      header) {
    return this.proxy.sendMessage(
        6,
        ash.mediaAppUi.mojom.PageHandler_SubmitForm_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_SubmitForm_ResponseParamsSpec.$,
        [
          url,
          payload,
          header
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ash.mediaAppUi.mojom.PageHandlerReceiver = class {
  /**
   * @param {!ash.mediaAppUi.mojom.PageHandlerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ash.mediaAppUi.mojom.PageHandlerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ash.mediaAppUi.mojom.PageHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.mediaAppUi.mojom.PageHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$,
        impl.openFeedbackDialog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ResponseParamsSpec.$,
        impl.toggleBrowserFullscreenMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ResponseParamsSpec.$,
        impl.maybeTriggerPdfHats.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ResponseParamsSpec.$,
        impl.isFileArcWritable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ResponseParamsSpec.$,
        impl.isFileBrowserWritable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ResponseParamsSpec.$,
        impl.editInPhotos.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ash.mediaAppUi.mojom.PageHandler_SubmitForm_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_SubmitForm_ResponseParamsSpec.$,
        impl.submitForm.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ash.mediaAppUi.mojom.PageHandler = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ash.media_app_ui.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ash.mediaAppUi.mojom.PageHandlerRemote}
   * @export
   */
  static getRemote() {
    let remote = new ash.mediaAppUi.mojom.PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ash.mediaAppUi.mojom.PageHandlerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ash.mediaAppUi.mojom.PageHandlerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ash.mediaAppUi.mojom.PageHandlerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openFeedbackDialog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$,
        this.openFeedbackDialog.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.toggleBrowserFullscreenMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ResponseParamsSpec.$,
        this.toggleBrowserFullscreenMode.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.maybeTriggerPdfHats =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ResponseParamsSpec.$,
        this.maybeTriggerPdfHats.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isFileArcWritable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ResponseParamsSpec.$,
        this.isFileArcWritable.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isFileBrowserWritable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ResponseParamsSpec.$,
        this.isFileBrowserWritable.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.editInPhotos =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ResponseParamsSpec.$,
        this.editInPhotos.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.submitForm =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ash.mediaAppUi.mojom.PageHandler_SubmitForm_ParamsSpec.$,
        ash.mediaAppUi.mojom.PageHandler_SubmitForm_ResponseParamsSpec.$,
        this.submitForm.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandlerFactory_CreatePageHandler_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_SubmitForm_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ash.mediaAppUi.mojom.PageHandler_SubmitForm_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'PageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField(
        'handler', 0,
        0,
        mojo.internal.InterfaceRequest(ash.mediaAppUi.mojom.PageHandlerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.mediaAppUi.mojom.PageHandlerFactory_CreatePageHandler_Params = class {
  constructor() {
    /** @export { !ash.mediaAppUi.mojom.PageHandlerPendingReceiver } */
    this.handler;
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ParamsSpec.$,
    'PageHandler_OpenFeedbackDialog_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ResponseParamsSpec.$,
    'PageHandler_OpenFeedbackDialog_ResponseParams',
    [
      mojo.internal.StructField(
        'errorMessage', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_OpenFeedbackDialog_ResponseParams = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.errorMessage;
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ParamsSpec.$,
    'PageHandler_ToggleBrowserFullscreenMode_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ResponseParamsSpec.$,
    'PageHandler_ToggleBrowserFullscreenMode_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_ToggleBrowserFullscreenMode_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ParamsSpec.$,
    'PageHandler_MaybeTriggerPdfHats_Params',
    [
    ],
    [[0, 8],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ResponseParamsSpec.$,
    'PageHandler_MaybeTriggerPdfHats_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_MaybeTriggerPdfHats_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ParamsSpec.$,
    'PageHandler_IsFileArcWritable_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessTransferTokenRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessTransferTokenRemote } */
    this.token;
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ResponseParamsSpec.$,
    'PageHandler_IsFileArcWritable_ResponseParams',
    [
      mojo.internal.StructField(
        'writable', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_IsFileArcWritable_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.writable;
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ParamsSpec.$,
    'PageHandler_IsFileBrowserWritable_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessTransferTokenRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessTransferTokenRemote } */
    this.token;
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ResponseParamsSpec.$,
    'PageHandler_IsFileBrowserWritable_ResponseParams',
    [
      mojo.internal.StructField(
        'writable', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_IsFileBrowserWritable_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.writable;
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ParamsSpec.$,
    'PageHandler_EditInPhotos_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.FileSystemAccessTransferTokenRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mimeType', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_EditInPhotos_Params = class {
  constructor() {
    /** @export { !blink.mojom.FileSystemAccessTransferTokenRemote } */
    this.token;
    /** @export { !string } */
    this.mimeType;
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ResponseParamsSpec.$,
    'PageHandler_EditInPhotos_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_EditInPhotos_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_SubmitForm_ParamsSpec.$,
    'PageHandler_SubmitForm_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'payload', 8,
        0,
        mojo.internal.Array(mojo.internal.Int8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'header', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_SubmitForm_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.url;
    /** @export { !Array<!number> } */
    this.payload;
    /** @export { !string } */
    this.header;
  }
};



mojo.internal.Struct(
    ash.mediaAppUi.mojom.PageHandler_SubmitForm_ResponseParamsSpec.$,
    'PageHandler_SubmitForm_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
ash.mediaAppUi.mojom.PageHandler_SubmitForm_ResponseParams = class {
  constructor() {
  }
};

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.


const mediaAppPageHandler = new ash.mediaAppUi.mojom.PageHandlerRemote();

// Set up a page handler to talk to the browser process.
ash.mediaAppUi.mojom.PageHandlerFactory.getRemote().createPageHandler(
    mediaAppPageHandler.$.bindNewPipeAndPassReceiver());

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Support code running in the released app to facilitate
 * testing. This file is present in the real app (not just tests), so it should
 * only be used for coverage of tests cases that can not be injected by the
 * test framework.
 */
// Event handlers for tests in MediaAppIntegrationTest for testing crash report
// integration. These can't be injected because errors on lines of injected code
// do not go to the error handlers installed on window in the real app context.
window.addEventListener('simulate-type-error-for-test', event => {
    event.notAFunction();
});
window.addEventListener('simulate-unhandled-rejection-for-test', _event => {
    new Promise(_resolve => {
        const error = new Error('fake_throw');
        error.name = 'FakeErrorName';
        throw error;
    });
});
window.addEventListener('simulate-unhandled-rejection-with-dom-exception-for-test', _event => {
    new Promise(_resolve => {
        throw new DOMException('Not a file.', 'NotAFile');
    });
});

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const DEFAULT_APP_ICON = 'app';
const EMPTY_WRITE_ERROR_NAME = 'EmptyWriteError';
// Open file picker configurations. Should be kept in sync with launch handler
// configurations in media_web_app_info.cc.
const AUDIO_EXTENSIONS = ['.flac', '.m4a', '.mp3', '.oga', '.ogg', '.opus', '.wav', '.weba', '.m4a'];
const IMAGE_EXTENSIONS = [
    '.jpg', '.png', '.webp', '.gif', '.avif', '.bmp', '.ico', '.svg',
    '.jpeg', '.jpe', '.jfif', '.jif', '.jfi', '.pjpeg', '.pjp', '.arw',
    '.cr2', '.dng', '.nef', '.nrw', '.orf', '.raf', '.rw2', '.svgz',
];
const VIDEO_EXTENSIONS = [
    '.3gp',
    '.avi',
    '.m4v',
    '.mkv',
    '.mov',
    '.mp4',
    '.mpeg',
    '.mpeg4',
    '.mpg',
    '.mpg4',
    '.ogv',
    '.ogx',
    '.ogm',
    '.webm',
];
const PDF_EXTENSIONS = ['.pdf'];
const OPEN_ACCEPT_ARGS = {
    'AUDIO': {
        description: loadTimeData.getString('fileFilterAudio'),
        accept: { 'audio/*': AUDIO_EXTENSIONS },
    },
    'IMAGE': {
        description: loadTimeData.getString('fileFilterImage'),
        accept: { 'image/*': IMAGE_EXTENSIONS },
    },
    'VIDEO': {
        description: loadTimeData.getString('fileFilterVideo'),
        accept: { 'video/*': VIDEO_EXTENSIONS },
    },
    'PDF': { description: 'PDF', accept: { 'application/pdf': PDF_EXTENSIONS } },
    // All supported file types, excluding text files (see b/183150750).
    'ALL_EX_TEXT': {
        description: 'All',
        accept: {
            '*/*': [
                ...AUDIO_EXTENSIONS,
                ...IMAGE_EXTENSIONS,
                ...VIDEO_EXTENSIONS,
                ...PDF_EXTENSIONS,
            ],
        },
    },
};
/**
 * Sort order for files in the navigation ring.
 */
var SortOrder;
(function (SortOrder) {
    /**
     * Lexicographic (with natural number ordering): advancing goes "down" the
     * alphabet.
     */
    SortOrder[SortOrder["A_FIRST"] = 1] = "A_FIRST";
    /**
     * Reverse lexicographic (with natural number ordering): advancing goes "up"
     * the alphabet.
     */
    SortOrder[SortOrder["Z_FIRST"] = 2] = "Z_FIRST";
    /** By modified time: pressing "right" goes to older files. */
    SortOrder[SortOrder["NEWEST_FIRST"] = 3] = "NEWEST_FIRST";
})(SortOrder || (SortOrder = {}));
/**
 * Array of entries available in the current directory.
 */
const currentFiles = [];
/**
 * A variable for storing the name of the app, taken from the <title>. We store
 * it here since we mutate the title to show filename, but may want to restore
 * it in some circumstances i.e. returning to zero state.
 */
let appTitle;
/**
 * The current sort order.
 * TODO(crbug.com/40384768): Match the file manager order when launched that way.
 * Note currently this is reassigned in tests.
 */
let sortOrder = SortOrder.A_FIRST;
/**
 * Index into `currentFiles` of the current file.
 */
let entryIndex = -1;
/**
 * Keeps track of the current launch (i.e. call to `launchWithDirectory`) .
 * Since file loading can be deferred i.e. we can load the first focused file
 * and start using the app then load other files in `loadOtherRelatedFiles()` we
 * need to make sure `loadOtherRelatedFiles` gets aborted if it is out of date
 * i.e. in interleaved launches.
 */
let globalLaunchNumber = -1;
/**
 * Reference to the directory handle that contains the first file in the most
 * recent launch event.
 */
let currentDirectoryHandle = null;
/**
 * Map of file tokens. Persists across new launch requests from the file
 * manager when chrome://media-app has not been closed.
 */
const tokenMap = new Map();
/**
 * A pipe through which we can send messages to the guest frame.
 * Use an undefined `target` to find the <iframe> automatically.
 * Do not rethrow errors, since handlers installed here are expected to
 * throw exceptions that are handled on the other side of the pipe. And
 * nothing `awaits` async callHandlerForMessageType_(), so they will always
 * be reported as `unhandledrejection` and trigger a crash report.
 */
const guestMessagePipe = new MessagePipe('chrome-untrusted://media-app', undefined, false);
// Register a handler for the "IFRAME_READY" message which does nothing. This
// prevents MessagePipe emitting an error that there is no handler for it. The
// message is handled by logic in first_message_received.js, which installs the
// event listener before the <iframe> is added to the DOM.
guestMessagePipe.registerHandler(Message.IFRAME_READY, () => { });
/**
 * The type of icon to show for this app's window.
 */
let appIconType = DEFAULT_APP_ICON;
/**
 * Sets the app icon depending on the icon type and color theme.
 * @param mediaQueryList Determines whether or not the icon should be in dark
 *     mode.
 */
function updateAppIcon(mediaQueryList) {
    // The default app icon does not have a separate dark variant.
    const isDark = mediaQueryList.matches && appIconType !== DEFAULT_APP_ICON ? '_dark' : '';
    const icon = document.querySelector('link[rel=icon]');
    icon.href = `system_assets/${appIconType}_icon${isDark}.svg`;
}
const darkMediaQuery = window.matchMedia('(prefers-color-scheme: dark)');
guestMessagePipe.registerHandler(Message.NOTIFY_CURRENT_FILE, (message) => {
    const notifyMsg = message;
    const title = document.querySelector('title');
    appTitle = appTitle || title.text;
    title.text = notifyMsg.name || appTitle;
    appIconType = notifyMsg.type ? notifyMsg.type.split('/')[0] : 'file';
    if (title.text === appTitle) {
        appIconType = DEFAULT_APP_ICON;
    }
    else if (notifyMsg.type === 'application/pdf') {
        appIconType = 'pdf';
    }
    else if (!['audio', 'image', 'video', 'file'].includes(appIconType)) {
        appIconType = 'file';
    }
    updateAppIcon(darkMediaQuery);
});
darkMediaQuery.addEventListener('change', updateAppIcon);
guestMessagePipe.registerHandler(Message.OPEN_FEEDBACK_DIALOG, () => {
    let response = mediaAppPageHandler.openFeedbackDialog();
    if (response === null) {
        response = { errorMessage: 'Null response received' };
    }
    return response;
});
guestMessagePipe.registerHandler(Message.TOGGLE_BROWSER_FULLSCREEN_MODE, () => {
    mediaAppPageHandler.toggleBrowserFullscreenMode();
});
guestMessagePipe.registerHandler(Message.OPEN_IN_SANDBOXED_VIEWER, (message) => {
    window.open(`./viewpdfhost.html?${new URLSearchParams(message)}`, '_blank', 'popup=1');
});
guestMessagePipe.registerHandler(Message.RELOAD_MAIN_FRAME, () => {
    window.location.reload();
});
guestMessagePipe.registerHandler(Message.MAYBE_TRIGGER_PDF_HATS, () => {
    mediaAppPageHandler.maybeTriggerPdfHats();
});
guestMessagePipe.registerHandler(Message.EDIT_IN_PHOTOS, (message) => {
    const editInPhotosMsg = message;
    const fileHandle = fileHandleForToken(editInPhotosMsg.token);
    const transferToken = new blink.mojom.FileSystemAccessTransferTokenRemote(Mojo.getFileSystemAccessTransferToken(fileHandle));
    return mediaAppPageHandler.editInPhotos(transferToken, editInPhotosMsg.mimeType);
});
guestMessagePipe.registerHandler(Message.IS_FILE_ARC_WRITABLE, (message) => {
    const writableMsg = message;
    const fileHandle = fileHandleForToken(writableMsg.token);
    const transferToken = new blink.mojom.FileSystemAccessTransferTokenRemote(Mojo.getFileSystemAccessTransferToken(fileHandle));
    return mediaAppPageHandler.isFileArcWritable(transferToken);
});
guestMessagePipe.registerHandler(Message.IS_FILE_BROWSER_WRITABLE, (message) => {
    const writableMsg = message;
    const fileHandle = fileHandleForToken(writableMsg.token);
    const transferToken = new blink.mojom.FileSystemAccessTransferTokenRemote(Mojo.getFileSystemAccessTransferToken(fileHandle));
    return mediaAppPageHandler.isFileBrowserWritable(transferToken);
});
guestMessagePipe.registerHandler(Message.OVERWRITE_FILE, async (message) => {
    const overwrite = message;
    const originalHandle = fileHandleForToken(overwrite.token);
    try {
        await saveBlobToFile(originalHandle, overwrite.blob);
    }
    catch (e) {
        if (e.name === EMPTY_WRITE_ERROR_NAME) {
            throw e;
        }
        // TODO(b/160843424): Collect UMA.
        console.warn('Showing a picker due to', e);
        return pickFileForFailedOverwrite(originalHandle.name, e.name, overwrite);
    }
});
guestMessagePipe.registerHandler(Message.SUBMIT_FORM, async (message) => {
    mediaAppPageHandler.submitForm({ url: message.url }, message.payload, message.header);
});
/**
 * Shows a file picker and redirects a failed OverwriteFileMessage to the chosen
 * file. Updates app state and rebinds file tokens if the write is successful.
 */
async function pickFileForFailedOverwrite(fileName, errorName, overwrite) {
    const fileHandle = await pickWritableFile(fileName, overwrite.blob.type, overwrite.token, []);
    await saveBlobToFile(fileHandle, overwrite.blob);
    // Success. Replace the old handle.
    tokenMap.set(overwrite.token, fileHandle);
    const entry = currentFiles.find(i => i.token === overwrite.token);
    if (entry) {
        entry.handle = fileHandle;
    }
    return { renamedTo: fileHandle.name, errorName };
}
guestMessagePipe.registerHandler(Message.DELETE_FILE, async (message) => {
    const deleteMsg = message;
    const { handle, directory } = assertFileAndDirectoryMutable(deleteMsg.token, 'Delete');
    if (!(await isHandleInCurrentDirectory(handle))) {
        // removeEntry() silently "succeeds" in this case, but that gives poor UX.
        console.warn(`"${handle.name}" not found in the last opened folder.`);
        const error = new Error('Ignoring delete request: file not found');
        error.name = 'NotFoundError';
        throw error;
    }
    await directory.removeEntry(handle.name);
    // Remove the file that was deleted.
    currentFiles.splice(entryIndex, 1);
    // Attempts to load the file to the right which is at now at
    // `currentFiles[entryIndex]`, where `entryIndex` was previously the index of
    // the deleted file.
    await advance(0);
});
/** Handler to rename the currently focused file. */
guestMessagePipe.registerHandler(Message.RENAME_FILE, async (message) => {
    const renameMsg = message;
    const { handle, directory } = assertFileAndDirectoryMutable(renameMsg.token, 'Rename');
    if (await filenameExistsInCurrentDirectory(renameMsg.newFilename)) {
        return { renameResult: RenameResult.FILE_EXISTS };
    }
    const originalFile = await maybeGetFileFromFileHandle(handle);
    let originalFileIndex = currentFiles.findIndex(fd => fd.token === renameMsg.token);
    if (!originalFile || originalFileIndex < 0) {
        return { renameResult: RenameResult.FILE_NO_LONGER_IN_LAST_OPENED_DIRECTORY };
    }
    const renamedFileHandle = await directory.getFileHandle(renameMsg.newFilename, { create: true });
    // Copy file data over to the new file.
    const writer = await renamedFileHandle.createWritable();
    const sink = writer;
    const source = originalFile;
    await source.stream().pipeTo(sink);
    // Remove the old file since the new file has all the data & the new name.
    // Note even though removing an entry that doesn't exist is considered
    // success, we first check `handle` is the same as the handle for the file
    // with that filename in the `currentDirectoryHandle`.
    if (await isHandleInCurrentDirectory(handle)) {
        await directory.removeEntry(originalFile.name);
    }
    // Replace the old file in our internal representation. There is no harm using
    // the old file's token since the old file is removed.
    tokenMap.set(renameMsg.token, renamedFileHandle);
    // Remove the entry for `originalFile` in current files, replace it with a
    // FileDescriptor for the renamed file.
    // Ensure the file is still in `currentFiles` after all the above `awaits`. If
    // missing it means either new files have loaded (or tried to), see
    // b/164985809.
    originalFileIndex =
        currentFiles.findIndex(fd => fd.token === renameMsg.token);
    if (originalFileIndex < 0) {
        // Can't navigate to the renamed file so don't add it to `currentFiles`.
        return { renameResult: RenameResult.SUCCESS };
    }
    currentFiles.splice(originalFileIndex, 1, {
        token: renameMsg.token,
        file: null,
        handle: renamedFileHandle,
        inCurrentDirectory: true,
    });
    return { renameResult: RenameResult.SUCCESS };
});
guestMessagePipe.registerHandler(Message.NAVIGATE, async (message) => {
    const navigate = message;
    await advance(navigate.direction, navigate.currentFileToken);
});
guestMessagePipe.registerHandler(Message.REQUEST_SAVE_FILE, async (message) => {
    const { suggestedName, mimeType, startInToken, accept } = message;
    const handle = await pickWritableFile(suggestedName, mimeType, startInToken, accept);
    const response = {
        pickedFileContext: {
            token: generateToken(handle),
            file: assertCast(await handle.getFile()),
            name: handle.name,
            error: '',
            canDelete: false,
            canRename: false,
        },
    };
    return response;
});
guestMessagePipe.registerHandler(Message.SAVE_AS, async (message) => {
    const { blob, oldFileToken, pickedFileToken } = message;
    const oldFileDescriptor = currentFiles.find(fd => fd.token === oldFileToken);
    const pickedHandle = assertCast(tokenMap.get(pickedFileToken));
    const pickedFileDescriptor = {
        // We silently take over the old file's file descriptor by taking its token,
        // note we can be passed an undefined token if the file we are saving was
        // dragged into the media app.
        token: oldFileToken || tokenGenerator.next().value,
        file: null,
        handle: pickedHandle,
    };
    const oldFileIndex = currentFiles.findIndex(fd => fd.token === oldFileToken);
    tokenMap.set(pickedFileDescriptor.token, pickedHandle);
    // Give the old file a new token, if we couldn't find the old file we assume
    // its been deleted (or pasted/dragged into the media app) and skip this
    // step.
    if (oldFileDescriptor) {
        oldFileDescriptor.token = generateToken(oldFileDescriptor.handle);
    }
    try {
        // Note `pickedFileHandle` could be the same as a `FileSystemFileHandle`
        // that exists in `tokenMap`. Possibly even the `File` currently open. But
        // that's OK. E.g. the next overwrite-file request will just invoke
        // `saveBlobToFile` in the same way.
        await saveBlobToFile(pickedHandle, blob);
    }
    catch (e) {
        // If something went wrong revert the token back to its original
        // owner so future file actions function correctly.
        if (oldFileDescriptor && oldFileToken) {
            oldFileDescriptor.token = oldFileToken;
            tokenMap.set(oldFileToken, oldFileDescriptor.handle);
        }
        throw e;
    }
    // Note: oldFileIndex may be `-1` here which causes the new file to be added
    // to the start of the array, this is WAI.
    currentFiles.splice(oldFileIndex + 1, 0, pickedFileDescriptor);
    // Silently update entry index without triggering a reload of the media app.
    entryIndex = oldFileIndex + 1;
    const response = { newFilename: pickedHandle.name };
    return response;
});
guestMessagePipe.registerHandler(Message.OPEN_FILES_WITH_PICKER, async (m) => {
    const { startInToken, accept, isSingleFile } = m;
    const acceptTypes = accept.map(k => OPEN_ACCEPT_ARGS[k]).filter(a => !!a);
    const options = { multiple: !isSingleFile };
    if (startInToken) {
        options.startIn = fileHandleForToken(startInToken);
    }
    if (acceptTypes.length > 0) {
        options.excludeAcceptAllOption = true;
        options.types = acceptTypes;
    }
    const handles = await window.showOpenFilePicker(options);
    const newDescriptors = [];
    for (const handle of handles) {
        newDescriptors.push({
            token: generateToken(handle),
            file: null,
            handle: handle,
            inCurrentDirectory: false,
        });
    }
    if (newDescriptors.length === 0) {
        // Be defensive against the file picker returning an empty array rather than
        // throwing an abort exception. Or any filtering we may introduce.
        return;
    }
    // Perform a full "relaunch": replace everything and set focus to index 0.
    currentFiles.splice(0, currentFiles.length, ...newDescriptors);
    entryIndex = 0;
    await sendSnapshotToGuest([...currentFiles], ++globalLaunchNumber);
});
guestMessagePipe.registerHandler(Message.OPEN_ALLOWED_FILE, async (message) => {
    const { fileToken } = message;
    const handle = fileHandleForToken(fileToken);
    const response = { file: (await getFileFromHandle(handle)).file };
    return response;
});
/**
 * Shows a file picker to get a writable file.
 */
function pickWritableFile(suggestedName, mimeType, startInToken, accept) {
    const JPG_EXTENSIONS = ['.jpg', '.jpeg', '.jpe', '.jfif', '.jif', '.jfi', '.pjpeg', '.pjp'];
    const ACCEPT_ARGS = {
        'JPG': { description: 'JPG', accept: { 'image/jpeg': JPG_EXTENSIONS } },
        'PNG': { description: 'PNG', accept: { 'image/png': ['.png'] } },
        'WEBP': { description: 'WEBP', accept: { 'image/webp': ['.webp'] } },
        'PDF': { description: 'PDF', accept: { 'application/pdf': ['.pdf'] } },
    };
    const acceptTypes = accept.map(k => ACCEPT_ARGS[k]).filter(a => !!a);
    const options = {
        suggestedName,
    };
    if (startInToken) {
        options.startIn = fileHandleForToken(startInToken);
    }
    if (acceptTypes.length > 0) {
        options.excludeAcceptAllOption = true;
        options.types = acceptTypes;
    }
    else {
        // Search for the mimeType, and add a single entry. If none is found, the
        // file picker is left "unconfigured"; with just "all files".
        for (const a of Object.values(ACCEPT_ARGS)) {
            if (a.accept[mimeType]) {
                options.excludeAcceptAllOption = true;
                options.types = [a];
            }
        }
    }
    // This may throw an error, but we can handle and recover from it on the
    // unprivileged side.
    return window.showSaveFilePicker(options);
}
/**
 * Generator instance for unguessable tokens.
 */
const tokenGenerator = (function* () {
    // To use the regular number type, tokens must stay below
    // Number.MAX_SAFE_INTEGER (2^53). So stick with ~33 bits. Note we can not
    // request more than 64kBytes from crypto.getRandomValues() at a time.
    const randomBuffer = new Uint32Array(1000);
    while (true) {
        assertCast(crypto).getRandomValues(randomBuffer);
        for (let i = 0; i < randomBuffer.length; ++i) {
            const token = randomBuffer[i];
            // Disallow "0" as a token.
            if (token && !tokenMap.has(token)) {
                yield Number(token);
            }
        }
    }
})();
/**
 * Generate a file token, and persist the mapping to `handle`.
 */
function generateToken(handle) {
    const token = tokenGenerator.next().value;
    tokenMap.set(token, handle);
    return token;
}
/**
 * Return the mimetype of a file given it's filename. Returns null if the
 * mimetype could not be determined or if the file does not have a extension.
 * TODO(b/178986064): Remove this once we have a file system access metadata
 * api.
 */
function getMimeTypeFromFilename(filename) {
    // This file extension to mime type map is adapted from
    // https://source.chromium.org/chromium/chromium/src/+/main:net/base/mime_util.cc;l=147;drc=51373c4ea13372d7711c59d9929b0be5d468633e
    const mapping = {
        'avif': 'image/avif',
        'crx': 'application/x-chrome-extension',
        'css': 'text/css',
        'flac': 'audio/flac',
        'gif': 'image/gif',
        'htm': 'text/html',
        'html': 'text/html',
        'jpeg': 'image/jpeg',
        'jpg': 'image/jpeg',
        'js': 'text/javascript',
        'm4a': 'audio/x-m4a',
        'm4v': 'video/mp4',
        'mht': 'multipart/related',
        'mhtml': 'multipart/related',
        'mjs': 'text/javascript',
        'mp3': 'audio/mpeg',
        'mp4': 'video/mp4',
        'oga': 'audio/ogg',
        'ogg': 'audio/ogg',
        'ogm': 'video/ogg',
        'ogv': 'video/ogg',
        'opus': 'audio/ogg',
        'png': 'image/png',
        'shtm': 'text/html',
        'shtml': 'text/html',
        'wasm': 'application/wasm',
        'wav': 'audio/wav',
        'webm': 'video/webm',
        'webp': 'image/webp',
        'xht': 'application/xhtml+xml',
        'xhtm': 'application/xhtml+xml',
        'xhtml': 'application/xhtml+xml',
        'xml': 'text/xml',
        'epub': 'application/epub+zip',
        'woff': 'application/font-woff',
        'gz': 'application/gzip',
        'tgz': 'application/gzip',
        'json': 'application/json',
        'bin': 'application/octet-stream',
        'exe': 'application/octet-stream',
        'com': 'application/octet-stream',
        'pdf': 'application/pdf',
        'p7m': 'application/pkcs7-mime',
        'p7c': 'application/pkcs7-mime',
        'p7z': 'application/pkcs7-mime',
        'p7s': 'application/pkcs7-signature',
        'ps': 'application/postscript',
        'eps': 'application/postscript',
        'ai': 'application/postscript',
        'rdf': 'application/rdf+xml',
        'rss': 'application/rss+xml',
        'apk': 'application/vnd.android.package-archive',
        'xul': 'application/vnd.mozilla.xul+xml',
        'xls': 'application/vnd.ms-excel',
        'xlsx': 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
        'zip': 'application/zip',
        'weba': 'audio/webm',
        'bmp': 'image/bmp',
        'jfif': 'image/jpeg',
        'pjpeg': 'image/jpeg',
        'pjp': 'image/jpeg',
        'svg': 'image/svg+xml',
        'svgz': 'image/svg+xml',
        'tiff': 'image/tiff',
        'tif': 'image/tiff',
        'ico': 'image/vnd.microsoft.icon',
        'eml': 'message/rfc822',
        'ics': 'text/calendar',
        'ehtml': 'text/html',
        'txt': 'text/plain',
        'text': 'text/plain',
        'sh': 'text/x-sh',
        'xsl': 'text/xml',
        'xbl': 'text/xml',
        'xslt': 'text/xml',
        'mpeg': 'video/mpeg',
        'mpg': 'video/mpeg',
        // Add more video file types. These are not web-supported types, but are
        // supported on ChromeOS, and have file handlers in media_web_app_info.cc.
        'mkv': 'video/x-matroska',
        '3gp': 'video/3gpp',
        'mov': 'video/quicktime',
        'avi': 'video/x-msvideo',
        'mpeg4': 'video/mp4',
        'mpg4': 'video/mp4',
    };
    const fileParts = filename.split('.');
    if (fileParts.length < 2) {
        return null;
    }
    const extension = fileParts[fileParts.length - 1].toLowerCase();
    const mimeType = mapping[extension];
    return mimeType !== undefined ? mimeType : null;
}
/**
 * Returns the `FileSystemFileHandle` for the given `token`. This is
 * "guaranteed" to succeed: tokens are only generated once a file handle has
 * been successfully opened at least once (and determined to be "related"). The
 * handle doesn't expire, but file system operations may fail later on.
 * One corner case, however, is when the initial file open fails and the token
 * gets replaced by `-1`. File operations all need to fail in that case.
 */
function fileHandleForToken(token) {
    const handle = tokenMap.get(token);
    if (!handle) {
        throw new DOMException(`No handle for token(${token})`, 'NotFoundError');
    }
    return handle;
}
/**
 * Saves the provided blob the provided fileHandle. Assumes the handle is
 * writable.
 */
async function saveBlobToFile(handle, data) {
    if (data.size === 0) {
        // Bugs or error states in the app could cause an unexpected write of zero
        // bytes to a file, which could cause data loss. Reject it here.
        const error = new Error('saveBlobToFile(): Refusing to write zero bytes.');
        error.name = EMPTY_WRITE_ERROR_NAME;
        throw error;
    }
    const writer = await handle.createWritable();
    await writer.write(data);
    await writer.truncate(data.size);
    await writer.close();
}
/**
 * Warns if a given exception is "uncommon". That is, one that the guest might
 * not provide UX for and should be dumped to console to give additional
 * context.
 */
function warnIfUncommon(e, fileName) {
    // Errors we expect to be thrown in normal operation.
    const commonErrors = ['NotFoundError', 'NotAllowedError', 'NotAFile'];
    if (commonErrors.includes(e.name)) {
        return;
    }
    console.warn(`Unexpected ${e.name} on ${fileName}: ${e.message}`);
}
/**
 * If `fd.file` is null, re-opens the file handle in `fd`.
 */
async function refreshFile(fd) {
    if (fd.file) {
        return;
    }
    fd.lastError = '';
    try {
        fd.file = (await getFileFromHandle(fd.handle)).file;
    }
    catch (e) {
        fd.lastError = e.name;
        // A failure here is only a problem for the "current" file (and that needs
        // to be handled in the unprivileged context), so ignore known errors.
        warnIfUncommon(e, fd.handle.name);
    }
}
/**
 * Loads the current file list into the guest.
 */
async function sendFilesToGuest() {
    return sendSnapshotToGuest([...currentFiles], globalLaunchNumber); // Shallow copy.
}
/**
 * Converts a file descriptor from `currentFiles` into a `FileContext` used by
 * the LoadFilesMessage. Closure forgets that some fields may be missing without
 * naming the type explicitly on the signature here.
 */
function fileDescriptorToFileContext(fd) {
    // TODO(b/163285659): Properly detect files that can't be renamed/deleted.
    return {
        token: fd.token,
        file: fd.file,
        name: fd.handle.name,
        error: fd.lastError || '',
        canDelete: fd.inCurrentDirectory || false,
        canRename: fd.inCurrentDirectory || false,
    };
}
/**
 * Loads the provided file list into the guest.
 * Note: code paths can defer loads i.e. `launchWithDirectory()` increment
 * `globalLaunchNumber` to ensure their deferred load is still relevant when it
 * finishes processing. Other code paths that call `sendSnapshotToGuest()` don't
 * have to.
 */
async function sendSnapshotToGuest(snapshot, localLaunchNumber, extraFiles = false) {
    const focusIndex = entryIndex;
    // Attempt to reopen the focus file only. In future we might also open
    // "nearby" files for preloading. However, reopening *all* files on every
    // navigation attempt to verify they can still be navigated to adds noticeable
    // lag in large directories.
    let targetIndex = -1;
    if (focusIndex >= 0 && focusIndex < snapshot.length) {
        targetIndex = focusIndex;
    }
    else if (snapshot.length !== 0) {
        targetIndex = 0;
    }
    if (targetIndex >= 0) {
        const descriptor = snapshot[targetIndex];
        await refreshFile(descriptor);
        await refreshLoadRequiredAssociatedFiles(snapshot, descriptor.handle.name, extraFiles);
        if (extraFiles) {
            snapshot.shift();
        }
    }
    if (localLaunchNumber !== globalLaunchNumber) {
        return;
    }
    const loadFilesMessage = {
        currentFileIndex: focusIndex,
        // Handle can't be passed through a message pipe.
        files: snapshot.map(fileDescriptorToFileContext),
    };
    // Clear handles to the open files in the privileged context so they are
    // refreshed on a navigation request. The refcount to the File will be alive
    // in the postMessage object until the guest takes its own reference.
    for (const fd of snapshot) {
        fd.file = null;
    }
    // Wait for the signal from first_message_received.js before proceeding.
    await window.firstMessageReceived;
    if (extraFiles) {
        await guestMessagePipe.sendMessage(Message.LOAD_EXTRA_FILES, loadFilesMessage);
    }
    else {
        await guestMessagePipe.sendMessage(Message.LOAD_FILES, loadFilesMessage);
    }
}
/**
 * Throws an error if the file or directory handles don't exist or the token for
 * the file to be mutated is incorrect.
 */
function assertFileAndDirectoryMutable(editFileToken, operation) {
    if (!currentDirectoryHandle) {
        throw new Error(`${operation} failed. File without launch directory.`);
    }
    return {
        handle: fileHandleForToken(editFileToken),
        directory: currentDirectoryHandle,
    };
}
/**
 * Returns whether `handle` is in `currentDirectoryHandle`. Prevents mutating a
 * file that doesn't exist.
 */
async function isHandleInCurrentDirectory(handle) {
    const file = await maybeGetFileFromFileHandle(handle);
    // If we were unable to get a file from the handle it must not be in the
    // current directory anymore.
    if (!file) {
        return false;
    }
    // It's unclear if getFile will always give us a NotFoundError if the file has
    // been moved as it's not explicitly stated in the File System Access API
    // spec. As such we perform an additional check here to make sure the file
    // returned by the handle is in fact in the current directory.
    // TODO(b/172628918): Remove this once we have more assurances getFile() does
    // the right thing.
    const currentFilename = file.name;
    const fileHandle = await getFileHandleFromCurrentDirectory(currentFilename);
    return fileHandle ? fileHandle.isSameEntry(handle) : false;
}
/**
 * Returns if a`filename` exists in `currentDirectoryHandle`.
 */
async function filenameExistsInCurrentDirectory(filename) {
    return (await getFileHandleFromCurrentDirectory(filename, true)) !== null;
}
/**
 * Returns the `FileSystemFileHandle` for `filename` if it exists in the current
 * directory, otherwise null.
 */
async function getFileHandleFromCurrentDirectory(filename, suppressError = false) {
    if (!currentDirectoryHandle) {
        return null;
    }
    try {
        return (await currentDirectoryHandle.getFileHandle(filename, { create: false }));
    }
    catch (e) {
        if (!suppressError) {
            // Some filenames (e.g. "thumbs.db") can't be opened (or deleted) by
            // filename. TypeError doesn't give a good error message in the app, so
            // convert to a new Error.
            if (e.name === 'TypeError' &&
                e.message ===
                    'Failed to execute \'getFileHandle\' on ' +
                        '\'FileSystemDirectoryHandle\': Name is not allowed.') {
                console.warn(e); // Warn so a crash report is not generated.
                throw new DOMException('File has a reserved name and can not be opened', 'InvalidModificationError');
            }
            console.error(e);
        }
        return null;
    }
}
/**
 * Gets a file from a handle received via the fileHandling API. Only handles
 * expected to be files should be passed to this function. Throws a DOMException
 * if opening the file fails - usually because the handle is stale.
 */
async function getFileFromHandle(fileSystemHandle) {
    if (!fileSystemHandle || fileSystemHandle.kind !== 'file') {
        // Invent our own exception for this corner case. It might happen if a file
        // is deleted and replaced with a directory with the same name.
        throw new DOMException('Not a file.', 'NotAFile');
    }
    const handle = fileSystemHandle;
    const file = await handle.getFile(); // Note: throws DOMException.
    return { file, handle };
}
/**
 * Calls getFile on `handle` and gracefully returns null if it encounters a
 * NotFoundError, which can happen if the file is no longer in the current
 * directory due to being moved or deleted.
 */
async function maybeGetFileFromFileHandle(handle) {
    let file;
    try {
        file = await handle.getFile();
    }
    catch (e) {
        // NotFoundError can be thrown if `handle` is no longer in the directory we
        // have access to.
        if (e.name === 'NotFoundError') {
            file = null;
        }
        else {
            // Any other error is unexpected.
            throw e;
        }
    }
    return file;
}
/**
 * Returns whether `fileName` is a file potentially containing subtitles.
 */
function isSubtitleFile(fileName) {
    return /\.vtt$/.test(fileName.toLowerCase());
}
/**
 * Returns whether `fileName` is a file likely to be a video.
 */
function isVideoFile(fileName) {
    return /^video\//.test(getMimeTypeFromFilename(fileName) ?? '');
}
/**
 * Returns whether `fileName` is a file likely to be an image.
 */
function isImageFile(fileName) {
    // Detect RAW images, which often don't have a mime type set.
    return /\.(arw|cr2|dng|nef|nrw|orf|raf|rw2)$/.test(fileName.toLowerCase()) ||
        /^image\//.test(getMimeTypeFromFilename(fileName) ?? '');
}
/**
 * Returns whether `fileName` is a file likely to be audio.
 */
function isAudioFile(fileName) {
    return /^audio\//.test(getMimeTypeFromFilename(fileName) ?? '');
}
/**
 * Returns whether fileName is the filename for a video or image, or a related
 * file type (e.g. video subtitles).
 */
function isVideoOrImage(fileName) {
    return isImageFile(fileName) || isVideoFile(fileName) ||
        isSubtitleFile(fileName);
}
/**
 * Returns whether `siblingFile` is related to `focusFile`. That is, whether
 * they should be traversable from one another. Usually this means they share a
 * similar (non-empty) MIME type.
 * @param focusFile The file selected by the user.
 * @param siblingFileName Filename for a file in the same directory as
 *     `focusFile`.
 */
function isFileRelated(focusFile, siblingFileName) {
    const siblingFileType = getMimeTypeFromFilename(siblingFileName);
    return focusFile.name === siblingFileName ||
        (!!focusFile.type && !!siblingFileType &&
            focusFile.type === siblingFileType) ||
        (isVideoOrImage(focusFile.name) && isVideoOrImage(siblingFileName));
}
/**
 * Enum like return value of `processOtherFilesInDirectory()`.
 */
var ProcessOtherFilesResult;
(function (ProcessOtherFilesResult) {
    // Newer load in progress, can abort loading these files.
    ProcessOtherFilesResult[ProcessOtherFilesResult["ABORT"] = -2] = "ABORT";
    // The focusFile is missing, treat this as a normal load.
    ProcessOtherFilesResult[ProcessOtherFilesResult["FOCUS_FILE_MISSING"] = -1] = "FOCUS_FILE_MISSING";
    // The focusFile is present, load these files as extra files.
    ProcessOtherFilesResult[ProcessOtherFilesResult["FOCUS_FILE_RELEVANT"] = 0] = "FOCUS_FILE_RELEVANT";
})(ProcessOtherFilesResult || (ProcessOtherFilesResult = {}));
/**
 * Loads related files the working directory to initialize file iteration
 * according to the type of the opened file. If `globalLaunchNumber` changes
 * (i.e. another launch occurs), this will abort early and not change
 * `currentFiles`.
 */
async function processOtherFilesInDirectory(directory, focusFile, localLaunchNumber) {
    if (!focusFile || !focusFile.name) {
        return ProcessOtherFilesResult.ABORT;
    }
    let relatedFiles = [];
    // TODO(b/158149714): Clear out old tokens as well? Care needs to be taken to
    // ensure any file currently open with unsaved changes can still be saved.
    try {
        for await (const handle of directory.values()) {
            if (localLaunchNumber !== globalLaunchNumber) {
                // Abort, another more up to date launch in progress.
                return ProcessOtherFilesResult.ABORT;
            }
            if (handle.kind !== 'file') {
                continue;
            }
            const fileHandle = handle;
            // Only allow traversal of related file types.
            if (isFileRelated(focusFile, handle.name)) {
                // Note: The focus file will be processed here again but will be skipped
                // over when added to `currentFiles`.
                relatedFiles.push({
                    token: generateToken(fileHandle),
                    // This will get populated by refreshFile before the file gets opened.
                    file: null,
                    handle: fileHandle,
                    inCurrentDirectory: true,
                });
            }
        }
    }
    catch (e) {
        console.warn(e, '(failed to traverse directory)');
        // It's unlikely traversal can "resume", but try to continue with anything
        // obtained so far.
    }
    if (currentFiles.length > 1) {
        // Related files identified as required for the initial load must be removed
        // so they don't appear in the file list twice.
        const atLoadCurrentFiles = currentFiles.slice(1);
        relatedFiles = relatedFiles.filter(f => !atLoadCurrentFiles.find(c => c.handle.name === f.handle.name));
    }
    if (localLaunchNumber !== globalLaunchNumber) {
        return ProcessOtherFilesResult.ABORT;
    }
    await sortFiles(relatedFiles);
    const name = focusFile.name;
    const focusIndex = relatedFiles.findIndex(i => i.handle.name === name);
    entryIndex = 0;
    if (focusIndex === -1) {
        // The focus file is no longer there i.e. might have been deleted, should be
        // missing from `currentFiles` as well.
        currentFiles.push(...relatedFiles);
        return ProcessOtherFilesResult.FOCUS_FILE_MISSING;
    }
    else {
        // Rotate the sorted files so focusIndex becomes index 0 such that we have
        // [focus file, ...files larger, ...files smaller].
        currentFiles.push(...relatedFiles.slice(focusIndex + 1));
        currentFiles.push(...relatedFiles.slice(0, focusIndex));
        return ProcessOtherFilesResult.FOCUS_FILE_RELEVANT;
    }
}
/**
 * Sorts the given `files` by `sortOrder`.
 */
async function sortFiles(files) {
    if (sortOrder === SortOrder.NEWEST_FIRST) {
        // If we are sorting by modification time we need to have the actual File
        // object available.
        for (const descriptor of files) {
            // TODO(b/166210455): Remove this call to getFile as it may be slow for
            // android files see b/172529567. Leaving it in at the moment since sort
            // order is not set to NEWEST_FIRST in any production release and there is
            // no way to get modified time without calling getFile.
            try {
                descriptor.file = (await getFileFromHandle(descriptor.handle)).file;
            }
            catch (e) {
                warnIfUncommon(e, descriptor.handle.name);
            }
        }
    }
    // Iteration order is not guaranteed using `directory.entries()`, so we
    // sort it afterwards by modification time to ensure a consistent and logical
    // order. More recent (i.e. higher timestamp) files should appear first. In
    // the case where timestamps are equal, the files will be sorted
    // lexicographically according to their names.
    files.sort((a, b) => {
        if (sortOrder === SortOrder.NEWEST_FIRST) {
            // Sort null files last if they racily appear.
            if (!a.file && !b.file) {
                return 0;
            }
            else if (!b.file) {
                return -1;
            }
            else if (!a.file) {
                return 1;
            }
            else if (a.file.lastModified === b.file.lastModified) {
                return a.file.name.localeCompare(b.file.name);
            }
            return b.file.lastModified - a.file.lastModified;
        }
        // Else default to lexicographical sort.
        // Match the Intl.Collator params used for sorting in the files app in
        // file_manager/common/js/util.js.
        const direction = sortOrder === SortOrder.A_FIRST ? 1 : -1;
        return direction *
            a.handle.name.localeCompare(b.handle.name, [], { usage: 'sort', numeric: true, sensitivity: 'base' });
    });
}
/**
 * Loads related files in the working directory and sends them to the guest. If
 * the focus file (currentFiles[0]) is no longer relevant i.e. is has been
 * deleted, we load files as usual.
 */
async function loadOtherRelatedFiles(directory, focusFile, _focusHandle, localLaunchNumber) {
    const processResult = await processOtherFilesInDirectory(directory, focusFile, localLaunchNumber);
    if (localLaunchNumber !== globalLaunchNumber ||
        processResult === ProcessOtherFilesResult.ABORT) {
        return;
    }
    const shallowCopy = [...currentFiles];
    // If the focus file is no longer relevant, loads files as normal.
    await sendSnapshotToGuest(shallowCopy, localLaunchNumber, processResult === ProcessOtherFilesResult.FOCUS_FILE_RELEVANT);
}
/**
 * Sets state for the files opened in the current directory.
 */
function setCurrentDirectory(directory, focusFile) {
    // Load currentFiles into the guest.
    currentFiles.length = 0;
    currentFiles.push({
        token: generateToken(focusFile.handle),
        file: focusFile.file,
        handle: focusFile.handle,
        inCurrentDirectory: true,
    });
    currentDirectoryHandle = directory;
    entryIndex = 0;
}
/**
 * Returns a filename associated with `focusFileName` that may be required to
 * properly load the file. The file might not exist.
 * TODO(b/175099007): Support multiple associated files.
 */
function requiredAssociatedFileName(focusFileName) {
    // Subtitles must be identified for the initial load to be properly attached.
    if (!isVideoFile(focusFileName)) {
        return '';
    }
    // To match the video player app, just look for `.vtt` until alternative
    // heuristics are added inside the app layer. See b/175099007.
    return focusFileName.replace(/\.[^\.]+$/, '.vtt');
}
/**
 * Adds file handles for associated files to the set of launch files.
 */
async function detectLoadRequiredAssociatedFiles(directory, focusFileName) {
    const vttFileName = requiredAssociatedFileName(focusFileName);
    if (!vttFileName) {
        return;
    }
    try {
        const vttFileHandle = await directory.getFileHandle(vttFileName);
        currentFiles.push({
            token: generateToken(vttFileHandle),
            file: null, // Will be set by `refreshLoadRequiredAssociatedFiles()`.
            handle: vttFileHandle,
            inCurrentDirectory: true,
        });
    }
    catch (e) {
        // Do nothing if not found or not permitted.
    }
}
/**
 * Refreshes the File object for all file handles associated with the focus
 * file.
 */
async function refreshLoadRequiredAssociatedFiles(snapshot, focusFileName, forExtraFilesMessage) {
    const vttFileName = requiredAssociatedFileName(focusFileName);
    if (!vttFileName) {
        return;
    }
    const index = snapshot.findIndex(d => d.handle.name === vttFileName);
    if (index >= 0) {
        await refreshFile(snapshot[index]);
        // In the extra files message, it's necessary to remove the vtt file from
        // the snapshot to avoid it being added again in the receiver.
        if (forExtraFilesMessage) {
            snapshot.splice(index, 1);
        }
    }
}
/**
 * Launch the media app with the files in the provided directory, using `handle`
 * as the initial launch entry.
 */
async function launchWithDirectory(directory, handle) {
    const localLaunchNumber = ++globalLaunchNumber;
    let asFile;
    try {
        asFile = await getFileFromHandle(handle);
    }
    catch (e) {
        console.warn(`${handle.name}: ${e.message}`);
        sendSnapshotToGuest([{
                token: -1,
                file: null,
                handle: handle,
                lastError: e.name,
            }], localLaunchNumber);
        return;
    }
    // Load currentFiles into the guest.
    setCurrentDirectory(directory, asFile);
    await detectLoadRequiredAssociatedFiles(directory, handle.name);
    await sendSnapshotToGuest([...currentFiles], localLaunchNumber);
    // The app is operable with the first file now.
    // Process other files in directory.
    // TODO(https://github.com/WICG/file-system-access/issues/215): Don't process
    // other files if there is only 1 file which is already loaded by
    // `sendSnapshotToGuest()` above.
    await loadOtherRelatedFiles(directory, asFile.file, asFile.handle, localLaunchNumber);
}
/**
 * Launch the media app with the selected files.
 */
async function launchWithMultipleSelection(directory, handles) {
    currentFiles.length = 0;
    for (const handle of handles) {
        if (handle && handle.kind === 'file') {
            const fileHandle = handle;
            currentFiles.push({
                token: generateToken(fileHandle),
                file: null, // Just let sendSnapshotToGuest() "refresh" it.
                handle: fileHandle,
                // TODO(b/163285659): Enable delete/rename for multi-select files.
            });
        }
    }
    await sortFiles(currentFiles);
    entryIndex = currentFiles.length > 0 ? 0 : -1;
    currentDirectoryHandle = directory;
    await sendFilesToGuest();
}
/**
 * Advance to another file.
 *
 * @param direction How far to advance (e.g. +/-1).
 * @param currentFileToken The token of the file that
 *     direction is in reference to. If unprovided it's assumed that
 *     currentFiles[entryIndex] is the current file.
 */
async function advance(direction, currentFileToken) {
    let currIndex = entryIndex;
    if (currentFileToken) {
        const fileIndex = currentFiles.findIndex(fd => fd.token === currentFileToken);
        currIndex = fileIndex === -1 ? currIndex : fileIndex;
    }
    if (currentFiles.length) {
        entryIndex = (currIndex + direction) % currentFiles.length;
        if (entryIndex < 0) {
            entryIndex += currentFiles.length;
        }
    }
    else {
        entryIndex = -1;
    }
    await sendFilesToGuest();
}
/**
 * The launchQueue consumer. This returns a promise to help tests, but the file
 * handling API will ignore it.
 */
async function launchConsumer(params) {
    // The MediaApp sets `include_launch_directory = true` in its SystemAppInfo
    // struct compiled into Chrome. That means files[0] is guaranteed to be a
    // directory, with remaining launch files following it. Validate that this is
    // true and abort the launch if is is not.
    if (!params || !params.files || params.files.length < 2) {
        console.error('Invalid launch (missing files): ', params);
        return;
    }
    if (assertCast(params.files[0]).kind !== 'directory') {
        console.error('Invalid launch: files[0] is not a directory: ', params);
        return;
    }
    const directory = params.files[0];
    // With a single file selected, that file is the focus file. Otherwise, there
    // is no inherent focus file.
    const maybeFocusEntry = assertCast(params.files[1]);
    // With a single file selected, launch with all files in the directory as
    // navigation candidates. Otherwise, launch with all selected files (except
    // the launch directory itself) as navigation candidates. The only exception
    // to this is audio files, which we explicitly don't load the directory for.
    if (params.files.length === 2 && !isAudioFile(maybeFocusEntry.name)) {
        try {
            await launchWithDirectory(directory, maybeFocusEntry);
        }
        catch (e) {
            console.error(e, '(launchWithDirectory aborted)');
        }
    }
    else {
        try {
            await launchWithMultipleSelection(directory, params.files.slice(1));
        }
        catch (e) {
            console.error(e, '(launchWithMultipleSelection aborted)');
        }
    }
}
/**
 * Wrapper for the launch consumer to ensure it doesn't return a Promise, nor
 * propagate exceptions. Tests will want to target `launchConsumer` directly so
 * that they can properly await launch results.
 */
function wrappedLaunchConsumer(params) {
    launchConsumer(params).catch(e => {
        console.error(e, '(launch aborted)');
    });
}
/**
 * Installs the handler for launch files, if window.launchQueue is available.
 */
function installLaunchHandler() {
    if (!window.launchQueue) {
        console.error('FileHandling API missing.');
        return;
    }
    window.launchQueue.setConsumer(wrappedLaunchConsumer);
}
installLaunchHandler();
// Make sure the guest frame has focus.
const guest = assertCast(document.querySelector('iframe[src^="chrome-untrusted://media-app"]'));
guest.addEventListener('load', () => {
    guest.focus();
});
const TEST_ONLY = {
    Message,
    SortOrder,
    advance,
    currentDirectoryHandle,
    currentFiles,
    fileHandleForToken,
    globalLaunchNumber,
    guestMessagePipe,
    launchConsumer,
    launchWithDirectory,
    loadOtherRelatedFiles,
    pickWritableFile,
    processOtherFilesInDirectory,
    sendFilesToGuest,
    setCurrentDirectory,
    sortOrder,
    tokenGenerator,
    tokenMap,
    mediaAppPageHandler,
    error_reporter,
    getGlobalLaunchNumber: () => globalLaunchNumber,
    incrementLaunchNumber: () => ++globalLaunchNumber,
    setCurrentDirectoryHandle: (d) => {
        currentDirectoryHandle = d;
    },
    setSortOrder: (s) => {
        sortOrder = s;
    },
    getEntryIndex: () => entryIndex,
    setEntryIndex: (i) => {
        entryIndex = i;
    },
};
// Expose `advance()` for MediaAppIntegrationTest.FileOpenCanTraverseDirectory.
window['advance'] = advance;

export { TEST_ONLY };
//# sourceMappingURL=launch.rollup.js.map
