// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let PiexModule;const initPiexModule=globalThis.createPiexModule;console.info(`[PiexLoader] available [init=${typeof initPiexModule}]`);let piexFailed=false;const MODULE_SETTINGS={onAbort:error=>{piexFailed=true;throw error}};let initPiexModulePromise=null;function piexModuleInitialized(){if(!initPiexModulePromise){initPiexModulePromise=new Promise((resolve=>{initPiexModule(MODULE_SETTINGS).then((module=>{PiexModule=module;console.info(`[PiexLoader] loaded [module=${typeof module}]`);resolve()}))}))}return initPiexModulePromise}function piexModuleFailed(){if(piexFailed||!PiexModule.calledRun){console.error("[PiexLoader] piex wasm module failed");return true}return false}class PiexLoaderResponse{thumbnail;mimeType;orientation;colorSpace;ifd;constructor(data){this.thumbnail=data.thumbnail;this.mimeType=data.mimeType||"image/jpeg";this.orientation=data.orientation;this.colorSpace=data.colorSpace;this.ifd=data.ifd||null}}const adobeProfile=new Uint8Array([255,226,2,64,73,67,67,95,80,82,79,70,73,76,69,0,1,1,0,0,2,48,65,68,66,69,2,16,0,0,109,110,116,114,82,71,66,32,88,89,90,32,7,208,0,8,0,11,0,19,0,51,0,59,97,99,115,112,65,80,80,76,0,0,0,0,110,111,110,101,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,246,214,0,1,0,0,0,0,211,45,65,68,66,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,99,112,114,116,0,0,0,252,0,0,0,50,100,101,115,99,0,0,1,48,0,0,0,107,119,116,112,116,0,0,1,156,0,0,0,20,98,107,112,116,0,0,1,176,0,0,0,20,114,84,82,67,0,0,1,196,0,0,0,14,103,84,82,67,0,0,1,212,0,0,0,14,98,84,82,67,0,0,1,228,0,0,0,14,114,88,89,90,0,0,1,244,0,0,0,20,103,88,89,90,0,0,2,8,0,0,0,20,98,88,89,90,0,0,2,28,0,0,0,20,116,101,120,116,0,0,0,0,67,111,112,121,114,105,103,104,116,32,50,48,48,48,32,65,100,111,98,101,32,83,121,115,116,101,109,115,32,73,110,99,111,114,112,111,114,97,116,101,100,0,0,0,100,101,115,99,0,0,0,0,0,0,0,17,65,100,111,98,101,32,82,71,66,32,40,49,57,57,56,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,89,90,32,0,0,0,0,0,0,243,81,0,1,0,0,0,1,22,204,88,89,90,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,99,117,114,118,0,0,0,0,0,0,0,1,2,51,0,0,99,117,114,118,0,0,0,0,0,0,0,1,2,51,0,0,99,117,114,118,0,0,0,0,0,0,0,1,2,51,0,0,88,89,90,32,0,0,0,0,0,0,156,24,0,0,79,165,0,0,4,252,88,89,90,32,0,0,0,0,0,0,52,141,0,0,160,44,0,0,15,149,88,89,90,32,0,0,0,0,0,0,38,49,0,0,16,47,0,0,190,156]);class ImageBuffer{source;length;memory=0;constructor(buffer){this.source=new Uint8Array(buffer);this.length=buffer.byteLength}process(){this.memory=PiexModule._malloc(this.length);if(!this.memory){throw new Error("Image malloc failed: "+this.length+" bytes")}PiexModule.HEAP8.set(this.source,this.memory);const result=PiexModule.image(this.memory,this.length);if(result.error){throw new Error(result.error)}return result}preview(result){const preview=result.preview;if(!preview){return this.thumbnail_(result)}const offset=preview.offset;const length=preview.length;if(offset>this.length||this.length-offset<length){throw new Error("Preview image access failed")}const view=new Uint8Array(this.source.buffer,offset,length);return{thumbnail:this.createImageDataArray_(view,preview).buffer,mimeType:"image/jpeg",ifd:this.details_(result,preview.orientation),orientation:preview.orientation,colorSpace:preview.colorSpace}}thumbnail_(result){const thumbnail=result.thumbnail;if(!thumbnail){return{thumbnail:new ArrayBuffer(0),colorSpace:"sRgb",orientation:1,ifd:null}}if(thumbnail.format){return this.rgb_(result)}const offset=thumbnail.offset;const length=thumbnail.length;if(offset>this.length||this.length-offset<length){throw new Error("Thumbnail image access failed")}const view=new Uint8Array(this.source.buffer,offset,length);return{thumbnail:this.createImageDataArray_(view,thumbnail).buffer,mimeType:"image/jpeg",ifd:this.details_(result,thumbnail.orientation),orientation:thumbnail.orientation,colorSpace:thumbnail.colorSpace}}rgb_(result){const thumbnail=result.thumbnail;if(!thumbnail||thumbnail.format!==1){return{thumbnail:new ArrayBuffer(0),colorSpace:"sRgb",orientation:1,ifd:null}}if(!thumbnail.width||!thumbnail.height){throw new Error("invalid image width or height")}const offset=thumbnail.offset;const length=thumbnail.length;if(offset>this.length||this.length-offset<length){throw new Error("Thumbnail image access failed")}const view=new Uint8Array(this.source.buffer,offset,length);const usesWidthAsHeight=thumbnail.orientation>=5;const height=usesWidthAsHeight?thumbnail.width:thumbnail.height;const width=usesWidthAsHeight?thumbnail.height:thumbnail.width;const rowPad=width&3;const rowStride=3*width+rowPad;const pixelDataOffset=14+108;const fileSize=pixelDataOffset+rowStride*height;const bitmap=new DataView(new ArrayBuffer(fileSize));bitmap.setUint8(0,"B".charCodeAt(0));bitmap.setUint8(1,"M".charCodeAt(0));bitmap.setUint32(2,fileSize,true);bitmap.setUint32(6,0,true);bitmap.setUint32(10,pixelDataOffset,true);bitmap.setUint32(14,108,true);bitmap.setInt32(18,width,true);bitmap.setInt32(22,-height,true);bitmap.setInt16(26,1,true);bitmap.setInt16(28,24,true);bitmap.setUint32(30,0,true);bitmap.setUint32(34,0,true);bitmap.setInt32(38,0,true);bitmap.setInt32(42,0,true);bitmap.setUint32(46,0,true);bitmap.setUint32(50,0,true);bitmap.setUint32(54,0,true);bitmap.setUint32(58,0,true);bitmap.setUint32(62,0,true);bitmap.setUint32(66,0,true);let rx=0;let ry=0;let gx=0;let gy=0;let bx=0;let by=0;let zz=0;let gg=0;if(thumbnail.colorSpace!=="adobeRgb"){bitmap.setUint8(70,"s".charCodeAt(0));bitmap.setUint8(71,"R".charCodeAt(0));bitmap.setUint8(72,"G".charCodeAt(0));bitmap.setUint8(73,"B".charCodeAt(0))}else{bitmap.setUint32(70,0);rx=Math.round(.64*(1<<30));ry=Math.round(.33*(1<<30));gx=Math.round(.21*(1<<30));gy=Math.round(.71*(1<<30));bx=Math.round(.15*(1<<30));by=Math.round(.06*(1<<30));zz=Math.round(1*(1<<30));gg=Math.round(2.1992187*(1<<16))}bitmap.setUint32(74,rx,true);bitmap.setUint32(78,ry,true);bitmap.setUint32(82,zz,true);bitmap.setUint32(86,gx,true);bitmap.setUint32(90,gy,true);bitmap.setUint32(94,zz,true);bitmap.setUint32(98,bx,true);bitmap.setUint32(102,by,true);bitmap.setUint32(106,zz,true);bitmap.setUint32(110,gg,true);bitmap.setUint32(114,gg,true);bitmap.setUint32(118,gg,true);const h=thumbnail.height-1;const w=thumbnail.width-1;let dx=0;for(let input=0,y=0;y<=h;++y){let output=pixelDataOffset;switch(thumbnail.orientation){case 1:output+=y*rowStride;dx=3;break;case 2:output+=y*rowStride+3*w;dx=-3;break;case 3:output+=(h-y)*rowStride+3*w;dx=-3;break;case 4:output+=(h-y)*rowStride;dx=3;break;case 5:output+=3*y;dx=rowStride;break;case 6:output+=3*(h-y);dx=rowStride;break;case 7:output+=w*rowStride+3*(h-y);dx=-rowStride;break;case 8:output+=w*rowStride+3*y;dx=-rowStride;break}for(let x=0;x<=w;++x,input+=3,output+=dx){bitmap.setUint8(output+0,view[input+2]);bitmap.setUint8(output+1,view[input+1]);bitmap.setUint8(output+2,view[input+0])}}if(rowPad){let paddingOffset=pixelDataOffset+3*width;for(let y=0;y<height;++y){let output=paddingOffset;switch(rowPad){case 1:bitmap.setUint8(output++,0);break;case 2:bitmap.setUint8(output++,0);bitmap.setUint8(output++,0);break;case 3:bitmap.setUint8(output++,0);bitmap.setUint8(output++,0);bitmap.setUint8(output++,0);break}paddingOffset+=rowStride}}return{thumbnail:bitmap.buffer,mimeType:"image/bmp",ifd:this.details_(result,thumbnail.orientation),colorSpace:thumbnail.colorSpace,orientation:1}}createImageDataArray_(view,preview){const jpeg=view.byteLength>2&&view[0]===255&&view[1]===216;if(jpeg&&preview.colorSpace==="adobeRgb"){const data=new Uint8Array(view.byteLength+adobeProfile.byteLength);data.set(view.subarray(2),2+adobeProfile.byteLength);data.set(adobeProfile,2);data.set([255,216],0);return data}return new Uint8Array(view)}details_(result,orientation){const details=result.details;if(!details){return null}const format={};for(const[key,value]of Object.entries(details)){if(typeof value==="string"){format[key]=value.replace(/\0+$/,"").trim()}else if(typeof value==="number"){if(!Number.isInteger(value)){format[key]=Number(value.toFixed(3).replace(/0+$/,""))}else{format[key]=value}}}const usesWidthAsHeight=orientation>=5;if(usesWidthAsHeight){const width=format["width"];format["width"]=format["height"];format["height"]=width}return JSON.stringify(format)}close(){const memory=this.memory;if(memory){PiexModule._free(memory);this.memory=0}}}const PiexLoader={load(buffer,onPiexModuleFailed){let imageBuffer;return piexModuleInitialized().then((()=>{if(piexModuleFailed()){throw new Error("piex wasm module failed")}imageBuffer=new ImageBuffer(buffer);return imageBuffer.process()})).then((result=>new PiexLoaderResponse(imageBuffer.preview(result)))).catch((error=>{if(piexModuleFailed()){setTimeout(onPiexModuleFailed,0);return Promise.reject("piex wasm module failed")}console.warn("[PiexLoader] "+error);return Promise.reject(error)})).finally((()=>{imageBuffer&&imageBuffer.close()}))}};const PIEX_LOADER_TEST_ONLY={getModule:()=>PiexModule};let piexEnabled=true;function onPiexModuleFailed(){piexEnabled=false}const SIZEOF_APP1_PREFIX=8;const SIZEOF_TIFF_HEADER=8;const SIZEOF_SINGLE_IFD_FRAME=18;const NUM_IFD_FRAMES=1;const SIZEOF_APP1_HEADER=SIZEOF_APP1_PREFIX+SIZEOF_TIFF_HEADER+NUM_IFD_FRAMES*SIZEOF_SINGLE_IFD_FRAME;const TIFF_HEADER=new Uint8Array([255,216,255,225,SIZEOF_APP1_HEADER>>8,SIZEOF_APP1_HEADER&255,69,120,105,102,0,0,73,73,42,0,8,0,0,0]);function makeOrientationIfdFrame(value){const LITTLE_ENDIAN=true;const TAG_ORIENTATION=274;const TYPE_UINT16=3;const FIELD_COUNT=1;const VALUE_LENGTH=1;const NEXT_OFFSET=0;const buffer=new ArrayBuffer(SIZEOF_SINGLE_IFD_FRAME);const view=new DataView(buffer);view.setUint16(0,FIELD_COUNT,LITTLE_ENDIAN);view.setUint16(2,TAG_ORIENTATION,LITTLE_ENDIAN);view.setUint16(4,TYPE_UINT16,LITTLE_ENDIAN);view.setUint32(6,VALUE_LENGTH,LITTLE_ENDIAN);view.setUint16(10,value,LITTLE_ENDIAN);view.setUint32(14,NEXT_OFFSET,LITTLE_ENDIAN);return buffer}async function extractFromRawImageBuffer(buffer){const APP1_MARKER=65505;const START_OF_IMAGE=65496;const NO_ROTATION=1;if(!piexEnabled){throw new Error("Piex disabled")}const response=await PiexLoader.load(buffer,onPiexModuleFailed);const jpegData=response.thumbnail;function original(warning=""){if(warning){console.warn(`Returning unrotated image: ${warning}.`)}return new File([jpegData],"raw-preview",{type:response.mimeType})}if(response.orientation===NO_ROTATION){return original()}const view=new DataView(jpegData);if(view.getUint16(0)!==START_OF_IMAGE){return original("No SOI")}if(view.getUint16(2)===APP1_MARKER){return original("APP1 marker already present")}const jpegWithoutSOI=new Blob([jpegData]).slice(2);const orientation=makeOrientationIfdFrame(response.orientation);return new File([TIFF_HEADER,orientation,jpegWithoutSOI],"raw-preview",{type:response.mimeType})}window.extractFromRawImageBuffer=extractFromRawImageBuffer;window.getPiexModuleForTesting=PIEX_LOADER_TEST_ONLY.getModule;