// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";const impl={data_:{},set data(value){impl.data_=value},getValue:id=>impl.data_[id],getString:id=>impl.data_[id],getBoolean:id=>impl.data_[id],getInteger:id=>impl.data_[id],valueExists:id=>impl.data_[id]!==undefined};window["loadTimeData"]=impl;function assert(value,message){if(value){return}throw new Error("Assertion failed"+"")}class PageHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"color_change_listener.mojom.PageHandler",scope)}}class PageHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}setPage(page){this.proxy.sendMessage(0,PageHandler_SetPage_ParamsSpec.$,null,[page],false)}}class PageHandler{static get $interfaceName(){return"color_change_listener.mojom.PageHandler"}static getRemote(){let remote=new PageHandlerRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}class PagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"color_change_listener.mojom.Page",scope)}}class PageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onColorProviderChanged(){this.proxy.sendMessage(0,Page_OnColorProviderChanged_ParamsSpec.$,null,[],false)}}class PageCallbackRouter{helper_internal_;$;router_;onColorProviderChanged;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onColorProviderChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,Page_OnColorProviderChanged_ParamsSpec.$,null,this.onColorProviderChanged.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}const PageHandler_SetPage_ParamsSpec={$:{}};const Page_OnColorProviderChanged_ParamsSpec={$:{}};mojo.internal.Struct(PageHandler_SetPage_ParamsSpec.$,"PageHandler_SetPage_Params",[mojo.internal.StructField("page",0,0,mojo.internal.InterfaceProxy(PageRemote),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Page_OnColorProviderChanged_ParamsSpec.$,"Page_OnColorProviderChanged_Params",[],[[0,8]]);let instance=null;class BrowserProxy{callbackRouter;constructor(){this.callbackRouter=new PageCallbackRouter;const pageHandlerRemote=PageHandler.getRemote();pageHandlerRemote.setPage(this.callbackRouter.$.bindNewPipeAndPassRemote())}static getInstance(){return instance||(instance=new BrowserProxy)}static setInstance(newInstance){instance=newInstance}}const COLORS_CSS_SELECTOR="link[href*='//theme/colors.css']";let documentInstance=null;const COLOR_PROVIDER_CHANGED="color-provider-changed";class ColorChangeUpdater{listenerId_=null;root_;eventTarget=new EventTarget;constructor(root){assert(documentInstance===null||root!==document);this.root_=root}start(){if(this.listenerId_!==null){return}this.listenerId_=BrowserProxy.getInstance().callbackRouter.onColorProviderChanged.addListener(this.onColorProviderChanged.bind(this))}async onColorProviderChanged(){await this.refreshColorsCss();this.eventTarget.dispatchEvent(new CustomEvent(COLOR_PROVIDER_CHANGED))}async refreshColorsCss(){const colorCssNode=this.root_.querySelector(COLORS_CSS_SELECTOR);if(!colorCssNode){return false}const href=colorCssNode.getAttribute("href");if(!href){return false}const hrefURL=new URL(href,location.href);const params=new URLSearchParams(hrefURL.search);params.set("version",(new Date).getTime().toString());const newHref=`${hrefURL.origin}${hrefURL.pathname}?${params.toString()}`;const newColorsCssLink=document.createElement("link");newColorsCssLink.setAttribute("href",newHref);newColorsCssLink.rel="stylesheet";newColorsCssLink.type="text/css";const newColorsLoaded=new Promise((resolve=>{newColorsCssLink.onload=resolve}));if(this.root_===document){document.getElementsByTagName("body")[0].appendChild(newColorsCssLink)}else{this.root_.appendChild(newColorsCssLink)}await newColorsLoaded;const oldColorCssNode=document.querySelector(COLORS_CSS_SELECTOR);if(oldColorCssNode){oldColorCssNode.remove()}return true}static forDocument(){return documentInstance||(documentInstance=new ColorChangeUpdater(document))}}function serializeError(error){return{message:error.message||"",name:error.name||"",stack:error.stack||""}}class NativeResolver{resolve;reject;promise;constructor(){this.promise=new Promise(((resolve,reject)=>{this.resolve=resolve;this.reject=reject}))}}function assertCast(condition){if(!condition){throw new Error("Failed assertion")}return condition}var ReservedMessageTypes;(function(ReservedMessageTypes){ReservedMessageTypes["RESPONSE_TYPE"]="___response";ReservedMessageTypes["ERROR_TYPE"]="___error"})(ReservedMessageTypes||(ReservedMessageTypes={}));function isGeneratedMessage(messageType){return messageType.substr(0,3)==="___"}function throwIfReserved(messageType){if(isGeneratedMessage(messageType)){throw new Error(`Unexpected reserved message type: '${messageType}'`)}}class MessagePipe{target_;targetOrigin_;rethrowErrors;logClientError=object=>console.error(JSON.stringify(object));messageHandlers_=new Map;pendingMessages_=new Map;nextMessageId_=0;messageListener_=m=>this.receiveMessage_(m);constructor(targetOrigin,target,rethrowErrors=true){if(!target){const frame=document.querySelector(`iframe[src^='${targetOrigin}']`);if(!frame||!frame.contentWindow){throw new Error("Unable to locate target content window.")}target=assertCast(frame.contentWindow)}this.target_=target;this.targetOrigin_=targetOrigin;this.rethrowErrors=rethrowErrors;console.assert(this.target_!==window,"target !== window");window.addEventListener("message",this.messageListener_)}registerHandler(messageType,handler){throwIfReserved(messageType);if(this.messageHandlers_.has(messageType)){throw new Error(`A handler already exists for ${messageType}`)}this.messageHandlers_.set(messageType,handler)}async sendMessage(messageType,message={}){try{return await this.sendMessageImpl(messageType,message)}catch(errorResponse){const error=new Error(`${messageType}: ${errorResponse.message}`);error.name=errorResponse.name||"Unknown Error";error.stack+=`\nError from ${this.targetOrigin_}\n${errorResponse.stack}`;throw error}}async sendMessageImpl(messageType,message={}){throwIfReserved(messageType);const messageId=this.nextMessageId_++;const resolver=new NativeResolver;this.pendingMessages_.set(messageId,resolver);this.postToTarget_(messageType,message,messageId);return resolver.promise}detach(){window.removeEventListener("message",this.messageListener_)}handleMessageResponse_(messageType,message,messageId){const{RESPONSE_TYPE:RESPONSE_TYPE,ERROR_TYPE:ERROR_TYPE}=ReservedMessageTypes;const resolver=assertCast(this.pendingMessages_.get(messageId));if(messageType===RESPONSE_TYPE){resolver.resolve(message)}else if(messageType===ERROR_TYPE){this.logClientError(message);resolver.reject(message)}else{console.error(`Response for message ${messageId} received with invalid message type ${messageType}`)}this.pendingMessages_.delete(messageId)}async callHandlerForMessageType_(messageType,message,messageId){const{RESPONSE_TYPE:RESPONSE_TYPE,ERROR_TYPE:ERROR_TYPE}=ReservedMessageTypes;let response;let error=null;let sawError=false;try{const handler=assertCast(this.messageHandlers_.get(messageType));response=await handler(message)}catch(err){sawError=true;error=err;response=serializeError(err)}this.postToTarget_(sawError?ERROR_TYPE:RESPONSE_TYPE,response,messageId);if(sawError&&this.rethrowErrors){this.logClientError(error);throw error}}receiveMessage_(e){if(typeof e.data!=="object"||!e.data||typeof e.data.type!=="string"){return}const{messageId:messageId,type:type,message:message}=e.data;const{ERROR_TYPE:ERROR_TYPE}=ReservedMessageTypes;if(e.origin!==this.targetOrigin_&&this.targetOrigin_!=="*"){return}if(isGeneratedMessage(type)&&this.pendingMessages_.has(messageId)){this.handleMessageResponse_(type,message,messageId);return}if(isGeneratedMessage(type)){console.error(`Response with type ${type} for unknown message received.`);return}if(!this.messageHandlers_.has(type)){const error=new Error(`No handler registered for message type '${type}'`);const errorResponse=serializeError(error);this.postToTarget_(ERROR_TYPE,errorResponse,messageId);return}this.callHandlerForMessageType_(type,message,messageId)}postToTarget_(messageType,message,messageId){const messageWrapper={messageId:messageId,type:messageType,message:message||{}};this.target_.postMessage(messageWrapper,this.targetOrigin_)}}const MantisErrorSpec={$:mojo.internal.Enum()};var MantisError;(function(MantisError){MantisError[MantisError["MIN_VALUE"]=0]="MIN_VALUE";MantisError[MantisError["MAX_VALUE"]=7]="MAX_VALUE";MantisError[MantisError["kUnknownError"]=0]="kUnknownError";MantisError[MantisError["kProcessorNotInitialized"]=1]="kProcessorNotInitialized";MantisError[MantisError["kInputError"]=2]="kInputError";MantisError[MantisError["kProcessFailed"]=3]="kProcessFailed";MantisError[MantisError["kMissingSegmenter"]=4]="kMissingSegmenter";MantisError[MantisError["kInputSafetyError"]=5]="kInputSafetyError";MantisError[MantisError["kOutputSafetyError"]=6]="kOutputSafetyError";MantisError[MantisError["kPromptSafetyError"]=7]="kPromptSafetyError"})(MantisError||(MantisError={}));const SafetyClassifierVerdictSpec={$:mojo.internal.Enum()};var SafetyClassifierVerdict;(function(SafetyClassifierVerdict){SafetyClassifierVerdict[SafetyClassifierVerdict["MIN_VALUE"]=0]="MIN_VALUE";SafetyClassifierVerdict[SafetyClassifierVerdict["MAX_VALUE"]=5]="MAX_VALUE";SafetyClassifierVerdict[SafetyClassifierVerdict["kPass"]=0]="kPass";SafetyClassifierVerdict[SafetyClassifierVerdict["kFail"]=1]="kFail";SafetyClassifierVerdict[SafetyClassifierVerdict["kFailedText"]=2]="kFailedText";SafetyClassifierVerdict[SafetyClassifierVerdict["kFailedImage"]=3]="kFailedImage";SafetyClassifierVerdict[SafetyClassifierVerdict["kServiceNotAvailable"]=4]="kServiceNotAvailable";SafetyClassifierVerdict[SafetyClassifierVerdict["kNoInternetConnection"]=5]="kNoInternetConnection"})(SafetyClassifierVerdict||(SafetyClassifierVerdict={}));const SegmentationModeSpec={$:mojo.internal.Enum()};var SegmentationMode;(function(SegmentationMode){SegmentationMode[SegmentationMode["MIN_VALUE"]=0]="MIN_VALUE";SegmentationMode[SegmentationMode["MAX_VALUE"]=1]="MAX_VALUE";SegmentationMode[SegmentationMode["kScribble"]=0]="kScribble";SegmentationMode[SegmentationMode["kLasso"]=1]="kLasso"})(SegmentationMode||(SegmentationMode={}));class MantisProcessorPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"mantis.mojom.MantisProcessor",scope)}}const TouchPointSpec={$:{}};const MantisProcessor_Inpainting_ParamsSpec={$:{}};const MantisProcessor_Inpainting_ResponseParamsSpec={$:{}};const MantisProcessor_GenerativeFill_ParamsSpec={$:{}};const MantisProcessor_GenerativeFill_ResponseParamsSpec={$:{}};const MantisProcessor_Segmentation_ParamsSpec={$:{}};const MantisProcessor_Segmentation_ResponseParamsSpec={$:{}};const MantisProcessor_ClassifyImageSafety_ParamsSpec={$:{}};const MantisProcessor_ClassifyImageSafety_ResponseParamsSpec={$:{}};const MantisProcessor_Outpainting_ParamsSpec={$:{}};const MantisProcessor_Outpainting_ResponseParamsSpec={$:{}};const MantisProcessor_InferSegmentationMode_ParamsSpec={$:{}};const MantisProcessor_InferSegmentationMode_ResponseParamsSpec={$:{}};const MantisResultSpec={$:{}};mojo.internal.Struct(TouchPointSpec.$,"TouchPoint",[mojo.internal.StructField("x",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(MantisProcessor_Inpainting_ParamsSpec.$,"MantisProcessor_Inpainting_Params",[mojo.internal.StructField("image",0,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined),mojo.internal.StructField("mask",8,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined),mojo.internal.StructField("seed",16,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(MantisProcessor_Inpainting_ResponseParamsSpec.$,"MantisProcessor_Inpainting_ResponseParams",[mojo.internal.StructField("result",0,0,MantisResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(MantisProcessor_GenerativeFill_ParamsSpec.$,"MantisProcessor_GenerativeFill_Params",[mojo.internal.StructField("image",0,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined),mojo.internal.StructField("mask",8,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined),mojo.internal.StructField("seed",16,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("prompt",24,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(MantisProcessor_GenerativeFill_ResponseParamsSpec.$,"MantisProcessor_GenerativeFill_ResponseParams",[mojo.internal.StructField("result",0,0,MantisResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(MantisProcessor_Segmentation_ParamsSpec.$,"MantisProcessor_Segmentation_Params",[mojo.internal.StructField("image",0,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined),mojo.internal.StructField("prior",8,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(MantisProcessor_Segmentation_ResponseParamsSpec.$,"MantisProcessor_Segmentation_ResponseParams",[mojo.internal.StructField("result",0,0,MantisResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(MantisProcessor_ClassifyImageSafety_ParamsSpec.$,"MantisProcessor_ClassifyImageSafety_Params",[mojo.internal.StructField("image",0,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(MantisProcessor_ClassifyImageSafety_ResponseParamsSpec.$,"MantisProcessor_ClassifyImageSafety_ResponseParams",[mojo.internal.StructField("verdict",0,0,SafetyClassifierVerdictSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(MantisProcessor_Outpainting_ParamsSpec.$,"MantisProcessor_Outpainting_Params",[mojo.internal.StructField("image",0,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined),mojo.internal.StructField("mask",8,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined),mojo.internal.StructField("seed",16,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(MantisProcessor_Outpainting_ResponseParamsSpec.$,"MantisProcessor_Outpainting_ResponseParams",[mojo.internal.StructField("result",0,0,MantisResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(MantisProcessor_InferSegmentationMode_ParamsSpec.$,"MantisProcessor_InferSegmentationMode_Params",[mojo.internal.StructField("gesture",0,0,mojo.internal.Array(TouchPointSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(MantisProcessor_InferSegmentationMode_ResponseParamsSpec.$,"MantisProcessor_InferSegmentationMode_ResponseParams",[mojo.internal.StructField("mode",0,0,SegmentationModeSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Union(MantisResultSpec.$,"MantisResult",{error:{ordinal:0,type:MantisErrorSpec.$},resultImage:{ordinal:1,type:mojo.internal.Array(mojo.internal.Uint8,false)}});var MantisResultFieldTags;(function(MantisResultFieldTags){MantisResultFieldTags[MantisResultFieldTags["ERROR"]=0]="ERROR";MantisResultFieldTags[MantisResultFieldTags["RESULT_IMAGE"]=1]="RESULT_IMAGE"})(MantisResultFieldTags||(MantisResultFieldTags={}));class JSTimeDataView{decoder_;version_;fieldSpecs_;constructor(decoder,version,fieldSpecs){this.decoder_=decoder;this.version_=version;this.fieldSpecs_=fieldSpecs}get msec(){const field=this.fieldSpecs_[0];return mojo.internal.decodeStructField(this.decoder_,field,this.version_)}}class JsTimeConverter{msec(date){return date.valueOf()}convert(view){return new Date(view.msec)}}const TimeSpec={$:{}};const JSTimeSpec={$:{}};const TimeDeltaSpec={$:{}};const TimeTicksSpec={$:{}};mojo.internal.Struct(TimeSpec.$,"Time",[mojo.internal.StructField("internalValue",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined)],[[0,16]]);const converterForJSTime=new JsTimeConverter;mojo.internal.TypemappedStruct(JSTimeSpec.$,"JSTime",JSTimeDataView,converterForJSTime,[mojo.internal.StructField("msec",0,0,mojo.internal.Double,0,false,0,undefined,(value=>converterForJSTime.msec(value)))],[[0,16]]);mojo.internal.Struct(TimeDeltaSpec.$,"TimeDelta",[mojo.internal.StructField("microseconds",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(TimeTicksSpec.$,"TimeTicks",[mojo.internal.StructField("internalValue",0,0,mojo.internal.Int64,BigInt(0),false,0,undefined,undefined)],[[0,16]]);const AnnotationUsecaseSpec={$:mojo.internal.Enum()};var AnnotationUsecase;(function(AnnotationUsecase){AnnotationUsecase[AnnotationUsecase["MIN_VALUE"]=0]="MIN_VALUE";AnnotationUsecase[AnnotationUsecase["MAX_VALUE"]=1]="MAX_VALUE";AnnotationUsecase[AnnotationUsecase["ANNOTATION_USECASE_SMART"]=0]="ANNOTATION_USECASE_SMART";AnnotationUsecase[AnnotationUsecase["ANNOTATION_USECASE_RAW"]=1]="ANNOTATION_USECASE_RAW"})(AnnotationUsecase||(AnnotationUsecase={}));class TextClassifierPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"chromeos.machine_learning.mojom.TextClassifier",scope)}}class TextClassifierRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(TextClassifierPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}annotate(request){return this.proxy.sendMessage(0,TextClassifier_Annotate_ParamsSpec.$,TextClassifier_Annotate_ResponseParamsSpec.$,[request],false)}findLanguages(text){return this.proxy.sendMessage(2,TextClassifier_FindLanguages_ParamsSpec.$,TextClassifier_FindLanguages_ResponseParamsSpec.$,[text],false)}rEMOVED1(request){return this.proxy.sendMessage(1,TextClassifier_REMOVED_1_ParamsSpec.$,TextClassifier_REMOVED_1_ResponseParamsSpec.$,[request],false)}}const TextEntitySpec={$:{}};const TextAnnotationSpec={$:{}};const TextAnnotationRequestSpec={$:{}};const CodepointSpanSpec={$:{}};const TextLanguageSpec={$:{}};const REMOVED_TextSuggestSelectionRequestSpec={$:{}};const TextClassifier_Annotate_ParamsSpec={$:{}};const TextClassifier_Annotate_ResponseParamsSpec={$:{}};const TextClassifier_FindLanguages_ParamsSpec={$:{}};const TextClassifier_FindLanguages_ResponseParamsSpec={$:{}};const TextClassifier_REMOVED_1_ParamsSpec={$:{}};const TextClassifier_REMOVED_1_ResponseParamsSpec={$:{}};const TextEntityDataSpec={$:{}};mojo.internal.Struct(TextEntitySpec.$,"TextEntity",[mojo.internal.StructField("name",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("confidenceScore",8,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("data",16,0,TextEntityDataSpec.$,null,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(TextAnnotationSpec.$,"TextAnnotation",[mojo.internal.StructField("startOffset",0,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("endOffset",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("entities",8,0,mojo.internal.Array(TextEntitySpec.$,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(TextAnnotationRequestSpec.$,"TextAnnotationRequest",[mojo.internal.StructField("text",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("defaultLocales",8,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("detectedTextLanguageTags",16,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("annotationUsecase",24,0,AnnotationUsecaseSpec.$,AnnotationUsecase.ANNOTATION_USECASE_SMART,false,0,undefined,undefined),mojo.internal.StructField("referenceTime",32,0,TimeSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("referenceTimezone",40,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("enabledEntities",48,0,mojo.internal.Array(mojo.internal.String,false),null,true,0,undefined,undefined),mojo.internal.StructField("triggerDictionaryOnBeginnerWords",28,0,mojo.internal.Bool,false,false,1,undefined,undefined)],[[0,64],[1,64]]);mojo.internal.Struct(CodepointSpanSpec.$,"CodepointSpan",[mojo.internal.StructField("startOffset",0,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("endOffset",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(TextLanguageSpec.$,"TextLanguage",[mojo.internal.StructField("locale",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("confidence",8,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(REMOVED_TextSuggestSelectionRequestSpec.$,"REMOVED_TextSuggestSelectionRequest",[mojo.internal.StructField("text",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("userSelection",8,0,CodepointSpanSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("defaultLocales",16,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("detectedTextLanguageTags",24,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("annotationUsecase",32,0,AnnotationUsecaseSpec.$,AnnotationUsecase.ANNOTATION_USECASE_SMART,false,0,undefined,undefined)],[[0,48]]);mojo.internal.Struct(TextClassifier_Annotate_ParamsSpec.$,"TextClassifier_Annotate_Params",[mojo.internal.StructField("request",0,0,TextAnnotationRequestSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(TextClassifier_Annotate_ResponseParamsSpec.$,"TextClassifier_Annotate_ResponseParams",[mojo.internal.StructField("outputs",0,0,mojo.internal.Array(TextAnnotationSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(TextClassifier_FindLanguages_ParamsSpec.$,"TextClassifier_FindLanguages_Params",[mojo.internal.StructField("text",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(TextClassifier_FindLanguages_ResponseParamsSpec.$,"TextClassifier_FindLanguages_ResponseParams",[mojo.internal.StructField("outputs",0,0,mojo.internal.Array(TextLanguageSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(TextClassifier_REMOVED_1_ParamsSpec.$,"TextClassifier_REMOVED_1_Params",[mojo.internal.StructField("request",0,0,REMOVED_TextSuggestSelectionRequestSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(TextClassifier_REMOVED_1_ResponseParamsSpec.$,"TextClassifier_REMOVED_1_ResponseParams",[mojo.internal.StructField("outputs",0,0,CodepointSpanSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Union(TextEntityDataSpec.$,"TextEntityData",{numericValue:{ordinal:0,type:mojo.internal.Double},stringValue:{ordinal:1,type:mojo.internal.String}});var TextEntityDataFieldTags;(function(TextEntityDataFieldTags){TextEntityDataFieldTags[TextEntityDataFieldTags["NUMERIC_VALUE"]=0]="NUMERIC_VALUE";TextEntityDataFieldTags[TextEntityDataFieldTags["STRING_VALUE"]=1]="STRING_VALUE"})(TextEntityDataFieldTags||(TextEntityDataFieldTags={}));const UuidSpec={$:{}};mojo.internal.Struct(UuidSpec.$,"Uuid",[mojo.internal.StructField("value",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);const MantisFeatureStatusSpec={$:mojo.internal.Enum()};var MantisFeatureStatus;(function(MantisFeatureStatus){MantisFeatureStatus[MantisFeatureStatus["MIN_VALUE"]=0]="MIN_VALUE";MantisFeatureStatus[MantisFeatureStatus["MAX_VALUE"]=2]="MAX_VALUE";MantisFeatureStatus[MantisFeatureStatus["kDeviceNotSupported"]=0]="kDeviceNotSupported";MantisFeatureStatus[MantisFeatureStatus["kARCVMDisabled"]=1]="kARCVMDisabled";MantisFeatureStatus[MantisFeatureStatus["kAvailable"]=2]="kAvailable"})(MantisFeatureStatus||(MantisFeatureStatus={}));const InitializeResultSpec={$:mojo.internal.Enum()};var InitializeResult;(function(InitializeResult){InitializeResult[InitializeResult["MIN_VALUE"]=0]="MIN_VALUE";InitializeResult[InitializeResult["MAX_VALUE"]=3]="MAX_VALUE";InitializeResult[InitializeResult["kSuccess"]=0]="kSuccess";InitializeResult[InitializeResult["kGpuBlocked"]=1]="kGpuBlocked";InitializeResult[InitializeResult["kFailedToLoadLibrary"]=2]="kFailedToLoadLibrary";InitializeResult[InitializeResult["kFailedToLoadSafetyService"]=3]="kFailedToLoadSafetyService"})(InitializeResult||(InitializeResult={}));class PlatformModelProgressObserverPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"mantis.mojom.PlatformModelProgressObserver",scope)}}class PlatformModelProgressObserverRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PlatformModelProgressObserverPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}progress(progress){this.proxy.sendMessage(0,PlatformModelProgressObserver_Progress_ParamsSpec.$,null,[progress],false)}}const PlatformModelProgressObserver_Progress_ParamsSpec={$:{}};const MantisService_GetMantisFeatureStatus_ParamsSpec={$:{}};const MantisService_GetMantisFeatureStatus_ResponseParamsSpec={$:{}};const MantisService_Initialize_ParamsSpec={$:{}};const MantisService_Initialize_ResponseParamsSpec={$:{}};mojo.internal.Struct(PlatformModelProgressObserver_Progress_ParamsSpec.$,"PlatformModelProgressObserver_Progress_Params",[mojo.internal.StructField("progress",0,0,mojo.internal.Double,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(MantisService_GetMantisFeatureStatus_ParamsSpec.$,"MantisService_GetMantisFeatureStatus_Params",[],[[0,8]]);mojo.internal.Struct(MantisService_GetMantisFeatureStatus_ResponseParamsSpec.$,"MantisService_GetMantisFeatureStatus_ResponseParams",[mojo.internal.StructField("status",0,0,MantisFeatureStatusSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(MantisService_Initialize_ParamsSpec.$,"MantisService_Initialize_Params",[mojo.internal.StructField("progressObserver",0,0,mojo.internal.InterfaceProxy(PlatformModelProgressObserverRemote),null,true,0,undefined,undefined),mojo.internal.StructField("processor",8,0,mojo.internal.InterfaceRequest(MantisProcessorPendingReceiver),null,false,0,undefined,undefined),mojo.internal.StructField("dlcUuid",16,0,UuidSpec.$,null,true,3,undefined,undefined),mojo.internal.StructField("textClassifier",24,0,mojo.internal.InterfaceProxy(TextClassifierRemote),null,true,4,undefined,undefined)],[[0,24],[3,32],[4,40]]);mojo.internal.Struct(MantisService_Initialize_ResponseParamsSpec.$,"MantisService_Initialize_ResponseParams",[mojo.internal.StructField("result",0,0,InitializeResultSpec.$,0,false,0,undefined,undefined)],[[0,16]]);var Message;(function(Message){Message["DELETE_FILE"]="delete-file";Message["EDIT_IN_PHOTOS"]="edit-in-photos";Message["IFRAME_READY"]="iframe-ready";Message["IS_FILE_ARC_WRITABLE"]="is-file-arc-writable";Message["IS_FILE_BROWSER_WRITABLE"]="is-file-browser-writable";Message["LOAD_EXTRA_FILES"]="load-extra-files";Message["LOAD_FILES"]="load-files";Message["MAYBE_TRIGGER_PDF_HATS"]="maybe-trigger-pdf-hats";Message["NAVIGATE"]="navigate";Message["NOTIFY_CURRENT_FILE"]="notify-current-file";Message["OPEN_ALLOWED_FILE"]="open-allowed-file";Message["OPEN_FEEDBACK_DIALOG"]="open-feedback-dialog";Message["OPEN_FILES_WITH_PICKER"]="open-files-with-picker";Message["OPEN_IN_SANDBOXED_VIEWER"]="open-in-sandboxed-viewer";Message["OVERWRITE_FILE"]="overwrite-file";Message["RELOAD_MAIN_FRAME"]="reload-main-frame";Message["RENAME_FILE"]="rename-file";Message["REQUEST_SAVE_FILE"]="request-save-file";Message["SAVE_AS"]="save-as";Message["SUBMIT_FORM"]="submit-form";Message["TOGGLE_BROWSER_FULLSCREEN_MODE"]="toggle-browser-fullscreen-mode"})(Message||(Message={}));var RenameResult;(function(RenameResult){RenameResult[RenameResult["FILE_NO_LONGER_IN_LAST_OPENED_DIRECTORY"]=-1]="FILE_NO_LONGER_IN_LAST_OPENED_DIRECTORY";RenameResult[RenameResult["SUCCESS"]=0]="SUCCESS";RenameResult[RenameResult["FILE_EXISTS"]=1]="FILE_EXISTS"})(RenameResult||(RenameResult={}));const BigBufferSharedMemoryRegionSpec={$:{}};const BigBufferSpec={$:{}};mojo.internal.Struct(BigBufferSharedMemoryRegionSpec.$,"BigBufferSharedMemoryRegion",[mojo.internal.StructField("bufferHandle",0,0,mojo.internal.Handle,null,false,0,undefined,undefined),mojo.internal.StructField("size",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Union(BigBufferSpec.$,"BigBuffer",{bytes:{ordinal:0,type:mojo.internal.Array(mojo.internal.Uint8,false)},sharedMemory:{ordinal:1,type:BigBufferSharedMemoryRegionSpec.$},invalidBuffer:{ordinal:2,type:mojo.internal.Bool}});var BigBufferFieldTags;(function(BigBufferFieldTags){BigBufferFieldTags[BigBufferFieldTags["BYTES"]=0]="BYTES";BigBufferFieldTags[BigBufferFieldTags["SHARED_MEMORY"]=1]="SHARED_MEMORY";BigBufferFieldTags[BigBufferFieldTags["INVALID_BUFFER"]=2]="INVALID_BUFFER"})(BigBufferFieldTags||(BigBufferFieldTags={}));const ColorTypeSpec={$:mojo.internal.Enum()};var ColorType;(function(ColorType){ColorType[ColorType["MIN_VALUE"]=0]="MIN_VALUE";ColorType[ColorType["MAX_VALUE"]=7]="MAX_VALUE";ColorType[ColorType["UNKNOWN"]=0]="UNKNOWN";ColorType[ColorType["ALPHA_8"]=1]="ALPHA_8";ColorType[ColorType["RGB_565"]=2]="RGB_565";ColorType[ColorType["ARGB_4444"]=3]="ARGB_4444";ColorType[ColorType["RGBA_8888"]=4]="RGBA_8888";ColorType[ColorType["BGRA_8888"]=5]="BGRA_8888";ColorType[ColorType["DEPRECATED_INDEX_8"]=6]="DEPRECATED_INDEX_8";ColorType[ColorType["GRAY_8"]=7]="GRAY_8"})(ColorType||(ColorType={}));const AlphaTypeSpec={$:mojo.internal.Enum()};var AlphaType;(function(AlphaType){AlphaType[AlphaType["MIN_VALUE"]=0]="MIN_VALUE";AlphaType[AlphaType["MAX_VALUE"]=3]="MAX_VALUE";AlphaType[AlphaType["UNKNOWN"]=0]="UNKNOWN";AlphaType[AlphaType["ALPHA_TYPE_OPAQUE"]=1]="ALPHA_TYPE_OPAQUE";AlphaType[AlphaType["PREMUL"]=2]="PREMUL";AlphaType[AlphaType["UNPREMUL"]=3]="UNPREMUL"})(AlphaType||(AlphaType={}));const ImageInfoSpec={$:{}};const BitmapN32ImageInfoSpec={$:{}};mojo.internal.Struct(ImageInfoSpec.$,"ImageInfo",[mojo.internal.StructField("colorType",0,0,ColorTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("alphaType",4,0,AlphaTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("width",8,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("height",12,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("colorTransferFunction",16,0,mojo.internal.Array(mojo.internal.Float,false),null,true,0,undefined,undefined),mojo.internal.StructField("colorToXyzMatrix",24,0,mojo.internal.Array(mojo.internal.Float,false),null,true,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(BitmapN32ImageInfoSpec.$,"BitmapN32ImageInfo",[mojo.internal.StructField("alphaType",0,0,AlphaTypeSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("width",4,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("height",8,0,mojo.internal.Uint32,0,false,0,undefined,undefined),mojo.internal.StructField("colorTransferFunction",16,0,mojo.internal.Array(mojo.internal.Float,false),null,true,0,undefined,undefined),mojo.internal.StructField("colorToXyzMatrix",24,0,mojo.internal.Array(mojo.internal.Float,false),null,true,0,undefined,undefined)],[[0,40]]);const BitmapN32Spec={$:{}};const BitmapWithArbitraryBppSpec={$:{}};const BitmapMappedFromTrustedProcessSpec={$:{}};const InlineBitmapSpec={$:{}};mojo.internal.Struct(BitmapN32Spec.$,"BitmapN32",[mojo.internal.StructField("imageInfo",0,0,BitmapN32ImageInfoSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("pixelData",8,0,BigBufferSpec.$,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(BitmapWithArbitraryBppSpec.$,"BitmapWithArbitraryBpp",[mojo.internal.StructField("imageInfo",0,0,ImageInfoSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("uNUSEDRowBytes",8,0,mojo.internal.Uint64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("pixelData",16,0,BigBufferSpec.$,null,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(BitmapMappedFromTrustedProcessSpec.$,"BitmapMappedFromTrustedProcess",[mojo.internal.StructField("imageInfo",0,0,ImageInfoSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("uNUSEDRowBytes",8,0,mojo.internal.Uint64,BigInt(0),false,0,undefined,undefined),mojo.internal.StructField("pixelData",16,0,BigBufferSpec.$,null,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(InlineBitmapSpec.$,"InlineBitmap",[mojo.internal.StructField("imageInfo",0,0,BitmapN32ImageInfoSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("pixelData",8,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined)],[[0,24]]);const PointSpec={$:{}};const PointFSpec={$:{}};const Point3FSpec={$:{}};const SizeSpec={$:{}};const SizeFSpec={$:{}};const RectSpec={$:{}};const RectFSpec={$:{}};const InsetsSpec={$:{}};const InsetsFSpec={$:{}};const Vector2dSpec={$:{}};const Vector2dFSpec={$:{}};const Vector3dFSpec={$:{}};const QuaternionSpec={$:{}};const QuadFSpec={$:{}};mojo.internal.Struct(PointSpec.$,"Point",[mojo.internal.StructField("x",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PointFSpec.$,"PointF",[mojo.internal.StructField("x",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Point3FSpec.$,"Point3F",[mojo.internal.StructField("x",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("z",8,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(SizeSpec.$,"Size",[mojo.internal.StructField("width",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("height",4,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(SizeFSpec.$,"SizeF",[mojo.internal.StructField("width",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("height",4,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(RectSpec.$,"Rect",[mojo.internal.StructField("x",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("width",8,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("height",12,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(RectFSpec.$,"RectF",[mojo.internal.StructField("x",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("width",8,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("height",12,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(InsetsSpec.$,"Insets",[mojo.internal.StructField("top",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("left",4,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("bottom",8,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("right",12,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(InsetsFSpec.$,"InsetsF",[mojo.internal.StructField("top",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("left",4,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("bottom",8,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("right",12,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(Vector2dSpec.$,"Vector2d",[mojo.internal.StructField("x",0,0,mojo.internal.Int32,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Vector2dFSpec.$,"Vector2dF",[mojo.internal.StructField("x",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(Vector3dFSpec.$,"Vector3dF",[mojo.internal.StructField("x",0,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("y",4,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("z",8,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(QuaternionSpec.$,"Quaternion",[mojo.internal.StructField("x",0,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("y",8,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("z",16,0,mojo.internal.Double,0,false,0,undefined,undefined),mojo.internal.StructField("w",24,0,mojo.internal.Double,0,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(QuadFSpec.$,"QuadF",[mojo.internal.StructField("p1",0,0,PointFSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("p2",8,0,PointFSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("p3",16,0,PointFSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("p4",24,0,PointFSpec.$,null,false,0,undefined,undefined)],[[0,40]]);class UntrustedServiceFactoryPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.media_app_ui.mojom.UntrustedServiceFactory",scope)}}class UntrustedServiceFactoryRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(UntrustedServiceFactoryPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}createOcrUntrustedService(receiver,page){this.proxy.sendMessage(0,UntrustedServiceFactory_CreateOcrUntrustedService_ParamsSpec.$,null,[receiver,page],false)}createMahiUntrustedService(receiver,page,fileName){this.proxy.sendMessage(1,UntrustedServiceFactory_CreateMahiUntrustedService_ParamsSpec.$,null,[receiver,page,fileName],false)}isMantisAvailable(){return this.proxy.sendMessage(2,UntrustedServiceFactory_IsMantisAvailable_ParamsSpec.$,UntrustedServiceFactory_IsMantisAvailable_ResponseParamsSpec.$,[],false)}createMantisUntrustedService(page,dlcUuid){return this.proxy.sendMessage(3,UntrustedServiceFactory_CreateMantisUntrustedService_ParamsSpec.$,UntrustedServiceFactory_CreateMantisUntrustedService_ResponseParamsSpec.$,[page,dlcUuid],false)}}class UntrustedServiceFactory{static get $interfaceName(){return"ash.media_app_ui.mojom.UntrustedServiceFactory"}static getRemote(){let remote=new UntrustedServiceFactoryRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}class OcrUntrustedServicePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.media_app_ui.mojom.OcrUntrustedService",scope)}}class OcrUntrustedServiceRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(OcrUntrustedServicePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}pageMetadataUpdated(pageMetadata){this.proxy.sendMessage(0,OcrUntrustedService_PageMetadataUpdated_ParamsSpec.$,null,[pageMetadata],false)}pageContentsUpdated(dirtyPageId){this.proxy.sendMessage(1,OcrUntrustedService_PageContentsUpdated_ParamsSpec.$,null,[dirtyPageId],false)}viewportUpdated(viewportBox,scaleFactor){this.proxy.sendMessage(2,OcrUntrustedService_ViewportUpdated_ParamsSpec.$,null,[viewportBox,scaleFactor],false)}}class OcrUntrustedPagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.media_app_ui.mojom.OcrUntrustedPage",scope)}}class OcrUntrustedPageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(OcrUntrustedPagePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}requestBitmap(requestedPageId){return this.proxy.sendMessage(0,OcrUntrustedPage_RequestBitmap_ParamsSpec.$,OcrUntrustedPage_RequestBitmap_ResponseParamsSpec.$,[requestedPageId],false)}setViewport(viewportBox){this.proxy.sendMessage(1,OcrUntrustedPage_SetViewport_ParamsSpec.$,null,[viewportBox],false)}setPdfOcrEnabled(enabled){this.proxy.sendMessage(2,OcrUntrustedPage_SetPdfOcrEnabled_ParamsSpec.$,null,[enabled],false)}}class OcrUntrustedPageCallbackRouter{helper_internal_;$;router_;requestBitmap;setViewport;setPdfOcrEnabled;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(OcrUntrustedPageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.requestBitmap=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,OcrUntrustedPage_RequestBitmap_ParamsSpec.$,OcrUntrustedPage_RequestBitmap_ResponseParamsSpec.$,this.requestBitmap.createReceiverHandler(true),false);this.setViewport=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,OcrUntrustedPage_SetViewport_ParamsSpec.$,null,this.setViewport.createReceiverHandler(false),false);this.setPdfOcrEnabled=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,OcrUntrustedPage_SetPdfOcrEnabled_ParamsSpec.$,null,this.setPdfOcrEnabled.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}class MahiUntrustedServicePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.media_app_ui.mojom.MahiUntrustedService",scope)}}class MahiUntrustedServiceRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(MahiUntrustedServicePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onPdfLoaded(){this.proxy.sendMessage(0,MahiUntrustedService_OnPdfLoaded_ParamsSpec.$,null,[],false)}onPdfFileNameUpdated(newName){this.proxy.sendMessage(1,MahiUntrustedService_OnPdfFileNameUpdated_ParamsSpec.$,null,[newName],false)}onPdfContextMenuShow(anchor,selectedText){this.proxy.sendMessage(2,MahiUntrustedService_OnPdfContextMenuShow_ParamsSpec.$,null,[anchor,selectedText],false)}onPdfContextMenuHide(){this.proxy.sendMessage(3,MahiUntrustedService_OnPdfContextMenuHide_ParamsSpec.$,null,[],false)}}class MahiUntrustedPagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.media_app_ui.mojom.MahiUntrustedPage",scope)}}class MahiUntrustedPageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(MahiUntrustedPagePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}hidePdfContextMenu(){this.proxy.sendMessage(0,MahiUntrustedPage_HidePdfContextMenu_ParamsSpec.$,null,[],false)}getPdfContent(limit){return this.proxy.sendMessage(1,MahiUntrustedPage_GetPdfContent_ParamsSpec.$,MahiUntrustedPage_GetPdfContent_ResponseParamsSpec.$,[limit],false)}}class MahiUntrustedPageCallbackRouter{helper_internal_;$;router_;hidePdfContextMenu;getPdfContent;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MahiUntrustedPageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.hidePdfContextMenu=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,MahiUntrustedPage_HidePdfContextMenu_ParamsSpec.$,null,this.hidePdfContextMenu.createReceiverHandler(false),false);this.getPdfContent=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,MahiUntrustedPage_GetPdfContent_ParamsSpec.$,MahiUntrustedPage_GetPdfContent_ResponseParamsSpec.$,this.getPdfContent.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}class MantisUntrustedServicePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.media_app_ui.mojom.MantisUntrustedService",scope)}}class MantisUntrustedServiceRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(MantisUntrustedServicePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}segmentImage(image,selection){return this.proxy.sendMessage(0,MantisUntrustedService_SegmentImage_ParamsSpec.$,MantisUntrustedService_SegmentImage_ResponseParamsSpec.$,[image,selection],false)}generativeFillImage(image,mask,text,seed){return this.proxy.sendMessage(1,MantisUntrustedService_GenerativeFillImage_ParamsSpec.$,MantisUntrustedService_GenerativeFillImage_ResponseParamsSpec.$,[image,mask,text,seed],false)}inpaintImage(image,mask,seed){return this.proxy.sendMessage(2,MantisUntrustedService_InpaintImage_ParamsSpec.$,MantisUntrustedService_InpaintImage_ResponseParamsSpec.$,[image,mask,seed],false)}outpaintImage(image,mask,seed){return this.proxy.sendMessage(3,MantisUntrustedService_OutpaintImage_ParamsSpec.$,MantisUntrustedService_OutpaintImage_ResponseParamsSpec.$,[image,mask,seed],false)}classifyImageSafety(image){return this.proxy.sendMessage(4,MantisUntrustedService_ClassifyImageSafety_ParamsSpec.$,MantisUntrustedService_ClassifyImageSafety_ResponseParamsSpec.$,[image],false)}inferSegmentationMode(gesture){return this.proxy.sendMessage(5,MantisUntrustedService_InferSegmentationMode_ParamsSpec.$,MantisUntrustedService_InferSegmentationMode_ResponseParamsSpec.$,[gesture],false)}}class MantisUntrustedPagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.media_app_ui.mojom.MantisUntrustedPage",scope)}}class MantisUntrustedPageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(MantisUntrustedPagePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}reportMantisProgress(progress){this.proxy.sendMessage(0,MantisUntrustedPage_ReportMantisProgress_ParamsSpec.$,null,[progress],false)}}class MantisUntrustedPageCallbackRouter{helper_internal_;$;router_;reportMantisProgress;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MantisUntrustedPageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.reportMantisProgress=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,MantisUntrustedPage_ReportMantisProgress_ParamsSpec.$,null,this.reportMantisProgress.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}const PageMetadataSpec={$:{}};const UntrustedServiceFactory_CreateOcrUntrustedService_ParamsSpec={$:{}};const UntrustedServiceFactory_CreateMahiUntrustedService_ParamsSpec={$:{}};const UntrustedServiceFactory_IsMantisAvailable_ParamsSpec={$:{}};const UntrustedServiceFactory_IsMantisAvailable_ResponseParamsSpec={$:{}};const UntrustedServiceFactory_CreateMantisUntrustedService_ParamsSpec={$:{}};const UntrustedServiceFactory_CreateMantisUntrustedService_ResponseParamsSpec={$:{}};const OcrUntrustedService_PageMetadataUpdated_ParamsSpec={$:{}};const OcrUntrustedService_PageContentsUpdated_ParamsSpec={$:{}};const OcrUntrustedService_ViewportUpdated_ParamsSpec={$:{}};const OcrUntrustedPage_RequestBitmap_ParamsSpec={$:{}};const OcrUntrustedPage_RequestBitmap_ResponseParamsSpec={$:{}};const OcrUntrustedPage_SetViewport_ParamsSpec={$:{}};const OcrUntrustedPage_SetPdfOcrEnabled_ParamsSpec={$:{}};const MahiUntrustedService_OnPdfLoaded_ParamsSpec={$:{}};const MahiUntrustedService_OnPdfFileNameUpdated_ParamsSpec={$:{}};const MahiUntrustedService_OnPdfContextMenuShow_ParamsSpec={$:{}};const MahiUntrustedService_OnPdfContextMenuHide_ParamsSpec={$:{}};const MahiUntrustedPage_HidePdfContextMenu_ParamsSpec={$:{}};const MahiUntrustedPage_GetPdfContent_ParamsSpec={$:{}};const MahiUntrustedPage_GetPdfContent_ResponseParamsSpec={$:{}};const MantisUntrustedService_SegmentImage_ParamsSpec={$:{}};const MantisUntrustedService_SegmentImage_ResponseParamsSpec={$:{}};const MantisUntrustedService_GenerativeFillImage_ParamsSpec={$:{}};const MantisUntrustedService_GenerativeFillImage_ResponseParamsSpec={$:{}};const MantisUntrustedService_InpaintImage_ParamsSpec={$:{}};const MantisUntrustedService_InpaintImage_ResponseParamsSpec={$:{}};const MantisUntrustedService_OutpaintImage_ParamsSpec={$:{}};const MantisUntrustedService_OutpaintImage_ResponseParamsSpec={$:{}};const MantisUntrustedService_ClassifyImageSafety_ParamsSpec={$:{}};const MantisUntrustedService_ClassifyImageSafety_ResponseParamsSpec={$:{}};const MantisUntrustedService_InferSegmentationMode_ParamsSpec={$:{}};const MantisUntrustedService_InferSegmentationMode_ResponseParamsSpec={$:{}};const MantisUntrustedPage_ReportMantisProgress_ParamsSpec={$:{}};const MantisUntrustedServiceResultSpec={$:{}};mojo.internal.Struct(PageMetadataSpec.$,"PageMetadata",[mojo.internal.StructField("id",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("rect",8,0,RectFSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(UntrustedServiceFactory_CreateOcrUntrustedService_ParamsSpec.$,"UntrustedServiceFactory_CreateOcrUntrustedService_Params",[mojo.internal.StructField("receiver",0,0,mojo.internal.InterfaceRequest(OcrUntrustedServicePendingReceiver),null,false,0,undefined,undefined),mojo.internal.StructField("page",4,0,mojo.internal.InterfaceProxy(OcrUntrustedPageRemote),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(UntrustedServiceFactory_CreateMahiUntrustedService_ParamsSpec.$,"UntrustedServiceFactory_CreateMahiUntrustedService_Params",[mojo.internal.StructField("receiver",0,0,mojo.internal.InterfaceRequest(MahiUntrustedServicePendingReceiver),null,false,0,undefined,undefined),mojo.internal.StructField("page",4,0,mojo.internal.InterfaceProxy(MahiUntrustedPageRemote),null,false,0,undefined,undefined),mojo.internal.StructField("fileName",16,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(UntrustedServiceFactory_IsMantisAvailable_ParamsSpec.$,"UntrustedServiceFactory_IsMantisAvailable_Params",[],[[0,8]]);mojo.internal.Struct(UntrustedServiceFactory_IsMantisAvailable_ResponseParamsSpec.$,"UntrustedServiceFactory_IsMantisAvailable_ResponseParams",[mojo.internal.StructField("result",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(UntrustedServiceFactory_CreateMantisUntrustedService_ParamsSpec.$,"UntrustedServiceFactory_CreateMantisUntrustedService_Params",[mojo.internal.StructField("page",0,0,mojo.internal.InterfaceProxy(MantisUntrustedPageRemote),null,false,0,undefined,undefined),mojo.internal.StructField("dlcUuid",8,0,UuidSpec.$,null,true,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(UntrustedServiceFactory_CreateMantisUntrustedService_ResponseParamsSpec.$,"UntrustedServiceFactory_CreateMantisUntrustedService_ResponseParams",[mojo.internal.StructField("result",0,0,MantisUntrustedServiceResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(OcrUntrustedService_PageMetadataUpdated_ParamsSpec.$,"OcrUntrustedService_PageMetadataUpdated_Params",[mojo.internal.StructField("pageMetadata",0,0,mojo.internal.Array(PageMetadataSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(OcrUntrustedService_PageContentsUpdated_ParamsSpec.$,"OcrUntrustedService_PageContentsUpdated_Params",[mojo.internal.StructField("dirtyPageId",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(OcrUntrustedService_ViewportUpdated_ParamsSpec.$,"OcrUntrustedService_ViewportUpdated_Params",[mojo.internal.StructField("viewportBox",0,0,RectFSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("scaleFactor",8,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(OcrUntrustedPage_RequestBitmap_ParamsSpec.$,"OcrUntrustedPage_RequestBitmap_Params",[mojo.internal.StructField("requestedPageId",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(OcrUntrustedPage_RequestBitmap_ResponseParamsSpec.$,"OcrUntrustedPage_RequestBitmap_ResponseParams",[mojo.internal.StructField("page",0,0,BitmapN32Spec.$,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(OcrUntrustedPage_SetViewport_ParamsSpec.$,"OcrUntrustedPage_SetViewport_Params",[mojo.internal.StructField("viewportBox",0,0,RectFSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(OcrUntrustedPage_SetPdfOcrEnabled_ParamsSpec.$,"OcrUntrustedPage_SetPdfOcrEnabled_Params",[mojo.internal.StructField("enabled",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(MahiUntrustedService_OnPdfLoaded_ParamsSpec.$,"MahiUntrustedService_OnPdfLoaded_Params",[],[[0,8]]);mojo.internal.Struct(MahiUntrustedService_OnPdfFileNameUpdated_ParamsSpec.$,"MahiUntrustedService_OnPdfFileNameUpdated_Params",[mojo.internal.StructField("newName",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(MahiUntrustedService_OnPdfContextMenuShow_ParamsSpec.$,"MahiUntrustedService_OnPdfContextMenuShow_Params",[mojo.internal.StructField("anchor",0,0,RectFSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("selectedText",8,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(MahiUntrustedService_OnPdfContextMenuHide_ParamsSpec.$,"MahiUntrustedService_OnPdfContextMenuHide_Params",[],[[0,8]]);mojo.internal.Struct(MahiUntrustedPage_HidePdfContextMenu_ParamsSpec.$,"MahiUntrustedPage_HidePdfContextMenu_Params",[],[[0,8]]);mojo.internal.Struct(MahiUntrustedPage_GetPdfContent_ParamsSpec.$,"MahiUntrustedPage_GetPdfContent_Params",[mojo.internal.StructField("limit",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(MahiUntrustedPage_GetPdfContent_ResponseParamsSpec.$,"MahiUntrustedPage_GetPdfContent_ResponseParams",[mojo.internal.StructField("content",0,0,mojo.internal.String,null,true,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(MantisUntrustedService_SegmentImage_ParamsSpec.$,"MantisUntrustedService_SegmentImage_Params",[mojo.internal.StructField("image",0,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined),mojo.internal.StructField("selection",8,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(MantisUntrustedService_SegmentImage_ResponseParamsSpec.$,"MantisUntrustedService_SegmentImage_ResponseParams",[mojo.internal.StructField("result",0,0,MantisResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(MantisUntrustedService_GenerativeFillImage_ParamsSpec.$,"MantisUntrustedService_GenerativeFillImage_Params",[mojo.internal.StructField("image",0,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined),mojo.internal.StructField("mask",8,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined),mojo.internal.StructField("text",16,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("seed",24,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(MantisUntrustedService_GenerativeFillImage_ResponseParamsSpec.$,"MantisUntrustedService_GenerativeFillImage_ResponseParams",[mojo.internal.StructField("result",0,0,MantisResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(MantisUntrustedService_InpaintImage_ParamsSpec.$,"MantisUntrustedService_InpaintImage_Params",[mojo.internal.StructField("image",0,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined),mojo.internal.StructField("mask",8,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined),mojo.internal.StructField("seed",16,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(MantisUntrustedService_InpaintImage_ResponseParamsSpec.$,"MantisUntrustedService_InpaintImage_ResponseParams",[mojo.internal.StructField("result",0,0,MantisResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(MantisUntrustedService_OutpaintImage_ParamsSpec.$,"MantisUntrustedService_OutpaintImage_Params",[mojo.internal.StructField("image",0,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined),mojo.internal.StructField("mask",8,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined),mojo.internal.StructField("seed",16,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(MantisUntrustedService_OutpaintImage_ResponseParamsSpec.$,"MantisUntrustedService_OutpaintImage_ResponseParams",[mojo.internal.StructField("result",0,0,MantisResultSpec.$,null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(MantisUntrustedService_ClassifyImageSafety_ParamsSpec.$,"MantisUntrustedService_ClassifyImageSafety_Params",[mojo.internal.StructField("image",0,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(MantisUntrustedService_ClassifyImageSafety_ResponseParamsSpec.$,"MantisUntrustedService_ClassifyImageSafety_ResponseParams",[mojo.internal.StructField("verdict",0,0,SafetyClassifierVerdictSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(MantisUntrustedService_InferSegmentationMode_ParamsSpec.$,"MantisUntrustedService_InferSegmentationMode_Params",[mojo.internal.StructField("gesture",0,0,mojo.internal.Array(TouchPointSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(MantisUntrustedService_InferSegmentationMode_ResponseParamsSpec.$,"MantisUntrustedService_InferSegmentationMode_ResponseParams",[mojo.internal.StructField("mode",0,0,SegmentationModeSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(MantisUntrustedPage_ReportMantisProgress_ParamsSpec.$,"MantisUntrustedPage_ReportMantisProgress_Params",[mojo.internal.StructField("progress",0,0,mojo.internal.Double,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Union(MantisUntrustedServiceResultSpec.$,"MantisUntrustedServiceResult",{service:{ordinal:0,type:mojo.internal.InterfaceProxy(MantisUntrustedServiceRemote)},error:{ordinal:1,type:InitializeResultSpec.$}});var MantisUntrustedServiceResultFieldTags;(function(MantisUntrustedServiceResultFieldTags){MantisUntrustedServiceResultFieldTags[MantisUntrustedServiceResultFieldTags["SERVICE"]=0]="SERVICE";MantisUntrustedServiceResultFieldTags[MantisUntrustedServiceResultFieldTags["ERROR"]=1]="ERROR"})(MantisUntrustedServiceResultFieldTags||(MantisUntrustedServiceResultFieldTags={}));let ocrUntrustedService$1;const ocrCallbackRouter=new OcrUntrustedPageCallbackRouter;const factoryRemote=UntrustedServiceFactory.getRemote();function connectToOcrUntrustedService(){if(ocrUntrustedService$1){ocrUntrustedService$1.$.close()}ocrUntrustedService$1=new OcrUntrustedServiceRemote;factoryRemote.createOcrUntrustedService(ocrUntrustedService$1.$.bindNewPipeAndPassReceiver(),ocrCallbackRouter.$.bindNewPipeAndPassRemote());return ocrUntrustedService$1}let mahiUntrustedService$1;const mahiCallbackRouter=new MahiUntrustedPageCallbackRouter;function connectToMahiUntrustedService(fileName){if(mahiUntrustedService$1){mahiUntrustedService$1.$.close()}mahiUntrustedService$1=new MahiUntrustedServiceRemote;factoryRemote.createMahiUntrustedService(mahiUntrustedService$1.$.bindNewPipeAndPassReceiver(),mahiCallbackRouter.$.bindNewPipeAndPassRemote(),fileName??"");return mahiUntrustedService$1}const mantisCallbackRouter=new MantisUntrustedPageCallbackRouter;async function isMantisAvailable(){const{result:result}=await factoryRemote.isMantisAvailable();return result}async function connectToMantisUntrustedService(dlcUuid){const{result:result}=await factoryRemote.createMantisUntrustedService(mantisCallbackRouter.$.bindNewPipeAndPassRemote(),dlcUuid);return result}let _piexLoadPromise=null;async function loadPiex(){async function startLoad(){function loadJs(path,module){return new Promise(((resolve,reject)=>{const script=document.createElement("script");script.onload=resolve;script.onerror=reject;if(module){script.type="module"}script.src=path;if(document.head){document.head.appendChild(script)}}))}await loadJs("piex/piex.js.wasm",false);await loadJs("piex_module.js",true);return window.extractFromRawImageBuffer}if(!_piexLoadPromise){_piexLoadPromise=startLoad()}return _piexLoadPromise}window.addEventListener("simulate-type-error-for-test",(event=>{event.notAFunction()}));window.addEventListener("simulate-unhandled-rejection-for-test",(_event=>{new Promise((_resolve=>{const error=new Error("fake_throw");error.name="FakeErrorName";throw error}))}));window.addEventListener("simulate-unhandled-rejection-with-dom-exception-for-test",(_event=>{new Promise((_resolve=>{throw new DOMException("Not a file.","NotAFile")}))}));const parentMessagePipe=new MessagePipe("chrome://media-app",window.parent);const PLACEHOLDER_BLOB=new Blob([]);const PDF_TEXT_CONTENT_PEEK_BYTE_SIZE=100;class ReceivedFile{blob;name;token;size;mimeType;fromClipboard;error;deleteOriginalFile;renameOriginalFile;constructor(file){this.blob=file.file||PLACEHOLDER_BLOB;this.name=file.name;this.size=this.blob.size;this.mimeType=this.blob.type;this.token=file.token;this.error=file.error;this.fromClipboard=false;if(file.canDelete){this.deleteOriginalFile=()=>this.deleteOriginalFileImpl()}if(file.canRename){this.renameOriginalFile=newName=>this.renameOriginalFileImpl(newName)}}async isArcWritable(){const message={token:this.token};const{writable:writable}=await parentMessagePipe.sendMessage(Message.IS_FILE_ARC_WRITABLE,message);return writable}async isBrowserWritable(){const message={token:this.token};const{writable:writable}=await parentMessagePipe.sendMessage(Message.IS_FILE_BROWSER_WRITABLE,message);return writable}async editInPhotos(){const message={token:this.token,mimeType:this.mimeType};await parentMessagePipe.sendMessage(Message.EDIT_IN_PHOTOS,message)}async overwriteOriginal(blob){const message={token:this.token,blob:blob};const result=await parentMessagePipe.sendMessage(Message.OVERWRITE_FILE,message);if(result.renamedTo){this.name=result.renamedTo;delete this.deleteOriginalFile;delete this.renameOriginalFile}this.error=result.errorName||"";this.updateFile(blob,this.name)}async deleteOriginalFileImpl(){await parentMessagePipe.sendMessage(Message.DELETE_FILE,{token:this.token})}async renameOriginalFileImpl(newName){const renameResponse=await parentMessagePipe.sendMessage(Message.RENAME_FILE,{token:this.token,newFilename:newName});if(renameResponse.renameResult===RenameResult.SUCCESS){this.name=newName}return renameResponse.renameResult}async saveAs(blob,pickedFileToken){const message={blob:blob,oldFileToken:this.token,pickedFileToken:pickedFileToken};const result=await parentMessagePipe.sendMessage(Message.SAVE_AS,message);this.updateFile(blob,result.newFilename);delete this.deleteOriginalFile;delete this.renameOriginalFile}async getExportFile(accept){const msg={suggestedName:this.name,mimeType:this.mimeType,startInToken:this.token,accept:accept};const response=await parentMessagePipe.sendMessage(Message.REQUEST_SAVE_FILE,msg);return new ReceivedFile(response.pickedFileContext)}async openFile(){const msg={fileToken:this.token};const response=await parentMessagePipe.sendMessage(Message.OPEN_ALLOWED_FILE,msg);return response.file}updateFile(blob,name){this.blob=new File([blob],name,{type:blob.type});this.size=blob.size;this.mimeType=blob.type;this.name=name}}let lastLoadedReceivedFileList=null;class ReceivedFileList{length;currentFileIndex;files;observers=[];constructor(filesMessage){const{files:files,currentFileIndex:currentFileIndex}=filesMessage;if(files.length){this.currentFileIndex=currentFileIndex>=0?currentFileIndex:0}else{this.currentFileIndex=-1}this.length=files.length;this.files=files.map((f=>new ReceivedFile(f)))}item(index){return this.files[index]||null}async loadNext(currentFileToken){await parentMessagePipe.sendMessage(Message.NAVIGATE,{currentFileToken:currentFileToken,direction:1})}async loadPrev(currentFileToken){await parentMessagePipe.sendMessage(Message.NAVIGATE,{currentFileToken:currentFileToken,direction:-1})}addObserver(observer){this.observers.push(observer)}async openFilesWithFilePicker(acceptTypeKeys,startInFolder,isSingleFile){const startInToken=startInFolder?.token||0;const msg={startInToken:startInToken>0?startInToken:0,accept:acceptTypeKeys,isSingleFile:!!isSingleFile};await parentMessagePipe.sendMessage(Message.OPEN_FILES_WITH_PICKER,msg)}filterInPlace(filter){this.files=this.files.filter(filter);this.length=this.files.length;this.currentFileIndex=this.length>0?0:-1}addFiles(files){if(files.length===0){return}this.files=[...this.files,...files];this.length=this.files.length;this.observers.map((o=>o(this)))}}parentMessagePipe.registerHandler(Message.LOAD_FILES,(async filesMessage=>{lastLoadedReceivedFileList=new ReceivedFileList(filesMessage);await loadFiles(lastLoadedReceivedFileList)}));parentMessagePipe.registerHandler(Message.LOAD_EXTRA_FILES,(async extraFilesMessage=>{if(!lastLoadedReceivedFileList){return}const newFiles=extraFilesMessage.files.map((f=>new ReceivedFile(f)));lastLoadedReceivedFileList.addFiles(newFiles)}));parentMessagePipe.sendMessage(Message.IFRAME_READY);let ocrUntrustedService;let mahiUntrustedService;let mantisUntrustedService;ocrCallbackRouter.requestBitmap.addListener((async requestedPageId=>{const app=getApp();if(app){const result=await app.requestBitmap(requestedPageId);return{page:result}}return null}));ocrCallbackRouter.setViewport.addListener((viewportBox=>void getApp()?.setViewport(viewportBox)));ocrCallbackRouter.setPdfOcrEnabled.addListener((enabled=>void getApp()?.setPdfOcrEnabled(enabled)));ocrCallbackRouter.onConnectionError.addListener((()=>{console.warn("Calling MediaApp RequestBitmap() failed to return bitmap.")}));mahiCallbackRouter.getPdfContent.addListener((async limit=>{const app=getApp();if(app){const content=await app.getPdfContent(limit);return{content:content}}return null}));mahiCallbackRouter.hidePdfContextMenu.addListener((()=>void getApp()?.hidePdfContextMenu()));mahiCallbackRouter.onConnectionError.addListener((()=>{console.warn("Calling MediaApp GetPdfContent() failed to return content.")}));mantisCallbackRouter.reportMantisProgress.addListener((progress=>void getApp()?.reportMantisProgress(progress)));const DELEGATE={async openFeedbackDialog(){const response=await parentMessagePipe.sendMessage(Message.OPEN_FEEDBACK_DIALOG);return response["errorMessage"]},async submitForm(url,payload,header){const msg={url:url,payload:payload,header:header};await parentMessagePipe.sendMessage(Message.SUBMIT_FORM,msg)},async toggleBrowserFullscreenMode(){await parentMessagePipe.sendMessage(Message.TOGGLE_BROWSER_FULLSCREEN_MODE)},async requestSaveFile(suggestedName,mimeType,accept){const msg={suggestedName:suggestedName,mimeType:mimeType,startInToken:0,accept:accept};const response=await parentMessagePipe.sendMessage(Message.REQUEST_SAVE_FILE,msg);return new ReceivedFile(response.pickedFileContext)},notifyCurrentFile(name,type){parentMessagePipe.sendMessage(Message.NOTIFY_CURRENT_FILE,{name:name,type:type})},notifyFileOpened(name,type){ocrUntrustedService?.$.close();mahiUntrustedService?.$.close();mantisUntrustedService?.$.close();if(type==="application/pdf"){ocrUntrustedService=connectToOcrUntrustedService();mahiUntrustedService=connectToMahiUntrustedService(name)}},notifyFilenameChanged(name){mahiUntrustedService?.onPdfFileNameUpdated(name)},async extractPreview(file){try{const bufferPromise=file.arrayBuffer();const extractFromRawImageBuffer=await loadPiex();return await extractFromRawImageBuffer(await bufferPromise)}catch(e){console.warn(e);if(e.name==="Error"){e.name="JpegNotFound"}throw e}},openInSandboxedViewer(title,blobUuid){parentMessagePipe.sendMessage(Message.OPEN_IN_SANDBOXED_VIEWER,{title:title,blobUuid:blobUuid})},reloadMainFrame(){parentMessagePipe.sendMessage(Message.RELOAD_MAIN_FRAME)},maybeTriggerPdfHats(){parentMessagePipe.sendMessage(Message.MAYBE_TRIGGER_PDF_HATS)},async pageMetadataUpdated(pageMetadata){await(ocrUntrustedService?.pageMetadataUpdated(pageMetadata))},async pageContentsUpdated(dirtyPageId){await(ocrUntrustedService?.pageContentsUpdated(dirtyPageId))},async viewportUpdated(viewportBox,scaleFactor){await(ocrUntrustedService?.viewportUpdated(viewportBox,scaleFactor))},async onPdfLoaded(){let hasText=false;const app=getApp();if(app){const peekContent=(await app.getPdfContent(PDF_TEXT_CONTENT_PEEK_BYTE_SIZE))?.toString()??"";hasText=peekContent.trim()!==""}if(!hasText){mahiUntrustedService?.$.close()}else{await(mahiUntrustedService?.onPdfLoaded())}},async onPdfContextMenuShow(anchor,selectedText){await(mahiUntrustedService?.onPdfContextMenuShow(anchor,selectedText))},async onPdfContextMenuHide(){await(mahiUntrustedService?.onPdfContextMenuHide())},async isMantisAvailable(){return isMantisAvailable()},async initializeMantis(dlcId){mantisUntrustedService?.$.close();const response=await connectToMantisUntrustedService(dlcId);if(response.error){return response.error}mantisUntrustedService=response.service;return InitializeResult.kSuccess},async segmentImage(image,selection){const response=await(mantisUntrustedService?.segmentImage(image,selection));return response.result},async generativeFillImage(image,mask,text,seed){const response=await(mantisUntrustedService?.generativeFillImage(image,mask,text,seed));return response.result},async inpaintImage(image,mask,seed){const response=await(mantisUntrustedService?.inpaintImage(image,mask,seed));return response.result},async classifyImageSafety(image){const response=await(mantisUntrustedService?.classifyImageSafety(image));return response.verdict},async outpaintImage(image,mask,seed){const response=await(mantisUntrustedService?.outpaintImage(image,mask,seed));return response.result},async inferSegmentationMode(gesture){const response=await(mantisUntrustedService?.inferSegmentationMode(gesture));return response.mode}};function getApp(){const app=document.querySelector("backlight-app");return app}async function loadFilesImpl(fileList){const app=getApp();if(app){await app.loadFiles(fileList)}else{window.customLaunchData.files=fileList}}let loadFiles=loadFilesImpl;function initializeApp(app){app.setDelegate(DELEGATE)}function mutationCallback(_mutationsList,observer){const app=getApp();if(!app){return}initializeApp(app);observer.disconnect()}window.addEventListener("DOMContentLoaded",(()=>{(function(){ColorChangeUpdater.forDocument().start()})();const app=getApp();if(app){initializeApp(app);return}const observer=new MutationObserver(mutationCallback);observer.observe(document.body,{childList:true})}));window.customLaunchData={delegate:DELEGATE,files:new ReceivedFileList({files:[],currentFileIndex:-1})};window.chooseFileSystemEntries=null;window.showOpenFilePicker=null;window.showSaveFilePicker=null;window.showDirectoryPicker=null;window.addColorChangeListener=function(listener){ColorChangeUpdater.forDocument().eventTarget.addEventListener(COLOR_PROVIDER_CHANGED,listener)};window.removeColorChangeListener=function(listener){ColorChangeUpdater.forDocument().eventTarget.removeEventListener(COLOR_PROVIDER_CHANGED,listener)};const TEST_ONLY={RenameResult:RenameResult,DELEGATE:DELEGATE,assertCast:assertCast,parentMessagePipe:parentMessagePipe,loadFiles:loadFiles,setLoadFiles:spy=>{loadFiles=spy}};window.lastLoadedReceivedFileList=()=>lastLoadedReceivedFileList;export{ReceivedFile,ReceivedFileList,TEST_ONLY};