// ash/webui/media_app_ui/media_app_ui_untrusted.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { SafetyClassifierVerdictSpec as mantis_mojom_SafetyClassifierVerdictSpec, SegmentationModeSpec as mantis_mojom_SegmentationModeSpec, TouchPointSpec as mantis_mojom_TouchPointSpec, MantisResultSpec as mantis_mojom_MantisResultSpec } from './mantis_processor.mojom-webui.js';
import { InitializeResultSpec as mantis_mojom_InitializeResultSpec } from './mantis_service.mojom-webui.js';
import { UuidSpec as mojoBase_mojom_UuidSpec } from '//resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js';
import { BitmapN32Spec as skia_mojom_BitmapN32Spec } from '//resources/mojo/skia/public/mojom/bitmap.mojom-webui.js';
import { RectFSpec as gfx_mojom_RectFSpec } from '//resources/mojo/ui/gfx/geometry/mojom/geometry.mojom-webui.js';
export class UntrustedServiceFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.media_app_ui.mojom.UntrustedServiceFactory', scope);
    }
}
export class UntrustedServiceFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(UntrustedServiceFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createOcrUntrustedService(receiver, page) {
        this.proxy.sendMessage(0, UntrustedServiceFactory_CreateOcrUntrustedService_ParamsSpec.$, null, [
            receiver,
            page
        ], false);
    }
    createMahiUntrustedService(receiver, page, fileName) {
        this.proxy.sendMessage(1, UntrustedServiceFactory_CreateMahiUntrustedService_ParamsSpec.$, null, [
            receiver,
            page,
            fileName
        ], false);
    }
    isMantisAvailable() {
        return this.proxy.sendMessage(2, UntrustedServiceFactory_IsMantisAvailable_ParamsSpec.$, UntrustedServiceFactory_IsMantisAvailable_ResponseParamsSpec.$, [], false);
    }
    createMantisUntrustedService(page, dlcUuid) {
        return this.proxy.sendMessage(3, UntrustedServiceFactory_CreateMantisUntrustedService_ParamsSpec.$, UntrustedServiceFactory_CreateMantisUntrustedService_ResponseParamsSpec.$, [
            page,
            dlcUuid
        ], false);
    }
}
;
/**
 * An object which receives request messages for the UntrustedServiceFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UntrustedServiceFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UntrustedServiceFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, UntrustedServiceFactory_CreateOcrUntrustedService_ParamsSpec.$, null, impl.createOcrUntrustedService.bind(impl), false);
        this.helper_internal_.registerHandler(1, UntrustedServiceFactory_CreateMahiUntrustedService_ParamsSpec.$, null, impl.createMahiUntrustedService.bind(impl), false);
        this.helper_internal_.registerHandler(2, UntrustedServiceFactory_IsMantisAvailable_ParamsSpec.$, UntrustedServiceFactory_IsMantisAvailable_ResponseParamsSpec.$, impl.isMantisAvailable.bind(impl), false);
        this.helper_internal_.registerHandler(3, UntrustedServiceFactory_CreateMantisUntrustedService_ParamsSpec.$, UntrustedServiceFactory_CreateMantisUntrustedService_ResponseParamsSpec.$, impl.createMantisUntrustedService.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class UntrustedServiceFactory {
    static get $interfaceName() {
        return "ash.media_app_ui.mojom.UntrustedServiceFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new UntrustedServiceFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the UntrustedServiceFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UntrustedServiceFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createOcrUntrustedService;
    createMahiUntrustedService;
    isMantisAvailable;
    createMantisUntrustedService;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UntrustedServiceFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createOcrUntrustedService =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, UntrustedServiceFactory_CreateOcrUntrustedService_ParamsSpec.$, null, this.createOcrUntrustedService.createReceiverHandler(false /* expectsResponse */), false);
        this.createMahiUntrustedService =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, UntrustedServiceFactory_CreateMahiUntrustedService_ParamsSpec.$, null, this.createMahiUntrustedService.createReceiverHandler(false /* expectsResponse */), false);
        this.isMantisAvailable =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, UntrustedServiceFactory_IsMantisAvailable_ParamsSpec.$, UntrustedServiceFactory_IsMantisAvailable_ResponseParamsSpec.$, this.isMantisAvailable.createReceiverHandler(true /* expectsResponse */), false);
        this.createMantisUntrustedService =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, UntrustedServiceFactory_CreateMantisUntrustedService_ParamsSpec.$, UntrustedServiceFactory_CreateMantisUntrustedService_ResponseParamsSpec.$, this.createMantisUntrustedService.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class OcrUntrustedServicePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.media_app_ui.mojom.OcrUntrustedService', scope);
    }
}
export class OcrUntrustedServiceRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(OcrUntrustedServicePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    pageMetadataUpdated(pageMetadata) {
        this.proxy.sendMessage(0, OcrUntrustedService_PageMetadataUpdated_ParamsSpec.$, null, [
            pageMetadata
        ], false);
    }
    pageContentsUpdated(dirtyPageId) {
        this.proxy.sendMessage(1, OcrUntrustedService_PageContentsUpdated_ParamsSpec.$, null, [
            dirtyPageId
        ], false);
    }
    viewportUpdated(viewportBox, scaleFactor) {
        this.proxy.sendMessage(2, OcrUntrustedService_ViewportUpdated_ParamsSpec.$, null, [
            viewportBox,
            scaleFactor
        ], false);
    }
}
;
/**
 * An object which receives request messages for the OcrUntrustedService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OcrUntrustedServiceReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(OcrUntrustedServiceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, OcrUntrustedService_PageMetadataUpdated_ParamsSpec.$, null, impl.pageMetadataUpdated.bind(impl), false);
        this.helper_internal_.registerHandler(1, OcrUntrustedService_PageContentsUpdated_ParamsSpec.$, null, impl.pageContentsUpdated.bind(impl), false);
        this.helper_internal_.registerHandler(2, OcrUntrustedService_ViewportUpdated_ParamsSpec.$, null, impl.viewportUpdated.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class OcrUntrustedService {
    static get $interfaceName() {
        return "ash.media_app_ui.mojom.OcrUntrustedService";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new OcrUntrustedServiceRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the OcrUntrustedService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OcrUntrustedServiceCallbackRouter {
    helper_internal_;
    $;
    router_;
    pageMetadataUpdated;
    pageContentsUpdated;
    viewportUpdated;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(OcrUntrustedServiceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.pageMetadataUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, OcrUntrustedService_PageMetadataUpdated_ParamsSpec.$, null, this.pageMetadataUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.pageContentsUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, OcrUntrustedService_PageContentsUpdated_ParamsSpec.$, null, this.pageContentsUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.viewportUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, OcrUntrustedService_ViewportUpdated_ParamsSpec.$, null, this.viewportUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class OcrUntrustedPagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.media_app_ui.mojom.OcrUntrustedPage', scope);
    }
}
export class OcrUntrustedPageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(OcrUntrustedPagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    requestBitmap(requestedPageId) {
        return this.proxy.sendMessage(0, OcrUntrustedPage_RequestBitmap_ParamsSpec.$, OcrUntrustedPage_RequestBitmap_ResponseParamsSpec.$, [
            requestedPageId
        ], false);
    }
    setViewport(viewportBox) {
        this.proxy.sendMessage(1, OcrUntrustedPage_SetViewport_ParamsSpec.$, null, [
            viewportBox
        ], false);
    }
    setPdfOcrEnabled(enabled) {
        this.proxy.sendMessage(2, OcrUntrustedPage_SetPdfOcrEnabled_ParamsSpec.$, null, [
            enabled
        ], false);
    }
}
;
/**
 * An object which receives request messages for the OcrUntrustedPage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class OcrUntrustedPageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(OcrUntrustedPageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, OcrUntrustedPage_RequestBitmap_ParamsSpec.$, OcrUntrustedPage_RequestBitmap_ResponseParamsSpec.$, impl.requestBitmap.bind(impl), false);
        this.helper_internal_.registerHandler(1, OcrUntrustedPage_SetViewport_ParamsSpec.$, null, impl.setViewport.bind(impl), false);
        this.helper_internal_.registerHandler(2, OcrUntrustedPage_SetPdfOcrEnabled_ParamsSpec.$, null, impl.setPdfOcrEnabled.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class OcrUntrustedPage {
    static get $interfaceName() {
        return "ash.media_app_ui.mojom.OcrUntrustedPage";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new OcrUntrustedPageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the OcrUntrustedPage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class OcrUntrustedPageCallbackRouter {
    helper_internal_;
    $;
    router_;
    requestBitmap;
    setViewport;
    setPdfOcrEnabled;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(OcrUntrustedPageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.requestBitmap =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, OcrUntrustedPage_RequestBitmap_ParamsSpec.$, OcrUntrustedPage_RequestBitmap_ResponseParamsSpec.$, this.requestBitmap.createReceiverHandler(true /* expectsResponse */), false);
        this.setViewport =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, OcrUntrustedPage_SetViewport_ParamsSpec.$, null, this.setViewport.createReceiverHandler(false /* expectsResponse */), false);
        this.setPdfOcrEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, OcrUntrustedPage_SetPdfOcrEnabled_ParamsSpec.$, null, this.setPdfOcrEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class MahiUntrustedServicePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.media_app_ui.mojom.MahiUntrustedService', scope);
    }
}
export class MahiUntrustedServiceRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(MahiUntrustedServicePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onPdfLoaded() {
        this.proxy.sendMessage(0, MahiUntrustedService_OnPdfLoaded_ParamsSpec.$, null, [], false);
    }
    onPdfFileNameUpdated(newName) {
        this.proxy.sendMessage(1, MahiUntrustedService_OnPdfFileNameUpdated_ParamsSpec.$, null, [
            newName
        ], false);
    }
    onPdfContextMenuShow(anchor, selectedText) {
        this.proxy.sendMessage(2, MahiUntrustedService_OnPdfContextMenuShow_ParamsSpec.$, null, [
            anchor,
            selectedText
        ], false);
    }
    onPdfContextMenuHide() {
        this.proxy.sendMessage(3, MahiUntrustedService_OnPdfContextMenuHide_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the MahiUntrustedService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MahiUntrustedServiceReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MahiUntrustedServiceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, MahiUntrustedService_OnPdfLoaded_ParamsSpec.$, null, impl.onPdfLoaded.bind(impl), false);
        this.helper_internal_.registerHandler(1, MahiUntrustedService_OnPdfFileNameUpdated_ParamsSpec.$, null, impl.onPdfFileNameUpdated.bind(impl), false);
        this.helper_internal_.registerHandler(2, MahiUntrustedService_OnPdfContextMenuShow_ParamsSpec.$, null, impl.onPdfContextMenuShow.bind(impl), false);
        this.helper_internal_.registerHandler(3, MahiUntrustedService_OnPdfContextMenuHide_ParamsSpec.$, null, impl.onPdfContextMenuHide.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class MahiUntrustedService {
    static get $interfaceName() {
        return "ash.media_app_ui.mojom.MahiUntrustedService";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new MahiUntrustedServiceRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the MahiUntrustedService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MahiUntrustedServiceCallbackRouter {
    helper_internal_;
    $;
    router_;
    onPdfLoaded;
    onPdfFileNameUpdated;
    onPdfContextMenuShow;
    onPdfContextMenuHide;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MahiUntrustedServiceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onPdfLoaded =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, MahiUntrustedService_OnPdfLoaded_ParamsSpec.$, null, this.onPdfLoaded.createReceiverHandler(false /* expectsResponse */), false);
        this.onPdfFileNameUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, MahiUntrustedService_OnPdfFileNameUpdated_ParamsSpec.$, null, this.onPdfFileNameUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onPdfContextMenuShow =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, MahiUntrustedService_OnPdfContextMenuShow_ParamsSpec.$, null, this.onPdfContextMenuShow.createReceiverHandler(false /* expectsResponse */), false);
        this.onPdfContextMenuHide =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, MahiUntrustedService_OnPdfContextMenuHide_ParamsSpec.$, null, this.onPdfContextMenuHide.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class MahiUntrustedPagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.media_app_ui.mojom.MahiUntrustedPage', scope);
    }
}
export class MahiUntrustedPageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(MahiUntrustedPagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    hidePdfContextMenu() {
        this.proxy.sendMessage(0, MahiUntrustedPage_HidePdfContextMenu_ParamsSpec.$, null, [], false);
    }
    getPdfContent(limit) {
        return this.proxy.sendMessage(1, MahiUntrustedPage_GetPdfContent_ParamsSpec.$, MahiUntrustedPage_GetPdfContent_ResponseParamsSpec.$, [
            limit
        ], false);
    }
}
;
/**
 * An object which receives request messages for the MahiUntrustedPage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MahiUntrustedPageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MahiUntrustedPageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, MahiUntrustedPage_HidePdfContextMenu_ParamsSpec.$, null, impl.hidePdfContextMenu.bind(impl), false);
        this.helper_internal_.registerHandler(1, MahiUntrustedPage_GetPdfContent_ParamsSpec.$, MahiUntrustedPage_GetPdfContent_ResponseParamsSpec.$, impl.getPdfContent.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class MahiUntrustedPage {
    static get $interfaceName() {
        return "ash.media_app_ui.mojom.MahiUntrustedPage";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new MahiUntrustedPageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the MahiUntrustedPage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MahiUntrustedPageCallbackRouter {
    helper_internal_;
    $;
    router_;
    hidePdfContextMenu;
    getPdfContent;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MahiUntrustedPageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.hidePdfContextMenu =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, MahiUntrustedPage_HidePdfContextMenu_ParamsSpec.$, null, this.hidePdfContextMenu.createReceiverHandler(false /* expectsResponse */), false);
        this.getPdfContent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, MahiUntrustedPage_GetPdfContent_ParamsSpec.$, MahiUntrustedPage_GetPdfContent_ResponseParamsSpec.$, this.getPdfContent.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class MantisUntrustedServicePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.media_app_ui.mojom.MantisUntrustedService', scope);
    }
}
export class MantisUntrustedServiceRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(MantisUntrustedServicePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    segmentImage(image, selection) {
        return this.proxy.sendMessage(0, MantisUntrustedService_SegmentImage_ParamsSpec.$, MantisUntrustedService_SegmentImage_ResponseParamsSpec.$, [
            image,
            selection
        ], false);
    }
    generativeFillImage(image, mask, text, seed) {
        return this.proxy.sendMessage(1, MantisUntrustedService_GenerativeFillImage_ParamsSpec.$, MantisUntrustedService_GenerativeFillImage_ResponseParamsSpec.$, [
            image,
            mask,
            text,
            seed
        ], false);
    }
    inpaintImage(image, mask, seed) {
        return this.proxy.sendMessage(2, MantisUntrustedService_InpaintImage_ParamsSpec.$, MantisUntrustedService_InpaintImage_ResponseParamsSpec.$, [
            image,
            mask,
            seed
        ], false);
    }
    outpaintImage(image, mask, seed) {
        return this.proxy.sendMessage(3, MantisUntrustedService_OutpaintImage_ParamsSpec.$, MantisUntrustedService_OutpaintImage_ResponseParamsSpec.$, [
            image,
            mask,
            seed
        ], false);
    }
    classifyImageSafety(image) {
        return this.proxy.sendMessage(4, MantisUntrustedService_ClassifyImageSafety_ParamsSpec.$, MantisUntrustedService_ClassifyImageSafety_ResponseParamsSpec.$, [
            image
        ], false);
    }
    inferSegmentationMode(gesture) {
        return this.proxy.sendMessage(5, MantisUntrustedService_InferSegmentationMode_ParamsSpec.$, MantisUntrustedService_InferSegmentationMode_ResponseParamsSpec.$, [
            gesture
        ], false);
    }
}
;
/**
 * An object which receives request messages for the MantisUntrustedService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MantisUntrustedServiceReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MantisUntrustedServiceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, MantisUntrustedService_SegmentImage_ParamsSpec.$, MantisUntrustedService_SegmentImage_ResponseParamsSpec.$, impl.segmentImage.bind(impl), false);
        this.helper_internal_.registerHandler(1, MantisUntrustedService_GenerativeFillImage_ParamsSpec.$, MantisUntrustedService_GenerativeFillImage_ResponseParamsSpec.$, impl.generativeFillImage.bind(impl), false);
        this.helper_internal_.registerHandler(2, MantisUntrustedService_InpaintImage_ParamsSpec.$, MantisUntrustedService_InpaintImage_ResponseParamsSpec.$, impl.inpaintImage.bind(impl), false);
        this.helper_internal_.registerHandler(3, MantisUntrustedService_OutpaintImage_ParamsSpec.$, MantisUntrustedService_OutpaintImage_ResponseParamsSpec.$, impl.outpaintImage.bind(impl), false);
        this.helper_internal_.registerHandler(4, MantisUntrustedService_ClassifyImageSafety_ParamsSpec.$, MantisUntrustedService_ClassifyImageSafety_ResponseParamsSpec.$, impl.classifyImageSafety.bind(impl), false);
        this.helper_internal_.registerHandler(5, MantisUntrustedService_InferSegmentationMode_ParamsSpec.$, MantisUntrustedService_InferSegmentationMode_ResponseParamsSpec.$, impl.inferSegmentationMode.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class MantisUntrustedService {
    static get $interfaceName() {
        return "ash.media_app_ui.mojom.MantisUntrustedService";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new MantisUntrustedServiceRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the MantisUntrustedService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MantisUntrustedServiceCallbackRouter {
    helper_internal_;
    $;
    router_;
    segmentImage;
    generativeFillImage;
    inpaintImage;
    outpaintImage;
    classifyImageSafety;
    inferSegmentationMode;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MantisUntrustedServiceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.segmentImage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, MantisUntrustedService_SegmentImage_ParamsSpec.$, MantisUntrustedService_SegmentImage_ResponseParamsSpec.$, this.segmentImage.createReceiverHandler(true /* expectsResponse */), false);
        this.generativeFillImage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, MantisUntrustedService_GenerativeFillImage_ParamsSpec.$, MantisUntrustedService_GenerativeFillImage_ResponseParamsSpec.$, this.generativeFillImage.createReceiverHandler(true /* expectsResponse */), false);
        this.inpaintImage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, MantisUntrustedService_InpaintImage_ParamsSpec.$, MantisUntrustedService_InpaintImage_ResponseParamsSpec.$, this.inpaintImage.createReceiverHandler(true /* expectsResponse */), false);
        this.outpaintImage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, MantisUntrustedService_OutpaintImage_ParamsSpec.$, MantisUntrustedService_OutpaintImage_ResponseParamsSpec.$, this.outpaintImage.createReceiverHandler(true /* expectsResponse */), false);
        this.classifyImageSafety =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, MantisUntrustedService_ClassifyImageSafety_ParamsSpec.$, MantisUntrustedService_ClassifyImageSafety_ResponseParamsSpec.$, this.classifyImageSafety.createReceiverHandler(true /* expectsResponse */), false);
        this.inferSegmentationMode =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, MantisUntrustedService_InferSegmentationMode_ParamsSpec.$, MantisUntrustedService_InferSegmentationMode_ResponseParamsSpec.$, this.inferSegmentationMode.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class MantisUntrustedPagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.media_app_ui.mojom.MantisUntrustedPage', scope);
    }
}
export class MantisUntrustedPageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(MantisUntrustedPagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    reportMantisProgress(progress) {
        this.proxy.sendMessage(0, MantisUntrustedPage_ReportMantisProgress_ParamsSpec.$, null, [
            progress
        ], false);
    }
}
;
/**
 * An object which receives request messages for the MantisUntrustedPage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MantisUntrustedPageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MantisUntrustedPageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, MantisUntrustedPage_ReportMantisProgress_ParamsSpec.$, null, impl.reportMantisProgress.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class MantisUntrustedPage {
    static get $interfaceName() {
        return "ash.media_app_ui.mojom.MantisUntrustedPage";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new MantisUntrustedPageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the MantisUntrustedPage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MantisUntrustedPageCallbackRouter {
    helper_internal_;
    $;
    router_;
    reportMantisProgress;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MantisUntrustedPageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.reportMantisProgress =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, MantisUntrustedPage_ReportMantisProgress_ParamsSpec.$, null, this.reportMantisProgress.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const PageMetadataSpec = { $: {} };
export const UntrustedServiceFactory_CreateOcrUntrustedService_ParamsSpec = { $: {} };
export const UntrustedServiceFactory_CreateMahiUntrustedService_ParamsSpec = { $: {} };
export const UntrustedServiceFactory_IsMantisAvailable_ParamsSpec = { $: {} };
export const UntrustedServiceFactory_IsMantisAvailable_ResponseParamsSpec = { $: {} };
export const UntrustedServiceFactory_CreateMantisUntrustedService_ParamsSpec = { $: {} };
export const UntrustedServiceFactory_CreateMantisUntrustedService_ResponseParamsSpec = { $: {} };
export const OcrUntrustedService_PageMetadataUpdated_ParamsSpec = { $: {} };
export const OcrUntrustedService_PageContentsUpdated_ParamsSpec = { $: {} };
export const OcrUntrustedService_ViewportUpdated_ParamsSpec = { $: {} };
export const OcrUntrustedPage_RequestBitmap_ParamsSpec = { $: {} };
export const OcrUntrustedPage_RequestBitmap_ResponseParamsSpec = { $: {} };
export const OcrUntrustedPage_SetViewport_ParamsSpec = { $: {} };
export const OcrUntrustedPage_SetPdfOcrEnabled_ParamsSpec = { $: {} };
export const MahiUntrustedService_OnPdfLoaded_ParamsSpec = { $: {} };
export const MahiUntrustedService_OnPdfFileNameUpdated_ParamsSpec = { $: {} };
export const MahiUntrustedService_OnPdfContextMenuShow_ParamsSpec = { $: {} };
export const MahiUntrustedService_OnPdfContextMenuHide_ParamsSpec = { $: {} };
export const MahiUntrustedPage_HidePdfContextMenu_ParamsSpec = { $: {} };
export const MahiUntrustedPage_GetPdfContent_ParamsSpec = { $: {} };
export const MahiUntrustedPage_GetPdfContent_ResponseParamsSpec = { $: {} };
export const MantisUntrustedService_SegmentImage_ParamsSpec = { $: {} };
export const MantisUntrustedService_SegmentImage_ResponseParamsSpec = { $: {} };
export const MantisUntrustedService_GenerativeFillImage_ParamsSpec = { $: {} };
export const MantisUntrustedService_GenerativeFillImage_ResponseParamsSpec = { $: {} };
export const MantisUntrustedService_InpaintImage_ParamsSpec = { $: {} };
export const MantisUntrustedService_InpaintImage_ResponseParamsSpec = { $: {} };
export const MantisUntrustedService_OutpaintImage_ParamsSpec = { $: {} };
export const MantisUntrustedService_OutpaintImage_ResponseParamsSpec = { $: {} };
export const MantisUntrustedService_ClassifyImageSafety_ParamsSpec = { $: {} };
export const MantisUntrustedService_ClassifyImageSafety_ResponseParamsSpec = { $: {} };
export const MantisUntrustedService_InferSegmentationMode_ParamsSpec = { $: {} };
export const MantisUntrustedService_InferSegmentationMode_ResponseParamsSpec = { $: {} };
export const MantisUntrustedPage_ReportMantisProgress_ParamsSpec = { $: {} };
export const MantisUntrustedServiceResultSpec = { $: {} };
mojo.internal.Struct(PageMetadataSpec.$, 'PageMetadata', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('rect', 8, 0, gfx_mojom_RectFSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(UntrustedServiceFactory_CreateOcrUntrustedService_ParamsSpec.$, 'UntrustedServiceFactory_CreateOcrUntrustedService_Params', [
    mojo.internal.StructField('receiver', 0, 0, mojo.internal.InterfaceRequest(OcrUntrustedServicePendingReceiver), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('page', 4, 0, mojo.internal.InterfaceProxy(OcrUntrustedPageRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(UntrustedServiceFactory_CreateMahiUntrustedService_ParamsSpec.$, 'UntrustedServiceFactory_CreateMahiUntrustedService_Params', [
    mojo.internal.StructField('receiver', 0, 0, mojo.internal.InterfaceRequest(MahiUntrustedServicePendingReceiver), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('page', 4, 0, mojo.internal.InterfaceProxy(MahiUntrustedPageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('fileName', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(UntrustedServiceFactory_IsMantisAvailable_ParamsSpec.$, 'UntrustedServiceFactory_IsMantisAvailable_Params', [], [[0, 8],]);
mojo.internal.Struct(UntrustedServiceFactory_IsMantisAvailable_ResponseParamsSpec.$, 'UntrustedServiceFactory_IsMantisAvailable_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(UntrustedServiceFactory_CreateMantisUntrustedService_ParamsSpec.$, 'UntrustedServiceFactory_CreateMantisUntrustedService_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(MantisUntrustedPageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('dlcUuid', 8, 0, mojoBase_mojom_UuidSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(UntrustedServiceFactory_CreateMantisUntrustedService_ResponseParamsSpec.$, 'UntrustedServiceFactory_CreateMantisUntrustedService_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, MantisUntrustedServiceResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(OcrUntrustedService_PageMetadataUpdated_ParamsSpec.$, 'OcrUntrustedService_PageMetadataUpdated_Params', [
    mojo.internal.StructField('pageMetadata', 0, 0, mojo.internal.Array(PageMetadataSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(OcrUntrustedService_PageContentsUpdated_ParamsSpec.$, 'OcrUntrustedService_PageContentsUpdated_Params', [
    mojo.internal.StructField('dirtyPageId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(OcrUntrustedService_ViewportUpdated_ParamsSpec.$, 'OcrUntrustedService_ViewportUpdated_Params', [
    mojo.internal.StructField('viewportBox', 0, 0, gfx_mojom_RectFSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('scaleFactor', 8, 0, mojo.internal.Float, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(OcrUntrustedPage_RequestBitmap_ParamsSpec.$, 'OcrUntrustedPage_RequestBitmap_Params', [
    mojo.internal.StructField('requestedPageId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(OcrUntrustedPage_RequestBitmap_ResponseParamsSpec.$, 'OcrUntrustedPage_RequestBitmap_ResponseParams', [
    mojo.internal.StructField('page', 0, 0, skia_mojom_BitmapN32Spec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(OcrUntrustedPage_SetViewport_ParamsSpec.$, 'OcrUntrustedPage_SetViewport_Params', [
    mojo.internal.StructField('viewportBox', 0, 0, gfx_mojom_RectFSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(OcrUntrustedPage_SetPdfOcrEnabled_ParamsSpec.$, 'OcrUntrustedPage_SetPdfOcrEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MahiUntrustedService_OnPdfLoaded_ParamsSpec.$, 'MahiUntrustedService_OnPdfLoaded_Params', [], [[0, 8],]);
mojo.internal.Struct(MahiUntrustedService_OnPdfFileNameUpdated_ParamsSpec.$, 'MahiUntrustedService_OnPdfFileNameUpdated_Params', [
    mojo.internal.StructField('newName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MahiUntrustedService_OnPdfContextMenuShow_ParamsSpec.$, 'MahiUntrustedService_OnPdfContextMenuShow_Params', [
    mojo.internal.StructField('anchor', 0, 0, gfx_mojom_RectFSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('selectedText', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(MahiUntrustedService_OnPdfContextMenuHide_ParamsSpec.$, 'MahiUntrustedService_OnPdfContextMenuHide_Params', [], [[0, 8],]);
mojo.internal.Struct(MahiUntrustedPage_HidePdfContextMenu_ParamsSpec.$, 'MahiUntrustedPage_HidePdfContextMenu_Params', [], [[0, 8],]);
mojo.internal.Struct(MahiUntrustedPage_GetPdfContent_ParamsSpec.$, 'MahiUntrustedPage_GetPdfContent_Params', [
    mojo.internal.StructField('limit', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MahiUntrustedPage_GetPdfContent_ResponseParamsSpec.$, 'MahiUntrustedPage_GetPdfContent_ResponseParams', [
    mojo.internal.StructField('content', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MantisUntrustedService_SegmentImage_ParamsSpec.$, 'MantisUntrustedService_SegmentImage_Params', [
    mojo.internal.StructField('image', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('selection', 8, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(MantisUntrustedService_SegmentImage_ResponseParamsSpec.$, 'MantisUntrustedService_SegmentImage_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mantis_mojom_MantisResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(MantisUntrustedService_GenerativeFillImage_ParamsSpec.$, 'MantisUntrustedService_GenerativeFillImage_Params', [
    mojo.internal.StructField('image', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('mask', 8, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('text', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('seed', 24, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(MantisUntrustedService_GenerativeFillImage_ResponseParamsSpec.$, 'MantisUntrustedService_GenerativeFillImage_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mantis_mojom_MantisResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(MantisUntrustedService_InpaintImage_ParamsSpec.$, 'MantisUntrustedService_InpaintImage_Params', [
    mojo.internal.StructField('image', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('mask', 8, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('seed', 16, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(MantisUntrustedService_InpaintImage_ResponseParamsSpec.$, 'MantisUntrustedService_InpaintImage_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mantis_mojom_MantisResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(MantisUntrustedService_OutpaintImage_ParamsSpec.$, 'MantisUntrustedService_OutpaintImage_Params', [
    mojo.internal.StructField('image', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('mask', 8, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('seed', 16, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(MantisUntrustedService_OutpaintImage_ResponseParamsSpec.$, 'MantisUntrustedService_OutpaintImage_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, mantis_mojom_MantisResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(MantisUntrustedService_ClassifyImageSafety_ParamsSpec.$, 'MantisUntrustedService_ClassifyImageSafety_Params', [
    mojo.internal.StructField('image', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MantisUntrustedService_ClassifyImageSafety_ResponseParamsSpec.$, 'MantisUntrustedService_ClassifyImageSafety_ResponseParams', [
    mojo.internal.StructField('verdict', 0, 0, mantis_mojom_SafetyClassifierVerdictSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MantisUntrustedService_InferSegmentationMode_ParamsSpec.$, 'MantisUntrustedService_InferSegmentationMode_Params', [
    mojo.internal.StructField('gesture', 0, 0, mojo.internal.Array(mantis_mojom_TouchPointSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MantisUntrustedService_InferSegmentationMode_ResponseParamsSpec.$, 'MantisUntrustedService_InferSegmentationMode_ResponseParams', [
    mojo.internal.StructField('mode', 0, 0, mantis_mojom_SegmentationModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MantisUntrustedPage_ReportMantisProgress_ParamsSpec.$, 'MantisUntrustedPage_ReportMantisProgress_Params', [
    mojo.internal.StructField('progress', 0, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Union(MantisUntrustedServiceResultSpec.$, 'MantisUntrustedServiceResult', {
    'service': {
        'ordinal': 0,
        'type': mojo.internal.InterfaceProxy(MantisUntrustedServiceRemote),
    },
    'error': {
        'ordinal': 1,
        'type': mantis_mojom_InitializeResultSpec.$,
    },
});
export var MantisUntrustedServiceResultFieldTags;
(function (MantisUntrustedServiceResultFieldTags) {
    MantisUntrustedServiceResultFieldTags[MantisUntrustedServiceResultFieldTags["SERVICE"] = 0] = "SERVICE";
    MantisUntrustedServiceResultFieldTags[MantisUntrustedServiceResultFieldTags["ERROR"] = 1] = "ERROR";
})(MantisUntrustedServiceResultFieldTags || (MantisUntrustedServiceResultFieldTags = {}));
export function whichMantisUntrustedServiceResult(u) {
    if (u.service !== null && u.service !== undefined) {
        return MantisUntrustedServiceResultFieldTags.SERVICE;
    }
    if (u.error !== null && u.error !== undefined) {
        return MantisUntrustedServiceResultFieldTags.ERROR;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
