// chromeos/services/machine_learning/public/mojom/text_classifier.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { TimeSpec as mojoBase_mojom_TimeSpec } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
export const AnnotationUsecaseSpec = { $: mojo.internal.Enum() };
export var AnnotationUsecase;
(function (AnnotationUsecase) {
    AnnotationUsecase[AnnotationUsecase["MIN_VALUE"] = 0] = "MIN_VALUE";
    AnnotationUsecase[AnnotationUsecase["MAX_VALUE"] = 1] = "MAX_VALUE";
    AnnotationUsecase[AnnotationUsecase["ANNOTATION_USECASE_SMART"] = 0] = "ANNOTATION_USECASE_SMART";
    AnnotationUsecase[AnnotationUsecase["ANNOTATION_USECASE_RAW"] = 1] = "ANNOTATION_USECASE_RAW";
})(AnnotationUsecase || (AnnotationUsecase = {}));
export class TextClassifierPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'chromeos.machine_learning.mojom.TextClassifier', scope);
    }
}
export class TextClassifierRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(TextClassifierPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    annotate(request) {
        return this.proxy.sendMessage(0, TextClassifier_Annotate_ParamsSpec.$, TextClassifier_Annotate_ResponseParamsSpec.$, [
            request
        ], false);
    }
    findLanguages(text) {
        return this.proxy.sendMessage(2, TextClassifier_FindLanguages_ParamsSpec.$, TextClassifier_FindLanguages_ResponseParamsSpec.$, [
            text
        ], false);
    }
    rEMOVED1(request) {
        return this.proxy.sendMessage(1, TextClassifier_REMOVED_1_ParamsSpec.$, TextClassifier_REMOVED_1_ResponseParamsSpec.$, [
            request
        ], false);
    }
}
;
/**
 * An object which receives request messages for the TextClassifier
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TextClassifierReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TextClassifierRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, TextClassifier_Annotate_ParamsSpec.$, TextClassifier_Annotate_ResponseParamsSpec.$, impl.annotate.bind(impl), false);
        this.helper_internal_.registerHandler(2, TextClassifier_FindLanguages_ParamsSpec.$, TextClassifier_FindLanguages_ResponseParamsSpec.$, impl.findLanguages.bind(impl), false);
        this.helper_internal_.registerHandler(1, TextClassifier_REMOVED_1_ParamsSpec.$, TextClassifier_REMOVED_1_ResponseParamsSpec.$, impl.rEMOVED1.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class TextClassifier {
    static get $interfaceName() {
        return "chromeos.machine_learning.mojom.TextClassifier";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new TextClassifierRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the TextClassifier
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TextClassifierCallbackRouter {
    helper_internal_;
    $;
    router_;
    annotate;
    findLanguages;
    rEMOVED1;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(TextClassifierRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.annotate =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, TextClassifier_Annotate_ParamsSpec.$, TextClassifier_Annotate_ResponseParamsSpec.$, this.annotate.createReceiverHandler(true /* expectsResponse */), false);
        this.findLanguages =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, TextClassifier_FindLanguages_ParamsSpec.$, TextClassifier_FindLanguages_ResponseParamsSpec.$, this.findLanguages.createReceiverHandler(true /* expectsResponse */), false);
        this.rEMOVED1 =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, TextClassifier_REMOVED_1_ParamsSpec.$, TextClassifier_REMOVED_1_ResponseParamsSpec.$, this.rEMOVED1.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const TextEntitySpec = { $: {} };
export const TextAnnotationSpec = { $: {} };
export const TextAnnotationRequestSpec = { $: {} };
export const CodepointSpanSpec = { $: {} };
export const TextLanguageSpec = { $: {} };
export const REMOVED_TextSuggestSelectionRequestSpec = { $: {} };
export const TextClassifier_Annotate_ParamsSpec = { $: {} };
export const TextClassifier_Annotate_ResponseParamsSpec = { $: {} };
export const TextClassifier_FindLanguages_ParamsSpec = { $: {} };
export const TextClassifier_FindLanguages_ResponseParamsSpec = { $: {} };
export const TextClassifier_REMOVED_1_ParamsSpec = { $: {} };
export const TextClassifier_REMOVED_1_ResponseParamsSpec = { $: {} };
export const TextEntityDataSpec = { $: {} };
mojo.internal.Struct(TextEntitySpec.$, 'TextEntity', [
    mojo.internal.StructField('name', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('confidenceScore', 8, 0, mojo.internal.Float, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('data', 16, 0, TextEntityDataSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(TextAnnotationSpec.$, 'TextAnnotation', [
    mojo.internal.StructField('startOffset', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('endOffset', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('entities', 8, 0, mojo.internal.Array(TextEntitySpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(TextAnnotationRequestSpec.$, 'TextAnnotationRequest', [
    mojo.internal.StructField('text', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('defaultLocales', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('detectedTextLanguageTags', 16, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('annotationUsecase', 24, 0, AnnotationUsecaseSpec.$, AnnotationUsecase.ANNOTATION_USECASE_SMART, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('referenceTime', 32, 0, mojoBase_mojom_TimeSpec.$, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('referenceTimezone', 40, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('enabledEntities', 48, 0, mojo.internal.Array(mojo.internal.String, false), null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('triggerDictionaryOnBeginnerWords', 28, 0, mojo.internal.Bool, false, false /* nullable */, 1, undefined, undefined),
], [[0, 64], [1, 64],]);
mojo.internal.Struct(CodepointSpanSpec.$, 'CodepointSpan', [
    mojo.internal.StructField('startOffset', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('endOffset', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TextLanguageSpec.$, 'TextLanguage', [
    mojo.internal.StructField('locale', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('confidence', 8, 0, mojo.internal.Float, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(REMOVED_TextSuggestSelectionRequestSpec.$, 'REMOVED_TextSuggestSelectionRequest', [
    mojo.internal.StructField('text', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('userSelection', 8, 0, CodepointSpanSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('defaultLocales', 16, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('detectedTextLanguageTags', 24, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('annotationUsecase', 32, 0, AnnotationUsecaseSpec.$, AnnotationUsecase.ANNOTATION_USECASE_SMART, false /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(TextClassifier_Annotate_ParamsSpec.$, 'TextClassifier_Annotate_Params', [
    mojo.internal.StructField('request', 0, 0, TextAnnotationRequestSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TextClassifier_Annotate_ResponseParamsSpec.$, 'TextClassifier_Annotate_ResponseParams', [
    mojo.internal.StructField('outputs', 0, 0, mojo.internal.Array(TextAnnotationSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TextClassifier_FindLanguages_ParamsSpec.$, 'TextClassifier_FindLanguages_Params', [
    mojo.internal.StructField('text', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TextClassifier_FindLanguages_ResponseParamsSpec.$, 'TextClassifier_FindLanguages_ResponseParams', [
    mojo.internal.StructField('outputs', 0, 0, mojo.internal.Array(TextLanguageSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TextClassifier_REMOVED_1_ParamsSpec.$, 'TextClassifier_REMOVED_1_Params', [
    mojo.internal.StructField('request', 0, 0, REMOVED_TextSuggestSelectionRequestSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TextClassifier_REMOVED_1_ResponseParamsSpec.$, 'TextClassifier_REMOVED_1_ResponseParams', [
    mojo.internal.StructField('outputs', 0, 0, CodepointSpanSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Union(TextEntityDataSpec.$, 'TextEntityData', {
    'numericValue': {
        'ordinal': 0,
        'type': mojo.internal.Double,
    },
    'stringValue': {
        'ordinal': 1,
        'type': mojo.internal.String,
    },
});
export var TextEntityDataFieldTags;
(function (TextEntityDataFieldTags) {
    TextEntityDataFieldTags[TextEntityDataFieldTags["NUMERIC_VALUE"] = 0] = "NUMERIC_VALUE";
    TextEntityDataFieldTags[TextEntityDataFieldTags["STRING_VALUE"] = 1] = "STRING_VALUE";
})(TextEntityDataFieldTags || (TextEntityDataFieldTags = {}));
export function whichTextEntityData(u) {
    if (u.numericValue !== null && u.numericValue !== undefined) {
        return TextEntityDataFieldTags.NUMERIC_VALUE;
    }
    if (u.stringValue !== null && u.stringValue !== undefined) {
        return TextEntityDataFieldTags.STRING_VALUE;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
