// chromeos/ash/components/mantis/mojom/mantis_service.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { MantisProcessorPendingReceiver as mantis_mojom_MantisProcessorPendingReceiver } from './mantis_processor.mojom-webui.js';
import { TextClassifierRemote as chromeos_machineLearning_mojom_TextClassifierRemote } from './text_classifier.mojom-webui.js';
import { UuidSpec as mojoBase_mojom_UuidSpec } from '//resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js';
export const MantisFeatureStatusSpec = { $: mojo.internal.Enum() };
export var MantisFeatureStatus;
(function (MantisFeatureStatus) {
    MantisFeatureStatus[MantisFeatureStatus["MIN_VALUE"] = 0] = "MIN_VALUE";
    MantisFeatureStatus[MantisFeatureStatus["MAX_VALUE"] = 2] = "MAX_VALUE";
    MantisFeatureStatus[MantisFeatureStatus["kDeviceNotSupported"] = 0] = "kDeviceNotSupported";
    MantisFeatureStatus[MantisFeatureStatus["kARCVMDisabled"] = 1] = "kARCVMDisabled";
    MantisFeatureStatus[MantisFeatureStatus["kAvailable"] = 2] = "kAvailable";
})(MantisFeatureStatus || (MantisFeatureStatus = {}));
export const InitializeResultSpec = { $: mojo.internal.Enum() };
export var InitializeResult;
(function (InitializeResult) {
    InitializeResult[InitializeResult["MIN_VALUE"] = 0] = "MIN_VALUE";
    InitializeResult[InitializeResult["MAX_VALUE"] = 3] = "MAX_VALUE";
    InitializeResult[InitializeResult["kSuccess"] = 0] = "kSuccess";
    InitializeResult[InitializeResult["kGpuBlocked"] = 1] = "kGpuBlocked";
    InitializeResult[InitializeResult["kFailedToLoadLibrary"] = 2] = "kFailedToLoadLibrary";
    InitializeResult[InitializeResult["kFailedToLoadSafetyService"] = 3] = "kFailedToLoadSafetyService";
})(InitializeResult || (InitializeResult = {}));
export class PlatformModelProgressObserverPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'mantis.mojom.PlatformModelProgressObserver', scope);
    }
}
export class PlatformModelProgressObserverRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PlatformModelProgressObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    progress(progress) {
        this.proxy.sendMessage(0, PlatformModelProgressObserver_Progress_ParamsSpec.$, null, [
            progress
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PlatformModelProgressObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PlatformModelProgressObserverReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PlatformModelProgressObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PlatformModelProgressObserver_Progress_ParamsSpec.$, null, impl.progress.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PlatformModelProgressObserver {
    static get $interfaceName() {
        return "mantis.mojom.PlatformModelProgressObserver";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PlatformModelProgressObserverRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PlatformModelProgressObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PlatformModelProgressObserverCallbackRouter {
    helper_internal_;
    $;
    router_;
    progress;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PlatformModelProgressObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.progress =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PlatformModelProgressObserver_Progress_ParamsSpec.$, null, this.progress.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class MantisServicePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'mantis.mojom.MantisService', scope);
    }
}
export class MantisServiceRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(MantisServicePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    getMantisFeatureStatus() {
        return this.proxy.sendMessage(1, MantisService_GetMantisFeatureStatus_ParamsSpec.$, MantisService_GetMantisFeatureStatus_ResponseParamsSpec.$, [], false);
    }
    initialize(progressObserver, processor, dlcUuid, textClassifier) {
        return this.proxy.sendMessage(0, MantisService_Initialize_ParamsSpec.$, MantisService_Initialize_ResponseParamsSpec.$, [
            progressObserver,
            processor,
            dlcUuid,
            textClassifier
        ], false);
    }
}
;
/**
 * An object which receives request messages for the MantisService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MantisServiceReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MantisServiceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(1, MantisService_GetMantisFeatureStatus_ParamsSpec.$, MantisService_GetMantisFeatureStatus_ResponseParamsSpec.$, impl.getMantisFeatureStatus.bind(impl), false);
        this.helper_internal_.registerHandler(0, MantisService_Initialize_ParamsSpec.$, MantisService_Initialize_ResponseParamsSpec.$, impl.initialize.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class MantisService {
    static get $interfaceName() {
        return "mantis.mojom.MantisService";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new MantisServiceRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the MantisService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MantisServiceCallbackRouter {
    helper_internal_;
    $;
    router_;
    getMantisFeatureStatus;
    initialize;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MantisServiceRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.getMantisFeatureStatus =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, MantisService_GetMantisFeatureStatus_ParamsSpec.$, MantisService_GetMantisFeatureStatus_ResponseParamsSpec.$, this.getMantisFeatureStatus.createReceiverHandler(true /* expectsResponse */), false);
        this.initialize =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, MantisService_Initialize_ParamsSpec.$, MantisService_Initialize_ResponseParamsSpec.$, this.initialize.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const PlatformModelProgressObserver_Progress_ParamsSpec = { $: {} };
export const MantisService_GetMantisFeatureStatus_ParamsSpec = { $: {} };
export const MantisService_GetMantisFeatureStatus_ResponseParamsSpec = { $: {} };
export const MantisService_Initialize_ParamsSpec = { $: {} };
export const MantisService_Initialize_ResponseParamsSpec = { $: {} };
mojo.internal.Struct(PlatformModelProgressObserver_Progress_ParamsSpec.$, 'PlatformModelProgressObserver_Progress_Params', [
    mojo.internal.StructField('progress', 0, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MantisService_GetMantisFeatureStatus_ParamsSpec.$, 'MantisService_GetMantisFeatureStatus_Params', [], [[0, 8],]);
mojo.internal.Struct(MantisService_GetMantisFeatureStatus_ResponseParamsSpec.$, 'MantisService_GetMantisFeatureStatus_ResponseParams', [
    mojo.internal.StructField('status', 0, 0, MantisFeatureStatusSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MantisService_Initialize_ParamsSpec.$, 'MantisService_Initialize_Params', [
    mojo.internal.StructField('progressObserver', 0, 0, mojo.internal.InterfaceProxy(PlatformModelProgressObserverRemote), null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('processor', 8, 0, mojo.internal.InterfaceRequest(mantis_mojom_MantisProcessorPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('dlcUuid', 16, 0, mojoBase_mojom_UuidSpec.$, null, true /* nullable */, 3, undefined, undefined),
    mojo.internal.StructField('textClassifier', 24, 0, mojo.internal.InterfaceProxy(chromeos_machineLearning_mojom_TextClassifierRemote), null, true /* nullable */, 4, undefined, undefined),
], [[0, 24], [3, 32], [4, 40],]);
mojo.internal.Struct(MantisService_Initialize_ResponseParamsSpec.$, 'MantisService_Initialize_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, InitializeResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
