// chromeos/ash/components/mantis/mojom/mantis_processor.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
export const MantisErrorSpec = { $: mojo.internal.Enum() };
export var MantisError;
(function (MantisError) {
    MantisError[MantisError["MIN_VALUE"] = 0] = "MIN_VALUE";
    MantisError[MantisError["MAX_VALUE"] = 7] = "MAX_VALUE";
    MantisError[MantisError["kUnknownError"] = 0] = "kUnknownError";
    MantisError[MantisError["kProcessorNotInitialized"] = 1] = "kProcessorNotInitialized";
    MantisError[MantisError["kInputError"] = 2] = "kInputError";
    MantisError[MantisError["kProcessFailed"] = 3] = "kProcessFailed";
    MantisError[MantisError["kMissingSegmenter"] = 4] = "kMissingSegmenter";
    MantisError[MantisError["kInputSafetyError"] = 5] = "kInputSafetyError";
    MantisError[MantisError["kOutputSafetyError"] = 6] = "kOutputSafetyError";
    MantisError[MantisError["kPromptSafetyError"] = 7] = "kPromptSafetyError";
})(MantisError || (MantisError = {}));
export const SafetyClassifierVerdictSpec = { $: mojo.internal.Enum() };
export var SafetyClassifierVerdict;
(function (SafetyClassifierVerdict) {
    SafetyClassifierVerdict[SafetyClassifierVerdict["MIN_VALUE"] = 0] = "MIN_VALUE";
    SafetyClassifierVerdict[SafetyClassifierVerdict["MAX_VALUE"] = 5] = "MAX_VALUE";
    SafetyClassifierVerdict[SafetyClassifierVerdict["kPass"] = 0] = "kPass";
    SafetyClassifierVerdict[SafetyClassifierVerdict["kFail"] = 1] = "kFail";
    SafetyClassifierVerdict[SafetyClassifierVerdict["kFailedText"] = 2] = "kFailedText";
    SafetyClassifierVerdict[SafetyClassifierVerdict["kFailedImage"] = 3] = "kFailedImage";
    SafetyClassifierVerdict[SafetyClassifierVerdict["kServiceNotAvailable"] = 4] = "kServiceNotAvailable";
    SafetyClassifierVerdict[SafetyClassifierVerdict["kNoInternetConnection"] = 5] = "kNoInternetConnection";
})(SafetyClassifierVerdict || (SafetyClassifierVerdict = {}));
export const SegmentationModeSpec = { $: mojo.internal.Enum() };
export var SegmentationMode;
(function (SegmentationMode) {
    SegmentationMode[SegmentationMode["MIN_VALUE"] = 0] = "MIN_VALUE";
    SegmentationMode[SegmentationMode["MAX_VALUE"] = 1] = "MAX_VALUE";
    SegmentationMode[SegmentationMode["kScribble"] = 0] = "kScribble";
    SegmentationMode[SegmentationMode["kLasso"] = 1] = "kLasso";
})(SegmentationMode || (SegmentationMode = {}));
export class MantisProcessorPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'mantis.mojom.MantisProcessor', scope);
    }
}
export class MantisProcessorRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(MantisProcessorPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    inpainting(image, mask, seed) {
        return this.proxy.sendMessage(0, MantisProcessor_Inpainting_ParamsSpec.$, MantisProcessor_Inpainting_ResponseParamsSpec.$, [
            image,
            mask,
            seed
        ], false);
    }
    generativeFill(image, mask, seed, prompt) {
        return this.proxy.sendMessage(1, MantisProcessor_GenerativeFill_ParamsSpec.$, MantisProcessor_GenerativeFill_ResponseParamsSpec.$, [
            image,
            mask,
            seed,
            prompt
        ], false);
    }
    segmentation(image, prior) {
        return this.proxy.sendMessage(2, MantisProcessor_Segmentation_ParamsSpec.$, MantisProcessor_Segmentation_ResponseParamsSpec.$, [
            image,
            prior
        ], false);
    }
    classifyImageSafety(image) {
        return this.proxy.sendMessage(3, MantisProcessor_ClassifyImageSafety_ParamsSpec.$, MantisProcessor_ClassifyImageSafety_ResponseParamsSpec.$, [
            image
        ], false);
    }
    outpainting(image, mask, seed) {
        return this.proxy.sendMessage(4, MantisProcessor_Outpainting_ParamsSpec.$, MantisProcessor_Outpainting_ResponseParamsSpec.$, [
            image,
            mask,
            seed
        ], false);
    }
    inferSegmentationMode(gesture) {
        return this.proxy.sendMessage(5, MantisProcessor_InferSegmentationMode_ParamsSpec.$, MantisProcessor_InferSegmentationMode_ResponseParamsSpec.$, [
            gesture
        ], false);
    }
}
;
/**
 * An object which receives request messages for the MantisProcessor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MantisProcessorReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MantisProcessorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, MantisProcessor_Inpainting_ParamsSpec.$, MantisProcessor_Inpainting_ResponseParamsSpec.$, impl.inpainting.bind(impl), false);
        this.helper_internal_.registerHandler(1, MantisProcessor_GenerativeFill_ParamsSpec.$, MantisProcessor_GenerativeFill_ResponseParamsSpec.$, impl.generativeFill.bind(impl), false);
        this.helper_internal_.registerHandler(2, MantisProcessor_Segmentation_ParamsSpec.$, MantisProcessor_Segmentation_ResponseParamsSpec.$, impl.segmentation.bind(impl), false);
        this.helper_internal_.registerHandler(3, MantisProcessor_ClassifyImageSafety_ParamsSpec.$, MantisProcessor_ClassifyImageSafety_ResponseParamsSpec.$, impl.classifyImageSafety.bind(impl), false);
        this.helper_internal_.registerHandler(4, MantisProcessor_Outpainting_ParamsSpec.$, MantisProcessor_Outpainting_ResponseParamsSpec.$, impl.outpainting.bind(impl), false);
        this.helper_internal_.registerHandler(5, MantisProcessor_InferSegmentationMode_ParamsSpec.$, MantisProcessor_InferSegmentationMode_ResponseParamsSpec.$, impl.inferSegmentationMode.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class MantisProcessor {
    static get $interfaceName() {
        return "mantis.mojom.MantisProcessor";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new MantisProcessorRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the MantisProcessor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MantisProcessorCallbackRouter {
    helper_internal_;
    $;
    router_;
    inpainting;
    generativeFill;
    segmentation;
    classifyImageSafety;
    outpainting;
    inferSegmentationMode;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(MantisProcessorRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.inpainting =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, MantisProcessor_Inpainting_ParamsSpec.$, MantisProcessor_Inpainting_ResponseParamsSpec.$, this.inpainting.createReceiverHandler(true /* expectsResponse */), false);
        this.generativeFill =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, MantisProcessor_GenerativeFill_ParamsSpec.$, MantisProcessor_GenerativeFill_ResponseParamsSpec.$, this.generativeFill.createReceiverHandler(true /* expectsResponse */), false);
        this.segmentation =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, MantisProcessor_Segmentation_ParamsSpec.$, MantisProcessor_Segmentation_ResponseParamsSpec.$, this.segmentation.createReceiverHandler(true /* expectsResponse */), false);
        this.classifyImageSafety =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, MantisProcessor_ClassifyImageSafety_ParamsSpec.$, MantisProcessor_ClassifyImageSafety_ResponseParamsSpec.$, this.classifyImageSafety.createReceiverHandler(true /* expectsResponse */), false);
        this.outpainting =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, MantisProcessor_Outpainting_ParamsSpec.$, MantisProcessor_Outpainting_ResponseParamsSpec.$, this.outpainting.createReceiverHandler(true /* expectsResponse */), false);
        this.inferSegmentationMode =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, MantisProcessor_InferSegmentationMode_ParamsSpec.$, MantisProcessor_InferSegmentationMode_ResponseParamsSpec.$, this.inferSegmentationMode.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const TouchPointSpec = { $: {} };
export const MantisProcessor_Inpainting_ParamsSpec = { $: {} };
export const MantisProcessor_Inpainting_ResponseParamsSpec = { $: {} };
export const MantisProcessor_GenerativeFill_ParamsSpec = { $: {} };
export const MantisProcessor_GenerativeFill_ResponseParamsSpec = { $: {} };
export const MantisProcessor_Segmentation_ParamsSpec = { $: {} };
export const MantisProcessor_Segmentation_ResponseParamsSpec = { $: {} };
export const MantisProcessor_ClassifyImageSafety_ParamsSpec = { $: {} };
export const MantisProcessor_ClassifyImageSafety_ResponseParamsSpec = { $: {} };
export const MantisProcessor_Outpainting_ParamsSpec = { $: {} };
export const MantisProcessor_Outpainting_ResponseParamsSpec = { $: {} };
export const MantisProcessor_InferSegmentationMode_ParamsSpec = { $: {} };
export const MantisProcessor_InferSegmentationMode_ResponseParamsSpec = { $: {} };
export const MantisResultSpec = { $: {} };
mojo.internal.Struct(TouchPointSpec.$, 'TouchPoint', [
    mojo.internal.StructField('x', 0, 0, mojo.internal.Float, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('y', 4, 0, mojo.internal.Float, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MantisProcessor_Inpainting_ParamsSpec.$, 'MantisProcessor_Inpainting_Params', [
    mojo.internal.StructField('image', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('mask', 8, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('seed', 16, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(MantisProcessor_Inpainting_ResponseParamsSpec.$, 'MantisProcessor_Inpainting_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, MantisResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(MantisProcessor_GenerativeFill_ParamsSpec.$, 'MantisProcessor_GenerativeFill_Params', [
    mojo.internal.StructField('image', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('mask', 8, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('seed', 16, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('prompt', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(MantisProcessor_GenerativeFill_ResponseParamsSpec.$, 'MantisProcessor_GenerativeFill_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, MantisResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(MantisProcessor_Segmentation_ParamsSpec.$, 'MantisProcessor_Segmentation_Params', [
    mojo.internal.StructField('image', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('prior', 8, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(MantisProcessor_Segmentation_ResponseParamsSpec.$, 'MantisProcessor_Segmentation_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, MantisResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(MantisProcessor_ClassifyImageSafety_ParamsSpec.$, 'MantisProcessor_ClassifyImageSafety_Params', [
    mojo.internal.StructField('image', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MantisProcessor_ClassifyImageSafety_ResponseParamsSpec.$, 'MantisProcessor_ClassifyImageSafety_ResponseParams', [
    mojo.internal.StructField('verdict', 0, 0, SafetyClassifierVerdictSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MantisProcessor_Outpainting_ParamsSpec.$, 'MantisProcessor_Outpainting_Params', [
    mojo.internal.StructField('image', 0, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('mask', 8, 0, mojo.internal.Array(mojo.internal.Uint8, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('seed', 16, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(MantisProcessor_Outpainting_ResponseParamsSpec.$, 'MantisProcessor_Outpainting_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, MantisResultSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(MantisProcessor_InferSegmentationMode_ParamsSpec.$, 'MantisProcessor_InferSegmentationMode_Params', [
    mojo.internal.StructField('gesture', 0, 0, mojo.internal.Array(TouchPointSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(MantisProcessor_InferSegmentationMode_ResponseParamsSpec.$, 'MantisProcessor_InferSegmentationMode_ResponseParams', [
    mojo.internal.StructField('mode', 0, 0, SegmentationModeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Union(MantisResultSpec.$, 'MantisResult', {
    'error': {
        'ordinal': 0,
        'type': MantisErrorSpec.$,
    },
    'resultImage': {
        'ordinal': 1,
        'type': mojo.internal.Array(mojo.internal.Uint8, false),
    },
});
export var MantisResultFieldTags;
(function (MantisResultFieldTags) {
    MantisResultFieldTags[MantisResultFieldTags["ERROR"] = 0] = "ERROR";
    MantisResultFieldTags[MantisResultFieldTags["RESULT_IMAGE"] = 1] = "RESULT_IMAGE";
})(MantisResultFieldTags || (MantisResultFieldTags = {}));
export function whichMantisResult(u) {
    if (u.error !== null && u.error !== undefined) {
        return MantisResultFieldTags.ERROR;
    }
    if (u.resultImage !== null && u.resultImage !== undefined) {
        return MantisResultFieldTags.RESULT_IMAGE;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
