// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"chrome://resources/ash/common/cr_elements/cros_color_overrides.css.js";import"chrome://resources/ash/common/cr_elements/cr_button/cr_button.js";import"chrome://resources/ash/common/cr_elements/cr_link_row/cr_link_row.js";import"chrome://resources/polymer/v3_0/iron-icon/iron-icon.js";import"./help_resources_icons.html.js";import"./os_feedback_shared.css.js";import{I18nMixin}from"chrome://resources/ash/common/cr_elements/i18n_mixin.js";import{assert}from"chrome://resources/js/assert.js";import{OpenWindowProxyImpl}from"chrome://resources/js/open_window_proxy.js";import{PolymerElement}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./confirmation_page.html.js";import{FeedbackFlowState}from"./feedback_flow.js";import{showScrollingEffects}from"./feedback_utils.js";import{getFeedbackServiceProvider}from"./mojo_interface_provider.js";import{FeedbackAppPostSubmitAction,SendReportStatus}from"./os_feedback_ui.mojom-webui.js";const ConfirmationPageElementBase=I18nMixin(PolymerElement);export class ConfirmationPageElement extends ConfirmationPageElementBase{static get is(){return"confirmation-page"}static get template(){return getTemplate()}static get properties(){return{sendReportStatus:{type:SendReportStatus,readOnly:false,notify:true},isUserLoggedIn:{type:Boolean,readOnly:false,notify:true}}}constructor(){super();this.isFirstAction=true;this.isUserLoggedIn=false;this.feedbackServiceProvider=getFeedbackServiceProvider()}ready(){super.ready();window.addEventListener("beforeunload",(()=>{this.handleEmitMetrics(FeedbackAppPostSubmitAction.kCloseFeedbackApp)}))}isOffline(){return this.sendReportStatus!==null&&this.sendReportStatus===SendReportStatus.kDelayed}getTitle(){if(this.isOffline()){return this.i18n("confirmationTitleOffline")}return this.i18n("confirmationTitleOnline")}getMessage(){if(this.isOffline()){return this.i18n("thankYouNoteOffline")}return this.i18n("thankYouNoteOnline")}handleBackButtonClicked(e){e.stopPropagation();this.dispatchEvent(new CustomEvent("go-back-click",{composed:true,bubbles:true,detail:{currentState:FeedbackFlowState.CONFIRMATION}}));this.handleEmitMetrics(FeedbackAppPostSubmitAction.kSendNewReport)}handleDoneButtonClicked(){this.handleEmitMetrics(FeedbackAppPostSubmitAction.kClickDoneButton);window.close()}handleLinkClicked(e){e.stopPropagation();const currentTarget=e.currentTarget;switch(currentTarget.id){case"diagnostics":this.feedbackServiceProvider.openDiagnosticsApp();this.handleEmitMetrics(FeedbackAppPostSubmitAction.kOpenDiagnosticsApp);break;case"explore":this.feedbackServiceProvider.openExploreApp();this.handleEmitMetrics(FeedbackAppPostSubmitAction.kOpenExploreApp);break;case"chromebookCommunity":OpenWindowProxyImpl.getInstance().openUrl(`https://support.google.com/chromebook/?hl=${this.i18n("language")||"en"}#topic=3399709`);this.handleEmitMetrics(FeedbackAppPostSubmitAction.kOpenChromebookCommunity);break;default:console.warn("unexpected caller id: ",currentTarget.id)}}handleEmitMetrics(action){if(this.isFirstAction){this.isFirstAction=false;this.feedbackServiceProvider.recordPostSubmitAction(action)}}focusPageTitle(){const element=this.shadowRoot.querySelector("#pageTitle");assert(element);element.focus()}onContainerScroll(event){showScrollingEffects(event,this)}}customElements.define(ConfirmationPageElement.is,ConfirmationPageElement);