import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style>:host-context(body.jelly-enabled) .help-content-label{font:var(--cros-headline-1-font)}:host-context(body.jelly-enabled) .help-item a{font:var(--cros-body-1-font)}:host-context(body.jelly-enabled) paper-tooltip::part(tooltip){font:var(--cros-annotation-2-font)}[class~='help-item']:last-of-type{padding-bottom:3px}[hidden]{display:none !important}.help-content-label{color:var(--cros-text-color-secondary);font-size:15px;font-weight:500;line-height:22px;margin:0}.help-item{display:flex;margin:12px 0 0;padding:0 4px 0 4px}.help-item a{align-items:center;color:var(--cros-text-color-primary);display:flex;font-size:14px;font-weight:400;line-height:20px;overflow:hidden;text-decoration:none;text-overflow:ellipsis;white-space:nowrap}.help-item a:focus-visible{outline:2px solid var(--cros-focus-ring-color)}.help-item-icon{padding-inline-end:12px}.no-help-content-details{align-items:center;display:flex;flex-direction:column;justify-content:center;padding-top:16px}.no-help-content-text{color:var(--cros-text-color-secondary);line-height:18px;max-width:200px;text-align:center}#helpContentLabelContainer{align-items:center;display:inline-flex}#helpContentIcon{--cr-tooltip-icon-fill-color:var(--cros-icon-color-secondary);margin-inline-start:6px}#helpContentIcon:focus-visible{border-radius:4px;outline:2px solid var(--cros-focus-ring-color)}#helpContentContainer{overflow:visible;padding-top:32px}iron-icon{--iron-icon-fill-color:var(--cros-text-color-secondary);--iron-icon-height:20px;--iron-icon-width:20px}paper-tooltip::part(tooltip){border-radius:2px;font-family:Roboto,sans-serif;font-size:12px;font-weight:400;line-height:18px;margin-top:-36px;padding:3px 8px}paper-tooltip{--paper-tooltip-background:var(--cros-tooltip-background-color);--paper-tooltip-delay-in:100ms;--paper-tooltip-text-color:var(--cros-tooltip-label-color)}svg{height:158px}</style>
<div id="helpContentContainer">
  <div id="helpContentLabelContainer">
    <h2 class="help-content-label">[[getLabel(searchResult, isOnline)]]</h2>
    <iron-icon icon="os-feedback:info" id="helpContentIcon" tabindex="0"
        hidden$="[[!hasSuggestedHelpContent(searchResult, isOnline)]]"
        aria-labelledby="helpContentLabelTooltip">
    </iron-icon>
    <paper-tooltip for="helpContentIcon" position="right" offset="-20">
      <div id="helpContentLabelTooltip">
        [[i18n('helpContentLabelTooltip')]]
      </div>
    </paper-tooltip>
  </div>
  <template is="dom-if" if="[[!isOnline]]">
    <div class="no-help-content-details">
      <svg id="offlineSvg" preserveAspectRatio="xMidYMid meet" role="img"
          viewBox="0 0 400 168">
        <title>[[i18n('helpContentOfflineAltText')]]</title>
        <use href=
            "//os-feedback/illustrations/illo_network_unavailable.svg#offline">
        </use>
      </svg>
      <div class="no-help-content-text">
        [[i18n('helpContentOfflineMessage')]]
      </div>
    </div>
  </template>
  <template is="dom-if" if="[[isOnline]]">
    <dom-repeat items="[[searchResult.contentList]]">
      <template>
        <div class="help-item">
          <a href="[[getUrl(item)]]" target="_blank"
              on-click="handleHelpContentClicked">
            <iron-icon icon="[[getIcon(item.contentType)]]"
                class="help-item-icon">
            </iron-icon>
            [[getTitle(item)]]
          </a>
        </div>
      </template>
    </dom-repeat>
    <div class="no-help-content-details"
        hidden$="[[!showHelpContentNotAvailableMsg(searchResult)]]">
      <svg id="noContentSvg" preserveAspectRatio="xMidYMid meet" role="img"
          viewBox="0 0 400 168">
        <title>[[i18n('helpContentNotAvailableAltText')]]</title>
        <use href=
            "//os-feedback/illustrations/illo_load_content_error.svg#error">
        </use>
      </svg>
      <div class="no-help-content-text">
        [[i18n('helpContentNotAvailableMessage')]]
      </div>
    </div>
  </template>
</div>
<!--_html_template_end_-->`}