// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./help_resources_icons.html.js";import"/strings.m.js";import"//resources/ash/common/cr_elements/cr_hidden_style.css.js";import"//resources/ash/common/cr_elements/cr_icons.css.js";import"//resources/ash/common/cr_elements/cr_shared_vars.css.js";import"//resources/ash/common/cr_elements/icons.html.js";import"//resources/ash/common/cr_elements/policy/cr_tooltip_icon.js";import"//resources/polymer/v3_0/iron-icon/iron-icon.js";import{I18nMixin}from"//resources/ash/common/cr_elements/i18n_mixin.js";import{strictQuery}from"//resources/ash/common/typescript_utils/strict_query.js";import{PolymerElement}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{getTemplate}from"./help_content.html.js";import{HelpContentType}from"./os_feedback_ui.mojom-webui.js";export const OS_FEEDBACK_TRUSTED_ORIGIN="chrome://os-feedback";const ICON_NAME_FOR_ARTICLE="content-type:article";const ICON_NAME_FOR_FORUM="content-type:forum";const HelpContentElementBase=I18nMixin(PolymerElement);export class HelpContentElement extends HelpContentElementBase{static get is(){return"help-content"}static get template(){return getTemplate()}static get properties(){return{searchResult:{type:Object},isOnline:{type:Boolean}}}constructor(){super();this.isOnline=navigator.onLine;this.searchResult={contentList:[],isQueryEmpty:true,isPopularContent:true}}ready(){super.ready();window.addEventListener("online",(()=>{this.isOnline=true}));window.addEventListener("offline",(()=>{this.isOnline=false}));const helpContent=strictQuery("#helpContentContainer",this.shadowRoot,HTMLElement);const resizeObserver=new ResizeObserver((()=>{window.parent.postMessage({iframeHeight:helpContent.scrollHeight},OS_FEEDBACK_TRUSTED_ORIGIN)}));if(helpContent){resizeObserver.observe(helpContent)}}notifyParent(){}getLabel(){if(!this.isOnline){return this.i18n("popularHelpContent")}if(!this.searchResult.isPopularContent){return this.i18n("suggestedHelpContent")}if(this.searchResult.isQueryEmpty){return this.i18n("popularHelpContent")}return this.i18n("noMatchedResults")}hasSuggestedHelpContent(){return this.isOnline&&!this.searchResult.isPopularContent}showHelpContentNotAvailableMsg(){return this.searchResult.contentList.length===0}getIcon(contentType){switch(contentType){case HelpContentType.kForum:return ICON_NAME_FOR_FORUM;case HelpContentType.kArticle:return ICON_NAME_FOR_ARTICLE;case HelpContentType.kUnknown:return ICON_NAME_FOR_ARTICLE;default:return ICON_NAME_FOR_ARTICLE}}getUrl(helpContent){return helpContent.url.url}getTitle(helpContent){return helpContent.title}handleHelpContentClicked(e){e.stopPropagation();window.parent.postMessage({id:"help-content-clicked"},OS_FEEDBACK_TRUSTED_ORIGIN)}}customElements.define(HelpContentElement.is,HelpContentElement);