// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{mojo}from"//resources/mojo/mojo/public/js/bindings.js";import{BigBufferSpec as mojoBase_mojom_BigBufferSpec}from"//resources/mojo/mojo/public/mojom/base/big_buffer.mojom-webui.js";import{SafeBaseNameSpec as mojoBase_mojom_SafeBaseNameSpec}from"//resources/mojo/mojo/public/mojom/base/safe_base_name.mojom-webui.js";import{String16Spec as mojoBase_mojom_String16Spec}from"//resources/mojo/mojo/public/mojom/base/string16.mojom-webui.js";import{UrlSpec as url_mojom_UrlSpec}from"//resources/mojo/url/mojom/url.mojom-webui.js";export const HelpContentTypeSpec={$:mojo.internal.Enum()};export var HelpContentType;(function(HelpContentType){HelpContentType[HelpContentType["MIN_VALUE"]=0]="MIN_VALUE";HelpContentType[HelpContentType["MAX_VALUE"]=2]="MAX_VALUE";HelpContentType[HelpContentType["kUnknown"]=0]="kUnknown";HelpContentType[HelpContentType["kArticle"]=1]="kArticle";HelpContentType[HelpContentType["kForum"]=2]="kForum"})(HelpContentType||(HelpContentType={}));export const SendReportStatusSpec={$:mojo.internal.Enum()};export var SendReportStatus;(function(SendReportStatus){SendReportStatus[SendReportStatus["MIN_VALUE"]=0]="MIN_VALUE";SendReportStatus[SendReportStatus["MAX_VALUE"]=2]="MAX_VALUE";SendReportStatus[SendReportStatus["kUnknown"]=0]="kUnknown";SendReportStatus[SendReportStatus["kSuccess"]=1]="kSuccess";SendReportStatus[SendReportStatus["kDelayed"]=2]="kDelayed"})(SendReportStatus||(SendReportStatus={}));export const FeedbackAppPostSubmitActionSpec={$:mojo.internal.Enum()};export var FeedbackAppPostSubmitAction;(function(FeedbackAppPostSubmitAction){FeedbackAppPostSubmitAction[FeedbackAppPostSubmitAction["MIN_VALUE"]=0]="MIN_VALUE";FeedbackAppPostSubmitAction[FeedbackAppPostSubmitAction["MAX_VALUE"]=5]="MAX_VALUE";FeedbackAppPostSubmitAction[FeedbackAppPostSubmitAction["kSendNewReport"]=0]="kSendNewReport";FeedbackAppPostSubmitAction[FeedbackAppPostSubmitAction["kClickDoneButton"]=1]="kClickDoneButton";FeedbackAppPostSubmitAction[FeedbackAppPostSubmitAction["kOpenExploreApp"]=2]="kOpenExploreApp";FeedbackAppPostSubmitAction[FeedbackAppPostSubmitAction["kOpenDiagnosticsApp"]=3]="kOpenDiagnosticsApp";FeedbackAppPostSubmitAction[FeedbackAppPostSubmitAction["kOpenChromebookCommunity"]=4]="kOpenChromebookCommunity";FeedbackAppPostSubmitAction[FeedbackAppPostSubmitAction["kCloseFeedbackApp"]=5]="kCloseFeedbackApp"})(FeedbackAppPostSubmitAction||(FeedbackAppPostSubmitAction={}));export const FeedbackAppPreSubmitActionSpec={$:mojo.internal.Enum()};export var FeedbackAppPreSubmitAction;(function(FeedbackAppPreSubmitAction){FeedbackAppPreSubmitAction[FeedbackAppPreSubmitAction["MIN_VALUE"]=0]="MIN_VALUE";FeedbackAppPreSubmitAction[FeedbackAppPreSubmitAction["MAX_VALUE"]=5]="MAX_VALUE";FeedbackAppPreSubmitAction[FeedbackAppPreSubmitAction["kViewedHelpContent"]=0]="kViewedHelpContent";FeedbackAppPreSubmitAction[FeedbackAppPreSubmitAction["kViewedScreenshot"]=1]="kViewedScreenshot";FeedbackAppPreSubmitAction[FeedbackAppPreSubmitAction["kViewedImage"]=2]="kViewedImage";FeedbackAppPreSubmitAction[FeedbackAppPreSubmitAction["kViewedSystemAndAppInfo"]=3]="kViewedSystemAndAppInfo";FeedbackAppPreSubmitAction[FeedbackAppPreSubmitAction["kViewedAutofillMetadata"]=4]="kViewedAutofillMetadata";FeedbackAppPreSubmitAction[FeedbackAppPreSubmitAction["kViewedMetrics"]=5]="kViewedMetrics"})(FeedbackAppPreSubmitAction||(FeedbackAppPreSubmitAction={}));export const FeedbackAppExitPathSpec={$:mojo.internal.Enum()};export var FeedbackAppExitPath;(function(FeedbackAppExitPath){FeedbackAppExitPath[FeedbackAppExitPath["MIN_VALUE"]=0]="MIN_VALUE";FeedbackAppExitPath[FeedbackAppExitPath["MAX_VALUE"]=6]="MAX_VALUE";FeedbackAppExitPath[FeedbackAppExitPath["kQuitSearchPageHelpContentClicked"]=0]="kQuitSearchPageHelpContentClicked";FeedbackAppExitPath[FeedbackAppExitPath["kQuitSearchPageNoHelpContentClicked"]=1]="kQuitSearchPageNoHelpContentClicked";FeedbackAppExitPath[FeedbackAppExitPath["kQuitNoHelpContentDisplayed"]=2]="kQuitNoHelpContentDisplayed";FeedbackAppExitPath[FeedbackAppExitPath["kQuitShareDataPageHelpContentClicked"]=3]="kQuitShareDataPageHelpContentClicked";FeedbackAppExitPath[FeedbackAppExitPath["kQuitShareDataPageNoHelpContentClicked"]=4]="kQuitShareDataPageNoHelpContentClicked";FeedbackAppExitPath[FeedbackAppExitPath["kSuccessHelpContentClicked"]=5]="kSuccessHelpContentClicked";FeedbackAppExitPath[FeedbackAppExitPath["kSuccessNoHelpContentClicked"]=6]="kSuccessNoHelpContentClicked"})(FeedbackAppExitPath||(FeedbackAppExitPath={}));export const FeedbackAppHelpContentOutcomeSpec={$:mojo.internal.Enum()};export var FeedbackAppHelpContentOutcome;(function(FeedbackAppHelpContentOutcome){FeedbackAppHelpContentOutcome[FeedbackAppHelpContentOutcome["MIN_VALUE"]=0]="MIN_VALUE";FeedbackAppHelpContentOutcome[FeedbackAppHelpContentOutcome["MAX_VALUE"]=5]="MAX_VALUE";FeedbackAppHelpContentOutcome[FeedbackAppHelpContentOutcome["kContinueHelpContentClicked"]=0]="kContinueHelpContentClicked";FeedbackAppHelpContentOutcome[FeedbackAppHelpContentOutcome["kContinueNoHelpContentClicked"]=1]="kContinueNoHelpContentClicked";FeedbackAppHelpContentOutcome[FeedbackAppHelpContentOutcome["kContinueNoHelpContentDisplayed"]=2]="kContinueNoHelpContentDisplayed";FeedbackAppHelpContentOutcome[FeedbackAppHelpContentOutcome["kQuitHelpContentClicked"]=3]="kQuitHelpContentClicked";FeedbackAppHelpContentOutcome[FeedbackAppHelpContentOutcome["kQuitNoHelpContentClicked"]=4]="kQuitNoHelpContentClicked";FeedbackAppHelpContentOutcome[FeedbackAppHelpContentOutcome["kQuitNoHelpContentDisplayed"]=5]="kQuitNoHelpContentDisplayed"})(FeedbackAppHelpContentOutcome||(FeedbackAppHelpContentOutcome={}));export class HelpContentProviderPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.os_feedback_ui.mojom.HelpContentProvider",scope)}}export class HelpContentProviderRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(HelpContentProviderPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}getHelpContents(request){return this.proxy.sendMessage(0,HelpContentProvider_GetHelpContents_ParamsSpec.$,HelpContentProvider_GetHelpContents_ResponseParamsSpec.$,[request],false)}}export class HelpContentProviderReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(HelpContentProviderRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,HelpContentProvider_GetHelpContents_ParamsSpec.$,HelpContentProvider_GetHelpContents_ResponseParamsSpec.$,impl.getHelpContents.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class HelpContentProvider{static get $interfaceName(){return"ash.os_feedback_ui.mojom.HelpContentProvider"}static getRemote(){let remote=new HelpContentProviderRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class HelpContentProviderCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(HelpContentProviderRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.getHelpContents=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,HelpContentProvider_GetHelpContents_ParamsSpec.$,HelpContentProvider_GetHelpContents_ResponseParamsSpec.$,this.getHelpContents.createReceiverHandler(true),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export class FeedbackServiceProviderPendingReceiver{constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"ash.os_feedback_ui.mojom.FeedbackServiceProvider",scope)}}export class FeedbackServiceProviderRemote{constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(FeedbackServiceProviderPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}getFeedbackContext(){return this.proxy.sendMessage(0,FeedbackServiceProvider_GetFeedbackContext_ParamsSpec.$,FeedbackServiceProvider_GetFeedbackContext_ResponseParamsSpec.$,[],false)}getScreenshotPng(){return this.proxy.sendMessage(1,FeedbackServiceProvider_GetScreenshotPng_ParamsSpec.$,FeedbackServiceProvider_GetScreenshotPng_ResponseParamsSpec.$,[],false)}sendReport(report){return this.proxy.sendMessage(2,FeedbackServiceProvider_SendReport_ParamsSpec.$,FeedbackServiceProvider_SendReport_ResponseParamsSpec.$,[report],false)}openDiagnosticsApp(){this.proxy.sendMessage(3,FeedbackServiceProvider_OpenDiagnosticsApp_ParamsSpec.$,null,[],false)}openExploreApp(){this.proxy.sendMessage(4,FeedbackServiceProvider_OpenExploreApp_ParamsSpec.$,null,[],false)}openMetricsDialog(){this.proxy.sendMessage(5,FeedbackServiceProvider_OpenMetricsDialog_ParamsSpec.$,null,[],false)}openSystemInfoDialog(){this.proxy.sendMessage(6,FeedbackServiceProvider_OpenSystemInfoDialog_ParamsSpec.$,null,[],false)}openAutofillDialog(autofillMetadata){this.proxy.sendMessage(7,FeedbackServiceProvider_OpenAutofillDialog_ParamsSpec.$,null,[autofillMetadata],false)}recordPostSubmitAction(action){this.proxy.sendMessage(8,FeedbackServiceProvider_RecordPostSubmitAction_ParamsSpec.$,null,[action],false)}recordPreSubmitAction(action){this.proxy.sendMessage(9,FeedbackServiceProvider_RecordPreSubmitAction_ParamsSpec.$,null,[action],false)}recordExitPath(exitPath){this.proxy.sendMessage(10,FeedbackServiceProvider_RecordExitPath_ParamsSpec.$,null,[exitPath],false)}recordHelpContentOutcome(outcome){this.proxy.sendMessage(11,FeedbackServiceProvider_RecordHelpContentOutcome_ParamsSpec.$,null,[outcome],false)}recordHelpContentSearchResultCount(count){this.proxy.sendMessage(12,FeedbackServiceProvider_RecordHelpContentSearchResultCount_ParamsSpec.$,null,[count],false)}}export class FeedbackServiceProviderReceiver{constructor(impl){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(FeedbackServiceProviderRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.helper_internal_.registerHandler(0,FeedbackServiceProvider_GetFeedbackContext_ParamsSpec.$,FeedbackServiceProvider_GetFeedbackContext_ResponseParamsSpec.$,impl.getFeedbackContext.bind(impl),false);this.helper_internal_.registerHandler(1,FeedbackServiceProvider_GetScreenshotPng_ParamsSpec.$,FeedbackServiceProvider_GetScreenshotPng_ResponseParamsSpec.$,impl.getScreenshotPng.bind(impl),false);this.helper_internal_.registerHandler(2,FeedbackServiceProvider_SendReport_ParamsSpec.$,FeedbackServiceProvider_SendReport_ResponseParamsSpec.$,impl.sendReport.bind(impl),false);this.helper_internal_.registerHandler(3,FeedbackServiceProvider_OpenDiagnosticsApp_ParamsSpec.$,null,impl.openDiagnosticsApp.bind(impl),false);this.helper_internal_.registerHandler(4,FeedbackServiceProvider_OpenExploreApp_ParamsSpec.$,null,impl.openExploreApp.bind(impl),false);this.helper_internal_.registerHandler(5,FeedbackServiceProvider_OpenMetricsDialog_ParamsSpec.$,null,impl.openMetricsDialog.bind(impl),false);this.helper_internal_.registerHandler(6,FeedbackServiceProvider_OpenSystemInfoDialog_ParamsSpec.$,null,impl.openSystemInfoDialog.bind(impl),false);this.helper_internal_.registerHandler(7,FeedbackServiceProvider_OpenAutofillDialog_ParamsSpec.$,null,impl.openAutofillDialog.bind(impl),false);this.helper_internal_.registerHandler(8,FeedbackServiceProvider_RecordPostSubmitAction_ParamsSpec.$,null,impl.recordPostSubmitAction.bind(impl),false);this.helper_internal_.registerHandler(9,FeedbackServiceProvider_RecordPreSubmitAction_ParamsSpec.$,null,impl.recordPreSubmitAction.bind(impl),false);this.helper_internal_.registerHandler(10,FeedbackServiceProvider_RecordExitPath_ParamsSpec.$,null,impl.recordExitPath.bind(impl),false);this.helper_internal_.registerHandler(11,FeedbackServiceProvider_RecordHelpContentOutcome_ParamsSpec.$,null,impl.recordHelpContentOutcome.bind(impl),false);this.helper_internal_.registerHandler(12,FeedbackServiceProvider_RecordHelpContentSearchResultCount_ParamsSpec.$,null,impl.recordHelpContentSearchResultCount.bind(impl),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}}export class FeedbackServiceProvider{static get $interfaceName(){return"ash.os_feedback_ui.mojom.FeedbackServiceProvider"}static getRemote(){let remote=new FeedbackServiceProviderRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}export class FeedbackServiceProviderCallbackRouter{constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(FeedbackServiceProviderRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.getFeedbackContext=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,FeedbackServiceProvider_GetFeedbackContext_ParamsSpec.$,FeedbackServiceProvider_GetFeedbackContext_ResponseParamsSpec.$,this.getFeedbackContext.createReceiverHandler(true),false);this.getScreenshotPng=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(1,FeedbackServiceProvider_GetScreenshotPng_ParamsSpec.$,FeedbackServiceProvider_GetScreenshotPng_ResponseParamsSpec.$,this.getScreenshotPng.createReceiverHandler(true),false);this.sendReport=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(2,FeedbackServiceProvider_SendReport_ParamsSpec.$,FeedbackServiceProvider_SendReport_ResponseParamsSpec.$,this.sendReport.createReceiverHandler(true),false);this.openDiagnosticsApp=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(3,FeedbackServiceProvider_OpenDiagnosticsApp_ParamsSpec.$,null,this.openDiagnosticsApp.createReceiverHandler(false),false);this.openExploreApp=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(4,FeedbackServiceProvider_OpenExploreApp_ParamsSpec.$,null,this.openExploreApp.createReceiverHandler(false),false);this.openMetricsDialog=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(5,FeedbackServiceProvider_OpenMetricsDialog_ParamsSpec.$,null,this.openMetricsDialog.createReceiverHandler(false),false);this.openSystemInfoDialog=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(6,FeedbackServiceProvider_OpenSystemInfoDialog_ParamsSpec.$,null,this.openSystemInfoDialog.createReceiverHandler(false),false);this.openAutofillDialog=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(7,FeedbackServiceProvider_OpenAutofillDialog_ParamsSpec.$,null,this.openAutofillDialog.createReceiverHandler(false),false);this.recordPostSubmitAction=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(8,FeedbackServiceProvider_RecordPostSubmitAction_ParamsSpec.$,null,this.recordPostSubmitAction.createReceiverHandler(false),false);this.recordPreSubmitAction=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(9,FeedbackServiceProvider_RecordPreSubmitAction_ParamsSpec.$,null,this.recordPreSubmitAction.createReceiverHandler(false),false);this.recordExitPath=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(10,FeedbackServiceProvider_RecordExitPath_ParamsSpec.$,null,this.recordExitPath.createReceiverHandler(false),false);this.recordHelpContentOutcome=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(11,FeedbackServiceProvider_RecordHelpContentOutcome_ParamsSpec.$,null,this.recordHelpContentOutcome.createReceiverHandler(false),false);this.recordHelpContentSearchResultCount=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(12,FeedbackServiceProvider_RecordHelpContentSearchResultCount_ParamsSpec.$,null,this.recordHelpContentSearchResultCount.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}export const HelpContentSpec={$:{}};export const SearchRequestSpec={$:{}};export const SearchResponseSpec={$:{}};export const FeedbackContextSpec={$:{}};export const AttachedFileSpec={$:{}};export const ReportSpec={$:{}};export const HelpContentProvider_GetHelpContents_ParamsSpec={$:{}};export const HelpContentProvider_GetHelpContents_ResponseParamsSpec={$:{}};export const FeedbackServiceProvider_GetFeedbackContext_ParamsSpec={$:{}};export const FeedbackServiceProvider_GetFeedbackContext_ResponseParamsSpec={$:{}};export const FeedbackServiceProvider_GetScreenshotPng_ParamsSpec={$:{}};export const FeedbackServiceProvider_GetScreenshotPng_ResponseParamsSpec={$:{}};export const FeedbackServiceProvider_SendReport_ParamsSpec={$:{}};export const FeedbackServiceProvider_SendReport_ResponseParamsSpec={$:{}};export const FeedbackServiceProvider_OpenDiagnosticsApp_ParamsSpec={$:{}};export const FeedbackServiceProvider_OpenExploreApp_ParamsSpec={$:{}};export const FeedbackServiceProvider_OpenMetricsDialog_ParamsSpec={$:{}};export const FeedbackServiceProvider_OpenSystemInfoDialog_ParamsSpec={$:{}};export const FeedbackServiceProvider_OpenAutofillDialog_ParamsSpec={$:{}};export const FeedbackServiceProvider_RecordPostSubmitAction_ParamsSpec={$:{}};export const FeedbackServiceProvider_RecordPreSubmitAction_ParamsSpec={$:{}};export const FeedbackServiceProvider_RecordExitPath_ParamsSpec={$:{}};export const FeedbackServiceProvider_RecordHelpContentOutcome_ParamsSpec={$:{}};export const FeedbackServiceProvider_RecordHelpContentSearchResultCount_ParamsSpec={$:{}};mojo.internal.Struct(HelpContentSpec.$,"HelpContent",[mojo.internal.StructField("title",0,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("url",8,0,url_mojom_UrlSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("contentType",16,0,HelpContentTypeSpec.$,0,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(SearchRequestSpec.$,"SearchRequest",[mojo.internal.StructField("query",0,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("maxResults",8,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(SearchResponseSpec.$,"SearchResponse",[mojo.internal.StructField("results",0,0,mojo.internal.Array(HelpContentSpec.$,false),null,false,0,undefined,undefined),mojo.internal.StructField("totalResults",8,0,mojo.internal.Uint32,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(FeedbackContextSpec.$,"FeedbackContext",[mojo.internal.StructField("email",0,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("wifiDebugLogsAllowed",8,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("hasLinkedCrossDevicePhone",8,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isInternalAccount",8,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("settingsSearchDoNotRecordMetrics",8,3,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("fromAutofill",8,4,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("autofillMetadata",16,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("pageUrl",24,0,url_mojom_UrlSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("extraDiagnostics",32,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("categoryTag",40,0,mojo.internal.String,null,true,0,undefined,undefined),mojo.internal.StructField("traceId",12,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,56]]);mojo.internal.Struct(AttachedFileSpec.$,"AttachedFile",[mojo.internal.StructField("fileData",0,0,mojoBase_mojom_BigBufferSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("fileName",16,0,mojoBase_mojom_SafeBaseNameSpec.$,null,false,0,undefined,undefined)],[[0,32]]);mojo.internal.Struct(ReportSpec.$,"Report",[mojo.internal.StructField("feedbackContext",0,0,FeedbackContextSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("description",8,0,mojoBase_mojom_String16Spec.$,null,false,0,undefined,undefined),mojo.internal.StructField("attachedFile",16,0,AttachedFileSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("includeSystemLogsAndHistograms",24,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("includeScreenshot",24,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("contactUserConsentGranted",24,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("sendBluetoothLogs",24,3,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("sendWifiDebugLogs",24,4,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("includeAutofillMetadata",24,5,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,40]]);mojo.internal.Struct(HelpContentProvider_GetHelpContents_ParamsSpec.$,"HelpContentProvider_GetHelpContents_Params",[mojo.internal.StructField("request",0,0,SearchRequestSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(HelpContentProvider_GetHelpContents_ResponseParamsSpec.$,"HelpContentProvider_GetHelpContents_ResponseParams",[mojo.internal.StructField("response",0,0,SearchResponseSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(FeedbackServiceProvider_GetFeedbackContext_ParamsSpec.$,"FeedbackServiceProvider_GetFeedbackContext_Params",[],[[0,8]]);mojo.internal.Struct(FeedbackServiceProvider_GetFeedbackContext_ResponseParamsSpec.$,"FeedbackServiceProvider_GetFeedbackContext_ResponseParams",[mojo.internal.StructField("feedbackContext",0,0,FeedbackContextSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(FeedbackServiceProvider_GetScreenshotPng_ParamsSpec.$,"FeedbackServiceProvider_GetScreenshotPng_Params",[],[[0,8]]);mojo.internal.Struct(FeedbackServiceProvider_GetScreenshotPng_ResponseParamsSpec.$,"FeedbackServiceProvider_GetScreenshotPng_ResponseParams",[mojo.internal.StructField("pngData",0,0,mojo.internal.Array(mojo.internal.Uint8,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(FeedbackServiceProvider_SendReport_ParamsSpec.$,"FeedbackServiceProvider_SendReport_Params",[mojo.internal.StructField("report",0,0,ReportSpec.$,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(FeedbackServiceProvider_SendReport_ResponseParamsSpec.$,"FeedbackServiceProvider_SendReport_ResponseParams",[mojo.internal.StructField("status",0,0,SendReportStatusSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(FeedbackServiceProvider_OpenDiagnosticsApp_ParamsSpec.$,"FeedbackServiceProvider_OpenDiagnosticsApp_Params",[],[[0,8]]);mojo.internal.Struct(FeedbackServiceProvider_OpenExploreApp_ParamsSpec.$,"FeedbackServiceProvider_OpenExploreApp_Params",[],[[0,8]]);mojo.internal.Struct(FeedbackServiceProvider_OpenMetricsDialog_ParamsSpec.$,"FeedbackServiceProvider_OpenMetricsDialog_Params",[],[[0,8]]);mojo.internal.Struct(FeedbackServiceProvider_OpenSystemInfoDialog_ParamsSpec.$,"FeedbackServiceProvider_OpenSystemInfoDialog_Params",[],[[0,8]]);mojo.internal.Struct(FeedbackServiceProvider_OpenAutofillDialog_ParamsSpec.$,"FeedbackServiceProvider_OpenAutofillDialog_Params",[mojo.internal.StructField("autofillMetadata",0,0,mojo.internal.String,null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(FeedbackServiceProvider_RecordPostSubmitAction_ParamsSpec.$,"FeedbackServiceProvider_RecordPostSubmitAction_Params",[mojo.internal.StructField("action",0,0,FeedbackAppPostSubmitActionSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(FeedbackServiceProvider_RecordPreSubmitAction_ParamsSpec.$,"FeedbackServiceProvider_RecordPreSubmitAction_Params",[mojo.internal.StructField("action",0,0,FeedbackAppPreSubmitActionSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(FeedbackServiceProvider_RecordExitPath_ParamsSpec.$,"FeedbackServiceProvider_RecordExitPath_Params",[mojo.internal.StructField("exitPath",0,0,FeedbackAppExitPathSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(FeedbackServiceProvider_RecordHelpContentOutcome_ParamsSpec.$,"FeedbackServiceProvider_RecordHelpContentOutcome_Params",[mojo.internal.StructField("outcome",0,0,FeedbackAppHelpContentOutcomeSpec.$,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(FeedbackServiceProvider_RecordHelpContentSearchResultCount_ParamsSpec.$,"FeedbackServiceProvider_RecordHelpContentSearchResultCount_Params",[mojo.internal.StructField("count",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);