import{html}from"//resources/polymer/v3_0/polymer/polymer_bundled.min.js";export function getTemplate(){return html`<!--_html_template_start_--><style include="os-feedback-shared">:host-context(body.jelly-enabled) #privacyNote{font:var(--cros-body-2-font)}:host-context(body.jelly-enabled) #screenshotCheckLabel{font:var(--cros-button-2-font)}:host-context(body.jelly-enabled) .checkbox-label{font:var(--cros-body-2-font)}:host-context(body.jelly-enabled) cr-dialog [slot=body]{font:var(--cros-body-1-font)}::-webkit-scrollbar{background-color:transparent;border-radius:4px;width:4px}::-webkit-scrollbar-thumb{background-color:var(--cros-app-scrollbar-color);border-radius:4px}:host-context(body.jelly-enabled) .card-frame{background-color:var(--cros-sys-app_base);border:none;border-radius:12px}:host-context(body.jelly-enabled) #screenshotContainer{margin-inline-end:16px}:host-context(body.jelly-enabled) #screenshotImage{border-radius:0 12px 12px 0}.privacy-note{color:var(--cros-color-secondary);font-size:13px;font-weight:400;line-height:18px;margin-bottom:20px;text-align:left}#attachFilesLabelContainer{align-items:center;display:inline-flex}#attachFilesIcon{--iron-icon-fill-color:var(--cros-icon-color-secondary);display:inline-block;height:20px;margin-bottom:8px;margin-inline-start:6px;width:20px}#attachFiles{display:flex;flex-direction:column;margin-bottom:20px}#attachFilesContainer{display:flex;flex-direction:row}.card-frame{align-items:center;border:1px solid var(--cros-separator-color);border-radius:4px;display:flex}#screenshotContainer{align-items:center;box-sizing:border-box;height:48px;margin-inline-end:12px;width:50%}#screenshotContainer>button{cursor:pointer}#screenshotImage{border-radius:0 4px 4px 0;display:block;height:46px;transition:all 250ms ease;width:68px}#screenshotImage:hover{opacity:0.7}#addFileContainer{align-items:center;box-sizing:border-box;height:48px;margin-inline-start:12px;width:50%}.md-select{--md-select-side-padding:16px;height:32px;margin-bottom:8px;width:248px}#shareDiagnosticData{margin-bottom:20px}.checkbox-field-container{align-items:start;display:flex;margin-bottom:8px}#pageUrl{display:flex;margin-bottom:8px;white-space:nowrap}#pageUrlLabel{display:flex;max-width:488px;white-space:nowrap}#tooltipContent{white-space:normal;word-wrap:break-word}.disabled-input-text{color:var(--cros-text-color-disabled)}#screenshotCheckbox{margin-inline-end:10px;margin-inline-start:12px;width:156px}#screenshotCheckLabel{flex:1;font-weight:400;line-height:20px;margin-inline-end:12px}#imageButton{background:none;border:none;height:48px;padding:0;width:68px}#userConsent{display:flex;margin-bottom:20px}h2{margin:0 0 8px 0}.checkbox-label{color:var(--cros-text-color-primary);font-size:13px;line-height:20px;margin-top:-2px}cr-dialog::part(dialog){width:400px}cr-dialog [slot=body]{color:var(--cros-text-color-primary);font-family:var(--feedback-roboto-font-family);font-size:15px;font-weight:var(--feedback-regular-font-weight);line-height:22px;padding-inline-end:24px;padding-inline-start:24px}cr-dialog [slot=body]{white-space:pre-line}#content{width:520px}cr-checkbox{align-items:flex-start;padding-top:2px}</style>
<div id="container">
  <div id="header">
    <h1 class="page-title">[[i18n('pageTitle')]]</h1>
  </div>
  <div id="shadowElevation"></div>
  <div id="content" on-scroll="onContainerScroll">
    <!-- Attach files -->
    <div id="attachFiles">
      <div id="attachFilesLabelContainer">
        <h2 id="attachFilesLabel">[[getAttachFilesLabel(feedbackContext)]]</h2>
        <iron-icon icon="os-feedback:info" id="attachFilesIcon"
            class="focusable" tabindex="0"
            aria-labelledby="attachFilesTooltipContent"
            hidden$="[[!isUserLoggedIn(feedbackContext)]]">
        </iron-icon>
        <paper-tooltip for="attachFilesIcon" position="top" offset="0" fit-to-visible-bounds>
          <div id="attachFilesTooltipContent">
            [[i18n('attachFileLabelTooltip')]]
          </div>
        </paper-tooltip>
      </div>
      <div id="attachFilesContainer">
        <!-- Attach a screenshot -->
        <div id="screenshotContainer" class="card-frame">
          <cr-checkbox id="screenshotCheckbox"
              disabled="[[!hasScreenshot(screenshotUrl)]]">
            <div id="screenshotCheckLabel" class="checkbox-label">[[i18n('attachScreenshotLabel')]]</div>
          </cr-checkbox>
          <button id="imageButton" class="focusable" on-click="handleScreenshotClick">
            <img id="screenshotImage" src="[[screenshotUrl]]">
          </button>
        </div>
        <!-- Attach a file -->
        <div id="addFileContainer" class="card-frame"
            hidden$="[[!isUserLoggedIn(feedbackContext)]]">
          <file-attachment></file-attachment>
        </div>
      </div>
    </div>
    <!-- User e-mail -->
    <div id="userEmail" class="text-field-container"
        hidden$="[[!hasEmail(feedbackContext)]]">
      <h2 id="userEmailLabel">[[i18n('userEmailLabel')]]</h2>
      <select id="userEmailDropDown" class="md-select"
          aria-label="[[i18n('userEmailAriaLabel')]]">
        <option value$="[[feedbackContext.email]]" class="email-dropdown">
          [[feedbackContext.email]]
        </option>
        <option id="anonymousUser" value="" class="email-dropdown">
          [[i18n('anonymousUser')]]
        </option>
      </select>
    </div>
    <!-- User consent -->
    <div id="userConsent" class="checkbox-field-container"
        hidden$="[[!hasEmail(feedbackContext)]]">
      <cr-checkbox id="userConsentCheckbox" aria-labelledby="userConsentLabel">
        <div id="userConsentLabel" class="checkbox-label">[[i18n('userConsentLabel')]]</div>
      </cr-checkbox>
    </div>
    <!-- Diagnostic data -->
    <div id="shareDiagnosticData">
      <h2 id="shareDiagnosticDataLabel">[[i18n('shareDiagnosticDataLabel')]]</h2>
      <!-- URL -->
      <div id="pageUrl" class="checkbox-field-container" hidden="[[!feedbackContext.pageUrl.url]]">
        <cr-checkbox id="pageUrlCheckbox" aria-labelledby="pageUrlLabel" checked>
          <div id="pageUrlLabel" class="checkbox-label">[[i18n('sharePageUrlLabel')]]&nbsp;
            <a href="[[feedbackContext.pageUrl.url]]" class="overflow-text" id="pageUrlText" target="_blank">
              [[feedbackContext.pageUrl.url]]
            </a>
            <paper-tooltip for="pageUrlText" fitToVisibleBounds>
              <div id="tooltipContent">[[feedbackContext.pageUrl.url]]</div>
            </paper-tooltip>
          </div>
        </cr-checkbox>
      </div>
      <!-- Autofill Metadata (Googler Internal Only) -->
      <div id="autofillCheckboxContainer" class="checkbox-field-container"
          hidden="[[!shouldShowAutofillCheckbox]]">
        <cr-checkbox id="autofillCheckbox"
            aria-labelledby="autofillCheckboxLabel" checked>
          <div id="autofillCheckboxLabel"
            inner-h-t-m-l="[[getAutofillCheckboxLabel()]]" class="checkbox-label">
          </div>
        </cr-checkbox>
      </div>
      <!-- System Information -->
      <div id="sysInfoContainer" class="checkbox-field-container">
        <cr-checkbox id="sysInfoCheckbox" aria-labelledby="sysInfoCheckboxLabel"
            checked="[[checkSysInfoAndMetrics(
                  feedbackContext.settingsSearchDoNotRecordMetrics)]]">
          <div id="sysInfoCheckboxLabel" inner-h-t-m-l="[[getSysInfoCheckboxLabel()]]"
              class="checkbox-label"></div>
        </cr-checkbox>
      </div>
      <!-- Bluetooth Logs (Googler Internal Only) -->
      <div id="bluetoothCheckboxContainer" class="checkbox-field-container"
          hidden="[[!shouldShowBluetoothCheckbox]]">
        <cr-checkbox id="bluetoothLogsCheckbox" aria-labelledby="bluetoothInfoLabel" checked>
          <div id="bluetoothInfoLabel" class="checkbox-label"
              inner-h-t-m-l="[[getBluetoothLogsCheckboxLabel()]]"></div>
        </cr-checkbox>
      </div>
      <!-- Wifi debug Logs (Googler Internal Only) -->
      <div id="wifiDebugLogsCheckboxContainer" class="checkbox-field-container"
          hidden="[[!shouldShowWifiDebugLogsCheckbox]]">
        <cr-checkbox id="wifiDebugLogsCheckbox"
            aria-labelledby="wifiDebugLogsInfoLabel" checked>
          <div id="wifiDebugLogsInfoLabel" class="checkbox-label"
              inner-h-t-m-l="[[getWifiDebugLogsCheckboxLabel()]]"></div>
        </cr-checkbox>
      </div>
      <!-- Link Cross Device Doogfood Feedback (Googler Internal Only) -->
      <div id="linkCrossDeviceDogfoodFeedbackCheckboxContainer" class="checkbox-field-container"
          hidden="[[!shouldShowLinkCrossDeviceDogfoodFeedbackCheckbox]]">
        <cr-checkbox id="linkCrossDeviceDogfoodFeedbackCheckbox" aria-labelledby="linkCrossDeviceDogfoodFeedbackInfoLabel" checked>
          <div id="linkCrossDeviceDogfoodFeedbackInfoLabel" class="checkbox-label"
              inner-h-t-m-l="[[getLinkCrossDeviceDogfoodFeedbackCheckboxLabel()]]"></div>
        </cr-checkbox>
      </div>
      <!-- Performance trace -->
      <div id="performanceTraceContainer" class="checkbox-field-container"
          hidden="[[!shouldShowPerformanceTraceCheckbox(feedbackContext)]]">
        <cr-checkbox id="performanceTraceCheckbox"
            aria-labelledby="performanceTraceCheckboxLabel" checked>
          <div id="performanceTraceCheckboxLabel" class="checkbox-label"
              inner-h-t-m-l="[[getPerformanceTraceCheckboxLabel()]]">
          </div>
        </cr-checkbox>
      </div>
    </div>
    <!-- Privacy note -->
    <div id="privacyNote" inner-h-t-m-l="[[getPrivacyNote(feedbackContext)]]"
        class="privacy-note">
    </div>
    <div id="shareWithPartnerNote" class="privacy-note">
      [[i18n('mayBeShareWithPartnerNote')]]</div>
    <div id="shadowShield"></div>
  </div>
  <div id="separator"></div>
  <div id="navButtons">
    <cr-button id="buttonBack" class="cancel-button"
        on-click="handleBackButtonClicked">
      [[i18n('backButtonLabel')]]
    </cr-button>
    <cr-button id="buttonSend" class="action-button"
        on-click="handleSendButtonClicked">
        [[i18n('sendButtonLabel')]]
    </cr-button>
  </div>
</div>
<dialog id="screenshotDialog" aria-label="[[i18n('previewScreenshotDialogLabel')]]">
  <div id="toolbar" class="dialog-toolbar">
    <cr-button id="closeDialogButton"
        class="close-dialog-button"
        title="[[i18n('dialogBackButtonAriaLabel')]]"
        aria-label="[[i18n('dialogBackButtonAriaLabel')]]"
        on-click="handleScreenshotDialogCloseClick">
      <iron-icon id="backArrow" class="dialog-back-arrow"
          icon="cr:arrow-back"></iron-icon>
    </cr-button>
    <div id="dialogTitle">[[i18n('attachScreenshotLabel')]]</div>
  </div>
  <div id="mainPanel" class="dialog-main-panel">
    <div id="innerContentPanel" class="dialog-content-panel">
      <img src="[[screenshotUrl]]" class="image-preview">
    </div>
  </div>
</dialog>
<cr-dialog id="bluetoothDialog">
  <div slot="body">
    [[i18n('bluetoothLogsMessage')]]
  </div>
  <div slot="button-container">
    <cr-button id="bluetoothDialogDoneButton" class="action-button"
        on-click="handleCloseBluetoothDialogClicked">
      [[i18n('buttonDone')]]
    </cr-button>
  </div>
</cr-dialog>
<cr-dialog id="wifiDebugLogsDialog">
  <div id="wifiDebugLogsDialogTitle" slot="title">
    [[i18n('wifiDebugLogsTitle')]]
  </div>
  <div slot="body">
    [[i18n('wifiDebugLogsMessage')]]
  </div>
  <div slot="button-container">
    <cr-button id="wifiDebugLogsDialogDoneButton" class="action-button"
        on-click="handleCloseWifiDebugLogsDialogClicked">
      [[i18n('buttonDone')]]
    </cr-button>
  </div>
</cr-dialog>
<cr-dialog id="linkCrossDeviceDogfoodFeedbackDialog">
  <div slot="body">
    [[i18n('linkCrossDeviceDogfoodFeedbackMessage')]]
  </div>
  <div slot="button-container">
    <cr-button id="linkCrossDeviceDogfoodFeedbackDialogDoneButton" class="action-button"
        on-click="handleCloseLinkCrossDeviceDogfoodFeedbackDialogClicked">
      [[i18n('buttonDone')]]
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}