import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="os-feedback-shared">:host-context(body.jelly-enabled) #descriptionEmptyError{font:var(--cros-annotation-2-font)}:host-context(body.jelly-enabled) #descriptionText{background-color:var(--cros-sys-input_field_on_shaded);font:var(--cros-body-2-font)}:host-context(body.jelly-enabled) #descriptionText::placeholder{font:var(--cros-body-2-font)}:host-context(body.jelly-enabled) #descriptionText.has-error{color:var(--cros-sys-error);outline:2px solid var(--cros-sys-error)}:host-context(body.jelly-enabled) #feedbackWritingGuidance{font:var(--cros-body-2-font)}:host-context(body.jelly-enabled) #emptyErrorIcon{--iron-icon-fill-color:var(--cros-sys-error)}iframe{border-style:none;height:var(--iframe-height);width:100%}#descriptionText{background-color:var(--cros-textfield-background-color);border:none;border-radius:4px;box-sizing:border-box;color:var(--cros-text-color-primary);font-family:var(--feedback-roboto-font-family);font-size:13px;height:120px;line-height:20px;padding:10px;resize:none;width:520px}#descriptionText:focus{outline:2px solid var(--cros-focus-ring-color)}#descriptionText::placeholder{color:var(--cros-color-disabled);font-family:var(--feedback-roboto-font-family);font-size:13px;line-height:20px}#descriptionText.has-error{color:var(--cros-text-color-alert);outline:2px solid var(--cros-color-alert)}#descriptionHeader{align-items:center;display:flex;flex-direction:row;justify-content:space-between}#helpContentFrame{display:flex}#descriptionEmptyError{color:var(--cros-text-color-alert);font-family:var(--feedback-google-sans-font-family);font-size:11px;font-weight:var(--feedback-regular-font-weight);line-height:16px;margin:0}#descriptionTitle{margin:0 0 6px 0}a{line-height:20px}#emptyErrorIcon{--iron-icon-fill-color:var(--cros-icon-color-alert);display:inline-block;height:16px;margin-inline-end:8px;width:16px}#emptyErrorContainer{align-items:center;display:flex;margin:4px 0 12px}#descriptionPane{height:148px;overflow:visible}</style>
<div id="container">
  <div id="header">
    <h1 class="page-title">[[i18n('pageTitle')]]</h1>
  </div>
  <div id="shadowElevation"></div>
  <div id="content" on-scroll="onContainerScroll">
    <div id="descriptionPane">
      <div id="descriptionHeader">
        <h2 id="descriptionTitle">[[i18n('descriptionLabel')]]</h2>
        <a id="feedbackWritingGuidance" href="[[feedbackWritingGuidanceUrl()]]"
            target="_blank"
            hidden$="[[!isUserLoggedIn(feedbackContext)]]">
            [[i18n('feedbackHelpLinkLabel')]]
        </a>
      </div>
      <span id="suggestionExplainAriaLabel" aria-hidden="true" hidden>
        [[i18n('helpContentLabelTooltip')]]
      </span>
      <textarea id="descriptionText"
          aria-labelledby="descriptionTitle suggestionExplainAriaLabel"
          aria-required="true" on-input="handleInputChanged">
      </textarea>
      <div id='emptyErrorContainer' aria-hidden="true" hidden>
        <iron-icon icon="cr:error-outline" id="emptyErrorIcon"></iron-icon>
        <p id="descriptionEmptyError">
          [[i18n('descriptionRequired')]]
        </p>
      </div>
    </div>
    <div>
      <iframe on-load="resolveIframeLoaded"
          src="chrome-untrusted://os-feedback/untrusted_index.html"
          scrolling="no" hidden$="[[!isUserLoggedIn(feedbackContext)]]">
      </iframe>
    </div>
    <div id="shadowShield"></div>
  </div>
  <div id="separator"></div>
  <div id="navButtons">
    <cr-button id="buttonContinue" class="action-button"
        on-click="handleContinueButtonClicked">
      [[i18n('continueButtonLabel')]]
    </cr-button>
  </div>
</div>
<!--_html_template_end_-->`;
}
