import 'chrome://personalization/strings.m.js';
import { html, useShadow, dom, Polymer, Templatizer, OptionalMutableDataBehavior, animationFrame, microTask, idlePeriod, flush, Debouncer, enqueueDebouncer, matches, translate, dedupingMixin, calculateSplices, PolymerElement, Base as Base$1, afterNextRender, templatize, dashToCamelCase, timeOut, beforeNextRender } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { mojo } from 'chrome://resources/mojo/mojo/public/js/bindings.js';
import { loadTimeData } from 'chrome://resources/js/load_time_data.js';
import { LitElement, css, html as html$1 } from 'chrome://resources/mwc/lit/index.js';

const styleMod$a = document.createElement('dom-module');
styleMod$a.appendChild(html `
  <template>
    <style>
:host-context([cros]) a:not(.item)[href]{color:var(--cros-link-color)}:host-context([cros]) cr-button[has-prefix-icon_],:host-context([cros]) cr-button[has-suffix-icon_]{--iron-icon-fill-color:currentColor}:host-context([cros]) cr-radio-button{--cr-radio-button-checked-color:var(--cros-radio-button-color);--cr-radio-button-checked-ripple-color:var(--cros-radio-button-ripple-color);--cr-radio-button-unchecked-color:var(--cros-radio-button-color-unchecked);--cr-radio-button-unchecked-ripple-color:var(--cros-radio-button-ripple-color-unchecked)}:host-context([cros]) cr-toggle{--cr-toggle-checked-bar-color:var(--cros-switch-track-color-active);--cr-toggle-checked-bar-opacity:100%;--cr-toggle-checked-button-color:var(--cros-switch-knob-color-active);--cr-toggle-checked-ripple-color:var(--cros-focus-aura-color);--cr-toggle-unchecked-bar-color:var(--cros-switch-track-color-inactive);--cr-toggle-unchecked-button-color:var(--cros-switch-knob-color-inactive);--cr-toggle-unchecked-ripple-color:var(--cros-ripple-color);--cr-toggle-box-shadow:var(--cros-elevation-1-shadow);--cr-toggle-ripple-diameter:32px}:host-context([cros]):host-context(.focus-outline-visible) cr-toggle:focus{--cr-toggle-ripple-ring:2px solid var(--cros-focus-ring-color)}:host-context([cros]) paper-spinner-lite{--paper-spinner-color:var(--cros-icon-color-prominent)}:host-context(body.jelly-enabled){--cros-button-label-color-primary:var(--cros-sys-on_primary);--cros-link-color:var(--cros-sys-primary);--cros-separator-color:var(--cros-sys-separator);--cros-tab-slider-track-color:var(--cros-sys-surface_variant,80%);--cr-form-field-label-color:var(--cros-sys-on_surface);--cr-link-color:var(--cros-sys-primary);--cr-primary-text-color:var(--cros-sys-on_surface);--cr-secondary-text-color:var(--cros-sys-on_surface_variant)}:host-context([cros][chrome-refresh-2023]){--cr-focus-outline-color:var(--cros-sys-focus_ring);--cr-disabled-opacity:var(--cros-disabled-opacity)}:host-context(body.jelly-enabled) cr-button{--text-color:var(--cros-sys-on_primary_container);--ink-color:var(--cros-sys-ripple_primary);--iron-icon-fill-color:currentColor;--hover-bg-color:var(--cros-sys-hover_on_subtle);--ripple-opacity:.1;--bg-action:var(--cros-sys-primary);--ink-color-action:var(--cros-sys-ripple_primary);--text-color-action:var(--cros-sys-on_primary);--hover-bg-action:var(--cros-sys-hover_on_prominent);--ripple-opacity-action:1;--disabled-bg:var(--cros-sys-disabled_container);--disabled-bg-action:var(--cros-sys-disabled_container);--disabled-text-color:var(--cros-sys-disabled);background-color:var(--cros-sys-primary_container);border:none}:host-context(body.jelly-enabled) cr-button:hover::part(hoverBackground){background-color:var(--hover-bg-color);display:block}:host-context(body.jelly-enabled) cr-button:active,:host-context(body.jelly-enabled) cr-button.action-button:not(:active):hover{box-shadow:none}:host-context(body.jelly-enabled) cr-button.action-button{background-color:var(--bg-action)}:host-context(body.jelly-enabled) cr-button.action-button:hover::part(hoverBackground){background-color:var(--hover-bg-action)}:host-context(body.jelly-enabled) cr-button[disabled]{background-color:var(--cros-sys-disabled_container)}:host-context(body.jelly-enabled):host-context(.focus-outline-visible) cr-button:focus{box-shadow:none;outline:2px solid var(--cros-sys-focus_ring)}:host-context(body.jelly-enabled) cr-checkbox{--cr-checkbox-checked-box-color:var(--cros-sys-primary);--cr-checkbox-ripple-checked-color:var(--cros-sys-ripple_primary);--cr-checkbox-checked-ripple-opacity:1;--cr-checkbox-mark-color:var(--cros-sys-inverse_on_surface);--cr-checkbox-ripple-unchecked-color:var(--cros-sys-ripple_primary);--cr-checkbox-unchecked-box-color:var(--cros-sys-on_surface);--cr-checkbox-unchecked-ripple-opacity:1}:host-context([cros][chrome-refresh-2023]) cr-checkbox{--cr-checkbox-focus-outline:none}:host-context([cros][chrome-refresh-2023]) cr-checkbox[disabled]{opacity:var(--cros-disabled-opacity)}:host-context([cros][chrome-refresh-2023]):host-context(.focus-outline-visible) cr-checkbox:focus{--cr-checkbox-ripple-ring:2px solid var(--cros-sys-focus_ring)}:host-context(body.jelly-enabled) cr-icon-button,:host-context(body.jelly-enabled) cr-link-row::part(icon),:host-context(body.jelly-enabled) cr-expand-button::part(icon){--cr-icon-button-fill-color:var(--cros-sys-secondary);--cr-icon-button-focus-outline-color:var(--cros-sys-focus_ring)}:host-context(body.jelly-enabled) cr-input,:host-context(body.jelly-enabled) cr-search-field::part(searchInput),:host-context(body.jelly-enabled) cr-searchable-drop-down::part(input),:host-context(body.jelly-enabled) cr-textarea{--cr-input-background-color:var(--cros-sys-input_field_on_base);--cr-input-error-color:var(--cros-sys-error);--cr-input-focus-color:var(--cros-sys-primary);--cr-input-placeholder-color:var(--cros-sys-secondary)}:host-context([cros][chrome-refresh-2023]) cr-input,:host-context([cros][chrome-refresh-2023]) cr-search-field::part(searchInput){--cr-input-background-color:var(--cros-sys-input_field_on_base);--cr-input-border:none;--cr-input-border-bottom:none;--cr-input-border-radius:8px;--cr-input-label-color:var(--cros-sys-on-surface);--cr-input-padding-start:16px;--cr-input-padding-end:16px;--cr-input-placeholder-color:var(--cros-sys-secondary);--cr-input-underline-display:none;font:var(--cros-body-2-font);--cr-input-focus-color:var(--cros-sys-primary);--cr-input-focus-label-color:var(--cros-sys-primary);--cr-input-focus-outline:2px solid var(--cros-sys-focus_ring);--cr-input-hover-background-color:transparent;--cr-input-error-color:var(--cros-sys-error)}:host-context([cros][chrome-refresh-2023]) cr-input[disabled]{color:currentColor;opacity:var(--cros-disabled-opacity)}:host-context([cros][chrome-refresh-2023]) cr-input[invalid]{--cr-input-focus-outline:2px solid var(--cros-sys-error)}:host-context([cros][chrome-refresh-2023]) cr-toolbar-search-field{--cr-toolbar-search-field-hover-background:none}:host-context([cros][chrome-refresh-2023]) .md-select{--md-arrow-width:7px;--md-select-bg-color:var(--cros-sys-input_field_on_base);--md-select-focus-shadow-color:transparent;--md-select-option-bg-color:var(--cros-sys-base_elevated);--md-select-side-padding:16px;--md-select-text-color:var(--cros-sys-on_surface);border:none;border-radius:8px;font:var(--cros-body-2-font);height:36px;line-height:36px}:host-context([cros][chrome-refresh-2023]) .md-select:hover{background-color:var(--md-select-bg-color)}:host-context([cros][chrome-refresh-2023]) .md-select[disabled]{background-color:var(--md-select-bg-color);border-color:transparent;color:var(--md-select-text-color);opacity:var(--cros-disabled-opacity)}:host-context(body.jelly-enabled),:host-context(body.jelly-enabled) cr-radio-button{--cr-radio-button-checked-color:var(--cros-sys-primary);--cr-radio-button-checked-ripple-color:var(--cros-sys-ripple_primary);--cr-radio-button-unchecked-color:var(--cros-sys-on_surface);--cr-radio-button-unchecked-ripple-color:var(--cros-sys-ripple_neutral_on_subtle)}:host-context([cros][chrome-refresh-2023]),:host-context([cros][chrome-refresh-2023]) cr-radio-button{--cr-radio-button-checked-color:var(--cros-sys-primary);--cr-radio-button-checked-ripple-color:var(--cros-sys-ripple_primary);--cr-radio-button-unchecked-color:var(--cros-sys-on_surface);--cr-radio-button-unchecked-ripple-color:var(--cros-sys-ripple_neutral_on_subtle);--cr-radio-button-ink-size:40px}:host-context([cros][chrome-refresh-2023]) cr-radio-button[disabled]{--cr-radio-button-checked-color:var(--cros-sys-disabled);--cr-radio-button-unchecked-color:var(--cros-sys-disabled)}:host-context(body.jelly-enabled) cr-card-radio-button{--cr-card-background-color:var(--cros-sys-app_base);--cr-checked-color:var(--cros-sys-primary);--cr-radio-button-checked-ripple-color:var(--cros-sys-ripple_primary);--hover-bg-color:var(--cros-sys-hover_on_subtle)}:host-context(body.jelly-enabled) cr-search-field{--cr-search-field-clear-icon-fill:var(--cros-sys-primary);--cr-search-field-clear-icon-margin-end:6px;--cr-search-field-input-border-bottom:none;--cr-search-field-input-padding-start:8px;--cr-search-field-input-underline-border-radius:4px;--cr-search-field-search-icon-display:none;--cr-search-field-search-icon-fill:var(--cros-sys-primary);--cr-search-field-search-icon-inline-display:block;--cr-search-field-search-icon-inline-margin-start:6px;border-radius:4px}:host-context([cros][chrome-refresh-2023]) cr-search-field{--cr-search-field-search-icon-fill:var(--cros-sys-secondary);--cr-search-field-search-icon-inline-margin-start:0;--cr-search-field-clear-icon-fill:var(--cros-sys-secondary);--cr-search-field-clear-icon-margin-end:6px;--cr-search-field-clear-icon-size:16px}:host-context([cros][chrome-refresh-2023]) cr-search-field::part(searchInput){--cr-input-padding-bottom:10px;--cr-input-padding-end:28px;--cr-input-padding-start:8px;--cr-input-padding-top:10px}:host-context(body.jelly-enabled) cr-slider{--cr-slider-active-color:var(--cros-sys-primary);--cr-slider-container-color:var(--cros-sys-primary_container);--cr-slider-container-disabled-color:var(--cros-sys-disabled_container);--cr-slider-disabled-color:var(--cros-sys-disabled);--cr-slider-knob-active-color:var(--cros-sys-primary);--cr-slider-knob-disabled-color:var(--cros-sys-disabled);--cr-slider-marker-active-color:var(--cros-sys-primary_container);--cr-slider-marker-color:var(--cros-sys-primary);--cr-slider-marker-disabled-color:var(--cros-sys-disabled);--cr-slider-ripple-color:var(--cros-sys-hover_on_prominent)}:host-context(body.jelly-enabled) cr-slider:not([disabled])::part(knob){background-color:var(--cros-sys-primary)}:host-context(body.jelly-enabled) cr-slider[disabled]::part(knob){border:none}:host-context(body.jelly-enabled) cr-slider::part(label){background:var(--cros-sys-primary);color:var(--cros-sys-on_primary)}:host-context(body.jelly-enabled) cr-toggle{--cr-toggle-checked-bar-color:var(--cros-sys-primary_container);--cr-toggle-checked-bar-opacity:100%;--cr-toggle-checked-button-color:var(--cros-sys-primary);--cr-toggle-checked-ripple-color:var(--cros-sys-hover_on_prominent);--cr-toggle-unchecked-bar-color:var(--cros-sys-secondary);--cr-toggle-unchecked-button-color:var(--cros-sys-surface_variant);--cr-toggle-unchecked-ripple-color:var(--cros-sys-hover_on_prominent);--cr-toggle-box-shadow:var(--cros-sys-app-elevation-1-shadow);--cr-toggle-ripple-diameter:32px}:host-context(body.jelly-enabled):host-context(.focus-outline-visible) cr-toggle:focus{--cr-toggle-ripple-ring:2px solid var(--cros-sys-focus_ring)}:host-context([cros][chrome-refresh-2023]) cr-toggle{--cr-toggle-bar-width:32px;--cr-toggle-knob-diameter:12px;--cr-toggle-bar-border:none;--cr-toggle-checked-bar-color:var(--cros-sys-primary);--cr-toggle-checked-button-color:var(--cros-sys-on_primary);--cr-toggle-unchecked-bar-color:var(--cros-sys-secondary);--cr-toggle-unchecked-button-color:var(--cros-sys-on_secondary);--color-toggle-button-thumb-on-hover:var(--cros-sys-on_primary);--cr-toggle-disabled-opacity:var(--cros-disabled-opacity)}:host-context([cros][chrome-refresh-2023]):host-context(.focus-outline-visible) cr-toggle:focus{--cr-toggle-ripple-ring:none}:host-context(body.jelly-enabled) paper-tooltip{--paper-tooltip-background:var(--cros-sys-on_surface);--paper-tooltip-border-radius:4px;--paper-tooltip-padding:5px 8px;--paper-tooltip-text-color:var(--cros-sys-inverse_on_surface)}:host-context(body.jelly-enabled) paper-tooltip::part(tooltip){font:var(--cros-annotation-1-font)}
    </style>
  </template>
`.content);
styleMod$a.register('cros-color-overrides');

const sheet = new CSSStyleSheet();
sheet.replaceSync(`html{--google-blue-50-rgb:232,240,254;--google-blue-50:rgb(var(--google-blue-50-rgb));--google-blue-100-rgb:210,227,252;--google-blue-100:rgb(var(--google-blue-100-rgb));--google-blue-200-rgb:174,203,250;--google-blue-200:rgb(var(--google-blue-200-rgb));--google-blue-300-rgb:138,180,248;--google-blue-300:rgb(var(--google-blue-300-rgb));--google-blue-400-rgb:102,157,246;--google-blue-400:rgb(var(--google-blue-400-rgb));--google-blue-500-rgb:66,133,244;--google-blue-500:rgb(var(--google-blue-500-rgb));--google-blue-600-rgb:26,115,232;--google-blue-600:rgb(var(--google-blue-600-rgb));--google-blue-700-rgb:25,103,210;--google-blue-700:rgb(var(--google-blue-700-rgb));--google-blue-800-rgb:24,90,188;--google-blue-800:rgb(var(--google-blue-800-rgb));--google-blue-900-rgb:23,78,166;--google-blue-900:rgb(var(--google-blue-900-rgb));--google-green-50-rgb:230,244,234;--google-green-50:rgb(var(--google-green-50-rgb));--google-green-200-rgb:168,218,181;--google-green-200:rgb(var(--google-green-200-rgb));--google-green-300-rgb:129,201,149;--google-green-300:rgb(var(--google-green-300-rgb));--google-green-400-rgb:91,185,116;--google-green-400:rgb(var(--google-green-400-rgb));--google-green-500-rgb:52,168,83;--google-green-500:rgb(var(--google-green-500-rgb));--google-green-600-rgb:30,142,62;--google-green-600:rgb(var(--google-green-600-rgb));--google-green-700-rgb:24,128,56;--google-green-700:rgb(var(--google-green-700-rgb));--google-green-800-rgb:19,115,51;--google-green-800:rgb(var(--google-green-800-rgb));--google-green-900-rgb:13,101,45;--google-green-900:rgb(var(--google-green-900-rgb));--google-grey-50-rgb:248,249,250;--google-grey-50:rgb(var(--google-grey-50-rgb));--google-grey-100-rgb:241,243,244;--google-grey-100:rgb(var(--google-grey-100-rgb));--google-grey-200-rgb:232,234,237;--google-grey-200:rgb(var(--google-grey-200-rgb));--google-grey-300-rgb:218,220,224;--google-grey-300:rgb(var(--google-grey-300-rgb));--google-grey-400-rgb:189,193,198;--google-grey-400:rgb(var(--google-grey-400-rgb));--google-grey-500-rgb:154,160,166;--google-grey-500:rgb(var(--google-grey-500-rgb));--google-grey-600-rgb:128,134,139;--google-grey-600:rgb(var(--google-grey-600-rgb));--google-grey-700-rgb:95,99,104;--google-grey-700:rgb(var(--google-grey-700-rgb));--google-grey-800-rgb:60,64,67;--google-grey-800:rgb(var(--google-grey-800-rgb));--google-grey-900-rgb:32,33,36;--google-grey-900:rgb(var(--google-grey-900-rgb));--google-grey-900-white-4-percent:#292a2d;--google-purple-200-rgb:215,174,251;--google-purple-200:rgb(var(--google-purple-200-rgb));--google-purple-900-rgb:104,29,168;--google-purple-900:rgb(var(--google-purple-900-rgb));--google-red-300-rgb:242,139,130;--google-red-300:rgb(var(--google-red-300-rgb));--google-red-500-rgb:234,67,53;--google-red-500:rgb(var(--google-red-500-rgb));--google-red-600-rgb:217,48,37;--google-red-600:rgb(var(--google-red-600-rgb));--google-yellow-50-rgb:254,247,224;--google-yellow-50:rgb(var(--google-yellow-50-rgb));--google-yellow-100-rgb:254,239,195;--google-yellow-100:rgb(var(--google-yellow-100-rgb));--google-yellow-200-rgb:253,226,147;--google-yellow-200:rgb(var(--google-yellow-200-rgb));--google-yellow-300-rgb:253,214,51;--google-yellow-300:rgb(var(--google-yellow-300-rgb));--google-yellow-400-rgb:252,201,52;--google-yellow-400:rgb(var(--google-yellow-400-rgb));--google-yellow-500-rgb:251,188,4;--google-yellow-500:rgb(var(--google-yellow-500-rgb));--cr-primary-text-color:var(--google-grey-900);--cr-secondary-text-color:var(--google-grey-700);--cr-card-background-color:white;--cr-shadow-color:var(--google-grey-800);--cr-shadow-key-color_:color-mix(in srgb,var(--cr-shadow-color) 30%,transparent);--cr-shadow-ambient-color_:color-mix(in srgb,var(--cr-shadow-color) 15%,transparent);--cr-elevation-1:var(--cr-shadow-key-color_) 0 1px 2px 0,var(--cr-shadow-ambient-color_) 0 1px 3px 1px;--cr-elevation-2:var(--cr-shadow-key-color_) 0 1px 2px 0,var(--cr-shadow-ambient-color_) 0 2px 6px 2px;--cr-elevation-3:var(--cr-shadow-key-color_) 0 1px 3px 0,var(--cr-shadow-ambient-color_) 0 4px 8px 3px;--cr-elevation-4:var(--cr-shadow-key-color_) 0 2px 3px 0,var(--cr-shadow-ambient-color_) 0 6px 10px 4px;--cr-elevation-5:var(--cr-shadow-key-color_) 0 4px 4px 0,var(--cr-shadow-ambient-color_) 0 8px 12px 6px;--cr-card-shadow:var(--cr-elevation-2);--cr-checked-color:var(--google-blue-600);--cr-focused-item-color:var(--google-grey-300);--cr-form-field-label-color:var(--google-grey-700);--cr-hairline-rgb:0,0,0;--cr-iph-anchor-highlight-color:rgba(var(--google-blue-600-rgb),0.1);--cr-link-color:var(--google-blue-700);--cr-menu-background-color:white;--cr-menu-background-focus-color:var(--google-grey-400);--cr-menu-shadow:0 2px 6px var(--paper-grey-500);--cr-separator-color:rgba(0,0,0,.06);--cr-title-text-color:rgb(90,90,90);--cr-toolbar-background-color:white;--cr-hover-background-color:rgba(var(--google-grey-900-rgb),.1);--cr-active-background-color:rgba(var(--google-grey-900-rgb),.16);--cr-focus-outline-color:rgba(var(--google-blue-600-rgb),.4);--paper-grey-500:#9e9e9e}@media (prefers-color-scheme:dark){html{--cr-primary-text-color:var(--google-grey-200);--cr-secondary-text-color:var(--google-grey-500);--cr-card-background-color:var(--google-grey-900-white-4-percent);--cr-card-shadow-color-rgb:0,0,0;--cr-checked-color:var(--google-blue-300);--cr-focused-item-color:var(--google-grey-800);--cr-form-field-label-color:var(--dark-secondary-color);--cr-hairline-rgb:255,255,255;--cr-iph-anchor-highlight-color:rgba(var(--google-grey-100-rgb),0.1);--cr-link-color:var(--google-blue-300);--cr-menu-background-color:var(--google-grey-900);--cr-menu-background-focus-color:var(--google-grey-700);--cr-menu-background-sheen:rgba(255,255,255,.06);--cr-menu-shadow:rgba(0,0,0,.3) 0 1px 2px 0,rgba(0,0,0,.15) 0 3px 6px 2px;--cr-separator-color:rgba(255,255,255,.1);--cr-title-text-color:var(--cr-primary-text-color);--cr-toolbar-background-color:var(--google-grey-900-white-4-percent);--cr-hover-background-color:rgba(255,255,255,.1);--cr-active-background-color:rgba(var(--google-grey-200-rgb),.16);--cr-focus-outline-color:rgba(var(--google-blue-300-rgb),.4)}}@media (forced-colors:active){html{--cr-focus-outline-hcm:2px solid transparent;--cr-border-hcm:2px solid transparent}}html{--cr-button-edge-spacing:12px;--cr-button-height:32px;--cr-controlled-by-spacing:24px;--cr-default-input-max-width:264px;--cr-icon-ripple-size:36px;--cr-icon-ripple-padding:8px;--cr-icon-size:20px;--cr-icon-button-margin-start:16px;--cr-icon-ripple-margin:calc(var(--cr-icon-ripple-padding) * -1);--cr-section-min-height:48px;--cr-section-two-line-min-height:64px;--cr-section-padding:20px;--cr-section-vertical-padding:12px;--cr-section-indent-width:40px;--cr-section-indent-padding:calc(var(--cr-section-padding) + var(--cr-section-indent-width));--cr-section-vertical-margin:21px;--cr-centered-card-max-width:680px;--cr-centered-card-width-percentage:0.96;--cr-hairline:1px solid rgba(var(--cr-hairline-rgb),.14);--cr-separator-height:1px;--cr-separator-line:var(--cr-separator-height) solid var(--cr-separator-color);--cr-toolbar-overlay-animation-duration:150ms;--cr-toolbar-height:56px;--cr-container-shadow-height:6px;--cr-container-shadow-margin:calc(-1 * var(--cr-container-shadow-height));--cr-container-shadow-max-opacity:1;--cr-card-border-radius:8px;--cr-disabled-opacity:.38;--cr-form-field-bottom-spacing:16px;--cr-form-field-label-font-size:.625rem;--cr-form-field-label-height:1em;--cr-form-field-label-line-height:1}html[chrome-refresh-2023]{--cr-fallback-color-outline:rgb(116,119,117);--cr-fallback-color-primary:rgb(11,87,208);--cr-fallback-color-on-primary:rgb(255,255,255);--cr-fallback-color-primary-container:rgb(211,227,253);--cr-fallback-color-on-primary-container:rgb(4,30,73);--cr-fallback-color-secondary-container:rgb(194,231,255);--cr-fallback-color-on-secondary-container:rgb(0,29,53);--cr-fallback-color-neutral-container:rgb(242,242,242);--cr-fallback-color-neutral-outline:rgb(199,199,199);--cr-fallback-color-surface:rgb(255,255,255);--cr-fallback-color-on-surface-rgb:31,31,31;--cr-fallback-color-on-surface:rgb(var(--cr-fallback-color-on-surface-rgb));--cr-fallback-color-surface-variant:rgb(225,227,225);--cr-fallback-color-on-surface-variant:rgb(68,71,70);--cr-fallback-color-on-surface-subtle:rgb(71,71,71);--cr-fallback-color-inverse-primary:rgb(168,199,250);--cr-fallback-color-inverse-surface:rgb(48,48,48);--cr-fallback-color-inverse-on-surface:rgb(242,242,242);--cr-fallback-color-tonal-container:rgb(211,227,253);--cr-fallback-color-on-tonal-container:rgb(4,30,73);--cr-fallback-color-tonal-outline:rgb(168,199,250);--cr-fallback-color-error:rgb(179,38,30);--cr-fallback-color-divider:rgb(211,227,253);--cr-fallback-color-state-hover-on-prominent_:rgba(253,252,251,.1);--cr-fallback-color-state-on-subtle-rgb_:31,31,31;--cr-fallback-color-state-hover-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.06);--cr-fallback-color-state-ripple-neutral-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.08);--cr-fallback-color-state-ripple-primary-rgb_:124,172,248;--cr-fallback-color-state-ripple-primary_:rgba(var(--cr-fallback-color-state-ripple-primary-rgb_),0.32);--cr-fallback-color-base-container:rgba(105,145,214,.12);--cr-fallback-color-disabled-background:rgba(var(--cr-fallback-color-on-surface-rgb),.12);--cr-fallback-color-disabled-foreground:rgba(var(--cr-fallback-color-on-surface-rgb),var(--cr-disabled-opacity));--cr-hover-background-color:var(--color-sys-state-hover,rgba(var(--cr-fallback-color-on-surface-rgb),.08));--cr-hover-on-prominent-background-color:var(--color-sys-state-hover-on-prominent,var(--cr-fallback-color-state-hover-on-prominent_));--cr-hover-on-subtle-background-color:var(--color-sys-state-hover-on-subtle,var(--cr-fallback-color-state-hover-on-subtle_));--cr-active-background-color:var(--color-sys-state-pressed,rgba(var(--cr-fallback-color-on-surface-rgb),.12));--cr-active-on-primary-background-color:var(--color-sys-state-ripple-primary,var(--cr-fallback-color-state-ripple-primary_));--cr-active-neutral-on-subtle-background-color:var(--color-sys-state-ripple-neutral-on-subtle,var(--cr-fallback-color-state-ripple-neutral-on-subtle_));--cr-focus-outline-color:var(--color-sys-state-focus-ring,var(--cr-fallback-color-primary));--cr-primary-text-color:var(--color-primary-foreground,var(--cr-fallback-color-on-surface));--cr-secondary-text-color:var(--color-secondary-foreground,var(--cr-fallback-color-on-surface-variant));--cr-link-color:var(--color-link-foreground-default,var(--cr-fallback-color-primary));--cr-button-height:36px;--cr-shadow-color:var(--color-sys-shadow,rgb(0,0,0))}@media (prefers-color-scheme:dark){html[chrome-refresh-2023]{--cr-fallback-color-outline:rgb(142,145,143);--cr-fallback-color-primary:rgb(168,199,250);--cr-fallback-color-on-primary:rgb(6,46,111);--cr-fallback-color-primary-container:rgb(8,66,160);--cr-fallback-color-on-primary-container:rgb(211,227,253);--cr-fallback-color-secondary-container:rgb(0,74,119);--cr-fallback-color-on-secondary-container:rgb(194,231,255);--cr-fallback-color-neutral-container:rgb(42,42,42);--cr-fallback-color-neutral-outline:rgb(117,117,117);--cr-fallback-color-surface:rgb(26,27,30);--cr-fallback-color-on-surface-rgb:227,227,227;--cr-fallback-color-surface-variant:rgb(68,71,70);--cr-fallback-color-on-surface-variant:rgb(196,199,197);--cr-fallback-color-on-surface-subtle:rgb(199,199,199);--cr-fallback-color-inverse-primary:rgb(11,87,208);--cr-fallback-color-inverse-surface:rgb(227,227,227);--cr-fallback-color-inverse-on-surface:rgb(31,31,31);--cr-fallback-color-tonal-container:rgb(0,74,119);--cr-fallback-color-on-tonal-container:rgb(194,231,255);--cr-fallback-color-tonal-outline:rgb(0,99,155);--cr-fallback-color-error:rgb(242,184,181);--cr-fallback-color-divider:rgb(71,71,71);--cr-fallback-color-state-hover-on-prominent_:rgba(31,31,31,.06);--cr-fallback-color-state-on-subtle-rgb_:253,252,251;--cr-fallback-color-state-hover-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.10);--cr-fallback-color-state-ripple-neutral-on-subtle_:rgba(var(--cr-fallback-color-state-on-subtle-rgb_),.16);--cr-fallback-color-state-ripple-primary-rgb_:76,141,246;--cr-fallback-color-base-container:rgba(40,40,40,1)}}@media (forced-colors:active){html[chrome-refresh-2023]{--cr-fallback-color-disabled-background:Canvas;--cr-fallback-color-disabled-foreground:GrayText}}`);
document.adoptedStyleSheets = [...document.adoptedStyleSheets, sheet];

const styleMod$9 = document.createElement('dom-module');
styleMod$9.appendChild(html `
  <template>
    <style include="cros-color-overrides">
[hidden]{display:none !important}:host{--personalization-app-breadcrumb-height:56px;--personalization-app-subpage-container-min-height:calc(100vh - var(--personalization-app-breadcrumb-height));--personalization-app-grid-item-background-color:var(--cros-sys-secondary_container);--personalization-app-grid-item-border-radius:16px;--personalization-app-grid-item-height:120px;--personalization-app-grid-item-spacing:20px;--personalization-app-text-shadow-elevation-1:0 1px 3px rgba(0,0,0,15%),0 1px 2px rgba(0,0,0,30%);--personalization-app-second-tone-opacity:0.3;--personalization-app-label-font:var(--cros-button-2-font)}@keyframes ripple{from{opacity:1}9%{opacity:0.15}15.8%{opacity:0.15}24.9%{opacity:1}to{opacity:1}}.placeholder{animation:2210ms linear var(--animation-delay,1s) infinite ripple}.placeholder.placeholder-no-animation{animation:none}.preview-container{background-color:var(--cros-bg-color);border:none;border-radius:16px}.preview-text-container,.preview-text-placeholder{align-items:flex-start;display:flex;flex-flow:column nowrap;margin:0}.preview-text-container{justify-content:flex-end}.preview-text-placeholder{justify-content:center}.placeholder{background-color:var(--personalization-app-grid-item-background-color);border-radius:16px}.preview-image-container{border-radius:16px;box-sizing:border-box;overflow:hidden;position:relative}.preview-image-border,.photo-images-border,.wallpaper-grid-item-border{border:1px solid rgba(0,0,0,0.08);border-radius:16px;bottom:0;box-sizing:border-box;left:0;pointer-events:none;position:absolute;right:0;top:0;z-index:2}.preview-image{height:100%;object-fit:cover;width:100%}.preview-text-container>*,.preview-text-placeholder>*{margin:0;max-width:100%;overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.preview-text-container>*+*{margin-top:4px}.preview-text-placeholder>*+*{margin-top:8px}.preview-text-container>span:first-child{color:var(--cros-text-color-secondary);font:var(--cros-body-2-font)}.preview-text-placeholder>.placeholder:first-child{--animation-delay:calc(1s + 83ms);height:20px;width:20%}.preview-text-container>span:nth-child(2){color:var(--cros-text-color-primary);font:var(--cros-display-6-font)}.preview-text-placeholder>.placeholder:nth-child(2){--animation-delay:calc(1s + 83ms * 2);height:24px;width:75%}.preview-text-container>span:nth-child(n+3){color:var(--cros-text-color-secondary);font:var(--cros-body-1-font)}.preview-text-placeholder>.placeholder:nth-child(n+3){--animation-delay:calc(1s + 83ms * 3);height:20px;width:33%}.ambient-subpage-element-title{color:var(--cros-text-color-primary);font:var(--personalization-app-label-font);margin:20px 10px 16px 10px}.ambient-toggle-row-container{border:none;border-radius:8px;display:flex;flex-flow:column nowrap;height:48px;width:100%}.ambient-toggle-row{align-items:center;display:flex;flex:1;flex-flow:row nowrap;justify-content:space-between;margin:0}.ambient-toggle-row+.ambient-toggle-row{border-top:1px solid var(--cros-separator-color)}.ambient-toggle-row>p{color:var(--cros-text-color-secondary);font:var(--cros-body-2-font);height:20px;margin:0}.clickable{cursor:pointer}.leftspacertop{grid-area:leftspacertop}.leftspacerbottom{border-radius:12px 0 0 12px;grid-area:leftspacerbottom}.rightspacertop{grid-area:rightspacertop}.rightspacerbottom{border-radius:0 12px 12px 0;grid-area:rightspacerbottom}div[class$='spacertop']{background-color:var(--cros-sys-app_base_shaded)}div[class$='spacerbottom']{background-color:var(--cros-bg-color)}:host-context([dir=rtl]) iron-icon[icon='cr:chevron-right']{transform:scaleX(-1)}.ellipsis{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}.disabled{opacity:var(--cros-disabled-opacity)}img.disabled{opacity:50%}cr-action-menu::part(dialog){overscroll-behavior:contain}a[href]{color:var(--cros-sys-primary)}
    </style>
  </template>
`.content);
styleMod$9.register('common');

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/

/**
 * Chrome uses an older version of DOM Level 3 Keyboard Events
 *
 * Most keys are labeled as text, but some are Unicode codepoints.
 * Values taken from:
 * http://www.w3.org/TR/2007/WD-DOM-Level-3-Events-20071221/keyset.html#KeySet-Set
 */
var KEY_IDENTIFIER = {
  'U+0008': 'backspace',
  'U+0009': 'tab',
  'U+001B': 'esc',
  'U+0020': 'space',
  'U+007F': 'del'
};

/**
 * Special table for KeyboardEvent.keyCode.
 * KeyboardEvent.keyIdentifier is better, and KeyBoardEvent.key is even better
 * than that.
 *
 * Values from:
 * https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent.keyCode#Value_of_keyCode
 */
var KEY_CODE = {
  8: 'backspace',
  9: 'tab',
  13: 'enter',
  27: 'esc',
  33: 'pageup',
  34: 'pagedown',
  35: 'end',
  36: 'home',
  32: 'space',
  37: 'left',
  38: 'up',
  39: 'right',
  40: 'down',
  46: 'del',
  106: '*'
};

/**
 * MODIFIER_KEYS maps the short name for modifier keys used in a key
 * combo string to the property name that references those same keys
 * in a KeyboardEvent instance.
 */
var MODIFIER_KEYS = {
  'shift': 'shiftKey',
  'ctrl': 'ctrlKey',
  'alt': 'altKey',
  'meta': 'metaKey'
};

/**
 * KeyboardEvent.key is mostly represented by printable character made by
 * the keyboard, with unprintable keys labeled nicely.
 *
 * However, on OS X, Alt+char can make a Unicode character that follows an
 * Apple-specific mapping. In this case, we fall back to .keyCode.
 */
var KEY_CHAR = /[a-z0-9*]/;

/**
 * Matches a keyIdentifier string.
 */
var IDENT_CHAR = /U\+/;

/**
 * Matches arrow keys in Gecko 27.0+
 */
var ARROW_KEY = /^arrow/;

/**
 * Matches space keys everywhere (notably including IE10's exceptional name
 * `spacebar`).
 */
var SPACE_KEY = /^space(bar)?/;

/**
 * Matches ESC key.
 *
 * Value from: http://w3c.github.io/uievents-key/#key-Escape
 */
var ESC_KEY = /^escape$/;

/**
 * Transforms the key.
 * @param {string} key The KeyBoardEvent.key
 * @param {Boolean} [noSpecialChars] Limits the transformation to
 * alpha-numeric characters.
 */
function transformKey(key, noSpecialChars) {
  var validKey = '';
  if (key) {
    var lKey = key.toLowerCase();
    if (lKey === ' ' || SPACE_KEY.test(lKey)) {
      validKey = 'space';
    } else if (ESC_KEY.test(lKey)) {
      validKey = 'esc';
    } else if (lKey.length == 1) {
      if (!noSpecialChars || KEY_CHAR.test(lKey)) {
        validKey = lKey;
      }
    } else if (ARROW_KEY.test(lKey)) {
      validKey = lKey.replace('arrow', '');
    } else if (lKey == 'multiply') {
      // numpad '*' can map to Multiply on IE/Windows
      validKey = '*';
    } else {
      validKey = lKey;
    }
  }
  return validKey;
}

function transformKeyIdentifier(keyIdent) {
  var validKey = '';
  if (keyIdent) {
    if (keyIdent in KEY_IDENTIFIER) {
      validKey = KEY_IDENTIFIER[keyIdent];
    } else if (IDENT_CHAR.test(keyIdent)) {
      keyIdent = parseInt(keyIdent.replace('U+', '0x'), 16);
      validKey = String.fromCharCode(keyIdent).toLowerCase();
    } else {
      validKey = keyIdent.toLowerCase();
    }
  }
  return validKey;
}

function transformKeyCode(keyCode) {
  var validKey = '';
  if (Number(keyCode)) {
    if (keyCode >= 65 && keyCode <= 90) {
      // ascii a-z
      // lowercase is 32 offset from uppercase
      validKey = String.fromCharCode(32 + keyCode);
    } else if (keyCode >= 112 && keyCode <= 123) {
      // function keys f1-f12
      validKey = 'f' + (keyCode - 112 + 1);
    } else if (keyCode >= 48 && keyCode <= 57) {
      // top 0-9 keys
      validKey = String(keyCode - 48);
    } else if (keyCode >= 96 && keyCode <= 105) {
      // num pad 0-9
      validKey = String(keyCode - 96);
    } else {
      validKey = KEY_CODE[keyCode];
    }
  }
  return validKey;
}

/**
 * Calculates the normalized key for a KeyboardEvent.
 * @param {KeyboardEvent} keyEvent
 * @param {Boolean} [noSpecialChars] Set to true to limit keyEvent.key
 * transformation to alpha-numeric chars. This is useful with key
 * combinations like shift + 2, which on FF for MacOS produces
 * keyEvent.key = @
 * To get 2 returned, set noSpecialChars = true
 * To get @ returned, set noSpecialChars = false
 */
function normalizedKeyForEvent(keyEvent, noSpecialChars) {
  // Fall back from .key, to .detail.key for artifical keyboard events,
  // and then to deprecated .keyIdentifier and .keyCode.
  if (keyEvent.key) {
    return transformKey(keyEvent.key, noSpecialChars);
  }
  if (keyEvent.detail && keyEvent.detail.key) {
    return transformKey(keyEvent.detail.key, noSpecialChars);
  }
  return transformKeyIdentifier(keyEvent.keyIdentifier) ||
      transformKeyCode(keyEvent.keyCode) || '';
}

function keyComboMatchesEvent(keyCombo, event) {
  // For combos with modifiers we support only alpha-numeric keys
  var keyEvent = normalizedKeyForEvent(event, keyCombo.hasModifiers);
  return keyEvent === keyCombo.key &&
      (!keyCombo.hasModifiers ||
       (!!event.shiftKey === !!keyCombo.shiftKey &&
        !!event.ctrlKey === !!keyCombo.ctrlKey &&
        !!event.altKey === !!keyCombo.altKey &&
        !!event.metaKey === !!keyCombo.metaKey));
}

function parseKeyComboString(keyComboString) {
  if (keyComboString.length === 1) {
    return {combo: keyComboString, key: keyComboString, event: 'keydown'};
  }
  return keyComboString.split('+')
      .reduce(function(parsedKeyCombo, keyComboPart) {
        var eventParts = keyComboPart.split(':');
        var keyName = eventParts[0];
        var event = eventParts[1];

        if (keyName in MODIFIER_KEYS) {
          parsedKeyCombo[MODIFIER_KEYS[keyName]] = true;
          parsedKeyCombo.hasModifiers = true;
        } else {
          parsedKeyCombo.key = keyName;
          parsedKeyCombo.event = event || 'keydown';
        }

        return parsedKeyCombo;
      }, {combo: keyComboString.split(':').shift()});
}

function parseEventString(eventString) {
  return eventString.trim().split(' ').map(function(keyComboString) {
    return parseKeyComboString(keyComboString);
  });
}

/**
 * `Polymer.IronA11yKeysBehavior` provides a normalized interface for processing
 * keyboard commands that pertain to [WAI-ARIA best
 * practices](http://www.w3.org/TR/wai-aria-practices/#kbd_general_binding). The
 * element takes care of browser differences with respect to Keyboard events and
 * uses an expressive syntax to filter key presses.
 *
 * Use the `keyBindings` prototype property to express what combination of keys
 * will trigger the callback. A key binding has the format
 * `"KEY+MODIFIER:EVENT": "callback"` (`"KEY": "callback"` or
 * `"KEY:EVENT": "callback"` are valid as well). Some examples:
 *
 *      keyBindings: {
 *        'space': '_onKeydown', // same as 'space:keydown'
 *        'shift+tab': '_onKeydown',
 *        'enter:keypress': '_onKeypress',
 *        'esc:keyup': '_onKeyup'
 *      }
 *
 * The callback will receive with an event containing the following information
 * in `event.detail`:
 *
 *      _onKeydown: function(event) {
 *        console.log(event.detail.combo); // KEY+MODIFIER, e.g. "shift+tab"
 *        console.log(event.detail.key); // KEY only, e.g. "tab"
 *        console.log(event.detail.event); // EVENT, e.g. "keydown"
 *        console.log(event.detail.keyboardEvent); // the original KeyboardEvent
 *      }
 *
 * Use the `keyEventTarget` attribute to set up event handlers on a specific
 * node.
 *
 * See the [demo source
 * code](https://github.com/PolymerElements/iron-a11y-keys-behavior/blob/master/demo/x-key-aware.html)
 * for an example.
 *
 * @demo demo/index.html
 * @polymerBehavior
 */
const IronA11yKeysBehavior = {
  properties: {
    /**
     * The EventTarget that will be firing relevant KeyboardEvents. Set it to
     * `null` to disable the listeners.
     * @type {?EventTarget}
     */
    keyEventTarget: {
      type: Object,
      value: function() {
        return this;
      }
    },

    /**
     * If true, this property will cause the implementing element to
     * automatically stop propagation on any handled KeyboardEvents.
     */
    stopKeyboardEventPropagation: {type: Boolean, value: false},

    _boundKeyHandlers: {
      type: Array,
      value: function() {
        return [];
      }
    },

    // We use this due to a limitation in IE10 where instances will have
    // own properties of everything on the "prototype".
    _imperativeKeyBindings: {
      type: Object,
      value: function() {
        return {};
      }
    }
  },

  observers: ['_resetKeyEventListeners(keyEventTarget, _boundKeyHandlers)'],


  /**
   * To be used to express what combination of keys  will trigger the relative
   * callback. e.g. `keyBindings: { 'esc': '_onEscPressed'}`
   * @type {!Object}
   */
  keyBindings: {},

  registered: function() {
    this._prepKeyBindings();
  },

  attached: function() {
    this._listenKeyEventListeners();
  },

  detached: function() {
    this._unlistenKeyEventListeners();
  },

  /**
   * Can be used to imperatively add a key binding to the implementing
   * element. This is the imperative equivalent of declaring a keybinding
   * in the `keyBindings` prototype property.
   *
   * @param {string} eventString
   * @param {string} handlerName
   */
  addOwnKeyBinding: function(eventString, handlerName) {
    this._imperativeKeyBindings[eventString] = handlerName;
    this._prepKeyBindings();
    this._resetKeyEventListeners();
  },

  /**
   * When called, will remove all imperatively-added key bindings.
   */
  removeOwnKeyBindings: function() {
    this._imperativeKeyBindings = {};
    this._prepKeyBindings();
    this._resetKeyEventListeners();
  },

  /**
   * Returns true if a keyboard event matches `eventString`.
   *
   * @param {KeyboardEvent} event
   * @param {string} eventString
   * @return {boolean}
   */
  keyboardEventMatchesKeys: function(event, eventString) {
    var keyCombos = parseEventString(eventString);
    for (var i = 0; i < keyCombos.length; ++i) {
      if (keyComboMatchesEvent(keyCombos[i], event)) {
        return true;
      }
    }
    return false;
  },

  _collectKeyBindings: function() {
    var keyBindings = this.behaviors.map(function(behavior) {
      return behavior.keyBindings;
    });

    if (keyBindings.indexOf(this.keyBindings) === -1) {
      keyBindings.push(this.keyBindings);
    }

    return keyBindings;
  },

  _prepKeyBindings: function() {
    this._keyBindings = {};

    this._collectKeyBindings().forEach(function(keyBindings) {
      for (var eventString in keyBindings) {
        this._addKeyBinding(eventString, keyBindings[eventString]);
      }
    }, this);

    for (var eventString in this._imperativeKeyBindings) {
      this._addKeyBinding(
          eventString, this._imperativeKeyBindings[eventString]);
    }

    // Give precedence to combos with modifiers to be checked first.
    for (var eventName in this._keyBindings) {
      this._keyBindings[eventName].sort(function(kb1, kb2) {
        var b1 = kb1[0].hasModifiers;
        var b2 = kb2[0].hasModifiers;
        return (b1 === b2) ? 0 : b1 ? -1 : 1;
      });
    }
  },

  _addKeyBinding: function(eventString, handlerName) {
    parseEventString(eventString).forEach(function(keyCombo) {
      this._keyBindings[keyCombo.event] =
          this._keyBindings[keyCombo.event] || [];

      this._keyBindings[keyCombo.event].push([keyCombo, handlerName]);
    }, this);
  },

  _resetKeyEventListeners: function() {
    this._unlistenKeyEventListeners();

    if (this.isAttached) {
      this._listenKeyEventListeners();
    }
  },

  _listenKeyEventListeners: function() {
    if (!this.keyEventTarget) {
      return;
    }
    Object.keys(this._keyBindings).forEach(function(eventName) {
      var keyBindings = this._keyBindings[eventName];
      var boundKeyHandler = this._onKeyBindingEvent.bind(this, keyBindings);

      this._boundKeyHandlers.push(
          [this.keyEventTarget, eventName, boundKeyHandler]);

      this.keyEventTarget.addEventListener(eventName, boundKeyHandler);
    }, this);
  },

  _unlistenKeyEventListeners: function() {
    var keyHandlerTuple;
    var keyEventTarget;
    var eventName;
    var boundKeyHandler;

    while (this._boundKeyHandlers.length) {
      // My kingdom for block-scope binding and destructuring assignment..
      keyHandlerTuple = this._boundKeyHandlers.pop();
      keyEventTarget = keyHandlerTuple[0];
      eventName = keyHandlerTuple[1];
      boundKeyHandler = keyHandlerTuple[2];

      keyEventTarget.removeEventListener(eventName, boundKeyHandler);
    }
  },

  _onKeyBindingEvent: function(keyBindings, event) {
    if (this.stopKeyboardEventPropagation) {
      event.stopPropagation();
    }

    // if event has been already prevented, don't do anything
    if (event.defaultPrevented) {
      return;
    }

    for (var i = 0; i < keyBindings.length; i++) {
      var keyCombo = keyBindings[i][0];
      var handlerName = keyBindings[i][1];
      if (keyComboMatchesEvent(keyCombo, event)) {
        this._triggerKeyHandler(keyCombo, handlerName, event);
        // exit the loop if eventDefault was prevented
        if (event.defaultPrevented) {
          return;
        }
      }
    }
  },

  _triggerKeyHandler: function(keyCombo, handlerName, keyboardEvent) {
    var detail = Object.create(keyCombo);
    detail.keyboardEvent = keyboardEvent;
    var event =
        new CustomEvent(keyCombo.event, {detail: detail, cancelable: true});
    this[handlerName].call(this, event);
    if (event.defaultPrevented) {
      keyboardEvent.preventDefault();
    }
  }
};

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/

// Contains all connected resizables that do not have a parent.
var ORPHANS = new Set();

/**
 * `IronResizableBehavior` is a behavior that can be used in Polymer elements to
 * coordinate the flow of resize events between "resizers" (elements that
 *control the size or hidden state of their children) and "resizables" (elements
 *that need to be notified when they are resized or un-hidden by their parents
 *in order to take action on their new measurements).
 *
 * Elements that perform measurement should add the `IronResizableBehavior`
 *behavior to their element definition and listen for the `iron-resize` event on
 *themselves. This event will be fired when they become showing after having
 *been hidden, when they are resized explicitly by another resizable, or when
 *the window has been resized.
 *
 * Note, the `iron-resize` event is non-bubbling.
 *
 * @polymerBehavior
 * @demo demo/index.html
 **/
const IronResizableBehavior = {
  properties: {
    /**
     * The closest ancestor element that implements `IronResizableBehavior`.
     */
    _parentResizable: {
      type: Object,
      observer: '_parentResizableChanged',
    },

    /**
     * True if this element is currently notifying its descendant elements of
     * resize.
     */
    _notifyingDescendant: {
      type: Boolean,
      value: false,
    }
  },

  listeners: {
    'iron-request-resize-notifications': '_onIronRequestResizeNotifications'
  },

  created: function() {
    // We don't really need property effects on these, and also we want them
    // to be created before the `_parentResizable` observer fires:
    this._interestedResizables = [];
    this._boundNotifyResize = this.notifyResize.bind(this);
    this._boundOnDescendantIronResize = this._onDescendantIronResize.bind(this);
  },

  attached: function() {
    this._requestResizeNotifications();
  },

  detached: function() {
    if (this._parentResizable) {
      this._parentResizable.stopResizeNotificationsFor(this);
    } else {
      ORPHANS.delete(this);
      window.removeEventListener('resize', this._boundNotifyResize);
    }

    this._parentResizable = null;
  },

  /**
   * Can be called to manually notify a resizable and its descendant
   * resizables of a resize change.
   */
  notifyResize: function() {
    if (!this.isAttached) {
      return;
    }

    this._interestedResizables.forEach(function(resizable) {
      if (this.resizerShouldNotify(resizable)) {
        this._notifyDescendant(resizable);
      }
    }, this);

    this._fireResize();
  },

  /**
   * Used to assign the closest resizable ancestor to this resizable
   * if the ancestor detects a request for notifications.
   */
  assignParentResizable: function(parentResizable) {
    if (this._parentResizable) {
      this._parentResizable.stopResizeNotificationsFor(this);
    }

    this._parentResizable = parentResizable;

    if (parentResizable &&
        parentResizable._interestedResizables.indexOf(this) === -1) {
      parentResizable._interestedResizables.push(this);
      parentResizable._subscribeIronResize(this);
    }
  },

  /**
   * Used to remove a resizable descendant from the list of descendants
   * that should be notified of a resize change.
   */
  stopResizeNotificationsFor: function(target) {
    var index = this._interestedResizables.indexOf(target);

    if (index > -1) {
      this._interestedResizables.splice(index, 1);
      this._unsubscribeIronResize(target);
    }
  },

  /**
   * Subscribe this element to listen to iron-resize events on the given target.
   *
   * Preferred over target.listen because the property renamer does not
   * understand to rename when the target is not specifically "this"
   *
   * @param {!HTMLElement} target Element to listen to for iron-resize events.
   */
  _subscribeIronResize: function(target) {
    target.addEventListener('iron-resize', this._boundOnDescendantIronResize);
  },

  /**
   * Unsubscribe this element from listening to to iron-resize events on the
   * given target.
   *
   * Preferred over target.unlisten because the property renamer does not
   * understand to rename when the target is not specifically "this"
   *
   * @param {!HTMLElement} target Element to listen to for iron-resize events.
   */
  _unsubscribeIronResize: function(target) {
    target.removeEventListener(
        'iron-resize', this._boundOnDescendantIronResize);
  },

  /**
   * This method can be overridden to filter nested elements that should or
   * should not be notified by the current element. Return true if an element
   * should be notified, or false if it should not be notified.
   *
   * @param {HTMLElement} element A candidate descendant element that
   * implements `IronResizableBehavior`.
   * @return {boolean} True if the `element` should be notified of resize.
   */
  resizerShouldNotify: function(element) {
    return true;
  },

  _onDescendantIronResize: function(event) {
    if (this._notifyingDescendant) {
      event.stopPropagation();
      return;
    }

    // no need to use this during shadow dom because of event retargeting
    if (!useShadow) {
      this._fireResize();
    }
  },

  _fireResize: function() {
    this.fire('iron-resize', null, {node: this, bubbles: false});
  },

  _onIronRequestResizeNotifications: function(event) {
    var target = /** @type {!EventTarget} */ (dom(event).rootTarget);
    if (target === this) {
      return;
    }

    target.assignParentResizable(this);
    this._notifyDescendant(target);

    event.stopPropagation();
  },

  _parentResizableChanged: function(parentResizable) {
    if (parentResizable) {
      window.removeEventListener('resize', this._boundNotifyResize);
    }
  },

  _notifyDescendant: function(descendant) {
    // NOTE(cdata): In IE10, attached is fired on children first, so it's
    // important not to notify them if the parent is not attached yet (or
    // else they will get redundantly notified when the parent attaches).
    if (!this.isAttached) {
      return;
    }

    this._notifyingDescendant = true;
    descendant.notifyResize();
    this._notifyingDescendant = false;
  },

  _requestResizeNotifications: function() {
    if (!this.isAttached) {
      return;
    }

    if (document.readyState === 'loading') {
      var _requestResizeNotifications =
          this._requestResizeNotifications.bind(this);
      document.addEventListener(
          'readystatechange', function readystatechanged() {
            document.removeEventListener('readystatechange', readystatechanged);
            _requestResizeNotifications();
          });
    } else {
      this._findParent();

      if (!this._parentResizable) {
        // If this resizable is an orphan, tell other orphans to try to find
        // their parent again, in case it's this resizable.
        ORPHANS.forEach(function(orphan) {
          if (orphan !== this) {
            orphan._findParent();
          }
        }, this);

        window.addEventListener('resize', this._boundNotifyResize);
        this.notifyResize();
      } else {
        // If this resizable has a parent, tell other child resizables of
        // that parent to try finding their parent again, in case it's this
        // resizable.
        this._parentResizable._interestedResizables
            .forEach(function(resizable) {
              if (resizable !== this) {
                resizable._findParent();
              }
            }, this);
      }
    }
  },

  _findParent: function() {
    this.assignParentResizable(null);
    this.fire(
        'iron-request-resize-notifications',
        null,
        {node: this, bubbles: true, cancelable: true});

    if (!this._parentResizable) {
      ORPHANS.add(this);
    } else {
      ORPHANS.delete(this);
    }
  }
};

/**
@license
Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/

/**
 * `Polymer.IronScrollTargetBehavior` allows an element to respond to scroll
 * events from a designated scroll target.
 *
 * Elements that consume this behavior can override the `_scrollHandler`
 * method to add logic on the scroll event.
 *
 * @demo demo/scrolling-region.html Scrolling Region
 * @demo demo/document.html Document Element
 * @polymerBehavior
 */
const IronScrollTargetBehavior = {

  properties: {

    /**
     * Specifies the element that will handle the scroll event
     * on the behalf of the current element. This is typically a reference to an
     *element, but there are a few more posibilities:
     *
     * ### Elements id
     *
     *```html
     * <div id="scrollable-element" style="overflow: auto;">
     *  <x-element scroll-target="scrollable-element">
     *    <!-- Content-->
     *  </x-element>
     * </div>
     *```
     * In this case, the `scrollTarget` will point to the outer div element.
     *
     * ### Document scrolling
     *
     * For document scrolling, you can use the reserved word `document`:
     *
     *```html
     * <x-element scroll-target="document">
     *   <!-- Content -->
     * </x-element>
     *```
     *
     * ### Elements reference
     *
     *```js
     * appHeader.scrollTarget = document.querySelector('#scrollable-element');
     *```
     *
     * @type {HTMLElement}
     * @default document
     */
    scrollTarget: {
      type: HTMLElement,
      value: function() {
        return this._defaultScrollTarget;
      }
    }
  },

  observers: ['_scrollTargetChanged(scrollTarget, isAttached)'],

  /**
   * True if the event listener should be installed.
   */
  _shouldHaveListener: true,

  _scrollTargetChanged: function(scrollTarget, isAttached) {

    if (this._oldScrollTarget) {
      this._toggleScrollListener(false, this._oldScrollTarget);
      this._oldScrollTarget = null;
    }
    if (!isAttached) {
      return;
    }
    // Support element id references
    if (scrollTarget === 'document') {
      this.scrollTarget = this._doc;

    } else if (typeof scrollTarget === 'string') {
      var domHost = this.domHost;

      this.scrollTarget = domHost && domHost.$ ?
          domHost.$[scrollTarget] :
          dom(this.ownerDocument).querySelector('#' + scrollTarget);

    } else if (this._isValidScrollTarget()) {
      this._oldScrollTarget = scrollTarget;
      this._toggleScrollListener(this._shouldHaveListener, scrollTarget);
    }
  },

  /**
   * Runs on every scroll event. Consumer of this behavior may override this
   * method.
   *
   * @protected
   */
  _scrollHandler: function scrollHandler() {},

  /**
   * The default scroll target. Consumers of this behavior may want to customize
   * the default scroll target.
   *
   * @type {Element}
   */
  get _defaultScrollTarget() {
    return this._doc;
  },

  /**
   * Shortcut for the document element
   *
   * @type {Element}
   */
  get _doc() {
    return this.ownerDocument.documentElement;
  },

  /**
   * Gets the number of pixels that the content of an element is scrolled
   * upward.
   *
   * @type {number}
   */
  get _scrollTop() {
    if (this._isValidScrollTarget()) {
      return this.scrollTarget === this._doc ? window.pageYOffset :
                                               this.scrollTarget.scrollTop;
    }
    return 0;
  },

  /**
   * Gets the number of pixels that the content of an element is scrolled to the
   * left.
   *
   * @type {number}
   */
  get _scrollLeft() {
    if (this._isValidScrollTarget()) {
      return this.scrollTarget === this._doc ? window.pageXOffset :
                                               this.scrollTarget.scrollLeft;
    }
    return 0;
  },

  /**
   * Sets the number of pixels that the content of an element is scrolled
   * upward.
   *
   * @type {number}
   */
  set _scrollTop(top) {
    if (this.scrollTarget === this._doc) {
      window.scrollTo(window.pageXOffset, top);
    } else if (this._isValidScrollTarget()) {
      this.scrollTarget.scrollTop = top;
    }
  },

  /**
   * Sets the number of pixels that the content of an element is scrolled to the
   * left.
   *
   * @type {number}
   */
  set _scrollLeft(left) {
    if (this.scrollTarget === this._doc) {
      window.scrollTo(left, window.pageYOffset);
    } else if (this._isValidScrollTarget()) {
      this.scrollTarget.scrollLeft = left;
    }
  },

  /**
   * Scrolls the content to a particular place.
   *
   * @method scroll
   * @param {number|!{left: number, top: number}} leftOrOptions The left position or scroll options
   * @param {number=} top The top position
   * @return {void}
   */
  scroll: function(leftOrOptions, top) {
    var left;

    if (typeof leftOrOptions === 'object') {
      left = leftOrOptions.left;
      top = leftOrOptions.top;
    } else {
      left = leftOrOptions;
    }

    left = left || 0;
    top = top || 0;
    if (this.scrollTarget === this._doc) {
      window.scrollTo(left, top);
    } else if (this._isValidScrollTarget()) {
      this.scrollTarget.scrollLeft = left;
      this.scrollTarget.scrollTop = top;
    }
  },

  /**
   * Gets the width of the scroll target.
   *
   * @type {number}
   */
  get _scrollTargetWidth() {
    if (this._isValidScrollTarget()) {
      return this.scrollTarget === this._doc ? window.innerWidth :
                                               this.scrollTarget.offsetWidth;
    }
    return 0;
  },

  /**
   * Gets the height of the scroll target.
   *
   * @type {number}
   */
  get _scrollTargetHeight() {
    if (this._isValidScrollTarget()) {
      return this.scrollTarget === this._doc ? window.innerHeight :
                                               this.scrollTarget.offsetHeight;
    }
    return 0;
  },

  /**
   * Returns true if the scroll target is a valid HTMLElement.
   *
   * @return {boolean}
   */
  _isValidScrollTarget: function() {
    return this.scrollTarget instanceof HTMLElement;
  },

  _toggleScrollListener: function(yes, scrollTarget) {
    var eventTarget = scrollTarget === this._doc ? window : scrollTarget;
    if (yes) {
      if (!this._boundScrollHandler) {
        this._boundScrollHandler = this._scrollHandler.bind(this);
        eventTarget.addEventListener('scroll', this._boundScrollHandler);
      }
    } else {
      if (this._boundScrollHandler) {
        eventTarget.removeEventListener('scroll', this._boundScrollHandler);
        this._boundScrollHandler = null;
      }
    }
  },

  /**
   * Enables or disables the scroll event listener.
   *
   * @param {boolean} yes True to add the event, False to remove it.
   */
  toggleScrollListener: function(yes) {
    this._shouldHaveListener = yes;
    this._toggleScrollListener(yes, this.scrollTarget);
  }

};

/**
@license
Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/

var IOS = navigator.userAgent.match(/iP(?:hone|ad;(?: U;)? CPU) OS (\d+)/);
var IOS_TOUCH_SCROLLING = IOS && IOS[1] >= 8;
var DEFAULT_PHYSICAL_COUNT = 3;
var HIDDEN_Y = '-10000px';
var SECRET_TABINDEX = -100;

/**

`iron-list` displays a virtual, 'infinite' list. The template inside
the iron-list element represents the DOM to create for each list item.
The `items` property specifies an array of list item data.

For performance reasons, not every item in the list is rendered at once;
instead a small subset of actual template elements *(enough to fill the
viewport)* are rendered and reused as the user scrolls. As such, it is important
that all state of the list template is bound to the model driving it, since the
view may be reused with a new model at any time. Particularly, any state that
may change as the result of a user interaction with the list item must be bound
to the model to avoid view state inconsistency.

### Sizing iron-list

`iron-list` must either be explicitly sized, or delegate scrolling to an
explicitly sized parent. By "explicitly sized", we mean it either has an
explicit CSS `height` property set via a class or inline style, or else is sized
by other layout means (e.g. the `flex` or `fit` classes).

#### Flexbox - [jsbin](https://jsbin.com/vejoni/edit?html,output)

```html
<template is="x-list">
  <style>
    :host {
      display: block;
      height: 100vh;
      display: flex;
      flex-direction: column;
    }

    iron-list {
      flex: 1 1 auto;
    }
  </style>
  <app-toolbar>App name</app-toolbar>
  <iron-list items="[[items]]">
    <template>
      <div>
        ...
      </div>
    </template>
  </iron-list>
</template>
```
#### Explicit size - [jsbin](https://jsbin.com/vopucus/edit?html,output)
```html
<template is="x-list">
  <style>
    :host {
      display: block;
    }

    iron-list {
      height: 100vh; /* don't use % values unless the parent element is sized.
*\/
    }
  </style>
  <iron-list items="[[items]]">
    <template>
      <div>
        ...
      </div>
    </template>
  </iron-list>
</template>
```
#### Main document scrolling -
[jsbin](https://jsbin.com/wevirow/edit?html,output)
```html
<head>
  <style>
    body {
      height: 100vh;
      margin: 0;
      display: flex;
      flex-direction: column;
    }

    app-toolbar {
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
    }

    iron-list {
      /* add padding since the app-toolbar is fixed at the top *\/
      padding-top: 64px;
    }
  </style>
</head>
<body>
  <app-toolbar>App name</app-toolbar>
  <iron-list scroll-target="document">
    <template>
      <div>
        ...
      </div>
    </template>
  </iron-list>
</body>
```

`iron-list` must be given a `<template>` which contains exactly one element. In
the examples above we used a `<div>`, but you can provide any element (including
custom elements).

### Template model

List item templates should bind to template models of the following structure:

```js
{
  index: 0,        // index in the item array
  selected: false, // true if the current item is selected
  tabIndex: -1,    // a dynamically generated tabIndex for focus management
  item: {}         // user data corresponding to items[index]
}
```

Alternatively, you can change the property name used as data index by changing
the `indexAs` property. The `as` property defines the name of the variable to
add to the binding scope for the array.

For example, given the following `data` array:

##### data.json

```js
[
  {"name": "Bob"},
  {"name": "Tim"},
  {"name": "Mike"}
]
```

The following code would render the list (note the name property is bound from
the model object provided to the template scope):

```html
<iron-ajax url="data.json" last-response="{{data}}" auto></iron-ajax>
<iron-list items="[[data]]" as="item">
  <template>
    <div>
      Name: [[item.name]]
    </div>
  </template>
</iron-list>
```

### Grid layout

`iron-list` supports a grid layout in addition to linear layout by setting
the `grid` attribute.  In this case, the list template item must have both fixed
width and height (e.g. via CSS). Based on this, the number of items
per row are determined automatically based on the size of the list viewport.

### Accessibility

`iron-list` automatically manages the focus state for the items. It also
provides a `tabIndex` property within the template scope that can be used for
keyboard navigation. For example, users can press the up and down keys to move
to previous and next items in the list:

```html
<iron-list items="[[data]]" as="item">
  <template>
    <div tabindex$="[[tabIndex]]">
      Name: [[item.name]]
    </div>
  </template>
</iron-list>
```

### Resizing

`iron-list` lays out the items when it receives a notification via the
`iron-resize` event. This event is fired by any element that implements
`IronResizableBehavior`.

By default, elements such as `iron-pages`, `paper-tabs` or `paper-dialog` will
trigger this event automatically. If you hide the list manually (e.g. you use
`display: none`) you might want to implement `IronResizableBehavior` or fire
this event manually right after the list became visible again. For example:

```js
document.querySelector('iron-list').fire('iron-resize');
```

### When should `<iron-list>` be used?

`iron-list` should be used when a page has significantly more DOM nodes than the
ones visible on the screen. e.g. the page has 500 nodes, but only 20 are visible
at a time. This is why we refer to it as a `virtual` list. In this case, a
`dom-repeat` will still create 500 nodes which could slow down the web app, but
`iron-list` will only create 20.

However, having an `iron-list` does not mean that you can load all the data at
once. Say you have a million records in the database, you want to split the data
into pages so you can bring in a page at the time. The page could contain 500
items, and iron-list will only render 20.

@element iron-list
@demo demo/index.html

*/
Polymer({
  /** @override */
  _template: html`
    <style>
      :host {
        display: block;
      }

      @media only screen and (-webkit-max-device-pixel-ratio: 1) {
        :host {
          will-change: transform;
        }
      }

      #items {
        position: relative;
      }

      :host(:not([grid])) #items > ::slotted(*) {
        width: 100%;
      }

      #items > ::slotted(*) {
        box-sizing: border-box;
        margin: 0;
        position: absolute;
        top: 0;
        will-change: transform;
      }
    </style>

    <array-selector id="selector" items="{{items}}" selected="{{selectedItems}}" selected-item="{{selectedItem}}"></array-selector>

    <div id="items">
      <slot></slot>
    </div>
`,

  is: 'iron-list',

  properties: {

    /**
     * An array containing items determining how many instances of the template
     * to stamp and that that each template instance should bind to.
     */
    items: {type: Array},

    /**
     * The name of the variable to add to the binding scope for the array
     * element associated with a given template instance.
     */
    as: {type: String, value: 'item'},

    /**
     * The name of the variable to add to the binding scope with the index
     * for the row.
     */
    indexAs: {type: String, value: 'index'},

    /**
     * The name of the variable to add to the binding scope to indicate
     * if the row is selected.
     */
    selectedAs: {type: String, value: 'selected'},

    /**
     * When true, the list is rendered as a grid. Grid items must have
     * fixed width and height set via CSS. e.g.
     *
     * ```html
     * <iron-list grid>
     *   <template>
     *      <div style="width: 100px; height: 100px;"> 100x100 </div>
     *   </template>
     * </iron-list>
     * ```
     */
    grid: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
      observer: '_gridChanged'
    },

    /**
     * When true, tapping a row will select the item, placing its data model
     * in the set of selected items retrievable via the selection property.
     *
     * Note that tapping focusable elements within the list item will not
     * result in selection, since they are presumed to have their * own action.
     */
    selectionEnabled: {type: Boolean, value: false},

    /**
     * When `multiSelection` is false, this is the currently selected item, or
     * `null` if no item is selected.
     */
    selectedItem: {type: Object, notify: true},

    /**
     * When `multiSelection` is true, this is an array that contains the
     * selected items.
     */
    selectedItems: {type: Object, notify: true},

    /**
     * When `true`, multiple items may be selected at once (in this case,
     * `selected` is an array of currently selected items).  When `false`,
     * only one item may be selected at a time.
     */
    multiSelection: {type: Boolean, value: false},

    /**
     * The offset top from the scrolling element to the iron-list element.
     * This value can be computed using the position returned by
     * `getBoundingClientRect()` although it's preferred to use a constant value
     * when possible.
     *
     * This property is useful when an external scrolling element is used and
     * there's some offset between the scrolling element and the list. For
     * example: a header is placed above the list.
     */
    scrollOffset: {type: Number, value: 0},

    /**
     * If set to true, focus on an element will be preserved after rerender.
     */
    preserveFocus: {
      type: Boolean,
      value: false
    }
  },

  observers: [
    '_itemsChanged(items.*)',
    '_selectionEnabledChanged(selectionEnabled)',
    '_multiSelectionChanged(multiSelection)',
    '_setOverflow(scrollTarget, scrollOffset)'
  ],

  behaviors: [
    Templatizer,
    IronResizableBehavior,
    IronScrollTargetBehavior,
    OptionalMutableDataBehavior
  ],

  /**
   * The ratio of hidden tiles that should remain in the scroll direction.
   * Recommended value ~0.5, so it will distribute tiles evenly in both
   * directions.
   */
  _ratio: 0.5,

  /**
   * The padding-top value for the list.
   */
  _scrollerPaddingTop: 0,

  /**
   * This value is a cached value of `scrollTop` from the last `scroll` event.
   */
  _scrollPosition: 0,

  /**
   * The sum of the heights of all the tiles in the DOM.
   */
  _physicalSize: 0,

  /**
   * The average `offsetHeight` of the tiles observed till now.
   */
  _physicalAverage: 0,

  /**
   * The number of tiles which `offsetHeight` > 0 observed until now.
   */
  _physicalAverageCount: 0,

  /**
   * The Y position of the item rendered in the `_physicalStart`
   * tile relative to the scrolling list.
   */
  _physicalTop: 0,

  /**
   * The number of items in the list.
   */
  _virtualCount: 0,

  /**
   * The estimated scroll height based on `_physicalAverage`
   */
  _estScrollHeight: 0,

  /**
   * The scroll height of the dom node
   */
  _scrollHeight: 0,

  /**
   * The height of the list. This is referred as the viewport in the context of
   * list.
   */
  _viewportHeight: 0,

  /**
   * The width of the list. This is referred as the viewport in the context of
   * list.
   */
  _viewportWidth: 0,

  /**
   * An array of DOM nodes that are currently in the tree
   * @type {?Array<!HTMLElement>}
   */
  _physicalItems: null,

  /**
   * An array of heights for each item in `_physicalItems`
   * @type {?Array<number>}
   */
  _physicalSizes: null,

  /**
   * A cached value for the first visible index.
   * See `firstVisibleIndex`
   * @type {?number}
   */
  _firstVisibleIndexVal: null,

  /**
   * A cached value for the last visible index.
   * See `lastVisibleIndex`
   * @type {?number}
   */
  _lastVisibleIndexVal: null,

  /**
   * The max number of pages to render. One page is equivalent to the height of
   * the list.
   */
  _maxPages: 2,

  /**
   * The currently focused physical item.
   */
  _focusedItem: null,

  /**
   * The virtual index of the focused item.
   */
  _focusedVirtualIndex: -1,

  /**
   * The physical index of the focused item.
   */
  _focusedPhysicalIndex: -1,

  /**
   * The the item that is focused if it is moved offscreen.
   * @private {?HTMLElement}
   */
  _offscreenFocusedItem: null,

  /**
   * The item that backfills the `_offscreenFocusedItem` in the physical items
   * list when that item is moved offscreen.
   * @type {?HTMLElement}
   */
  _focusBackfillItem: null,

  /**
   * The maximum items per row
   */
  _itemsPerRow: 1,

  /**
   * The width of each grid item
   */
  _itemWidth: 0,

  /**
   * The height of the row in grid layout.
   */
  _rowHeight: 0,

  /**
   * The cost of stamping a template in ms.
   */
  _templateCost: 0,

  /**
   * Needed to pass event.model property to declarative event handlers -
   * see polymer/polymer#4339.
   */
  _parentModel: true,

  /**
   * The bottom of the physical content.
   */
  get _physicalBottom() {
    return this._physicalTop + this._physicalSize;
  },

  /**
   * The bottom of the scroll.
   */
  get _scrollBottom() {
    return this._scrollPosition + this._viewportHeight;
  },

  /**
   * The n-th item rendered in the last physical item.
   */
  get _virtualEnd() {
    return this._virtualStart + this._physicalCount - 1;
  },

  /**
   * The height of the physical content that isn't on the screen.
   */
  get _hiddenContentSize() {
    var size =
        this.grid ? this._physicalRows * this._rowHeight : this._physicalSize;
    return size - this._viewportHeight;
  },

  /**
   * The parent node for the _userTemplate.
   */
  get _itemsParent() {
    return dom(dom(this._userTemplate).parentNode);
  },

  /**
   * The maximum scroll top value.
   */
  get _maxScrollTop() {
    return this._estScrollHeight - this._viewportHeight + this._scrollOffset;
  },

  /**
   * The largest n-th value for an item such that it can be rendered in
   * `_physicalStart`.
   */
  get _maxVirtualStart() {
    var virtualCount = this._convertIndexToCompleteRow(this._virtualCount);
    return Math.max(0, virtualCount - this._physicalCount);
  },

  set _virtualStart(val) {
    val = this._clamp(val, 0, this._maxVirtualStart);
    if (this.grid) {
      val = val - (val % this._itemsPerRow);
    }
    this._virtualStartVal = val;
  },

  get _virtualStart() {
    return this._virtualStartVal || 0;
  },

  /**
   * The k-th tile that is at the top of the scrolling list.
   */
  set _physicalStart(val) {
    val = val % this._physicalCount;
    if (val < 0) {
      val = this._physicalCount + val;
    }
    if (this.grid) {
      val = val - (val % this._itemsPerRow);
    }
    this._physicalStartVal = val;
  },

  get _physicalStart() {
    return this._physicalStartVal || 0;
  },

  /**
   * The k-th tile that is at the bottom of the scrolling list.
   */
  get _physicalEnd() {
    return (this._physicalStart + this._physicalCount - 1) %
        this._physicalCount;
  },

  set _physicalCount(val) {
    this._physicalCountVal = val;
  },

  get _physicalCount() {
    return this._physicalCountVal || 0;
  },

  /**
   * An optimal physical size such that we will have enough physical items
   * to fill up the viewport and recycle when the user scrolls.
   *
   * This default value assumes that we will at least have the equivalent
   * to a viewport of physical items above and below the user's viewport.
   */
  get _optPhysicalSize() {
    return this._viewportHeight === 0 ? Infinity :
                                        this._viewportHeight * this._maxPages;
  },

  /**
   * True if the current list is visible.
   */
  get _isVisible() {
    return Boolean(this.offsetWidth || this.offsetHeight);
  },

  /**
   * Gets the index of the first visible item in the viewport.
   *
   * @type {number}
   */
  get firstVisibleIndex() {
    var idx = this._firstVisibleIndexVal;
    if (idx == null) {
      var physicalOffset = this._physicalTop + this._scrollOffset;

      idx = this._iterateItems(function(pidx, vidx) {
        physicalOffset += this._getPhysicalSizeIncrement(pidx);

        if (physicalOffset > this._scrollPosition) {
          return this.grid ? vidx - (vidx % this._itemsPerRow) : vidx;
        }
        // Handle a partially rendered final row in grid mode
        if (this.grid && this._virtualCount - 1 === vidx) {
          return vidx - (vidx % this._itemsPerRow);
        }
      }) ||
          0;
      this._firstVisibleIndexVal = idx;
    }
    return idx;
  },

  /**
   * Gets the index of the last visible item in the viewport.
   *
   * @type {number}
   */
  get lastVisibleIndex() {
    var idx = this._lastVisibleIndexVal;
    if (idx == null) {
      if (this.grid) {
        idx = Math.min(
            this._virtualCount,
            this.firstVisibleIndex + this._estRowsInView * this._itemsPerRow -
                1);
      } else {
        var physicalOffset = this._physicalTop + this._scrollOffset;
        this._iterateItems(function(pidx, vidx) {
          if (physicalOffset < this._scrollBottom) {
            idx = vidx;
          }
          physicalOffset += this._getPhysicalSizeIncrement(pidx);
        });
      }
      this._lastVisibleIndexVal = idx;
    }
    return idx;
  },

  get _defaultScrollTarget() {
    return this;
  },

  get _virtualRowCount() {
    return Math.ceil(this._virtualCount / this._itemsPerRow);
  },

  get _estRowsInView() {
    return Math.ceil(this._viewportHeight / this._rowHeight);
  },

  get _physicalRows() {
    return Math.ceil(this._physicalCount / this._itemsPerRow);
  },

  get _scrollOffset() {
    return this._scrollerPaddingTop + this.scrollOffset;
  },

  /** @override */
  ready: function() {
    this.addEventListener('focus', this._didFocus.bind(this), true);
  },

  /** @override */
  attached: function() {
    this._debounce('_render', this._render, animationFrame);
    // `iron-resize` is fired when the list is attached if the event is added
    // before attached causing unnecessary work.
    this.listen(this, 'iron-resize', '_resizeHandler');
    this.listen(this, 'keydown', '_keydownHandler');
  },

  /** @override */
  detached: function() {
    this.unlisten(this, 'iron-resize', '_resizeHandler');
    this.unlisten(this, 'keydown', '_keydownHandler');
  },

  /**
   * Set the overflow property if this element has its own scrolling region
   */
  _setOverflow: function(scrollTarget) {
    this.style.webkitOverflowScrolling = scrollTarget === this ? 'touch' : '';
    this.style.overflowY = scrollTarget === this ? 'auto' : '';
    // Clear cache.
    this._lastVisibleIndexVal = null;
    this._firstVisibleIndexVal = null;
    this._debounce('_render', this._render, animationFrame);
  },

  /**
   * Invoke this method if you dynamically update the viewport's
   * size or CSS padding.
   *
   * @method updateViewportBoundaries
   */
  updateViewportBoundaries: function() {
    var styles = window.getComputedStyle(this);
    this._scrollerPaddingTop =
        this.scrollTarget === this ? 0 : parseInt(styles['padding-top'], 10);
    this._isRTL = Boolean(styles.direction === 'rtl');
    this._viewportWidth = this.$.items.offsetWidth;
    this._viewportHeight = this._scrollTargetHeight;
    this.grid && this._updateGridMetrics();
  },

  /**
   * Recycles the physical items when needed.
   */
  _scrollHandler: function() {
    var scrollTop = Math.max(0, Math.min(this._maxScrollTop, this._scrollTop));
    var delta = scrollTop - this._scrollPosition;
    var isScrollingDown = delta >= 0;
    // Track the current scroll position.
    this._scrollPosition = scrollTop;
    // Clear indexes for first and last visible indexes.
    this._firstVisibleIndexVal = null;
    this._lastVisibleIndexVal = null;
    // Random access.
    if (Math.abs(delta) > this._physicalSize && this._physicalSize > 0) {
      delta = delta - this._scrollOffset;
      var idxAdjustment =
          Math.round(delta / this._physicalAverage) * this._itemsPerRow;
      this._virtualStart = this._virtualStart + idxAdjustment;
      this._physicalStart = this._physicalStart + idxAdjustment;
      // Estimate new physical offset based on the virtual start index.
      // adjusts the physical start position to stay in sync with the clamped
      // virtual start index. It's critical not to let this value be
      // more than the scroll position however, since that would result in
      // the physical items not covering the viewport, and leading to
      // _increasePoolIfNeeded to run away creating items to try to fill it.
      this._physicalTop = Math.min(
          Math.floor(this._virtualStart / this._itemsPerRow) *
              this._physicalAverage,
          this._scrollPosition);
      this._update();
    } else if (this._physicalCount > 0) {
      var reusables = this._getReusables(isScrollingDown);
      if (isScrollingDown) {
        this._physicalTop = reusables.physicalTop;
        this._virtualStart = this._virtualStart + reusables.indexes.length;
        this._physicalStart = this._physicalStart + reusables.indexes.length;
      } else {
        this._virtualStart = this._virtualStart - reusables.indexes.length;
        this._physicalStart = this._physicalStart - reusables.indexes.length;
      }
      this._update(
          reusables.indexes, isScrollingDown ? null : reusables.indexes);
      this._debounce(
          '_increasePoolIfNeeded',
          this._increasePoolIfNeeded.bind(this, 0),
          microTask);
    }
  },

  /**
   * Returns an object that contains the indexes of the physical items
   * that might be reused and the physicalTop.
   *
   * @param {boolean} fromTop If the potential reusable items are above the scrolling region.
   */
  _getReusables: function(fromTop) {
    var ith, offsetContent, physicalItemHeight;
    var idxs = [];
    var protectedOffsetContent = this._hiddenContentSize * this._ratio;
    var virtualStart = this._virtualStart;
    var virtualEnd = this._virtualEnd;
    var physicalCount = this._physicalCount;
    var top = this._physicalTop + this._scrollOffset;
    var bottom = this._physicalBottom + this._scrollOffset;
    // This may be called outside of a scrollHandler, so use last cached position
    var scrollTop = this._scrollPosition;
    var scrollBottom = this._scrollBottom;

    if (fromTop) {
      ith = this._physicalStart;
      this._physicalEnd;
      offsetContent = scrollTop - top;
    } else {
      ith = this._physicalEnd;
      this._physicalStart;
      offsetContent = bottom - scrollBottom;
    }
    while (true) {
      physicalItemHeight = this._getPhysicalSizeIncrement(ith);
      offsetContent = offsetContent - physicalItemHeight;
      if (idxs.length >= physicalCount ||
          offsetContent <= protectedOffsetContent) {
        break;
      }
      if (fromTop) {
        // Check that index is within the valid range.
        if (virtualEnd + idxs.length + 1 >= this._virtualCount) {
          break;
        }
        // Check that the index is not visible.
        if (top + physicalItemHeight >= scrollTop - this._scrollOffset) {
          break;
        }
        idxs.push(ith);
        top = top + physicalItemHeight;
        ith = (ith + 1) % physicalCount;
      } else {
        // Check that index is within the valid range.
        if (virtualStart - idxs.length <= 0) {
          break;
        }
        // Check that the index is not visible.
        if (top + this._physicalSize - physicalItemHeight <= scrollBottom) {
          break;
        }
        idxs.push(ith);
        top = top - physicalItemHeight;
        ith = (ith === 0) ? physicalCount - 1 : ith - 1;
      }
    }
    return {indexes: idxs, physicalTop: top - this._scrollOffset};
  },

  /**
   * Update the list of items, starting from the `_virtualStart` item.
   * @param {!Array<number>=} itemSet
   * @param {!Array<number>=} movingUp
   */
  _update: function(itemSet, movingUp) {
    if ((itemSet && itemSet.length === 0) || this._physicalCount === 0) {
      return;
    }
    this._manageFocus();
    this._assignModels(itemSet);
    this._updateMetrics(itemSet);
    // Adjust offset after measuring.
    if (movingUp) {
      while (movingUp.length) {
        var idx = movingUp.pop();
        this._physicalTop -= this._getPhysicalSizeIncrement(idx);
      }
    }
    this._positionItems();
    this._updateScrollerSize();
  },

  /**
   * Creates a pool of DOM elements and attaches them to the local dom.
   *
   * @param {number} size Size of the pool
   */
  _createPool: function(size) {
    this._ensureTemplatized();
    var i, inst;
    var physicalItems = new Array(size);
    for (i = 0; i < size; i++) {
      inst = this.stamp(null);
      // TODO(blasten):
      // First element child is item; Safari doesn't support children[0]
      // on a doc fragment. Test this to see if it still matters.
      physicalItems[i] = inst.root.querySelector('*');
      this._itemsParent.appendChild(inst.root);
    }
    return physicalItems;
  },

  _isClientFull: function() {
    return this._scrollBottom != 0 &&
        this._physicalBottom - 1 >= this._scrollBottom &&
        this._physicalTop <= this._scrollPosition;
  },

  /**
   * Increases the pool size.
   */
  _increasePoolIfNeeded: function(count) {
    var nextPhysicalCount = this._clamp(
        this._physicalCount + count,
        DEFAULT_PHYSICAL_COUNT,
        this._virtualCount - this._virtualStart);
    nextPhysicalCount = this._convertIndexToCompleteRow(nextPhysicalCount);
    if (this.grid) {
      var correction = nextPhysicalCount % this._itemsPerRow;
      if (correction && nextPhysicalCount - correction <= this._physicalCount) {
        nextPhysicalCount += this._itemsPerRow;
      }
      nextPhysicalCount -= correction;
    }
    var delta = nextPhysicalCount - this._physicalCount;
    var nextIncrease = Math.round(this._physicalCount * 0.5);

    if (delta < 0) {
      return;
    }
    if (delta > 0) {
      var ts = window.performance.now();
      // Concat arrays in place.
      [].push.apply(this._physicalItems, this._createPool(delta));
      // Push 0s into physicalSizes. Can't use Array.fill because IE11 doesn't
      // support it.
      for (var i = 0; i < delta; i++) {
        this._physicalSizes.push(0);
      }
      this._physicalCount = this._physicalCount + delta;
      // Update the physical start if it needs to preserve the model of the
      // focused item. In this situation, the focused item is currently rendered
      // and its model would have changed after increasing the pool if the
      // physical start remained unchanged.
      if (this._physicalStart > this._physicalEnd &&
          this._isIndexRendered(this._focusedVirtualIndex) &&
          this._getPhysicalIndex(this._focusedVirtualIndex) <
              this._physicalEnd) {
        this._physicalStart = this._physicalStart + delta;
      }
      this._update();
      this._templateCost = (window.performance.now() - ts) / delta;
      nextIncrease = Math.round(this._physicalCount * 0.5);
    }
    // The upper bounds is not fixed when dealing with a grid that doesn't
    // fill it's last row with the exact number of items per row.
    if (this._virtualEnd >= this._virtualCount - 1 || nextIncrease === 0) ; else if (!this._isClientFull()) {
      this._debounce(
          '_increasePoolIfNeeded',
          this._increasePoolIfNeeded.bind(this, nextIncrease),
          microTask);
    } else if (this._physicalSize < this._optPhysicalSize) {
      // Yield and increase the pool during idle time until the physical size is
      // optimal.
      this._debounce(
          '_increasePoolIfNeeded',
          this._increasePoolIfNeeded.bind(
              this,
              this._clamp(
                  Math.round(50 / this._templateCost), 1, nextIncrease)),
          idlePeriod);
    }
  },

  /**
   * Renders the a new list.
   */
  _render: function() {
    if (!this.isAttached || !this._isVisible) {
      return;
    }
    if (this._physicalCount !== 0) {
      var reusables = this._getReusables(true);
      this._physicalTop = reusables.physicalTop;
      this._virtualStart = this._virtualStart + reusables.indexes.length;
      this._physicalStart = this._physicalStart + reusables.indexes.length;
      this._update(reusables.indexes);
      this._update();
      this._increasePoolIfNeeded(0);
    } else if (this._virtualCount > 0) {
      // Initial render
      this.updateViewportBoundaries();
      this._increasePoolIfNeeded(DEFAULT_PHYSICAL_COUNT);
    }
  },

  /**
   * Templetizes the user template.
   */
  _ensureTemplatized: function() {
    if (this.ctor) {
      return;
    }
    this._userTemplate = /** @type {!HTMLTemplateElement} */ (
        this.queryEffectiveChildren('template'));
    if (!this._userTemplate) {
      console.warn('iron-list requires a template to be provided in light-dom');
    }
    var instanceProps = {};
    instanceProps.__key__ = true;
    instanceProps[this.as] = true;
    instanceProps[this.indexAs] = true;
    instanceProps[this.selectedAs] = true;
    instanceProps.tabIndex = true;
    this._instanceProps = instanceProps;
    this.templatize(this._userTemplate, this.mutableData);
  },

  _gridChanged: function(newGrid, oldGrid) {
    if (typeof oldGrid === 'undefined')
      return;
    this.notifyResize();
    flush();
    newGrid && this._updateGridMetrics();
  },

  /**
   * Finds and returns the focused element (both within self and children's
   * Shadow DOM).
   * @return {?HTMLElement}
   */
  _getFocusedElement: function() {
    function doSearch(node, query) {
      let result = null;
      let type = node.nodeType;
      if (type == Node.ELEMENT_NODE || type == Node.DOCUMENT_FRAGMENT_NODE)
        result = node.querySelector(query);
      if (result)
        return result;

      let child = node.firstChild;
      while (child !== null && result === null) {
        result = doSearch(child, query);
        child = child.nextSibling;
      }
      if (result)
        return result;

      const shadowRoot = node.shadowRoot;
      return shadowRoot ? doSearch(shadowRoot, query) : null;
    }

    // Find out if any of the items are focused first, and only search
    // recursively in the item that contains focus, to avoid a slow
    // search of the entire list.
    const focusWithin = doSearch(this, ':focus-within');
    return focusWithin ? doSearch(focusWithin, ':focus') : null;
  },

  /**
   * Called when the items have changed. That is, reassignments
   * to `items`, splices or updates to a single item.
   */
  _itemsChanged: function(change) {
    var rendering = /^items(\.splices){0,1}$/.test(change.path);
    var lastFocusedIndex, focusedElement;
    if (rendering && this.preserveFocus) {
      lastFocusedIndex = this._focusedVirtualIndex;
      focusedElement = this._getFocusedElement();
    }

    var preservingFocus = rendering && this.preserveFocus && focusedElement;

    if (change.path === 'items') {
      this._virtualStart = 0;
      this._physicalTop = 0;
      this._virtualCount = this.items ? this.items.length : 0;
      this._physicalIndexForKey = {};
      this._firstVisibleIndexVal = null;
      this._lastVisibleIndexVal = null;
      this._physicalCount = this._physicalCount || 0;
      this._physicalItems = this._physicalItems || [];
      this._physicalSizes = this._physicalSizes || [];
      this._physicalStart = 0;
      if (this._scrollTop > this._scrollOffset && !preservingFocus) {
        this._resetScrollPosition(0);
      }
      this._removeFocusedItem();
      this._debounce('_render', this._render, animationFrame);
    } else if (change.path === 'items.splices') {
      this._adjustVirtualIndex(change.value.indexSplices);
      this._virtualCount = this.items ? this.items.length : 0;
      // Only blur if at least one item is added or removed.
      var itemAddedOrRemoved = change.value.indexSplices.some(function(splice) {
        return splice.addedCount > 0 || splice.removed.length > 0;
      });
      if (itemAddedOrRemoved) {
        // Only blur activeElement if it is a descendant of the list (#505,
        // #507).
        var activeElement = this._getActiveElement();
        if (this.contains(activeElement)) {
          activeElement.blur();
        }
      }
      // Render only if the affected index is rendered.
      var affectedIndexRendered =
          change.value.indexSplices.some(function(splice) {
            return splice.index + splice.addedCount >= this._virtualStart &&
                splice.index <= this._virtualEnd;
          }, this);
      if (!this._isClientFull() || affectedIndexRendered) {
        this._debounce('_render', this._render, animationFrame);
      }
    } else if (change.path !== 'items.length') {
      this._forwardItemPath(change.path, change.value);
    }

    // If the list was in focus when updated, preserve the focus on item.
    if (preservingFocus) {
      flush();
      focusedElement.blur();  // paper- elements breaks when focused twice.
      this._focusPhysicalItem(
          Math.min(this.items.length - 1, lastFocusedIndex));
      if (!this._isIndexVisible(this._focusedVirtualIndex)) {
        this.scrollToIndex(this._focusedVirtualIndex);
      }
    }
  },

  _forwardItemPath: function(path, value) {
    path = path.slice(6);  // 'items.'.length == 6
    var dot = path.indexOf('.');
    if (dot === -1) {
      dot = path.length;
    }
    var isIndexRendered;
    var pidx;
    var inst;
    var offscreenInstance = this.modelForElement(this._offscreenFocusedItem);
    var vidx = parseInt(path.substring(0, dot), 10);
    isIndexRendered = this._isIndexRendered(vidx);
    if (isIndexRendered) {
      pidx = this._getPhysicalIndex(vidx);
      inst = this.modelForElement(this._physicalItems[pidx]);
    } else if (offscreenInstance) {
      inst = offscreenInstance;
    }

    if (!inst || inst[this.indexAs] !== vidx) {
      return;
    }
    path = path.substring(dot + 1);
    path = this.as + (path ? '.' + path : '');
    inst._setPendingPropertyOrPath(path, value, false, true);
    inst._flushProperties && inst._flushProperties();
    // TODO(blasten): V1 doesn't do this and it's a bug
    if (isIndexRendered) {
      this._updateMetrics([pidx]);
      this._positionItems();
      this._updateScrollerSize();
    }
  },

  /**
   * @param {!Array<!Object>} splices
   */
  _adjustVirtualIndex: function(splices) {
    splices.forEach(function(splice) {
      // deselect removed items
      splice.removed.forEach(this._removeItem, this);
      // We only need to care about changes happening above the current position
      if (splice.index < this._virtualStart) {
        var delta = Math.max(
            splice.addedCount - splice.removed.length,
            splice.index - this._virtualStart);
        this._virtualStart = this._virtualStart + delta;
        if (this._focusedVirtualIndex >= 0) {
          this._focusedVirtualIndex = this._focusedVirtualIndex + delta;
        }
      }
    }, this);
  },

  _removeItem: function(item) {
    this.$.selector.deselect(item);
    // remove the current focused item
    if (this._focusedItem &&
        this.modelForElement(this._focusedItem)[this.as] === item) {
      this._removeFocusedItem();
    }
  },

  /**
   * Executes a provided function per every physical index in `itemSet`
   * `itemSet` default value is equivalent to the entire set of physical
   * indexes.
   *
   * @param {!function(number, number)} fn
   * @param {!Array<number>=} itemSet
   */
  _iterateItems: function(fn, itemSet) {
    var pidx, vidx, rtn, i;

    if (arguments.length === 2 && itemSet) {
      for (i = 0; i < itemSet.length; i++) {
        pidx = itemSet[i];
        vidx = this._computeVidx(pidx);
        if ((rtn = fn.call(this, pidx, vidx)) != null) {
          return rtn;
        }
      }
    } else {
      pidx = this._physicalStart;
      vidx = this._virtualStart;
      for (; pidx < this._physicalCount; pidx++, vidx++) {
        if ((rtn = fn.call(this, pidx, vidx)) != null) {
          return rtn;
        }
      }
      for (pidx = 0; pidx < this._physicalStart; pidx++, vidx++) {
        if ((rtn = fn.call(this, pidx, vidx)) != null) {
          return rtn;
        }
      }
    }
  },

  /**
   * Returns the virtual index for a given physical index
   *
   * @param {number} pidx Physical index
   * @return {number}
   */
  _computeVidx: function(pidx) {
    if (pidx >= this._physicalStart) {
      return this._virtualStart + (pidx - this._physicalStart);
    }
    return this._virtualStart + (this._physicalCount - this._physicalStart) +
        pidx;
  },

  /**
   * Assigns the data models to a given set of items.
   * @param {!Array<number>=} itemSet
   */
  _assignModels: function(itemSet) {
    this._iterateItems(function(pidx, vidx) {
      var el = this._physicalItems[pidx];
      var item = this.items && this.items[vidx];
      if (item != null) {
        var inst = this.modelForElement(el);
        inst.__key__ = null;
        this._forwardProperty(inst, this.as, item);
        this._forwardProperty(
            inst, this.selectedAs, this.$.selector.isSelected(item));
        this._forwardProperty(inst, this.indexAs, vidx);
        this._forwardProperty(
            inst, 'tabIndex', this._focusedVirtualIndex === vidx ? 0 : -1);
        this._physicalIndexForKey[inst.__key__] = pidx;
        inst._flushProperties && inst._flushProperties(true);
        el.removeAttribute('hidden');
      } else {
        el.setAttribute('hidden', '');
      }
    }, itemSet);
  },

  /**
   * Updates the height for a given set of items.
   *
   * @param {!Array<number>=} itemSet
   */
  _updateMetrics: function(itemSet) {
    // Make sure we distributed all the physical items
    // so we can measure them.
    flush();

    var newPhysicalSize = 0;
    var oldPhysicalSize = 0;
    var prevAvgCount = this._physicalAverageCount;
    var prevPhysicalAvg = this._physicalAverage;

    this._iterateItems(function(pidx, vidx) {
      oldPhysicalSize += this._physicalSizes[pidx];
      this._physicalSizes[pidx] = this._physicalItems[pidx].offsetHeight;
      newPhysicalSize += this._physicalSizes[pidx];
      this._physicalAverageCount += this._physicalSizes[pidx] ? 1 : 0;
    }, itemSet);

    if (this.grid) {
      this._updateGridMetrics();
      this._physicalSize =
          Math.ceil(this._physicalCount / this._itemsPerRow) * this._rowHeight;
    } else {
      oldPhysicalSize = (this._itemsPerRow === 1) ?
          oldPhysicalSize :
          Math.ceil(this._physicalCount / this._itemsPerRow) * this._rowHeight;
      this._physicalSize =
          this._physicalSize + newPhysicalSize - oldPhysicalSize;
      this._itemsPerRow = 1;
    }
    // Update the average if it measured something.
    if (this._physicalAverageCount !== prevAvgCount) {
      this._physicalAverage = Math.round(
          ((prevPhysicalAvg * prevAvgCount) + newPhysicalSize) /
          this._physicalAverageCount);
    }
  },

  _updateGridMetrics: function() {
    this._itemWidth = this._physicalCount > 0 ?
        this._physicalItems[0].getBoundingClientRect().width :
        200;
    this._rowHeight =
        this._physicalCount > 0 ? this._physicalItems[0].offsetHeight : 200;
    this._itemsPerRow = this._itemWidth ?
        Math.floor(this._viewportWidth / this._itemWidth) :
        this._itemsPerRow;
  },

  /**
   * Updates the position of the physical items.
   */
  _positionItems: function() {
    this._adjustScrollPosition();

    var y = this._physicalTop;

    if (this.grid) {
      var totalItemWidth = this._itemsPerRow * this._itemWidth;
      var rowOffset = (this._viewportWidth - totalItemWidth) / 2;

      this._iterateItems(function(pidx, vidx) {
        var modulus = vidx % this._itemsPerRow;
        var x = Math.floor((modulus * this._itemWidth) + rowOffset);
        if (this._isRTL) {
          x = x * -1;
        }
        this.translate3d(x + 'px', y + 'px', 0, this._physicalItems[pidx]);
        if (this._shouldRenderNextRow(vidx)) {
          y += this._rowHeight;
        }
      });
    } else {
      const order = [];
      this._iterateItems(function(pidx, vidx) {
        const item = this._physicalItems[pidx];
        this.translate3d(0, y + 'px', 0, item);
        y += this._physicalSizes[pidx];
        const itemId = item.id;
        if (itemId) {
          order.push(itemId);
        }
      });
      if (order.length) {
        this.setAttribute('aria-owns', order.join(' '));
      }
    }
  },

  _getPhysicalSizeIncrement: function(pidx) {
    if (!this.grid) {
      return this._physicalSizes[pidx];
    }
    if (this._computeVidx(pidx) % this._itemsPerRow !== this._itemsPerRow - 1) {
      return 0;
    }
    return this._rowHeight;
  },

  /**
   * Returns, based on the current index,
   * whether or not the next index will need
   * to be rendered on a new row.
   *
   * @param {number} vidx Virtual index
   * @return {boolean}
   */
  _shouldRenderNextRow: function(vidx) {
    return vidx % this._itemsPerRow === this._itemsPerRow - 1;
  },

  /**
   * Adjusts the scroll position when it was overestimated.
   */
  _adjustScrollPosition: function() {
    var deltaHeight = this._virtualStart === 0 ?
        this._physicalTop :
        Math.min(this._scrollPosition + this._physicalTop, 0);
    // Note: the delta can be positive or negative.
    if (deltaHeight !== 0) {
      this._physicalTop = this._physicalTop - deltaHeight;
      // This may be called outside of a scrollHandler, so use last cached position
      var scrollTop = this._scrollPosition;
      // juking scroll position during interial scrolling on iOS is no bueno
      if (!IOS_TOUCH_SCROLLING && scrollTop > 0) {
        this._resetScrollPosition(scrollTop - deltaHeight);
      }
    }
  },

  /**
   * Sets the position of the scroll.
   */
  _resetScrollPosition: function(pos) {
    if (this.scrollTarget && pos >= 0) {
      this._scrollTop = pos;
      this._scrollPosition = this._scrollTop;
    }
  },

  /**
   * Sets the scroll height, that's the height of the content,
   *
   * @param {boolean=} forceUpdate If true, updates the height no matter what.
   */
  _updateScrollerSize: function(forceUpdate) {
    if (this.grid) {
      this._estScrollHeight = this._virtualRowCount * this._rowHeight;
    } else {
      this._estScrollHeight =
          (this._physicalBottom +
           Math.max(
               this._virtualCount - this._physicalCount - this._virtualStart,
               0) *
               this._physicalAverage);
    }
    forceUpdate = forceUpdate || this._scrollHeight === 0;
    forceUpdate = forceUpdate ||
        this._scrollPosition >= this._estScrollHeight - this._physicalSize;
    forceUpdate = forceUpdate ||
        this.grid && this.$.items.style.height < this._estScrollHeight;
    // Amortize height adjustment, so it won't trigger large repaints too often.
    if (forceUpdate ||
        Math.abs(this._estScrollHeight - this._scrollHeight) >=
            this._viewportHeight) {
      this.$.items.style.height = this._estScrollHeight + 'px';
      this._scrollHeight = this._estScrollHeight;
    }
  },

  /**
   * Scroll to a specific item in the virtual list regardless
   * of the physical items in the DOM tree.
   *
   * @method scrollToItem
   * @param {(Object)} item The item to be scrolled to
   */
  scrollToItem: function(item) {
    return this.scrollToIndex(this.items.indexOf(item));
  },

  /**
   * Scroll to a specific index in the virtual list regardless
   * of the physical items in the DOM tree.
   *
   * @method scrollToIndex
   * @param {number} idx The index of the item
   */
  scrollToIndex: function(idx) {
    if (typeof idx !== 'number' || idx < 0 || idx > this.items.length - 1) {
      return;
    }
    flush();
    // Items should have been rendered prior scrolling to an index.
    if (this._physicalCount === 0) {
      return;
    }
    idx = this._clamp(idx, 0, this._virtualCount - 1);
    // Update the virtual start only when needed.
    if (!this._isIndexRendered(idx) || idx >= this._maxVirtualStart) {
      this._virtualStart =
          this.grid ? (idx - this._itemsPerRow * 2) : (idx - 1);
    }
    this._manageFocus();
    this._assignModels();
    this._updateMetrics();
    // Estimate new physical offset.
    this._physicalTop = Math.floor(this._virtualStart / this._itemsPerRow) *
        this._physicalAverage;

    var currentTopItem = this._physicalStart;
    var currentVirtualItem = this._virtualStart;
    var targetOffsetTop = 0;
    var hiddenContentSize = this._hiddenContentSize;
    // scroll to the item as much as we can.
    while (currentVirtualItem < idx && targetOffsetTop <= hiddenContentSize) {
      targetOffsetTop =
          targetOffsetTop + this._getPhysicalSizeIncrement(currentTopItem);
      currentTopItem = (currentTopItem + 1) % this._physicalCount;
      currentVirtualItem++;
    }
    this._updateScrollerSize(true);
    this._positionItems();
    this._resetScrollPosition(
        this._physicalTop + this._scrollOffset + targetOffsetTop);
    this._increasePoolIfNeeded(0);
    // clear cached visible index.
    this._firstVisibleIndexVal = null;
    this._lastVisibleIndexVal = null;
  },

  /**
   * Reset the physical average and the average count.
   */
  _resetAverage: function() {
    this._physicalAverage = 0;
    this._physicalAverageCount = 0;
  },

  /**
   * A handler for the `iron-resize` event triggered by `IronResizableBehavior`
   * when the element is resized.
   */
  _resizeHandler: function() {
    this._debounce('_render', function() {
      // clear cached visible index.
      this._firstVisibleIndexVal = null;
      this._lastVisibleIndexVal = null;
      if (this._isVisible) {
        this.updateViewportBoundaries();
        // Reinstall the scroll event listener.
        this.toggleScrollListener(true);
        this._resetAverage();
        this._render();
      } else {
        // Uninstall the scroll event listener.
        this.toggleScrollListener(false);
      }
    }, animationFrame);
  },

  /**
   * Selects the given item.
   *
   * @method selectItem
   * @param {Object} item The item instance.
   */
  selectItem: function(item) {
    return this.selectIndex(this.items.indexOf(item));
  },

  /**
   * Selects the item at the given index in the items array.
   *
   * @method selectIndex
   * @param {number} index The index of the item in the items array.
   */
  selectIndex: function(index) {
    if (index < 0 || index >= this._virtualCount) {
      return;
    }
    if (!this.multiSelection && this.selectedItem) {
      this.clearSelection();
    }
    if (this._isIndexRendered(index)) {
      var model = this.modelForElement(
          this._physicalItems[this._getPhysicalIndex(index)]);
      if (model) {
        model[this.selectedAs] = true;
      }
      this.updateSizeForIndex(index);
    }
    this.$.selector.selectIndex(index);
  },

  /**
   * Deselects the given item.
   *
   * @method deselect
   * @param {Object} item The item instance.
   */
  deselectItem: function(item) {
    return this.deselectIndex(this.items.indexOf(item));
  },

  /**
   * Deselects the item at the given index in the items array.
   *
   * @method deselectIndex
   * @param {number} index The index of the item in the items array.
   */
  deselectIndex: function(index) {
    if (index < 0 || index >= this._virtualCount) {
      return;
    }
    if (this._isIndexRendered(index)) {
      var model = this.modelForElement(
          this._physicalItems[this._getPhysicalIndex(index)]);
      model[this.selectedAs] = false;
      this.updateSizeForIndex(index);
    }
    this.$.selector.deselectIndex(index);
  },

  /**
   * Selects or deselects a given item depending on whether the item
   * has already been selected.
   *
   * @method toggleSelectionForItem
   * @param {Object} item The item object.
   */
  toggleSelectionForItem: function(item) {
    return this.toggleSelectionForIndex(this.items.indexOf(item));
  },

  /**
   * Selects or deselects the item at the given index in the items array
   * depending on whether the item has already been selected.
   *
   * @method toggleSelectionForIndex
   * @param {number} index The index of the item in the items array.
   */
  toggleSelectionForIndex: function(index) {
    var isSelected = this.$.selector.isIndexSelected ?
        this.$.selector.isIndexSelected(index) :
        this.$.selector.isSelected(this.items[index]);
    isSelected ? this.deselectIndex(index) : this.selectIndex(index);
  },

  /**
   * Clears the current selection in the list.
   *
   * @method clearSelection
   */
  clearSelection: function() {
    this._iterateItems(function(pidx, vidx) {
      this.modelForElement(this._physicalItems[pidx])[this.selectedAs] = false;
    });
    this.$.selector.clearSelection();
  },

  /**
   * Add an event listener to `tap` if `selectionEnabled` is true,
   * it will remove the listener otherwise.
   */
  _selectionEnabledChanged: function(selectionEnabled) {
    var handler = selectionEnabled ? this.listen : this.unlisten;
    handler.call(this, this, 'tap', '_selectionHandler');
  },

  /**
   * Select an item from an event object.
   */
  _selectionHandler: function(e) {
    var model = this.modelForElement(e.target);
    if (!model) {
      return;
    }
    var modelTabIndex, activeElTabIndex;
    var target = dom(e).path[0];
    var activeEl = this._getActiveElement();
    var physicalItem =
        this._physicalItems[this._getPhysicalIndex(model[this.indexAs])];
    // Safari does not focus certain form controls via mouse
    // https://bugs.webkit.org/show_bug.cgi?id=118043
    if (target.localName === 'input' || target.localName === 'button' ||
        target.localName === 'select') {
      return;
    }
    // Set a temporary tabindex
    modelTabIndex = model.tabIndex;
    model.tabIndex = SECRET_TABINDEX;
    activeElTabIndex = activeEl ? activeEl.tabIndex : -1;
    model.tabIndex = modelTabIndex;
    // Only select the item if the tap wasn't on a focusable child
    // or the element bound to `tabIndex`
    if (activeEl && physicalItem !== activeEl &&
        physicalItem.contains(activeEl) &&
        activeElTabIndex !== SECRET_TABINDEX) {
      return;
    }
    this.toggleSelectionForItem(model[this.as]);
  },

  _multiSelectionChanged: function(multiSelection) {
    this.clearSelection();
    this.$.selector.multi = multiSelection;
  },

  /**
   * Updates the size of a given list item.
   *
   * @method updateSizeForItem
   * @param {Object} item The item instance.
   */
  updateSizeForItem: function(item) {
    return this.updateSizeForIndex(this.items.indexOf(item));
  },

  /**
   * Updates the size of the item at the given index in the items array.
   *
   * @method updateSizeForIndex
   * @param {number} index The index of the item in the items array.
   */
  updateSizeForIndex: function(index) {
    if (!this._isIndexRendered(index)) {
      return null;
    }
    this._updateMetrics([this._getPhysicalIndex(index)]);
    this._positionItems();
    return null;
  },

  /**
   * Creates a temporary backfill item in the rendered pool of physical items
   * to replace the main focused item. The focused item has tabIndex = 0
   * and might be currently focused by the user.
   *
   * This dynamic replacement helps to preserve the focus state.
   */
  _manageFocus: function() {
    var fidx = this._focusedVirtualIndex;

    if (fidx >= 0 && fidx < this._virtualCount) {
      // if it's a valid index, check if that index is rendered
      // in a physical item.
      if (this._isIndexRendered(fidx)) {
        this._restoreFocusedItem();
      } else {
        this._createFocusBackfillItem();
      }
    } else if (this._virtualCount > 0 && this._physicalCount > 0) {
      // otherwise, assign the initial focused index.
      this._focusedPhysicalIndex = this._physicalStart;
      this._focusedVirtualIndex = this._virtualStart;
      this._focusedItem = this._physicalItems[this._physicalStart];
    }
  },

  /**
   * Converts a random index to the index of the item that completes it's row.
   * Allows for better order and fill computation when grid == true.
   */
  _convertIndexToCompleteRow: function(idx) {
    // when grid == false _itemPerRow can be unset.
    this._itemsPerRow = this._itemsPerRow || 1;
    return this.grid ? Math.ceil(idx / this._itemsPerRow) * this._itemsPerRow :
                       idx;
  },

  _isIndexRendered: function(idx) {
    return idx >= this._virtualStart && idx <= this._virtualEnd;
  },

  _isIndexVisible: function(idx) {
    return idx >= this.firstVisibleIndex && idx <= this.lastVisibleIndex;
  },

  _getPhysicalIndex: function(vidx) {
    return (this._physicalStart + (vidx - this._virtualStart)) %
        this._physicalCount;
  },

  focusItem: function(idx) {
    this._focusPhysicalItem(idx);
  },

  _focusPhysicalItem: function(idx) {
    if (idx < 0 || idx >= this._virtualCount) {
      return;
    }
    this._restoreFocusedItem();
    // scroll to index to make sure it's rendered
    if (!this._isIndexRendered(idx)) {
      this.scrollToIndex(idx);
    }
    var physicalItem = this._physicalItems[this._getPhysicalIndex(idx)];
    var model = this.modelForElement(physicalItem);
    var focusable;
    // set a secret tab index
    model.tabIndex = SECRET_TABINDEX;
    // check if focusable element is the physical item
    if (physicalItem.tabIndex === SECRET_TABINDEX) {
      focusable = physicalItem;
    }
    // search for the element which tabindex is bound to the secret tab index
    if (!focusable) {
      focusable = dom(physicalItem)
                      .querySelector('[tabindex="' + SECRET_TABINDEX + '"]');
    }
    // restore the tab index
    model.tabIndex = 0;
    // focus the focusable element
    this._focusedVirtualIndex = idx;
    focusable && focusable.focus();
  },

  _removeFocusedItem: function() {
    if (this._offscreenFocusedItem) {
      this._itemsParent.removeChild(this._offscreenFocusedItem);
    }
    this._offscreenFocusedItem = null;
    this._focusBackfillItem = null;
    this._focusedItem = null;
    this._focusedVirtualIndex = -1;
    this._focusedPhysicalIndex = -1;
  },

  _createFocusBackfillItem: function() {
    var fpidx = this._focusedPhysicalIndex;

    if (this._offscreenFocusedItem || this._focusedVirtualIndex < 0) {
      return;
    }
    if (!this._focusBackfillItem) {
      // Create a physical item.
      var inst = this.stamp(null);
      this._focusBackfillItem =
          /** @type {!HTMLElement} */ (inst.root.querySelector('*'));
      this._itemsParent.appendChild(inst.root);
    }
    // Set the offcreen focused physical item.
    this._offscreenFocusedItem = this._physicalItems[fpidx];
    this.modelForElement(this._offscreenFocusedItem).tabIndex = 0;
    this._physicalItems[fpidx] = this._focusBackfillItem;
    this._focusedPhysicalIndex = fpidx;
    // Hide the focused physical.
    this.translate3d(0, HIDDEN_Y, 0, this._offscreenFocusedItem);
  },

  _restoreFocusedItem: function() {
    if (!this._offscreenFocusedItem || this._focusedVirtualIndex < 0) {
      return;
    }
    // Assign models to the focused index.
    this._assignModels();
    // Get the new physical index for the focused index.
    var fpidx = this._focusedPhysicalIndex =
        this._getPhysicalIndex(this._focusedVirtualIndex);

    var onScreenItem = this._physicalItems[fpidx];
    if (!onScreenItem) {
      return;
    }
    var onScreenInstance = this.modelForElement(onScreenItem);
    var offScreenInstance = this.modelForElement(this._offscreenFocusedItem);
    // Restores the physical item only when it has the same model
    // as the offscreen one. Use key for comparison since users can set
    // a new item via set('items.idx').
    if (onScreenInstance[this.as] === offScreenInstance[this.as]) {
      // Flip the focus backfill.
      this._focusBackfillItem = onScreenItem;
      onScreenInstance.tabIndex = -1;
      // Restore the focused physical item.
      this._physicalItems[fpidx] = this._offscreenFocusedItem;
      // Hide the physical item that backfills.
      this.translate3d(0, HIDDEN_Y, 0, this._focusBackfillItem);
    } else {
      this._removeFocusedItem();
      this._focusBackfillItem = null;
    }
    this._offscreenFocusedItem = null;
  },

  _didFocus: function(e) {
    var targetModel = this.modelForElement(e.target);
    var focusedModel = this.modelForElement(this._focusedItem);
    var hasOffscreenFocusedItem = this._offscreenFocusedItem !== null;
    var fidx = this._focusedVirtualIndex;
    if (!targetModel) {
      return;
    }
    if (focusedModel !== targetModel) {
      this._restoreFocusedItem();
      // Restore tabIndex for the currently focused item.
      if (focusedModel) {
        focusedModel.tabIndex = -1;
      }
      // Set the tabIndex for the next focused item.
      targetModel.tabIndex = 0;
      fidx = targetModel[this.indexAs];
      this._focusedVirtualIndex = fidx;
      this._focusedPhysicalIndex = this._getPhysicalIndex(fidx);
      this._focusedItem = this._physicalItems[this._focusedPhysicalIndex];
      if (hasOffscreenFocusedItem && !this._offscreenFocusedItem) {
        this._update();
      }
    }
  },

  _keydownHandler: function(e) {
    switch (e.keyCode) {
      case /* ARROW_DOWN */ 40:
        if (this._focusedVirtualIndex < this._virtualCount - 1)
          e.preventDefault();
        this._focusPhysicalItem(
            this._focusedVirtualIndex + (this.grid ? this._itemsPerRow : 1));
        break;
      case /* ARROW_RIGHT */ 39:
        if (this.grid)
          this._focusPhysicalItem(
              this._focusedVirtualIndex + (this._isRTL ? -1 : 1));
        break;
      case /* ARROW_UP */ 38:
        if (this._focusedVirtualIndex > 0)
          e.preventDefault();
        this._focusPhysicalItem(
            this._focusedVirtualIndex - (this.grid ? this._itemsPerRow : 1));
        break;
      case /* ARROW_LEFT */ 37:
        if (this.grid)
          this._focusPhysicalItem(
              this._focusedVirtualIndex + (this._isRTL ? 1 : -1));
        break;
      case /* ENTER */ 13:
        this._focusPhysicalItem(this._focusedVirtualIndex);
        if (this.selectionEnabled)
          this._selectionHandler(e);
        break;
    }
  },

  _clamp: function(v, min, max) {
    return Math.min(max, Math.max(min, v));
  },

  _debounce: function(name, cb, asyncModule) {
    this._debouncers = this._debouncers || {};
    this._debouncers[name] =
        Debouncer.debounce(this._debouncers[name], asyncModule, cb.bind(this));
    enqueueDebouncer(this._debouncers[name]);
  },

  _forwardProperty: function(inst, name, value) {
    inst._setPendingProperty(name, value);
  },

  /* Templatizer bindings for v2 */
  _forwardHostPropV2: function(prop, value) {
    (this._physicalItems || [])
        .concat([this._offscreenFocusedItem, this._focusBackfillItem])
        .forEach(function(item) {
          if (item) {
            this.modelForElement(item).forwardHostProp(prop, value);
          }
        }, this);
  },

  _notifyInstancePropV2: function(inst, prop, value) {
    if (matches(this.as, prop)) {
      var idx = inst[this.indexAs];
      if (prop == this.as) {
        this.items[idx] = value;
      }
      this.notifyPath(translate(this.as, 'items.' + idx, prop), value);
    }
  },

  /* Templatizer bindings for v1 */
  _getStampedChildren: function() {
    return this._physicalItems;
  },

  _forwardInstancePath: function(inst, path, value) {
    if (path.indexOf(this.as + '.') === 0) {
      this.notifyPath(
          'items.' + inst.__key__ + '.' + path.slice(this.as.length + 1),
          value);
    }
  },

  _forwardParentPath: function(path, value) {
    (this._physicalItems || [])
        .concat([this._offscreenFocusedItem, this._focusBackfillItem])
        .forEach(function(item) {
          if (item) {
            this.modelForElement(item).notifyPath(path, value);
          }
        }, this);
  },

  _forwardParentProp: function(prop, value) {
    (this._physicalItems || [])
        .concat([this._offscreenFocusedItem, this._focusBackfillItem])
        .forEach(function(item) {
          if (item) {
            this.modelForElement(item)[prop] = value;
          }
        }, this);
  },

  /* Gets the activeElement of the shadow root/host that contains the list. */
  _getActiveElement: function() {
    var itemsHost = this._itemsParent.node.domHost;
    return dom(itemsHost ? itemsHost.root : document).activeElement;
  }
});

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Verify |value| is truthy.
 * @param value A value to check for truthiness. Note that this
 *     may be used to test whether |value| is defined or not, and we don't want
 *     to force a cast to boolean.
 */
function assert$1(value, message) {
    if (value) {
        return;
    }
    throw new Error('Assertion failed' + (message ? `: ${message}` : ''));
}
function assertInstanceof(value, type, message) {
    if (value instanceof type) {
        return;
    }
    throw new Error(message || `Value ${value} is not of type ${type.name || typeof type}`);
}
/**
 * Call this from places in the code that should never be reached.
 *
 * For example, handling all the values of enum with a switch() like this:
 *
 *   function getValueFromEnum(enum) {
 *     switch (enum) {
 *       case ENUM_FIRST_OF_TWO:
 *         return first
 *       case ENUM_LAST_OF_TWO:
 *         return last;
 *     }
 *     assertNotReached();
 *   }
 *
 * This code should only be hit in the case of serious programmer error or
 * unexpected input.
 */
function assertNotReached(message = 'Unreachable code hit') {
    assert$1(false, message);
}

// ash/style/mojom/color_scheme.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ColorSchemeSpec = { $: mojo.internal.Enum() };
var ColorScheme;
(function (ColorScheme) {
    ColorScheme[ColorScheme["MIN_VALUE"] = 0] = "MIN_VALUE";
    ColorScheme[ColorScheme["MAX_VALUE"] = 4] = "MAX_VALUE";
    ColorScheme[ColorScheme["kStatic"] = 0] = "kStatic";
    ColorScheme[ColorScheme["kTonalSpot"] = 1] = "kTonalSpot";
    ColorScheme[ColorScheme["kNeutral"] = 2] = "kNeutral";
    ColorScheme[ColorScheme["kExpressive"] = 3] = "kExpressive";
    ColorScheme[ColorScheme["kVibrant"] = 4] = "kVibrant";
})(ColorScheme || (ColorScheme = {}));

// mojo/public/mojom/base/big_buffer.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const BigBufferSharedMemoryRegionSpec = { $: {} };
const BigBufferSpec = { $: {} };
mojo.internal.Struct(BigBufferSharedMemoryRegionSpec.$, 'BigBufferSharedMemoryRegion', [
    mojo.internal.StructField('bufferHandle', 0, 0, mojo.internal.Handle, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('size', 4, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Union(BigBufferSpec.$, 'BigBuffer', {
    'bytes': {
        'ordinal': 0,
        'type': mojo.internal.Array(mojo.internal.Uint8, false),
    },
    'sharedMemory': {
        'ordinal': 1,
        'type': BigBufferSharedMemoryRegionSpec.$,
    },
    'invalidBuffer': {
        'ordinal': 2,
        'type': mojo.internal.Bool,
    },
});
var BigBufferFieldTags;
(function (BigBufferFieldTags) {
    BigBufferFieldTags[BigBufferFieldTags["BYTES"] = 0] = "BYTES";
    BigBufferFieldTags[BigBufferFieldTags["SHARED_MEMORY"] = 1] = "SHARED_MEMORY";
    BigBufferFieldTags[BigBufferFieldTags["INVALID_BUFFER"] = 2] = "INVALID_BUFFER";
})(BigBufferFieldTags || (BigBufferFieldTags = {}));

// mojo/public/mojom/base/file_path.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const FilePathSpec = { $: {} };
const RelativeFilePathSpec = { $: {} };
mojo.internal.Struct(FilePathSpec.$, 'FilePath', [
    mojo.internal.StructField('path', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(RelativeFilePathSpec.$, 'RelativeFilePath', [
    mojo.internal.StructField('path', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);

// mojo/public/mojom/base/string16.mojom-converters.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class String16DataView {
    decoder_;
    version_;
    fieldSpecs_;
    constructor(decoder, version, fieldSpecs) {
        this.decoder_ = decoder;
        this.version_ = version;
        this.fieldSpecs_ = fieldSpecs;
    }
    get data() {
        const field = this.fieldSpecs_[0];
        return mojo.internal.decodeStructField(this.decoder_, field, this.version_);
    }
}

class String16Converter {
    data(str) {
        const arr = [];
        for (let i = 0; i < str.length; ++i) {
            arr.push(str.charCodeAt(i));
        }
        return arr;
    }
    convert(view) {
        const data = view.data;
        return this.convertImpl(data);
    }
    // Exported for testing.
    // TODO(crbug.com/448737199): we should not have to expose a separate method
    // just to facilitate testing.
    convertImpl(data) {
        // Taken from chunk size used in goog.crypt.byteArrayToBinaryString in
        // Closure Library. The value is equal to 2^13.
        const CHUNK_SIZE = 8192;
        if (data.length < CHUNK_SIZE) {
            return String.fromCharCode(...data);
        }
        // Convert the array to a string in chunks, to avoid passing too many
        // arguments to String.fromCharCode() at once, which can exceed the max call
        // stack size (c.f. crbug.com/1509792).
        let str = '';
        for (let i = 0; i < data.length; i += CHUNK_SIZE) {
            const chunk = data.slice(i, i + CHUNK_SIZE);
            str += String.fromCharCode(...chunk);
        }
        return str;
    }
}

// mojo/public/mojom/base/string16.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const String16Spec = { $: {} };
const BigString16Spec = { $: {} };
const converterForString16 = new String16Converter();
mojo.internal.TypemappedStruct(String16Spec.$, 'String16', String16DataView, converterForString16, [
    mojo.internal.StructField('data', 0, 0, mojo.internal.Array(mojo.internal.Uint16, false), null, false /* nullable */, 0, undefined, ((value) => converterForString16.data(value))),
], [[0, 16],]);
mojo.internal.Struct(BigString16Spec.$, 'BigString16', [
    mojo.internal.StructField('data', 0, 0, BigBufferSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);

// mojo/public/mojom/base/time.mojom-converters.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
class JSTimeDataView {
    decoder_;
    version_;
    fieldSpecs_;
    constructor(decoder, version, fieldSpecs) {
        this.decoder_ = decoder;
        this.version_ = version;
        this.fieldSpecs_ = fieldSpecs;
    }
    get msec() {
        const field = this.fieldSpecs_[0];
        return mojo.internal.decodeStructField(this.decoder_, field, this.version_);
    }
}

class JsTimeConverter {
    // Encoding
    msec(date) {
        return date.valueOf();
    }
    // Decoding
    convert(view) {
        return new Date(view.msec);
    }
}

// mojo/public/mojom/base/time.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const TimeSpec = { $: {} };
const JSTimeSpec = { $: {} };
const TimeDeltaSpec = { $: {} };
const TimeTicksSpec = { $: {} };
mojo.internal.Struct(TimeSpec.$, 'Time', [
    mojo.internal.StructField('internalValue', 0, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
const converterForJSTime = new JsTimeConverter();
mojo.internal.TypemappedStruct(JSTimeSpec.$, 'JSTime', JSTimeDataView, converterForJSTime, [
    mojo.internal.StructField('msec', 0, 0, mojo.internal.Double, 0, false /* nullable */, 0, undefined, ((value) => converterForJSTime.msec(value))),
], [[0, 16],]);
mojo.internal.Struct(TimeDeltaSpec.$, 'TimeDelta', [
    mojo.internal.StructField('microseconds', 0, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(TimeTicksSpec.$, 'TimeTicks', [
    mojo.internal.StructField('internalValue', 0, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);

// skia/public/mojom/skcolor.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SkColorSpec = { $: {} };
mojo.internal.Struct(SkColorSpec.$, 'SkColor', [
    mojo.internal.StructField('value', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);

// url/mojom/url.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const UrlSpec = { $: {} };
mojo.internal.Struct(UrlSpec.$, 'Url', [
    mojo.internal.StructField('url', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);

// ash/webui/personalization_app/mojom/personalization_app.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const STATIC_COLOR_GOOGLE_BLUE = 0x4285F4;
const STATIC_COLOR_LIGHT_PINK = 0xFFD6D6;
const STATIC_COLOR_DARK_GREEN = 0x485045;
const STATIC_COLOR_LIGHT_PURPLE = 0xCBBFFF;
const WHITE_COLOR = 0xFFFFFF;
const RED_COLOR = 0xEE675C;
const YELLOW_COLOR = 0xFBBC04;
const GREEN_COLOR = 0x34A853;
const BLUE_COLOR = 0x00A3C2;
const INDIGO_COLOR = 0x4285F4;
const PURPLE_COLOR = 0xB76DF8;
const WallpaperLayoutSpec = { $: mojo.internal.Enum() };
var WallpaperLayout;
(function (WallpaperLayout) {
    WallpaperLayout[WallpaperLayout["MIN_VALUE"] = 0] = "MIN_VALUE";
    WallpaperLayout[WallpaperLayout["MAX_VALUE"] = 3] = "MAX_VALUE";
    WallpaperLayout[WallpaperLayout["kCenter"] = 0] = "kCenter";
    WallpaperLayout[WallpaperLayout["kCenterCropped"] = 1] = "kCenterCropped";
    WallpaperLayout[WallpaperLayout["kStretch"] = 2] = "kStretch";
    WallpaperLayout[WallpaperLayout["kTile"] = 3] = "kTile";
})(WallpaperLayout || (WallpaperLayout = {}));
const WallpaperTypeSpec = { $: mojo.internal.Enum() };
var WallpaperType;
(function (WallpaperType) {
    WallpaperType[WallpaperType["MIN_VALUE"] = 0] = "MIN_VALUE";
    WallpaperType[WallpaperType["MAX_VALUE"] = 13] = "MAX_VALUE";
    WallpaperType[WallpaperType["kDaily"] = 0] = "kDaily";
    WallpaperType[WallpaperType["kCustomized"] = 1] = "kCustomized";
    WallpaperType[WallpaperType["kDefault"] = 2] = "kDefault";
    WallpaperType[WallpaperType["kOnline"] = 4] = "kOnline";
    WallpaperType[WallpaperType["kPolicy"] = 5] = "kPolicy";
    WallpaperType[WallpaperType["kThirdParty"] = 6] = "kThirdParty";
    WallpaperType[WallpaperType["kDevice"] = 7] = "kDevice";
    WallpaperType[WallpaperType["kOneShot"] = 8] = "kOneShot";
    WallpaperType[WallpaperType["kDailyGooglePhotos"] = 10] = "kDailyGooglePhotos";
    WallpaperType[WallpaperType["kOnceGooglePhotos"] = 11] = "kOnceGooglePhotos";
    WallpaperType[WallpaperType["kOobe"] = 12] = "kOobe";
    WallpaperType[WallpaperType["kSeaPen"] = 13] = "kSeaPen";
})(WallpaperType || (WallpaperType = {}));
const OnlineImageTypeSpec = { $: mojo.internal.Enum() };
var OnlineImageType;
(function (OnlineImageType) {
    OnlineImageType[OnlineImageType["MIN_VALUE"] = 0] = "MIN_VALUE";
    OnlineImageType[OnlineImageType["MAX_VALUE"] = 5] = "MAX_VALUE";
    OnlineImageType[OnlineImageType["kUnknown"] = 0] = "kUnknown";
    OnlineImageType[OnlineImageType["kLight"] = 1] = "kLight";
    OnlineImageType[OnlineImageType["kDark"] = 2] = "kDark";
    OnlineImageType[OnlineImageType["kPreview"] = 3] = "kPreview";
    OnlineImageType[OnlineImageType["kMorning"] = 4] = "kMorning";
    OnlineImageType[OnlineImageType["kLateAfternoon"] = 5] = "kLateAfternoon";
})(OnlineImageType || (OnlineImageType = {}));
const GooglePhotosEnablementStateSpec = { $: mojo.internal.Enum() };
var GooglePhotosEnablementState;
(function (GooglePhotosEnablementState) {
    GooglePhotosEnablementState[GooglePhotosEnablementState["MIN_VALUE"] = 0] = "MIN_VALUE";
    GooglePhotosEnablementState[GooglePhotosEnablementState["MAX_VALUE"] = 2] = "MAX_VALUE";
    GooglePhotosEnablementState[GooglePhotosEnablementState["kError"] = 0] = "kError";
    GooglePhotosEnablementState[GooglePhotosEnablementState["kDisabled"] = 1] = "kDisabled";
    GooglePhotosEnablementState[GooglePhotosEnablementState["kEnabled"] = 2] = "kEnabled";
})(GooglePhotosEnablementState || (GooglePhotosEnablementState = {}));
const StaticColorSpec = { $: mojo.internal.Enum() };
var StaticColor;
(function (StaticColor) {
    StaticColor[StaticColor["MIN_VALUE"] = 0] = "MIN_VALUE";
    StaticColor[StaticColor["MAX_VALUE"] = 4] = "MAX_VALUE";
    StaticColor[StaticColor["kUnknown"] = 0] = "kUnknown";
    StaticColor[StaticColor["kGoogleBlue"] = 1] = "kGoogleBlue";
    StaticColor[StaticColor["kLightPink"] = 2] = "kLightPink";
    StaticColor[StaticColor["kDarkGreen"] = 3] = "kDarkGreen";
    StaticColor[StaticColor["kLightPurple"] = 4] = "kLightPurple";
})(StaticColor || (StaticColor = {}));
const AmbientThemeSpec = { $: mojo.internal.Enum() };
var AmbientTheme;
(function (AmbientTheme) {
    AmbientTheme[AmbientTheme["MIN_VALUE"] = 0] = "MIN_VALUE";
    AmbientTheme[AmbientTheme["MAX_VALUE"] = 3] = "MAX_VALUE";
    AmbientTheme[AmbientTheme["kSlideshow"] = 0] = "kSlideshow";
    AmbientTheme[AmbientTheme["kFeelTheBreeze"] = 1] = "kFeelTheBreeze";
    AmbientTheme[AmbientTheme["kFloatOnBy"] = 2] = "kFloatOnBy";
    AmbientTheme[AmbientTheme["kVideo"] = 3] = "kVideo";
})(AmbientTheme || (AmbientTheme = {}));
const TopicSourceSpec = { $: mojo.internal.Enum() };
var TopicSource;
(function (TopicSource) {
    TopicSource[TopicSource["MIN_VALUE"] = 0] = "MIN_VALUE";
    TopicSource[TopicSource["MAX_VALUE"] = 2] = "MAX_VALUE";
    TopicSource[TopicSource["kGooglePhotos"] = 0] = "kGooglePhotos";
    TopicSource[TopicSource["kArtGallery"] = 1] = "kArtGallery";
    TopicSource[TopicSource["kVideo"] = 2] = "kVideo";
})(TopicSource || (TopicSource = {}));
const TemperatureUnitSpec = { $: mojo.internal.Enum() };
var TemperatureUnit;
(function (TemperatureUnit) {
    TemperatureUnit[TemperatureUnit["MIN_VALUE"] = 0] = "MIN_VALUE";
    TemperatureUnit[TemperatureUnit["MAX_VALUE"] = 1] = "MAX_VALUE";
    TemperatureUnit[TemperatureUnit["kFahrenheit"] = 0] = "kFahrenheit";
    TemperatureUnit[TemperatureUnit["kCelsius"] = 1] = "kCelsius";
})(TemperatureUnit || (TemperatureUnit = {}));
const AmbientUiVisibilitySpec = { $: mojo.internal.Enum() };
var AmbientUiVisibility;
(function (AmbientUiVisibility) {
    AmbientUiVisibility[AmbientUiVisibility["MIN_VALUE"] = 0] = "MIN_VALUE";
    AmbientUiVisibility[AmbientUiVisibility["MAX_VALUE"] = 3] = "MAX_VALUE";
    AmbientUiVisibility[AmbientUiVisibility["kShouldShow"] = 0] = "kShouldShow";
    AmbientUiVisibility[AmbientUiVisibility["kPreview"] = 1] = "kPreview";
    AmbientUiVisibility[AmbientUiVisibility["kHidden"] = 2] = "kHidden";
    AmbientUiVisibility[AmbientUiVisibility["kClosed"] = 3] = "kClosed";
})(AmbientUiVisibility || (AmbientUiVisibility = {}));
const BacklightColorSpec = { $: mojo.internal.Enum() };
var BacklightColor;
(function (BacklightColor) {
    BacklightColor[BacklightColor["MIN_VALUE"] = 0] = "MIN_VALUE";
    BacklightColor[BacklightColor["MAX_VALUE"] = 100] = "MAX_VALUE";
    BacklightColor[BacklightColor["kWallpaper"] = 0] = "kWallpaper";
    BacklightColor[BacklightColor["kWhite"] = 1] = "kWhite";
    BacklightColor[BacklightColor["kRed"] = 2] = "kRed";
    BacklightColor[BacklightColor["kYellow"] = 3] = "kYellow";
    BacklightColor[BacklightColor["kGreen"] = 4] = "kGreen";
    BacklightColor[BacklightColor["kBlue"] = 5] = "kBlue";
    BacklightColor[BacklightColor["kIndigo"] = 6] = "kIndigo";
    BacklightColor[BacklightColor["kPurple"] = 7] = "kPurple";
    BacklightColor[BacklightColor["kRainbow"] = 100] = "kRainbow";
})(BacklightColor || (BacklightColor = {}));
class WallpaperObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.WallpaperObserver', scope);
    }
}
class WallpaperObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(WallpaperObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onWallpaperPreviewEnded() {
        this.proxy.sendMessage(0, WallpaperObserver_OnWallpaperPreviewEnded_ParamsSpec.$, null, [], false);
    }
    onAttributionChanged(attribution) {
        this.proxy.sendMessage(1, WallpaperObserver_OnAttributionChanged_ParamsSpec.$, null, [
            attribution
        ], false);
    }
    onWallpaperChanged(image) {
        this.proxy.sendMessage(2, WallpaperObserver_OnWallpaperChanged_ParamsSpec.$, null, [
            image
        ], false);
    }
}
/**
 * An object which receives request messages for the WallpaperObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class WallpaperObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WallpaperObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, WallpaperObserver_OnWallpaperPreviewEnded_ParamsSpec.$, null, impl.onWallpaperPreviewEnded.bind(impl), false);
        this.helper_internal_.registerHandler(1, WallpaperObserver_OnAttributionChanged_ParamsSpec.$, null, impl.onAttributionChanged.bind(impl), false);
        this.helper_internal_.registerHandler(2, WallpaperObserver_OnWallpaperChanged_ParamsSpec.$, null, impl.onWallpaperChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
/**
 * An object which receives request messages for the WallpaperObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class WallpaperObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WallpaperObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onWallpaperPreviewEnded =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, WallpaperObserver_OnWallpaperPreviewEnded_ParamsSpec.$, null, this.onWallpaperPreviewEnded.createReceiverHandler(false /* expectsResponse */), false);
        this.onAttributionChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, WallpaperObserver_OnAttributionChanged_ParamsSpec.$, null, this.onAttributionChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onWallpaperChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, WallpaperObserver_OnWallpaperChanged_ParamsSpec.$, null, this.onWallpaperChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
class WallpaperProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.WallpaperProvider', scope);
    }
}
class WallpaperProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(WallpaperProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    makeTransparent() {
        this.proxy.sendMessage(0, WallpaperProvider_MakeTransparent_ParamsSpec.$, null, [], false);
    }
    makeOpaque() {
        this.proxy.sendMessage(1, WallpaperProvider_MakeOpaque_ParamsSpec.$, null, [], false);
    }
    fetchCollections() {
        return this.proxy.sendMessage(2, WallpaperProvider_FetchCollections_ParamsSpec.$, WallpaperProvider_FetchCollections_ResponseParamsSpec.$, [], false);
    }
    fetchImagesForCollection(collectionId) {
        return this.proxy.sendMessage(3, WallpaperProvider_FetchImagesForCollection_ParamsSpec.$, WallpaperProvider_FetchImagesForCollection_ResponseParamsSpec.$, [
            collectionId
        ], false);
    }
    fetchGooglePhotosAlbums(resumeToken) {
        return this.proxy.sendMessage(4, WallpaperProvider_FetchGooglePhotosAlbums_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosAlbums_ResponseParamsSpec.$, [
            resumeToken
        ], false);
    }
    fetchGooglePhotosSharedAlbums(resumeToken) {
        return this.proxy.sendMessage(5, WallpaperProvider_FetchGooglePhotosSharedAlbums_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosSharedAlbums_ResponseParamsSpec.$, [
            resumeToken
        ], false);
    }
    fetchGooglePhotosEnabled() {
        return this.proxy.sendMessage(6, WallpaperProvider_FetchGooglePhotosEnabled_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosEnabled_ResponseParamsSpec.$, [], false);
    }
    fetchGooglePhotosPhotos(itemId, albumId, resumeToken) {
        return this.proxy.sendMessage(7, WallpaperProvider_FetchGooglePhotosPhotos_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosPhotos_ResponseParamsSpec.$, [
            itemId,
            albumId,
            resumeToken
        ], false);
    }
    getLocalImages() {
        return this.proxy.sendMessage(8, WallpaperProvider_GetLocalImages_ParamsSpec.$, WallpaperProvider_GetLocalImages_ResponseParamsSpec.$, [], false);
    }
    getDefaultImageThumbnail() {
        return this.proxy.sendMessage(9, WallpaperProvider_GetDefaultImageThumbnail_ParamsSpec.$, WallpaperProvider_GetDefaultImageThumbnail_ResponseParamsSpec.$, [], false);
    }
    getLocalImageThumbnail(filePath) {
        return this.proxy.sendMessage(10, WallpaperProvider_GetLocalImageThumbnail_ParamsSpec.$, WallpaperProvider_GetLocalImageThumbnail_ResponseParamsSpec.$, [
            filePath
        ], false);
    }
    setWallpaperObserver(observer) {
        this.proxy.sendMessage(11, WallpaperProvider_SetWallpaperObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    selectWallpaper(unitId, previewMode) {
        return this.proxy.sendMessage(12, WallpaperProvider_SelectWallpaper_ParamsSpec.$, WallpaperProvider_SelectWallpaper_ResponseParamsSpec.$, [
            unitId,
            previewMode
        ], false);
    }
    selectDefaultImage() {
        return this.proxy.sendMessage(13, WallpaperProvider_SelectDefaultImage_ParamsSpec.$, WallpaperProvider_SelectDefaultImage_ResponseParamsSpec.$, [], false);
    }
    selectLocalImage(path, layout, previewMode) {
        return this.proxy.sendMessage(14, WallpaperProvider_SelectLocalImage_ParamsSpec.$, WallpaperProvider_SelectLocalImage_ResponseParamsSpec.$, [
            path,
            layout,
            previewMode
        ], false);
    }
    selectGooglePhotosPhoto(id, layout, previewMode) {
        return this.proxy.sendMessage(15, WallpaperProvider_SelectGooglePhotosPhoto_ParamsSpec.$, WallpaperProvider_SelectGooglePhotosPhoto_ResponseParamsSpec.$, [
            id,
            layout,
            previewMode
        ], false);
    }
    selectGooglePhotosAlbum(id) {
        return this.proxy.sendMessage(16, WallpaperProvider_SelectGooglePhotosAlbum_ParamsSpec.$, WallpaperProvider_SelectGooglePhotosAlbum_ResponseParamsSpec.$, [
            id
        ], false);
    }
    getGooglePhotosDailyRefreshAlbumId() {
        return this.proxy.sendMessage(17, WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ParamsSpec.$, WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ResponseParamsSpec.$, [], false);
    }
    setCurrentWallpaperLayout(layout) {
        this.proxy.sendMessage(18, WallpaperProvider_SetCurrentWallpaperLayout_ParamsSpec.$, null, [
            layout
        ], false);
    }
    setDailyRefreshCollectionId(collectionId) {
        return this.proxy.sendMessage(19, WallpaperProvider_SetDailyRefreshCollectionId_ParamsSpec.$, WallpaperProvider_SetDailyRefreshCollectionId_ResponseParamsSpec.$, [
            collectionId
        ], false);
    }
    getDailyRefreshCollectionId() {
        return this.proxy.sendMessage(20, WallpaperProvider_GetDailyRefreshCollectionId_ParamsSpec.$, WallpaperProvider_GetDailyRefreshCollectionId_ResponseParamsSpec.$, [], false);
    }
    updateDailyRefreshWallpaper() {
        return this.proxy.sendMessage(21, WallpaperProvider_UpdateDailyRefreshWallpaper_ParamsSpec.$, WallpaperProvider_UpdateDailyRefreshWallpaper_ResponseParamsSpec.$, [], false);
    }
    isInTabletMode() {
        return this.proxy.sendMessage(22, WallpaperProvider_IsInTabletMode_ParamsSpec.$, WallpaperProvider_IsInTabletMode_ResponseParamsSpec.$, [], false);
    }
    confirmPreviewWallpaper() {
        this.proxy.sendMessage(23, WallpaperProvider_ConfirmPreviewWallpaper_ParamsSpec.$, null, [], false);
    }
    cancelPreviewWallpaper() {
        this.proxy.sendMessage(24, WallpaperProvider_CancelPreviewWallpaper_ParamsSpec.$, null, [], false);
    }
    shouldShowTimeOfDayWallpaperDialog() {
        return this.proxy.sendMessage(25, WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ParamsSpec.$, WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ResponseParamsSpec.$, [], false);
    }
}
/**
 * An object which receives request messages for the WallpaperProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class WallpaperProviderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WallpaperProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, WallpaperProvider_MakeTransparent_ParamsSpec.$, null, impl.makeTransparent.bind(impl), false);
        this.helper_internal_.registerHandler(1, WallpaperProvider_MakeOpaque_ParamsSpec.$, null, impl.makeOpaque.bind(impl), false);
        this.helper_internal_.registerHandler(2, WallpaperProvider_FetchCollections_ParamsSpec.$, WallpaperProvider_FetchCollections_ResponseParamsSpec.$, impl.fetchCollections.bind(impl), false);
        this.helper_internal_.registerHandler(3, WallpaperProvider_FetchImagesForCollection_ParamsSpec.$, WallpaperProvider_FetchImagesForCollection_ResponseParamsSpec.$, impl.fetchImagesForCollection.bind(impl), false);
        this.helper_internal_.registerHandler(4, WallpaperProvider_FetchGooglePhotosAlbums_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosAlbums_ResponseParamsSpec.$, impl.fetchGooglePhotosAlbums.bind(impl), false);
        this.helper_internal_.registerHandler(5, WallpaperProvider_FetchGooglePhotosSharedAlbums_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosSharedAlbums_ResponseParamsSpec.$, impl.fetchGooglePhotosSharedAlbums.bind(impl), false);
        this.helper_internal_.registerHandler(6, WallpaperProvider_FetchGooglePhotosEnabled_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosEnabled_ResponseParamsSpec.$, impl.fetchGooglePhotosEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(7, WallpaperProvider_FetchGooglePhotosPhotos_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosPhotos_ResponseParamsSpec.$, impl.fetchGooglePhotosPhotos.bind(impl), false);
        this.helper_internal_.registerHandler(8, WallpaperProvider_GetLocalImages_ParamsSpec.$, WallpaperProvider_GetLocalImages_ResponseParamsSpec.$, impl.getLocalImages.bind(impl), false);
        this.helper_internal_.registerHandler(9, WallpaperProvider_GetDefaultImageThumbnail_ParamsSpec.$, WallpaperProvider_GetDefaultImageThumbnail_ResponseParamsSpec.$, impl.getDefaultImageThumbnail.bind(impl), false);
        this.helper_internal_.registerHandler(10, WallpaperProvider_GetLocalImageThumbnail_ParamsSpec.$, WallpaperProvider_GetLocalImageThumbnail_ResponseParamsSpec.$, impl.getLocalImageThumbnail.bind(impl), false);
        this.helper_internal_.registerHandler(11, WallpaperProvider_SetWallpaperObserver_ParamsSpec.$, null, impl.setWallpaperObserver.bind(impl), false);
        this.helper_internal_.registerHandler(12, WallpaperProvider_SelectWallpaper_ParamsSpec.$, WallpaperProvider_SelectWallpaper_ResponseParamsSpec.$, impl.selectWallpaper.bind(impl), false);
        this.helper_internal_.registerHandler(13, WallpaperProvider_SelectDefaultImage_ParamsSpec.$, WallpaperProvider_SelectDefaultImage_ResponseParamsSpec.$, impl.selectDefaultImage.bind(impl), false);
        this.helper_internal_.registerHandler(14, WallpaperProvider_SelectLocalImage_ParamsSpec.$, WallpaperProvider_SelectLocalImage_ResponseParamsSpec.$, impl.selectLocalImage.bind(impl), false);
        this.helper_internal_.registerHandler(15, WallpaperProvider_SelectGooglePhotosPhoto_ParamsSpec.$, WallpaperProvider_SelectGooglePhotosPhoto_ResponseParamsSpec.$, impl.selectGooglePhotosPhoto.bind(impl), false);
        this.helper_internal_.registerHandler(16, WallpaperProvider_SelectGooglePhotosAlbum_ParamsSpec.$, WallpaperProvider_SelectGooglePhotosAlbum_ResponseParamsSpec.$, impl.selectGooglePhotosAlbum.bind(impl), false);
        this.helper_internal_.registerHandler(17, WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ParamsSpec.$, WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ResponseParamsSpec.$, impl.getGooglePhotosDailyRefreshAlbumId.bind(impl), false);
        this.helper_internal_.registerHandler(18, WallpaperProvider_SetCurrentWallpaperLayout_ParamsSpec.$, null, impl.setCurrentWallpaperLayout.bind(impl), false);
        this.helper_internal_.registerHandler(19, WallpaperProvider_SetDailyRefreshCollectionId_ParamsSpec.$, WallpaperProvider_SetDailyRefreshCollectionId_ResponseParamsSpec.$, impl.setDailyRefreshCollectionId.bind(impl), false);
        this.helper_internal_.registerHandler(20, WallpaperProvider_GetDailyRefreshCollectionId_ParamsSpec.$, WallpaperProvider_GetDailyRefreshCollectionId_ResponseParamsSpec.$, impl.getDailyRefreshCollectionId.bind(impl), false);
        this.helper_internal_.registerHandler(21, WallpaperProvider_UpdateDailyRefreshWallpaper_ParamsSpec.$, WallpaperProvider_UpdateDailyRefreshWallpaper_ResponseParamsSpec.$, impl.updateDailyRefreshWallpaper.bind(impl), false);
        this.helper_internal_.registerHandler(22, WallpaperProvider_IsInTabletMode_ParamsSpec.$, WallpaperProvider_IsInTabletMode_ResponseParamsSpec.$, impl.isInTabletMode.bind(impl), false);
        this.helper_internal_.registerHandler(23, WallpaperProvider_ConfirmPreviewWallpaper_ParamsSpec.$, null, impl.confirmPreviewWallpaper.bind(impl), false);
        this.helper_internal_.registerHandler(24, WallpaperProvider_CancelPreviewWallpaper_ParamsSpec.$, null, impl.cancelPreviewWallpaper.bind(impl), false);
        this.helper_internal_.registerHandler(25, WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ParamsSpec.$, WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ResponseParamsSpec.$, impl.shouldShowTimeOfDayWallpaperDialog.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class WallpaperProvider {
    static get $interfaceName() {
        return "ash.personalization_app.mojom.WallpaperProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new WallpaperProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the WallpaperProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class WallpaperProviderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(WallpaperProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.makeTransparent =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, WallpaperProvider_MakeTransparent_ParamsSpec.$, null, this.makeTransparent.createReceiverHandler(false /* expectsResponse */), false);
        this.makeOpaque =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, WallpaperProvider_MakeOpaque_ParamsSpec.$, null, this.makeOpaque.createReceiverHandler(false /* expectsResponse */), false);
        this.fetchCollections =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, WallpaperProvider_FetchCollections_ParamsSpec.$, WallpaperProvider_FetchCollections_ResponseParamsSpec.$, this.fetchCollections.createReceiverHandler(true /* expectsResponse */), false);
        this.fetchImagesForCollection =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, WallpaperProvider_FetchImagesForCollection_ParamsSpec.$, WallpaperProvider_FetchImagesForCollection_ResponseParamsSpec.$, this.fetchImagesForCollection.createReceiverHandler(true /* expectsResponse */), false);
        this.fetchGooglePhotosAlbums =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, WallpaperProvider_FetchGooglePhotosAlbums_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosAlbums_ResponseParamsSpec.$, this.fetchGooglePhotosAlbums.createReceiverHandler(true /* expectsResponse */), false);
        this.fetchGooglePhotosSharedAlbums =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, WallpaperProvider_FetchGooglePhotosSharedAlbums_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosSharedAlbums_ResponseParamsSpec.$, this.fetchGooglePhotosSharedAlbums.createReceiverHandler(true /* expectsResponse */), false);
        this.fetchGooglePhotosEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, WallpaperProvider_FetchGooglePhotosEnabled_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosEnabled_ResponseParamsSpec.$, this.fetchGooglePhotosEnabled.createReceiverHandler(true /* expectsResponse */), false);
        this.fetchGooglePhotosPhotos =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, WallpaperProvider_FetchGooglePhotosPhotos_ParamsSpec.$, WallpaperProvider_FetchGooglePhotosPhotos_ResponseParamsSpec.$, this.fetchGooglePhotosPhotos.createReceiverHandler(true /* expectsResponse */), false);
        this.getLocalImages =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, WallpaperProvider_GetLocalImages_ParamsSpec.$, WallpaperProvider_GetLocalImages_ResponseParamsSpec.$, this.getLocalImages.createReceiverHandler(true /* expectsResponse */), false);
        this.getDefaultImageThumbnail =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, WallpaperProvider_GetDefaultImageThumbnail_ParamsSpec.$, WallpaperProvider_GetDefaultImageThumbnail_ResponseParamsSpec.$, this.getDefaultImageThumbnail.createReceiverHandler(true /* expectsResponse */), false);
        this.getLocalImageThumbnail =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, WallpaperProvider_GetLocalImageThumbnail_ParamsSpec.$, WallpaperProvider_GetLocalImageThumbnail_ResponseParamsSpec.$, this.getLocalImageThumbnail.createReceiverHandler(true /* expectsResponse */), false);
        this.setWallpaperObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, WallpaperProvider_SetWallpaperObserver_ParamsSpec.$, null, this.setWallpaperObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.selectWallpaper =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, WallpaperProvider_SelectWallpaper_ParamsSpec.$, WallpaperProvider_SelectWallpaper_ResponseParamsSpec.$, this.selectWallpaper.createReceiverHandler(true /* expectsResponse */), false);
        this.selectDefaultImage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, WallpaperProvider_SelectDefaultImage_ParamsSpec.$, WallpaperProvider_SelectDefaultImage_ResponseParamsSpec.$, this.selectDefaultImage.createReceiverHandler(true /* expectsResponse */), false);
        this.selectLocalImage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, WallpaperProvider_SelectLocalImage_ParamsSpec.$, WallpaperProvider_SelectLocalImage_ResponseParamsSpec.$, this.selectLocalImage.createReceiverHandler(true /* expectsResponse */), false);
        this.selectGooglePhotosPhoto =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, WallpaperProvider_SelectGooglePhotosPhoto_ParamsSpec.$, WallpaperProvider_SelectGooglePhotosPhoto_ResponseParamsSpec.$, this.selectGooglePhotosPhoto.createReceiverHandler(true /* expectsResponse */), false);
        this.selectGooglePhotosAlbum =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(16, WallpaperProvider_SelectGooglePhotosAlbum_ParamsSpec.$, WallpaperProvider_SelectGooglePhotosAlbum_ResponseParamsSpec.$, this.selectGooglePhotosAlbum.createReceiverHandler(true /* expectsResponse */), false);
        this.getGooglePhotosDailyRefreshAlbumId =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(17, WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ParamsSpec.$, WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ResponseParamsSpec.$, this.getGooglePhotosDailyRefreshAlbumId.createReceiverHandler(true /* expectsResponse */), false);
        this.setCurrentWallpaperLayout =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(18, WallpaperProvider_SetCurrentWallpaperLayout_ParamsSpec.$, null, this.setCurrentWallpaperLayout.createReceiverHandler(false /* expectsResponse */), false);
        this.setDailyRefreshCollectionId =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(19, WallpaperProvider_SetDailyRefreshCollectionId_ParamsSpec.$, WallpaperProvider_SetDailyRefreshCollectionId_ResponseParamsSpec.$, this.setDailyRefreshCollectionId.createReceiverHandler(true /* expectsResponse */), false);
        this.getDailyRefreshCollectionId =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(20, WallpaperProvider_GetDailyRefreshCollectionId_ParamsSpec.$, WallpaperProvider_GetDailyRefreshCollectionId_ResponseParamsSpec.$, this.getDailyRefreshCollectionId.createReceiverHandler(true /* expectsResponse */), false);
        this.updateDailyRefreshWallpaper =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(21, WallpaperProvider_UpdateDailyRefreshWallpaper_ParamsSpec.$, WallpaperProvider_UpdateDailyRefreshWallpaper_ResponseParamsSpec.$, this.updateDailyRefreshWallpaper.createReceiverHandler(true /* expectsResponse */), false);
        this.isInTabletMode =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(22, WallpaperProvider_IsInTabletMode_ParamsSpec.$, WallpaperProvider_IsInTabletMode_ResponseParamsSpec.$, this.isInTabletMode.createReceiverHandler(true /* expectsResponse */), false);
        this.confirmPreviewWallpaper =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(23, WallpaperProvider_ConfirmPreviewWallpaper_ParamsSpec.$, null, this.confirmPreviewWallpaper.createReceiverHandler(false /* expectsResponse */), false);
        this.cancelPreviewWallpaper =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(24, WallpaperProvider_CancelPreviewWallpaper_ParamsSpec.$, null, this.cancelPreviewWallpaper.createReceiverHandler(false /* expectsResponse */), false);
        this.shouldShowTimeOfDayWallpaperDialog =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(25, WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ParamsSpec.$, WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ResponseParamsSpec.$, this.shouldShowTimeOfDayWallpaperDialog.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
class ThemeObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.ThemeObserver', scope);
    }
}
class ThemeObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ThemeObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onColorModeChanged(darkModeEnabled) {
        this.proxy.sendMessage(0, ThemeObserver_OnColorModeChanged_ParamsSpec.$, null, [
            darkModeEnabled
        ], false);
    }
    onColorModeAutoScheduleChanged(enabled) {
        this.proxy.sendMessage(1, ThemeObserver_OnColorModeAutoScheduleChanged_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    onColorSchemeChanged(colorScheme) {
        this.proxy.sendMessage(2, ThemeObserver_OnColorSchemeChanged_ParamsSpec.$, null, [
            colorScheme
        ], false);
    }
    onSampleColorSchemesChanged(sampleColorSchemes) {
        this.proxy.sendMessage(3, ThemeObserver_OnSampleColorSchemesChanged_ParamsSpec.$, null, [
            sampleColorSchemes
        ], false);
    }
    onStaticColorChanged(color) {
        this.proxy.sendMessage(4, ThemeObserver_OnStaticColorChanged_ParamsSpec.$, null, [
            color
        ], false);
    }
    onGeolocationPermissionForSystemServicesChanged(enabled, isUserModifiable) {
        this.proxy.sendMessage(5, ThemeObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec.$, null, [
            enabled,
            isUserModifiable
        ], false);
    }
    onDaylightTimeChanged(sunriseTime, sunsetTime) {
        this.proxy.sendMessage(6, ThemeObserver_OnDaylightTimeChanged_ParamsSpec.$, null, [
            sunriseTime,
            sunsetTime
        ], false);
    }
}
/**
 * An object which receives request messages for the ThemeObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class ThemeObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ThemeObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ThemeObserver_OnColorModeChanged_ParamsSpec.$, null, impl.onColorModeChanged.bind(impl), false);
        this.helper_internal_.registerHandler(1, ThemeObserver_OnColorModeAutoScheduleChanged_ParamsSpec.$, null, impl.onColorModeAutoScheduleChanged.bind(impl), false);
        this.helper_internal_.registerHandler(2, ThemeObserver_OnColorSchemeChanged_ParamsSpec.$, null, impl.onColorSchemeChanged.bind(impl), false);
        this.helper_internal_.registerHandler(3, ThemeObserver_OnSampleColorSchemesChanged_ParamsSpec.$, null, impl.onSampleColorSchemesChanged.bind(impl), false);
        this.helper_internal_.registerHandler(4, ThemeObserver_OnStaticColorChanged_ParamsSpec.$, null, impl.onStaticColorChanged.bind(impl), false);
        this.helper_internal_.registerHandler(5, ThemeObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec.$, null, impl.onGeolocationPermissionForSystemServicesChanged.bind(impl), false);
        this.helper_internal_.registerHandler(6, ThemeObserver_OnDaylightTimeChanged_ParamsSpec.$, null, impl.onDaylightTimeChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
/**
 * An object which receives request messages for the ThemeObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class ThemeObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ThemeObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onColorModeChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ThemeObserver_OnColorModeChanged_ParamsSpec.$, null, this.onColorModeChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onColorModeAutoScheduleChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ThemeObserver_OnColorModeAutoScheduleChanged_ParamsSpec.$, null, this.onColorModeAutoScheduleChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onColorSchemeChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, ThemeObserver_OnColorSchemeChanged_ParamsSpec.$, null, this.onColorSchemeChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onSampleColorSchemesChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, ThemeObserver_OnSampleColorSchemesChanged_ParamsSpec.$, null, this.onSampleColorSchemesChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onStaticColorChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, ThemeObserver_OnStaticColorChanged_ParamsSpec.$, null, this.onStaticColorChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onGeolocationPermissionForSystemServicesChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, ThemeObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec.$, null, this.onGeolocationPermissionForSystemServicesChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onDaylightTimeChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, ThemeObserver_OnDaylightTimeChanged_ParamsSpec.$, null, this.onDaylightTimeChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
class ThemeProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.ThemeProvider', scope);
    }
}
class ThemeProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(ThemeProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    setThemeObserver(observer) {
        this.proxy.sendMessage(0, ThemeProvider_SetThemeObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    setColorModePref(darkModeEnabled) {
        this.proxy.sendMessage(1, ThemeProvider_SetColorModePref_ParamsSpec.$, null, [
            darkModeEnabled
        ], false);
    }
    setColorModeAutoScheduleEnabled(enabled) {
        this.proxy.sendMessage(2, ThemeProvider_SetColorModeAutoScheduleEnabled_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    setColorScheme(colorScheme) {
        this.proxy.sendMessage(3, ThemeProvider_SetColorScheme_ParamsSpec.$, null, [
            colorScheme
        ], false);
    }
    setStaticColor(staticColor) {
        this.proxy.sendMessage(4, ThemeProvider_SetStaticColor_ParamsSpec.$, null, [
            staticColor
        ], false);
    }
    enableGeolocationForSystemServices() {
        this.proxy.sendMessage(5, ThemeProvider_EnableGeolocationForSystemServices_ParamsSpec.$, null, [], false);
    }
    getColorScheme() {
        return this.proxy.sendMessage(6, ThemeProvider_GetColorScheme_ParamsSpec.$, ThemeProvider_GetColorScheme_ResponseParamsSpec.$, [], false);
    }
    getStaticColor() {
        return this.proxy.sendMessage(7, ThemeProvider_GetStaticColor_ParamsSpec.$, ThemeProvider_GetStaticColor_ResponseParamsSpec.$, [], false);
    }
    generateSampleColorSchemes() {
        return this.proxy.sendMessage(8, ThemeProvider_GenerateSampleColorSchemes_ParamsSpec.$, ThemeProvider_GenerateSampleColorSchemes_ResponseParamsSpec.$, [], false);
    }
    isColorModeAutoScheduleEnabled() {
        return this.proxy.sendMessage(9, ThemeProvider_IsColorModeAutoScheduleEnabled_ParamsSpec.$, ThemeProvider_IsColorModeAutoScheduleEnabled_ResponseParamsSpec.$, [], false);
    }
    isDarkModeEnabled() {
        return this.proxy.sendMessage(10, ThemeProvider_IsDarkModeEnabled_ParamsSpec.$, ThemeProvider_IsDarkModeEnabled_ResponseParamsSpec.$, [], false);
    }
    isGeolocationEnabledForSystemServices() {
        return this.proxy.sendMessage(11, ThemeProvider_IsGeolocationEnabledForSystemServices_ParamsSpec.$, ThemeProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec.$, [], false);
    }
    isGeolocationUserModifiable() {
        return this.proxy.sendMessage(12, ThemeProvider_IsGeolocationUserModifiable_ParamsSpec.$, ThemeProvider_IsGeolocationUserModifiable_ResponseParamsSpec.$, [], false);
    }
}
/**
 * An object which receives request messages for the ThemeProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class ThemeProviderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ThemeProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, ThemeProvider_SetThemeObserver_ParamsSpec.$, null, impl.setThemeObserver.bind(impl), false);
        this.helper_internal_.registerHandler(1, ThemeProvider_SetColorModePref_ParamsSpec.$, null, impl.setColorModePref.bind(impl), false);
        this.helper_internal_.registerHandler(2, ThemeProvider_SetColorModeAutoScheduleEnabled_ParamsSpec.$, null, impl.setColorModeAutoScheduleEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(3, ThemeProvider_SetColorScheme_ParamsSpec.$, null, impl.setColorScheme.bind(impl), false);
        this.helper_internal_.registerHandler(4, ThemeProvider_SetStaticColor_ParamsSpec.$, null, impl.setStaticColor.bind(impl), false);
        this.helper_internal_.registerHandler(5, ThemeProvider_EnableGeolocationForSystemServices_ParamsSpec.$, null, impl.enableGeolocationForSystemServices.bind(impl), false);
        this.helper_internal_.registerHandler(6, ThemeProvider_GetColorScheme_ParamsSpec.$, ThemeProvider_GetColorScheme_ResponseParamsSpec.$, impl.getColorScheme.bind(impl), false);
        this.helper_internal_.registerHandler(7, ThemeProvider_GetStaticColor_ParamsSpec.$, ThemeProvider_GetStaticColor_ResponseParamsSpec.$, impl.getStaticColor.bind(impl), false);
        this.helper_internal_.registerHandler(8, ThemeProvider_GenerateSampleColorSchemes_ParamsSpec.$, ThemeProvider_GenerateSampleColorSchemes_ResponseParamsSpec.$, impl.generateSampleColorSchemes.bind(impl), false);
        this.helper_internal_.registerHandler(9, ThemeProvider_IsColorModeAutoScheduleEnabled_ParamsSpec.$, ThemeProvider_IsColorModeAutoScheduleEnabled_ResponseParamsSpec.$, impl.isColorModeAutoScheduleEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(10, ThemeProvider_IsDarkModeEnabled_ParamsSpec.$, ThemeProvider_IsDarkModeEnabled_ResponseParamsSpec.$, impl.isDarkModeEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(11, ThemeProvider_IsGeolocationEnabledForSystemServices_ParamsSpec.$, ThemeProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec.$, impl.isGeolocationEnabledForSystemServices.bind(impl), false);
        this.helper_internal_.registerHandler(12, ThemeProvider_IsGeolocationUserModifiable_ParamsSpec.$, ThemeProvider_IsGeolocationUserModifiable_ResponseParamsSpec.$, impl.isGeolocationUserModifiable.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class ThemeProvider {
    static get $interfaceName() {
        return "ash.personalization_app.mojom.ThemeProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new ThemeProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the ThemeProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class ThemeProviderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ThemeProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.setThemeObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, ThemeProvider_SetThemeObserver_ParamsSpec.$, null, this.setThemeObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.setColorModePref =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, ThemeProvider_SetColorModePref_ParamsSpec.$, null, this.setColorModePref.createReceiverHandler(false /* expectsResponse */), false);
        this.setColorModeAutoScheduleEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, ThemeProvider_SetColorModeAutoScheduleEnabled_ParamsSpec.$, null, this.setColorModeAutoScheduleEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.setColorScheme =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, ThemeProvider_SetColorScheme_ParamsSpec.$, null, this.setColorScheme.createReceiverHandler(false /* expectsResponse */), false);
        this.setStaticColor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, ThemeProvider_SetStaticColor_ParamsSpec.$, null, this.setStaticColor.createReceiverHandler(false /* expectsResponse */), false);
        this.enableGeolocationForSystemServices =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, ThemeProvider_EnableGeolocationForSystemServices_ParamsSpec.$, null, this.enableGeolocationForSystemServices.createReceiverHandler(false /* expectsResponse */), false);
        this.getColorScheme =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, ThemeProvider_GetColorScheme_ParamsSpec.$, ThemeProvider_GetColorScheme_ResponseParamsSpec.$, this.getColorScheme.createReceiverHandler(true /* expectsResponse */), false);
        this.getStaticColor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, ThemeProvider_GetStaticColor_ParamsSpec.$, ThemeProvider_GetStaticColor_ResponseParamsSpec.$, this.getStaticColor.createReceiverHandler(true /* expectsResponse */), false);
        this.generateSampleColorSchemes =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, ThemeProvider_GenerateSampleColorSchemes_ParamsSpec.$, ThemeProvider_GenerateSampleColorSchemes_ResponseParamsSpec.$, this.generateSampleColorSchemes.createReceiverHandler(true /* expectsResponse */), false);
        this.isColorModeAutoScheduleEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, ThemeProvider_IsColorModeAutoScheduleEnabled_ParamsSpec.$, ThemeProvider_IsColorModeAutoScheduleEnabled_ResponseParamsSpec.$, this.isColorModeAutoScheduleEnabled.createReceiverHandler(true /* expectsResponse */), false);
        this.isDarkModeEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, ThemeProvider_IsDarkModeEnabled_ParamsSpec.$, ThemeProvider_IsDarkModeEnabled_ResponseParamsSpec.$, this.isDarkModeEnabled.createReceiverHandler(true /* expectsResponse */), false);
        this.isGeolocationEnabledForSystemServices =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, ThemeProvider_IsGeolocationEnabledForSystemServices_ParamsSpec.$, ThemeProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec.$, this.isGeolocationEnabledForSystemServices.createReceiverHandler(true /* expectsResponse */), false);
        this.isGeolocationUserModifiable =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, ThemeProvider_IsGeolocationUserModifiable_ParamsSpec.$, ThemeProvider_IsGeolocationUserModifiable_ResponseParamsSpec.$, this.isGeolocationUserModifiable.createReceiverHandler(true /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
class UserImageObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.UserImageObserver', scope);
    }
}
class UserImageObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(UserImageObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onUserImageChanged(userImage) {
        this.proxy.sendMessage(0, UserImageObserver_OnUserImageChanged_ParamsSpec.$, null, [
            userImage
        ], false);
    }
    onUserProfileImageUpdated(profileImage) {
        this.proxy.sendMessage(1, UserImageObserver_OnUserProfileImageUpdated_ParamsSpec.$, null, [
            profileImage
        ], false);
    }
    onCameraPresenceCheckDone(isCameraPresent) {
        this.proxy.sendMessage(2, UserImageObserver_OnCameraPresenceCheckDone_ParamsSpec.$, null, [
            isCameraPresent
        ], false);
    }
    onIsEnterpriseManagedChanged(isEnterpriseManaged) {
        this.proxy.sendMessage(3, UserImageObserver_OnIsEnterpriseManagedChanged_ParamsSpec.$, null, [
            isEnterpriseManaged
        ], false);
    }
}
/**
 * An object which receives request messages for the UserImageObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class UserImageObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UserImageObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, UserImageObserver_OnUserImageChanged_ParamsSpec.$, null, impl.onUserImageChanged.bind(impl), false);
        this.helper_internal_.registerHandler(1, UserImageObserver_OnUserProfileImageUpdated_ParamsSpec.$, null, impl.onUserProfileImageUpdated.bind(impl), false);
        this.helper_internal_.registerHandler(2, UserImageObserver_OnCameraPresenceCheckDone_ParamsSpec.$, null, impl.onCameraPresenceCheckDone.bind(impl), false);
        this.helper_internal_.registerHandler(3, UserImageObserver_OnIsEnterpriseManagedChanged_ParamsSpec.$, null, impl.onIsEnterpriseManagedChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
/**
 * An object which receives request messages for the UserImageObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class UserImageObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UserImageObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onUserImageChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, UserImageObserver_OnUserImageChanged_ParamsSpec.$, null, this.onUserImageChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onUserProfileImageUpdated =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, UserImageObserver_OnUserProfileImageUpdated_ParamsSpec.$, null, this.onUserProfileImageUpdated.createReceiverHandler(false /* expectsResponse */), false);
        this.onCameraPresenceCheckDone =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, UserImageObserver_OnCameraPresenceCheckDone_ParamsSpec.$, null, this.onCameraPresenceCheckDone.createReceiverHandler(false /* expectsResponse */), false);
        this.onIsEnterpriseManagedChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, UserImageObserver_OnIsEnterpriseManagedChanged_ParamsSpec.$, null, this.onIsEnterpriseManagedChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
class UserProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.UserProvider', scope);
    }
}
class UserProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(UserProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    setUserImageObserver(observer) {
        this.proxy.sendMessage(0, UserProvider_SetUserImageObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    getUserInfo() {
        return this.proxy.sendMessage(1, UserProvider_GetUserInfo_ParamsSpec.$, UserProvider_GetUserInfo_ResponseParamsSpec.$, [], false);
    }
    getDefaultUserImages() {
        return this.proxy.sendMessage(2, UserProvider_GetDefaultUserImages_ParamsSpec.$, UserProvider_GetDefaultUserImages_ResponseParamsSpec.$, [], false);
    }
    selectDefaultImage(index) {
        this.proxy.sendMessage(3, UserProvider_SelectDefaultImage_ParamsSpec.$, null, [
            index
        ], false);
    }
    selectProfileImage() {
        this.proxy.sendMessage(4, UserProvider_SelectProfileImage_ParamsSpec.$, null, [], false);
    }
    selectCameraImage(data) {
        this.proxy.sendMessage(5, UserProvider_SelectCameraImage_ParamsSpec.$, null, [
            data
        ], false);
    }
    selectImageFromDisk() {
        this.proxy.sendMessage(6, UserProvider_SelectImageFromDisk_ParamsSpec.$, null, [], false);
    }
    selectLastExternalUserImage() {
        this.proxy.sendMessage(7, UserProvider_SelectLastExternalUserImage_ParamsSpec.$, null, [], false);
    }
}
/**
 * An object which receives request messages for the UserProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class UserProviderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UserProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, UserProvider_SetUserImageObserver_ParamsSpec.$, null, impl.setUserImageObserver.bind(impl), false);
        this.helper_internal_.registerHandler(1, UserProvider_GetUserInfo_ParamsSpec.$, UserProvider_GetUserInfo_ResponseParamsSpec.$, impl.getUserInfo.bind(impl), false);
        this.helper_internal_.registerHandler(2, UserProvider_GetDefaultUserImages_ParamsSpec.$, UserProvider_GetDefaultUserImages_ResponseParamsSpec.$, impl.getDefaultUserImages.bind(impl), false);
        this.helper_internal_.registerHandler(3, UserProvider_SelectDefaultImage_ParamsSpec.$, null, impl.selectDefaultImage.bind(impl), false);
        this.helper_internal_.registerHandler(4, UserProvider_SelectProfileImage_ParamsSpec.$, null, impl.selectProfileImage.bind(impl), false);
        this.helper_internal_.registerHandler(5, UserProvider_SelectCameraImage_ParamsSpec.$, null, impl.selectCameraImage.bind(impl), false);
        this.helper_internal_.registerHandler(6, UserProvider_SelectImageFromDisk_ParamsSpec.$, null, impl.selectImageFromDisk.bind(impl), false);
        this.helper_internal_.registerHandler(7, UserProvider_SelectLastExternalUserImage_ParamsSpec.$, null, impl.selectLastExternalUserImage.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class UserProvider {
    static get $interfaceName() {
        return "ash.personalization_app.mojom.UserProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new UserProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the UserProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class UserProviderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(UserProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.setUserImageObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, UserProvider_SetUserImageObserver_ParamsSpec.$, null, this.setUserImageObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.getUserInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, UserProvider_GetUserInfo_ParamsSpec.$, UserProvider_GetUserInfo_ResponseParamsSpec.$, this.getUserInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.getDefaultUserImages =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, UserProvider_GetDefaultUserImages_ParamsSpec.$, UserProvider_GetDefaultUserImages_ResponseParamsSpec.$, this.getDefaultUserImages.createReceiverHandler(true /* expectsResponse */), false);
        this.selectDefaultImage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, UserProvider_SelectDefaultImage_ParamsSpec.$, null, this.selectDefaultImage.createReceiverHandler(false /* expectsResponse */), false);
        this.selectProfileImage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, UserProvider_SelectProfileImage_ParamsSpec.$, null, this.selectProfileImage.createReceiverHandler(false /* expectsResponse */), false);
        this.selectCameraImage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, UserProvider_SelectCameraImage_ParamsSpec.$, null, this.selectCameraImage.createReceiverHandler(false /* expectsResponse */), false);
        this.selectImageFromDisk =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, UserProvider_SelectImageFromDisk_ParamsSpec.$, null, this.selectImageFromDisk.createReceiverHandler(false /* expectsResponse */), false);
        this.selectLastExternalUserImage =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, UserProvider_SelectLastExternalUserImage_ParamsSpec.$, null, this.selectLastExternalUserImage.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
class AmbientObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.AmbientObserver', scope);
    }
}
class AmbientObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AmbientObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onAmbientModeEnabledChanged(ambientModeEnabled) {
        this.proxy.sendMessage(0, AmbientObserver_OnAmbientModeEnabledChanged_ParamsSpec.$, null, [
            ambientModeEnabled
        ], false);
    }
    onAmbientThemeChanged(ambientTheme) {
        this.proxy.sendMessage(1, AmbientObserver_OnAmbientThemeChanged_ParamsSpec.$, null, [
            ambientTheme
        ], false);
    }
    onTopicSourceChanged(topicSource) {
        this.proxy.sendMessage(2, AmbientObserver_OnTopicSourceChanged_ParamsSpec.$, null, [
            topicSource
        ], false);
    }
    onScreenSaverDurationChanged(minutes) {
        this.proxy.sendMessage(3, AmbientObserver_OnScreenSaverDurationChanged_ParamsSpec.$, null, [
            minutes
        ], false);
    }
    onTemperatureUnitChanged(temperatureUnit) {
        this.proxy.sendMessage(4, AmbientObserver_OnTemperatureUnitChanged_ParamsSpec.$, null, [
            temperatureUnit
        ], false);
    }
    onAlbumsChanged(albums) {
        this.proxy.sendMessage(5, AmbientObserver_OnAlbumsChanged_ParamsSpec.$, null, [
            albums
        ], false);
    }
    onPreviewsFetched(previews) {
        this.proxy.sendMessage(6, AmbientObserver_OnPreviewsFetched_ParamsSpec.$, null, [
            previews
        ], false);
    }
    onAmbientUiVisibilityChanged(visibility) {
        this.proxy.sendMessage(7, AmbientObserver_OnAmbientUiVisibilityChanged_ParamsSpec.$, null, [
            visibility
        ], false);
    }
    onGeolocationPermissionForSystemServicesChanged(enabled, isUserModifiable) {
        this.proxy.sendMessage(8, AmbientObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec.$, null, [
            enabled,
            isUserModifiable
        ], false);
    }
    onAmbientThemePreviewImagesChanged(previews) {
        this.proxy.sendMessage(9, AmbientObserver_OnAmbientThemePreviewImagesChanged_ParamsSpec.$, null, [
            previews
        ], false);
    }
}
/**
 * An object which receives request messages for the AmbientObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class AmbientObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AmbientObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AmbientObserver_OnAmbientModeEnabledChanged_ParamsSpec.$, null, impl.onAmbientModeEnabledChanged.bind(impl), false);
        this.helper_internal_.registerHandler(1, AmbientObserver_OnAmbientThemeChanged_ParamsSpec.$, null, impl.onAmbientThemeChanged.bind(impl), false);
        this.helper_internal_.registerHandler(2, AmbientObserver_OnTopicSourceChanged_ParamsSpec.$, null, impl.onTopicSourceChanged.bind(impl), false);
        this.helper_internal_.registerHandler(3, AmbientObserver_OnScreenSaverDurationChanged_ParamsSpec.$, null, impl.onScreenSaverDurationChanged.bind(impl), false);
        this.helper_internal_.registerHandler(4, AmbientObserver_OnTemperatureUnitChanged_ParamsSpec.$, null, impl.onTemperatureUnitChanged.bind(impl), false);
        this.helper_internal_.registerHandler(5, AmbientObserver_OnAlbumsChanged_ParamsSpec.$, null, impl.onAlbumsChanged.bind(impl), false);
        this.helper_internal_.registerHandler(6, AmbientObserver_OnPreviewsFetched_ParamsSpec.$, null, impl.onPreviewsFetched.bind(impl), false);
        this.helper_internal_.registerHandler(7, AmbientObserver_OnAmbientUiVisibilityChanged_ParamsSpec.$, null, impl.onAmbientUiVisibilityChanged.bind(impl), false);
        this.helper_internal_.registerHandler(8, AmbientObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec.$, null, impl.onGeolocationPermissionForSystemServicesChanged.bind(impl), false);
        this.helper_internal_.registerHandler(9, AmbientObserver_OnAmbientThemePreviewImagesChanged_ParamsSpec.$, null, impl.onAmbientThemePreviewImagesChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
/**
 * An object which receives request messages for the AmbientObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class AmbientObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AmbientObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onAmbientModeEnabledChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AmbientObserver_OnAmbientModeEnabledChanged_ParamsSpec.$, null, this.onAmbientModeEnabledChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onAmbientThemeChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, AmbientObserver_OnAmbientThemeChanged_ParamsSpec.$, null, this.onAmbientThemeChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onTopicSourceChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, AmbientObserver_OnTopicSourceChanged_ParamsSpec.$, null, this.onTopicSourceChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onScreenSaverDurationChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, AmbientObserver_OnScreenSaverDurationChanged_ParamsSpec.$, null, this.onScreenSaverDurationChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onTemperatureUnitChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, AmbientObserver_OnTemperatureUnitChanged_ParamsSpec.$, null, this.onTemperatureUnitChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onAlbumsChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, AmbientObserver_OnAlbumsChanged_ParamsSpec.$, null, this.onAlbumsChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onPreviewsFetched =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, AmbientObserver_OnPreviewsFetched_ParamsSpec.$, null, this.onPreviewsFetched.createReceiverHandler(false /* expectsResponse */), false);
        this.onAmbientUiVisibilityChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, AmbientObserver_OnAmbientUiVisibilityChanged_ParamsSpec.$, null, this.onAmbientUiVisibilityChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onGeolocationPermissionForSystemServicesChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, AmbientObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec.$, null, this.onGeolocationPermissionForSystemServicesChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onAmbientThemePreviewImagesChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, AmbientObserver_OnAmbientThemePreviewImagesChanged_ParamsSpec.$, null, this.onAmbientThemePreviewImagesChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
class AmbientProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.AmbientProvider', scope);
    }
}
class AmbientProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(AmbientProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    isAmbientModeEnabled() {
        return this.proxy.sendMessage(0, AmbientProvider_IsAmbientModeEnabled_ParamsSpec.$, AmbientProvider_IsAmbientModeEnabled_ResponseParamsSpec.$, [], false);
    }
    setAmbientModeEnabled(enabled) {
        this.proxy.sendMessage(1, AmbientProvider_SetAmbientModeEnabled_ParamsSpec.$, null, [
            enabled
        ], false);
    }
    setAmbientObserver(observer) {
        this.proxy.sendMessage(2, AmbientProvider_SetAmbientObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    setAmbientTheme(ambientTheme) {
        this.proxy.sendMessage(3, AmbientProvider_SetAmbientTheme_ParamsSpec.$, null, [
            ambientTheme
        ], false);
    }
    setScreenSaverDuration(minutes) {
        this.proxy.sendMessage(4, AmbientProvider_SetScreenSaverDuration_ParamsSpec.$, null, [
            minutes
        ], false);
    }
    setTopicSource(topicSource) {
        this.proxy.sendMessage(5, AmbientProvider_SetTopicSource_ParamsSpec.$, null, [
            topicSource
        ], false);
    }
    setTemperatureUnit(temperatureUnit) {
        this.proxy.sendMessage(6, AmbientProvider_SetTemperatureUnit_ParamsSpec.$, null, [
            temperatureUnit
        ], false);
    }
    setAlbumSelected(id, topicSource, selected) {
        this.proxy.sendMessage(7, AmbientProvider_SetAlbumSelected_ParamsSpec.$, null, [
            id,
            topicSource,
            selected
        ], false);
    }
    setPageViewed() {
        this.proxy.sendMessage(8, AmbientProvider_SetPageViewed_ParamsSpec.$, null, [], false);
    }
    fetchSettingsAndAlbums() {
        this.proxy.sendMessage(9, AmbientProvider_FetchSettingsAndAlbums_ParamsSpec.$, null, [], false);
    }
    startScreenSaverPreview() {
        this.proxy.sendMessage(10, AmbientProvider_StartScreenSaverPreview_ParamsSpec.$, null, [], false);
    }
    shouldShowTimeOfDayBanner() {
        return this.proxy.sendMessage(11, AmbientProvider_ShouldShowTimeOfDayBanner_ParamsSpec.$, AmbientProvider_ShouldShowTimeOfDayBanner_ResponseParamsSpec.$, [], false);
    }
    handleTimeOfDayBannerDismissed() {
        this.proxy.sendMessage(12, AmbientProvider_HandleTimeOfDayBannerDismissed_ParamsSpec.$, null, [], false);
    }
    isGeolocationEnabledForSystemServices() {
        return this.proxy.sendMessage(13, AmbientProvider_IsGeolocationEnabledForSystemServices_ParamsSpec.$, AmbientProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec.$, [], false);
    }
    isGeolocationUserModifiable() {
        return this.proxy.sendMessage(14, AmbientProvider_IsGeolocationUserModifiable_ParamsSpec.$, AmbientProvider_IsGeolocationUserModifiable_ResponseParamsSpec.$, [], false);
    }
    enableGeolocationForSystemServices() {
        this.proxy.sendMessage(15, AmbientProvider_EnableGeolocationForSystemServices_ParamsSpec.$, null, [], false);
    }
}
/**
 * An object which receives request messages for the AmbientProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class AmbientProviderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AmbientProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, AmbientProvider_IsAmbientModeEnabled_ParamsSpec.$, AmbientProvider_IsAmbientModeEnabled_ResponseParamsSpec.$, impl.isAmbientModeEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(1, AmbientProvider_SetAmbientModeEnabled_ParamsSpec.$, null, impl.setAmbientModeEnabled.bind(impl), false);
        this.helper_internal_.registerHandler(2, AmbientProvider_SetAmbientObserver_ParamsSpec.$, null, impl.setAmbientObserver.bind(impl), false);
        this.helper_internal_.registerHandler(3, AmbientProvider_SetAmbientTheme_ParamsSpec.$, null, impl.setAmbientTheme.bind(impl), false);
        this.helper_internal_.registerHandler(4, AmbientProvider_SetScreenSaverDuration_ParamsSpec.$, null, impl.setScreenSaverDuration.bind(impl), false);
        this.helper_internal_.registerHandler(5, AmbientProvider_SetTopicSource_ParamsSpec.$, null, impl.setTopicSource.bind(impl), false);
        this.helper_internal_.registerHandler(6, AmbientProvider_SetTemperatureUnit_ParamsSpec.$, null, impl.setTemperatureUnit.bind(impl), false);
        this.helper_internal_.registerHandler(7, AmbientProvider_SetAlbumSelected_ParamsSpec.$, null, impl.setAlbumSelected.bind(impl), false);
        this.helper_internal_.registerHandler(8, AmbientProvider_SetPageViewed_ParamsSpec.$, null, impl.setPageViewed.bind(impl), false);
        this.helper_internal_.registerHandler(9, AmbientProvider_FetchSettingsAndAlbums_ParamsSpec.$, null, impl.fetchSettingsAndAlbums.bind(impl), false);
        this.helper_internal_.registerHandler(10, AmbientProvider_StartScreenSaverPreview_ParamsSpec.$, null, impl.startScreenSaverPreview.bind(impl), false);
        this.helper_internal_.registerHandler(11, AmbientProvider_ShouldShowTimeOfDayBanner_ParamsSpec.$, AmbientProvider_ShouldShowTimeOfDayBanner_ResponseParamsSpec.$, impl.shouldShowTimeOfDayBanner.bind(impl), false);
        this.helper_internal_.registerHandler(12, AmbientProvider_HandleTimeOfDayBannerDismissed_ParamsSpec.$, null, impl.handleTimeOfDayBannerDismissed.bind(impl), false);
        this.helper_internal_.registerHandler(13, AmbientProvider_IsGeolocationEnabledForSystemServices_ParamsSpec.$, AmbientProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec.$, impl.isGeolocationEnabledForSystemServices.bind(impl), false);
        this.helper_internal_.registerHandler(14, AmbientProvider_IsGeolocationUserModifiable_ParamsSpec.$, AmbientProvider_IsGeolocationUserModifiable_ResponseParamsSpec.$, impl.isGeolocationUserModifiable.bind(impl), false);
        this.helper_internal_.registerHandler(15, AmbientProvider_EnableGeolocationForSystemServices_ParamsSpec.$, null, impl.enableGeolocationForSystemServices.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class AmbientProvider {
    static get $interfaceName() {
        return "ash.personalization_app.mojom.AmbientProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new AmbientProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the AmbientProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class AmbientProviderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(AmbientProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.isAmbientModeEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, AmbientProvider_IsAmbientModeEnabled_ParamsSpec.$, AmbientProvider_IsAmbientModeEnabled_ResponseParamsSpec.$, this.isAmbientModeEnabled.createReceiverHandler(true /* expectsResponse */), false);
        this.setAmbientModeEnabled =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, AmbientProvider_SetAmbientModeEnabled_ParamsSpec.$, null, this.setAmbientModeEnabled.createReceiverHandler(false /* expectsResponse */), false);
        this.setAmbientObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, AmbientProvider_SetAmbientObserver_ParamsSpec.$, null, this.setAmbientObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.setAmbientTheme =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, AmbientProvider_SetAmbientTheme_ParamsSpec.$, null, this.setAmbientTheme.createReceiverHandler(false /* expectsResponse */), false);
        this.setScreenSaverDuration =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, AmbientProvider_SetScreenSaverDuration_ParamsSpec.$, null, this.setScreenSaverDuration.createReceiverHandler(false /* expectsResponse */), false);
        this.setTopicSource =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, AmbientProvider_SetTopicSource_ParamsSpec.$, null, this.setTopicSource.createReceiverHandler(false /* expectsResponse */), false);
        this.setTemperatureUnit =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, AmbientProvider_SetTemperatureUnit_ParamsSpec.$, null, this.setTemperatureUnit.createReceiverHandler(false /* expectsResponse */), false);
        this.setAlbumSelected =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, AmbientProvider_SetAlbumSelected_ParamsSpec.$, null, this.setAlbumSelected.createReceiverHandler(false /* expectsResponse */), false);
        this.setPageViewed =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(8, AmbientProvider_SetPageViewed_ParamsSpec.$, null, this.setPageViewed.createReceiverHandler(false /* expectsResponse */), false);
        this.fetchSettingsAndAlbums =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(9, AmbientProvider_FetchSettingsAndAlbums_ParamsSpec.$, null, this.fetchSettingsAndAlbums.createReceiverHandler(false /* expectsResponse */), false);
        this.startScreenSaverPreview =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(10, AmbientProvider_StartScreenSaverPreview_ParamsSpec.$, null, this.startScreenSaverPreview.createReceiverHandler(false /* expectsResponse */), false);
        this.shouldShowTimeOfDayBanner =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(11, AmbientProvider_ShouldShowTimeOfDayBanner_ParamsSpec.$, AmbientProvider_ShouldShowTimeOfDayBanner_ResponseParamsSpec.$, this.shouldShowTimeOfDayBanner.createReceiverHandler(true /* expectsResponse */), false);
        this.handleTimeOfDayBannerDismissed =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(12, AmbientProvider_HandleTimeOfDayBannerDismissed_ParamsSpec.$, null, this.handleTimeOfDayBannerDismissed.createReceiverHandler(false /* expectsResponse */), false);
        this.isGeolocationEnabledForSystemServices =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(13, AmbientProvider_IsGeolocationEnabledForSystemServices_ParamsSpec.$, AmbientProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec.$, this.isGeolocationEnabledForSystemServices.createReceiverHandler(true /* expectsResponse */), false);
        this.isGeolocationUserModifiable =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(14, AmbientProvider_IsGeolocationUserModifiable_ParamsSpec.$, AmbientProvider_IsGeolocationUserModifiable_ResponseParamsSpec.$, this.isGeolocationUserModifiable.createReceiverHandler(true /* expectsResponse */), false);
        this.enableGeolocationForSystemServices =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(15, AmbientProvider_EnableGeolocationForSystemServices_ParamsSpec.$, null, this.enableGeolocationForSystemServices.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
class KeyboardBacklightObserverPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.KeyboardBacklightObserver', scope);
    }
}
class KeyboardBacklightObserverRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(KeyboardBacklightObserverPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onBacklightStateChanged(currentBacklightState) {
        this.proxy.sendMessage(0, KeyboardBacklightObserver_OnBacklightStateChanged_ParamsSpec.$, null, [
            currentBacklightState
        ], false);
    }
    onWallpaperColorChanged(wallpaperColor) {
        this.proxy.sendMessage(1, KeyboardBacklightObserver_OnWallpaperColorChanged_ParamsSpec.$, null, [
            wallpaperColor
        ], false);
    }
}
/**
 * An object which receives request messages for the KeyboardBacklightObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class KeyboardBacklightObserverReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardBacklightObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, KeyboardBacklightObserver_OnBacklightStateChanged_ParamsSpec.$, null, impl.onBacklightStateChanged.bind(impl), false);
        this.helper_internal_.registerHandler(1, KeyboardBacklightObserver_OnWallpaperColorChanged_ParamsSpec.$, null, impl.onWallpaperColorChanged.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
/**
 * An object which receives request messages for the KeyboardBacklightObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class KeyboardBacklightObserverCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardBacklightObserverRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onBacklightStateChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, KeyboardBacklightObserver_OnBacklightStateChanged_ParamsSpec.$, null, this.onBacklightStateChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onWallpaperColorChanged =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, KeyboardBacklightObserver_OnWallpaperColorChanged_ParamsSpec.$, null, this.onWallpaperColorChanged.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
class KeyboardBacklightProviderPendingReceiver {
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'ash.personalization_app.mojom.KeyboardBacklightProvider', scope);
    }
}
class KeyboardBacklightProviderRemote {
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(KeyboardBacklightProviderPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    setKeyboardBacklightObserver(observer) {
        this.proxy.sendMessage(0, KeyboardBacklightProvider_SetKeyboardBacklightObserver_ParamsSpec.$, null, [
            observer
        ], false);
    }
    setBacklightColor(backlightColor) {
        this.proxy.sendMessage(1, KeyboardBacklightProvider_SetBacklightColor_ParamsSpec.$, null, [
            backlightColor
        ], false);
    }
    setBacklightZoneColor(zone, backlightColor) {
        this.proxy.sendMessage(2, KeyboardBacklightProvider_SetBacklightZoneColor_ParamsSpec.$, null, [
            zone,
            backlightColor
        ], false);
    }
    shouldShowNudge() {
        return this.proxy.sendMessage(3, KeyboardBacklightProvider_ShouldShowNudge_ParamsSpec.$, KeyboardBacklightProvider_ShouldShowNudge_ResponseParamsSpec.$, [], false);
    }
    handleNudgeShown() {
        this.proxy.sendMessage(4, KeyboardBacklightProvider_HandleNudgeShown_ParamsSpec.$, null, [], false);
    }
}
/**
 * An object which receives request messages for the KeyboardBacklightProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
class KeyboardBacklightProviderReceiver {
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardBacklightProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, KeyboardBacklightProvider_SetKeyboardBacklightObserver_ParamsSpec.$, null, impl.setKeyboardBacklightObserver.bind(impl), false);
        this.helper_internal_.registerHandler(1, KeyboardBacklightProvider_SetBacklightColor_ParamsSpec.$, null, impl.setBacklightColor.bind(impl), false);
        this.helper_internal_.registerHandler(2, KeyboardBacklightProvider_SetBacklightZoneColor_ParamsSpec.$, null, impl.setBacklightZoneColor.bind(impl), false);
        this.helper_internal_.registerHandler(3, KeyboardBacklightProvider_ShouldShowNudge_ParamsSpec.$, KeyboardBacklightProvider_ShouldShowNudge_ResponseParamsSpec.$, impl.shouldShowNudge.bind(impl), false);
        this.helper_internal_.registerHandler(4, KeyboardBacklightProvider_HandleNudgeShown_ParamsSpec.$, null, impl.handleNudgeShown.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
class KeyboardBacklightProvider {
    static get $interfaceName() {
        return "ash.personalization_app.mojom.KeyboardBacklightProvider";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new KeyboardBacklightProviderRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the KeyboardBacklightProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
class KeyboardBacklightProviderCallbackRouter {
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(KeyboardBacklightProviderRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.setKeyboardBacklightObserver =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, KeyboardBacklightProvider_SetKeyboardBacklightObserver_ParamsSpec.$, null, this.setKeyboardBacklightObserver.createReceiverHandler(false /* expectsResponse */), false);
        this.setBacklightColor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, KeyboardBacklightProvider_SetBacklightColor_ParamsSpec.$, null, this.setBacklightColor.createReceiverHandler(false /* expectsResponse */), false);
        this.setBacklightZoneColor =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, KeyboardBacklightProvider_SetBacklightZoneColor_ParamsSpec.$, null, this.setBacklightZoneColor.createReceiverHandler(false /* expectsResponse */), false);
        this.shouldShowNudge =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, KeyboardBacklightProvider_ShouldShowNudge_ParamsSpec.$, KeyboardBacklightProvider_ShouldShowNudge_ResponseParamsSpec.$, this.shouldShowNudge.createReceiverHandler(true /* expectsResponse */), false);
        this.handleNudgeShown =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, KeyboardBacklightProvider_HandleNudgeShown_ParamsSpec.$, null, this.handleNudgeShown.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
const WallpaperCollectionSpec = { $: {} };
const GooglePhotosAlbumSpec = { $: {} };
const FetchGooglePhotosAlbumsResponseSpec = { $: {} };
const WallpaperImageSpec = { $: {} };
const GooglePhotosPhotoSpec = { $: {} };
const FetchGooglePhotosPhotosResponseSpec = { $: {} };
const CurrentAttributionSpec = { $: {} };
const CurrentWallpaperSpec = { $: {} };
const SampleColorSchemeSpec = { $: {} };
const UserInfoSpec = { $: {} };
const DeprecatedSourceInfoSpec = { $: {} };
const DefaultUserImageSpec = { $: {} };
const ProfileImageSpec = { $: {} };
const InvalidImageSpec = { $: {} };
const AmbientModeAlbumSpec = { $: {} };
const WallpaperObserver_OnWallpaperPreviewEnded_ParamsSpec = { $: {} };
const WallpaperObserver_OnAttributionChanged_ParamsSpec = { $: {} };
const WallpaperObserver_OnWallpaperChanged_ParamsSpec = { $: {} };
const WallpaperProvider_MakeTransparent_ParamsSpec = { $: {} };
const WallpaperProvider_MakeOpaque_ParamsSpec = { $: {} };
const WallpaperProvider_FetchCollections_ParamsSpec = { $: {} };
const WallpaperProvider_FetchCollections_ResponseParamsSpec = { $: {} };
const WallpaperProvider_FetchImagesForCollection_ParamsSpec = { $: {} };
const WallpaperProvider_FetchImagesForCollection_ResponseParamsSpec = { $: {} };
const WallpaperProvider_FetchGooglePhotosAlbums_ParamsSpec = { $: {} };
const WallpaperProvider_FetchGooglePhotosAlbums_ResponseParamsSpec = { $: {} };
const WallpaperProvider_FetchGooglePhotosSharedAlbums_ParamsSpec = { $: {} };
const WallpaperProvider_FetchGooglePhotosSharedAlbums_ResponseParamsSpec = { $: {} };
const WallpaperProvider_FetchGooglePhotosEnabled_ParamsSpec = { $: {} };
const WallpaperProvider_FetchGooglePhotosEnabled_ResponseParamsSpec = { $: {} };
const WallpaperProvider_FetchGooglePhotosPhotos_ParamsSpec = { $: {} };
const WallpaperProvider_FetchGooglePhotosPhotos_ResponseParamsSpec = { $: {} };
const WallpaperProvider_GetLocalImages_ParamsSpec = { $: {} };
const WallpaperProvider_GetLocalImages_ResponseParamsSpec = { $: {} };
const WallpaperProvider_GetDefaultImageThumbnail_ParamsSpec = { $: {} };
const WallpaperProvider_GetDefaultImageThumbnail_ResponseParamsSpec = { $: {} };
const WallpaperProvider_GetLocalImageThumbnail_ParamsSpec = { $: {} };
const WallpaperProvider_GetLocalImageThumbnail_ResponseParamsSpec = { $: {} };
const WallpaperProvider_SetWallpaperObserver_ParamsSpec = { $: {} };
const WallpaperProvider_SelectWallpaper_ParamsSpec = { $: {} };
const WallpaperProvider_SelectWallpaper_ResponseParamsSpec = { $: {} };
const WallpaperProvider_SelectDefaultImage_ParamsSpec = { $: {} };
const WallpaperProvider_SelectDefaultImage_ResponseParamsSpec = { $: {} };
const WallpaperProvider_SelectLocalImage_ParamsSpec = { $: {} };
const WallpaperProvider_SelectLocalImage_ResponseParamsSpec = { $: {} };
const WallpaperProvider_SelectGooglePhotosPhoto_ParamsSpec = { $: {} };
const WallpaperProvider_SelectGooglePhotosPhoto_ResponseParamsSpec = { $: {} };
const WallpaperProvider_SelectGooglePhotosAlbum_ParamsSpec = { $: {} };
const WallpaperProvider_SelectGooglePhotosAlbum_ResponseParamsSpec = { $: {} };
const WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ParamsSpec = { $: {} };
const WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ResponseParamsSpec = { $: {} };
const WallpaperProvider_SetCurrentWallpaperLayout_ParamsSpec = { $: {} };
const WallpaperProvider_SetDailyRefreshCollectionId_ParamsSpec = { $: {} };
const WallpaperProvider_SetDailyRefreshCollectionId_ResponseParamsSpec = { $: {} };
const WallpaperProvider_GetDailyRefreshCollectionId_ParamsSpec = { $: {} };
const WallpaperProvider_GetDailyRefreshCollectionId_ResponseParamsSpec = { $: {} };
const WallpaperProvider_UpdateDailyRefreshWallpaper_ParamsSpec = { $: {} };
const WallpaperProvider_UpdateDailyRefreshWallpaper_ResponseParamsSpec = { $: {} };
const WallpaperProvider_IsInTabletMode_ParamsSpec = { $: {} };
const WallpaperProvider_IsInTabletMode_ResponseParamsSpec = { $: {} };
const WallpaperProvider_ConfirmPreviewWallpaper_ParamsSpec = { $: {} };
const WallpaperProvider_CancelPreviewWallpaper_ParamsSpec = { $: {} };
const WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ParamsSpec = { $: {} };
const WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ResponseParamsSpec = { $: {} };
const ThemeObserver_OnColorModeChanged_ParamsSpec = { $: {} };
const ThemeObserver_OnColorModeAutoScheduleChanged_ParamsSpec = { $: {} };
const ThemeObserver_OnColorSchemeChanged_ParamsSpec = { $: {} };
const ThemeObserver_OnSampleColorSchemesChanged_ParamsSpec = { $: {} };
const ThemeObserver_OnStaticColorChanged_ParamsSpec = { $: {} };
const ThemeObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec = { $: {} };
const ThemeObserver_OnDaylightTimeChanged_ParamsSpec = { $: {} };
const ThemeProvider_SetThemeObserver_ParamsSpec = { $: {} };
const ThemeProvider_SetColorModePref_ParamsSpec = { $: {} };
const ThemeProvider_SetColorModeAutoScheduleEnabled_ParamsSpec = { $: {} };
const ThemeProvider_SetColorScheme_ParamsSpec = { $: {} };
const ThemeProvider_SetStaticColor_ParamsSpec = { $: {} };
const ThemeProvider_EnableGeolocationForSystemServices_ParamsSpec = { $: {} };
const ThemeProvider_GetColorScheme_ParamsSpec = { $: {} };
const ThemeProvider_GetColorScheme_ResponseParamsSpec = { $: {} };
const ThemeProvider_GetStaticColor_ParamsSpec = { $: {} };
const ThemeProvider_GetStaticColor_ResponseParamsSpec = { $: {} };
const ThemeProvider_GenerateSampleColorSchemes_ParamsSpec = { $: {} };
const ThemeProvider_GenerateSampleColorSchemes_ResponseParamsSpec = { $: {} };
const ThemeProvider_IsColorModeAutoScheduleEnabled_ParamsSpec = { $: {} };
const ThemeProvider_IsColorModeAutoScheduleEnabled_ResponseParamsSpec = { $: {} };
const ThemeProvider_IsDarkModeEnabled_ParamsSpec = { $: {} };
const ThemeProvider_IsDarkModeEnabled_ResponseParamsSpec = { $: {} };
const ThemeProvider_IsGeolocationEnabledForSystemServices_ParamsSpec = { $: {} };
const ThemeProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec = { $: {} };
const ThemeProvider_IsGeolocationUserModifiable_ParamsSpec = { $: {} };
const ThemeProvider_IsGeolocationUserModifiable_ResponseParamsSpec = { $: {} };
const UserImageObserver_OnUserImageChanged_ParamsSpec = { $: {} };
const UserImageObserver_OnUserProfileImageUpdated_ParamsSpec = { $: {} };
const UserImageObserver_OnCameraPresenceCheckDone_ParamsSpec = { $: {} };
const UserImageObserver_OnIsEnterpriseManagedChanged_ParamsSpec = { $: {} };
const UserProvider_SetUserImageObserver_ParamsSpec = { $: {} };
const UserProvider_GetUserInfo_ParamsSpec = { $: {} };
const UserProvider_GetUserInfo_ResponseParamsSpec = { $: {} };
const UserProvider_GetDefaultUserImages_ParamsSpec = { $: {} };
const UserProvider_GetDefaultUserImages_ResponseParamsSpec = { $: {} };
const UserProvider_SelectDefaultImage_ParamsSpec = { $: {} };
const UserProvider_SelectProfileImage_ParamsSpec = { $: {} };
const UserProvider_SelectCameraImage_ParamsSpec = { $: {} };
const UserProvider_SelectImageFromDisk_ParamsSpec = { $: {} };
const UserProvider_SelectLastExternalUserImage_ParamsSpec = { $: {} };
const AmbientObserver_OnAmbientModeEnabledChanged_ParamsSpec = { $: {} };
const AmbientObserver_OnAmbientThemeChanged_ParamsSpec = { $: {} };
const AmbientObserver_OnTopicSourceChanged_ParamsSpec = { $: {} };
const AmbientObserver_OnScreenSaverDurationChanged_ParamsSpec = { $: {} };
const AmbientObserver_OnTemperatureUnitChanged_ParamsSpec = { $: {} };
const AmbientObserver_OnAlbumsChanged_ParamsSpec = { $: {} };
const AmbientObserver_OnPreviewsFetched_ParamsSpec = { $: {} };
const AmbientObserver_OnAmbientUiVisibilityChanged_ParamsSpec = { $: {} };
const AmbientObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec = { $: {} };
const AmbientObserver_OnAmbientThemePreviewImagesChanged_ParamsSpec = { $: {} };
const AmbientProvider_IsAmbientModeEnabled_ParamsSpec = { $: {} };
const AmbientProvider_IsAmbientModeEnabled_ResponseParamsSpec = { $: {} };
const AmbientProvider_SetAmbientModeEnabled_ParamsSpec = { $: {} };
const AmbientProvider_SetAmbientObserver_ParamsSpec = { $: {} };
const AmbientProvider_SetAmbientTheme_ParamsSpec = { $: {} };
const AmbientProvider_SetScreenSaverDuration_ParamsSpec = { $: {} };
const AmbientProvider_SetTopicSource_ParamsSpec = { $: {} };
const AmbientProvider_SetTemperatureUnit_ParamsSpec = { $: {} };
const AmbientProvider_SetAlbumSelected_ParamsSpec = { $: {} };
const AmbientProvider_SetPageViewed_ParamsSpec = { $: {} };
const AmbientProvider_FetchSettingsAndAlbums_ParamsSpec = { $: {} };
const AmbientProvider_StartScreenSaverPreview_ParamsSpec = { $: {} };
const AmbientProvider_ShouldShowTimeOfDayBanner_ParamsSpec = { $: {} };
const AmbientProvider_ShouldShowTimeOfDayBanner_ResponseParamsSpec = { $: {} };
const AmbientProvider_HandleTimeOfDayBannerDismissed_ParamsSpec = { $: {} };
const AmbientProvider_IsGeolocationEnabledForSystemServices_ParamsSpec = { $: {} };
const AmbientProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec = { $: {} };
const AmbientProvider_IsGeolocationUserModifiable_ParamsSpec = { $: {} };
const AmbientProvider_IsGeolocationUserModifiable_ResponseParamsSpec = { $: {} };
const AmbientProvider_EnableGeolocationForSystemServices_ParamsSpec = { $: {} };
const KeyboardBacklightObserver_OnBacklightStateChanged_ParamsSpec = { $: {} };
const KeyboardBacklightObserver_OnWallpaperColorChanged_ParamsSpec = { $: {} };
const KeyboardBacklightProvider_SetKeyboardBacklightObserver_ParamsSpec = { $: {} };
const KeyboardBacklightProvider_SetBacklightColor_ParamsSpec = { $: {} };
const KeyboardBacklightProvider_SetBacklightZoneColor_ParamsSpec = { $: {} };
const KeyboardBacklightProvider_ShouldShowNudge_ParamsSpec = { $: {} };
const KeyboardBacklightProvider_ShouldShowNudge_ResponseParamsSpec = { $: {} };
const KeyboardBacklightProvider_HandleNudgeShown_ParamsSpec = { $: {} };
const UserImageSpec = { $: {} };
const CurrentBacklightStateSpec = { $: {} };
mojo.internal.Struct(WallpaperCollectionSpec.$, 'WallpaperCollection', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('descriptionContent', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('previews', 24, 0, mojo.internal.Array(UrlSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(GooglePhotosAlbumSpec.$, 'GooglePhotosAlbum', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('photoCount', 16, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('preview', 24, 0, UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('timestamp', 32, 0, TimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isShared', 20, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(FetchGooglePhotosAlbumsResponseSpec.$, 'FetchGooglePhotosAlbumsResponse', [
    mojo.internal.StructField('albums', 0, 0, mojo.internal.Array(GooglePhotosAlbumSpec.$, false), null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resumeToken', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WallpaperImageSpec.$, 'WallpaperImage', [
    mojo.internal.StructField('url', 0, 0, UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('attribution', 8, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('assetId', 16, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('unitId', 24, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('type', 32, 0, OnlineImageTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(GooglePhotosPhotoSpec.$, 'GooglePhotosPhoto', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('dedupKey', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('date', 24, 0, String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 32, 0, UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('location', 40, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(FetchGooglePhotosPhotosResponseSpec.$, 'FetchGooglePhotosPhotosResponse', [
    mojo.internal.StructField('photos', 0, 0, mojo.internal.Array(GooglePhotosPhotoSpec.$, false), null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resumeToken', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CurrentAttributionSpec.$, 'CurrentAttribution', [
    mojo.internal.StructField('attribution', 0, 0, mojo.internal.Array(mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('key', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(CurrentWallpaperSpec.$, 'CurrentWallpaper', [
    mojo.internal.StructField('layout', 0, 0, WallpaperLayoutSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('type', 4, 0, WallpaperTypeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('key', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('descriptionTitle', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('descriptionContent', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('actionUrl', 32, 0, UrlSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 48],]);
mojo.internal.Struct(SampleColorSchemeSpec.$, 'SampleColorScheme', [
    mojo.internal.StructField('scheme', 0, 0, ColorSchemeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('primary', 8, 0, SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('secondary', 16, 0, SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('tertiary', 24, 0, SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(UserInfoSpec.$, 'UserInfo', [
    mojo.internal.StructField('email', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(DeprecatedSourceInfoSpec.$, 'DeprecatedSourceInfo', [
    mojo.internal.StructField('author', 0, 0, String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('website', 8, 0, UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(DefaultUserImageSpec.$, 'DefaultUserImage', [
    mojo.internal.StructField('index', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 8, 0, String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 16, 0, UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sourceInfo', 24, 0, DeprecatedSourceInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
mojo.internal.Struct(ProfileImageSpec.$, 'ProfileImage', [], [[0, 8],]);
mojo.internal.Struct(InvalidImageSpec.$, 'InvalidImage', [], [[0, 8],]);
mojo.internal.Struct(AmbientModeAlbumSpec.$, 'AmbientModeAlbum', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('checked', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('title', 16, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('description', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('numberOfPhotos', 12, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('topicSource', 32, 0, TopicSourceSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('url', 40, 0, UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(WallpaperObserver_OnWallpaperPreviewEnded_ParamsSpec.$, 'WallpaperObserver_OnWallpaperPreviewEnded_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperObserver_OnAttributionChanged_ParamsSpec.$, 'WallpaperObserver_OnAttributionChanged_Params', [
    mojo.internal.StructField('attribution', 0, 0, CurrentAttributionSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperObserver_OnWallpaperChanged_ParamsSpec.$, 'WallpaperObserver_OnWallpaperChanged_Params', [
    mojo.internal.StructField('image', 0, 0, CurrentWallpaperSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_MakeTransparent_ParamsSpec.$, 'WallpaperProvider_MakeTransparent_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_MakeOpaque_ParamsSpec.$, 'WallpaperProvider_MakeOpaque_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_FetchCollections_ParamsSpec.$, 'WallpaperProvider_FetchCollections_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_FetchCollections_ResponseParamsSpec.$, 'WallpaperProvider_FetchCollections_ResponseParams', [
    mojo.internal.StructField('collections', 0, 0, mojo.internal.Array(WallpaperCollectionSpec.$, false), null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_FetchImagesForCollection_ParamsSpec.$, 'WallpaperProvider_FetchImagesForCollection_Params', [
    mojo.internal.StructField('collectionId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_FetchImagesForCollection_ResponseParamsSpec.$, 'WallpaperProvider_FetchImagesForCollection_ResponseParams', [
    mojo.internal.StructField('images', 0, 0, mojo.internal.Array(WallpaperImageSpec.$, false), null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_FetchGooglePhotosAlbums_ParamsSpec.$, 'WallpaperProvider_FetchGooglePhotosAlbums_Params', [
    mojo.internal.StructField('resumeToken', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_FetchGooglePhotosAlbums_ResponseParamsSpec.$, 'WallpaperProvider_FetchGooglePhotosAlbums_ResponseParams', [
    mojo.internal.StructField('response', 0, 0, FetchGooglePhotosAlbumsResponseSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_FetchGooglePhotosSharedAlbums_ParamsSpec.$, 'WallpaperProvider_FetchGooglePhotosSharedAlbums_Params', [
    mojo.internal.StructField('resumeToken', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_FetchGooglePhotosSharedAlbums_ResponseParamsSpec.$, 'WallpaperProvider_FetchGooglePhotosSharedAlbums_ResponseParams', [
    mojo.internal.StructField('response', 0, 0, FetchGooglePhotosAlbumsResponseSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_FetchGooglePhotosEnabled_ParamsSpec.$, 'WallpaperProvider_FetchGooglePhotosEnabled_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_FetchGooglePhotosEnabled_ResponseParamsSpec.$, 'WallpaperProvider_FetchGooglePhotosEnabled_ResponseParams', [
    mojo.internal.StructField('state', 0, 0, GooglePhotosEnablementStateSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_FetchGooglePhotosPhotos_ParamsSpec.$, 'WallpaperProvider_FetchGooglePhotosPhotos_Params', [
    mojo.internal.StructField('itemId', 0, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('albumId', 8, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('resumeToken', 16, 0, mojo.internal.String, null, true /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(WallpaperProvider_FetchGooglePhotosPhotos_ResponseParamsSpec.$, 'WallpaperProvider_FetchGooglePhotosPhotos_ResponseParams', [
    mojo.internal.StructField('response', 0, 0, FetchGooglePhotosPhotosResponseSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_GetLocalImages_ParamsSpec.$, 'WallpaperProvider_GetLocalImages_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_GetLocalImages_ResponseParamsSpec.$, 'WallpaperProvider_GetLocalImages_ResponseParams', [
    mojo.internal.StructField('images', 0, 0, mojo.internal.Array(FilePathSpec.$, false), null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_GetDefaultImageThumbnail_ParamsSpec.$, 'WallpaperProvider_GetDefaultImageThumbnail_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_GetDefaultImageThumbnail_ResponseParamsSpec.$, 'WallpaperProvider_GetDefaultImageThumbnail_ResponseParams', [
    mojo.internal.StructField('data', 0, 0, UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_GetLocalImageThumbnail_ParamsSpec.$, 'WallpaperProvider_GetLocalImageThumbnail_Params', [
    mojo.internal.StructField('filePath', 0, 0, FilePathSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_GetLocalImageThumbnail_ResponseParamsSpec.$, 'WallpaperProvider_GetLocalImageThumbnail_ResponseParams', [
    mojo.internal.StructField('data', 0, 0, UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SetWallpaperObserver_ParamsSpec.$, 'WallpaperProvider_SetWallpaperObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(WallpaperObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SelectWallpaper_ParamsSpec.$, 'WallpaperProvider_SelectWallpaper_Params', [
    mojo.internal.StructField('unitId', 0, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('previewMode', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WallpaperProvider_SelectWallpaper_ResponseParamsSpec.$, 'WallpaperProvider_SelectWallpaper_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SelectDefaultImage_ParamsSpec.$, 'WallpaperProvider_SelectDefaultImage_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_SelectDefaultImage_ResponseParamsSpec.$, 'WallpaperProvider_SelectDefaultImage_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SelectLocalImage_ParamsSpec.$, 'WallpaperProvider_SelectLocalImage_Params', [
    mojo.internal.StructField('path', 0, 0, FilePathSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('layout', 8, 0, WallpaperLayoutSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('previewMode', 12, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WallpaperProvider_SelectLocalImage_ResponseParamsSpec.$, 'WallpaperProvider_SelectLocalImage_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SelectGooglePhotosPhoto_ParamsSpec.$, 'WallpaperProvider_SelectGooglePhotosPhoto_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('layout', 8, 0, WallpaperLayoutSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('previewMode', 12, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(WallpaperProvider_SelectGooglePhotosPhoto_ResponseParamsSpec.$, 'WallpaperProvider_SelectGooglePhotosPhoto_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SelectGooglePhotosAlbum_ParamsSpec.$, 'WallpaperProvider_SelectGooglePhotosAlbum_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SelectGooglePhotosAlbum_ResponseParamsSpec.$, 'WallpaperProvider_SelectGooglePhotosAlbum_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ParamsSpec.$, 'WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ResponseParamsSpec.$, 'WallpaperProvider_GetGooglePhotosDailyRefreshAlbumId_ResponseParams', [
    mojo.internal.StructField('albumId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SetCurrentWallpaperLayout_ParamsSpec.$, 'WallpaperProvider_SetCurrentWallpaperLayout_Params', [
    mojo.internal.StructField('layout', 0, 0, WallpaperLayoutSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SetDailyRefreshCollectionId_ParamsSpec.$, 'WallpaperProvider_SetDailyRefreshCollectionId_Params', [
    mojo.internal.StructField('collectionId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_SetDailyRefreshCollectionId_ResponseParamsSpec.$, 'WallpaperProvider_SetDailyRefreshCollectionId_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_GetDailyRefreshCollectionId_ParamsSpec.$, 'WallpaperProvider_GetDailyRefreshCollectionId_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_GetDailyRefreshCollectionId_ResponseParamsSpec.$, 'WallpaperProvider_GetDailyRefreshCollectionId_ResponseParams', [
    mojo.internal.StructField('collectionId', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_UpdateDailyRefreshWallpaper_ParamsSpec.$, 'WallpaperProvider_UpdateDailyRefreshWallpaper_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_UpdateDailyRefreshWallpaper_ResponseParamsSpec.$, 'WallpaperProvider_UpdateDailyRefreshWallpaper_ResponseParams', [
    mojo.internal.StructField('success', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_IsInTabletMode_ParamsSpec.$, 'WallpaperProvider_IsInTabletMode_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_IsInTabletMode_ResponseParamsSpec.$, 'WallpaperProvider_IsInTabletMode_ResponseParams', [
    mojo.internal.StructField('tabletMode', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(WallpaperProvider_ConfirmPreviewWallpaper_ParamsSpec.$, 'WallpaperProvider_ConfirmPreviewWallpaper_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_CancelPreviewWallpaper_ParamsSpec.$, 'WallpaperProvider_CancelPreviewWallpaper_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ParamsSpec.$, 'WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_Params', [], [[0, 8],]);
mojo.internal.Struct(WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ResponseParamsSpec.$, 'WallpaperProvider_ShouldShowTimeOfDayWallpaperDialog_ResponseParams', [
    mojo.internal.StructField('shouldShowDialog', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeObserver_OnColorModeChanged_ParamsSpec.$, 'ThemeObserver_OnColorModeChanged_Params', [
    mojo.internal.StructField('darkModeEnabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeObserver_OnColorModeAutoScheduleChanged_ParamsSpec.$, 'ThemeObserver_OnColorModeAutoScheduleChanged_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeObserver_OnColorSchemeChanged_ParamsSpec.$, 'ThemeObserver_OnColorSchemeChanged_Params', [
    mojo.internal.StructField('colorScheme', 0, 0, ColorSchemeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeObserver_OnSampleColorSchemesChanged_ParamsSpec.$, 'ThemeObserver_OnSampleColorSchemesChanged_Params', [
    mojo.internal.StructField('sampleColorSchemes', 0, 0, mojo.internal.Array(SampleColorSchemeSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeObserver_OnStaticColorChanged_ParamsSpec.$, 'ThemeObserver_OnStaticColorChanged_Params', [
    mojo.internal.StructField('color', 0, 0, SkColorSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec.$, 'ThemeObserver_OnGeolocationPermissionForSystemServicesChanged_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isUserModifiable', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeObserver_OnDaylightTimeChanged_ParamsSpec.$, 'ThemeObserver_OnDaylightTimeChanged_Params', [
    mojo.internal.StructField('sunriseTime', 0, 0, String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sunsetTime', 8, 0, String16Spec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(ThemeProvider_SetThemeObserver_ParamsSpec.$, 'ThemeProvider_SetThemeObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(ThemeObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_SetColorModePref_ParamsSpec.$, 'ThemeProvider_SetColorModePref_Params', [
    mojo.internal.StructField('darkModeEnabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_SetColorModeAutoScheduleEnabled_ParamsSpec.$, 'ThemeProvider_SetColorModeAutoScheduleEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_SetColorScheme_ParamsSpec.$, 'ThemeProvider_SetColorScheme_Params', [
    mojo.internal.StructField('colorScheme', 0, 0, ColorSchemeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_SetStaticColor_ParamsSpec.$, 'ThemeProvider_SetStaticColor_Params', [
    mojo.internal.StructField('staticColor', 0, 0, SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_EnableGeolocationForSystemServices_ParamsSpec.$, 'ThemeProvider_EnableGeolocationForSystemServices_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeProvider_GetColorScheme_ParamsSpec.$, 'ThemeProvider_GetColorScheme_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeProvider_GetColorScheme_ResponseParamsSpec.$, 'ThemeProvider_GetColorScheme_ResponseParams', [
    mojo.internal.StructField('colorScheme', 0, 0, ColorSchemeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_GetStaticColor_ParamsSpec.$, 'ThemeProvider_GetStaticColor_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeProvider_GetStaticColor_ResponseParamsSpec.$, 'ThemeProvider_GetStaticColor_ResponseParams', [
    mojo.internal.StructField('staticColor', 0, 0, SkColorSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_GenerateSampleColorSchemes_ParamsSpec.$, 'ThemeProvider_GenerateSampleColorSchemes_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeProvider_GenerateSampleColorSchemes_ResponseParamsSpec.$, 'ThemeProvider_GenerateSampleColorSchemes_ResponseParams', [
    mojo.internal.StructField('sampleColorSchemes', 0, 0, mojo.internal.Array(SampleColorSchemeSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_IsColorModeAutoScheduleEnabled_ParamsSpec.$, 'ThemeProvider_IsColorModeAutoScheduleEnabled_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeProvider_IsColorModeAutoScheduleEnabled_ResponseParamsSpec.$, 'ThemeProvider_IsColorModeAutoScheduleEnabled_ResponseParams', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_IsDarkModeEnabled_ParamsSpec.$, 'ThemeProvider_IsDarkModeEnabled_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeProvider_IsDarkModeEnabled_ResponseParamsSpec.$, 'ThemeProvider_IsDarkModeEnabled_ResponseParams', [
    mojo.internal.StructField('darkModeEnabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_IsGeolocationEnabledForSystemServices_ParamsSpec.$, 'ThemeProvider_IsGeolocationEnabledForSystemServices_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec.$, 'ThemeProvider_IsGeolocationEnabledForSystemServices_ResponseParams', [
    mojo.internal.StructField('geolocationEnabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(ThemeProvider_IsGeolocationUserModifiable_ParamsSpec.$, 'ThemeProvider_IsGeolocationUserModifiable_Params', [], [[0, 8],]);
mojo.internal.Struct(ThemeProvider_IsGeolocationUserModifiable_ResponseParamsSpec.$, 'ThemeProvider_IsGeolocationUserModifiable_ResponseParams', [
    mojo.internal.StructField('geolocationIsUserModifiable', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(UserImageObserver_OnUserImageChanged_ParamsSpec.$, 'UserImageObserver_OnUserImageChanged_Params', [
    mojo.internal.StructField('userImage', 0, 0, UserImageSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(UserImageObserver_OnUserProfileImageUpdated_ParamsSpec.$, 'UserImageObserver_OnUserProfileImageUpdated_Params', [
    mojo.internal.StructField('profileImage', 0, 0, UrlSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(UserImageObserver_OnCameraPresenceCheckDone_ParamsSpec.$, 'UserImageObserver_OnCameraPresenceCheckDone_Params', [
    mojo.internal.StructField('isCameraPresent', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(UserImageObserver_OnIsEnterpriseManagedChanged_ParamsSpec.$, 'UserImageObserver_OnIsEnterpriseManagedChanged_Params', [
    mojo.internal.StructField('isEnterpriseManaged', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(UserProvider_SetUserImageObserver_ParamsSpec.$, 'UserProvider_SetUserImageObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(UserImageObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(UserProvider_GetUserInfo_ParamsSpec.$, 'UserProvider_GetUserInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(UserProvider_GetUserInfo_ResponseParamsSpec.$, 'UserProvider_GetUserInfo_ResponseParams', [
    mojo.internal.StructField('userInfo', 0, 0, UserInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(UserProvider_GetDefaultUserImages_ParamsSpec.$, 'UserProvider_GetDefaultUserImages_Params', [], [[0, 8],]);
mojo.internal.Struct(UserProvider_GetDefaultUserImages_ResponseParamsSpec.$, 'UserProvider_GetDefaultUserImages_ResponseParams', [
    mojo.internal.StructField('defaultUserImages', 0, 0, mojo.internal.Array(DefaultUserImageSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(UserProvider_SelectDefaultImage_ParamsSpec.$, 'UserProvider_SelectDefaultImage_Params', [
    mojo.internal.StructField('index', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(UserProvider_SelectProfileImage_ParamsSpec.$, 'UserProvider_SelectProfileImage_Params', [], [[0, 8],]);
mojo.internal.Struct(UserProvider_SelectCameraImage_ParamsSpec.$, 'UserProvider_SelectCameraImage_Params', [
    mojo.internal.StructField('data', 0, 0, BigBufferSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(UserProvider_SelectImageFromDisk_ParamsSpec.$, 'UserProvider_SelectImageFromDisk_Params', [], [[0, 8],]);
mojo.internal.Struct(UserProvider_SelectLastExternalUserImage_ParamsSpec.$, 'UserProvider_SelectLastExternalUserImage_Params', [], [[0, 8],]);
mojo.internal.Struct(AmbientObserver_OnAmbientModeEnabledChanged_ParamsSpec.$, 'AmbientObserver_OnAmbientModeEnabledChanged_Params', [
    mojo.internal.StructField('ambientModeEnabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientObserver_OnAmbientThemeChanged_ParamsSpec.$, 'AmbientObserver_OnAmbientThemeChanged_Params', [
    mojo.internal.StructField('ambientTheme', 0, 0, AmbientThemeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientObserver_OnTopicSourceChanged_ParamsSpec.$, 'AmbientObserver_OnTopicSourceChanged_Params', [
    mojo.internal.StructField('topicSource', 0, 0, TopicSourceSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientObserver_OnScreenSaverDurationChanged_ParamsSpec.$, 'AmbientObserver_OnScreenSaverDurationChanged_Params', [
    mojo.internal.StructField('minutes', 0, 0, mojo.internal.Uint32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientObserver_OnTemperatureUnitChanged_ParamsSpec.$, 'AmbientObserver_OnTemperatureUnitChanged_Params', [
    mojo.internal.StructField('temperatureUnit', 0, 0, TemperatureUnitSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientObserver_OnAlbumsChanged_ParamsSpec.$, 'AmbientObserver_OnAlbumsChanged_Params', [
    mojo.internal.StructField('albums', 0, 0, mojo.internal.Array(AmbientModeAlbumSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientObserver_OnPreviewsFetched_ParamsSpec.$, 'AmbientObserver_OnPreviewsFetched_Params', [
    mojo.internal.StructField('previews', 0, 0, mojo.internal.Array(UrlSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientObserver_OnAmbientUiVisibilityChanged_ParamsSpec.$, 'AmbientObserver_OnAmbientUiVisibilityChanged_Params', [
    mojo.internal.StructField('visibility', 0, 0, AmbientUiVisibilitySpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientObserver_OnGeolocationPermissionForSystemServicesChanged_ParamsSpec.$, 'AmbientObserver_OnGeolocationPermissionForSystemServicesChanged_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isUserModifiable', 0, 1, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientObserver_OnAmbientThemePreviewImagesChanged_ParamsSpec.$, 'AmbientObserver_OnAmbientThemePreviewImagesChanged_Params', [
    mojo.internal.StructField('previews', 0, 0, mojo.internal.Map(AmbientThemeSpec.$, UrlSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_IsAmbientModeEnabled_ParamsSpec.$, 'AmbientProvider_IsAmbientModeEnabled_Params', [], [[0, 8],]);
mojo.internal.Struct(AmbientProvider_IsAmbientModeEnabled_ResponseParamsSpec.$, 'AmbientProvider_IsAmbientModeEnabled_ResponseParams', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_SetAmbientModeEnabled_ParamsSpec.$, 'AmbientProvider_SetAmbientModeEnabled_Params', [
    mojo.internal.StructField('enabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_SetAmbientObserver_ParamsSpec.$, 'AmbientProvider_SetAmbientObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(AmbientObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_SetAmbientTheme_ParamsSpec.$, 'AmbientProvider_SetAmbientTheme_Params', [
    mojo.internal.StructField('ambientTheme', 0, 0, AmbientThemeSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_SetScreenSaverDuration_ParamsSpec.$, 'AmbientProvider_SetScreenSaverDuration_Params', [
    mojo.internal.StructField('minutes', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_SetTopicSource_ParamsSpec.$, 'AmbientProvider_SetTopicSource_Params', [
    mojo.internal.StructField('topicSource', 0, 0, TopicSourceSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_SetTemperatureUnit_ParamsSpec.$, 'AmbientProvider_SetTemperatureUnit_Params', [
    mojo.internal.StructField('temperatureUnit', 0, 0, TemperatureUnitSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_SetAlbumSelected_ParamsSpec.$, 'AmbientProvider_SetAlbumSelected_Params', [
    mojo.internal.StructField('id', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('topicSource', 8, 0, TopicSourceSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('selected', 12, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(AmbientProvider_SetPageViewed_ParamsSpec.$, 'AmbientProvider_SetPageViewed_Params', [], [[0, 8],]);
mojo.internal.Struct(AmbientProvider_FetchSettingsAndAlbums_ParamsSpec.$, 'AmbientProvider_FetchSettingsAndAlbums_Params', [], [[0, 8],]);
mojo.internal.Struct(AmbientProvider_StartScreenSaverPreview_ParamsSpec.$, 'AmbientProvider_StartScreenSaverPreview_Params', [], [[0, 8],]);
mojo.internal.Struct(AmbientProvider_ShouldShowTimeOfDayBanner_ParamsSpec.$, 'AmbientProvider_ShouldShowTimeOfDayBanner_Params', [], [[0, 8],]);
mojo.internal.Struct(AmbientProvider_ShouldShowTimeOfDayBanner_ResponseParamsSpec.$, 'AmbientProvider_ShouldShowTimeOfDayBanner_ResponseParams', [
    mojo.internal.StructField('shouldShowBanner', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_HandleTimeOfDayBannerDismissed_ParamsSpec.$, 'AmbientProvider_HandleTimeOfDayBannerDismissed_Params', [], [[0, 8],]);
mojo.internal.Struct(AmbientProvider_IsGeolocationEnabledForSystemServices_ParamsSpec.$, 'AmbientProvider_IsGeolocationEnabledForSystemServices_Params', [], [[0, 8],]);
mojo.internal.Struct(AmbientProvider_IsGeolocationEnabledForSystemServices_ResponseParamsSpec.$, 'AmbientProvider_IsGeolocationEnabledForSystemServices_ResponseParams', [
    mojo.internal.StructField('geolocationEnabled', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_IsGeolocationUserModifiable_ParamsSpec.$, 'AmbientProvider_IsGeolocationUserModifiable_Params', [], [[0, 8],]);
mojo.internal.Struct(AmbientProvider_IsGeolocationUserModifiable_ResponseParamsSpec.$, 'AmbientProvider_IsGeolocationUserModifiable_ResponseParams', [
    mojo.internal.StructField('geolocationIsUserModifiable', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(AmbientProvider_EnableGeolocationForSystemServices_ParamsSpec.$, 'AmbientProvider_EnableGeolocationForSystemServices_Params', [], [[0, 8],]);
mojo.internal.Struct(KeyboardBacklightObserver_OnBacklightStateChanged_ParamsSpec.$, 'KeyboardBacklightObserver_OnBacklightStateChanged_Params', [
    mojo.internal.StructField('currentBacklightState', 0, 0, CurrentBacklightStateSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(KeyboardBacklightObserver_OnWallpaperColorChanged_ParamsSpec.$, 'KeyboardBacklightObserver_OnWallpaperColorChanged_Params', [
    mojo.internal.StructField('wallpaperColor', 0, 0, SkColorSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(KeyboardBacklightProvider_SetKeyboardBacklightObserver_ParamsSpec.$, 'KeyboardBacklightProvider_SetKeyboardBacklightObserver_Params', [
    mojo.internal.StructField('observer', 0, 0, mojo.internal.InterfaceProxy(KeyboardBacklightObserverRemote), null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(KeyboardBacklightProvider_SetBacklightColor_ParamsSpec.$, 'KeyboardBacklightProvider_SetBacklightColor_Params', [
    mojo.internal.StructField('backlightColor', 0, 0, BacklightColorSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(KeyboardBacklightProvider_SetBacklightZoneColor_ParamsSpec.$, 'KeyboardBacklightProvider_SetBacklightZoneColor_Params', [
    mojo.internal.StructField('zone', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('backlightColor', 4, 0, BacklightColorSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(KeyboardBacklightProvider_ShouldShowNudge_ParamsSpec.$, 'KeyboardBacklightProvider_ShouldShowNudge_Params', [], [[0, 8],]);
mojo.internal.Struct(KeyboardBacklightProvider_ShouldShowNudge_ResponseParamsSpec.$, 'KeyboardBacklightProvider_ShouldShowNudge_ResponseParams', [
    mojo.internal.StructField('shouldShowNudge', 0, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(KeyboardBacklightProvider_HandleNudgeShown_ParamsSpec.$, 'KeyboardBacklightProvider_HandleNudgeShown_Params', [], [[0, 8],]);
mojo.internal.Union(UserImageSpec.$, 'UserImage', {
    'defaultImage': {
        'ordinal': 0,
        'type': DefaultUserImageSpec.$,
    },
    'externalImage': {
        'ordinal': 1,
        'type': BigBufferSpec.$,
    },
    'profileImage': {
        'ordinal': 2,
        'type': ProfileImageSpec.$,
    },
    'invalidImage': {
        'ordinal': 3,
        'type': InvalidImageSpec.$,
    },
});
var UserImageFieldTags;
(function (UserImageFieldTags) {
    UserImageFieldTags[UserImageFieldTags["DEFAULT_IMAGE"] = 0] = "DEFAULT_IMAGE";
    UserImageFieldTags[UserImageFieldTags["EXTERNAL_IMAGE"] = 1] = "EXTERNAL_IMAGE";
    UserImageFieldTags[UserImageFieldTags["PROFILE_IMAGE"] = 2] = "PROFILE_IMAGE";
    UserImageFieldTags[UserImageFieldTags["INVALID_IMAGE"] = 3] = "INVALID_IMAGE";
})(UserImageFieldTags || (UserImageFieldTags = {}));
function whichUserImage(u) {
    if (u.defaultImage !== null && u.defaultImage !== undefined) {
        return UserImageFieldTags.DEFAULT_IMAGE;
    }
    if (u.externalImage !== null && u.externalImage !== undefined) {
        return UserImageFieldTags.EXTERNAL_IMAGE;
    }
    if (u.profileImage !== null && u.profileImage !== undefined) {
        return UserImageFieldTags.PROFILE_IMAGE;
    }
    if (u.invalidImage !== null && u.invalidImage !== undefined) {
        return UserImageFieldTags.INVALID_IMAGE;
    }
    throw new Error("no union field has been set, this is an illegal state");
}
mojo.internal.Union(CurrentBacklightStateSpec.$, 'CurrentBacklightState', {
    'color': {
        'ordinal': 0,
        'type': BacklightColorSpec.$,
    },
    'zoneColors': {
        'ordinal': 1,
        'type': mojo.internal.Array(BacklightColorSpec.$, false),
    },
});
var CurrentBacklightStateFieldTags;
(function (CurrentBacklightStateFieldTags) {
    CurrentBacklightStateFieldTags[CurrentBacklightStateFieldTags["COLOR"] = 0] = "COLOR";
    CurrentBacklightStateFieldTags[CurrentBacklightStateFieldTags["ZONE_COLORS"] = 1] = "ZONE_COLORS";
})(CurrentBacklightStateFieldTags || (CurrentBacklightStateFieldTags = {}));
function whichCurrentBacklightState(u) {
    if (u.color !== null && u.color !== undefined) {
        return CurrentBacklightStateFieldTags.COLOR;
    }
    if (u.zoneColors !== null && u.zoneColors !== undefined) {
        return CurrentBacklightStateFieldTags.ZONE_COLORS;
    }
    throw new Error("no union field has been set, this is an illegal state");
}

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Make a string safe for Polymer bindings that are inner-h-t-m-l or other
 * innerHTML use.
 * @param rawString The unsanitized string
 * @param opts Optional additional allowed tags and attributes.
 */
function sanitizeInnerHtmlInternal(rawString, opts) {
    opts = opts || {};
    const html = parseHtmlSubset(`<b>${rawString}</b>`, opts.tags, opts.attrs)
        .firstElementChild;
    return html.innerHTML;
}
// 
let sanitizedPolicy = null;
/**
 * Same as |sanitizeInnerHtmlInternal|, but it passes through sanitizedPolicy
 * to create a TrustedHTML.
 */
function sanitizeInnerHtml(rawString, opts) {
    assert$1(window.trustedTypes);
    if (sanitizedPolicy === null) {
        // Initialize |sanitizedPolicy| lazily.
        sanitizedPolicy = window.trustedTypes.createPolicy('sanitize-inner-html', {
            createHTML: sanitizeInnerHtmlInternal,
            createScript: () => assertNotReached(),
            createScriptURL: () => assertNotReached(),
        });
    }
    return sanitizedPolicy.createHTML(rawString, opts);
}
const allowAttribute = (_node, _value) => true;
/** Allow-list of attributes in parseHtmlSubset. */
const allowedAttributes = new Map([
    [
        'href',
        (node, value) => {
            // Only allow a[href] starting with chrome:// or https:// or equaling
            // to #.
            return node.tagName === 'A' &&
                (value.startsWith('chrome://') || value.startsWith('https://') ||
                    value === '#');
        },
    ],
    [
        'target',
        (node, value) => {
            // Only allow a[target='_blank'].
            // TODO(dbeam): are there valid use cases for target !== '_blank'?
            return node.tagName === 'A' && value === '_blank';
        },
    ],
]);
/** Allow-list of optional attributes in parseHtmlSubset. */
const allowedOptionalAttributes = new Map([
    ['class', allowAttribute],
    ['id', allowAttribute],
    ['is', (_node, value) => value === 'action-link' || value === ''],
    ['role', (_node, value) => value === 'link'],
    [
        'src',
        (node, value) => {
            // Only allow img[src] starting with chrome://
            return node.tagName === 'IMG' &&
                value.startsWith('chrome://');
        },
    ],
    ['tabindex', allowAttribute],
    ['aria-description', allowAttribute],
    ['aria-hidden', allowAttribute],
    ['aria-label', allowAttribute],
    ['aria-labelledby', allowAttribute],
]);
/** Allow-list of tag names in parseHtmlSubset. */
const allowedTags = new Set(['A', 'B', 'I', 'BR', 'DIV', 'EM', 'KBD', 'P', 'PRE', 'SPAN', 'STRONG']);
/** Allow-list of optional tag names in parseHtmlSubset. */
const allowedOptionalTags = new Set(['IMG', 'LI', 'UL']);
/**
 * This policy maps a given string to a `TrustedHTML` object
 * without performing any validation. Callsites must ensure
 * that the resulting object will only be used in inert
 * documents. Initialized lazily.
 */
let unsanitizedPolicy;
/**
 * @param optTags an Array to merge.
 * @return Set of allowed tags.
 */
function mergeTags(optTags) {
    const clone = new Set(allowedTags);
    optTags.forEach(str => {
        const tag = str.toUpperCase();
        if (allowedOptionalTags.has(tag)) {
            clone.add(tag);
        }
    });
    return clone;
}
/**
 * @param optAttrs an Array to merge.
 * @return Map of allowed attributes.
 */
function mergeAttrs(optAttrs) {
    const clone = new Map(allowedAttributes);
    optAttrs.forEach(key => {
        if (allowedOptionalAttributes.has(key)) {
            clone.set(key, allowedOptionalAttributes.get(key));
        }
    });
    return clone;
}
function walk(n, f) {
    f(n);
    for (let i = 0; i < n.childNodes.length; i++) {
        walk(n.childNodes[i], f);
    }
}
function assertElement(tags, node) {
    if (!tags.has(node.tagName)) {
        throw Error(node.tagName + ' is not supported');
    }
}
function assertAttribute(attrs, attrNode, node) {
    const n = attrNode.nodeName;
    const v = attrNode.nodeValue || '';
    if (!attrs.has(n) || !attrs.get(n)(node, v)) {
        throw Error(node.tagName + '[' + n + '="' + v +
            '"] is not supported');
    }
}
/**
 * Parses a very small subset of HTML. This ensures that insecure HTML /
 * javascript cannot be injected into WebUI.
 * @param s The string to parse.
 * @param extraTags Optional extra allowed tags.
 * @param extraAttrs
 *     Optional extra allowed attributes (all tags are run through these).
 * @throws an Error in case of non supported markup.
 * @return A document fragment containing the DOM tree.
 */
function parseHtmlSubset(s, extraTags, extraAttrs) {
    const tags = extraTags ? mergeTags(extraTags) : allowedTags;
    const attrs = extraAttrs ? mergeAttrs(extraAttrs) : allowedAttributes;
    const doc = document.implementation.createHTMLDocument('');
    const r = doc.createRange();
    r.selectNode(doc.body);
    if (window.trustedTypes) {
        if (!unsanitizedPolicy) {
            unsanitizedPolicy =
                window.trustedTypes.createPolicy('parse-html-subset', {
                    createHTML: (untrustedHTML) => untrustedHTML,
                    createScript: () => assertNotReached(),
                    createScriptURL: () => assertNotReached(),
                });
        }
        s = unsanitizedPolicy.createHTML(s);
    }
    // This does not execute any scripts because the document has no view.
    const df = r.createContextualFragment(s);
    walk(df, function (node) {
        switch (node.nodeType) {
            case Node.ELEMENT_NODE:
                assertElement(tags, node);
                const nodeAttrs = node.attributes;
                for (let i = 0; i < nodeAttrs.length; ++i) {
                    assertAttribute(attrs, nodeAttrs[i], node);
                }
                break;
            case Node.COMMENT_NODE:
            case Node.DOCUMENT_FRAGMENT_NODE:
            case Node.TEXT_NODE:
                break;
            default:
                throw Error('Node type ' + node.nodeType + ' is not supported');
        }
    });
    return df;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'I18nMixin' is a Mixin offering loading of internationalization
 * strings. Typically it is used as [[i18n('someString')]] computed bindings or
 * for this.i18n('foo'). It is not needed for HTML $i18n{otherString}, which is
 * handled by a C++ templatizer.
 *
 * Forked from ui/webui/resources/cr_elements/i18n_mixin.ts
 */
const I18nMixin = dedupingMixin((superClass) => {
    class I18nMixin extends superClass {
        /**
         * Returns a translated string where $1 to $9 are replaced by the given
         * values.
         * @param id The ID of the string to translate.
         * @param varArgs Values to replace the placeholders $1 to $9 in the
         *     string.
         * @return A translated, substituted string.
         */
        i18nRaw_(id, ...varArgs) {
            return varArgs.length === 0 ? loadTimeData.getString(id) :
                loadTimeData.getStringF(id, ...varArgs);
        }
        /**
         * Returns a translated string where $1 to $9 are replaced by the given
         * values. Also sanitizes the output to filter out dangerous HTML/JS.
         * Use with Polymer bindings that are *not* inner-h-t-m-l.
         * NOTE: This is not related to $i18n{foo} in HTML, see file overview.
         * @param id The ID of the string to translate.
         * @param varArgs Values to replace the placeholders $1 to $9 in the
         *     string.
         * @return A translated, sanitized, substituted string.
         */
        i18n(id, ...varArgs) {
            const rawString = this.i18nRaw_(id, ...varArgs);
            return parseHtmlSubset(`<b>${rawString}</b>`).firstChild.textContent;
        }
        /**
         * Similar to 'i18n', returns a translated, sanitized, substituted
         * string. It receives the string ID and a dictionary containing the
         * substitutions as well as optional additional allowed tags and
         * attributes. Use with Polymer bindings that are inner-h-t-m-l, for
         * example.
         * @param id The ID of the string to translate.
         */
        i18nAdvanced(id, opts) {
            opts = opts || {};
            const rawString = this.i18nRaw_(id, ...(opts.substitutions || []));
            return sanitizeInnerHtml(rawString, opts);
        }
        /**
         * Similar to 'i18n', with an unused |locale| parameter used to trigger
         * updates when the locale changes.
         * @param locale The UI language used.
         * @param id The ID of the string to translate.
         * @param varArgs Values to replace the placeholders $1 to $9 in the
         *     string.
         * @return A translated, sanitized, substituted string.
         */
        i18nDynamic(_locale, id, ...varArgs) {
            return this.i18n(id, ...varArgs);
        }
        /**
         * Similar to 'i18nDynamic', but varArgs valus are interpreted as keys
         * in loadTimeData. This allows generation of strings that take other
         * localized strings as parameters.
         * @param locale The UI language used.
         * @param id The ID of the string to translate.
         * @param varArgs Values to replace the placeholders $1 to $9
         *     in the string. Values are interpreted as strings IDs if found in
         * the list of localized strings.
         * @return A translated, sanitized, substituted string.
         */
        i18nRecursive(locale, id, ...varArgs) {
            let args = varArgs;
            if (args.length > 0) {
                // Try to replace IDs with localized values.
                args = args.map(str => {
                    return this.i18nExists(str) ? loadTimeData.getString(str) : str;
                });
            }
            return this.i18nDynamic(locale, id, ...args);
        }
        /**
         * Returns true if a translation exists for |id|.
         */
        i18nExists(id) {
            return loadTimeData.valueExists(id);
        }
    }
    return I18nMixin;
});

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const ListPropertyUpdateMixin = dedupingMixin((superClass) => {
    class ListPropertyUpdateMixin extends superClass {
        updateList(propertyPath, identityGetter, updatedList, identityBasedUpdate = false) {
            const list = this.get(propertyPath);
            const splices = calculateSplices(updatedList.map(item => identityGetter(item)), list.map(identityGetter));
            splices.forEach(splice => {
                const index = splice.index;
                const deleteCount = splice.removed.length;
                // Transform splices to the expected format of notifySplices().
                // Convert !Array<string> to !Array<!Object>.
                splice.removed = list.slice(index, index + deleteCount);
                splice.object = list;
                splice.type = 'splice';
                const added = updatedList.slice(index, index + splice.addedCount);
                const spliceParams = [index, deleteCount].concat(added);
                list.splice.apply(list, spliceParams);
            });
            let updated = splices.length > 0;
            if (!identityBasedUpdate) {
                list.forEach((item, index) => {
                    const updatedItem = updatedList[index];
                    if (JSON.stringify(item) !== JSON.stringify(updatedItem)) {
                        this.set([propertyPath, index], updatedItem);
                        updated = true;
                    }
                });
            }
            if (splices.length > 0) {
                this.notifySplices(propertyPath, splices);
            }
            return updated;
        }
    }
    return ListPropertyUpdateMixin;
});

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Create a store client mixin for the store instance returned by
 * `storeGetter()`. An app, such as Personalization App, will have one central
 * store to bind to. Example:
 *
 * class MyStore extends Store {
 *   static getInstance(): MyStore {
 *     ....
 *   }
 * }
 *
 * const MyStoreClientMixin = makeStoreClientMixin(MyStore.getInstance);
 *
 * const MyElement extends MyStoreClientMixin(PolymerElement) {
 *   ....
 * }
 */
function makeStoreClientMixin(storeGetter) {
    function storeClientMixin(superClass) {
        class StoreClientMixin extends superClass {
            constructor() {
                super(...arguments);
                this.propertyWatches_ = new Map();
            }
            connectedCallback() {
                super.connectedCallback();
                this.getStore().addObserver(this);
            }
            disconnectedCallback() {
                super.disconnectedCallback();
                this.getStore().removeObserver(this);
            }
            dispatch(action) {
                this.getStore().dispatch(action);
            }
            dispatchAsync(action) {
                this.getStore().dispatchAsync(action);
            }
            onStateChanged(state) {
                // Collect all changes and batch them together. This reduces visual
                // churn on the polymer component if a single store change results in
                // multiple polymer properties changing.
                const changes = {};
                for (const [localProperty, valueGetter] of this.propertyWatches_) {
                    const oldValue = this.get(localProperty);
                    const newValue = valueGetter(state);
                    if (newValue !== oldValue && newValue !== undefined) {
                        changes[localProperty] = newValue;
                    }
                }
                this.setProperties(changes);
            }
            updateFromStore() {
                // TODO(b/296282541) assert that store is initialized instead of
                // performing a runtime check.
                if (this.getStore().isInitialized()) {
                    this.onStateChanged(this.getStore().data);
                }
            }
            watch(localProperty, valueGetter) {
                if (this.propertyWatches_.has(localProperty)) {
                    console.warn(`Overwriting watch for property ${localProperty}`);
                }
                this.propertyWatches_.set(localProperty, valueGetter);
            }
            getState() {
                return this.getStore().data;
            }
            getStore() {
                return storeGetter();
            }
        }
        return StoreClientMixin;
    }
    return dedupingMixin(storeClientMixin);
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * A generic datastore for the state of a page, where the state is publicly
 * readable but can only be modified by dispatching an Action.
 * The Store should be extended by specifying S, the page state type
 * associated with the store.
 */
class Store {
    data;
    reducer_;
    initialized_ = false;
    queuedActions_ = [];
    observers_ = new Set();
    batchMode_ = false;
    constructor(emptyState, reducer) {
        this.data = emptyState;
        this.reducer_ = reducer;
    }
    init(initialState) {
        this.data = initialState;
        this.queuedActions_.forEach((action) => {
            this.dispatchInternal_(action);
        });
        this.queuedActions_ = [];
        this.initialized_ = true;
        this.notifyObservers_(this.data);
    }
    isInitialized() {
        return this.initialized_;
    }
    addObserver(observer) {
        this.observers_.add(observer);
    }
    removeObserver(observer) {
        this.observers_.delete(observer);
    }
    hasObserver(observer) {
        return this.observers_.has(observer);
    }
    /**
     * Begin a batch update to store data, which will disable updates to the
     * UI until `endBatchUpdate` is called. This is useful when a single UI
     * operation is likely to cause many sequential model updates (eg, deleting
     * 100 bookmarks).
     */
    beginBatchUpdate() {
        this.batchMode_ = true;
    }
    /**
     * End a batch update to the store data, notifying the UI of any changes
     * which occurred while batch mode was enabled.
     */
    endBatchUpdate() {
        this.batchMode_ = false;
        this.notifyObservers_(this.data);
    }
    /**
     * Handles a 'deferred' action, which can asynchronously dispatch actions
     * to the Store in order to reach a new UI state. DeferredActions have the
     * form `dispatchAsync(function(dispatch) { ... })`). Inside that function,
     * the |dispatch| callback can be called asynchronously to dispatch Actions
     * directly to the Store.
     */
    dispatchAsync(action) {
        if (!this.initialized_) {
            this.queuedActions_.push(action);
            return;
        }
        this.dispatchInternal_(action);
    }
    /**
     * Transition to a new UI state based on the supplied |action|, and notify
     * observers of the change. If the Store has not yet been initialized, the
     * action will be queued and performed upon initialization.
     */
    dispatch(action) {
        this.dispatchAsync(function (dispatch) {
            dispatch(action);
        });
    }
    dispatchInternal_(action) {
        action(this.reduce.bind(this));
    }
    reduce(action) {
        if (!action) {
            return;
        }
        this.data = this.reducer_(this.data, action);
        // Batch notifications until after all initialization queuedActions are
        // resolved.
        if (this.isInitialized() && !this.batchMode_) {
            this.notifyObservers_(this.data);
        }
    }
    notifyObservers_(state) {
        this.observers_.forEach(function (o) {
            o.onStateChanged(state);
        });
    }
}

// ash/webui/common/mojom/sea_pen_generated.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const SeaPenTemplateIdSpec = { $: mojo.internal.Enum() };
var SeaPenTemplateId;
(function (SeaPenTemplateId) {
    SeaPenTemplateId[SeaPenTemplateId["MIN_VALUE"] = 0] = "MIN_VALUE";
    SeaPenTemplateId[SeaPenTemplateId["MAX_VALUE"] = 107] = "MAX_VALUE";
    SeaPenTemplateId[SeaPenTemplateId["kFlower"] = 0] = "kFlower";
    SeaPenTemplateId[SeaPenTemplateId["kMineral"] = 1] = "kMineral";
    SeaPenTemplateId[SeaPenTemplateId["kArt"] = 2] = "kArt";
    SeaPenTemplateId[SeaPenTemplateId["kCharacters"] = 3] = "kCharacters";
    SeaPenTemplateId[SeaPenTemplateId["kTerrain"] = 4] = "kTerrain";
    SeaPenTemplateId[SeaPenTemplateId["kCurious"] = 5] = "kCurious";
    SeaPenTemplateId[SeaPenTemplateId["kDreamscapes"] = 6] = "kDreamscapes";
    SeaPenTemplateId[SeaPenTemplateId["kTranslucent"] = 7] = "kTranslucent";
    SeaPenTemplateId[SeaPenTemplateId["kScifi"] = 8] = "kScifi";
    SeaPenTemplateId[SeaPenTemplateId["kLetters"] = 9] = "kLetters";
    SeaPenTemplateId[SeaPenTemplateId["kGlowscapes"] = 10] = "kGlowscapes";
    SeaPenTemplateId[SeaPenTemplateId["kSurreal"] = 11] = "kSurreal";
    SeaPenTemplateId[SeaPenTemplateId["kTerrainAlternate"] = 12] = "kTerrainAlternate";
    SeaPenTemplateId[SeaPenTemplateId["kVcBackgroundSimple"] = 100] = "kVcBackgroundSimple";
    SeaPenTemplateId[SeaPenTemplateId["kVcBackgroundOffice"] = 101] = "kVcBackgroundOffice";
    SeaPenTemplateId[SeaPenTemplateId["kVcBackgroundTerrainVc"] = 102] = "kVcBackgroundTerrainVc";
    SeaPenTemplateId[SeaPenTemplateId["kVcBackgroundCafe"] = 103] = "kVcBackgroundCafe";
    SeaPenTemplateId[SeaPenTemplateId["kVcBackgroundArt"] = 104] = "kVcBackgroundArt";
    SeaPenTemplateId[SeaPenTemplateId["kVcBackgroundDreamscapesVc"] = 105] = "kVcBackgroundDreamscapesVc";
    SeaPenTemplateId[SeaPenTemplateId["kVcBackgroundCharacters"] = 106] = "kVcBackgroundCharacters";
    SeaPenTemplateId[SeaPenTemplateId["kVcBackgroundGlowscapes"] = 107] = "kVcBackgroundGlowscapes";
})(SeaPenTemplateId || (SeaPenTemplateId = {}));
const SeaPenTemplateChipSpec = { $: mojo.internal.Enum() };
var SeaPenTemplateChip;
(function (SeaPenTemplateChip) {
    SeaPenTemplateChip[SeaPenTemplateChip["MIN_VALUE"] = 0] = "MIN_VALUE";
    SeaPenTemplateChip[SeaPenTemplateChip["MAX_VALUE"] = 10017] = "MAX_VALUE";
    SeaPenTemplateChip[SeaPenTemplateChip["kFlowerType"] = 0] = "kFlowerType";
    SeaPenTemplateChip[SeaPenTemplateChip["kFlowerColor"] = 1] = "kFlowerColor";
    SeaPenTemplateChip[SeaPenTemplateChip["kMineralName"] = 2] = "kMineralName";
    SeaPenTemplateChip[SeaPenTemplateChip["kMineralColor"] = 3] = "kMineralColor";
    SeaPenTemplateChip[SeaPenTemplateChip["kScifiFeature"] = 4] = "kScifiFeature";
    SeaPenTemplateChip[SeaPenTemplateChip["kScifiColor"] = 5] = "kScifiColor";
    SeaPenTemplateChip[SeaPenTemplateChip["kArtFeature"] = 6] = "kArtFeature";
    SeaPenTemplateChip[SeaPenTemplateChip["kArtMovement"] = 7] = "kArtMovement";
    SeaPenTemplateChip[SeaPenTemplateChip["kCharactersColor"] = 8] = "kCharactersColor";
    SeaPenTemplateChip[SeaPenTemplateChip["kCharactersSubjects"] = 9] = "kCharactersSubjects";
    SeaPenTemplateChip[SeaPenTemplateChip["kCharactersBackground"] = 10] = "kCharactersBackground";
    SeaPenTemplateChip[SeaPenTemplateChip["kTerrainFeature"] = 11] = "kTerrainFeature";
    SeaPenTemplateChip[SeaPenTemplateChip["kTerrainColor"] = 12] = "kTerrainColor";
    SeaPenTemplateChip[SeaPenTemplateChip["kCuriousSubject"] = 13] = "kCuriousSubject";
    SeaPenTemplateChip[SeaPenTemplateChip["kCuriousFeature"] = 14] = "kCuriousFeature";
    SeaPenTemplateChip[SeaPenTemplateChip["kCuriousColor"] = 15] = "kCuriousColor";
    SeaPenTemplateChip[SeaPenTemplateChip["kDreamscapesObject"] = 16] = "kDreamscapesObject";
    SeaPenTemplateChip[SeaPenTemplateChip["kDreamscapesMaterial"] = 17] = "kDreamscapesMaterial";
    SeaPenTemplateChip[SeaPenTemplateChip["kDreamscapesColors"] = 18] = "kDreamscapesColors";
    SeaPenTemplateChip[SeaPenTemplateChip["kTranslucentItem"] = 19] = "kTranslucentItem";
    SeaPenTemplateChip[SeaPenTemplateChip["kTranslucentColor"] = 20] = "kTranslucentColor";
    SeaPenTemplateChip[SeaPenTemplateChip["kLettersColor"] = 21] = "kLettersColor";
    SeaPenTemplateChip[SeaPenTemplateChip["kLettersLetter"] = 22] = "kLettersLetter";
    SeaPenTemplateChip[SeaPenTemplateChip["kGlowscapesLandscape"] = 23] = "kGlowscapesLandscape";
    SeaPenTemplateChip[SeaPenTemplateChip["kGlowscapesFeature"] = 24] = "kGlowscapesFeature";
    SeaPenTemplateChip[SeaPenTemplateChip["kSurrealLandscape"] = 25] = "kSurrealLandscape";
    SeaPenTemplateChip[SeaPenTemplateChip["kSurrealSubject"] = 26] = "kSurrealSubject";
    SeaPenTemplateChip[SeaPenTemplateChip["kVcBackgroundSimpleStyle"] = 10000] = "kVcBackgroundSimpleStyle";
    SeaPenTemplateChip[SeaPenTemplateChip["kVcBackgroundSimpleTone"] = 10001] = "kVcBackgroundSimpleTone";
    SeaPenTemplateChip[SeaPenTemplateChip["kVcBackgroundOfficeStyle"] = 10002] = "kVcBackgroundOfficeStyle";
    SeaPenTemplateChip[SeaPenTemplateChip["kVcBackgroundOfficeColor"] = 10003] = "kVcBackgroundOfficeColor";
    SeaPenTemplateChip[SeaPenTemplateChip["kVcBackgroundTerrainFeature"] = 10004] = "kVcBackgroundTerrainFeature";
    SeaPenTemplateChip[SeaPenTemplateChip["kVcBackgroundTerrainColor"] = 10005] = "kVcBackgroundTerrainColor";
    SeaPenTemplateChip[SeaPenTemplateChip["kVcBackgroundCafeStyle"] = 10006] = "kVcBackgroundCafeStyle";
    SeaPenTemplateChip[SeaPenTemplateChip["kVcBackgroundCafeType"] = 10007] = "kVcBackgroundCafeType";
    SeaPenTemplateChip[SeaPenTemplateChip["kVcBackgroundArtFeature"] = 10008] = "kVcBackgroundArtFeature";
    SeaPenTemplateChip[SeaPenTemplateChip["kVcBackgroundArtMovement"] = 10009] = "kVcBackgroundArtMovement";
    SeaPenTemplateChip[SeaPenTemplateChip["kVcBackgroundDreamscapesObject"] = 10010] = "kVcBackgroundDreamscapesObject";
    SeaPenTemplateChip[SeaPenTemplateChip["kVcBackgroundDreamscapesMaterial"] = 10011] = "kVcBackgroundDreamscapesMaterial";
    SeaPenTemplateChip[SeaPenTemplateChip["kVcBackgroundDreamscapesColors"] = 10012] = "kVcBackgroundDreamscapesColors";
    SeaPenTemplateChip[SeaPenTemplateChip["kVcBackgroundCharactersColor"] = 10013] = "kVcBackgroundCharactersColor";
    SeaPenTemplateChip[SeaPenTemplateChip["kVcBackgroundCharactersSubjects"] = 10014] = "kVcBackgroundCharactersSubjects";
    SeaPenTemplateChip[SeaPenTemplateChip["kVcBackgroundCharactersBackground"] = 10015] = "kVcBackgroundCharactersBackground";
    SeaPenTemplateChip[SeaPenTemplateChip["kVcBackgroundGlowscapesLandscape"] = 10016] = "kVcBackgroundGlowscapesLandscape";
    SeaPenTemplateChip[SeaPenTemplateChip["kVcBackgroundGlowscapesFeature"] = 10017] = "kVcBackgroundGlowscapesFeature";
})(SeaPenTemplateChip || (SeaPenTemplateChip = {}));
const SeaPenTemplateOptionSpec = { $: mojo.internal.Enum() };
var SeaPenTemplateOption;
(function (SeaPenTemplateOption) {
    SeaPenTemplateOption[SeaPenTemplateOption["MIN_VALUE"] = 0] = "MIN_VALUE";
    SeaPenTemplateOption[SeaPenTemplateOption["MAX_VALUE"] = 10217] = "MAX_VALUE";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerTypeRose"] = 0] = "kFlowerTypeRose";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerTypeCallaLily"] = 1] = "kFlowerTypeCallaLily";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerTypeWindflower"] = 2] = "kFlowerTypeWindflower";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerTypeTulip"] = 3] = "kFlowerTypeTulip";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerTypeLilyOfTheValley"] = 4] = "kFlowerTypeLilyOfTheValley";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerTypeBirdOfParadise"] = 5] = "kFlowerTypeBirdOfParadise";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerTypeOrchid"] = 6] = "kFlowerTypeOrchid";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerTypeRanunculus"] = 7] = "kFlowerTypeRanunculus";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerTypeDaisy"] = 8] = "kFlowerTypeDaisy";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerTypeHydrangea"] = 9] = "kFlowerTypeHydrangea";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerColorPink"] = 10] = "kFlowerColorPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerColorPurple"] = 11] = "kFlowerColorPurple";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerColorBlue"] = 12] = "kFlowerColorBlue";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerColorWhite"] = 13] = "kFlowerColorWhite";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerColorCoral"] = 14] = "kFlowerColorCoral";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerColorYellow"] = 15] = "kFlowerColorYellow";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerColorGreen"] = 16] = "kFlowerColorGreen";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerColorRed"] = 17] = "kFlowerColorRed";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameAgate"] = 18] = "kMineralNameAgate";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameAmethyst"] = 19] = "kMineralNameAmethyst";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameAquamarine"] = 20] = "kMineralNameAquamarine";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameAragonite"] = 21] = "kMineralNameAragonite";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameBismuth"] = 22] = "kMineralNameBismuth";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameCerussite"] = 23] = "kMineralNameCerussite";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameChalcopyrite"] = 24] = "kMineralNameChalcopyrite";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameChrysoprase"] = 25] = "kMineralNameChrysoprase";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameFluorite"] = 26] = "kMineralNameFluorite";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameGalena"] = 27] = "kMineralNameGalena";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameJasper"] = 28] = "kMineralNameJasper";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameLabradorite"] = 29] = "kMineralNameLabradorite";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameMoonstone"] = 30] = "kMineralNameMoonstone";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameOpal"] = 31] = "kMineralNameOpal";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNamePeridot"] = 32] = "kMineralNamePeridot";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameRhondochrosite"] = 33] = "kMineralNameRhondochrosite";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameRuby"] = 34] = "kMineralNameRuby";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameSapphire"] = 35] = "kMineralNameSapphire";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameQuartz"] = 36] = "kMineralNameQuartz";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralNameTourmaline"] = 37] = "kMineralNameTourmaline";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralColorWarm"] = 38] = "kMineralColorWarm";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralColorCool"] = 39] = "kMineralColorCool";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralColorNeutral"] = 40] = "kMineralColorNeutral";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralColorPastel"] = 41] = "kMineralColorPastel";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralColorMuted"] = 42] = "kMineralColorMuted";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralColorVibrant"] = 43] = "kMineralColorVibrant";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralColorEarthy"] = 44] = "kMineralColorEarthy";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralColorMetallic"] = 45] = "kMineralColorMetallic";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralColorNeon"] = 46] = "kMineralColorNeon";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralColorTonal"] = 47] = "kMineralColorTonal";
    SeaPenTemplateOption[SeaPenTemplateOption["kMineralColorGray"] = 48] = "kMineralColorGray";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiFeatureStreet"] = 49] = "kScifiFeatureStreet";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiFeatureSkyline"] = 50] = "kScifiFeatureSkyline";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiFeatureSwamp"] = 51] = "kScifiFeatureSwamp";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiFeatureTransport"] = 52] = "kScifiFeatureTransport";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiFeatureBusStop"] = 53] = "kScifiFeatureBusStop";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiFeatureDesert"] = 54] = "kScifiFeatureDesert";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiFeatureBeach"] = 55] = "kScifiFeatureBeach";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiFeatureMountains"] = 56] = "kScifiFeatureMountains";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiFeaturePark"] = 57] = "kScifiFeaturePark";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiFeatureForest"] = 58] = "kScifiFeatureForest";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiFeatureSmallTown"] = 59] = "kScifiFeatureSmallTown";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiFeatureFarm"] = 60] = "kScifiFeatureFarm";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiFeatureUnderwater"] = 61] = "kScifiFeatureUnderwater";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiColorEarthy"] = 62] = "kScifiColorEarthy";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiColorVibrant"] = 63] = "kScifiColorVibrant";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiColorSilver"] = 64] = "kScifiColorSilver";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiColorEerie"] = 65] = "kScifiColorEerie";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiColorComplementary"] = 66] = "kScifiColorComplementary";
    SeaPenTemplateOption[SeaPenTemplateOption["kScifiColorNeutral"] = 67] = "kScifiColorNeutral";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureCanyon"] = 68] = "kArtFeatureCanyon";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureMountain"] = 69] = "kArtFeatureMountain";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureBeach"] = 70] = "kArtFeatureBeach";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureCave"] = 71] = "kArtFeatureCave";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureCliff"] = 72] = "kArtFeatureCliff";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureForest"] = 73] = "kArtFeatureForest";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureGlacier"] = 74] = "kArtFeatureGlacier";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureIsland"] = 75] = "kArtFeatureIsland";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureJungle"] = 76] = "kArtFeatureJungle";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureLake"] = 77] = "kArtFeatureLake";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureMeadow"] = 78] = "kArtFeatureMeadow";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureOcean"] = 79] = "kArtFeatureOcean";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureRiver"] = 80] = "kArtFeatureRiver";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureDune"] = 81] = "kArtFeatureDune";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureSwamp"] = 82] = "kArtFeatureSwamp";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureValley"] = 83] = "kArtFeatureValley";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureWaterfall"] = 84] = "kArtFeatureWaterfall";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureField"] = 85] = "kArtFeatureField";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureCityscape"] = 86] = "kArtFeatureCityscape";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtFeatureVillage"] = 87] = "kArtFeatureVillage";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtMovementAvantGarde"] = 88] = "kArtMovementAvantGarde";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtMovementRealist"] = 89] = "kArtMovementRealist";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtMovementExpressionist"] = 90] = "kArtMovementExpressionist";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtMovementImpressionist"] = 91] = "kArtMovementImpressionist";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtMovementPostImpressionist"] = 92] = "kArtMovementPostImpressionist";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtMovementArtNouveau"] = 93] = "kArtMovementArtNouveau";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtMovementBaroque"] = 94] = "kArtMovementBaroque";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtMovementBauhaus"] = 95] = "kArtMovementBauhaus";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtMovementClassicist"] = 96] = "kArtMovementClassicist";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtMovementWatercolor"] = 97] = "kArtMovementWatercolor";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtMovementAbstract"] = 98] = "kArtMovementAbstract";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtMovementPointillist"] = 99] = "kArtMovementPointillist";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtMovementGraphicDesign"] = 100] = "kArtMovementGraphicDesign";
    SeaPenTemplateOption[SeaPenTemplateOption["kArtMovementModernArt"] = 101] = "kArtMovementModernArt";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorYellow"] = 102] = "kCharactersColorYellow";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorPink"] = 103] = "kCharactersColorPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorRed"] = 104] = "kCharactersColorRed";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorBlue"] = 105] = "kCharactersColorBlue";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorIndigo"] = 106] = "kCharactersColorIndigo";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorGreen"] = 107] = "kCharactersColorGreen";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorCyan"] = 108] = "kCharactersColorCyan";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorPurple"] = 109] = "kCharactersColorPurple";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorBrown"] = 110] = "kCharactersColorBrown";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorGold"] = 111] = "kCharactersColorGold";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorRust"] = 112] = "kCharactersColorRust";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorOlive"] = 113] = "kCharactersColorOlive";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorGray"] = 114] = "kCharactersColorGray";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorWhite"] = 115] = "kCharactersColorWhite";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorBeige"] = 116] = "kCharactersColorBeige";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorMagenta"] = 117] = "kCharactersColorMagenta";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorNeonGreen"] = 118] = "kCharactersColorNeonGreen";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorLightBlue"] = 119] = "kCharactersColorLightBlue";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorNeonPink"] = 120] = "kCharactersColorNeonPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersColorCoralPink"] = 121] = "kCharactersColorCoralPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsLemons"] = 122] = "kCharactersSubjectsLemons";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsFlowers"] = 123] = "kCharactersSubjectsFlowers";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsApples"] = 124] = "kCharactersSubjectsApples";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsCherries"] = 125] = "kCharactersSubjectsCherries";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsOranges"] = 126] = "kCharactersSubjectsOranges";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsPineapples"] = 127] = "kCharactersSubjectsPineapples";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsStrawberries"] = 128] = "kCharactersSubjectsStrawberries";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsWatermelons"] = 129] = "kCharactersSubjectsWatermelons";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsPotatoes"] = 130] = "kCharactersSubjectsPotatoes";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsSushi"] = 131] = "kCharactersSubjectsSushi";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsBaconAndEggs"] = 132] = "kCharactersSubjectsBaconAndEggs";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsPizza"] = 133] = "kCharactersSubjectsPizza";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsHotDogs"] = 134] = "kCharactersSubjectsHotDogs";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsHamburgers"] = 135] = "kCharactersSubjectsHamburgers";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsRamen"] = 136] = "kCharactersSubjectsRamen";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsTacos"] = 137] = "kCharactersSubjectsTacos";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsBunnies"] = 138] = "kCharactersSubjectsBunnies";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsCats"] = 139] = "kCharactersSubjectsCats";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsDogs"] = 140] = "kCharactersSubjectsDogs";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsKoalas"] = 141] = "kCharactersSubjectsKoalas";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsPandas"] = 142] = "kCharactersSubjectsPandas";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsPenguins"] = 143] = "kCharactersSubjectsPenguins";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsPigs"] = 144] = "kCharactersSubjectsPigs";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsSloths"] = 145] = "kCharactersSubjectsSloths";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsPonies"] = 146] = "kCharactersSubjectsPonies";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsElephants"] = 147] = "kCharactersSubjectsElephants";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsFoxes"] = 148] = "kCharactersSubjectsFoxes";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsOwls"] = 149] = "kCharactersSubjectsOwls";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsCrabs"] = 150] = "kCharactersSubjectsCrabs";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsBees"] = 151] = "kCharactersSubjectsBees";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsButterflies"] = 152] = "kCharactersSubjectsButterflies";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsBicycles"] = 153] = "kCharactersSubjectsBicycles";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsBoats"] = 154] = "kCharactersSubjectsBoats";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsBooks"] = 155] = "kCharactersSubjectsBooks";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsCutlery"] = 156] = "kCharactersSubjectsCutlery";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsUmbrellas"] = 157] = "kCharactersSubjectsUmbrellas";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersSubjectsInstruments"] = 158] = "kCharactersSubjectsInstruments";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundPurple"] = 159] = "kCharactersBackgroundPurple";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundBlue"] = 160] = "kCharactersBackgroundBlue";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundIndigo"] = 161] = "kCharactersBackgroundIndigo";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundGreen"] = 162] = "kCharactersBackgroundGreen";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundCyan"] = 163] = "kCharactersBackgroundCyan";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundBrown"] = 164] = "kCharactersBackgroundBrown";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundGold"] = 165] = "kCharactersBackgroundGold";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundRed"] = 166] = "kCharactersBackgroundRed";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundRust"] = 167] = "kCharactersBackgroundRust";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundOlive"] = 168] = "kCharactersBackgroundOlive";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundPink"] = 169] = "kCharactersBackgroundPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundGray"] = 170] = "kCharactersBackgroundGray";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundYellow"] = 171] = "kCharactersBackgroundYellow";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundWhite"] = 172] = "kCharactersBackgroundWhite";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundBeige"] = 173] = "kCharactersBackgroundBeige";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundMagenta"] = 174] = "kCharactersBackgroundMagenta";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundNeonGreen"] = 175] = "kCharactersBackgroundNeonGreen";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundLightBlue"] = 176] = "kCharactersBackgroundLightBlue";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundNeonPink"] = 177] = "kCharactersBackgroundNeonPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kCharactersBackgroundCoralPink"] = 178] = "kCharactersBackgroundCoralPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainFeatureSaltLake"] = 179] = "kTerrainFeatureSaltLake";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainFeatureRiver"] = 180] = "kTerrainFeatureRiver";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainFeatureNorthernLights"] = 181] = "kTerrainFeatureNorthernLights";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainFeatureSandDunes"] = 182] = "kTerrainFeatureSandDunes";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainFeatureClayHills"] = 183] = "kTerrainFeatureClayHills";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainFeatureSandyLagoon"] = 184] = "kTerrainFeatureSandyLagoon";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainFeatureMountains"] = 185] = "kTerrainFeatureMountains";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainFeatureBioluminescentBeach"] = 186] = "kTerrainFeatureBioluminescentBeach";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainFeatureFireflyForest"] = 187] = "kTerrainFeatureFireflyForest";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainFeatureDifferentPlanet"] = 188] = "kTerrainFeatureDifferentPlanet";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainColorPink"] = 189] = "kTerrainColorPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainColorTeal"] = 190] = "kTerrainColorTeal";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainColorWhite"] = 191] = "kTerrainColorWhite";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainColorPurple"] = 192] = "kTerrainColorPurple";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainColorBlue"] = 193] = "kTerrainColorBlue";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainColorYellow"] = 194] = "kTerrainColorYellow";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainColorMaroonPink"] = 195] = "kTerrainColorMaroonPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainColorBluePurple"] = 196] = "kTerrainColorBluePurple";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainColorPinkYellow"] = 197] = "kTerrainColorPinkYellow";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainColorBluePink"] = 198] = "kTerrainColorBluePink";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousSubjectCherryBlossoms"] = 199] = "kCuriousSubjectCherryBlossoms";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousSubjectJasmineFlowers"] = 200] = "kCuriousSubjectJasmineFlowers";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousSubjectDaisies"] = 201] = "kCuriousSubjectDaisies";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousSubjectTulips"] = 202] = "kCuriousSubjectTulips";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousSubjectCarnations"] = 203] = "kCuriousSubjectCarnations";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousSubjectDaffodils"] = 204] = "kCuriousSubjectDaffodils";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousSubjectForgetMeNots"] = 205] = "kCuriousSubjectForgetMeNots";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousSubjectSunflowers"] = 206] = "kCuriousSubjectSunflowers";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousSubjectBougainvilleas"] = 207] = "kCuriousSubjectBougainvilleas";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousSubjectAirPlants"] = 208] = "kCuriousSubjectAirPlants";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousSubjectSucculents"] = 209] = "kCuriousSubjectSucculents";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousFeatureAlpineLake"] = 210] = "kCuriousFeatureAlpineLake";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousFeatureGalaxy"] = 211] = "kCuriousFeatureGalaxy";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousFeatureSandDunes"] = 212] = "kCuriousFeatureSandDunes";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousFeatureSwamp"] = 213] = "kCuriousFeatureSwamp";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousFeatureBeach"] = 214] = "kCuriousFeatureBeach";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousFeatureMountains"] = 215] = "kCuriousFeatureMountains";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousFeatureRiver"] = 216] = "kCuriousFeatureRiver";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousFeatureWaterfall"] = 217] = "kCuriousFeatureWaterfall";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorBlue"] = 218] = "kCuriousColorBlue";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorRed"] = 219] = "kCuriousColorRed";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorYellow"] = 220] = "kCuriousColorYellow";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorGreen"] = 221] = "kCuriousColorGreen";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorPurple"] = 222] = "kCuriousColorPurple";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorOrange"] = 223] = "kCuriousColorOrange";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorPink"] = 224] = "kCuriousColorPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorBrown"] = 225] = "kCuriousColorBrown";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorBlack"] = 226] = "kCuriousColorBlack";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorTurquoise"] = 227] = "kCuriousColorTurquoise";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorMagenta"] = 228] = "kCuriousColorMagenta";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorLavender"] = 229] = "kCuriousColorLavender";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorMaroon"] = 230] = "kCuriousColorMaroon";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorNavy"] = 231] = "kCuriousColorNavy";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorOlive"] = 232] = "kCuriousColorOlive";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorCoral"] = 233] = "kCuriousColorCoral";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorCream"] = 234] = "kCuriousColorCream";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorIndigo"] = 235] = "kCuriousColorIndigo";
    SeaPenTemplateOption[SeaPenTemplateOption["kCuriousColorFuchsia"] = 236] = "kCuriousColorFuchsia";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesObjectBicycle"] = 237] = "kDreamscapesObjectBicycle";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesObjectCastle"] = 238] = "kDreamscapesObjectCastle";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesObjectBuilding"] = 239] = "kDreamscapesObjectBuilding";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesObjectBoat"] = 240] = "kDreamscapesObjectBoat";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesObjectLamp"] = 241] = "kDreamscapesObjectLamp";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesObjectTable"] = 242] = "kDreamscapesObjectTable";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesObjectBridge"] = 243] = "kDreamscapesObjectBridge";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesObjectLighthouse"] = 244] = "kDreamscapesObjectLighthouse";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesObjectPagoda"] = 245] = "kDreamscapesObjectPagoda";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesObjectPalace"] = 246] = "kDreamscapesObjectPalace";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesObjectTower"] = 247] = "kDreamscapesObjectTower";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesObjectChair"] = 248] = "kDreamscapesObjectChair";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialFlowers"] = 249] = "kDreamscapesMaterialFlowers";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialSilk"] = 250] = "kDreamscapesMaterialSilk";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialFelt"] = 251] = "kDreamscapesMaterialFelt";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialBurlap"] = 252] = "kDreamscapesMaterialBurlap";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialChiffon"] = 253] = "kDreamscapesMaterialChiffon";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialCotton"] = 254] = "kDreamscapesMaterialCotton";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialFur"] = 255] = "kDreamscapesMaterialFur";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialLace"] = 256] = "kDreamscapesMaterialLace";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialLinen"] = 257] = "kDreamscapesMaterialLinen";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialOrganza"] = 258] = "kDreamscapesMaterialOrganza";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialTulle"] = 259] = "kDreamscapesMaterialTulle";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialWool"] = 260] = "kDreamscapesMaterialWool";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialYarn"] = 261] = "kDreamscapesMaterialYarn";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialFleece"] = 262] = "kDreamscapesMaterialFleece";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialClay"] = 263] = "kDreamscapesMaterialClay";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialStone"] = 264] = "kDreamscapesMaterialStone";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialWood"] = 265] = "kDreamscapesMaterialWood";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialAmethyst"] = 266] = "kDreamscapesMaterialAmethyst";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialLapisLuzuli"] = 267] = "kDreamscapesMaterialLapisLuzuli";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialObsidian"] = 268] = "kDreamscapesMaterialObsidian";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialOpal"] = 269] = "kDreamscapesMaterialOpal";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesMaterialSapphire"] = 270] = "kDreamscapesMaterialSapphire";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesColorsPinkPurple"] = 271] = "kDreamscapesColorsPinkPurple";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesColorsCoralTan"] = 272] = "kDreamscapesColorsCoralTan";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesColorsCreamOrange"] = 273] = "kDreamscapesColorsCreamOrange";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesColorsBlueIndigo"] = 274] = "kDreamscapesColorsBlueIndigo";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesColorsGreenTeal"] = 275] = "kDreamscapesColorsGreenTeal";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesColorsBurgundyMaroon"] = 276] = "kDreamscapesColorsBurgundyMaroon";
    SeaPenTemplateOption[SeaPenTemplateOption["kDreamscapesColorsYellowTeal"] = 277] = "kDreamscapesColorsYellowTeal";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemApple"] = 278] = "kTranslucentItemApple";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemAzalea"] = 279] = "kTranslucentItemAzalea";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemBegonia"] = 280] = "kTranslucentItemBegonia";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemBluebell"] = 281] = "kTranslucentItemBluebell";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemCherryBlossom"] = 282] = "kTranslucentItemCherryBlossom";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemChrysanthemum"] = 283] = "kTranslucentItemChrysanthemum";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemClemati"] = 284] = "kTranslucentItemClemati";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemDaffodil"] = 285] = "kTranslucentItemDaffodil";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemDaisy"] = 286] = "kTranslucentItemDaisy";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemDandelion"] = 287] = "kTranslucentItemDandelion";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemRose"] = 288] = "kTranslucentItemRose";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemDogwood"] = 289] = "kTranslucentItemDogwood";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemHibiscus"] = 290] = "kTranslucentItemHibiscus";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemHydrangea"] = 291] = "kTranslucentItemHydrangea";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemLeaf"] = 292] = "kTranslucentItemLeaf";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemLily"] = 293] = "kTranslucentItemLily";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemPansy"] = 294] = "kTranslucentItemPansy";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemPear"] = 295] = "kTranslucentItemPear";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemPeony"] = 296] = "kTranslucentItemPeony";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemPhilodendron"] = 297] = "kTranslucentItemPhilodendron";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemPoppy"] = 298] = "kTranslucentItemPoppy";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemSunflower"] = 299] = "kTranslucentItemSunflower";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemPea"] = 300] = "kTranslucentItemPea";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentItemTulip"] = 301] = "kTranslucentItemTulip";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorPink"] = 302] = "kTranslucentColorPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorBlue"] = 303] = "kTranslucentColorBlue";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorIndigo"] = 304] = "kTranslucentColorIndigo";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorGreen"] = 305] = "kTranslucentColorGreen";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorEmerald"] = 306] = "kTranslucentColorEmerald";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorTeal"] = 307] = "kTranslucentColorTeal";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorCyan"] = 308] = "kTranslucentColorCyan";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorPurple"] = 309] = "kTranslucentColorPurple";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorGold"] = 310] = "kTranslucentColorGold";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorRed"] = 311] = "kTranslucentColorRed";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorRust"] = 312] = "kTranslucentColorRust";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorOlive"] = 313] = "kTranslucentColorOlive";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorGray"] = 314] = "kTranslucentColorGray";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorYellow"] = 315] = "kTranslucentColorYellow";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorViolet"] = 316] = "kTranslucentColorViolet";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorIvory"] = 317] = "kTranslucentColorIvory";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorMagenta"] = 318] = "kTranslucentColorMagenta";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorPeach"] = 319] = "kTranslucentColorPeach";
    SeaPenTemplateOption[SeaPenTemplateOption["kTranslucentColorBlack"] = 320] = "kTranslucentColorBlack";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainFeatureTreeTunnel"] = 321] = "kTerrainFeatureTreeTunnel";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainFeatureBaobabTrees"] = 322] = "kTerrainFeatureBaobabTrees";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainFeatureMistyForest"] = 323] = "kTerrainFeatureMistyForest";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainFeatureCactusForest"] = 324] = "kTerrainFeatureCactusForest";
    SeaPenTemplateOption[SeaPenTemplateOption["kTerrainColorCyan"] = 325] = "kTerrainColorCyan";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterA"] = 326] = "kLettersLetterA";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterB"] = 327] = "kLettersLetterB";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterC"] = 328] = "kLettersLetterC";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterD"] = 329] = "kLettersLetterD";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterE"] = 330] = "kLettersLetterE";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterF"] = 331] = "kLettersLetterF";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterG"] = 332] = "kLettersLetterG";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterH"] = 333] = "kLettersLetterH";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterI"] = 334] = "kLettersLetterI";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterJ"] = 335] = "kLettersLetterJ";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterK"] = 336] = "kLettersLetterK";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterL"] = 337] = "kLettersLetterL";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterM"] = 338] = "kLettersLetterM";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterN"] = 339] = "kLettersLetterN";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterO"] = 340] = "kLettersLetterO";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterP"] = 341] = "kLettersLetterP";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterQ"] = 342] = "kLettersLetterQ";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterR"] = 343] = "kLettersLetterR";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterS"] = 344] = "kLettersLetterS";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterT"] = 345] = "kLettersLetterT";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterU"] = 346] = "kLettersLetterU";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterV"] = 347] = "kLettersLetterV";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterW"] = 348] = "kLettersLetterW";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterX"] = 349] = "kLettersLetterX";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterY"] = 350] = "kLettersLetterY";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersLetterZ"] = 351] = "kLettersLetterZ";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersColorPastel"] = 352] = "kLettersColorPastel";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersColorBlack"] = 353] = "kLettersColorBlack";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersColorYellow"] = 354] = "kLettersColorYellow";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersColorRed"] = 355] = "kLettersColorRed";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersColorBlue"] = 356] = "kLettersColorBlue";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersColorIndigo"] = 357] = "kLettersColorIndigo";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersColorGreen"] = 358] = "kLettersColorGreen";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersColorCyan"] = 359] = "kLettersColorCyan";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersColorPurple"] = 360] = "kLettersColorPurple";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersColorOlive"] = 361] = "kLettersColorOlive";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersColorGray"] = 362] = "kLettersColorGray";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersColorMagenta"] = 363] = "kLettersColorMagenta";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersColorNeonGreen"] = 364] = "kLettersColorNeonGreen";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersColorLightBlue"] = 365] = "kLettersColorLightBlue";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersColorNeonPink"] = 366] = "kLettersColorNeonPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kLettersColorCoralPink"] = 367] = "kLettersColorCoralPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kGlowscapesLandscapeValley"] = 368] = "kGlowscapesLandscapeValley";
    SeaPenTemplateOption[SeaPenTemplateOption["kGlowscapesLandscapeHotSpring"] = 369] = "kGlowscapesLandscapeHotSpring";
    SeaPenTemplateOption[SeaPenTemplateOption["kGlowscapesLandscapeMeadow"] = 370] = "kGlowscapesLandscapeMeadow";
    SeaPenTemplateOption[SeaPenTemplateOption["kGlowscapesLandscapeCoralReef"] = 371] = "kGlowscapesLandscapeCoralReef";
    SeaPenTemplateOption[SeaPenTemplateOption["kGlowscapesLandscapePond"] = 372] = "kGlowscapesLandscapePond";
    SeaPenTemplateOption[SeaPenTemplateOption["kGlowscapesFeatureRiver"] = 373] = "kGlowscapesFeatureRiver";
    SeaPenTemplateOption[SeaPenTemplateOption["kGlowscapesFeatureSaltRock"] = 374] = "kGlowscapesFeatureSaltRock";
    SeaPenTemplateOption[SeaPenTemplateOption["kGlowscapesFeatureFlower"] = 375] = "kGlowscapesFeatureFlower";
    SeaPenTemplateOption[SeaPenTemplateOption["kGlowscapesFeatureWalkway"] = 376] = "kGlowscapesFeatureWalkway";
    SeaPenTemplateOption[SeaPenTemplateOption["kGlowscapesFeaturePool"] = 377] = "kGlowscapesFeaturePool";
    SeaPenTemplateOption[SeaPenTemplateOption["kSurrealLandscapeMeadow"] = 378] = "kSurrealLandscapeMeadow";
    SeaPenTemplateOption[SeaPenTemplateOption["kSurrealLandscapeSaltRock"] = 379] = "kSurrealLandscapeSaltRock";
    SeaPenTemplateOption[SeaPenTemplateOption["kSurrealLandscapeIsland"] = 380] = "kSurrealLandscapeIsland";
    SeaPenTemplateOption[SeaPenTemplateOption["kSurrealLandscapeLake"] = 381] = "kSurrealLandscapeLake";
    SeaPenTemplateOption[SeaPenTemplateOption["kSurrealLandscapeBeach"] = 382] = "kSurrealLandscapeBeach";
    SeaPenTemplateOption[SeaPenTemplateOption["kSurrealLandscapeCliff"] = 383] = "kSurrealLandscapeCliff";
    SeaPenTemplateOption[SeaPenTemplateOption["kSurrealSubjectFlowers"] = 384] = "kSurrealSubjectFlowers";
    SeaPenTemplateOption[SeaPenTemplateOption["kSurrealSubjectPools"] = 385] = "kSurrealSubjectPools";
    SeaPenTemplateOption[SeaPenTemplateOption["kSurrealSubjectSnow"] = 386] = "kSurrealSubjectSnow";
    SeaPenTemplateOption[SeaPenTemplateOption["kSurrealSubjectGlowingBubbles"] = 387] = "kSurrealSubjectGlowingBubbles";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerTypeSucculent"] = 388] = "kFlowerTypeSucculent";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerTypeGrass"] = 389] = "kFlowerTypeGrass";
    SeaPenTemplateOption[SeaPenTemplateOption["kFlowerTypeCactusFlower"] = 390] = "kFlowerTypeCactusFlower";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundSimpleStyleMinimal"] = 10000] = "kVcBackgroundSimpleStyleMinimal";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundSimpleStyleZen"] = 10001] = "kVcBackgroundSimpleStyleZen";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundSimpleStyleModern"] = 10002] = "kVcBackgroundSimpleStyleModern";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundSimpleStyleMagical"] = 10003] = "kVcBackgroundSimpleStyleMagical";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundSimpleToneNeutral"] = 10004] = "kVcBackgroundSimpleToneNeutral";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundSimpleToneDark"] = 10005] = "kVcBackgroundSimpleToneDark";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundSimpleToneLight"] = 10006] = "kVcBackgroundSimpleToneLight";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundOfficeStyleModern"] = 10007] = "kVcBackgroundOfficeStyleModern";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundOfficeStyleCreative"] = 10008] = "kVcBackgroundOfficeStyleCreative";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundOfficeStyleTraditional"] = 10009] = "kVcBackgroundOfficeStyleTraditional";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundOfficeStyleFuturistic"] = 10010] = "kVcBackgroundOfficeStyleFuturistic";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundOfficeColorNeutral"] = 10011] = "kVcBackgroundOfficeColorNeutral";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundOfficeColorDark"] = 10012] = "kVcBackgroundOfficeColorDark";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundOfficeColorColorful"] = 10013] = "kVcBackgroundOfficeColorColorful";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundOfficeColorEarthy"] = 10014] = "kVcBackgroundOfficeColorEarthy";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainFeatureSaltLake"] = 10015] = "kVcBackgroundTerrainFeatureSaltLake";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainFeatureRiver"] = 10016] = "kVcBackgroundTerrainFeatureRiver";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainFeatureNorthernLights"] = 10017] = "kVcBackgroundTerrainFeatureNorthernLights";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainFeatureSandDunes"] = 10018] = "kVcBackgroundTerrainFeatureSandDunes";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainFeatureClayHills"] = 10019] = "kVcBackgroundTerrainFeatureClayHills";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainFeatureSandyLagoon"] = 10020] = "kVcBackgroundTerrainFeatureSandyLagoon";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainFeatureMountains"] = 10021] = "kVcBackgroundTerrainFeatureMountains";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainFeatureBioluminescentBeach"] = 10022] = "kVcBackgroundTerrainFeatureBioluminescentBeach";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainFeatureFireflyForest"] = 10023] = "kVcBackgroundTerrainFeatureFireflyForest";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainFeatureDifferentPlanet"] = 10024] = "kVcBackgroundTerrainFeatureDifferentPlanet";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainColorPink"] = 10025] = "kVcBackgroundTerrainColorPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainColorTeal"] = 10026] = "kVcBackgroundTerrainColorTeal";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainColorWhite"] = 10027] = "kVcBackgroundTerrainColorWhite";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainColorPurple"] = 10028] = "kVcBackgroundTerrainColorPurple";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainColorBlue"] = 10029] = "kVcBackgroundTerrainColorBlue";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainColorYellow"] = 10030] = "kVcBackgroundTerrainColorYellow";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainColorMaroonPink"] = 10031] = "kVcBackgroundTerrainColorMaroonPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainColorBluePurple"] = 10032] = "kVcBackgroundTerrainColorBluePurple";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainColorPinkYellow"] = 10033] = "kVcBackgroundTerrainColorPinkYellow";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainColorBluePink"] = 10034] = "kVcBackgroundTerrainColorBluePink";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCafeStyleCozy"] = 10035] = "kVcBackgroundCafeStyleCozy";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCafeStyleNeutral"] = 10036] = "kVcBackgroundCafeStyleNeutral";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCafeStyleDistressed"] = 10037] = "kVcBackgroundCafeStyleDistressed";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCafeStyleClassic"] = 10038] = "kVcBackgroundCafeStyleClassic";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCafeStyleRomantic"] = 10039] = "kVcBackgroundCafeStyleRomantic";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCafeTypeCottage"] = 10040] = "kVcBackgroundCafeTypeCottage";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCafeTypeModern"] = 10041] = "kVcBackgroundCafeTypeModern";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCafeTypeTeaHouse"] = 10042] = "kVcBackgroundCafeTypeTeaHouse";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCafeTypeHighTea"] = 10043] = "kVcBackgroundCafeTypeHighTea";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCafeTypeOutdoor"] = 10044] = "kVcBackgroundCafeTypeOutdoor";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureCanyon"] = 10045] = "kVcBackgroundArtFeatureCanyon";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureMountain"] = 10046] = "kVcBackgroundArtFeatureMountain";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureBeach"] = 10047] = "kVcBackgroundArtFeatureBeach";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureCave"] = 10048] = "kVcBackgroundArtFeatureCave";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureCliff"] = 10049] = "kVcBackgroundArtFeatureCliff";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureForest"] = 10050] = "kVcBackgroundArtFeatureForest";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureGlacier"] = 10051] = "kVcBackgroundArtFeatureGlacier";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureIsland"] = 10052] = "kVcBackgroundArtFeatureIsland";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureJungle"] = 10053] = "kVcBackgroundArtFeatureJungle";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureLake"] = 10054] = "kVcBackgroundArtFeatureLake";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureMeadow"] = 10055] = "kVcBackgroundArtFeatureMeadow";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureOcean"] = 10056] = "kVcBackgroundArtFeatureOcean";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureRiver"] = 10057] = "kVcBackgroundArtFeatureRiver";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureDune"] = 10058] = "kVcBackgroundArtFeatureDune";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureSwamp"] = 10059] = "kVcBackgroundArtFeatureSwamp";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureValley"] = 10060] = "kVcBackgroundArtFeatureValley";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureWaterfall"] = 10061] = "kVcBackgroundArtFeatureWaterfall";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureField"] = 10062] = "kVcBackgroundArtFeatureField";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureCityscape"] = 10063] = "kVcBackgroundArtFeatureCityscape";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureVillage"] = 10064] = "kVcBackgroundArtFeatureVillage";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureAnime"] = 10065] = "kVcBackgroundArtFeatureAnime";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeaturePixelArt"] = 10066] = "kVcBackgroundArtFeaturePixelArt";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtFeatureCyberpunk"] = 10067] = "kVcBackgroundArtFeatureCyberpunk";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtMovementAvantGarde"] = 10068] = "kVcBackgroundArtMovementAvantGarde";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtMovementRealist"] = 10069] = "kVcBackgroundArtMovementRealist";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtMovementExpressionist"] = 10070] = "kVcBackgroundArtMovementExpressionist";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtMovementImpressionist"] = 10071] = "kVcBackgroundArtMovementImpressionist";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtMovementPostImpressionist"] = 10072] = "kVcBackgroundArtMovementPostImpressionist";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtMovementArtNouveau"] = 10073] = "kVcBackgroundArtMovementArtNouveau";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtMovementBaroque"] = 10074] = "kVcBackgroundArtMovementBaroque";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtMovementBauhaus"] = 10075] = "kVcBackgroundArtMovementBauhaus";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtMovementClassicist"] = 10076] = "kVcBackgroundArtMovementClassicist";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtMovementWatercolor"] = 10077] = "kVcBackgroundArtMovementWatercolor";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtMovementAbstract"] = 10078] = "kVcBackgroundArtMovementAbstract";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtMovementPointillist"] = 10079] = "kVcBackgroundArtMovementPointillist";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtMovementGraphicDesign"] = 10080] = "kVcBackgroundArtMovementGraphicDesign";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtMovementModernArt"] = 10081] = "kVcBackgroundArtMovementModernArt";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtMovementAnime"] = 10082] = "kVcBackgroundArtMovementAnime";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtMovementPixelArt"] = 10083] = "kVcBackgroundArtMovementPixelArt";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundArtMovementCyberpunk"] = 10084] = "kVcBackgroundArtMovementCyberpunk";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesObjectBicycle"] = 10085] = "kVcBackgroundDreamscapesObjectBicycle";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesObjectCastle"] = 10086] = "kVcBackgroundDreamscapesObjectCastle";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesObjectBuilding"] = 10087] = "kVcBackgroundDreamscapesObjectBuilding";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesObjectBoat"] = 10088] = "kVcBackgroundDreamscapesObjectBoat";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesObjectLamp"] = 10089] = "kVcBackgroundDreamscapesObjectLamp";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesObjectTable"] = 10090] = "kVcBackgroundDreamscapesObjectTable";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesObjectBridge"] = 10091] = "kVcBackgroundDreamscapesObjectBridge";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesObjectLighthouse"] = 10092] = "kVcBackgroundDreamscapesObjectLighthouse";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesObjectPagoda"] = 10093] = "kVcBackgroundDreamscapesObjectPagoda";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesObjectPalace"] = 10094] = "kVcBackgroundDreamscapesObjectPalace";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesObjectTower"] = 10095] = "kVcBackgroundDreamscapesObjectTower";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesObjectChair"] = 10096] = "kVcBackgroundDreamscapesObjectChair";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialFlowers"] = 10097] = "kVcBackgroundDreamscapesMaterialFlowers";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialSilk"] = 10098] = "kVcBackgroundDreamscapesMaterialSilk";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialFelt"] = 10099] = "kVcBackgroundDreamscapesMaterialFelt";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialBurlap"] = 10100] = "kVcBackgroundDreamscapesMaterialBurlap";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialChiffon"] = 10101] = "kVcBackgroundDreamscapesMaterialChiffon";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialCotton"] = 10102] = "kVcBackgroundDreamscapesMaterialCotton";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialFur"] = 10103] = "kVcBackgroundDreamscapesMaterialFur";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialLace"] = 10104] = "kVcBackgroundDreamscapesMaterialLace";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialLinen"] = 10105] = "kVcBackgroundDreamscapesMaterialLinen";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialOrganza"] = 10106] = "kVcBackgroundDreamscapesMaterialOrganza";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialTulle"] = 10107] = "kVcBackgroundDreamscapesMaterialTulle";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialWool"] = 10108] = "kVcBackgroundDreamscapesMaterialWool";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialYarn"] = 10109] = "kVcBackgroundDreamscapesMaterialYarn";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialFleece"] = 10110] = "kVcBackgroundDreamscapesMaterialFleece";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialClay"] = 10111] = "kVcBackgroundDreamscapesMaterialClay";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialStone"] = 10112] = "kVcBackgroundDreamscapesMaterialStone";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialWood"] = 10113] = "kVcBackgroundDreamscapesMaterialWood";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialAmethyst"] = 10114] = "kVcBackgroundDreamscapesMaterialAmethyst";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialLapisLuzuli"] = 10115] = "kVcBackgroundDreamscapesMaterialLapisLuzuli";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialObsidian"] = 10116] = "kVcBackgroundDreamscapesMaterialObsidian";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialOpal"] = 10117] = "kVcBackgroundDreamscapesMaterialOpal";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesMaterialSapphire"] = 10118] = "kVcBackgroundDreamscapesMaterialSapphire";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesColorsPinkPurple"] = 10119] = "kVcBackgroundDreamscapesColorsPinkPurple";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesColorsCoralTan"] = 10120] = "kVcBackgroundDreamscapesColorsCoralTan";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesColorsCreamOrange"] = 10121] = "kVcBackgroundDreamscapesColorsCreamOrange";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesColorsBlueIndigo"] = 10122] = "kVcBackgroundDreamscapesColorsBlueIndigo";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesColorsGreenTeal"] = 10123] = "kVcBackgroundDreamscapesColorsGreenTeal";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesColorsBurgundyMaroon"] = 10124] = "kVcBackgroundDreamscapesColorsBurgundyMaroon";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundDreamscapesColorsYellowTeal"] = 10125] = "kVcBackgroundDreamscapesColorsYellowTeal";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorYellow"] = 10126] = "kVcBackgroundCharactersColorYellow";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorPink"] = 10127] = "kVcBackgroundCharactersColorPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorRed"] = 10128] = "kVcBackgroundCharactersColorRed";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorBlue"] = 10129] = "kVcBackgroundCharactersColorBlue";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorIndigo"] = 10130] = "kVcBackgroundCharactersColorIndigo";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorGreen"] = 10131] = "kVcBackgroundCharactersColorGreen";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorCyan"] = 10132] = "kVcBackgroundCharactersColorCyan";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorPurple"] = 10133] = "kVcBackgroundCharactersColorPurple";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorBrown"] = 10134] = "kVcBackgroundCharactersColorBrown";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorGold"] = 10135] = "kVcBackgroundCharactersColorGold";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorRust"] = 10136] = "kVcBackgroundCharactersColorRust";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorOlive"] = 10137] = "kVcBackgroundCharactersColorOlive";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorGray"] = 10138] = "kVcBackgroundCharactersColorGray";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorWhite"] = 10139] = "kVcBackgroundCharactersColorWhite";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorBeige"] = 10140] = "kVcBackgroundCharactersColorBeige";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorMagenta"] = 10141] = "kVcBackgroundCharactersColorMagenta";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorNeonGreen"] = 10142] = "kVcBackgroundCharactersColorNeonGreen";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorLightBlue"] = 10143] = "kVcBackgroundCharactersColorLightBlue";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorNeonPink"] = 10144] = "kVcBackgroundCharactersColorNeonPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersColorCoralPink"] = 10145] = "kVcBackgroundCharactersColorCoralPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsLemons"] = 10146] = "kVcBackgroundCharactersSubjectsLemons";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsFlowers"] = 10147] = "kVcBackgroundCharactersSubjectsFlowers";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsApples"] = 10148] = "kVcBackgroundCharactersSubjectsApples";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsCherries"] = 10149] = "kVcBackgroundCharactersSubjectsCherries";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsOranges"] = 10150] = "kVcBackgroundCharactersSubjectsOranges";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsPineapples"] = 10151] = "kVcBackgroundCharactersSubjectsPineapples";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsStrawberries"] = 10152] = "kVcBackgroundCharactersSubjectsStrawberries";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsWatermelons"] = 10153] = "kVcBackgroundCharactersSubjectsWatermelons";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsPotatoes"] = 10154] = "kVcBackgroundCharactersSubjectsPotatoes";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsSushi"] = 10155] = "kVcBackgroundCharactersSubjectsSushi";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsBaconAndEggs"] = 10156] = "kVcBackgroundCharactersSubjectsBaconAndEggs";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsPizza"] = 10157] = "kVcBackgroundCharactersSubjectsPizza";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsHotDogs"] = 10158] = "kVcBackgroundCharactersSubjectsHotDogs";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsHamburgers"] = 10159] = "kVcBackgroundCharactersSubjectsHamburgers";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsRamen"] = 10160] = "kVcBackgroundCharactersSubjectsRamen";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsTacos"] = 10161] = "kVcBackgroundCharactersSubjectsTacos";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsBunnies"] = 10162] = "kVcBackgroundCharactersSubjectsBunnies";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsCats"] = 10163] = "kVcBackgroundCharactersSubjectsCats";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsDogs"] = 10164] = "kVcBackgroundCharactersSubjectsDogs";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsKoalas"] = 10165] = "kVcBackgroundCharactersSubjectsKoalas";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsPandas"] = 10166] = "kVcBackgroundCharactersSubjectsPandas";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsPenguins"] = 10167] = "kVcBackgroundCharactersSubjectsPenguins";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsPigs"] = 10168] = "kVcBackgroundCharactersSubjectsPigs";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsSloths"] = 10169] = "kVcBackgroundCharactersSubjectsSloths";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsPonies"] = 10170] = "kVcBackgroundCharactersSubjectsPonies";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsElephants"] = 10171] = "kVcBackgroundCharactersSubjectsElephants";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsFoxes"] = 10172] = "kVcBackgroundCharactersSubjectsFoxes";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsOwls"] = 10173] = "kVcBackgroundCharactersSubjectsOwls";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsCrabs"] = 10174] = "kVcBackgroundCharactersSubjectsCrabs";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsBees"] = 10175] = "kVcBackgroundCharactersSubjectsBees";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsButterflies"] = 10176] = "kVcBackgroundCharactersSubjectsButterflies";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsBicycles"] = 10177] = "kVcBackgroundCharactersSubjectsBicycles";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsBoats"] = 10178] = "kVcBackgroundCharactersSubjectsBoats";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsBooks"] = 10179] = "kVcBackgroundCharactersSubjectsBooks";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsCutlery"] = 10180] = "kVcBackgroundCharactersSubjectsCutlery";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsUmbrellas"] = 10181] = "kVcBackgroundCharactersSubjectsUmbrellas";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersSubjectsInstruments"] = 10182] = "kVcBackgroundCharactersSubjectsInstruments";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundPurple"] = 10183] = "kVcBackgroundCharactersBackgroundPurple";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundBlue"] = 10184] = "kVcBackgroundCharactersBackgroundBlue";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundIndigo"] = 10185] = "kVcBackgroundCharactersBackgroundIndigo";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundGreen"] = 10186] = "kVcBackgroundCharactersBackgroundGreen";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundCyan"] = 10187] = "kVcBackgroundCharactersBackgroundCyan";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundBrown"] = 10188] = "kVcBackgroundCharactersBackgroundBrown";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundGold"] = 10189] = "kVcBackgroundCharactersBackgroundGold";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundRed"] = 10190] = "kVcBackgroundCharactersBackgroundRed";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundRust"] = 10191] = "kVcBackgroundCharactersBackgroundRust";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundOlive"] = 10192] = "kVcBackgroundCharactersBackgroundOlive";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundPink"] = 10193] = "kVcBackgroundCharactersBackgroundPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundGray"] = 10194] = "kVcBackgroundCharactersBackgroundGray";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundYellow"] = 10195] = "kVcBackgroundCharactersBackgroundYellow";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundWhite"] = 10196] = "kVcBackgroundCharactersBackgroundWhite";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundBeige"] = 10197] = "kVcBackgroundCharactersBackgroundBeige";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundMagenta"] = 10198] = "kVcBackgroundCharactersBackgroundMagenta";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundNeonGreen"] = 10199] = "kVcBackgroundCharactersBackgroundNeonGreen";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundLightBlue"] = 10200] = "kVcBackgroundCharactersBackgroundLightBlue";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundNeonPink"] = 10201] = "kVcBackgroundCharactersBackgroundNeonPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundCharactersBackgroundCoralPink"] = 10202] = "kVcBackgroundCharactersBackgroundCoralPink";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainFeatureTreeTunnel"] = 10203] = "kVcBackgroundTerrainFeatureTreeTunnel";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainFeatureBaobabTrees"] = 10204] = "kVcBackgroundTerrainFeatureBaobabTrees";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainFeatureMistyForest"] = 10205] = "kVcBackgroundTerrainFeatureMistyForest";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainFeatureCactusForest"] = 10206] = "kVcBackgroundTerrainFeatureCactusForest";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundTerrainColorCyan"] = 10207] = "kVcBackgroundTerrainColorCyan";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundGlowscapesLandscapeValley"] = 10208] = "kVcBackgroundGlowscapesLandscapeValley";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundGlowscapesLandscapeHotSpring"] = 10209] = "kVcBackgroundGlowscapesLandscapeHotSpring";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundGlowscapesLandscapeMeadow"] = 10210] = "kVcBackgroundGlowscapesLandscapeMeadow";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundGlowscapesLandscapeCoralReef"] = 10211] = "kVcBackgroundGlowscapesLandscapeCoralReef";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundGlowscapesLandscapePond"] = 10212] = "kVcBackgroundGlowscapesLandscapePond";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundGlowscapesFeatureRiver"] = 10213] = "kVcBackgroundGlowscapesFeatureRiver";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundGlowscapesFeatureSaltRock"] = 10214] = "kVcBackgroundGlowscapesFeatureSaltRock";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundGlowscapesFeatureFlower"] = 10215] = "kVcBackgroundGlowscapesFeatureFlower";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundGlowscapesFeatureWalkway"] = 10216] = "kVcBackgroundGlowscapesFeatureWalkway";
    SeaPenTemplateOption[SeaPenTemplateOption["kVcBackgroundGlowscapesFeaturePool"] = 10217] = "kVcBackgroundGlowscapesFeaturePool";
})(SeaPenTemplateOption || (SeaPenTemplateOption = {}));

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// AUTOGENERATED - DO NOT EDIT!
// This file is generated by chromium_generator.py
function getWallpaperTemplates() {
    return [
        {
            id: SeaPenTemplateId.kGlowscapes,
            title: loadTimeData.getString('seaPenTemplateTitleGlowscapes'),
            text: loadTimeData.getStringF('seaPenTemplateGlowscapes', `<${SeaPenTemplateChip.kGlowscapesLandscape}>`, `<${SeaPenTemplateChip.kGlowscapesFeature}>`),
            preview: [{
                    url: 'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_glowscapes.jpg',
                }],
            options: new Map([
                [
                    SeaPenTemplateChip.kGlowscapesLandscape,
                    [
                        {
                            value: SeaPenTemplateOption.kGlowscapesLandscapeValley,
                            translation: loadTimeData.getString('seaPenOptionGlowscapesLandscapeValley'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/valley.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kGlowscapesLandscapeHotSpring,
                            translation: loadTimeData.getString('seaPenOptionGlowscapesLandscapeHotSpring'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/hot_spring.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kGlowscapesLandscapeMeadow,
                            translation: loadTimeData.getString('seaPenOptionGlowscapesLandscapeMeadow'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/meadow.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kGlowscapesLandscapeCoralReef,
                            translation: loadTimeData.getString('seaPenOptionGlowscapesLandscapeCoralReef'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral_reef.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kGlowscapesLandscapePond,
                            translation: loadTimeData.getString('seaPenOptionGlowscapesLandscapePond'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pond.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kGlowscapesFeature,
                    [
                        {
                            value: SeaPenTemplateOption.kGlowscapesFeatureRiver,
                            translation: loadTimeData.getString('seaPenOptionGlowscapesFeatureRiver'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/river.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kGlowscapesFeatureSaltRock,
                            translation: loadTimeData.getString('seaPenOptionGlowscapesFeatureSaltRock'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/salt_rock.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kGlowscapesFeatureFlower,
                            translation: loadTimeData.getString('seaPenOptionGlowscapesFeatureFlower'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/flower.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kGlowscapesFeatureWalkway,
                            translation: loadTimeData.getString('seaPenOptionGlowscapesFeatureWalkway'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/walkway.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kGlowscapesFeaturePool,
                            translation: loadTimeData.getString('seaPenOptionGlowscapesFeaturePool'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pool.jpg',
                        },
                    ],
                ],
            ]),
        },
        {
            id: SeaPenTemplateId.kDreamscapes,
            title: loadTimeData.getString('seaPenTemplateTitleDreamscapes'),
            text: loadTimeData.getStringF('seaPenTemplateDreamscapes', `<${SeaPenTemplateChip.kDreamscapesObject}>`, `<${SeaPenTemplateChip.kDreamscapesMaterial}>`, `<${SeaPenTemplateChip.kDreamscapesColors}>`),
            preview: [{
                    url: 'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_dreamscapes.jpg',
                }],
            options: new Map([
                [
                    SeaPenTemplateChip.kDreamscapesObject,
                    [
                        {
                            value: SeaPenTemplateOption.kDreamscapesObjectBicycle,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesObjectBicycle'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bicycle.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesObjectCastle,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesObjectCastle'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/castle.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesObjectBuilding,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesObjectBuilding'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/building.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesObjectBoat,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesObjectBoat'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/boat.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesObjectLamp,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesObjectLamp'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lamp.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesObjectTable,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesObjectTable'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/table.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesObjectBridge,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesObjectBridge'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bridge.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesObjectPagoda,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesObjectPagoda'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pagoda.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesObjectPalace,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesObjectPalace'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/palace.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kDreamscapesMaterial,
                    [
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialFlowers,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialFlowers'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/flowers.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialSilk,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialSilk'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/silk.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialFelt,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialFelt'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/felt.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialBurlap,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialBurlap'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/burlap.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialChiffon,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialChiffon'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/chiffon.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialCotton,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialCotton'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cotton.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialFur,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialFur'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/fur.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialLace,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialLace'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lace.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialLinen,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialLinen'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/linen.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialOrganza,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialOrganza'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/organza.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialTulle,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialTulle'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/tulle.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialWool,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialWool'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/wool.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialYarn,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialYarn'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yarn.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialFleece,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialFleece'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/fleece.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialClay,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialClay'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/clay.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialStone,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialStone'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/stone.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialWood,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialWood'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/wood.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialAmethyst,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialAmethyst'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/amethyst.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialLapisLuzuli,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialLapisLuzuli'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lapis_luzuli.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialObsidian,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialObsidian'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/obsidian.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialOpal,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialOpal'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/opal.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesMaterialSapphire,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesMaterialSapphire'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sapphire.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kDreamscapesColors,
                    [
                        {
                            value: SeaPenTemplateOption.kDreamscapesColorsPinkPurple,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesColorsPinkPurple'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink_purple.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesColorsCoralTan,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesColorsCoralTan'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral_tan.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesColorsCreamOrange,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesColorsCreamOrange'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cream_orange.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesColorsBlueIndigo,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesColorsBlueIndigo'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue_indigo.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesColorsGreenTeal,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesColorsGreenTeal'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/green_teal.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesColorsBurgundyMaroon,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesColorsBurgundyMaroon'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/burgundy_maroon.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kDreamscapesColorsYellowTeal,
                            translation: loadTimeData.getString('seaPenOptionDreamscapesColorsYellowTeal'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow_teal.jpg',
                        },
                    ],
                ],
            ]),
        },
        {
            id: SeaPenTemplateId.kTerrain,
            title: loadTimeData.getString('seaPenTemplateTitleTerrain'),
            text: loadTimeData.getStringF('seaPenTemplateTerrain', `<${SeaPenTemplateChip.kTerrainFeature}>`, `<${SeaPenTemplateChip.kTerrainColor}>`),
            preview: [{
                    url: 'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_terrain.jpg',
                }],
            options: new Map([
                [
                    SeaPenTemplateChip.kTerrainFeature,
                    [
                        {
                            value: SeaPenTemplateOption.kTerrainFeatureSaltLake,
                            translation: loadTimeData.getString('seaPenOptionTerrainFeatureSaltLake'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/salt_lake.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainFeatureRiver,
                            translation: loadTimeData.getString('seaPenOptionTerrainFeatureRiver'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/glacial_river.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainFeatureNorthernLights,
                            translation: loadTimeData.getString('seaPenOptionTerrainFeatureNorthernLights'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/northern_lights.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainFeatureSandDunes,
                            translation: loadTimeData.getString('seaPenOptionTerrainFeatureSandDunes'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sand_dune.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainFeatureClayHills,
                            translation: loadTimeData.getString('seaPenOptionTerrainFeatureClayHills'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/clay_hills.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainFeatureSandyLagoon,
                            translation: loadTimeData.getString('seaPenOptionTerrainFeatureSandyLagoon'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sandy_lagoon.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainFeatureMountains,
                            translation: loadTimeData.getString('seaPenOptionTerrainFeatureMountains'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/mountain.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainFeatureBioluminescentBeach,
                            translation: loadTimeData.getString('seaPenOptionTerrainFeatureBioluminescentBeach'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bioluminescent_beach.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainFeatureDifferentPlanet,
                            translation: loadTimeData.getString('seaPenOptionTerrainFeatureDifferentPlanet'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/different_planet.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainFeatureTreeTunnel,
                            translation: loadTimeData.getString('seaPenOptionTerrainFeatureTreeTunnel'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/tree_tunnel.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainFeatureBaobabTrees,
                            translation: loadTimeData.getString('seaPenOptionTerrainFeatureBaobabTrees'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/baobab_trees.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainFeatureMistyForest,
                            translation: loadTimeData.getString('seaPenOptionTerrainFeatureMistyForest'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/misty_forest.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainFeatureCactusForest,
                            translation: loadTimeData.getString('seaPenOptionTerrainFeatureCactusForest'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cactus_forest.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kTerrainColor,
                    [
                        {
                            value: SeaPenTemplateOption.kTerrainColorPink,
                            translation: loadTimeData.getString('seaPenOptionTerrainColorPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainColorCyan,
                            translation: loadTimeData.getString('seaPenOptionTerrainColorCyan'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cyan.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainColorWhite,
                            translation: loadTimeData.getString('seaPenOptionTerrainColorWhite'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/white.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainColorPurple,
                            translation: loadTimeData.getString('seaPenOptionTerrainColorPurple'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/purple.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainColorBlue,
                            translation: loadTimeData.getString('seaPenOptionTerrainColorBlue'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainColorYellow,
                            translation: loadTimeData.getString('seaPenOptionTerrainColorYellow'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainColorMaroonPink,
                            translation: loadTimeData.getString('seaPenOptionTerrainColorMaroonPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/maroon_pink.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainColorBluePurple,
                            translation: loadTimeData.getString('seaPenOptionTerrainColorBluePurple'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue_purple.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainColorPinkYellow,
                            translation: loadTimeData.getString('seaPenOptionTerrainColorPinkYellow'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink_yellow.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kTerrainColorBluePink,
                            translation: loadTimeData.getString('seaPenOptionTerrainColorBluePink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue_pink.jpg',
                        },
                    ],
                ],
            ]),
        },
        {
            id: SeaPenTemplateId.kSurreal,
            title: loadTimeData.getString('seaPenTemplateTitleSurreal'),
            text: loadTimeData.getStringF('seaPenTemplateSurreal', `<${SeaPenTemplateChip.kSurrealLandscape}>`, `<${SeaPenTemplateChip.kSurrealSubject}>`),
            preview: [{
                    url: 'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_surreal.jpg',
                }],
            options: new Map([
                [
                    SeaPenTemplateChip.kSurrealLandscape,
                    [
                        {
                            value: SeaPenTemplateOption.kSurrealLandscapeMeadow,
                            translation: loadTimeData.getString('seaPenOptionSurrealLandscapeMeadow'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/meadow.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kSurrealLandscapeSaltRock,
                            translation: loadTimeData.getString('seaPenOptionSurrealLandscapeSaltRock'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/salt_rock.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kSurrealLandscapeIsland,
                            translation: loadTimeData.getString('seaPenOptionSurrealLandscapeIsland'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/island.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kSurrealLandscapeLake,
                            translation: loadTimeData.getString('seaPenOptionSurrealLandscapeLake'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lake.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kSurrealLandscapeBeach,
                            translation: loadTimeData.getString('seaPenOptionSurrealLandscapeBeach'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/beach.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kSurrealLandscapeCliff,
                            translation: loadTimeData.getString('seaPenOptionSurrealLandscapeCliff'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cliff.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kSurrealSubject,
                    [
                        {
                            value: SeaPenTemplateOption.kSurrealSubjectFlowers,
                            translation: loadTimeData.getString('seaPenOptionSurrealSubjectFlowers'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/flowers.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kSurrealSubjectPools,
                            translation: loadTimeData.getString('seaPenOptionSurrealSubjectPools'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pool.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kSurrealSubjectSnow,
                            translation: loadTimeData.getString('seaPenOptionSurrealSubjectSnow'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/snow.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kSurrealSubjectGlowingBubbles,
                            translation: loadTimeData.getString('seaPenOptionSurrealSubjectGlowingBubbles'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/glowing_bubbles.jpg',
                        },
                    ],
                ],
            ]),
        },
        {
            id: SeaPenTemplateId.kArt,
            title: loadTimeData.getString('seaPenTemplateTitleArt'),
            text: loadTimeData.getStringF('seaPenTemplateArt', `<${SeaPenTemplateChip.kArtFeature}>`, `<${SeaPenTemplateChip.kArtMovement}>`),
            preview: [{
                    url: 'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_art.jpg',
                }],
            options: new Map([
                [
                    SeaPenTemplateChip.kArtFeature,
                    [
                        {
                            value: SeaPenTemplateOption.kArtFeatureField,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureField'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/field_of_flowers.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtFeatureSwamp,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureSwamp'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/swamp.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtFeatureBeach,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureBeach'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/beach.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtFeatureMeadow,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureMeadow'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/meadow.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtFeatureForest,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureForest'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/forest.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtFeatureGlacier,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureGlacier'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/glacier.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtFeatureIsland,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureIsland'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/island.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtFeatureJungle,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureJungle'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/jungle.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtFeatureLake,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureLake'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lake.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtFeatureCliff,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureCliff'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cliff.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtFeatureOcean,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureOcean'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/ocean.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtFeatureRiver,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureRiver'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/river.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtFeatureDune,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureDune'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sand_dune.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtFeatureMountain,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureMountain'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/mountain.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtFeatureValley,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureValley'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/valley.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtFeatureWaterfall,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureWaterfall'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/waterfall.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtFeatureCanyon,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureCanyon'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/canyon.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtFeatureCityscape,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureCityscape'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cityscape.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtFeatureVillage,
                            translation: loadTimeData.getString('seaPenOptionArtFeatureVillage'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/mediterranean_village.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kArtMovement,
                    [
                        {
                            value: SeaPenTemplateOption.kArtMovementAvantGarde,
                            translation: loadTimeData.getString('seaPenOptionArtMovementAvantGarde'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/avant-garde.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtMovementRealist,
                            translation: loadTimeData.getString('seaPenOptionArtMovementRealist'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/realist.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtMovementExpressionist,
                            translation: loadTimeData.getString('seaPenOptionArtMovementExpressionist'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/expressionist.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtMovementImpressionist,
                            translation: loadTimeData.getString('seaPenOptionArtMovementImpressionist'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/impressionist.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtMovementPostImpressionist,
                            translation: loadTimeData.getString('seaPenOptionArtMovementPostImpressionist'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/post-impressionist.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtMovementArtNouveau,
                            translation: loadTimeData.getString('seaPenOptionArtMovementArtNouveau'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/art_nouveau.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtMovementBauhaus,
                            translation: loadTimeData.getString('seaPenOptionArtMovementBauhaus'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bauhaus.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtMovementWatercolor,
                            translation: loadTimeData.getString('seaPenOptionArtMovementWatercolor'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/watercolor.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtMovementAbstract,
                            translation: loadTimeData.getString('seaPenOptionArtMovementAbstract'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/abstract.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kArtMovementModernArt,
                            translation: loadTimeData.getString('seaPenOptionArtMovementModernArt'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/modern_art.jpg',
                        },
                    ],
                ],
            ]),
        },
        {
            id: SeaPenTemplateId.kLetters,
            title: loadTimeData.getString('seaPenTemplateTitleLetters'),
            text: loadTimeData.getStringF('seaPenTemplateLetters', `<${SeaPenTemplateChip.kLettersColor}>`, `<${SeaPenTemplateChip.kLettersLetter}>`),
            preview: [{
                    url: 'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_letters.jpg',
                }],
            options: new Map([
                [
                    SeaPenTemplateChip.kLettersColor,
                    [
                        {
                            value: SeaPenTemplateOption.kLettersColorPastel,
                            translation: loadTimeData.getString('seaPenOptionLettersColorPastel'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pastel.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersColorBlack,
                            translation: loadTimeData.getString('seaPenOptionLettersColorBlack'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/black.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersColorYellow,
                            translation: loadTimeData.getString('seaPenOptionLettersColorYellow'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersColorRed,
                            translation: loadTimeData.getString('seaPenOptionLettersColorRed'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/red.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersColorBlue,
                            translation: loadTimeData.getString('seaPenOptionLettersColorBlue'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersColorIndigo,
                            translation: loadTimeData.getString('seaPenOptionLettersColorIndigo'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/indigo.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersColorGreen,
                            translation: loadTimeData.getString('seaPenOptionLettersColorGreen'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/green.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersColorCyan,
                            translation: loadTimeData.getString('seaPenOptionLettersColorCyan'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cyan.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersColorPurple,
                            translation: loadTimeData.getString('seaPenOptionLettersColorPurple'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/purple.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersColorOlive,
                            translation: loadTimeData.getString('seaPenOptionLettersColorOlive'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/olive.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersColorGray,
                            translation: loadTimeData.getString('seaPenOptionLettersColorGray'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/gray.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersColorMagenta,
                            translation: loadTimeData.getString('seaPenOptionLettersColorMagenta'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/magenta.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersColorNeonGreen,
                            translation: loadTimeData.getString('seaPenOptionLettersColorNeonGreen'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_green.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersColorLightBlue,
                            translation: loadTimeData.getString('seaPenOptionLettersColorLightBlue'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/light_blue.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersColorNeonPink,
                            translation: loadTimeData.getString('seaPenOptionLettersColorNeonPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_pink.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersColorCoralPink,
                            translation: loadTimeData.getString('seaPenOptionLettersColorCoralPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral_pink.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kLettersLetter,
                    [
                        {
                            value: SeaPenTemplateOption.kLettersLetterA,
                            translation: 'A',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterB,
                            translation: 'B',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterC,
                            translation: 'C',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterD,
                            translation: 'D',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterE,
                            translation: 'E',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterF,
                            translation: 'F',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterG,
                            translation: 'G',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterH,
                            translation: 'H',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterI,
                            translation: 'I',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterJ,
                            translation: 'J',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterK,
                            translation: 'K',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterL,
                            translation: 'L',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterM,
                            translation: 'M',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterN,
                            translation: 'N',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterO,
                            translation: 'O',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterP,
                            translation: 'P',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterQ,
                            translation: 'Q',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterR,
                            translation: 'R',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterS,
                            translation: 'S',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterT,
                            translation: 'T',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterU,
                            translation: 'U',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterV,
                            translation: 'V',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterW,
                            translation: 'W',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterX,
                            translation: 'X',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterY,
                            translation: 'Y',
                        },
                        {
                            value: SeaPenTemplateOption.kLettersLetterZ,
                            translation: 'Z',
                        },
                    ],
                ],
            ]),
        },
        {
            id: SeaPenTemplateId.kCharacters,
            title: loadTimeData.getString('seaPenTemplateTitleCharacters'),
            text: loadTimeData.getStringF('seaPenTemplateCharacters', `<${SeaPenTemplateChip.kCharactersColor}>`, `<${SeaPenTemplateChip.kCharactersSubjects}>`, `<${SeaPenTemplateChip.kCharactersBackground}>`),
            preview: [{
                    url: 'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_characters.jpg',
                }],
            options: new Map([
                [
                    SeaPenTemplateChip.kCharactersColor,
                    [
                        {
                            value: SeaPenTemplateOption.kCharactersColorPink,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorYellow,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorYellow'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorRed,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorRed'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/red.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorBlue,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorBlue'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorIndigo,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorIndigo'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/indigo.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorGreen,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorGreen'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/green.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorCyan,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorCyan'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cyan.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorPurple,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorPurple'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/purple.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorBrown,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorBrown'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/brown.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorGold,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorGold'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/gold.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorRust,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorRust'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/rust.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorOlive,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorOlive'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/olive.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorGray,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorGray'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/gray.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorWhite,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorWhite'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/white.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorBeige,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorBeige'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/beige.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorMagenta,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorMagenta'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/magenta.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorNeonGreen,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorNeonGreen'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_green.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorLightBlue,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorLightBlue'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/light_blue.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorNeonPink,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorNeonPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_pink.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersColorCoralPink,
                            translation: loadTimeData.getString('seaPenOptionCharactersColorCoralPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral_pink.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kCharactersSubjects,
                    [
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsLemons,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsLemons'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lemons.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsFlowers,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsFlowers'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/flowers.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsApples,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsApples'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/apples.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsCherries,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsCherries'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cherries.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsOranges,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsOranges'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/oranges.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsPineapples,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsPineapples'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pineapples.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsStrawberries,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsStrawberries'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/strawberries.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsWatermelons,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsWatermelons'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/watermelons.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsPotatoes,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsPotatoes'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/potatoes.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsSushi,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsSushi'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sushi.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsBaconAndEggs,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsBaconAndEggs'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bacon_and_eggs.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsPizza,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsPizza'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pizza.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsHotDogs,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsHotDogs'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/hot_dogs.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsHamburgers,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsHamburgers'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/hamburgers.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsRamen,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsRamen'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/ramen.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsTacos,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsTacos'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/tacos.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsBunnies,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsBunnies'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bunnies.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsCats,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsCats'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/rectangle_3471020.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsDogs,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsDogs'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/dogs.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsKoalas,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsKoalas'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/koalas.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsPandas,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsPandas'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pandas.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsPenguins,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsPenguins'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/penguins.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsPigs,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsPigs'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pigs.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsSloths,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsSloths'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sloths.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsPonies,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsPonies'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/ponies.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsElephants,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsElephants'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/elephants.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsFoxes,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsFoxes'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/foxes.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsOwls,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsOwls'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/owls.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsCrabs,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsCrabs'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/crabs.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsBees,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsBees'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bees.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsButterflies,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsButterflies'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/butterflies.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsBicycles,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsBicycles'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bicycles.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsBoats,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsBoats'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/boats.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsBooks,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsBooks'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/books.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsCutlery,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsCutlery'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cutlery.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsUmbrellas,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsUmbrellas'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/umbrellas.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersSubjectsInstruments,
                            translation: loadTimeData.getString('seaPenOptionCharactersSubjectsInstruments'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/musical_instruments.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kCharactersBackground,
                    [
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundPurple,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundPurple'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/purple.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundBlue,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundBlue'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundIndigo,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundIndigo'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/indigo.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundGreen,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundGreen'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/green.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundCyan,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundCyan'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cyan.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundBrown,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundBrown'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/brown.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundGold,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundGold'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/gold.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundRed,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundRed'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/red.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundRust,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundRust'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/rust.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundOlive,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundOlive'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/olive.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundPink,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundGray,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundGray'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/gray.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundYellow,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundYellow'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundWhite,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundWhite'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/white.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundBeige,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundBeige'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/beige.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundMagenta,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundMagenta'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/magenta.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundNeonGreen,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundNeonGreen'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_green.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundLightBlue,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundLightBlue'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/light_blue.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundNeonPink,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundNeonPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_pink.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kCharactersBackgroundCoralPink,
                            translation: loadTimeData.getString('seaPenOptionCharactersBackgroundCoralPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral_pink.jpg',
                        },
                    ],
                ],
            ]),
        },
        {
            id: SeaPenTemplateId.kFlower,
            title: loadTimeData.getString('seaPenTemplateTitleFlower'),
            text: loadTimeData.getStringF('seaPenTemplateFlower', `<${SeaPenTemplateChip.kFlowerColor}>`, `<${SeaPenTemplateChip.kFlowerType}>`),
            preview: [{
                    url: 'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_flower.jpg',
                }],
            options: new Map([
                [
                    SeaPenTemplateChip.kFlowerColor,
                    [
                        {
                            value: SeaPenTemplateOption.kFlowerColorPink,
                            translation: loadTimeData.getString('seaPenOptionFlowerColorPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kFlowerColorPurple,
                            translation: loadTimeData.getString('seaPenOptionFlowerColorPurple'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/purple.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kFlowerColorBlue,
                            translation: loadTimeData.getString('seaPenOptionFlowerColorBlue'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kFlowerColorWhite,
                            translation: loadTimeData.getString('seaPenOptionFlowerColorWhite'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/white.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kFlowerColorCoral,
                            translation: loadTimeData.getString('seaPenOptionFlowerColorCoral'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kFlowerColorYellow,
                            translation: loadTimeData.getString('seaPenOptionFlowerColorYellow'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kFlowerColorGreen,
                            translation: loadTimeData.getString('seaPenOptionFlowerColorGreen'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/green.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kFlowerColorRed,
                            translation: loadTimeData.getString('seaPenOptionFlowerColorRed'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/red.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kFlowerType,
                    [
                        {
                            value: SeaPenTemplateOption.kFlowerTypeOrchid,
                            translation: loadTimeData.getString('seaPenOptionFlowerTypeOrchid'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/orchid.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kFlowerTypeTulip,
                            translation: loadTimeData.getString('seaPenOptionFlowerTypeTulip'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/tulip.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kFlowerTypeBirdOfParadise,
                            translation: loadTimeData.getString('seaPenOptionFlowerTypeBirdOfParadise'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bird_of_paradise.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kFlowerTypeRose,
                            translation: loadTimeData.getString('seaPenOptionFlowerTypeRose'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/garden_rose.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kFlowerTypeDaisy,
                            translation: loadTimeData.getString('seaPenOptionFlowerTypeDaisy'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/daisy.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kFlowerTypeHydrangea,
                            translation: loadTimeData.getString('seaPenOptionFlowerTypeHydrangea'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/hydrangea.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kFlowerTypeSucculent,
                            translation: loadTimeData.getString('seaPenOptionFlowerTypeSucculent'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/succulent.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kFlowerTypeGrass,
                            translation: loadTimeData.getString('seaPenOptionFlowerTypeGrass'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/grass.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kFlowerTypeCactusFlower,
                            translation: loadTimeData.getString('seaPenOptionFlowerTypeCactusFlower'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cactus_flower.jpg',
                        },
                    ],
                ],
            ]),
        },
    ];
}
function getVcBackgroundTemplates() {
    return [
        {
            id: SeaPenTemplateId.kVcBackgroundSimple,
            title: loadTimeData.getString('seaPenTemplateTitleVcBackgroundSimple'),
            text: loadTimeData.getStringF('seaPenTemplateVcBackgroundSimple', `<${SeaPenTemplateChip.kVcBackgroundSimpleStyle}>`, `<${SeaPenTemplateChip.kVcBackgroundSimpleTone}>`),
            preview: [{
                    url: 'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_simple.jpg',
                }],
            options: new Map([
                [
                    SeaPenTemplateChip.kVcBackgroundSimpleStyle,
                    [
                        {
                            value: SeaPenTemplateOption.kVcBackgroundSimpleStyleMinimal,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundSimpleStyleMinimal'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/minimal.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundSimpleStyleZen,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundSimpleStyleZen'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/zen.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundSimpleStyleModern,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundSimpleStyleModern'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/modern.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundSimpleStyleMagical,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundSimpleStyleMagical'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/magical.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kVcBackgroundSimpleTone,
                    [
                        {
                            value: SeaPenTemplateOption.kVcBackgroundSimpleToneNeutral,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundSimpleToneNeutral'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neutral.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundSimpleToneDark,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundSimpleToneDark'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/dark.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundSimpleToneLight,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundSimpleToneLight'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/light.jpg',
                        },
                    ],
                ],
            ]),
        },
        {
            id: SeaPenTemplateId.kVcBackgroundOffice,
            title: loadTimeData.getString('seaPenTemplateTitleVcBackgroundOffice'),
            text: loadTimeData.getStringF('seaPenTemplateVcBackgroundOffice', `<${SeaPenTemplateChip.kVcBackgroundOfficeStyle}>`, `<${SeaPenTemplateChip.kVcBackgroundOfficeColor}>`),
            preview: [{
                    url: 'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_office.jpg',
                }],
            options: new Map([
                [
                    SeaPenTemplateChip.kVcBackgroundOfficeStyle,
                    [
                        {
                            value: SeaPenTemplateOption.kVcBackgroundOfficeStyleModern,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundOfficeStyleModern'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/modern.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundOfficeStyleCreative,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundOfficeStyleCreative'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/creative.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundOfficeStyleTraditional,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundOfficeStyleTraditional'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/traditional.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundOfficeStyleFuturistic,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundOfficeStyleFuturistic'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/futuristic.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kVcBackgroundOfficeColor,
                    [
                        {
                            value: SeaPenTemplateOption.kVcBackgroundOfficeColorNeutral,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundOfficeColorNeutral'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neutral.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundOfficeColorDark,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundOfficeColorDark'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/dark.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundOfficeColorColorful,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundOfficeColorColorful'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/colorful.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundOfficeColorEarthy,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundOfficeColorEarthy'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/earthy.jpg',
                        },
                    ],
                ],
            ]),
        },
        {
            id: SeaPenTemplateId.kVcBackgroundTerrainVc,
            title: loadTimeData.getString('seaPenTemplateTitleVcBackgroundTerrainVc'),
            text: loadTimeData.getStringF('seaPenTemplateVcBackgroundTerrainVc', `<${SeaPenTemplateChip.kVcBackgroundTerrainFeature}>`, `<${SeaPenTemplateChip.kVcBackgroundTerrainColor}>`),
            preview: [{
                    url: 'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_terrain_vc.jpg',
                }],
            options: new Map([
                [
                    SeaPenTemplateChip.kVcBackgroundTerrainFeature,
                    [
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainFeatureSaltLake,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainFeatureSaltLake'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/salt_lake.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainFeatureRiver,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainFeatureRiver'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/glacial_river.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundTerrainFeatureNorthernLights,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainFeatureNorthernLights'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/northern_lights.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainFeatureSandDunes,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainFeatureSandDunes'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sand_dune.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainFeatureClayHills,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainFeatureClayHills'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/clay_hills.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainFeatureSandyLagoon,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainFeatureSandyLagoon'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sandy_lagoon.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainFeatureMountains,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainFeatureMountains'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/mountain.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundTerrainFeatureBioluminescentBeach,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainFeatureBioluminescentBeach'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bioluminescent_beach.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainFeatureFireflyForest,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainFeatureFireflyForest'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/firefly_forest.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundTerrainFeatureDifferentPlanet,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainFeatureDifferentPlanet'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/different_planet.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainFeatureTreeTunnel,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainFeatureTreeTunnel'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/tree_tunnel.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainFeatureBaobabTrees,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainFeatureBaobabTrees'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/baobab_trees.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainFeatureMistyForest,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainFeatureMistyForest'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/misty_forest.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainFeatureCactusForest,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainFeatureCactusForest'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cactus_forest.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kVcBackgroundTerrainColor,
                    [
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainColorPink,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainColorPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainColorCyan,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainColorCyan'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cyan.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainColorWhite,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainColorWhite'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/white.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainColorPurple,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainColorPurple'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/purple.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainColorBlue,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainColorBlue'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainColorYellow,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainColorYellow'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainColorMaroonPink,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainColorMaroonPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/maroon_pink.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainColorBluePurple,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainColorBluePurple'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue_purple.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainColorPinkYellow,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainColorPinkYellow'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink_yellow.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundTerrainColorBluePink,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundTerrainColorBluePink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue_pink.jpg',
                        },
                    ],
                ],
            ]),
        },
        {
            id: SeaPenTemplateId.kVcBackgroundCafe,
            title: loadTimeData.getString('seaPenTemplateTitleVcBackgroundCafe'),
            text: loadTimeData.getStringF('seaPenTemplateVcBackgroundCafe', `<${SeaPenTemplateChip.kVcBackgroundCafeStyle}>`, `<${SeaPenTemplateChip.kVcBackgroundCafeType}>`),
            preview: [{
                    url: 'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_cafe.jpg',
                }],
            options: new Map([
                [
                    SeaPenTemplateChip.kVcBackgroundCafeStyle,
                    [
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCafeStyleCozy,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCafeStyleCozy'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cozy.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCafeStyleNeutral,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCafeStyleNeutral'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neutral.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCafeStyleDistressed,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCafeStyleDistressed'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/distressed.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCafeStyleClassic,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCafeStyleClassic'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/classic.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCafeStyleRomantic,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCafeStyleRomantic'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/romantic.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kVcBackgroundCafeType,
                    [
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCafeTypeCottage,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCafeTypeCottage'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cottage.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCafeTypeModern,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCafeTypeModern'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/modern.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCafeTypeTeaHouse,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCafeTypeTeaHouse'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/tea_house.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCafeTypeHighTea,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCafeTypeHighTea'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/high_tea.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCafeTypeOutdoor,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCafeTypeOutdoor'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/outdoor.jpg',
                        },
                    ],
                ],
            ]),
        },
        {
            id: SeaPenTemplateId.kVcBackgroundArt,
            title: loadTimeData.getString('seaPenTemplateTitleVcBackgroundArt'),
            text: loadTimeData.getStringF('seaPenTemplateVcBackgroundArt', `<${SeaPenTemplateChip.kVcBackgroundArtFeature}>`, `<${SeaPenTemplateChip.kVcBackgroundArtMovement}>`),
            preview: [{
                    url: 'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_art.jpg',
                }],
            options: new Map([
                [
                    SeaPenTemplateChip.kVcBackgroundArtFeature,
                    [
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureField,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureField'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/field_of_flowers.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureSwamp,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureSwamp'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/swamp.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureBeach,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureBeach'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/beach.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureMeadow,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureMeadow'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/meadow.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureForest,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureForest'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/forest.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureGlacier,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureGlacier'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/glacier.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureIsland,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureIsland'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/island.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureJungle,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureJungle'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/jungle.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureLake,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureLake'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lake.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureCliff,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureCliff'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cliff.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureOcean,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureOcean'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/ocean.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureRiver,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureRiver'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/river.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureDune,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureDune'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sand_dune.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureMountain,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureMountain'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/mountain.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureValley,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureValley'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/valley.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureWaterfall,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureWaterfall'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/waterfall.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureCanyon,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureCanyon'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/canyon.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureCityscape,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureCityscape'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cityscape.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtFeatureVillage,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtFeatureVillage'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/mediterranean_village.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kVcBackgroundArtMovement,
                    [
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtMovementAvantGarde,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtMovementAvantGarde'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/avant-garde.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtMovementRealist,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtMovementRealist'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/realist.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtMovementExpressionist,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtMovementExpressionist'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/expressionist.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtMovementImpressionist,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtMovementImpressionist'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/impressionist.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundArtMovementPostImpressionist,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtMovementPostImpressionist'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/post-impressionist.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtMovementArtNouveau,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtMovementArtNouveau'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/art_nouveau.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtMovementBauhaus,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtMovementBauhaus'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bauhaus.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtMovementClassicist,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtMovementClassicist'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/classicist.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtMovementWatercolor,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtMovementWatercolor'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/watercolor.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtMovementAbstract,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtMovementAbstract'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/abstract.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtMovementGraphicDesign,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtMovementGraphicDesign'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/graphic.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtMovementModernArt,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtMovementModernArt'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/modern_art.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtMovementAnime,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtMovementAnime'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/anime.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtMovementPixelArt,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtMovementPixelArt'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pixel_art.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundArtMovementCyberpunk,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundArtMovementCyberpunk'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cyberpunk.jpg',
                        },
                    ],
                ],
            ]),
        },
        {
            id: SeaPenTemplateId.kVcBackgroundDreamscapesVc,
            title: loadTimeData.getString('seaPenTemplateTitleVcBackgroundDreamscapesVc'),
            text: loadTimeData.getStringF('seaPenTemplateVcBackgroundDreamscapesVc', `<${SeaPenTemplateChip.kVcBackgroundDreamscapesObject}>`, `<${SeaPenTemplateChip.kVcBackgroundDreamscapesMaterial}>`, `<${SeaPenTemplateChip.kVcBackgroundDreamscapesColors}>`),
            preview: [{
                    url: 'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_dreamscapes_vc.jpg',
                }],
            options: new Map([
                [
                    SeaPenTemplateChip.kVcBackgroundDreamscapesObject,
                    [
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectBicycle,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesObjectBicycle'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bicycle.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectCastle,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesObjectCastle'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/castle.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectBuilding,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesObjectBuilding'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/building.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectBoat,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesObjectBoat'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/boat.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectLamp,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesObjectLamp'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lamp.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectTable,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesObjectTable'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/table.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectBridge,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesObjectBridge'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bridge.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectLighthouse,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesObjectLighthouse'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lighthouse.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectPagoda,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesObjectPagoda'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pagoda.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectPalace,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesObjectPalace'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/palace.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectTower,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesObjectTower'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/tower.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesObjectChair,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesObjectChair'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/chair.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kVcBackgroundDreamscapesMaterial,
                    [
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialFlowers,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialFlowers'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/flowers.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialSilk,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialSilk'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/silk.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialFelt,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialFelt'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/felt.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialBurlap,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialBurlap'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/burlap.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialChiffon,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialChiffon'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/chiffon.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialCotton,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialCotton'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cotton.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialFur,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialFur'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/fur.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialLace,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialLace'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lace.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialLinen,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialLinen'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/linen.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialOrganza,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialOrganza'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/organza.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialTulle,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialTulle'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/tulle.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialWool,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialWool'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/wool.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialYarn,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialYarn'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yarn.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialFleece,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialFleece'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/fleece.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialClay,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialClay'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/clay.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialStone,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialStone'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/stone.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialWood,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialWood'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/wood.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialAmethyst,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialAmethyst'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/amethyst.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundDreamscapesMaterialLapisLuzuli,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialLapisLuzuli'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lapis_luzuli.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialObsidian,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialObsidian'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/obsidian.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialOpal,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialOpal'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/opal.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesMaterialSapphire,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesMaterialSapphire'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sapphire.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kVcBackgroundDreamscapesColors,
                    [
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesColorsPinkPurple,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesColorsPinkPurple'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink_purple.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesColorsCoralTan,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesColorsCoralTan'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral_tan.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundDreamscapesColorsCreamOrange,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesColorsCreamOrange'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cream_orange.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesColorsBlueIndigo,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesColorsBlueIndigo'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue_indigo.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesColorsGreenTeal,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesColorsGreenTeal'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/green_teal.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundDreamscapesColorsBurgundyMaroon,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesColorsBurgundyMaroon'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/burgundy_maroon.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundDreamscapesColorsYellowTeal,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundDreamscapesColorsYellowTeal'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow_teal.jpg',
                        },
                    ],
                ],
            ]),
        },
        {
            id: SeaPenTemplateId.kVcBackgroundCharacters,
            title: loadTimeData.getString('seaPenTemplateTitleVcBackgroundCharacters'),
            text: loadTimeData.getStringF('seaPenTemplateVcBackgroundCharacters', `<${SeaPenTemplateChip.kVcBackgroundCharactersColor}>`, `<${SeaPenTemplateChip.kVcBackgroundCharactersSubjects}>`, `<${SeaPenTemplateChip.kVcBackgroundCharactersBackground}>`),
            preview: [{
                    url: 'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_characters.jpg',
                }],
            options: new Map([
                [
                    SeaPenTemplateChip.kVcBackgroundCharactersColor,
                    [
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorPink,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorYellow,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorYellow'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorRed,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorRed'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/red.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorBlue,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorBlue'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorIndigo,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorIndigo'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/indigo.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorGreen,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorGreen'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/green.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorCyan,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorCyan'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cyan.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorPurple,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorPurple'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/purple.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorBrown,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorBrown'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/brown.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorGold,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorGold'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/gold.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorRust,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorRust'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/rust.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorOlive,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorOlive'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/olive.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorGray,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorGray'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/gray.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorWhite,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorWhite'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/white.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorBeige,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorBeige'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/beige.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorMagenta,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorMagenta'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/magenta.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorNeonGreen,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorNeonGreen'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_green.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorLightBlue,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorLightBlue'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/light_blue.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorNeonPink,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorNeonPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_pink.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersColorCoralPink,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersColorCoralPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral_pink.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kVcBackgroundCharactersSubjects,
                    [
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsLemons,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsLemons'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/lemons.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsFlowers,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsFlowers'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/flowers.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsApples,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsApples'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/apples.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsCherries,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsCherries'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cherries.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsOranges,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsOranges'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/oranges.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundCharactersSubjectsPineapples,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsPineapples'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pineapples.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundCharactersSubjectsStrawberries,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsStrawberries'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/strawberries.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundCharactersSubjectsWatermelons,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsWatermelons'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/watermelons.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsPotatoes,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsPotatoes'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/potatoes.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsSushi,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsSushi'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sushi.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundCharactersSubjectsBaconAndEggs,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsBaconAndEggs'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bacon_and_eggs.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsPizza,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsPizza'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pizza.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsHotDogs,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsHotDogs'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/hot_dogs.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundCharactersSubjectsHamburgers,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsHamburgers'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/hamburgers.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsRamen,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsRamen'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/ramen.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsTacos,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsTacos'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/tacos.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsBunnies,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsBunnies'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bunnies.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsCats,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsCats'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/rectangle_3471020.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsDogs,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsDogs'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/dogs.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsKoalas,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsKoalas'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/koalas.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsPandas,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsPandas'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pandas.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsPenguins,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsPenguins'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/penguins.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsPigs,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsPigs'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pigs.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsSloths,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsSloths'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/sloths.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsPonies,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsPonies'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/ponies.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsElephants,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsElephants'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/elephants.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsFoxes,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsFoxes'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/foxes.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsOwls,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsOwls'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/owls.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsCrabs,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsCrabs'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/crabs.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsBees,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsBees'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bees.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundCharactersSubjectsButterflies,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsButterflies'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/butterflies.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsBicycles,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsBicycles'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/bicycles.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsBoats,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsBoats'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/boats.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsBooks,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsBooks'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/books.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsCutlery,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsCutlery'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cutlery.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersSubjectsUmbrellas,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsUmbrellas'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/umbrellas.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundCharactersSubjectsInstruments,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersSubjectsInstruments'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/musical_instruments.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kVcBackgroundCharactersBackground,
                    [
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundPurple,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundPurple'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/purple.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundBlue,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundBlue'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/blue.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundIndigo,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundIndigo'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/indigo.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundGreen,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundGreen'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/green.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundCyan,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundCyan'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/cyan.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundBrown,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundBrown'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/brown.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundGold,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundGold'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/gold.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundRed,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundRed'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/red.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundRust,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundRust'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/rust.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundOlive,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundOlive'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/olive.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundPink,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pink.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundGray,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundGray'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/gray.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundYellow,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundYellow'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/yellow.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundWhite,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundWhite'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/white.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundBeige,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundBeige'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/beige.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundCharactersBackgroundMagenta,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundMagenta'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/magenta.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundCharactersBackgroundNeonGreen,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundNeonGreen'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_green.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundCharactersBackgroundLightBlue,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundLightBlue'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/light_blue.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundCharactersBackgroundNeonPink,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundNeonPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/neon_pink.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundCharactersBackgroundCoralPink,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundCharactersBackgroundCoralPink'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral_pink.jpg',
                        },
                    ],
                ],
            ]),
        },
        {
            id: SeaPenTemplateId.kVcBackgroundGlowscapes,
            title: loadTimeData.getString('seaPenTemplateTitleVcBackgroundGlowscapes'),
            text: loadTimeData.getStringF('seaPenTemplateVcBackgroundGlowscapes', `<${SeaPenTemplateChip.kVcBackgroundGlowscapesLandscape}>`, `<${SeaPenTemplateChip.kVcBackgroundGlowscapesFeature}>`),
            preview: [{
                    url: 'chrome://resources/ash/common/sea_pen/sea_pen_images/sea_pen_glowscapes.jpg',
                }],
            options: new Map([
                [
                    SeaPenTemplateChip.kVcBackgroundGlowscapesLandscape,
                    [
                        {
                            value: SeaPenTemplateOption.kVcBackgroundGlowscapesLandscapeValley,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundGlowscapesLandscapeValley'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/valley.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundGlowscapesLandscapeHotSpring,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundGlowscapesLandscapeHotSpring'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/hot_spring.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundGlowscapesLandscapeMeadow,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundGlowscapesLandscapeMeadow'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/meadow.jpg',
                        },
                        {
                            value: SeaPenTemplateOption
                                .kVcBackgroundGlowscapesLandscapeCoralReef,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundGlowscapesLandscapeCoralReef'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/coral_reef.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundGlowscapesLandscapePond,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundGlowscapesLandscapePond'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pond.jpg',
                        },
                    ],
                ],
                [
                    SeaPenTemplateChip.kVcBackgroundGlowscapesFeature,
                    [
                        {
                            value: SeaPenTemplateOption.kVcBackgroundGlowscapesFeatureRiver,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundGlowscapesFeatureRiver'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/river.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundGlowscapesFeatureSaltRock,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundGlowscapesFeatureSaltRock'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/salt_rock.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundGlowscapesFeatureFlower,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundGlowscapesFeatureFlower'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/flower.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundGlowscapesFeatureWalkway,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundGlowscapesFeatureWalkway'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/walkway.jpg',
                        },
                        {
                            value: SeaPenTemplateOption.kVcBackgroundGlowscapesFeaturePool,
                            translation: loadTimeData.getString('seaPenOptionVcBackgroundGlowscapesFeaturePool'),
                            previewUrl: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/pool.jpg',
                        },
                    ],
                ],
            ]),
        },
    ];
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const QUERY = 'Query';
/** Enumeration of supported tabs. */
var FreeformTab;
(function (FreeformTab) {
    FreeformTab["SAMPLE_PROMPTS"] = "sample_prompts";
    FreeformTab["RESULTS"] = "results";
})(FreeformTab || (FreeformTab = {}));
function getSeaPenTemplates() {
    const templates = window.location.origin === 'chrome://personalization' ?
        getWallpaperTemplates() :
        getVcBackgroundTemplates();
    return templates;
}
/**
 * Split the template string into an array of strings, where each string is
 * either a literal string or a placeholder for a chip.
 * @example
 * // returns ['A park in', '<city>', 'in the style of', '<style>']
 * parseTemplateText('A park in <city> in the style of <style>');
 */
function parseTemplateText(template) {
    return template.split(/(<\w+>)/g)
        .filter(function (entry) {
        return entry.trim() != '';
    })
        .map(entry => entry.trim());
}
const SEA_PEN_SUGGESTIONS = [
    'seaPenFreeformSuggestion4K',
    'seaPenFreeformSuggestionRealisticPhoto',
    'seaPenFreeformSuggestionSurreal',
    'seaPenFreeformSuggestionBeautiful',
    'seaPenFreeformSuggestionMinimal',
    'seaPenFreeformSuggestionSunset',
    'seaPenFreeformSuggestionPastelColors',
    'seaPenFreeformSuggestionGlowing',
    'seaPenFreeformSuggestionStarFilledSky',
    'seaPenFreeformSuggestionDramaticShadows',
    'seaPenFreeformSuggestionCoveredInSnow',
    'seaPenFreeformSuggestionBioluminescent',
    'seaPenFreeformSuggestionLongExposure',
    'seaPenFreeformSuggestionFoggy',
    'seaPenFreeformSuggestionGalaxy',
    'seaPenFreeformSuggestionNeonLights',
    'seaPenFreeformSuggestionReflections',
    'seaPenFreeformSuggestionLightning',
    'seaPenFreeformSuggestionBokehEffect',
    'seaPenFreeformSuggestionWithColorGrading',
    'seaPenFreeformSuggestionVolumetricLight',
    'seaPenFreeformSuggestionNegativeSpace',
    'seaPenFreeformSuggestionDigitalArt',
    'seaPenFreeformSuggestionTRex',
    'seaPenFreeformSuggestionUnicorn',
    'seaPenFreeformSuggestionCats',
    'seaPenFreeformSuggestionVectorArtStyle',
    'seaPenFreeformSuggestion3DRender',
];
// These values are used for metrics; do not change or reuse values.
var SeaPenSamplePromptId;
(function (SeaPenSamplePromptId) {
    SeaPenSamplePromptId[SeaPenSamplePromptId["CHROME_SPHERES"] = 0] = "CHROME_SPHERES";
    SeaPenSamplePromptId[SeaPenSamplePromptId["GALAXY_WITH_SPACESHIP"] = 1] = "GALAXY_WITH_SPACESHIP";
    SeaPenSamplePromptId[SeaPenSamplePromptId["CAT_RIDING_UNICORN"] = 2] = "CAT_RIDING_UNICORN";
    SeaPenSamplePromptId[SeaPenSamplePromptId["ANIMATED_FLOWERS"] = 3] = "ANIMATED_FLOWERS";
    SeaPenSamplePromptId[SeaPenSamplePromptId["LILY_IN_RAIN"] = 4] = "LILY_IN_RAIN";
    // Value 5 is deprecated.
    SeaPenSamplePromptId[SeaPenSamplePromptId["DALMATION"] = 6] = "DALMATION";
    SeaPenSamplePromptId[SeaPenSamplePromptId["DELOREAN"] = 7] = "DELOREAN";
    SeaPenSamplePromptId[SeaPenSamplePromptId["BLACK_MOTORCYCLE"] = 8] = "BLACK_MOTORCYCLE";
    SeaPenSamplePromptId[SeaPenSamplePromptId["SPACESHIP_OVER_CITY"] = 9] = "SPACESHIP_OVER_CITY";
    SeaPenSamplePromptId[SeaPenSamplePromptId["CAT_ON_WINDOWSILL"] = 10] = "CAT_ON_WINDOWSILL";
    SeaPenSamplePromptId[SeaPenSamplePromptId["BIOLUMINESCENT_BEACH"] = 11] = "BIOLUMINESCENT_BEACH";
    SeaPenSamplePromptId[SeaPenSamplePromptId["BLACK_SAND_DUNES"] = 12] = "BLACK_SAND_DUNES";
    SeaPenSamplePromptId[SeaPenSamplePromptId["TREE_MADE_OF_STARS"] = 13] = "TREE_MADE_OF_STARS";
    SeaPenSamplePromptId[SeaPenSamplePromptId["MOON_OVER_LAKE"] = 14] = "MOON_OVER_LAKE";
    SeaPenSamplePromptId[SeaPenSamplePromptId["MARBLE_ARCH"] = 15] = "MARBLE_ARCH";
    SeaPenSamplePromptId[SeaPenSamplePromptId["STEAMPUNK_SPACESHIP"] = 16] = "STEAMPUNK_SPACESHIP";
    SeaPenSamplePromptId[SeaPenSamplePromptId["WHITE_TIGER"] = 17] = "WHITE_TIGER";
    SeaPenSamplePromptId[SeaPenSamplePromptId["ANIME_PATH_OVERLOOKING_OCEAN"] = 18] = "ANIME_PATH_OVERLOOKING_OCEAN";
    SeaPenSamplePromptId[SeaPenSamplePromptId["PAPAVER_RHEA_STEMS"] = 19] = "PAPAVER_RHEA_STEMS";
    SeaPenSamplePromptId[SeaPenSamplePromptId["METEOR_SHOWER"] = 20] = "METEOR_SHOWER";
    SeaPenSamplePromptId[SeaPenSamplePromptId["MAX_VALUE"] = 20] = "MAX_VALUE";
})(SeaPenSamplePromptId || (SeaPenSamplePromptId = {}));
const SEA_PEN_SAMPLES = [
    {
        id: SeaPenSamplePromptId.CHROME_SPHERES,
        prompt: 'seaPenFreeformSampleChromeSpheres',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/3d_rendering_of_chrome_spheres.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.GALAXY_WITH_SPACESHIP,
        prompt: 'seaPenFreeformSampleGalaxyWithSpaceship',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/a_beautiful_cosmic_nebula_galaxy_with_a_fast_futuristic_spaceship.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.CAT_RIDING_UNICORN,
        prompt: 'seaPenFreeformSampleCatRidingUnicorn',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/a_cat_playing_a_flying_v_while_riding_a_unicorn.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.ANIMATED_FLOWERS,
        prompt: 'seaPenFreeformSampleAnimatedFlowers',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/a_close_up_of_several_white_and_yellow_flowers.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.LILY_IN_RAIN,
        prompt: 'seaPenFreeformSampleLilyInRain',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/a_closeup_of_an_intricate_dew-covered_pond_lily.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.DALMATION,
        prompt: 'seaPenFreeformSampleDalmation',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/a_dalmatian_dog.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.DELOREAN,
        prompt: 'seaPenFreeformSampleDelorean',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/a_delorean_with_neon_lights.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.BLACK_MOTORCYCLE,
        prompt: 'seaPenFreeformSampleBlackMotorcycle',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/a_futuristic_motorcycle_made_of_black_paper.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.SPACESHIP_OVER_CITY,
        prompt: 'seaPenFreeformSampleSpaceshipOverCity',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/a_huge_spaceship_floats_over_the_city.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.CAT_ON_WINDOWSILL,
        prompt: 'seaPenFreeformSampleCatOnWindowsill',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/a_japanese_animation_illustration_of_a_cat_sitting.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.BIOLUMINESCENT_BEACH,
        prompt: 'seaPenFreeformSampleBioluminescentBeach',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/a_long_exposure_photo_of_a_bioluminescent_beach.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.BLACK_SAND_DUNES,
        prompt: 'seaPenFreeformSampleBlackSandDunes',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/a_minimal_professional_photo_of_glittery_black_sand.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.TREE_MADE_OF_STARS,
        prompt: 'seaPenFreeformSampleTreeMadeOfStars',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/a_photo_of_a_tree_made_of_stars.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.MOON_OVER_LAKE,
        prompt: 'seaPenFreeformSampleMoonOverLake',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/a_photograph_of_a_moon_over_a_lake.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.MARBLE_ARCH,
        prompt: 'seaPenFreeformSampleMarbleArch',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/a_piece_of_white_organza_floating_in_the_middle.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.STEAMPUNK_SPACESHIP,
        prompt: 'seaPenFreeformSampleSteampunkSpaceship',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/a_steampunk_space_ship_flying_through.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.WHITE_TIGER,
        prompt: 'seaPenFreeformSampleWhiteTiger',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/a_surreal_white_tiger_with_gold_eyes.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.ANIME_PATH_OVERLOOKING_OCEAN,
        prompt: 'seaPenFreeformSampleAnimePathOverlookingOcean',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/anime_path_overlooking_the_ocean.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.PAPAVER_RHEA_STEMS,
        prompt: 'seaPenFreeformSamplePapaverRheaStems',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/minimal_still_life_of_a_few_Papaver_rhea_stems.jpeg',
        },
    },
    {
        id: SeaPenSamplePromptId.METEOR_SHOWER,
        prompt: 'seaPenFreeformSampleMeteorShower',
        preview: {
            url: 'https://www.gstatic.com/chromecast/home/chromeos/sea_pen/freeform/photo_of_a_night_sky_with_a_meteor_shower.jpeg',
        },
    },
];

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Returns true if `maybeUrl` is a valid Url.
function isUrl(maybeUrl) {
    return !!maybeUrl && typeof maybeUrl === 'object' && 'url' in maybeUrl &&
        typeof maybeUrl.url === 'string';
}
// Returns true if `maybeDataUrl` is a Url that contains a base64 encoded image.
function isImageDataUrl(maybeDataUrl) {
    return maybeDataUrl.url.startsWith('data:image/png;base64') ||
        maybeDataUrl.url.startsWith('data:image/jpeg;base64');
}
// SeaPenImageId must always be a positive
function isSeaPenImageId(maybeSeaPenImageId) {
    return typeof maybeSeaPenImageId === 'number' &&
        Number.isInteger(maybeSeaPenImageId) && maybeSeaPenImageId >= 0;
}
// Returns true if `maybeArray` is an array with at least one item.
function isNonEmptyArray(maybeArray) {
    return Array.isArray(maybeArray) && maybeArray.length > 0;
}
// Returns true is `obj` is a FilePath with a non-empty path.
function isNonEmptyFilePath(obj) {
    return !!obj && typeof obj === 'object' && 'path' in obj &&
        typeof obj.path === 'string' && !!obj.path;
}
/**
 * Returns a random number between [0, max).
 */
function getRandomInt(max) {
    return Math.floor(Math.random() * max);
}
function isChip(word) {
    return !!word && word.startsWith('<') && word.endsWith('>');
}
function toChip(word) {
    return parseInt(word.slice(1, -1));
}
/**
 * Returns the default mapping of chip to option for the template.
 * Randomly picks the option if `random` is true.
 */
function getDefaultOptions(template, random = false) {
    const selectedOptions = new Map();
    template.options.forEach((options, chip) => {
        if (isNonEmptyArray(options)) {
            let option = options[0];
            if (random) {
                option = options[getRandomInt(options.length)];
            }
            selectedOptions.set(chip, option);
        }
        else {
            console.warn('empty options for', template.id);
        }
    });
    return selectedOptions;
}
/**
 * Separates a template into tokens that can be displayed on the UI.
 */
function getTemplateTokens(template, selectedOptions) {
    const strs = parseTemplateText(template.text);
    return strs.map(str => {
        if (isChip(str)) {
            const templateChip = toChip(str);
            return {
                translation: selectedOptions.get(templateChip)?.translation || '',
                id: templateChip,
            };
        }
        else {
            return str;
        }
    });
}
/**
 * Get the selected template options map from the options information in
 * SeaPenQuery `query` and SeaPenTemplate `template`.
 */
function getSelectedOptionsFromQuery(query, template) {
    if (!query || query.textQuery) {
        return null;
    }
    const templateId = query.templateQuery?.id;
    assert$1(templateId === template.id, 'template id should match');
    // Update the selected options to match with current Sea Pen query.
    const options = query.templateQuery?.options;
    const newSelectedOptions = new Map();
    for (const [key, value] of Object.entries(options ?? new Map())) {
        const chip = parseInt(key);
        const chipOptions = template.options.get(chip);
        const selectedChipOption = chipOptions?.find((option) => option.value === value);
        if (selectedChipOption) {
            newSelectedOptions.set(chip, selectedChipOption);
        }
    }
    return newSelectedOptions;
}
/**
 * Checks whether a Sea Pen query is active. Freeform query is active by
 * default. Template query should have active template and chip options.
 */
function isActiveSeaPenQuery(query) {
    if (!query) {
        return false;
    }
    if (query.textQuery) {
        return true;
    }
    const template = getSeaPenTemplates().find((seaPenTemplate) => seaPenTemplate.id === query.templateQuery?.id);
    const options = query.templateQuery?.options;
    if (!template || !options) {
        return false;
    }
    const isActive = Object.entries(options).every(([key, value]) => {
        const chip = parseInt(key);
        const activeOptions = template.options.get(chip);
        return !!activeOptions && activeOptions.some(opt => opt.value === value);
    });
    return isActive;
}
/**
 * Get the user visible query from SeaPenQuery `query`. Empty string if the
 * query is null or invalid.
 */
function getUserVisibleQuery(query) {
    if (!query) {
        return '';
    }
    if (query.textQuery) {
        return query.textQuery;
    }
    if (query.templateQuery) {
        return query.templateQuery.userVisibleQuery?.text ?? '';
    }
    return '';
}
/**
 * Convert Sea Pen template id in string type to SeaPenTemplateId/Query type.
 */
function getTemplateIdFromString(templateId) {
    if (templateId === QUERY) {
        return QUERY;
    }
    return parseInt(templateId);
}
/**
 * Checks whether the origin of the URL from Personalization App.
 */
function isPersonalizationApp() {
    return window.location.origin === 'chrome://personalization';
}
/** Returns true if this event is a user action to select an item. */
function isSelectionEvent$2(event) {
    return (event instanceof MouseEvent && event.type === 'click') ||
        (event instanceof KeyboardEvent && event.key === 'Enter');
}
/**
 * Fisher-Yates Shuffle
 */
function shuffle(array) {
    const copy = [...array];
    for (let i = copy.length - 1; i > 0; i--) {
        const j = Math.floor(Math.random() * (i + 1));
        [copy[i], copy[j]] = [copy[j], copy[i]];
    }
    return copy;
}
/**
 * Checks whether the two arrays contain the same elements. Uses strict equals
 * comparison on each member of the arrays.
 */
function isArrayEqual(arr1, arr2) {
    return arr1.length === arr2.length &&
        arr1.every((value, index) => value === arr2[index]);
}
/**
 * Announces the given message to users when screen reader is enabled.
 */
class IronAnnounceEvent extends CustomEvent {
    constructor(message) {
        super('iron-announce', {
            bubbles: true,
            composed: true,
            detail: {
                text: message,
            },
        });
    }
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Defines the actions to change ambient state.
 */
var AmbientActionName;
(function (AmbientActionName) {
    AmbientActionName["SET_ALBUMS"] = "set_albums";
    AmbientActionName["SET_ALBUM_SELECTED"] = "set_album_selected";
    AmbientActionName["SET_AMBIENT_MODE_ENABLED"] = "set_ambient_mode_enabled";
    AmbientActionName["SET_AMBIENT_THEME"] = "set_ambient_theme";
    AmbientActionName["SET_AMBIENT_THEME_PREVIEWS"] = "set_ambient_theme_previews";
    AmbientActionName["SET_PREVIEWS"] = "set_previews";
    AmbientActionName["SET_SCREEN_SAVER_DURATION"] = "set_screen_saver_duration";
    AmbientActionName["SET_TEMPERATURE_UNIT"] = "set_temperature_unit";
    AmbientActionName["SET_TOPIC_SOURCE"] = "set_topic_source";
    AmbientActionName["SET_AMBIENT_UI_VISIBILITY"] = "set_ambient_ui_visibility";
    AmbientActionName["SET_SHOULD_SHOW_TIME_OF_DAY_BANNER"] = "set_should_show_time_of_day_banner";
    AmbientActionName["SET_GEOLOCATION_PERMISSION_ENABLED"] = "set_geolocation_permission_enabled";
    AmbientActionName["SET_GEOLOCATION_IS_USER_MODIFIABLE"] = "set_geolocation_is_user_modifiable";
})(AmbientActionName || (AmbientActionName = {}));
/**
 * Sets the current value of the albums.
 */
function setAlbumsAction(albums) {
    return { name: AmbientActionName.SET_ALBUMS, albums };
}
function setAlbumSelectedAction() {
    return { name: AmbientActionName.SET_ALBUM_SELECTED };
}
/**
 * Sets the current value of the ambient mode pref.
 */
function setAmbientModeEnabledAction(enabled) {
    return { name: AmbientActionName.SET_AMBIENT_MODE_ENABLED, enabled };
}
/**
 * Sets the current value of the ambient theme.
 */
function setAmbientThemeAction(ambientTheme) {
    return { name: AmbientActionName.SET_AMBIENT_THEME, ambientTheme };
}
function setAmbientThemePreviewsAction(previews) {
    return { name: AmbientActionName.SET_AMBIENT_THEME_PREVIEWS, previews };
}
/**
 * Sets the current value of preview image URLs.
 */
function setPreviewsAction(previews) {
    return { name: AmbientActionName.SET_PREVIEWS, previews };
}
/**
 * Sets the current value of the screen saver duration.
 */
function setScreenSaverDurationAction(minutes) {
    return { name: AmbientActionName.SET_SCREEN_SAVER_DURATION, minutes };
}
/**
 * Sets the current value of the topic source.
 */
function setTopicSourceAction(topicSource) {
    return { name: AmbientActionName.SET_TOPIC_SOURCE, topicSource };
}
/**
 * Sets the current value of the temperature unit.
 */
function setTemperatureUnitAction(temperatureUnit) {
    return { name: AmbientActionName.SET_TEMPERATURE_UNIT, temperatureUnit };
}
/**
 * Sets the current state of Ambient UI visibility.
 */
function setAmbientUiVisibilityAction(ambientUiVisibility) {
    return {
        name: AmbientActionName.SET_AMBIENT_UI_VISIBILITY,
        ambientUiVisibility,
    };
}
/**
 * Sets the boolean that determines whether to show the time of day banner.
 */
function setShouldShowTimeOfDayBannerAction(shouldShowTimeOfDayBanner) {
    return {
        name: AmbientActionName.SET_SHOULD_SHOW_TIME_OF_DAY_BANNER,
        shouldShowTimeOfDayBanner,
    };
}
function setGeolocationPermissionEnabledAction$1(enabled) {
    return { name: AmbientActionName.SET_GEOLOCATION_PERMISSION_ENABLED, enabled };
}
function setGeolocationIsUserModifiableAction$1(isUserModifiable) {
    return {
        name: AmbientActionName.SET_GEOLOCATION_IS_USER_MODIFIABLE,
        isUserModifiable,
    };
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function albumsReducer(state, action, _) {
    switch (action.name) {
        case AmbientActionName.SET_ALBUMS:
            return action.albums;
        case AmbientActionName.SET_ALBUM_SELECTED:
            if (!state) {
                return state;
            }
            // An albums in AmbientState.albums is mutated by setting checked
            // to True/False, have to return a copy of albums state so that
            // Polymer knows there is an update.
            return [...state];
        default:
            return state;
    }
}
function ambientModeEnabledReducer(state, action, _) {
    switch (action.name) {
        case AmbientActionName.SET_AMBIENT_MODE_ENABLED:
            return action.enabled;
        default:
            return state;
    }
}
function ambientThemeReducer(state, action, _) {
    switch (action.name) {
        case AmbientActionName.SET_AMBIENT_THEME:
            return action.ambientTheme;
        default:
            return state;
    }
}
function ambientThemePreviewsReducer(state, action, _) {
    switch (action.name) {
        case AmbientActionName.SET_AMBIENT_THEME_PREVIEWS:
            return action.previews;
        default:
            return state;
    }
}
function previewsReducer(state, action, _) {
    switch (action.name) {
        case AmbientActionName.SET_PREVIEWS:
            return action.previews;
        default:
            return state;
    }
}
function screenSaverDurationReducer(state, action, _) {
    switch (action.name) {
        case AmbientActionName.SET_SCREEN_SAVER_DURATION:
            return action.minutes;
        default:
            return state;
    }
}
function temperatureUnitReducer(state, action, _) {
    switch (action.name) {
        case AmbientActionName.SET_TEMPERATURE_UNIT:
            return action.temperatureUnit;
        default:
            return state;
    }
}
function topicSourceReducer(state, action, _) {
    switch (action.name) {
        case AmbientActionName.SET_TOPIC_SOURCE:
            return action.topicSource;
        default:
            return state;
    }
}
function ambientUiVisibilityReducer(state, action, _) {
    switch (action.name) {
        case AmbientActionName.SET_AMBIENT_UI_VISIBILITY:
            return action.ambientUiVisibility;
        default:
            return state;
    }
}
function shouldShowTimeOfDayBannerReducer(state, action, _) {
    switch (action.name) {
        case AmbientActionName.SET_SHOULD_SHOW_TIME_OF_DAY_BANNER:
            return action.shouldShowTimeOfDayBanner;
        default:
            return state;
    }
}
function geolocationPermissionEnabledReducer$1(state, action, _) {
    switch (action.name) {
        case AmbientActionName.SET_GEOLOCATION_PERMISSION_ENABLED:
            return action.enabled;
        default:
            return state;
    }
}
function geolocationIsUserModifiableReducer$1(state, action, _) {
    switch (action.name) {
        case AmbientActionName.SET_GEOLOCATION_IS_USER_MODIFIABLE:
            return action.isUserModifiable;
        default:
            return state;
    }
}
const ambientReducers = {
    albums: albumsReducer,
    ambientModeEnabled: ambientModeEnabledReducer,
    ambientTheme: ambientThemeReducer,
    ambientThemePreviews: ambientThemePreviewsReducer,
    duration: screenSaverDurationReducer,
    previews: previewsReducer,
    temperatureUnit: temperatureUnitReducer,
    topicSource: topicSourceReducer,
    ambientUiVisibility: ambientUiVisibilityReducer,
    shouldShowTimeOfDayBanner: shouldShowTimeOfDayBannerReducer,
    geolocationPermissionEnabled: geolocationPermissionEnabledReducer$1,
    geolocationIsUserModifiable: geolocationIsUserModifiableReducer$1,
};

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Defines the actions to update keyboard backlight settings.
 */
var KeyboardBacklightActionName;
(function (KeyboardBacklightActionName) {
    KeyboardBacklightActionName["SET_CURRENT_BACKLIGHT_STATE"] = "set_current_backlight_state";
    KeyboardBacklightActionName["SET_SHOULD_SHOW_NUDGE"] = "set_should_show_nudge";
    KeyboardBacklightActionName["SET_WALLPAPER_COLOR"] = "set_wallpaper_color";
})(KeyboardBacklightActionName || (KeyboardBacklightActionName = {}));
/**
 * Sets the current value of the backlight state.
 */
function setCurrentBacklightStateAction(currentBacklightState) {
    return {
        name: KeyboardBacklightActionName.SET_CURRENT_BACKLIGHT_STATE,
        currentBacklightState,
    };
}
function setShouldShowNudgeAction(shouldShowNudge) {
    return {
        name: KeyboardBacklightActionName.SET_SHOULD_SHOW_NUDGE,
        shouldShowNudge,
    };
}
/**
 * Sets the current value of the wallpaper extracted color.
 */
function setWallpaperColorAction(wallpaperColor) {
    return {
        name: KeyboardBacklightActionName.SET_WALLPAPER_COLOR,
        wallpaperColor,
    };
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function currentBacklightStateReducer(state, action, _) {
    switch (action.name) {
        case KeyboardBacklightActionName.SET_CURRENT_BACKLIGHT_STATE:
            return action.currentBacklightState;
        default:
            return state;
    }
}
function shouldShowNudgeReducer(state, action, _) {
    switch (action.name) {
        case KeyboardBacklightActionName.SET_SHOULD_SHOW_NUDGE:
            return action.shouldShowNudge;
        default:
            return state;
    }
}
function wallpaperColorReducer(state, action, _) {
    switch (action.name) {
        case KeyboardBacklightActionName.SET_WALLPAPER_COLOR:
            return action.wallpaperColor;
        default:
            return state;
    }
}
const keyboardBacklightReducers = {
    currentBacklightState: currentBacklightStateReducer,
    shouldShowNudge: shouldShowNudgeReducer,
    wallpaperColor: wallpaperColorReducer,
};

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Defines the actions to change state.
 */
var PersonalizationActionName;
(function (PersonalizationActionName) {
    PersonalizationActionName["DISMISS_ERROR"] = "dismiss_error";
    PersonalizationActionName["SET_ERROR"] = "set_error";
})(PersonalizationActionName || (PersonalizationActionName = {}));
/**
 * Dismiss the current error if there is any.
 * @param id if non-null, the current error is only dismissed if it matches.
 * @param fromUser whether the dismiss action originated from the user.
 */
function dismissErrorAction(id, fromUser) {
    return { id, fromUser, name: PersonalizationActionName.DISMISS_ERROR };
}
/** Sets the current error. */
function setErrorAction(error) {
    return { error, name: PersonalizationActionName.SET_ERROR };
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Defines the actions to change theme state.
 */
var ThemeActionName;
(function (ThemeActionName) {
    ThemeActionName["SET_DARK_MODE_ENABLED"] = "set_dark_mode_enabled";
    ThemeActionName["SET_COLOR_MODE_AUTO_SCHEDULE_ENABLED"] = "set_color_mode_auto_schedule_enabled";
    ThemeActionName["SET_COLOR_SCHEME"] = "set_color_scheme";
    ThemeActionName["SET_SAMPLE_COLOR_SCHEMES"] = "set_sample_color_schemes";
    ThemeActionName["SET_STATIC_COLOR"] = "set_static_color";
    ThemeActionName["SET_GEOLOCATION_PERMISSION_ENABLED"] = "set_geolocation_permission_enabled";
    ThemeActionName["SET_SUNRISE_TIME"] = "set_sunrise_time";
    ThemeActionName["SET_SUNSET_TIME"] = "set_sunset_time";
    ThemeActionName["SET_GEOLOCATION_IS_USER_MODIFIABLE"] = "set_geolocation_is_user_modifiable";
})(ThemeActionName || (ThemeActionName = {}));
function setDarkModeEnabledAction(enabled) {
    return { name: ThemeActionName.SET_DARK_MODE_ENABLED, enabled };
}
function setColorModeAutoScheduleEnabledAction(enabled) {
    return { name: ThemeActionName.SET_COLOR_MODE_AUTO_SCHEDULE_ENABLED, enabled };
}
function setColorSchemeAction(colorScheme) {
    return { name: ThemeActionName.SET_COLOR_SCHEME, colorScheme };
}
function setSampleColorSchemesAction(sampleColorSchemes) {
    return { name: ThemeActionName.SET_SAMPLE_COLOR_SCHEMES, sampleColorSchemes };
}
function setStaticColorAction(staticColor) {
    return { name: ThemeActionName.SET_STATIC_COLOR, staticColor };
}
function setGeolocationPermissionEnabledAction(enabled) {
    return { name: ThemeActionName.SET_GEOLOCATION_PERMISSION_ENABLED, enabled };
}
function setGeolocationIsUserModifiableAction(isUserModifiable) {
    return {
        name: ThemeActionName.SET_GEOLOCATION_IS_USER_MODIFIABLE,
        isUserModifiable,
    };
}
function setSunriseTimeAction(time) {
    return { name: ThemeActionName.SET_SUNRISE_TIME, time };
}
function setSunsetTimeAction(time) {
    return { name: ThemeActionName.SET_SUNSET_TIME, time };
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function darkModeEnabledReducer(state, action, _) {
    switch (action.name) {
        case ThemeActionName.SET_DARK_MODE_ENABLED:
            return action.enabled;
        default:
            return state;
    }
}
function colorModeAutoScheduleEnabledReducer(state, action, _) {
    switch (action.name) {
        case ThemeActionName.SET_COLOR_MODE_AUTO_SCHEDULE_ENABLED:
            return action.enabled;
        default:
            return state;
    }
}
function colorSchemeSelectedReducer(state, action, _) {
    switch (action.name) {
        case ThemeActionName.SET_COLOR_SCHEME:
            return action.colorScheme;
        default:
            return state;
    }
}
function sampleColorSchemesReducer(state, action, _) {
    switch (action.name) {
        case ThemeActionName.SET_SAMPLE_COLOR_SCHEMES:
            return action.sampleColorSchemes;
        default:
            return state;
    }
}
function staticColorSelectedReducer(state, action, _) {
    switch (action.name) {
        case ThemeActionName.SET_STATIC_COLOR:
            return action.staticColor;
        default:
            return state;
    }
}
function geolocationPermissionEnabledReducer(state, action, _) {
    switch (action.name) {
        case ThemeActionName.SET_GEOLOCATION_PERMISSION_ENABLED:
            return action.enabled;
        default:
            return state;
    }
}
function geolocationIsUserModifiableReducer(state, action, _) {
    switch (action.name) {
        case ThemeActionName.SET_GEOLOCATION_IS_USER_MODIFIABLE:
            return action.isUserModifiable;
        default:
            return state;
    }
}
function sunriseTimeReducer(state, action, _) {
    switch (action.name) {
        case ThemeActionName.SET_SUNRISE_TIME:
            return action.time;
        default:
            return state;
    }
}
function sunsetTimeReducer(state, action, _) {
    switch (action.name) {
        case ThemeActionName.SET_SUNSET_TIME:
            return action.time;
        default:
            return state;
    }
}
const themeReducers = {
    colorModeAutoScheduleEnabled: colorModeAutoScheduleEnabledReducer,
    darkModeEnabled: darkModeEnabledReducer,
    colorSchemeSelected: colorSchemeSelectedReducer,
    sampleColorSchemes: sampleColorSchemesReducer,
    staticColorSelected: staticColorSelectedReducer,
    geolocationPermissionEnabled: geolocationPermissionEnabledReducer,
    geolocationIsUserModifiable: geolocationIsUserModifiableReducer,
    sunriseTime: sunriseTimeReducer,
    sunsetTime: sunsetTimeReducer,
};

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Defines the actions to change user state.
 */
var UserActionName;
(function (UserActionName) {
    UserActionName["SET_DEFAULT_USER_IMAGES"] = "set_default_user_images";
    UserActionName["SET_PROFILE_IMAGE"] = "set_profile_image";
    UserActionName["SET_IS_CAMERA_PRESENT"] = "set_is_camera_present";
    UserActionName["SET_USER_IMAGE"] = "set_user_image";
    UserActionName["SET_USER_INFO"] = "set_user_info";
    UserActionName["SET_USER_IMAGE_IS_ENTERPRISE_MANAGED"] = "set_user_image_is_enterprise_managed";
})(UserActionName || (UserActionName = {}));
function setIsCameraPresentAction(isCameraPresent) {
    return {
        name: UserActionName.SET_IS_CAMERA_PRESENT,
        isCameraPresent,
    };
}
function setUserImageAction(image) {
    return { name: UserActionName.SET_USER_IMAGE, image };
}
function setDefaultUserImagesAction(defaultUserImages) {
    return {
        name: UserActionName.SET_DEFAULT_USER_IMAGES,
        defaultUserImages,
    };
}
/**
 * Notify that the app has finished loading user info. Will be called with null
 * on error.
 */
function setUserInfoAction(userInfo) {
    return {
        name: UserActionName.SET_USER_INFO,
        user_info: userInfo,
    };
}
function setProfileImageAction(profileImage) {
    return {
        name: UserActionName.SET_PROFILE_IMAGE,
        profileImage,
    };
}
function setUserImageIsEnterpriseManagedAction(isEnterpriseManaged) {
    return {
        name: UserActionName.SET_USER_IMAGE_IS_ENTERPRISE_MANAGED,
        isEnterpriseManaged,
    };
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function imageReducer(state, action, _) {
    switch (action.name) {
        case UserActionName.SET_USER_IMAGE:
            return action.image;
        default:
            return state;
    }
}
function defaultUserImagesReducer(state, action, _) {
    switch (action.name) {
        case UserActionName.SET_DEFAULT_USER_IMAGES:
            return action.defaultUserImages;
        default:
            return state;
    }
}
function infoReducer(state, action, _) {
    switch (action.name) {
        case UserActionName.SET_USER_INFO:
            return action.user_info;
        default:
            return state;
    }
}
function profileImageReducer(state, action, _) {
    switch (action.name) {
        case UserActionName.SET_PROFILE_IMAGE:
            return action.profileImage;
        default:
            return state;
    }
}
function isCameraPresentReducer(state, action, _) {
    switch (action.name) {
        case UserActionName.SET_IS_CAMERA_PRESENT:
            return action.isCameraPresent;
        default:
            return state;
    }
}
function lastExternalUserImageReducer(state, action, _) {
    switch (action.name) {
        case UserActionName.SET_USER_IMAGE:
            if (action.image.externalImage) {
                return action.image;
            }
            return state;
        default:
            return state;
    }
}
function imageIsEnterpriseManagedReducer(state, action, _) {
    switch (action.name) {
        case UserActionName.SET_USER_IMAGE_IS_ENTERPRISE_MANAGED:
            return action.isEnterpriseManaged;
        default:
            return state;
    }
}
const userReducers = {
    defaultUserImages: defaultUserImagesReducer,
    image: imageReducer,
    info: infoReducer,
    profileImage: profileImageReducer,
    isCameraPresent: isCameraPresentReducer,
    lastExternalUserImage: lastExternalUserImageReducer,
    imageIsEnterpriseManaged: imageIsEnterpriseManagedReducer,
};

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Defines the actions to change wallpaper state.
 */
var WallpaperActionName;
(function (WallpaperActionName) {
    WallpaperActionName["APPEND_GOOGLE_PHOTOS_ALBUM"] = "append_google_photos_album";
    WallpaperActionName["APPEND_GOOGLE_PHOTOS_ALBUMS"] = "append_google_photos_albums";
    WallpaperActionName["APPEND_GOOGLE_PHOTOS_SHARED_ALBUMS"] = "append_google_photos_shared_albums";
    WallpaperActionName["APPEND_GOOGLE_PHOTOS_PHOTOS"] = "append_google_photos_photos";
    WallpaperActionName["BEGIN_LOAD_GOOGLE_PHOTOS_ALBUM"] = "begin_load_google_photos_album";
    WallpaperActionName["BEGIN_LOAD_GOOGLE_PHOTOS_ALBUMS"] = "begin_load_google_photos_albums";
    WallpaperActionName["BEGIN_LOAD_GOOGLE_PHOTOS_SHARED_ALBUMS"] = "begin_load_google_photos_shared_albums";
    WallpaperActionName["BEGIN_LOAD_GOOGLE_PHOTOS_ENABLED"] = "begin_load_google_photos_enabled";
    WallpaperActionName["BEGIN_LOAD_GOOGLE_PHOTOS_PHOTOS"] = "begin_load_google_photos_photos";
    WallpaperActionName["BEGIN_LOAD_IMAGES_FOR_COLLECTIONS"] = "begin_load_images_for_collections";
    WallpaperActionName["BEGIN_LOAD_DEFAULT_IMAGE_THUMBNAIL"] = "begin_load_default_image";
    WallpaperActionName["BEGIN_LOAD_LOCAL_IMAGES"] = "begin_load_local_images";
    WallpaperActionName["BEGIN_LOAD_LOCAL_IMAGE_DATA"] = "begin_load_local_image_data";
    WallpaperActionName["BEGIN_LOAD_SELECTED_IMAGE"] = "begin_load_selected_image";
    WallpaperActionName["BEGIN_SELECT_IMAGE"] = "begin_select_image";
    WallpaperActionName["BEGIN_UPDATE_DAILY_REFRESH_IMAGE"] = "begin_update_daily_refresh_image";
    WallpaperActionName["CLEAR_DAILY_REFRESH_ACTION"] = "clear_daily_refresh_action";
    WallpaperActionName["END_SELECT_IMAGE"] = "end_select_image";
    WallpaperActionName["SET_ATTRIBUTION"] = "set_attribution";
    WallpaperActionName["SET_COLLECTIONS"] = "set_collections";
    WallpaperActionName["SET_DAILY_REFRESH_COLLECTION_ID"] = "set_daily_refresh_collection_id";
    WallpaperActionName["SET_GOOGLE_PHOTOS_DAILY_REFRESH_ALBUM_ID"] = "set_google_photos_daily_refresh_album_id";
    WallpaperActionName["SET_GOOGLE_PHOTOS_ENABLED"] = "set_google_photos_enabled";
    WallpaperActionName["SET_IMAGES_FOR_COLLECTION"] = "set_images_for_collection";
    WallpaperActionName["SET_DEFAULT_IMAGE_THUMBNAIL"] = "set_default_image";
    WallpaperActionName["SET_LOCAL_IMAGES"] = "set_local_images";
    WallpaperActionName["SET_LOCAL_IMAGE_DATA"] = "set_local_image_data";
    WallpaperActionName["SET_SELECTED_IMAGE"] = "set_selected_image";
    WallpaperActionName["SET_UPDATED_DAILY_REFRESH_IMAGE"] = "set_updated_daily_refreshed_image";
    WallpaperActionName["SET_FULLSCREEN_STATE"] = "set_fullscreen_state";
    WallpaperActionName["SET_SHOULD_SHOW_TIME_OF_DAY_WALLPAPER_DIALOG"] = "set_shoud_show_time_of_day_wallpaper_dialog";
})(WallpaperActionName || (WallpaperActionName = {}));
/**
 * Appends to the list of Google Photos photos for the album associated with the
 * specified id. May be called with null on error.
 */
function appendGooglePhotosAlbumAction(albumId, photos, resumeToken) {
    return {
        albumId,
        photos,
        resumeToken,
        name: WallpaperActionName.APPEND_GOOGLE_PHOTOS_ALBUM,
    };
}
/**
 * Appends to the list of Google Photos owned albums. May be called with
 * null on error.
 */
function appendGooglePhotosAlbumsAction(albums, resumeToken) {
    return {
        albums,
        resumeToken,
        name: WallpaperActionName.APPEND_GOOGLE_PHOTOS_ALBUMS,
    };
}
/**
 * Appends to the list of Google Photos shared albums. May be called with
 * null on error.
 */
function appendGooglePhotosSharedAlbumsAction(albums, resumeToken) {
    return {
        albums,
        resumeToken,
        name: WallpaperActionName.APPEND_GOOGLE_PHOTOS_SHARED_ALBUMS,
    };
}
/**
 * Appends to the list of Google Photos photos. May be called with null on
 * error.
 */
function appendGooglePhotosPhotosAction(photos, resumeToken) {
    return {
        photos,
        resumeToken,
        name: WallpaperActionName.APPEND_GOOGLE_PHOTOS_PHOTOS,
    };
}
/**
 * Notifies that the app is loading the list of Google Photos photos for the
 * album associated with the specified id.
 */
function beginLoadGooglePhotosAlbumAction(albumId) {
    return { albumId, name: WallpaperActionName.BEGIN_LOAD_GOOGLE_PHOTOS_ALBUM };
}
/**
 * Notifies that the app is loading the list of Google Photos albums.
 */
function beginLoadGooglePhotosAlbumsAction() {
    return { name: WallpaperActionName.BEGIN_LOAD_GOOGLE_PHOTOS_ALBUMS };
}
/**
 * Notifies that the app is loading the list of Google Photos albums.
 */
function beginLoadGooglePhotosSharedAlbumsAction() {
    return { name: WallpaperActionName.BEGIN_LOAD_GOOGLE_PHOTOS_SHARED_ALBUMS };
}
/**
 * Notifies that the app is loading whether the user is allowed to access Google
 * Photos.
 */
function beginLoadGooglePhotosEnabledAction() {
    return { name: WallpaperActionName.BEGIN_LOAD_GOOGLE_PHOTOS_ENABLED };
}
/**
 * Notifies that the app is loading the list of Google Photos photos.
 */
function beginLoadGooglePhotosPhotosAction() {
    return { name: WallpaperActionName.BEGIN_LOAD_GOOGLE_PHOTOS_PHOTOS };
}
/**
 * Notifies that app is loading image list for the given collection.
 */
function beginLoadImagesForCollectionsAction(collections) {
    return {
        collections,
        name: WallpaperActionName.BEGIN_LOAD_IMAGES_FOR_COLLECTIONS,
    };
}
function beginLoadDefaultImageThubmnailAction() {
    return { name: WallpaperActionName.BEGIN_LOAD_DEFAULT_IMAGE_THUMBNAIL };
}
/**
 * Notifies that app is loading local image list.
 */
function beginLoadLocalImagesAction() {
    return { name: WallpaperActionName.BEGIN_LOAD_LOCAL_IMAGES };
}
/**
 * Notifies that app is loading thumbnail for the given local image.
 */
function beginLoadLocalImageDataAction(image) {
    return {
        id: image.path,
        name: WallpaperActionName.BEGIN_LOAD_LOCAL_IMAGE_DATA,
    };
}
/**
 * Notifies that a user has clicked on the refresh button.
 */
function beginUpdateDailyRefreshImageAction() {
    return {
        name: WallpaperActionName.BEGIN_UPDATE_DAILY_REFRESH_IMAGE,
    };
}
/**
 * Notifies that app is loading currently selected image information.
 */
function beginLoadSelectedImageAction() {
    return { name: WallpaperActionName.BEGIN_LOAD_SELECTED_IMAGE };
}
/**
 * Notifies that a user has clicked on an image to set as wallpaper.
 */
function beginSelectImageAction(image) {
    return { name: WallpaperActionName.BEGIN_SELECT_IMAGE, image };
}
/**
 * Notifies that the user-initiated action to set image has finished.
 */
function endSelectImageAction(image, success) {
    return { name: WallpaperActionName.END_SELECT_IMAGE, image, success };
}
/**
 * Sets the attribution of the current wallpaper. May be called with null if an
 * error occurred.
 */
function setAttributionAction(attribution) {
    return {
        name: WallpaperActionName.SET_ATTRIBUTION,
        attribution,
    };
}
/**
 * Sets the collections. May be called with null if an error occurred.
 */
function setCollectionsAction(collections) {
    return {
        name: WallpaperActionName.SET_COLLECTIONS,
        collections,
    };
}
/**
 * Sets and enable daily refresh for given collectionId.
 */
function setDailyRefreshCollectionIdAction(collectionId) {
    return {
        collectionId,
        name: WallpaperActionName.SET_DAILY_REFRESH_COLLECTION_ID,
    };
}
/**
 * Sets and enable daily refresh for given Google Photos albumId.
 */
function setGooglePhotosDailyRefreshAlbumIdAction(albumId) {
    return {
        albumId,
        name: WallpaperActionName.SET_GOOGLE_PHOTOS_DAILY_REFRESH_ALBUM_ID,
    };
}
/**
 * Clears the data related to daily refresh, indicating daily refresh is not
 * active.
 */
function clearDailyRefreshAction() {
    return {
        name: WallpaperActionName.CLEAR_DAILY_REFRESH_ACTION,
    };
}
/** Sets whether the user is allowed to access Google Photos. */
function setGooglePhotosEnabledAction(enabled) {
    return { enabled, name: WallpaperActionName.SET_GOOGLE_PHOTOS_ENABLED };
}
/**
 * Sets the images for a given collection. May be called with null if an error
 * occurred.
 */
function setImagesForCollectionAction(collectionId, images) {
    return {
        collectionId,
        images,
        name: WallpaperActionName.SET_IMAGES_FOR_COLLECTION,
    };
}
function setDefaultImageThumbnailAction(thumbnail) {
    return {
        thumbnail,
        name: WallpaperActionName.SET_DEFAULT_IMAGE_THUMBNAIL,
    };
}
/**
 * Sets the thumbnail data for a local image.
 */
function setLocalImageDataAction(filePath, data) {
    return {
        id: filePath.path,
        data,
        name: WallpaperActionName.SET_LOCAL_IMAGE_DATA,
    };
}
/** Sets the list of local images. */
function setLocalImagesAction(images) {
    return {
        images,
        name: WallpaperActionName.SET_LOCAL_IMAGES,
    };
}
/**
 * Notifies that a image has been refreshed.
 */
function setUpdatedDailyRefreshImageAction() {
    return {
        name: WallpaperActionName.SET_UPDATED_DAILY_REFRESH_IMAGE,
    };
}
/**
 * Returns an action to set the current image as currently selected across the
 * app. Can be called with null to represent no image currently selected or that
 * an error occurred.
 */
function setSelectedImageAction(image) {
    return {
        image,
        name: WallpaperActionName.SET_SELECTED_IMAGE,
    };
}
/**
 * Sets the boolean that determines whether to show the time of day wallpaper
 * dialog.
 */
function setShouldShowTimeOfDayWallpaperDialog(shouldShowDialog) {
    assert$1(typeof shouldShowDialog === 'boolean');
    return {
        name: WallpaperActionName.SET_SHOULD_SHOW_TIME_OF_DAY_WALLPAPER_DIALOG,
        shouldShowDialog,
    };
}
/**
 * Enables/disables the fullscreen preview mode for wallpaper.
 */
function setFullscreenStateAction(state) {
    return { name: WallpaperActionName.SET_FULLSCREEN_STATE, state };
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var FullscreenPreviewState;
(function (FullscreenPreviewState) {
    FullscreenPreviewState["OFF"] = "fullscreen_preview_off";
    FullscreenPreviewState["LOADING"] = "fullscreen_preview_loading";
    FullscreenPreviewState["VISIBLE"] = "fullscreen_preview_visible";
})(FullscreenPreviewState || (FullscreenPreviewState = {}));

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview defines the actions to change SeaPen state.
 */
var SeaPenActionName;
(function (SeaPenActionName) {
    SeaPenActionName["BEGIN_SEARCH_SEA_PEN_THUMBNAILS"] = "begin_search_sea_pen_thumbnails";
    SeaPenActionName["BEGIN_LOAD_RECENT_SEA_PEN_IMAGES"] = "begin_load_recent_sea_pen_images";
    SeaPenActionName["BEGIN_LOAD_RECENT_SEA_PEN_IMAGE_DATA"] = "begin_load_recent_sea_pen_image_data";
    SeaPenActionName["BEGIN_LOAD_SELECTED_RECENT_SEA_PEN_IMAGE"] = "begin_load_selected_recent_sea_pen_image";
    SeaPenActionName["SET_THUMBNAIL_RESPONSE_STATUS_CODE"] = "set_thumbnail_response_status_code";
    SeaPenActionName["BEGIN_SELECT_SEA_PEN_THUMBNAIL"] = "begin_select_sea_pen_thumbnail";
    SeaPenActionName["CLEAR_CURRENT_SEA_PEN_QUERY"] = "clear_current_sea_pen_query";
    SeaPenActionName["CLEAR_SEA_PEN_THUMBNAILS"] = "clear_sea_pen_thumbnails";
    SeaPenActionName["CLEAR_SEA_PEN_THUMBNAILS_LOADING"] = "clear_sea_pen_thumbnails_loading";
    SeaPenActionName["END_SELECT_SEA_PEN_THUMBNAIL"] = "end_select_sea_pen_thumbnail";
    SeaPenActionName["BEGIN_SELECT_RECENT_SEA_PEN_IMAGE"] = "begin_select_recent_sea_pen_image";
    SeaPenActionName["END_SELECT_RECENT_SEA_PEN_IMAGE"] = "end_select_recent_sea_pen_image";
    SeaPenActionName["SET_CURRENT_SEA_PEN_QUERY"] = "set_current_sea_pen_query";
    SeaPenActionName["SET_SEA_PEN_THUMBNAILS"] = "set_sea_pen_thumbnails";
    SeaPenActionName["SET_RECENT_SEA_PEN_IMAGES"] = "set_recent_sea_pen_images";
    SeaPenActionName["SET_RECENT_SEA_PEN_IMAGE_DATA"] = "set_recent_sea_pen_image_data";
    SeaPenActionName["SET_SELECTED_RECENT_SEA_PEN_IMAGE"] = "set_selected_recent_sea_pen_image";
    SeaPenActionName["SET_SHOULD_SHOW_SEA_PEN_INTRODUCTION_DIALOG"] = "set_should_show_sea_pen_introduction_dialog";
    SeaPenActionName["SET_SHOULD_SHOW_SEA_PEN_FREEFORM_INTRODUCTION_DIALOG"] = "set_should_show_sea_pen_freeform_introduction_dialog";
    SeaPenActionName["DISMISS_SEA_PEN_ERROR_ACTION"] = "dismiss_sea_pen_error";
    SeaPenActionName["SET_SEA_PEN_FULLSCREEN_STATE"] = "set_sea_pen_fullscreen_state";
    SeaPenActionName["SET_SEA_PEN_TEXT_QUERY_HISTORY"] = "set_sea_pen_text_query_history";
})(SeaPenActionName || (SeaPenActionName = {}));
function beginSearchSeaPenThumbnailsAction(query) {
    return {
        query: query,
        name: SeaPenActionName.BEGIN_SEARCH_SEA_PEN_THUMBNAILS,
    };
}
/**
 * Sets the currently searched Sea Pen query.
 */
function setCurrentSeaPenQueryAction(query) {
    return { name: SeaPenActionName.SET_CURRENT_SEA_PEN_QUERY, query };
}
/**
 * Sets the generated thumbnails for the given prompt text.
 */
function setSeaPenThumbnailsAction(query, thumbnails) {
    return { name: SeaPenActionName.SET_SEA_PEN_THUMBNAILS, query, thumbnails };
}
/**
 * Begins load recent sea pen images.
 */
function beginLoadRecentSeaPenImagesAction() {
    return {
        name: SeaPenActionName.BEGIN_LOAD_RECENT_SEA_PEN_IMAGES,
    };
}
/**
 * Sets the recent sea pen images.
 */
function setRecentSeaPenImagesAction(recentImages) {
    return {
        name: SeaPenActionName.SET_RECENT_SEA_PEN_IMAGES,
        recentImages,
    };
}
/**
 * Begins load the recent sea pen image data.
 */
function beginLoadRecentSeaPenImageDataAction(id) {
    return {
        name: SeaPenActionName.BEGIN_LOAD_RECENT_SEA_PEN_IMAGE_DATA,
        id,
    };
}
/**
 * Sets the recent sea pen image data.
 */
function setRecentSeaPenImageDataAction(id, data) {
    return {
        name: SeaPenActionName.SET_RECENT_SEA_PEN_IMAGE_DATA,
        id,
        data,
    };
}
/**
 * Begins selecting a recent Sea Pen image.
 */
function beginSelectRecentSeaPenImageAction(id) {
    return {
        name: SeaPenActionName.BEGIN_SELECT_RECENT_SEA_PEN_IMAGE,
        id,
    };
}
/**
 * Ends selecting a recent Sea Pen image.
 */
function endSelectRecentSeaPenImageAction(id, success) {
    return {
        name: SeaPenActionName.END_SELECT_RECENT_SEA_PEN_IMAGE,
        id,
        success,
    };
}
/**
 * Begins loading the selected recent Sea Pen image.
 */
function beginLoadSelectedRecentSeaPenImageAction() {
    return { name: SeaPenActionName.BEGIN_LOAD_SELECTED_RECENT_SEA_PEN_IMAGE };
}
/**
 * Sets the selected recent Sea Pen image.
 * Key is the id of the thumbnail that was used to generate this image.
 */
function setSelectedRecentSeaPenImageAction(key) {
    return {
        name: SeaPenActionName.SET_SELECTED_RECENT_SEA_PEN_IMAGE,
        key,
    };
}
function setSeaPenTextQueryHistory(history) {
    return {
        name: SeaPenActionName.SET_SEA_PEN_TEXT_QUERY_HISTORY,
        history,
    };
}
function setThumbnailResponseStatusCodeAction(thumbnailResponseStatusCode) {
    return {
        name: SeaPenActionName.SET_THUMBNAIL_RESPONSE_STATUS_CODE,
        thumbnailResponseStatusCode,
    };
}
function beginSelectSeaPenThumbnailAction(thumbnail) {
    return {
        name: SeaPenActionName.BEGIN_SELECT_SEA_PEN_THUMBNAIL,
        thumbnail,
    };
}
function endSelectSeaPenThumbnailAction(thumbnail, success) {
    return {
        name: SeaPenActionName.END_SELECT_SEA_PEN_THUMBNAIL,
        thumbnail,
        success,
    };
}
function clearCurrentSeaPenQueryAction() {
    return { name: SeaPenActionName.CLEAR_CURRENT_SEA_PEN_QUERY };
}
function clearSeaPenThumbnailsAction() {
    return { name: SeaPenActionName.CLEAR_SEA_PEN_THUMBNAILS };
}
function clearSeaPenThumbnailsLoadingAction() {
    return { name: SeaPenActionName.CLEAR_SEA_PEN_THUMBNAILS_LOADING };
}
/**
 * Sets the boolean that determines whether to show the Sea Pen introduction
 * dialog.
 */
function setShouldShowSeaPenIntroductionDialogAction(shouldShowDialog) {
    assert$1(typeof shouldShowDialog === 'boolean');
    return {
        name: SeaPenActionName.SET_SHOULD_SHOW_SEA_PEN_INTRODUCTION_DIALOG,
        shouldShowDialog,
    };
}
/**
 * Sets the boolean that determines whether to show the Sea Pen freeform
 * introduction dialog.
 */
function setShouldShowSeaPenFreeformIntroductionDialogAction(shouldShowFreeformDialog) {
    assert$1(typeof shouldShowFreeformDialog === 'boolean');
    return {
        name: SeaPenActionName.SET_SHOULD_SHOW_SEA_PEN_FREEFORM_INTRODUCTION_DIALOG,
        shouldShowFreeformDialog,
    };
}
function dismissSeaPenErrorAction() {
    return { name: SeaPenActionName.DISMISS_SEA_PEN_ERROR_ACTION };
}
/**
 * Enables/disables the fullscreen preview mode for wallpaper.
 */
function setSeaPenFullscreenStateAction(state) {
    return { name: SeaPenActionName.SET_SEA_PEN_FULLSCREEN_STATE, state };
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function loadingReducer$1(state, action) {
    switch (action.name) {
        case SeaPenActionName.BEGIN_SEARCH_SEA_PEN_THUMBNAILS:
            return {
                ...state,
                thumbnails: true,
            };
        case SeaPenActionName.CLEAR_SEA_PEN_THUMBNAILS_LOADING:
        case SeaPenActionName.SET_SEA_PEN_THUMBNAILS:
            return {
                ...state,
                thumbnails: false,
            };
        case SeaPenActionName.BEGIN_LOAD_RECENT_SEA_PEN_IMAGES:
            return {
                ...state,
                recentImages: true,
            };
        case SeaPenActionName.SET_RECENT_SEA_PEN_IMAGES:
            const newRecentImages = Array.isArray(action.recentImages) ? action.recentImages : [];
            // Only keep loading state for most recent Sea Pen images.
            return {
                ...state,
                recentImageData: newRecentImages.reduce((result, next) => {
                    if (state.recentImageData.hasOwnProperty(next)) {
                        result[next] = state.recentImageData[next];
                    }
                    return result;
                }, {}),
                // Recent image list is done loading.
                recentImages: false,
            };
        case SeaPenActionName.BEGIN_LOAD_RECENT_SEA_PEN_IMAGE_DATA:
            return {
                ...state,
                recentImageData: {
                    ...state.recentImageData,
                    [action.id]: true,
                },
            };
        case SeaPenActionName.SET_RECENT_SEA_PEN_IMAGE_DATA:
            return {
                ...state,
                recentImageData: {
                    ...state.recentImageData,
                    [action.id]: false,
                },
            };
        case SeaPenActionName.BEGIN_SELECT_RECENT_SEA_PEN_IMAGE:
            return { ...state, setImage: state.setImage + 1 };
        case SeaPenActionName.END_SELECT_RECENT_SEA_PEN_IMAGE:
        case SeaPenActionName.END_SELECT_SEA_PEN_THUMBNAIL:
            if (state.setImage <= 0) {
                console.error('Impossible state for loading.setImage');
                // Reset to 0.
                return { ...state, setImage: 0 };
            }
            return { ...state, setImage: state.setImage - 1 };
        case SeaPenActionName.BEGIN_LOAD_SELECTED_RECENT_SEA_PEN_IMAGE:
            return {
                ...state,
                currentSelected: true,
            };
        case SeaPenActionName.BEGIN_SELECT_SEA_PEN_THUMBNAIL:
            return {
                ...state,
                currentSelected: true,
                setImage: state.setImage + 1,
            };
        case SeaPenActionName.SET_SELECTED_RECENT_SEA_PEN_IMAGE:
            return {
                ...state,
                currentSelected: false,
            };
        default:
            return state;
    }
}
function thumbnailResponseStatusCodeReducer(state, action) {
    switch (action.name) {
        case SeaPenActionName.SET_THUMBNAIL_RESPONSE_STATUS_CODE:
            return action.thumbnailResponseStatusCode;
        default:
            return state;
    }
}
function currentSelectedReducer$1(state, action) {
    switch (action.name) {
        case SeaPenActionName.SET_SELECTED_RECENT_SEA_PEN_IMAGE:
            return action.key;
        default:
            return state;
    }
}
/**
 * Reducer for the pending selected image. The pendingSelected state is set when
 * a user clicks on an image and before the client code is reached.
 *
 * Note: We allow multiple concurrent requests of selecting images while only
 * keeping the latest pending image and failing others occurred in between.
 * The pendingSelected state should not be cleared in this scenario (of multiple
 * concurrent requests). Otherwise, it results in a unwanted jumpy motion of
 * selected state.
 */
function pendingSelectedReducer$1(state, action, globalState) {
    switch (action.name) {
        case SeaPenActionName.BEGIN_SELECT_RECENT_SEA_PEN_IMAGE:
            return action.id;
        case SeaPenActionName.SET_SELECTED_RECENT_SEA_PEN_IMAGE:
            const { key } = action;
            if (state && !key) {
                console.warn('pendingSelectedReducer: Failed to get selected image.');
                return null;
            }
            else if (globalState.loading.setImage == 0) {
                // Clear the pending state when there are no more requests.
                return null;
            }
            return state;
        case SeaPenActionName.END_SELECT_RECENT_SEA_PEN_IMAGE:
        case SeaPenActionName.END_SELECT_SEA_PEN_THUMBNAIL:
            const { success } = action;
            if (!success && globalState.loading.setImage <= 1) {
                // Clear the pending selected state if an error occurs and
                // there are no multiple concurrent requests of selecting images.
                return null;
            }
            return state;
        case SeaPenActionName.BEGIN_SELECT_SEA_PEN_THUMBNAIL:
            return action.thumbnail;
        default:
            return state;
    }
}
function recentImagesReducer(state, action) {
    switch (action.name) {
        case SeaPenActionName.SET_RECENT_SEA_PEN_IMAGES:
            return action.recentImages;
        default:
            return state;
    }
}
function recentImageDataReducer(state, action) {
    switch (action.name) {
        case SeaPenActionName.SET_RECENT_SEA_PEN_IMAGES:
            const newRecentImages = Array.isArray(action.recentImages) ? action.recentImages : [];
            return newRecentImages.reduce((result, id) => {
                if (id && state.hasOwnProperty(id)) {
                    result[id] = state[id];
                }
                return result;
            }, {});
        case SeaPenActionName.SET_RECENT_SEA_PEN_IMAGE_DATA:
            return { ...state, [action.id]: action.data };
        default:
            return state;
    }
}
function currentSeaPenQueryReducer(state, action) {
    switch (action.name) {
        case SeaPenActionName.SET_CURRENT_SEA_PEN_QUERY:
            assert$1(!!action.query, 'query is empty.');
            return action.query;
        case SeaPenActionName.CLEAR_CURRENT_SEA_PEN_QUERY:
            return null;
        default:
            return state;
    }
}
function thumbnailsReducer(state, action) {
    switch (action.name) {
        case SeaPenActionName.SET_SEA_PEN_THUMBNAILS:
            assert$1(!!action.query, 'input text is empty.');
            return action.thumbnails;
        case SeaPenActionName.CLEAR_SEA_PEN_THUMBNAILS:
            return null;
        default:
            return state;
    }
}
function shouldShowSeaPenIntroductionDialogReducer(state, action) {
    switch (action.name) {
        case SeaPenActionName.SET_SHOULD_SHOW_SEA_PEN_INTRODUCTION_DIALOG:
            return action.shouldShowDialog;
        default:
            return state;
    }
}
function shouldShowSeaPenFreeformIntroductionDialogReducer(state, action) {
    switch (action.name) {
        case SeaPenActionName.SET_SHOULD_SHOW_SEA_PEN_FREEFORM_INTRODUCTION_DIALOG:
            return action.shouldShowFreeformDialog;
        default:
            return state;
    }
}
function errorReducer$1(state, action) {
    switch (action.name) {
        case SeaPenActionName.END_SELECT_RECENT_SEA_PEN_IMAGE:
        case SeaPenActionName.END_SELECT_SEA_PEN_THUMBNAIL:
            if (!action.success) {
                // TODO(b/332743948) make error messages for this flow use manta status
                // code.
                return loadTimeData.getString('seaPenErrorGeneric');
            }
            return null;
        case SeaPenActionName.BEGIN_SELECT_SEA_PEN_THUMBNAIL:
        case SeaPenActionName.BEGIN_SELECT_RECENT_SEA_PEN_IMAGE:
        case SeaPenActionName.DISMISS_SEA_PEN_ERROR_ACTION:
        case SeaPenActionName.BEGIN_SEARCH_SEA_PEN_THUMBNAILS:
        case SeaPenActionName.CLEAR_SEA_PEN_THUMBNAILS:
            return null;
        default:
            return state;
    }
}
function textQueryHistoryReducer(state, action) {
    switch (action.name) {
        case SeaPenActionName.SET_SEA_PEN_TEXT_QUERY_HISTORY:
            return action.history;
        default:
            return state;
    }
}
function seaPenReducer(state, action) {
    const newState = {
        loading: loadingReducer$1(state.loading, action),
        recentImageData: recentImageDataReducer(state.recentImageData, action),
        recentImages: recentImagesReducer(state.recentImages, action),
        thumbnailResponseStatusCode: thumbnailResponseStatusCodeReducer(state.thumbnailResponseStatusCode, action),
        thumbnails: thumbnailsReducer(state.thumbnails, action),
        currentSeaPenQuery: currentSeaPenQueryReducer(state.currentSeaPenQuery, action),
        currentSelected: currentSelectedReducer$1(state.currentSelected, action),
        pendingSelected: pendingSelectedReducer$1(state.pendingSelected, action, state),
        shouldShowSeaPenFreeformIntroductionDialog: shouldShowSeaPenFreeformIntroductionDialogReducer(state.shouldShowSeaPenFreeformIntroductionDialog, action),
        shouldShowSeaPenIntroductionDialog: shouldShowSeaPenIntroductionDialogReducer(state.shouldShowSeaPenIntroductionDialog, action),
        error: errorReducer$1(state.error, action),
        textQueryHistory: textQueryHistoryReducer(state.textQueryHistory, action),
    };
    return newState;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// A special unique symbol that represents the device default image, normally
// not accessible by the user.
// Warning: symbols as object keys are not iterated by normal methods, but can
// be iterated by |getOwnPropertySymbols|.
const kDefaultImageSymbol = Symbol.for('chromeos_default_wallpaper');
const kMaximumLocalImagePreviews = 4;

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Utility functions to be used throughout personalization app.
 */
const WALLPAPER = 'wallpaperColor';
const WHITE = 'whiteColor';
const RED = 'redColor';
const YELLOW = 'yellowColor';
const GREEN = 'greenColor';
const BLUE = 'blueColor';
const INDIGO = 'indigoColor';
const PURPLE = 'purpleColor';
const RAINBOW = 'rainbowColor';
const staticColorIds = [WALLPAPER, WHITE, RED, YELLOW, GREEN, BLUE, INDIGO, PURPLE];
/** Returns true if this event is a user action to select an item. */
function isSelectionEvent$1(event) {
    return (event instanceof MouseEvent && event.type === 'click') ||
        (event instanceof KeyboardEvent && event.key === 'Enter');
}
/** Returns the text to display for a number of images. */
function getCountText(x) {
    switch (x) {
        case null:
        case undefined:
            return '';
        case 0:
            return loadTimeData.getString('zeroImages');
        case 1:
            return loadTimeData.getString('oneImage');
        default:
            if ('number' !== typeof x || x < 0) {
                console.error('Received an impossible value');
                return '';
            }
            return loadTimeData.getStringF('multipleImages', x);
    }
}
/**
 * Returns the number of grid items to render per row given the current inner
 * width of the |window|.
 */
function getNumberOfGridItemsPerRow() {
    return window.innerWidth > 720 ? 4 : 3;
}
/**
 * Checks if argument is a string with non-zero length.
 */
function isNonEmptyString(maybeString) {
    return typeof maybeString === 'string' && maybeString.length > 0;
}
/**
 * Checks if a number is within a range.
 */
function inBetween(num, minVal, maxVal) {
    return minVal <= num && num <= maxVal;
}
/** Returns the RGB hex in #ffffff format. */
function convertToRgbHexStr(hexVal) {
    const PADDING_LENGTH = 6;
    const STRING_LENGTH = 16;
    return `#${(hexVal & 0x0FFFFFF)
        .toString(STRING_LENGTH)
        .padStart(PADDING_LENGTH, '0')}`;
}
/**
 * Returns the mapping of preset colors to their hex value and enum value in
 * BacklightColor.
 */
function getPresetColors() {
    return {
        [WHITE]: {
            hexVal: convertToRgbHexStr(WHITE_COLOR),
            enumVal: BacklightColor.kWhite,
        },
        [RED]: {
            hexVal: convertToRgbHexStr(RED_COLOR),
            enumVal: BacklightColor.kRed,
        },
        [YELLOW]: {
            hexVal: convertToRgbHexStr(YELLOW_COLOR),
            enumVal: BacklightColor.kYellow,
        },
        [GREEN]: {
            hexVal: convertToRgbHexStr(GREEN_COLOR),
            enumVal: BacklightColor.kGreen,
        },
        [BLUE]: {
            hexVal: convertToRgbHexStr(BLUE_COLOR),
            enumVal: BacklightColor.kBlue,
        },
        [INDIGO]: {
            hexVal: convertToRgbHexStr(INDIGO_COLOR),
            enumVal: BacklightColor.kIndigo,
        },
        [PURPLE]: {
            hexVal: convertToRgbHexStr(PURPLE_COLOR),
            enumVal: BacklightColor.kPurple,
        },
    };
}
/**
 * Returns whether the given album is Recent Highlights.
 */
function isRecentHighlightsAlbum(album) {
    return album.id === 'RecentHighlights';
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/** @fileoverview Wallpaper related utility functions in personalization app */
function isWallpaperImage(obj) {
    return !!obj && typeof obj.unitId === 'bigint';
}
function isDefaultImage(obj) {
    return obj === kDefaultImageSymbol;
}
/** Checks whether |obj| is an instance of |GooglePhotosPhoto|. */
function isGooglePhotosPhoto(obj) {
    return !!obj && typeof obj.id === 'string';
}
/** Returns whether |image| is a match for the specified |key|. */
function isImageAMatchForKey(image, key) {
    if (isWallpaperImage(image)) {
        return key === image.unitId.toString();
    }
    if (isDefaultImage(image)) {
        return key === kDefaultImageSymbol;
    }
    if (isNonEmptyFilePath(image)) {
        return key === image.path;
    }
    assert$1(isGooglePhotosPhoto(image));
    // NOTE: Old clients may not support |dedupKey| when setting Google Photos
    // wallpaper, so use |id| in such cases for backwards compatibility.
    return (image.dedupKey && key === image.dedupKey) || key === image.id;
}
/**
 * Compare an image from the list of selectable images with the currently
 * selected user wallpaper.
 * @param image a selectable image that the user can choose
 * @param selected currently selected user walpaper
 * @return boolean whether they are considered the same image
 */
function isImageEqualToSelected(image, selected) {
    if (isDefaultImage(image)) {
        // Special case for default images. Mojom generated code for type
        // |CurrentWallpaper.key| cannot include javascript symbols.
        return selected.type === WallpaperType.kDefault;
    }
    return isImageAMatchForKey(image, selected.key);
}
/**
 * Subtly different than |getImageKey|, which returns just the file part of the
 * path. |getPathOrSymbol| returns the whole path for local images.
 */
function getPathOrSymbol(image) {
    if (isNonEmptyFilePath(image)) {
        return image.path;
    }
    assert$1(image === kDefaultImageSymbol, 'only one symbol should be present');
    return image;
}
/**
 * Convert a string layout value to the corresponding enum.
 */
function getWallpaperLayoutEnum(layout) {
    switch (layout) {
        case 'FILL':
            return WallpaperLayout.kCenterCropped;
        case 'CENTER': // fall through
        default:
            return WallpaperLayout.kCenter;
    }
}
/** Returns a css variable to control the animation delay. */
function getLoadingPlaceholderAnimationDelay$1(index) {
    // 48 is chosen because 4 and 3 are both factors, and it's large enough
    // that 48 grid items don't fit on one screen.
    const wrapped = index % 48;
    return `--animation-delay: ${wrapped * 83}ms;`;
}
/**
 * Returns loading placeholders to render given the current inner width of the
 * |window|. Placeholders are constructed using the specified |factory|.
 */
function getLoadingPlaceholders(factory) {
    const x = getNumberOfGridItemsPerRow();
    const y = Math.max(Math.floor(window.innerHeight / /*tileHeightPx=*/ 136), 2);
    return Array.from({ length: x * y }, factory);
}
/**
 * Returns the attribution list from local storage.
 * Such as attribution (image title, author...) of a downloaded image.
 */
function getLocalStorageAttribution(key) {
    const attributionMap = JSON.parse((window.localStorage['attribution'] || '{}'));
    const attribution = attributionMap[key];
    if (!attribution) {
        console.warn('Unable to get attribution from local storage.', key);
    }
    return attribution;
}
/**
 * Get the aria label of the currently selected wallpaper.
 */
function getWallpaperAriaLabel(image, attribution, dailyRefreshState) {
    if (!image || !attribution || image.key !== attribution.key) {
        return `${loadTimeData.getString('currentlySet')} ${loadTimeData.getString('unknownImageAttribution')}`;
    }
    if (image.type === WallpaperType.kDefault) {
        return `${loadTimeData.getString('currentlySet')} ${loadTimeData.getString('defaultWallpaper')}`;
    }
    const isDailyRefreshActive = !!dailyRefreshState;
    if (isNonEmptyArray(attribution.attribution)) {
        return isDailyRefreshActive ?
            [
                loadTimeData.getString('currentlySet'),
                loadTimeData.getString('dailyRefresh'),
                ...attribution.attribution,
            ].join(' ') :
            [
                loadTimeData.getString('currentlySet'),
                ...attribution.attribution,
            ].join(' ');
    }
    // Fallback to cached attribution.
    const cachedAttribution = getLocalStorageAttribution(image.key);
    if (isNonEmptyArray(cachedAttribution)) {
        return isDailyRefreshActive ?
            [
                loadTimeData.getString('currentlySet'),
                loadTimeData.getString('dailyRefresh'),
                ...attribution.attribution,
            ].join(' ') :
            [loadTimeData.getString('currentlySet'), ...cachedAttribution].join(' ');
    }
    return `${loadTimeData.getString('currentlySet')} ${loadTimeData.getString('unknownImageAttribution')}`;
}
/**
 * Get a url to download a high quality preview of the current wallpaper.
 * Responds with null in case |image| is invalid or null.
 */
function getWallpaperSrc(image) {
    if (!image) {
        return null;
    }
    if (typeof image.key !== 'string' || !image.key) {
        console.warn('Invalid image key received');
        return null;
    }
    /**
     * Add a key query parameter to cache bust when the image changes.
     *
     * TODO(b/276360067): UnitId is used as the key for online wallpaper images so
     * we need to bust the cache to show the correct variant when it changes.
     * Remove &timestamp param after b/276360067 is implemented.
     */
    return `/wallpaper.jpg?key=${encodeURIComponent(image.key)}&${Date.now()}`;
}
/**
 * Finds and returns a Google Photos album from albums list with a matching id.
 * Returns null in case invalid id or albums list or no album is found.
 */
function findAlbumById(albumId, albums) {
    if (isNonEmptyString(albumId) && isNonEmptyArray(albums)) {
        return albums.find(album => album.id === albumId) ?? null;
    }
    return null;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function emptyState$6() {
    return {
        loading: {
            recentImages: false,
            recentImageData: {},
            thumbnails: false,
            currentSelected: false,
            setImage: 0,
        },
        recentImageData: {},
        recentImages: null,
        thumbnailResponseStatusCode: null,
        thumbnails: null,
        currentSeaPenQuery: null,
        currentSelected: null,
        pendingSelected: null,
        shouldShowSeaPenIntroductionDialog: false,
        shouldShowSeaPenFreeformIntroductionDialog: false,
        error: null,
        textQueryHistory: null,
    };
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
var DailyRefreshType;
(function (DailyRefreshType) {
    DailyRefreshType["GOOGLE_PHOTOS"] = "daily_refresh_google_photos";
    DailyRefreshType["BACKDROP"] = "daily_refresh_backdrop";
})(DailyRefreshType || (DailyRefreshType = {}));
function emptyState$5() {
    return {
        backdrop: { collections: null, images: {} },
        loading: {
            collections: true,
            images: {},
            local: { images: false, data: { [kDefaultImageSymbol]: false } },
            refreshWallpaper: false,
            selected: {
                attribution: false,
                image: false,
            },
            setImage: 0,
            googlePhotos: {
                enabled: false,
                albums: false,
                albumsShared: false,
                photos: false,
                photosByAlbumId: {},
            },
        },
        local: { images: null, data: { [kDefaultImageSymbol]: { url: '' } } },
        attribution: null,
        currentSelected: null,
        pendingSelected: null,
        dailyRefresh: null,
        fullscreen: FullscreenPreviewState.OFF,
        shouldShowTimeOfDayWallpaperDialog: false,
        googlePhotos: {
            enabled: undefined,
            albums: undefined,
            albumsShared: undefined,
            photos: undefined,
            photosByAlbumId: {},
            resumeTokens: { albums: null, albumsShared: null, photos: null, photosByAlbumId: {} },
        },
        seaPen: emptyState$6(),
    };
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function backdropReducer(state, action, _) {
    switch (action.name) {
        case WallpaperActionName.SET_COLLECTIONS:
            return { collections: action.collections, images: {} };
        case WallpaperActionName.SET_IMAGES_FOR_COLLECTION:
            if (!state.collections) {
                console.warn('Cannot set images when collections is null');
                return state;
            }
            if (!state.collections.some(({ id }) => id === action.collectionId)) {
                console.warn('Cannot store images for unknown collection', action.collectionId);
                return state;
            }
            return {
                ...state,
                images: { ...state.images, [action.collectionId]: action.images },
            };
        default:
            return state;
    }
}
function loadingReducer(state, action, globalState) {
    switch (action.name) {
        case WallpaperActionName.BEGIN_LOAD_IMAGES_FOR_COLLECTIONS:
            return {
                ...state,
                images: action.collections.reduce((result, { id }) => {
                    result[id] = true;
                    return result;
                }, {}),
            };
        case WallpaperActionName.BEGIN_LOAD_LOCAL_IMAGE_DATA:
            return {
                ...state,
                local: { ...state.local, data: { ...state.local.data, [action.id]: true } },
            };
        case WallpaperActionName.BEGIN_LOAD_SELECTED_IMAGE:
            return { ...state, selected: { attribution: true, image: true } };
        case WallpaperActionName.BEGIN_SELECT_IMAGE:
            return { ...state, setImage: state.setImage + 1 };
        case WallpaperActionName.END_SELECT_IMAGE:
            if (state.setImage <= 0) {
                console.error('Impossible state for loading.setImage');
                // Reset to 0.
                return { ...state, setImage: 0 };
            }
            return { ...state, setImage: state.setImage - 1 };
        case WallpaperActionName.SET_COLLECTIONS:
            return { ...state, collections: false };
        case WallpaperActionName.SET_IMAGES_FOR_COLLECTION:
            return {
                ...state,
                images: { ...state.images, [action.collectionId]: false },
            };
        case WallpaperActionName.BEGIN_LOAD_DEFAULT_IMAGE_THUMBNAIL:
            return {
                ...state,
                local: {
                    ...state.local,
                    data: {
                        ...state.local.data,
                        [kDefaultImageSymbol]: true,
                    },
                },
            };
        case WallpaperActionName.BEGIN_LOAD_LOCAL_IMAGES:
            return {
                ...state,
                local: {
                    ...state.local,
                    images: true,
                },
            };
        case WallpaperActionName.SET_DEFAULT_IMAGE_THUMBNAIL:
            return {
                ...state,
                local: {
                    ...state.local,
                    data: {
                        ...state.local.data,
                        [kDefaultImageSymbol]: false,
                    },
                },
            };
        case WallpaperActionName.SET_LOCAL_IMAGES:
            // Only keep loading state for most recent local images and the default
            // image.
            const imagesToKeep = [kDefaultImageSymbol, ...(action.images || [])];
            return {
                ...state,
                local: {
                    data: imagesToKeep.reduce((result, next) => {
                        const path = isNonEmptyFilePath(next) ? next.path : next;
                        if (state.local.data.hasOwnProperty(path)) {
                            result[path] = state.local.data[path];
                        }
                        return result;
                    }, {}),
                    // Image list is done loading.
                    images: false,
                },
            };
        case WallpaperActionName.SET_LOCAL_IMAGE_DATA:
            return {
                ...state,
                local: {
                    ...state.local,
                    data: {
                        ...state.local.data,
                        [action.id]: false,
                    },
                },
            };
        case WallpaperActionName.SET_SELECTED_IMAGE:
            if (globalState.wallpaper.pendingSelected && action.image &&
                !isImageEqualToSelected(globalState.wallpaper.pendingSelected, action.image)) {
                // If the user is in the process of selecting a new image, but the
                // received image does not match what the user last selected, make sure
                // loading.selected stays true.
                return state;
            }
            return { ...state, selected: { ...state.selected, image: false } };
        case WallpaperActionName.SET_ATTRIBUTION:
            return { ...state, selected: { ...state.selected, attribution: false } };
        case SeaPenActionName.END_SELECT_SEA_PEN_THUMBNAIL:
        case SeaPenActionName.END_SELECT_RECENT_SEA_PEN_IMAGE:
            // End loading state if selecting a SeaPen image failed. There are no
            // incoming events from wallpaper_observer.ts to reset the loading state
            // from wallpaper side, as the SeaPen image was not saved and applied.
            if (!action.success) {
                return { ...state, selected: { image: false, attribution: false } };
            }
            return state;
        case WallpaperActionName.BEGIN_UPDATE_DAILY_REFRESH_IMAGE:
            return { ...state, refreshWallpaper: true };
        case WallpaperActionName.SET_UPDATED_DAILY_REFRESH_IMAGE:
            return { ...state, refreshWallpaper: false };
        case WallpaperActionName.BEGIN_LOAD_GOOGLE_PHOTOS_ALBUM:
            assert$1(!state.googlePhotos.photosByAlbumId[action.albumId]);
            return {
                ...state,
                googlePhotos: {
                    ...state.googlePhotos,
                    photosByAlbumId: {
                        ...state.googlePhotos.photosByAlbumId,
                        [action.albumId]: true,
                    },
                },
            };
        case WallpaperActionName.APPEND_GOOGLE_PHOTOS_ALBUM:
            assert$1(state.googlePhotos.photosByAlbumId[action.albumId] === true);
            return {
                ...state,
                googlePhotos: {
                    ...state.googlePhotos,
                    photosByAlbumId: {
                        ...state.googlePhotos.photosByAlbumId,
                        [action.albumId]: false,
                    },
                },
            };
        case WallpaperActionName.BEGIN_LOAD_GOOGLE_PHOTOS_ALBUMS:
            assert$1(state.googlePhotos.albums === false);
            return {
                ...state,
                googlePhotos: {
                    ...state.googlePhotos,
                    albums: true,
                },
            };
        case WallpaperActionName.APPEND_GOOGLE_PHOTOS_ALBUMS:
            assert$1(state.googlePhotos.albums === true);
            return {
                ...state,
                googlePhotos: {
                    ...state.googlePhotos,
                    albums: false,
                },
            };
        case WallpaperActionName.BEGIN_LOAD_GOOGLE_PHOTOS_SHARED_ALBUMS:
            assert$1(state.googlePhotos.albumsShared === false);
            return {
                ...state,
                googlePhotos: {
                    ...state.googlePhotos,
                    albumsShared: true,
                },
            };
        case WallpaperActionName.APPEND_GOOGLE_PHOTOS_SHARED_ALBUMS:
            assert$1(state.googlePhotos.albumsShared === true);
            return {
                ...state,
                googlePhotos: {
                    ...state.googlePhotos,
                    albumsShared: false,
                },
            };
        case WallpaperActionName.BEGIN_LOAD_GOOGLE_PHOTOS_ENABLED:
            assert$1(state.googlePhotos.enabled === false);
            return {
                ...state,
                googlePhotos: {
                    ...state.googlePhotos,
                    enabled: true,
                },
            };
        case WallpaperActionName.SET_GOOGLE_PHOTOS_ENABLED:
            assert$1(state.googlePhotos.enabled === true);
            return {
                ...state,
                googlePhotos: {
                    ...state.googlePhotos,
                    enabled: false,
                },
            };
        case WallpaperActionName.BEGIN_LOAD_GOOGLE_PHOTOS_PHOTOS:
            assert$1(state.googlePhotos.photos === false);
            return {
                ...state,
                googlePhotos: {
                    ...state.googlePhotos,
                    photos: true,
                },
            };
        case WallpaperActionName.APPEND_GOOGLE_PHOTOS_PHOTOS:
            assert$1(state.googlePhotos.photos === true);
            return {
                ...state,
                googlePhotos: {
                    ...state.googlePhotos,
                    photos: false,
                },
            };
        default:
            return state;
    }
}
function localReducer(state, action, _) {
    switch (action.name) {
        case WallpaperActionName.SET_DEFAULT_IMAGE_THUMBNAIL:
            if (isUrl(action.thumbnail) && isImageDataUrl(action.thumbnail)) {
                return {
                    images: [
                        kDefaultImageSymbol,
                        ...(state.images || []).filter(img => isNonEmptyFilePath(img)),
                    ],
                    data: {
                        ...state.data,
                        [kDefaultImageSymbol]: action.thumbnail,
                    },
                };
            }
            return {
                images: Array.isArray(state.images) ?
                    state.images.filter(img => isNonEmptyFilePath(img)) :
                    null,
                data: { ...state.data, [kDefaultImageSymbol]: { url: '' } },
            };
        case WallpaperActionName.SET_LOCAL_IMAGES: {
            const hasDefaultImageWithData = isNonEmptyArray(state.images) &&
                isDefaultImage(state.images[0]) && !!state.data[kDefaultImageSymbol];
            if (!Array.isArray(action.images)) {
                return {
                    // Keep the default image in image list if it is present.
                    images: hasDefaultImageWithData ? [kDefaultImageSymbol] : null,
                    data: { [kDefaultImageSymbol]: state.data[kDefaultImageSymbol] },
                };
            }
            // If the first image from prior state is the device default image, keep
            // it.
            const newImages = hasDefaultImageWithData ? [kDefaultImageSymbol, ...action.images] :
                action.images;
            return {
                images: newImages,
                // Only keep image thumbnails if the image is still in |images|.
                data: newImages.reduce((result, next) => {
                    const key = isNonEmptyFilePath(next) ? next.path : next;
                    if (state.data.hasOwnProperty(key)) {
                        result[key] = state.data[key];
                    }
                    return result;
                }, 
                // Set the default value for |kDefaultImageSymbol| here.
                { [kDefaultImageSymbol]: { url: '' } }),
            };
        }
        case WallpaperActionName.SET_LOCAL_IMAGE_DATA:
            return {
                ...state,
                data: {
                    ...state.data,
                    [action.id]: action.data,
                },
            };
        default:
            return state;
    }
}
function attributionReducer(state, action, _) {
    switch (action.name) {
        case WallpaperActionName.SET_ATTRIBUTION:
            return action.attribution;
        default:
            return state;
    }
}
function currentSelectedReducer(state, action, _) {
    switch (action.name) {
        case WallpaperActionName.SET_SELECTED_IMAGE:
            return action.image;
        default:
            return state;
    }
}
/**
 * Reducer for the pending selected image. The pendingSelected state is set when
 * a user clicks on an image and before the client code is reached.
 *
 * Note: We allow multiple concurrent requests of selecting images while only
 * keeping the latest pending image and failing others occurred in between.
 * The pendingSelected state should not be cleared in this scenario (of multiple
 * concurrent requests). Otherwise, it results in a unwanted jumpy motion of
 * selected state.
 */
function pendingSelectedReducer(state, action, globalState) {
    switch (action.name) {
        case WallpaperActionName.BEGIN_SELECT_IMAGE:
            return action.image;
        case WallpaperActionName.BEGIN_UPDATE_DAILY_REFRESH_IMAGE:
            return null;
        case WallpaperActionName.SET_SELECTED_IMAGE:
            const { image } = action;
            if (!image) {
                console.warn('pendingSelectedReducer: Failed to get selected image.');
                return null;
            }
            else if (globalState.wallpaper.loading.setImage == 0) {
                // Clear the pending state when there are no more requests.
                return null;
            }
            return state;
        case WallpaperActionName.SET_FULLSCREEN_STATE:
            if (action.state === FullscreenPreviewState.OFF) {
                // Clear the pending selected state after full screen is dismissed.
                return null;
            }
            return state;
        case WallpaperActionName.END_SELECT_IMAGE:
            const { success } = action;
            if (!success && globalState.wallpaper.loading.setImage <= 1) {
                // Clear the pending selected state if an error occurs and
                // there are no multiple concurrent requests of selecting images.
                return null;
            }
            return state;
        default:
            return state;
    }
}
function dailyRefreshReducer(state, action, _) {
    switch (action.name) {
        case WallpaperActionName.SET_DAILY_REFRESH_COLLECTION_ID:
            return {
                id: action.collectionId,
                type: DailyRefreshType.BACKDROP,
            };
        case WallpaperActionName.SET_GOOGLE_PHOTOS_DAILY_REFRESH_ALBUM_ID:
            return {
                id: action.albumId,
                type: DailyRefreshType.GOOGLE_PHOTOS,
            };
        case WallpaperActionName.CLEAR_DAILY_REFRESH_ACTION:
            return null;
        default:
            return state;
    }
}
function fullscreenReducer(state, action, _) {
    switch (action.name) {
        case WallpaperActionName.SET_FULLSCREEN_STATE:
            return action.state;
        default:
            return state;
    }
}
function shouldShowTimeOfDayWallpaperDialogReducer(state, action, _) {
    switch (action.name) {
        case WallpaperActionName.SET_SHOULD_SHOW_TIME_OF_DAY_WALLPAPER_DIALOG:
            return action.shouldShowDialog;
        default:
            return state;
    }
}
function googlePhotosReducer(state, action, _) {
    switch (action.name) {
        case WallpaperActionName.BEGIN_LOAD_GOOGLE_PHOTOS_ALBUM:
            // The list of photos for an album should be loaded only while additional
            // photos exist.
            assert$1(findAlbumById(action.albumId, state.albums) ||
                findAlbumById(action.albumId, state.albumsShared), 'No matching album id found in Google Photos albums.');
            assert$1(!state.photosByAlbumId[action.albumId] ||
                state.resumeTokens.photosByAlbumId[action.albumId], 'No photos available in the given Google Photos album.');
            return state;
        case WallpaperActionName.APPEND_GOOGLE_PHOTOS_ALBUM:
            assert$1(action.albumId !== undefined, 'Album id is undefined.');
            assert$1(action.photos !== undefined, 'List of Google Photos photos is undefined.');
            assert$1(findAlbumById(action.albumId, state.albums) ||
                findAlbumById(action.albumId, state.albumsShared), 'No matching album id found in Google Photos albums.');
            // Case: First batch of photos.
            if (!Array.isArray(state.photosByAlbumId[action.albumId])) {
                return {
                    ...state,
                    photosByAlbumId: {
                        ...state.photosByAlbumId,
                        [action.albumId]: action.photos,
                    },
                    resumeTokens: {
                        ...state.resumeTokens,
                        photosByAlbumId: {
                            ...state.resumeTokens.photosByAlbumId,
                            [action.albumId]: action.resumeToken,
                        },
                    },
                };
            }
            // Case: Subsequent batches of photos.
            if (Array.isArray(action.photos)) {
                return {
                    ...state,
                    photosByAlbumId: {
                        ...state.photosByAlbumId,
                        [action.albumId]: [...state.photosByAlbumId[action.albumId], ...action.photos],
                    },
                    resumeTokens: {
                        ...state.resumeTokens,
                        photosByAlbumId: {
                            ...state.resumeTokens.photosByAlbumId,
                            [action.albumId]: action.resumeToken,
                        },
                    },
                };
            }
            // Case: Error.
            return {
                ...state,
                resumeTokens: {
                    ...state.resumeTokens,
                    photosByAlbumId: {
                        ...state.resumeTokens.photosByAlbumId,
                        [action.albumId]: action.resumeToken,
                    },
                },
            };
        case WallpaperActionName.BEGIN_LOAD_GOOGLE_PHOTOS_ALBUMS:
            // The list of albums should be loaded only while additional albums exist.
            assert$1(!state.albums || state.resumeTokens.albums, 'Additional owned albums do not exist.');
            return state;
        case WallpaperActionName.APPEND_GOOGLE_PHOTOS_ALBUMS:
            assert$1(action.albums !== undefined, 'No owned albums fetched.');
            // Case: First batch of albums.
            if (!Array.isArray(state.albums)) {
                return {
                    ...state,
                    albums: action.albums,
                    resumeTokens: {
                        ...state.resumeTokens,
                        albums: action.resumeToken,
                    },
                };
            }
            // Case: Subsequent batches of albums.
            if (Array.isArray(action.albums)) {
                return {
                    ...state,
                    albums: [...state.albums, ...action.albums],
                    resumeTokens: {
                        ...state.resumeTokens,
                        albums: action.resumeToken,
                    },
                };
            }
            // Case: Error.
            return {
                ...state,
                resumeTokens: {
                    ...state.resumeTokens,
                    albums: action.resumeToken,
                },
            };
        case WallpaperActionName.BEGIN_LOAD_GOOGLE_PHOTOS_SHARED_ALBUMS:
            assert$1(!state.albumsShared || state.resumeTokens.albumsShared, 'Additional shared albums do not exist.');
            return state;
        case WallpaperActionName.APPEND_GOOGLE_PHOTOS_SHARED_ALBUMS:
            assert$1(action.albums !== undefined, 'No shared albums fetched.');
            // Case: First batch of albums.
            if (!Array.isArray(state.albumsShared)) {
                return {
                    ...state,
                    albumsShared: action.albums,
                    resumeTokens: {
                        ...state.resumeTokens,
                        albumsShared: action.resumeToken,
                    },
                };
            }
            // Case: Subsequent batches of albums.
            if (Array.isArray(action.albums)) {
                return {
                    ...state,
                    albumsShared: [...state.albumsShared, ...action.albums],
                    resumeTokens: {
                        ...state.resumeTokens,
                        albumsShared: action.resumeToken,
                    },
                };
            }
            // Case: Error.
            return {
                ...state,
                resumeTokens: {
                    ...state.resumeTokens,
                    albumsShared: action.resumeToken,
                },
            };
        case WallpaperActionName.BEGIN_LOAD_GOOGLE_PHOTOS_ENABLED:
            // Whether the user is allowed to access Google Photos should be loaded
            // only once.
            assert$1(state.enabled === undefined);
            return state;
        case WallpaperActionName.SET_GOOGLE_PHOTOS_ENABLED:
            assert$1(action.enabled !== undefined);
            return {
                ...state,
                enabled: action.enabled,
            };
        case WallpaperActionName.BEGIN_LOAD_GOOGLE_PHOTOS_PHOTOS:
            // The list of photos should be loaded only while additional photos exist.
            assert$1(!state.photos || state.resumeTokens.photos);
            return state;
        case WallpaperActionName.APPEND_GOOGLE_PHOTOS_PHOTOS:
            assert$1(action.photos !== undefined);
            // Case: First batch of photos.
            if (!Array.isArray(state.photos)) {
                return {
                    ...state,
                    photos: action.photos,
                    resumeTokens: {
                        ...state.resumeTokens,
                        photos: action.resumeToken,
                    },
                };
            }
            // Case: Subsequent batches of photos.
            if (Array.isArray(action.photos)) {
                return {
                    ...state,
                    photos: [...state.photos, ...action.photos],
                    resumeTokens: {
                        ...state.resumeTokens,
                        photos: action.resumeToken,
                    },
                };
            }
            // Case: Error.
            return {
                ...state,
                resumeTokens: {
                    ...state.resumeTokens,
                    photos: action.resumeToken,
                },
            };
        default:
            return state;
    }
}
const allSeaPenActionNames = new Set(Object.values(SeaPenActionName));
function actionIsSeaPenAction(action) {
    return allSeaPenActionNames.has(action.name);
}
function seaPenReducerAdapter(state, action, _) {
    if (actionIsSeaPenAction(action)) {
        return seaPenReducer(state, action);
    }
    return state;
}
const wallpaperReducers = {
    backdrop: backdropReducer,
    loading: loadingReducer,
    local: localReducer,
    attribution: attributionReducer,
    currentSelected: currentSelectedReducer,
    pendingSelected: pendingSelectedReducer,
    dailyRefresh: dailyRefreshReducer,
    fullscreen: fullscreenReducer,
    shouldShowTimeOfDayWallpaperDialog: shouldShowTimeOfDayWallpaperDialogReducer,
    googlePhotos: googlePhotosReducer,
    seaPen: seaPenReducerAdapter,
};

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview  Defines reducers for personalization app.  Reducers must be a
 * pure function that returns a new state object if anything has changed.
 * @see [redux tutorial]{@link https://redux.js.org/tutorials/fundamentals/part-3-state-actions-reducers}
 */
/**
 * Combines reducers into a single top level reducer. Inspired by Redux's
 * |combineReducers| functions.
 */
function combineReducers(mapping) {
    function reduce(state, action, globalState) {
        const newState = Object.keys(mapping).reduce((result, key) => {
            const func = mapping[key];
            result[key] = func(state[key], action, globalState);
            return result;
        }, {});
        const change = Object.keys(state)
            .some((key) => newState[key] !== state[key]);
        return change ? newState : state;
    }
    return reduce;
}
function errorReducer(state, action, _) {
    switch (action.name) {
        case WallpaperActionName.END_SELECT_IMAGE:
            const { success } = action;
            if (success) {
                return null;
            }
            return { message: loadTimeData.getString('setWallpaperError') };
        case WallpaperActionName.SET_SELECTED_IMAGE:
            const { image } = action;
            if (image) {
                return state;
            }
            return { message: loadTimeData.getString('loadWallpaperError') };
        // Show network error toast if local images are available but online
        // collections are failed to load. As local images include at least
        // the default image, we only need to check the status of online
        // collections.
        case WallpaperActionName.SET_COLLECTIONS:
            const { collections } = action;
            if (!isNonEmptyArray(collections)) {
                return { message: loadTimeData.getString('wallpaperNetworkError') };
            }
            return state;
        case PersonalizationActionName.SET_ERROR:
            if (state && state.dismiss && state.dismiss.callback) {
                state.dismiss.callback(/*fromUser=*/ false);
            }
            return action.error;
        case PersonalizationActionName.DISMISS_ERROR:
            if (!state) {
                console.warn('Received dismiss error action when error is already null');
                return null;
            }
            if (action.id && (!state.id || action.id !== state.id)) {
                return state;
            }
            if (state && state.dismiss && state.dismiss.callback) {
                state.dismiss.callback(action.fromUser);
            }
            return null;
        default:
            return state;
    }
}
const root = combineReducers({
    error: errorReducer,
    ambient: combineReducers(ambientReducers),
    keyboardBacklight: combineReducers(keyboardBacklightReducers),
    theme: combineReducers(themeReducers),
    user: combineReducers(userReducers),
    wallpaper: combineReducers(wallpaperReducers),
});
function reduce(state, action) {
    return root(state, action, state);
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function emptyState$4() {
    return {
        albums: null,
        ambientModeEnabled: null,
        ambientTheme: null,
        ambientThemePreviews: null,
        duration: null,
        previews: null,
        temperatureUnit: null,
        topicSource: null,
        ambientUiVisibility: null,
        shouldShowTimeOfDayBanner: false,
        geolocationPermissionEnabled: null,
        geolocationIsUserModifiable: null,
    };
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function emptyState$3() {
    return {
        currentBacklightState: null,
        shouldShowNudge: false,
        wallpaperColor: null,
    };
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function emptyState$2() {
    return {
        colorModeAutoScheduleEnabled: null,
        colorSchemeSelected: null,
        darkModeEnabled: null,
        sampleColorSchemes: [],
        staticColorSelected: null,
        geolocationPermissionEnabled: null,
        sunriseTime: null,
        sunsetTime: null,
        geolocationIsUserModifiable: null,
    };
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function emptyState$1() {
    return {
        defaultUserImages: null,
        image: null,
        info: null,
        profileImage: null,
        isCameraPresent: false,
        lastExternalUserImage: null,
        imageIsEnterpriseManaged: null,
    };
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function emptyState() {
    return {
        error: null,
        ambient: emptyState$4(),
        keyboardBacklight: emptyState$3(),
        theme: emptyState$2(),
        user: emptyState$1(),
        wallpaper: emptyState$5(),
    };
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A singleton datastore for the personalization app. Page state
 * is publicly readable, but can only be modified by dispatching an Action to
 * the store. Any data that is shared between components should go here.
 */
/**
 * The singleton instance of PersonalizationStore. Constructed once when the
 * app starts. Replaced in tests.
 */
let instance$a = null;
/**
 * A Personalization App specific version of a Store with singleton getter and
 * setter.
 */
class PersonalizationStore extends Store {
    constructor() {
        super(emptyState(), reduce);
    }
    static getInstance() {
        return instance$a || (instance$a = new PersonalizationStore());
    }
    static setInstance(newInstance) {
        instance$a = newInstance;
    }
}
const PersonalizationStoreClientMixin = makeStoreClientMixin(PersonalizationStore.getInstance);
/**
 * A base class for Personalization App polymer elements to access useful
 * utilities like i18n and store client methods.
 */
const WithPersonalizationStore = I18nMixin(ListPropertyUpdateMixin(PersonalizationStoreClientMixin(PolymerElement)));

function getTemplate$1e() {
    return html `<!--_html_template_start_--><style include="wallpaper common">:host{overflow:hidden}iron-list{width:100%}wallpaper-grid-item[data-is-video][aria-selected='true']::part(item){cursor:default}</style>
<iron-list aria-setsize$="[[albumsForDisplay_.length]]" as="album" grid id="grid"
    items="[[albumsForDisplay_]]" role="listbox">
  <template>
    <!-- |albums| is used for |class$| and |selected| to ensure the attributes
          are updated correctly. -->
    <wallpaper-grid-item aria-label$="[[album.title]]"
        aria-posinset$="[[getAriaIndex_(index)]]"
        class$="[[getAlbumItemClass_(album, albums)]]"
        data-is-video$="[[isVideo_(topicSource)]]"
        index="[[index]]"
        is-google-photos="[[isGooglePhotos_(topicSource)]]"
        on-wallpaper-grid-item-selected="onAlbumSelected_"
        primary-text="[[album.title]]"
        role="option"
        secondary-text="[[getSecondaryText_(album, topicSource)]]"
        selected="[[isAlbumSelected_(album, albums)]]"
        src="[[album.url]]"
        tabindex$="[[tabIndex]]">
    </wallpaper-grid-item>
  </template>
</iron-list>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview The element for displaying a list of albums.
 */
class AlbumListElement extends WithPersonalizationStore {
    static get is() {
        return 'album-list';
    }
    static get template() {
        return getTemplate$1e();
    }
    static get properties() {
        return {
            topicSource: TopicSource,
            /**
             * List of albums received from the client.
             */
            albums: {
                type: Array,
                value: null,
                observer: 'onAlbumsChanged_',
            },
            /**
             * List of albums used for iron-list rendering.
             */
            albumsForDisplay_: {
                type: Array,
                value: [],
            },
        };
    }
    onAlbumsChanged_(albums) {
        if (!albums) {
            return;
        }
        // `albumsForDisplay_` is updated in place to avoid complete re-rendering of
        // iron-list, which would cause the tabindex to reset. See b/291123326.
        this.updateList(
        /*propertyPath=*/ 'albumsForDisplay_', 
        /*identityGetter=*/
        (album) => album.id + `${album.numberOfPhotos}`, 
        /*newList=*/ albums, 
        /*identityBasedUpdate=*/ true);
    }
    /** Invoked on selection of an album. */
    onAlbumSelected_(e) {
        // Retrieve the actual instance of selected album from `albums`.
        const albumIndex = this.albums.findIndex(album => album.id === e.model.album.id);
        assert$1(albumIndex >= 0);
        const albumChanged = this.albums[albumIndex];
        if (this.topicSource === TopicSource.kVideo && albumChanged.checked) {
            // De-selecting a selected video album is a no-op. Selecting a different
            // video album will unselect the other video albums in the client.
            return;
        }
        albumChanged.checked = !albumChanged.checked;
        this.dispatchEvent(new CustomEvent('album_selected_changed', { bubbles: true, composed: true, detail: { album: albumChanged } }));
    }
    isAlbumSelected_(changedAlbum, albums) {
        if (!changedAlbum) {
            return false;
        }
        const album = albums.find(album => album.id === changedAlbum.id);
        return !!album && album.checked;
    }
    getAlbumItemClass_(album, albums) {
        return album && this.isAlbumSelected_(album, albums) ?
            'album album-selected' :
            'album';
    }
    /** Returns the secondary text to display for the specified |album|. */
    getSecondaryText_(album, topicSource) {
        if (!album) {
            return '';
        }
        if (topicSource === TopicSource.kGooglePhotos) {
            if (isRecentHighlightsAlbum(album)) {
                return this.i18n('ambientModeAlbumsSubpageRecentHighlightsDesc');
            }
            return getCountText(album.numberOfPhotos);
        }
        if (this.topicSource === TopicSource.kArtGallery ||
            this.topicSource === TopicSource.kVideo) {
            return album.description;
        }
        return '';
    }
    getAriaIndex_(index) {
        return index + 1;
    }
    isGooglePhotos_(topicSource) {
        return topicSource === TopicSource.kGooglePhotos;
    }
    isVideo_(topicSource) {
        return topicSource === TopicSource.kVideo;
    }
}
customElements.define(AlbumListElement.is, AlbumListElement);

const styleMod$8 = document.createElement('dom-module');
styleMod$8.appendChild(html `
  <template>
    <style>
[hidden],:host([hidden]){display:none !important}
    </style>
  </template>
`.content);
styleMod$8.register('cr-hidden-style');

const styleMod$7 = document.createElement('dom-module');
styleMod$7.appendChild(html `
  <template>
    <style>
.icon-arrow-back{--cr-icon-image:url(chrome://resources/images/icon_arrow_back.svg)}.icon-arrow-dropdown{--cr-icon-image:url(chrome://resources/images/icon_arrow_dropdown.svg)}.icon-arrow-drop-down-cr23{--cr-icon-image:url(chrome://resources/images/icon_arrow_drop_down_cr23.svg)}.icon-arrow-drop-up-cr23{--cr-icon-image:url(chrome://resources/images/icon_arrow_drop_up_cr23.svg)}.icon-cancel{--cr-icon-image:url(chrome://resources/images/icon_cancel.svg)}.icon-clear{--cr-icon-image:url(chrome://resources/images/icon_clear.svg)}.icon-copy-content{--cr-icon-image:url(chrome://resources/images/icon_copy_content.svg)}.icon-delete-gray{--cr-icon-image:url(chrome://resources/images/icon_delete_gray.svg)}.icon-edit{--cr-icon-image:url(chrome://resources/images/icon_edit.svg)}.icon-file{--cr-icon-image:url(chrome://resources/images/icon_filetype_generic.svg)}.icon-folder-open{--cr-icon-image:url(chrome://resources/images/icon_folder_open.svg)}.icon-picture-delete{--cr-icon-image:url(chrome://resources/images/icon_picture_delete.svg)}.icon-expand-less{--cr-icon-image:url(chrome://resources/images/icon_expand_less.svg)}.icon-expand-more{--cr-icon-image:url(chrome://resources/images/icon_expand_more.svg)}.icon-external{--cr-icon-image:url(chrome://resources/images/open_in_new.svg)}.icon-more-vert{--cr-icon-image:url(chrome://resources/images/icon_more_vert.svg)}.icon-refresh{--cr-icon-image:url(chrome://resources/images/icon_refresh.svg)}.icon-search{--cr-icon-image:url(chrome://resources/images/icon_search.svg)}.icon-settings{--cr-icon-image:url(chrome://resources/images/icon_settings.svg)}.icon-visibility{--cr-icon-image:url(chrome://resources/images/icon_visibility.svg)}.icon-visibility-off{--cr-icon-image:url(chrome://resources/images/icon_visibility_off.svg)}.subpage-arrow{--cr-icon-image:url(chrome://resources/images/arrow_right.svg)}.cr-icon{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-size);background-color:var(--cr-icon-color,var(--google-grey-700));flex-shrink:0;height:var(--cr-icon-ripple-size);margin-inline-end:var(--cr-icon-ripple-margin);margin-inline-start:var(--cr-icon-button-margin-start);user-select:none;width:var(--cr-icon-ripple-size)}:host-context([dir=rtl]) .cr-icon{transform:scaleX(-1)}.cr-icon.no-overlap{margin-inline-end:0;margin-inline-start:0}@media (prefers-color-scheme:dark){.cr-icon{background-color:var(--cr-icon-color,var(--google-grey-500))}}
    </style>
  </template>
`.content);
styleMod$7.register('cr-icons');

const styleMod$6 = document.createElement('dom-module');
styleMod$6.appendChild(html `
  <template>
    <style include="cr-hidden-style cr-icons">
html,:host{--scrollable-border-color:var(--google-grey-300)}@media (prefers-color-scheme:dark){html,:host{--scrollable-border-color:var(--google-grey-700)}}[actionable]{cursor:pointer}.hr{border-top:var(--cr-separator-line)}iron-list.cr-separators>*:not([first]){border-top:var(--cr-separator-line)}[scrollable]{border-color:transparent;border-style:solid;border-width:1px 0;overflow-y:auto}[scrollable].is-scrolled{border-top-color:var(--scrollable-border-color)}[scrollable].can-scroll:not(.scrolled-to-bottom){border-bottom-color:var(--scrollable-border-color)}[scrollable] iron-list>:not(.no-outline):focus,[selectable]:focus,[selectable]>:focus{background-color:var(--cr-focused-item-color);outline:none}.scroll-container{display:flex;flex-direction:column;min-height:1px}[selectable]>*{cursor:pointer}.cr-centered-card-container{box-sizing:border-box;display:block;height:inherit;margin:0 auto;max-width:var(--cr-centered-card-max-width);min-width:550px;position:relative;width:calc(100% * var(--cr-centered-card-width-percentage))}.cr-container-shadow{box-shadow:inset 0 5px 6px -3px rgba(0,0,0,.4);height:var(--cr-container-shadow-height);left:0;margin:0 0 var(--cr-container-shadow-margin);opacity:0;pointer-events:none;position:relative;right:0;top:0;transition:opacity 500ms;z-index:1}#cr-container-shadow-bottom{margin-bottom:0;margin-top:var(--cr-container-shadow-margin);transform:scaleY(-1)}#cr-container-shadow-top.has-shadow,#cr-container-shadow-bottom.has-shadow{opacity:var(--cr-container-shadow-max-opacity)}.cr-row{align-items:center;border-top:var(--cr-separator-line);display:flex;min-height:var(--cr-section-min-height);padding:0 var(--cr-section-padding)}.cr-row.first,.cr-row.continuation{border-top:none}.cr-row-gap{padding-inline-start:16px}.cr-button-gap{margin-inline-start:8px}paper-tooltip::part(tooltip){border-radius:var(--paper-tooltip-border-radius,2px);font-size:92.31%;font-weight:500;max-width:330px;min-width:var(--paper-tooltip-min-width,200px);padding:var(--paper-tooltip-padding,10px 8px)}.cr-padded-text{padding-block-end:var(--cr-section-vertical-padding);padding-block-start:var(--cr-section-vertical-padding)}.cr-title-text{color:var(--cr-title-text-color);font-size:107.6923%;font-weight:500}.cr-secondary-text{color:var(--cr-secondary-text-color);font-weight:400}.cr-form-field-label{color:var(--cr-form-field-label-color);display:block;font-size:var(--cr-form-field-label-font-size);font-weight:500;letter-spacing:.4px;line-height:var(--cr-form-field-label-line-height);margin-bottom:8px}.cr-vertical-tab{align-items:center;display:flex}.cr-vertical-tab::before{border-radius:0 3px 3px 0;content:'';display:block;flex-shrink:0;height:var(--cr-vertical-tab-height,100%);width:4px}.cr-vertical-tab.selected::before{background:var(--cr-vertical-tab-selected-color,var(--cr-checked-color))}:host-context([dir=rtl]) .cr-vertical-tab::before{transform:scaleX(-1)}.iph-anchor-highlight{background-color:var(--cr-iph-anchor-highlight-color)}
    </style>
  </template>
`.content);
styleMod$6.register('cr-shared-style');

function getTemplate$1d() {
    return html `<!--_html_template_start_--><style include="cr-shared-style">:host{--cr-localized-link-display:inline;display:block}:host([link-disabled]){cursor:pointer;opacity:var(--cr-disabled-opacity);pointer-events:none}a{display:var(--cr-localized-link-display)}a[href]{color:var(--cr-link-color)}a[href]:focus{outline-color:var(--cros-sys-focus_ring)}a[is=action-link]{user-select:none}#container{display:contents}</style>
<!-- innerHTML is set via setContainerInnerHtml_. -->
<div id="container"></div>
<!--_html_template_end_-->`;
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'localized-link' takes a localized string that
 * contains up to one anchor tag, and labels the string contained within the
 * anchor tag with the entire localized string. The string should not be bound
 * by element tags. The string should not contain any elements other than the
 * single anchor tagged element that will be aria-labelledby the entire string.
 *
 * Example: "lorem ipsum <a href="example.com">Learn More</a> dolor sit"
 *
 * The "Learn More" will be aria-labelledby like so: "lorem ipsum Learn More
 * dolor sit". Meanwhile, "Lorem ipsum" and "dolor sit" will be aria-hidden.
 *
 * This element also supports strings that do not contain anchor tags; in this
 * case, the element gracefully falls back to normal text. This can be useful
 * when the property is data-bound to a function which sometimes returns a
 * string with a link and sometimes returns a normal string.
 *
 * Forked from ui/webui/resources/ash/common/cr_elements/localized_link/localized_link.ts
 */
class LocalizedLinkElement extends PolymerElement {
    static get is() {
        return 'localized-link';
    }
    static get template() {
        return getTemplate$1d();
    }
    static get properties() {
        return {
            /**
             * The localized string that contains up to one anchor tag, the text
             * within which will be aria-labelledby the entire localizedString.
             */
            localizedString: String,
            /**
             * If provided, the URL that the anchor tag will point to. There is no
             * need to provide a linkUrl if the URL is embedded in the
             * localizedString.
             */
            linkUrl: {
                type: String,
                value: '',
            },
            /**
             * If true, localized link will be disabled.
             */
            linkDisabled: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
                observer: 'updateAnchorTagTabIndex_',
            },
            /**
             * localizedString, with aria attributes and the optionally provided link.
             */
            containerInnerHTML_: {
                type: String,
                value: '',
                computed: 'getAriaLabelledContent_(localizedString, linkUrl)',
                observer: 'setContainerInnerHtml_',
            },
        };
    }
    /**
     * Attaches aria attributes and optionally provided link to the provided
     * localizedString.
     * @return localizedString formatted with additional ids, spans, and an
     *     aria-labelledby tag
     */
    getAriaLabelledContent_(localizedString, linkUrl) {
        const tempEl = document.createElement('div');
        tempEl.innerHTML = sanitizeInnerHtml(localizedString, { attrs: ['id'] });
        const ariaLabelledByIds = [];
        tempEl.childNodes.forEach((node, index) => {
            // Text nodes should be aria-hidden and associated with an element id
            // that the anchor element can be aria-labelledby.
            if (node.nodeType === Node.TEXT_NODE) {
                const spanNode = document.createElement('span');
                spanNode.textContent = node.textContent;
                spanNode.id = `id${index}`;
                ariaLabelledByIds.push(spanNode.id);
                spanNode.setAttribute('aria-hidden', 'true');
                node.replaceWith(spanNode);
                return;
            }
            // The single element node with anchor tags should also be aria-labelledby
            // itself in-order with respect to the entire string.
            if (node.nodeType === Node.ELEMENT_NODE && node.nodeName === 'A') {
                const element = node;
                element.id = `id${index}`;
                ariaLabelledByIds.push(element.id);
                return;
            }
            // Only text and <a> nodes are allowed.
            assertNotReached('localized-link has invalid node types');
        });
        const anchorTags = tempEl.querySelectorAll('a');
        // In the event the provided localizedString contains only text nodes,
        // populate the contents with the provided localizedString.
        if (anchorTags.length === 0) {
            return localizedString;
        }
        assert$1(anchorTags.length === 1, 'localized-link should contain exactly one anchor tag');
        const anchorTag = anchorTags[0];
        anchorTag.setAttribute('aria-labelledby', ariaLabelledByIds.join(' '));
        anchorTag.tabIndex = this.linkDisabled ? -1 : 0;
        if (linkUrl !== '') {
            anchorTag.href = linkUrl;
            anchorTag.target = '_blank';
        }
        return tempEl.innerHTML;
    }
    setContainerInnerHtml_() {
        this.$.container.innerHTML = sanitizeInnerHtml(this.containerInnerHTML_, {
            attrs: [
                'aria-hidden',
                'aria-labelledby',
                'id',
                'tabindex',
            ],
        });
        const anchorTag = this.shadowRoot.querySelector('a');
        if (anchorTag) {
            anchorTag.addEventListener('click', (event) => this.onAnchorTagClick_(event));
            anchorTag.addEventListener('auxclick', (event) => {
                // trigger the click handler on middle-button clicks
                if (event.button === 1) {
                    this.onAnchorTagClick_(event);
                }
            });
        }
    }
    onAnchorTagClick_(event) {
        if (this.linkDisabled) {
            event.preventDefault();
            return;
        }
        this.dispatchEvent(new CustomEvent('link-clicked', { bubbles: true, composed: true, detail: { event } }));
        // Stop propagation of the event, since it has already been handled by
        // opening the link.
        event.stopPropagation();
    }
    /**
     *  Removes anchor tag from being targeted by chromeVox when link is
     *  disabled.
     */
    updateAnchorTagTabIndex_() {
        const anchorTag = this.shadowRoot.querySelector('a');
        if (!anchorTag) {
            return;
        }
        anchorTag.tabIndex = this.linkDisabled ? -1 : 0;
    }
}
customElements.define(LocalizedLinkElement.is, LocalizedLinkElement);

const styleMod$5 = document.createElement('dom-module');
styleMod$5.appendChild(html `
  <template>
    <style>
cr-button{border-color:var(--cros-button-stroke-color-secondary);border-radius:16px}cr-button.primary{background-color:var(--cros-button-background-color-primary);border:0;--text-color:var(--cros-button-label-color-primary);--ink-color:var(--cros-button-ripple-color-primary);--hover-bg-color:var(--cros-button-background-color-primary-hover-preblended);--disabled-bg:var(--cros-button-background-color-primary-disabled);--disabled-text-color:var(--cros-button-label-color-primary-disabled)}cr-button.primary:active{box-shadow:none}cr-button.primary:hover{background-color:var(--cros-button-background-color-primary-hover-preblended)}cr-button.secondary{background-color:var(--cros-button-background-color-secondary);border:1px solid var(--cros-button-stroke-color-secondary);--text-color:var(--cros-button-label-color-secondary);--border-color:var(--cros-button-stroke-color-secondary);--ink-color:var(--cros-button-ripple-color-secondary);--hover-border-color:var(--cros-button-stroke-color-secondary-hover);--hover-bg-color:var(--cros-button-background-color-secondary-hover);--disabled-text-color:var(--cros-button-label-color-secondary-disabled);--disabled-border-color:var(--cros-button-stroke-color-secondary-disabled)}cr-button.secondary:hover{background-color:var(--cros-button-background-color-secondary-hover)}cr-icon-button:focus-visible,cr-button:focus-visible{box-shadow:none;outline:2px solid var(--cros-sys-focus_ring,rgba(var(--cros-focus-ring-color-rgb),0.8))}cr-icon-button:hover,cr-button:hover{background-color:var(--cros-ripple-color);box-shadow:none}cr-button[aria-pressed=true],cr-button[aria-selected=true]{background-color:var(--cros-sys-highlight_shape,var(--cros-highlight-color));border:none}iron-icon{--iron-icon-height:20px;--iron-icon-width:20px}cr-icon-button{--cr-icon-button-fill-color:var(--cros-menu-icon-color)}
    </style>
  </template>
`.content);
styleMod$5.register('cros-button-style');

function getTemplate$1c() {
    return html `<!--_html_template_start_--><style include="common cros-button-style">cr-dialog::part(dialog){min-width:288px;width:288px}</style>
<cr-dialog id="dialog" show-on-attach>
  <div slot="body">$i18n{ambientModeLastArtAlbumMessage}</div>
  <div slot="button-container">
    <cr-button class="action-button primary" on-click="onClose_">
      $i18n{ambientModeArtAlbumDialogCloseButtonLabel}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview The element for displaying information for art albums.
 */
class ArtAlbumDialogElement extends WithPersonalizationStore {
    static get is() {
        return 'art-album-dialog';
    }
    static get template() {
        return getTemplate$1c();
    }
    static get properties() {
        return {};
    }
    onClose_() {
        if (this.$.dialog.open) {
            this.$.dialog.close();
        }
    }
}
customElements.define(ArtAlbumDialogElement.is, ArtAlbumDialogElement);

// Copyright 2012 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * The class name to set on the document element.
 */
const CLASS_NAME = 'focus-outline-visible';
const docsToManager = new Map();
/**
 * This class sets a CSS class name on the HTML element of |doc| when the user
 * presses a key. It removes the class name when the user clicks anywhere.
 *
 * This allows you to write CSS like this:
 *
 * html.focus-outline-visible my-element:focus {
 *   outline: 5px auto -webkit-focus-ring-color;
 * }
 *
 * And the outline will only be shown if the user uses the keyboard to get to
 * it.
 *
 */
class FocusOutlineManager {
    // Whether focus change is triggered by a keyboard event.
    focusByKeyboard_ = true;
    classList_;
    /**
     * @param doc The document to attach the focus outline manager to.
     */
    constructor(doc) {
        this.classList_ = doc.documentElement.classList;
        doc.addEventListener('keydown', (e) => this.onEvent_(true, e), true);
        doc.addEventListener('mousedown', (e) => this.onEvent_(false, e), true);
        this.updateVisibility();
    }
    onEvent_(focusByKeyboard, e) {
        if (this.focusByKeyboard_ === focusByKeyboard) {
            return;
        }
        if (e instanceof KeyboardEvent && e.repeat) {
            // A repeated keydown should not trigger the focus state. For example,
            // there is a repeated ALT keydown if ALT+CLICK is used to open the
            // context menu and ALT is not released.
            return;
        }
        this.focusByKeyboard_ = focusByKeyboard;
        this.updateVisibility();
    }
    updateVisibility() {
        this.visible = this.focusByKeyboard_;
    }
    /**
     * Whether the focus outline should be visible.
     */
    set visible(visible) {
        this.classList_.toggle(CLASS_NAME, visible);
    }
    get visible() {
        return this.classList_.contains(CLASS_NAME);
    }
    /**
     * Gets a per document singleton focus outline manager.
     * @param doc The document to get the |FocusOutlineManager| for.
     * @return The per document singleton focus outline manager.
     */
    static forDocument(doc) {
        let manager = docsToManager.get(doc);
        if (!manager) {
            manager = new FocusOutlineManager(doc);
            docsToManager.set(doc, manager);
        }
        return manager;
    }
}

var MAX_RADIUS_PX = 300;
var MIN_DURATION_MS = 800;

/**
 * @param {number} x1
 * @param {number} y1
 * @param {number} x2
 * @param {number} y2
 * @return {number} The distance between (x1, y1) and (x2, y2).
 */
var distance = function(x1, y1, x2, y2) {
  var xDelta = x1 - x2;
  var yDelta = y1 - y2;
  return Math.sqrt(xDelta * xDelta + yDelta * yDelta);
};

Polymer({
  _template: html`
    <style>
      :host {
        bottom: 0;
        display: block;
        left: 0;
        overflow: hidden;
        pointer-events: none;
        position: absolute;
        right: 0;
        top: 0;
        /* For rounded corners: http://jsbin.com/temexa/4. */
        transform: translate3d(0, 0, 0);
      }

      .ripple {
        background-color: currentcolor;
        left: 0;
        opacity: var(--paper-ripple-opacity, 0.25);
        pointer-events: none;
        position: absolute;
        will-change: height, transform, width;
      }

      .ripple,
      :host(.circle) {
        border-radius: 50%;
      }
    </style>
`,

  is: 'paper-ripple',
  behaviors: [IronA11yKeysBehavior],

  properties: {
    center: {type: Boolean, value: false},
    holdDown: {type: Boolean, value: false, observer: '_holdDownChanged'},
    recenters: {type: Boolean, value: false},
    noink: {type: Boolean, value: false},
  },

  keyBindings: {
    'enter:keydown': '_onEnterKeydown',
    'space:keydown': '_onSpaceKeydown',
    'space:keyup': '_onSpaceKeyup',
  },

  /** @override */
  created: function() {
    /** @type {Array<!Element>} */
    this.ripples = [];
  },

  /** @override */
  attached: function() {
    this.keyEventTarget = this.parentNode.nodeType == 11 ?
        dom(this).getOwnerRoot().host : this.parentNode;
    this.keyEventTarget = /** @type {!EventTarget} */ (this.keyEventTarget);
    this.listen(this.keyEventTarget, 'up', 'uiUpAction');
    this.listen(this.keyEventTarget, 'down', 'uiDownAction');
  },

  /** @override */
  detached: function() {
    this.unlisten(this.keyEventTarget, 'up', 'uiUpAction');
    this.unlisten(this.keyEventTarget, 'down', 'uiDownAction');
    this.keyEventTarget = null;
  },

  simulatedRipple: function() {
    this.downAction();
    // Using a 1ms delay ensures a macro-task.
    this.async(function() { this.upAction(); }.bind(this), 1);
  },

  /** @param {Event=} e */
  uiDownAction: function(e) {
    if (!this.noink)
      this.downAction(e);
  },

  /** @param {Event=} e */
  downAction: function(e) {
    if (this.ripples.length && this.holdDown)
      return;
    // TODO(dbeam): some things (i.e. paper-icon-button-light) dynamically
    // create ripples on 'up', Ripples register an event listener on their
    // parent (or shadow DOM host) when attached().  This sometimes causes
    // duplicate events to fire on us.
    this.debounce('show ripple', function() { this.__showRipple(e); }, 1);
  },

  clear: function() {
    this.__hideRipple();
    this.holdDown = false;
  },

  showAndHoldDown: function() {
    this.ripples.forEach(ripple => {
      ripple.remove();
    });
    this.ripples = [];
    this.holdDown = true;
  },

  /**
   * @param {Event=} e
   * @private
   * @suppress {checkTypes}
   */
  __showRipple: function(e) {
    var rect = this.getBoundingClientRect();

    var roundedCenterX = function() { return Math.round(rect.width / 2); };
    var roundedCenterY = function() { return Math.round(rect.height / 2); };

    var centered = !e || this.center;
    if (centered) {
      var x = roundedCenterX();
      var y = roundedCenterY();
    } else {
      var sourceEvent = e.detail.sourceEvent;
      var x = Math.round(sourceEvent.clientX - rect.left);
      var y = Math.round(sourceEvent.clientY - rect.top);
    }

    var corners = [
      {x: 0, y: 0},
      {x: rect.width, y: 0},
      {x: 0, y: rect.height},
      {x: rect.width, y: rect.height},
    ];

    var cornerDistances = corners.map(function(corner) {
      return Math.round(distance(x, y, corner.x, corner.y));
    });

    var radius = Math.min(MAX_RADIUS_PX, Math.max.apply(Math, cornerDistances));

    var startTranslate = (x - radius) + 'px, ' + (y - radius) + 'px';
    if (this.recenters && !centered) {
      var endTranslate = (roundedCenterX() - radius) + 'px, ' +
                         (roundedCenterY() - radius) + 'px';
    } else {
      var endTranslate = startTranslate;
    }

    var ripple = document.createElement('div');
    ripple.classList.add('ripple');
    ripple.style.height = ripple.style.width = (2 * radius) + 'px';

    this.ripples.push(ripple);
    this.shadowRoot.appendChild(ripple);

    ripple.animate({
      // TODO(dbeam): scale to 90% of radius at .75 offset?
      transform: ['translate(' + startTranslate + ') scale(0)',
                  'translate(' + endTranslate + ') scale(1)'],
    }, {
      duration: Math.max(MIN_DURATION_MS, Math.log(radius) * radius) || 0,
      easing: 'cubic-bezier(.2, .9, .1, .9)',
      fill: 'forwards',
    });
  },

  /** @param {Event=} e */
  uiUpAction: function(e) {
    if (!this.noink)
      this.upAction();
  },

  /** @param {Event=} e */
  upAction: function(e) {
    if (!this.holdDown)
      this.debounce('hide ripple', function() { this.__hideRipple(); }, 1);
  },

  /**
   * @private
   * @suppress {checkTypes}
   */
  __hideRipple: function() {
    Promise.all(this.ripples.map(function(ripple) {
      return new Promise(function(resolve) {
        var removeRipple = function() {
          ripple.remove();
          resolve();
        };
        var opacity = getComputedStyle(ripple).opacity;
        if (!opacity.length) {
          removeRipple();
        } else {
          var animation = ripple.animate({
            opacity: [opacity, 0],
          }, {
            duration: 150,
            fill: 'forwards',
          });
          animation.addEventListener('finish', removeRipple);
          animation.addEventListener('cancel', removeRipple);
        }
      });
    })).then(function() { this.fire('transitionend'); }.bind(this));
    this.ripples = [];
  },

  /** @protected */
  _onEnterKeydown: function() {
    this.uiDownAction();
    this.async(this.uiUpAction, 1);
  },

  /** @protected */
  _onSpaceKeydown: function() {
    this.uiDownAction();
  },

  /** @protected */
  _onSpaceKeyup: function() {
    this.uiUpAction();
  },

  /** @protected */
  _holdDownChanged: function(newHoldDown, oldHoldDown) {
    if (oldHoldDown === undefined)
      return;
    if (newHoldDown)
      this.downAction();
    else
      this.upAction();
  },
});

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * Note: This file is forked from Polymer's paper-ripple-behavior.js
 *
 * `PaperRippleMixin` dynamically implements a ripple when the element has
 * focus via pointer or keyboard.
 */

const PaperRippleMixin = dedupingMixin(superClass => {
  class PaperRippleMixin extends superClass {
    static get properties() {
      return {
        /**
         * If true, the element will not produce a ripple effect when interacted
         * with via the pointer.
         */
        noink: {type: Boolean, observer: '_noinkChanged'},

        /**
         * @type {Element|undefined}
         */
        _rippleContainer: Object,
      };
    }


    /**
     * Ensures this element contains a ripple effect. For startup efficiency
     * the ripple effect is dynamically on demand when needed.
     */
    ensureRipple() {
      if (this.hasRipple()) {
        return;
      }

      this._ripple = this._createRipple();
      this._ripple.noink = this.noink;
      var rippleContainer = this._rippleContainer || this.root;
      if (rippleContainer) {
        rippleContainer.appendChild(this._ripple);
      }
    }

    /**
     * Returns the `<paper-ripple>` element used by this element to create
     * ripple effects. The element's ripple is created on demand, when
     * necessary, and calling this method will force the
     * ripple to be created.
     */
    getRipple() {
      this.ensureRipple();
      return this._ripple;
    }

    /**
     * Returns true if this element currently contains a ripple effect.
     * @return {boolean}
     */
    hasRipple() {
      return Boolean(this._ripple);
    }

    /**
     * Create the element's ripple effect via creating a `<paper-ripple>`.
     * Override this method to customize the ripple element.
     * @return {!PaperRippleElement} Returns a `<paper-ripple>` element.
     */
    _createRipple() {
      var element = /** @type {!PaperRippleElement} */ (
          document.createElement('paper-ripple'));
      return element;
    }

    _noinkChanged(noink) {
      if (this.hasRipple()) {
        this._ripple.noink = noink;
      }
    }
  }

  return PaperRippleMixin;
});

function getTemplate$1b() {
    return html `<!--_html_template_start_--><style include="cr-hidden-style">:host{--active-shadow-rgb:var(--google-grey-800-rgb);--active-shadow-action-rgb:var(--google-blue-500-rgb);--bg-action:var(--google-blue-600);--border-color:var(--google-grey-300);--disabled-bg-action:var(--google-grey-100);--disabled-bg:white;--disabled-border-color:var(--google-grey-100);--disabled-text-color:var(--google-grey-600);--focus-shadow-color:rgba(var(--google-blue-600-rgb),.4);--hover-bg-action:rgba(var(--google-blue-600-rgb),.9);--hover-bg-color:rgba(var(--google-blue-500-rgb),.04);--hover-border-color:var(--google-blue-100);--hover-shadow-action-rgb:var(--google-blue-500-rgb);--ink-color-action:white;--ink-color:var(--google-blue-600);--ripple-opacity-action:.32;--ripple-opacity:.1;--text-color-action:white;--text-color:var(--google-blue-600)}@media (prefers-color-scheme:dark){:host{--active-bg:black linear-gradient(rgba(255,255,255,.06),rgba(255,255,255,.06));--active-shadow-rgb:0,0,0;--active-shadow-action-rgb:var(--google-blue-500-rgb);--bg-action:var(--google-blue-300);--border-color:var(--google-grey-700);--disabled-bg-action:var(--google-grey-800);--disabled-bg:transparent;--disabled-border-color:var(--google-grey-800);--disabled-text-color:var(--google-grey-500);--focus-shadow-color:rgba(var(--google-blue-300-rgb),.5);--hover-bg-action:var(--bg-action) linear-gradient(rgba(0,0,0,.08),rgba(0,0,0,.08));--hover-bg-color:rgba(var(--google-blue-300-rgb),.08);--ink-color-action:black;--ink-color:var(--google-blue-300);--ripple-opacity-action:.16;--ripple-opacity:.16;--text-color-action:var(--google-grey-900);--text-color:var(--google-blue-300)}}:host{--paper-ripple-opacity:var(--ripple-opacity);-webkit-tap-highlight-color:transparent;align-items:center;border:1px solid var(--border-color);border-radius:4px;box-sizing:border-box;color:var(--text-color);cursor:pointer;display:inline-flex;flex-shrink:0;font-weight:500;height:var(--cr-button-height);justify-content:center;min-width:5.14em;outline-width:0;overflow:hidden;padding:8px 16px;position:relative;user-select:none}:host-context([chrome-refresh-2023]):host{--border-color:var(--color-button-border,var(--cr-fallback-color-tonal-outline));--text-color:var(--color-button-foreground,var(--cr-fallback-color-primary));--hover-bg-color:transparent;--hover-border-color:var(--border-color);--active-bg:transparent;--active-shadow:none;--ink-color:var(--cr-active-background-color);--ripple-opacity:1;--disabled-bg:transparent;--disabled-border-color:var(--color-button-border-disabled,var(--cr-fallback-color-disabled-background));--disabled-text-color:var(--color-button-foreground-disabled,var(--cr-fallback-color-disabled-foreground));--bg-action:var(--color-button-background-prominent,var(--cr-fallback-color-primary));--text-color-action:var(--color-button-foreground-prominent,var(--cr-fallback-color-on-primary));--hover-bg-action:var(--bg-action);--active-shadow-action:none;--ink-color-action:var(--cr-active-background-color);--ripple-opacity-action:1;--disabled-bg-action:var(--color-button-background-prominent-disabled,var(--cr-fallback-color-disabled-background));background:transparent;border-radius:100px;isolation:isolate;line-height:20px}:host([has-prefix-icon_]),:host([has-suffix-icon_]){--iron-icon-height:16px;--iron-icon-width:16px;gap:8px;padding:8px}:host-context([chrome-refresh-2023]):host([has-prefix-icon_]),:host-context([chrome-refresh-2023]):host([has-suffix-icon_]){--iron-icon-height:20px;--iron-icon-width:20px;--icon-block-padding-large:16px;--icon-block-padding-small:12px;padding-block-end:8px;padding-block-start:8px}:host-context([chrome-refresh-2023]):host([has-prefix-icon_]){padding-inline-end:var(--icon-block-padding-large);padding-inline-start:var(--icon-block-padding-small)}:host-context([chrome-refresh-2023]):host([has-suffix-icon_]){padding-inline-end:var(--icon-block-padding-small);padding-inline-start:var(--icon-block-padding-large)}:host-context(.focus-outline-visible):host(:focus){box-shadow:0 0 0 2px var(--focus-shadow-color)}@media (forced-colors:active){:host-context(.focus-outline-visible):host(:focus){outline:var(--cr-focus-outline-hcm)}:host-context([chrome-refresh-2023]):host{forced-color-adjust:none}}:host-context([chrome-refresh-2023].focus-outline-visible):host(:focus){box-shadow:none;outline:2px solid var(--cr-focus-outline-color);outline-offset:2px}:host(:active){background:var(--active-bg);box-shadow:var(--active-shadow,0 1px 2px 0 rgba(var(--active-shadow-rgb),.3),0 3px 6px 2px rgba(var(--active-shadow-rgb),.15))}:host(:hover){background-color:var(--hover-bg-color)}@media (prefers-color-scheme:light){:host(:hover){border-color:var(--hover-border-color)}}#background{border-radius:inherit;inset:0;pointer-events:none;position:absolute;z-index:0}:host-context([chrome-refresh-2023]):host(:hover) #background{background-color:var(--hover-bg-color)}:host-context([chrome-refresh-2023].focus-outline-visible):host(:focus) #background{background-clip:padding-box}:host-context([chrome-refresh-2023]):host(.action-button) #background{background-color:var(--bg-action)}:host-context([chrome-refresh-2023]):host([disabled]) #background{background-color:var(--disabled-bg)}:host-context([chrome-refresh-2023]):host(.action-button[disabled]) #background{background-color:var(--disabled-bg-action)}:host-context([chrome-refresh-2023]):host(.tonal-button) #background,:host-context([chrome-refresh-2023]):host(.floating-button) #background{background-color:var(--color-button-background-tonal,var(--cr-fallback-color-secondary-container))}:host-context([chrome-refresh-2023]):host([disabled].tonal-button) #background,:host-context([chrome-refresh-2023]):host([disabled].floating-button) #background{background-color:var(--color-button-background-tonal-disabled,var(--cr-fallback-color-disabled-background))}#content{display:contents}:host-context([chrome-refresh-2023]) #content{display:inline;z-index:2}:host-context([chrome-refresh-2023]) ::slotted(*){z-index:2}#hoverBackground{content:'';display:none;inset:0;pointer-events:none;position:absolute;z-index:1}:host-context([chrome-refresh-2023]):host(:hover) #hoverBackground{background:var(--cr-hover-background-color);display:block}:host-context([chrome-refresh-2023]):host(.action-button:hover) #hoverBackground{background:var(--cr-hover-on-prominent-background-color)}:host(.action-button){--ink-color:var(--ink-color-action);--paper-ripple-opacity:var(--ripple-opacity-action);background-color:var(--bg-action);border:none;color:var(--text-color-action)}:host-context([chrome-refresh-2023]):host(.action-button){--ink-color:var(--cr-active-on-primary-background-color);background-color:transparent}:host(.action-button:active){box-shadow:var(--active-shadow-action,0 1px 2px 0 rgba(var(--active-shadow-action-rgb),.3),0 3px 6px 2px rgba(var(--active-shadow-action-rgb),.15))}:host(.action-button:hover){background:var(--hover-bg-action)}@media (prefers-color-scheme:light){:host(.action-button:not(:active):hover){box-shadow:0 1px 2px 0 rgba(var(--hover-shadow-action-rgb),.3),0 1px 3px 1px rgba(var(--hover-shadow-action-rgb),.15)}:host-context([chrome-refresh-2023]):host(.action-button:not(:active):hover){box-shadow:none}}:host([disabled]){background-color:var(--disabled-bg);border-color:var(--disabled-border-color);color:var(--disabled-text-color);cursor:auto;pointer-events:none}:host(.action-button[disabled]){background-color:var(--disabled-bg-action);border-color:transparent}:host(.cancel-button){margin-inline-end:8px}:host(.action-button),:host(.cancel-button){line-height:154%}:host-context([chrome-refresh-2023]):host(.tonal-button),:host-context([chrome-refresh-2023]):host(.floating-button){border:none;color:var(--color-button-foreground-tonal,var(--cr-fallback-color-on-tonal-container))}:host-context([chrome-refresh-2023]):host(.tonal-button[disabled]),:host-context([chrome-refresh-2023]):host(.floating-button[disabled]){border:none;color:var(--disabled-text-color)}:host-context([chrome-refresh-2023]):host(.floating-button){border-radius:8px;height:40px;transition:box-shadow 80ms linear}:host-context([chrome-refresh-2023]):host(.floating-button:hover){box-shadow:var(--cr-elevation-3)}paper-ripple{color:var(--ink-color);height:var(--paper-ripple-height);left:var(--paper-ripple-left,0);top:var(--paper-ripple-top,0);width:var(--paper-ripple-width)}:host-context([chrome-refresh-2023]) paper-ripple{z-index:1}</style>

<div id="background"></div>
<slot id="prefixIcon" name="prefix-icon"
    on-slotchange="onPrefixIconSlotChanged_">
</slot>
<span id="content"><slot></slot></span>
<slot id="suffixIcon" name="suffix-icon"
    on-slotchange="onSuffixIconSlotChanged_">
</slot>
<div id="hoverBackground" part="hoverBackground"></div>
<!--_html_template_end_-->`;
}

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'cr-button' is a button which displays slotted elements. It can
 * be interacted with like a normal button using click as well as space and
 * enter to effectively click the button and fire a 'click' event. It can also
 * style an icon inside of the button with the [has-icon] attribute.
 *
 * Forked from ui/webui/resources/cr_elements/cr_button/cr_button.ts
 */
const CrButtonElementBase = PaperRippleMixin(PolymerElement);
class CrButtonElement extends CrButtonElementBase {
    static get is() {
        return 'cr-button';
    }
    static get template() {
        return getTemplate$1b();
    }
    static get properties() {
        return {
            disabled: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
                observer: 'disabledChanged_',
            },
            /**
             * Use this property in order to configure the "tabindex" attribute.
             */
            customTabIndex: {
                type: Number,
                observer: 'applyTabIndex_',
            },
            /**
             * Flag used for formatting ripples on circle shaped cr-buttons.
             * @private
             */
            circleRipple: {
                type: Boolean,
                value: false,
            },
            hasPrefixIcon_: {
                type: Boolean,
                reflectToAttribute: true,
                value: false,
            },
            hasSuffixIcon_: {
                type: Boolean,
                reflectToAttribute: true,
                value: false,
            },
        };
    }
    constructor() {
        super();
        /**
         * It is possible to activate a tab when the space key is pressed down. When
         * this element has focus, the keyup event for the space key should not
         * perform a 'click'. |spaceKeyDown_| tracks when a space pressed and
         * handled by this element. Space keyup will only result in a 'click' when
         * |spaceKeyDown_| is true. |spaceKeyDown_| is set to false when element
         * loses focus.
         */
        this.spaceKeyDown_ = false;
        this.timeoutIds_ = new Set();
        this.addEventListener('blur', this.onBlur_.bind(this));
        // Must be added in constructor so that stopImmediatePropagation() works as
        // expected.
        this.addEventListener('click', this.onClick_.bind(this));
        this.addEventListener('keydown', this.onKeyDown_.bind(this));
        this.addEventListener('keyup', this.onKeyUp_.bind(this));
        this.addEventListener('pointerdown', this.onPointerDown_.bind(this));
    }
    ready() {
        super.ready();
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'button');
        }
        if (!this.hasAttribute('tabindex')) {
            this.setAttribute('tabindex', '0');
        }
        if (!this.hasAttribute('aria-disabled')) {
            this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
        }
        FocusOutlineManager.forDocument(document);
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.timeoutIds_.forEach(clearTimeout);
        this.timeoutIds_.clear();
    }
    setTimeout_(fn, delay) {
        if (!this.isConnected) {
            return;
        }
        const id = setTimeout(() => {
            this.timeoutIds_.delete(id);
            fn();
        }, delay);
        this.timeoutIds_.add(id);
    }
    disabledChanged_(newValue, oldValue) {
        if (!newValue && oldValue === undefined) {
            return;
        }
        if (this.disabled) {
            this.blur();
        }
        this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
        this.applyTabIndex_();
    }
    /**
     * Updates the tabindex HTML attribute to the actual value.
     */
    applyTabIndex_() {
        let value = this.customTabIndex;
        if (value === undefined) {
            value = this.disabled ? -1 : 0;
        }
        this.setAttribute('tabindex', value.toString());
    }
    onBlur_() {
        this.spaceKeyDown_ = false;
        // If a keyup event is never fired (e.g. after keydown the focus is moved to
        // another element), we need to clear the ripple here. 100ms delay was
        // chosen manually as a good time period for the ripple to be visible.
        this.setTimeout_(() => this.getRipple().uiUpAction(), 100);
    }
    onClick_(e) {
        if (this.disabled) {
            e.stopImmediatePropagation();
        }
    }
    onPrefixIconSlotChanged_() {
        this.hasPrefixIcon_ = this.$.prefixIcon.assignedElements().length > 0;
    }
    onSuffixIconSlotChanged_() {
        this.hasSuffixIcon_ = this.$.suffixIcon.assignedElements().length > 0;
    }
    onKeyDown_(e) {
        if (e.key !== ' ' && e.key !== 'Enter') {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        if (e.repeat) {
            return;
        }
        this.getRipple().uiDownAction();
        if (e.key === 'Enter') {
            this.click();
            // Delay was chosen manually as a good time period for the ripple to be
            // visible.
            this.setTimeout_(() => this.getRipple().uiUpAction(), 100);
        }
        else if (e.key === ' ') {
            this.spaceKeyDown_ = true;
        }
    }
    onKeyUp_(e) {
        if (e.key !== ' ' && e.key !== 'Enter') {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        if (this.spaceKeyDown_ && e.key === ' ') {
            this.spaceKeyDown_ = false;
            this.click();
            this.getRipple().uiUpAction();
        }
    }
    onPointerDown_() {
        this.ensureRipple();
    }
    /**
     * Customize the element's ripple. Overriding the '_createRipple' function
     * from PaperRippleMixin.
     */
    /* eslint-disable-next-line @typescript-eslint/naming-convention */
    _createRipple() {
        const ripple = super._createRipple();
        if (this.circleRipple) {
            ripple.setAttribute('center', '');
            ripple.classList.add('circle');
        }
        return ripple;
    }
}
customElements.define(CrButtonElement.is, CrButtonElement);

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/

class IronMeta {
  /**
   * @param {{
   *   type: (string|null|undefined),
   *   key: (string|null|undefined),
   *   value: *,
   * }=} options
   */
  constructor(options) {
    IronMeta[' '](options);

    /** @type {string} */
    this.type = (options && options.type) || 'default';
    /** @type {string|null|undefined} */
    this.key = options && options.key;
    if (options && 'value' in options) {
      /** @type {*} */
      this.value = options.value;
    }
  }

  /** @return {*} */
  get value() {
    var type = this.type;
    var key = this.key;

    if (type && key) {
      return IronMeta.types[type] && IronMeta.types[type][key];
    }
  }

  /** @param {*} value */
  set value(value) {
    var type = this.type;
    var key = this.key;

    if (type && key) {
      type = IronMeta.types[type] = IronMeta.types[type] || {};
      if (value == null) {
        delete type[key];
      } else {
        type[key] = value;
      }
    }
  }

  /** @return {!Array<*>} */
  get list() {
    var type = this.type;

    if (type) {
      var items = IronMeta.types[this.type];
      if (!items) {
        return [];
      }

      return Object.keys(items).map(function(key) {
        return metaDatas[this.type][key];
      }, this);
    }
  }

  /**
   * @param {string} key
   * @return {*}
   */
  byKey(key) {
    this.key = key;
    return this.value;
  }
}
// This function is used to convince Closure not to remove constructor calls
// for instances that are not held anywhere. For example, when
// `new IronMeta({...})` is used only for the side effect of adding a value.
IronMeta[' '] = function() {};

IronMeta.types = {};

var metaDatas = IronMeta.types;

/**
`iron-meta` is a generic element you can use for sharing information across the
DOM tree. It uses [monostate pattern](http://c2.com/cgi/wiki?MonostatePattern)
such that any instance of iron-meta has access to the shared information. You
can use `iron-meta` to share whatever you want (or create an extension [like
x-meta] for enhancements).

The `iron-meta` instances containing your actual data can be loaded in an
import, or constructed in any way you see fit. The only requirement is that you
create them before you try to access them.

Examples:

If I create an instance like this:

    <iron-meta key="info" value="foo/bar"></iron-meta>

Note that value="foo/bar" is the metadata I've defined. I could define more
attributes or use child nodes to define additional metadata.

Now I can access that element (and it's metadata) from any iron-meta instance
via the byKey method, e.g.

    meta.byKey('info');

Pure imperative form would be like:

    document.createElement('iron-meta').byKey('info');

Or, in a Polymer element, you can include a meta in your template:

    <iron-meta id="meta"></iron-meta>
    ...
    this.$.meta.byKey('info');

@group Iron Elements
@demo demo/index.html
@element iron-meta
*/
Polymer({

  is: 'iron-meta',

  properties: {

    /**
     * The type of meta-data.  All meta-data of the same type is stored
     * together.
     * @type {string}
     */
    type: {
      type: String,
      value: 'default',
    },

    /**
     * The key used to store `value` under the `type` namespace.
     * @type {?string}
     */
    key: {
      type: String,
    },

    /**
     * The meta-data to store or retrieve.
     * @type {*}
     */
    value: {
      type: String,
      notify: true,
    },

    /**
     * If true, `value` is set to the iron-meta instance itself.
     */
    self: {type: Boolean, observer: '_selfChanged'},

    __meta: {type: Boolean, computed: '__computeMeta(type, key, value)'}
  },

  hostAttributes: {hidden: true},

  __computeMeta: function(type, key, value) {
    var meta = new IronMeta({type: type, key: key});

    if (value !== undefined && value !== meta.value) {
      meta.value = value;
    } else if (this.value !== meta.value) {
      this.value = meta.value;
    }

    return meta;
  },

  get list() {
    return this.__meta && this.__meta.list;
  },

  _selfChanged: function(self) {
    if (self) {
      this.value = this;
    }
  },

  /**
   * Retrieves meta data value by key.
   *
   * @method byKey
   * @param {string} key The key of the meta-data to be returned.
   * @return {*}
   */
  byKey: function(key) {
    return new IronMeta({type: this.type, key: key}).value;
  }
});

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/

/**

The `iron-icon` element displays an icon. By default an icon renders as a 24px
square.

Example using src:

    <iron-icon src="star.png"></iron-icon>

Example setting size to 32px x 32px:

    <iron-icon class="big" src="big_star.png"></iron-icon>

    <style is="custom-style">
      .big {
        --iron-icon-height: 32px;
        --iron-icon-width: 32px;
      }
    </style>

The iron elements include several sets of icons. To use the default set of
icons, import `iron-icons.js` and use the `icon` attribute to specify an icon:

    <script type="module">
      import "../iron-icons/iron-icons.js";
    </script>

    <iron-icon icon="menu"></iron-icon>

To use a different built-in set of icons, import the specific
`iron-icons/<iconset>-icons.js`, and specify the icon as `<iconset>:<icon>`.
For example, to use a communication icon, you would use:

    <script type="module">
      import "../iron-icons/communication-icons.js";
    </script>

    <iron-icon icon="communication:email"></iron-icon>

You can also create custom icon sets of bitmap or SVG icons.

Example of using an icon named `cherry` from a custom iconset with the ID
`fruit`:

    <iron-icon icon="fruit:cherry"></iron-icon>

See `<iron-iconset>` and `<iron-iconset-svg>` for more information about how to
create a custom iconset.

See the `iron-icons` demo to see the icons available in the various iconsets.

### Styling

The following custom properties are available for styling:

Custom property | Description | Default
----------------|-------------|----------
`--iron-icon` | Mixin applied to the icon | {}
`--iron-icon-width` | Width of the icon | `24px`
`--iron-icon-height` | Height of the icon | `24px`
`--iron-icon-fill-color` | Fill color of the svg icon | `currentcolor`
`--iron-icon-stroke-color` | Stroke color of the svg icon | none

@group Iron Elements
@element iron-icon
@demo demo/index.html
@hero hero.svg
@homepage polymer.github.io
*/
Polymer({
  _template: html`
    <style>
      :host {
        align-items: center;
        display: inline-flex;
        justify-content: center;
        position: relative;

        vertical-align: middle;

        fill: var(--iron-icon-fill-color, currentcolor);
        stroke: var(--iron-icon-stroke-color, none);

        width: var(--iron-icon-width, 24px);
        height: var(--iron-icon-height, 24px);
      }

      :host([hidden]) {
        display: none;
      }
    </style>
`,

  is: 'iron-icon',

  properties: {

    /**
     * The name of the icon to use. The name should be of the form:
     * `iconset_name:icon_name`.
     */
    icon: {type: String},

    /**
     * The name of the theme to used, if one is specified by the
     * iconset.
     */
    theme: {type: String},

    /**
     * If using iron-icon without an iconset, you can set the src to be
     * the URL of an individual icon image file. Note that this will take
     * precedence over a given icon attribute.
     */
    src: {type: String},

    /**
     * @type {!IronMeta}
     */
    _meta: {value: Base$1.create('iron-meta', {type: 'iconset'})}

  },

  observers: [
    '_updateIcon(_meta, isAttached)',
    '_updateIcon(theme, isAttached)',
    '_srcChanged(src, isAttached)',
    '_iconChanged(icon, isAttached)'
  ],

  _DEFAULT_ICONSET: 'icons',

  _iconChanged: function(icon) {
    var parts = (icon || '').split(':');
    this._iconName = parts.pop();
    this._iconsetName = parts.pop() || this._DEFAULT_ICONSET;
    this._updateIcon();
  },

  _srcChanged: function(src) {
    this._updateIcon();
  },

  _usesIconset: function() {
    return this.icon || !this.src;
  },

  /** @suppress {visibility} */
  _updateIcon: function() {
    if (this._usesIconset()) {
      if (this._img && this._img.parentNode) {
        dom(this.root).removeChild(this._img);
      }
      if (this._iconName === '') {
        if (this._iconset) {
          this._iconset.removeIcon(this);
        }
      } else if (this._iconsetName && this._meta) {
        this._iconset = /** @type {?Polymer.Iconset} */ (
            this._meta.byKey(this._iconsetName));
        if (this._iconset) {
          this._iconset.applyIcon(this, this._iconName, this.theme);
          this.unlisten(window, 'iron-iconset-added', '_updateIcon');
        } else {
          this.listen(window, 'iron-iconset-added', '_updateIcon');
        }
      }
    } else {
      if (this._iconset) {
        this._iconset.removeIcon(this);
      }
      if (!this._img) {
        this._img = document.createElement('img');
        this._img.style.width = '100%';
        this._img.style.height = '100%';
        this._img.draggable = false;
      }
      this._img.src = this.src;
      dom(this.root).appendChild(this._img);
    }
  }
});

function getTemplate$1a() {
    return html `<!--_html_template_start_--><style>:host{--cr-icon-button-fill-color:var(--google-grey-700);--cr-icon-button-icon-start-offset:0;--cr-icon-button-icon-size:20px;--cr-icon-button-size:36px;--cr-icon-button-height:var(--cr-icon-button-size);--cr-icon-button-transition:150ms ease-in-out;--cr-icon-button-width:var(--cr-icon-button-size);-webkit-tap-highlight-color:transparent;border-radius:50%;color:var(--cr-icon-button-stroke-color,var(--cr-icon-button-fill-color));cursor:pointer;display:inline-flex;flex-shrink:0;height:var(--cr-icon-button-height);margin-inline-end:var(--cr-icon-button-margin-end,var(--cr-icon-ripple-margin));margin-inline-start:var(--cr-icon-button-margin-start);outline:none;overflow:hidden;user-select:none;vertical-align:middle;width:var(--cr-icon-button-width)}:host-context([chrome-refresh-2023]):host{--cr-icon-button-fill-color:currentColor;--cr-icon-button-size:32px;position:relative}:host(:hover){background-color:var(--cr-icon-button-hover-background-color,var(--cr-hover-background-color))}:host(:focus-visible:focus){box-shadow:inset 0 0 0 2px var(--cr-icon-button-focus-outline-color,var(--cr-focus-outline-color))}@media (forced-colors:active){:host(:focus-visible:focus){outline:var(--cr-focus-outline-hcm)}}:host-context(html:not([chrome-refresh-2023])) :host(:active){background-color:var(--cr-icon-button-active-background-color,var(--cr-active-background-color))}paper-ripple{display:none}:host-context([chrome-refresh-2023]) paper-ripple{--paper-ripple-opacity:1;color:var(--cr-active-background-color);display:block}:host([disabled]){cursor:initial;opacity:var(--cr-disabled-opacity);pointer-events:none}:host(.no-overlap){--cr-icon-button-margin-end:0;--cr-icon-button-margin-start:0}:host-context([dir=rtl]):host(:not([dir=ltr]):not([multiple-icons_])){transform:scaleX(-1)}:host-context([dir=rtl]):host(:not([dir=ltr])[multiple-icons_]) iron-icon{transform:scaleX(-1)}:host(:not([iron-icon])) #maskedImage{-webkit-mask-image:var(--cr-icon-image);-webkit-mask-position:center;-webkit-mask-repeat:no-repeat;-webkit-mask-size:var(--cr-icon-button-icon-size);-webkit-transform:var(--cr-icon-image-transform,none);background-color:var(--cr-icon-button-fill-color);height:100%;transition:background-color var(--cr-icon-button-transition);width:100%}@media (forced-colors:active){:host(:not([iron-icon])) #maskedImage{background-color:ButtonText}}#icon{align-items:center;border-radius:4px;display:flex;height:100%;justify-content:center;padding-inline-start:var(--cr-icon-button-icon-start-offset);position:relative;width:100%}iron-icon{--iron-icon-fill-color:var(--cr-icon-button-fill-color);--iron-icon-stroke-color:var(--cr-icon-button-stroke-color,none);--iron-icon-height:var(--cr-icon-button-icon-size);--iron-icon-width:var(--cr-icon-button-icon-size);transition:fill var(--cr-icon-button-transition),stroke var(--cr-icon-button-transition)}@media (prefers-color-scheme:dark){:host{--cr-icon-button-fill-color:var(--google-grey-500)}}</style>
<div id="icon">
  <div id="maskedImage"></div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'cr-icon-button' is a button which displays an icon with a
 * ripple. It can be interacted with like a normal button using click as well as
 * space and enter to effectively click the button and fire a 'click' event.
 *
 * Forked from ui/webui/resources/cr_elements/cr_icon_button/cr_icon_button.ts
 *
 * There are two sources to icons, cr-icons and iron-iconset-svg. The cr-icon's
 * are defined as background images with a reference to a resource file
 * associated with a CSS class name. The iron-icon's are defined as inline SVG's
 * under a key that is stored in a global map that is accessible to the
 * iron-icon element.
 *
 * Example of using a cr-icon:
 * <link rel="import" href="chrome://resources/ash/common/cr_elements/cr_icons.css.html">
 * <dom-module id="module">
 *   <template>
 *     <style includes="cr-icons"></style>
 *     <cr-icon-button class="icon-class-name"></cr-icon-button>
 *   </template>
 * </dom-module>
 *
 * In general when an icon is specified using a class, the expectation is the
 * class will set an image to the --cr-icon-image variable.
 *
 * Example of using an iron-icon:
 * In the TS file:
 * import 'chrome://resources/ash/common/cr_elements/icons.html.js';
 *
 * In the HTML template file:
 * <cr-icon-button iron-icon="cr:icon-key"></cr-icon-button>
 *
 * The color of the icon can be overridden using CSS variables. When using
 * iron-icon both the fill and stroke can be overridden the variables:
 * --cr-icon-button-fill-color
 * --cr-icon-button-stroke-color
 *
 * When not using iron-icon (ie. specifying --cr-icon-image), the icons support
 * one color and the 'stroke' variables are ignored.
 *
 * When using iron-icon's, more than one icon can be specified by setting
 * the |ironIcon| property to a comma-delimited list of keys.
 */
const CrIconbuttonElementBase = PaperRippleMixin(PolymerElement);
class CrIconButtonElement extends CrIconbuttonElementBase {
    static get is() {
        return 'cr-icon-button';
    }
    static get template() {
        return getTemplate$1a();
    }
    static get properties() {
        return {
            disabled: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
                observer: 'disabledChanged_',
            },
            /**
             * Use this property in order to configure the "tabindex" attribute.
             */
            customTabIndex: {
                type: Number,
                observer: 'applyTabIndex_',
            },
            ironIcon: {
                type: String,
                observer: 'onIronIconChanged_',
                reflectToAttribute: true,
            },
            multipleIcons_: {
                type: Boolean,
                reflectToAttribute: true,
            },
        };
    }
    constructor() {
        super();
        /**
         * It is possible to activate a tab when the space key is pressed down. When
         * this element has focus, the keyup event for the space key should not
         * perform a 'click'. |spaceKeyDown_| tracks when a space pressed and
         * handled by this element. Space keyup will only result in a 'click' when
         * |spaceKeyDown_| is true. |spaceKeyDown_| is set to false when element
         * loses focus.
         */
        this.spaceKeyDown_ = false;
        this.addEventListener('blur', this.onBlur_.bind(this));
        this.addEventListener('click', this.onClick_.bind(this));
        this.addEventListener('keydown', this.onKeyDown_.bind(this));
        this.addEventListener('keyup', this.onKeyUp_.bind(this));
        if (document.documentElement.hasAttribute('chrome-refresh-2023')) {
            this.addEventListener('pointerdown', this.onPointerDown_.bind(this));
        }
    }
    ready() {
        super.ready();
        this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'button');
        }
        if (!this.hasAttribute('tabindex')) {
            this.setAttribute('tabindex', '0');
        }
    }
    toggleClass(className) {
        this.classList.toggle(className);
    }
    disabledChanged_(newValue, oldValue) {
        if (!newValue && oldValue === undefined) {
            return;
        }
        if (this.disabled) {
            this.blur();
        }
        this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
        this.applyTabIndex_();
    }
    /**
     * Updates the tabindex HTML attribute to the actual value.
     */
    applyTabIndex_() {
        let value = this.customTabIndex;
        if (value === undefined) {
            value = this.disabled ? -1 : 0;
        }
        this.setAttribute('tabindex', value.toString());
    }
    onBlur_() {
        this.spaceKeyDown_ = false;
    }
    onClick_(e) {
        if (this.disabled) {
            e.stopImmediatePropagation();
        }
    }
    onIronIconChanged_() {
        this.shadowRoot.querySelectorAll('iron-icon').forEach(el => el.remove());
        if (!this.ironIcon) {
            return;
        }
        const icons = (this.ironIcon || '').split(',');
        this.multipleIcons_ = icons.length > 1;
        icons.forEach(icon => {
            const ironIcon = document.createElement('iron-icon');
            ironIcon.icon = icon;
            this.$.icon.appendChild(ironIcon);
            if (ironIcon.shadowRoot) {
                ironIcon.shadowRoot.querySelectorAll('svg, img')
                    .forEach(child => child.setAttribute('role', 'none'));
            }
        });
    }
    onKeyDown_(e) {
        if (e.key !== ' ' && e.key !== 'Enter') {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        if (e.repeat) {
            return;
        }
        if (e.key === 'Enter') {
            this.click();
        }
        else if (e.key === ' ') {
            this.spaceKeyDown_ = true;
        }
    }
    onKeyUp_(e) {
        if (e.key === ' ' || e.key === 'Enter') {
            e.preventDefault();
            e.stopPropagation();
        }
        if (this.spaceKeyDown_ && e.key === ' ') {
            this.spaceKeyDown_ = false;
            this.click();
        }
    }
    onPointerDown_() {
        this.ensureRipple();
    }
}
customElements.define(CrIconButtonElement.is, CrIconButtonElement);

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview CrContainerShadowMixin holds logic for showing a drop shadow
 * near the top of a container element, when the content has scrolled.
 *
 * Forked from ui/webui/resources/cr_elements/cr_container_shadow_mixin.ts
 *
 * Elements using this mixin are expected to define a #container element,
 * which is the element being scrolled. If the #container element has a
 * show-bottom-shadow attribute, a drop shadow will also be shown near the
 * bottom of the container element, when there is additional content to scroll
 * to. Examples:
 *
 * For both top and bottom shadows:
 * <div id="container" show-bottom-shadow>...</div>
 *
 * For top shadow only:
 * <div id="container">...</div>
 *
 * The mixin will take care of inserting an element with ID
 * 'cr-container-shadow-top' which holds the drop shadow effect, and,
 * optionally, an element with ID 'cr-container-shadow-bottom' which holds the
 * same effect. A 'has-shadow' CSS class is automatically added to/removed from
 * both elements while scrolling, as necessary. Note that the show-bottom-shadow
 * attribute is inspected only during attached(), and any changes to it that
 * occur after that point will not be respected.
 *
 * Clients should either use the existing shared styling in
 * cr_shared_style.css, '#cr-container-shadow-[top/bottom]' and
 * '#cr-container-shadow-[top/bottom].has-shadow', or define their own styles.
 */
var CrContainerShadowSide;
(function (CrContainerShadowSide) {
    CrContainerShadowSide["TOP"] = "top";
    CrContainerShadowSide["BOTTOM"] = "bottom";
})(CrContainerShadowSide || (CrContainerShadowSide = {}));
const CrContainerShadowMixin = dedupingMixin((superClass) => {
    class CrContainerShadowMixin extends superClass {
        constructor() {
            super(...arguments);
            this.intersectionObserver_ = null;
            this.dropShadows_ = new Map();
            this.intersectionProbes_ = new Map();
            this.sides_ = null;
        }
        connectedCallback() {
            super.connectedCallback();
            const hasBottomShadow = this.getContainer_().hasAttribute('show-bottom-shadow');
            this.sides_ = hasBottomShadow ?
                [CrContainerShadowSide.TOP, CrContainerShadowSide.BOTTOM] :
                [CrContainerShadowSide.TOP];
            this.sides_.forEach(side => {
                // The element holding the drop shadow effect to be shown.
                const shadow = document.createElement('div');
                shadow.id = `cr-container-shadow-${side}`;
                shadow.classList.add('cr-container-shadow');
                this.dropShadows_.set(side, shadow);
                this.intersectionProbes_.set(side, document.createElement('div'));
            });
            this.getContainer_().parentNode.insertBefore(this.dropShadows_.get(CrContainerShadowSide.TOP), this.getContainer_());
            this.getContainer_().prepend(this.intersectionProbes_.get(CrContainerShadowSide.TOP));
            if (hasBottomShadow) {
                this.getContainer_().parentNode.insertBefore(this.dropShadows_.get(CrContainerShadowSide.BOTTOM), this.getContainer_().nextSibling);
                this.getContainer_().append(this.intersectionProbes_.get(CrContainerShadowSide.BOTTOM));
            }
            this.enableShadowBehavior(true);
        }
        disconnectedCallback() {
            super.disconnectedCallback();
            this.enableShadowBehavior(false);
        }
        getContainer_() {
            return this.shadowRoot.querySelector('#container');
        }
        getIntersectionObserver_() {
            const callback = (entries) => {
                // In some rare cases, there could be more than one entry per
                // observed element, in which case the last entry's result
                // stands.
                for (const entry of entries) {
                    const target = entry.target;
                    this.sides_.forEach(side => {
                        if (target === this.intersectionProbes_.get(side)) {
                            this.dropShadows_.get(side).classList.toggle('has-shadow', entry.intersectionRatio === 0);
                        }
                    });
                }
            };
            return new IntersectionObserver(callback, { root: this.getContainer_(), threshold: 0 });
        }
        /**
         * @param enable Whether to enable the mixin or disable it.
         *     This function does nothing if the mixin is already in the
         *     requested state.
         */
        enableShadowBehavior(enable) {
            // Behavior is already enabled/disabled. Return early.
            if (enable === !!this.intersectionObserver_) {
                return;
            }
            if (!enable) {
                this.intersectionObserver_.disconnect();
                this.intersectionObserver_ = null;
                return;
            }
            this.intersectionObserver_ = this.getIntersectionObserver_();
            // Need to register the observer within a setTimeout() callback,
            // otherwise the drop shadow flashes once on startup, because of the
            // DOM modifications earlier in this function causing a relayout.
            window.setTimeout(() => {
                if (this.intersectionObserver_) {
                    // In case this is already detached.
                    this.intersectionProbes_.forEach(probe => {
                        this.intersectionObserver_.observe(probe);
                    });
                }
            });
        }
        /**
         * Shows the shadows. The shadow mixin must be disabled before
         * calling this method, otherwise the intersection observer might
         * show the shadows again.
         */
        showDropShadows() {
            assert$1(!this.intersectionObserver_);
            assert$1(this.sides_);
            for (const side of this.sides_) {
                this.dropShadows_.get(side).classList.toggle('has-shadow', true);
            }
        }
    }
    return CrContainerShadowMixin;
});

function getTemplate$19() {
    return html `<!--_html_template_start_--><style include="cr-hidden-style cr-icons">dialog{--cr-dialog-background-color:var(--cros-sys-dialog_container);--cr-dialog-border-radius:20px;--cr-dialog-title-font:var(--cros-display-7-font);--scroll-border-color:#e0e0e0;--scroll-border:1px solid var(--scroll-border-color);background-color:var(--cr-dialog-background-color);border:0;border-radius:var(--cr-dialog-border-radius);bottom:50%;box-shadow:var(--cros-sys-app-elevation-3-shadow);color:inherit;max-height:initial;max-width:initial;overflow-y:hidden;padding:0;position:absolute;top:50%;width:var(--cr-dialog-width,512px)}@media (prefers-color-scheme:dark){dialog{--scroll-border-color:var(--google-grey-700)}}@media (forced-colors:active){dialog{border:var(--cr-border-hcm)}}dialog[open] #content-wrapper{display:flex;flex-direction:column;max-height:100vh;overflow:auto}.top-container,:host ::slotted([slot=button-container]),:host ::slotted([slot=footer]){flex-shrink:0}dialog::backdrop{background-color:rgba(0,0,0,0.6);bottom:0;left:0;position:fixed;right:0;top:0}:host ::slotted([slot=body]){color:var(--cr-secondary-text-color);padding:0 var(--cr-dialog-body-padding-horizontal,20px)}:host ::slotted([slot=title]){color:var(--cr-primary-text-color);flex:1;font:var(--cr-dialog-title-font);padding-bottom:var(--cr-dialog-title-slot-padding-bottom,16px);padding-inline-end:var(--cr-dialog-title-slot-padding-end,20px);padding-inline-start:var(--cr-dialog-title-slot-padding-start,20px);padding-top:var(--cr-dialog-title-slot-padding-top,20px)}:host ::slotted([slot=button-container]){display:flex;justify-content:flex-end;padding-bottom:var(--cr-dialog-button-container-padding-bottom,16px);padding-inline-end:var(--cr-dialog-button-container-padding-horizontal,16px);padding-inline-start:var(--cr-dialog-button-container-padding-horizontal,16px);padding-top:var(--cr-dialog-button-container-padding-top,16px)}:host ::slotted([slot=footer]){border-bottom-left-radius:inherit;border-bottom-right-radius:inherit;border-top:1px solid #dbdbdb;margin:0;padding:16px 20px}:host([hide-backdrop]) dialog::backdrop{opacity:0}@media (prefers-color-scheme:dark){:host ::slotted([slot=footer]){border-top-color:var(--cr-separator-color)}}.body-container{box-sizing:border-box;display:flex;flex-direction:column;min-height:1.375rem;overflow:auto}:host{--transparent-border:1px solid transparent}#cr-container-shadow-top{border-bottom:var(--cr-dialog-body-border-top,var(--transparent-border))}#cr-container-shadow-bottom{border-bottom:var(--cr-dialog-body-border-bottom,var(--transparent-border))}#cr-container-shadow-top.has-shadow,#cr-container-shadow-bottom.has-shadow{border-bottom:var(--scroll-border)}.top-container{align-items:flex-start;display:flex;min-height:var(--cr-dialog-top-container-min-height,31px)}.title-container{display:flex;flex:1;font-size:inherit;font-weight:inherit;margin:0;outline:none}#close{align-self:flex-start;margin-inline-end:4px;margin-top:4px}</style>
<dialog id="dialog" on-close="onNativeDialogClose_"
    on-cancel="onNativeDialogCancel_" part="dialog"
    aria-labelledby="title" aria-description$="[[ariaDescriptionText]]">
<!-- This wrapper is necessary, such that the "pulse" animation is not
    erroneously played when the user clicks on the outer-most scrollbar. -->
  <div id="content-wrapper" part="wrapper">
    <div class="top-container">
      <h2 id="title" class="title-container" tabindex="-1">
        <slot name="title"></slot>
      </h2>
      <cr-icon-button id="close" class="icon-clear"
          hidden$="[[!showCloseButton]]" aria-label$="[[closeText]]"
          on-click="cancel" on-keypress="onCloseKeypress_">
      </cr-icon-button>
    </div>
    <slot name="header"></slot>
    <div class="body-container" id="container" show-bottom-shadow
        part="body-container">
      <slot name="body"></slot>
    </div>
    <slot name="button-container"></slot>
    <slot name="footer"></slot>
  </div>
</dialog>
<!--_html_template_end_-->`;
}

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview 'cr-dialog' is a component for showing a modal dialog. If the
 * dialog is closed via close(), a 'close' event is fired. If the dialog is
 * canceled via cancel(), a 'cancel' event is fired followed by a 'close' event.
 *
 * Additionally clients can get a reference to the internal native <dialog> via
 * calling getNative() and inspecting the |returnValue| property inside
 * the 'close' event listener to determine whether it was canceled or just
 * closed, where a truthy value means success, and a falsy value means it was
 * canceled.
 *
 * Note that <cr-dialog> wrapper itself always has 0x0 dimensions, and
 * specifying width/height on <cr-dialog> directly will have no effect on the
 * internal native <dialog>. Instead use cr-dialog::part(dialog) to specify
 * width/height (as well as other available mixins to style other parts of the
 * dialog contents).
 *
 * Forked from ui/webui/resources/cr_elements/cr_dialog/cr_dialog.ts
 */
const CrDialogElementBase = CrContainerShadowMixin(PolymerElement);
class CrDialogElement extends CrDialogElementBase {
    constructor() {
        super(...arguments);
        this.intersectionObserver_ = null;
        this.mutationObserver_ = null;
        this.boundKeydown_ = null;
    }
    static get is() {
        return 'cr-dialog';
    }
    static get template() {
        return getTemplate$19();
    }
    static get properties() {
        return {
            open: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            /**
             * Alt-text for the dialog close button.
             */
            closeText: String,
            /**
             * True if the dialog should remain open on 'popstate' events. This is
             * used for navigable dialogs that have their separate navigation handling
             * code.
             */
            ignorePopstate: {
                type: Boolean,
                value: false,
            },
            /**
             * True if the dialog should ignore 'Enter' keypresses.
             */
            ignoreEnterKey: {
                type: Boolean,
                value: false,
            },
            /**
             * True if the dialog should consume 'keydown' events. If ignoreEnterKey
             * is true, 'Enter' key won't be consumed.
             */
            consumeKeydownEvent: {
                type: Boolean,
                value: false,
            },
            /**
             * True if the dialog should not be able to be cancelled, which will
             * prevent 'Escape' key presses from closing the dialog.
             */
            noCancel: {
                type: Boolean,
                value: false,
            },
            // True if dialog should show the 'X' close button.
            showCloseButton: {
                type: Boolean,
                value: false,
            },
            showOnAttach: {
                type: Boolean,
                value: false,
            },
            /**
             * Text for the aria description.
             */
            ariaDescriptionText: String,
        };
    }
    ready() {
        super.ready();
        // If the active history entry changes (i.e. user clicks back button),
        // all open dialogs should be cancelled.
        window.addEventListener('popstate', () => {
            if (!this.ignorePopstate && this.$.dialog.open) {
                this.cancel();
            }
        });
        if (!this.ignoreEnterKey) {
            this.addEventListener('keypress', this.onKeypress_.bind(this));
        }
        this.addEventListener('pointerdown', e => this.onPointerdown_(e));
    }
    connectedCallback() {
        super.connectedCallback();
        const mutationObserverCallback = () => {
            if (this.$.dialog.open) {
                this.enableShadowBehavior(true);
                this.addKeydownListener_();
            }
            else {
                this.enableShadowBehavior(false);
                this.removeKeydownListener_();
            }
        };
        this.mutationObserver_ = new MutationObserver(mutationObserverCallback);
        this.mutationObserver_.observe(this.$.dialog, {
            attributes: true,
            attributeFilter: ['open'],
        });
        // In some cases dialog already has the 'open' attribute by this point.
        mutationObserverCallback();
        if (this.showOnAttach) {
            this.showModal();
        }
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.removeKeydownListener_();
        if (this.mutationObserver_) {
            this.mutationObserver_.disconnect();
            this.mutationObserver_ = null;
        }
    }
    addKeydownListener_() {
        if (!this.consumeKeydownEvent) {
            return;
        }
        this.boundKeydown_ = this.boundKeydown_ || this.onKeydown_.bind(this);
        this.addEventListener('keydown', this.boundKeydown_);
        // Sometimes <body> is key event's target and in that case the event
        // will bypass cr-dialog. We should consume those events too in order to
        // behave modally. This prevents accidentally triggering keyboard commands.
        document.body.addEventListener('keydown', this.boundKeydown_);
    }
    removeKeydownListener_() {
        if (!this.boundKeydown_) {
            return;
        }
        this.removeEventListener('keydown', this.boundKeydown_);
        document.body.removeEventListener('keydown', this.boundKeydown_);
        this.boundKeydown_ = null;
    }
    showModal() {
        this.$.dialog.showModal();
        assert$1(this.$.dialog.open);
        this.open = true;
        this.dispatchEvent(new CustomEvent('cr-dialog-open', { bubbles: true, composed: true }));
    }
    cancel() {
        this.dispatchEvent(new CustomEvent('cancel', { bubbles: true, composed: true }));
        this.$.dialog.close();
        assert$1(!this.$.dialog.open);
        this.open = false;
    }
    close() {
        this.$.dialog.close('success');
        assert$1(!this.$.dialog.open);
        this.open = false;
    }
    /**
     * Set the title of the dialog for a11y reader.
     * @param title Title of the dialog.
     */
    setTitleAriaLabel(title) {
        this.$.dialog.removeAttribute('aria-labelledby');
        this.$.dialog.setAttribute('aria-label', title);
    }
    onCloseKeypress_(e) {
        // Because the dialog may have a default Enter key handler, prevent
        // keypress events from bubbling up from this element.
        e.stopPropagation();
    }
    onNativeDialogClose_(e) {
        // Ignore any 'close' events not fired directly by the <dialog> element.
        if (e.target !== this.getNative()) {
            return;
        }
        // Catch and re-fire the 'close' event such that it bubbles across Shadow
        // DOM v1.
        this.dispatchEvent(new CustomEvent('close', { bubbles: true, composed: true }));
    }
    onNativeDialogCancel_(e) {
        // Ignore any 'cancel' events not fired directly by the <dialog> element.
        if (e.target !== this.getNative()) {
            return;
        }
        if (this.noCancel) {
            e.preventDefault();
            return;
        }
        // When the dialog is dismissed using the 'Esc' key, need to manually update
        // the |open| property (since close() is not called).
        this.open = false;
        // Catch and re-fire the native 'cancel' event such that it bubbles across
        // Shadow DOM v1.
        this.dispatchEvent(new CustomEvent('cancel', { bubbles: true, composed: true }));
    }
    /**
     * Expose the inner native <dialog> for some rare cases where it needs to be
     * directly accessed (for example to programmatically setheight/width, which
     * would not work on the wrapper).
     */
    getNative() {
        return this.$.dialog;
    }
    onKeypress_(e) {
        if (e.key !== 'Enter') {
            return;
        }
        // Accept Enter keys from either the dialog itself, or a child cr-input,
        // considering that the event may have been retargeted, for example if the
        // cr-input is nested inside another element. Also exclude inputs of type
        // 'search', since hitting 'Enter' on a search field most likely intends to
        // trigger searching.
        const accept = e.target === this ||
            e.composedPath().some(el => el.tagName === 'CR-INPUT' &&
                el.type !== 'search');
        if (!accept) {
            return;
        }
        const actionButton = this.querySelector('.action-button:not([disabled]):not([hidden])');
        if (actionButton) {
            actionButton.click();
            e.preventDefault();
        }
    }
    onKeydown_(e) {
        assert$1(this.consumeKeydownEvent);
        if (!this.getNative().open) {
            return;
        }
        if (this.ignoreEnterKey && e.key === 'Enter') {
            return;
        }
        // Stop propagation to behave modally.
        e.stopPropagation();
    }
    onPointerdown_(e) {
        // Only show pulse animation if user left-clicked outside of the dialog
        // contents.
        if (e.button !== 0 ||
            e.composedPath()[0].tagName !== 'DIALOG') {
            return;
        }
        this.$.dialog.animate([
            { transform: 'scale(1)', offset: 0 },
            { transform: 'scale(1.02)', offset: 0.4 },
            { transform: 'scale(1.02)', offset: 0.6 },
            { transform: 'scale(1)', offset: 1 },
        ], {
            duration: 180,
            easing: 'ease-in-out',
            iterations: 1,
        });
        // Prevent any text from being selected within the dialog when clicking in
        // the backdrop area.
        e.preventDefault();
    }
    focus() {
        const titleContainer = this.shadowRoot.querySelector('.title-container');
        assert$1(titleContainer);
        titleContainer.focus();
    }
}
customElements.define(CrDialogElement.is, CrDialogElement);

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Queries |selector| on |root| and returns the first matching element. Throws
 * exception if there is no resulting element or if element is not of type
 * |type|.
 */
function strictQuery(selector, root, type) {
    const element = root.querySelector(selector);
    assert$1(element, 'Queried element is not defined.');
    assert$1(element instanceof type, 'Queried element is not an instance of type T.');
    return element;
}

function getTemplate$18() {
    return html `<!--_html_template_start_--><style include="cr-icons common cros-button-style">#paragraph1{margin-block-start:0px}cr-dialog::part(dialog){width:410px}</style>

<cr-dialog id="systemGeolocationDialog" show-on-attach>
  <div slot="title">
    $i18n{systemGeolocationDialogTitle}
  </div>
  <div slot="body" id="dialogBody">
    <p id="paragraph1">[[bodyTextParagraph1]]</p>
    <template is="dom-if" if="[[bodyTextParagraph2]]">
      <localized-link
          aria-describedby="paragraph1"
          localized-string="[[bodyTextParagraph2]]"
          link-url="$i18n{geolocationAccuracyLearnMoreUrl}">
      </localized-link>
    </template>
  </div>
  <div slot="button-container">
    <cr-button id="cancelButton"
        class="cancel-button"
        on-click="onCancelClicked_">
      [[cancelButtonText]]
    </cr-button>
    <cr-button id="confirmButton"
        class="action-button"
        on-click="onEnableClicked_">
      [[confirmButtonText]]
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview This dialog explains and asks users to enable system location
 * permission to allow precise timezone resolution.
 */
/**
 * Geolocation access levels for the ChromeOS system.
 * This must be kept in sync with `GeolocationAccessLevel` in
 * ash/constants/geolocation_access_level.h
 */
var GeolocationAccessLevel;
(function (GeolocationAccessLevel) {
    GeolocationAccessLevel[GeolocationAccessLevel["DISALLOWED"] = 0] = "DISALLOWED";
    GeolocationAccessLevel[GeolocationAccessLevel["ALLOWED"] = 1] = "ALLOWED";
    GeolocationAccessLevel[GeolocationAccessLevel["ONLY_ALLOWED_FOR_SYSTEM"] = 2] = "ONLY_ALLOWED_FOR_SYSTEM";
    GeolocationAccessLevel[GeolocationAccessLevel["MAX_VALUE"] = 2] = "MAX_VALUE";
})(GeolocationAccessLevel || (GeolocationAccessLevel = {}));
class GeolocationDialog extends PolymerElement {
    static get is() {
        return 'geolocation-dialog';
    }
    static get template() {
        return getTemplate$18();
    }
    static get properties() {
        return {
            bodyTextParagraph1: {
                type: String,
            },
            bodyTextParagraph2: {
                type: String,
            },
            cancelButtonText: {
                type: String,
            },
            confirmButtonText: {
                type: String,
            },
        };
    }
    /**
     * Callback on user accepting the geolocation dialog, with the intent to
     * enable geolocation for system services.
     * Closes the warning dialog and emits 'geolocation-enabled' event for direct
     * parent element to process.
     */
    onEnableClicked_() {
        this.dispatchEvent(new CustomEvent('geolocation-enabled', { bubbles: false }));
        logSystemLocationPermissionChange(GeolocationAccessLevel.ONLY_ALLOWED_FOR_SYSTEM);
        this.getDialog_().close();
    }
    // Closes the dialog.
    onCancelClicked_() {
        this.getDialog_().close();
    }
    getDialog_() {
        return strictQuery('#systemGeolocationDialog', this.shadowRoot, CrDialogElement);
    }
}
customElements.define(GeolocationDialog.is, GeolocationDialog);

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
/**

The `iron-location` element manages binding to and from the current URL.

iron-location is the first, and lowest level element in the Polymer team's
routing system. This is a beta release of iron-location as we continue work
on higher level elements, and as such iron-location may undergo breaking
changes.

#### Properties

When the URL is: `/search?query=583#details` iron-location's properties will be:

  - path: `'/search'`
  - query: `'query=583'`
  - hash: `'details'`

These bindings are bidirectional. Modifying them will in turn modify the URL.

iron-location is only active while it is attached to the document.

#### Links

While iron-location is active in the document it will intercept clicks on links
within your site, updating the URL pushing the updated URL out through the
databinding system. iron-location only intercepts clicks with the intent to
open in the same window, so middle mouse clicks and ctrl/cmd clicks work fine.

You can customize this behavior with the `urlSpaceRegex`.

#### Dwell Time

iron-location protects against accidental history spamming by only adding
entries to the user's history if the URL stays unchanged for `dwellTime`
milliseconds.

@demo demo/index.html

 */
Polymer({
  is: 'iron-location',

  properties: {
    /**
     * The pathname component of the URL.
     */
    path: {
      type: String,
      notify: true,
      value: function() {
        return window.decodeURIComponent(window.location.pathname);
      }
    },

    /**
     * The query string portion of the URL.
     */
    query: {
      type: String,
      notify: true,
      value: function() {
        return window.location.search.slice(1);
      }
    },

    /**
     * The hash component of the URL.
     */
    hash: {
      type: String,
      notify: true,
      value: function() {
        return window.decodeURIComponent(window.location.hash.slice(1));
      }
    },

    /**
     * If the user was on a URL for less than `dwellTime` milliseconds, it
     * won't be added to the browser's history, but instead will be replaced
     * by the next entry.
     *
     * This is to prevent large numbers of entries from clogging up the user's
     * browser history. Disable by setting to a negative number.
     */
    dwellTime: {type: Number, value: 2000},

    /**
     * A regexp that defines the set of URLs that should be considered part
     * of this web app.
     *
     * Clicking on a link that matches this regex won't result in a full page
     * navigation, but will instead just update the URL state in place.
     *
     * This regexp is given everything after the origin in an absolute
     * URL. So to match just URLs that start with /search/ do:
     *     url-space-regex="^/search/"
     *
     * @type {string|RegExp}
     */
    urlSpaceRegex: {type: String, value: ''},

    /**
     * A flag that specifies whether the spaces in query that would normally be
     * encoded as %20 should be encoded as +.
     *
     * Given an example text "hello world", it is encoded in query as
     * - "hello%20world" without the parameter
     * - "hello+world" with the parameter
     */
    encodeSpaceAsPlusInQuery: {type: Boolean, value: false},

    /**
     * urlSpaceRegex, but coerced into a regexp.
     *
     * @type {RegExp}
     */
    _urlSpaceRegExp: {computed: '_makeRegExp(urlSpaceRegex)'},

    _lastChangedAt: {type: Number},

    _initialized: {type: Boolean, value: false}
  },

  hostAttributes: {hidden: true},

  observers: ['_updateUrl(path, query, hash)'],

  created: function() {
    this.__location = window.location;
  },

  attached: function() {
    this.listen(window, 'hashchange', '_hashChanged');
    this.listen(window, 'location-changed', '_urlChanged');
    this.listen(window, 'popstate', '_urlChanged');
    this.listen(
        /** @type {!HTMLBodyElement} */ (document.body),
        'click',
        '_globalOnClick');
    // Give a 200ms grace period to make initial redirects without any
    // additions to the user's history.
    this._lastChangedAt = window.performance.now() - (this.dwellTime - 200);
    this._initialized = true;

    this._urlChanged();
  },

  detached: function() {
    this.unlisten(window, 'hashchange', '_hashChanged');
    this.unlisten(window, 'location-changed', '_urlChanged');
    this.unlisten(window, 'popstate', '_urlChanged');
    this.unlisten(
        /** @type {!HTMLBodyElement} */ (document.body),
        'click',
        '_globalOnClick');
    this._initialized = false;
  },

  _hashChanged: function() {
    this.hash = window.decodeURIComponent(this.__location.hash.substring(1));
  },

  _urlChanged: function() {
    // We want to extract all info out of the updated URL before we
    // try to write anything back into it.
    //
    // i.e. without _dontUpdateUrl we'd overwrite the new path with the old
    // one when we set this.hash. Likewise for query.
    this._dontUpdateUrl = true;
    this._hashChanged();
    this.path = window.decodeURIComponent(this.__location.pathname);
    this.query = this.__location.search.substring(1);
    this._dontUpdateUrl = false;
    this._updateUrl();
  },

  _getUrl: function() {
    var partiallyEncodedPath =
        window.encodeURI(this.path).replace(/\#/g, '%23').replace(/\?/g, '%3F');
    var partiallyEncodedQuery = '';
    if (this.query) {
      partiallyEncodedQuery = '?' + this.query.replace(/\#/g, '%23');
      if (this.encodeSpaceAsPlusInQuery) {
        partiallyEncodedQuery = partiallyEncodedQuery.replace(/\+/g, '%2B')
                                    .replace(/ /g, '+')
                                    .replace(/%20/g, '+');
      } else {
        // required for edge
        partiallyEncodedQuery =
            partiallyEncodedQuery.replace(/\+/g, '%2B').replace(/ /g, '%20');
      }
    }
    var partiallyEncodedHash = '';
    if (this.hash) {
      partiallyEncodedHash = '#' + window.encodeURI(this.hash);
    }
    return (
        partiallyEncodedPath + partiallyEncodedQuery + partiallyEncodedHash);
  },

  _updateUrl: function() {
    if (this._dontUpdateUrl || !this._initialized) {
      return;
    }

    if (this.path === window.decodeURIComponent(this.__location.pathname) &&
        this.query === this.__location.search.substring(1) &&
        this.hash ===
            window.decodeURIComponent(this.__location.hash.substring(1))) {
      // Nothing to do, the current URL is a representation of our properties.
      return;
    }

    var newUrl = this._getUrl();
    // Need to use a full URL in case the containing page has a base URI.
    var fullNewUrl =
        new URL(newUrl, this.__location.protocol + '//' + this.__location.host)
            .href;
    var now = window.performance.now();
    var shouldReplace = this._lastChangedAt + this.dwellTime > now;
    this._lastChangedAt = now;

    if (shouldReplace) {
      window.history.replaceState({}, '', fullNewUrl);
    } else {
      window.history.pushState({}, '', fullNewUrl);
    }

    this.fire('location-changed', {}, {node: window});
  },

  /**
   * A necessary evil so that links work as expected. Does its best to
   * bail out early if possible.
   *
   * @param {MouseEvent} event .
   */
  _globalOnClick: function(event) {
    // If another event handler has stopped this event then there's nothing
    // for us to do. This can happen e.g. when there are multiple
    // iron-location elements in a page.
    if (event.defaultPrevented) {
      return;
    }

    var href = this._getSameOriginLinkHref(event);

    if (!href) {
      return;
    }

    event.preventDefault();

    // If the navigation is to the current page we shouldn't add a history
    // entry or fire a change event.
    if (href === this.__location.href) {
      return;
    }

    window.history.pushState({}, '', href);
    this.fire('location-changed', {}, {node: window});
  },

  /**
   * Returns the absolute URL of the link (if any) that this click event
   * is clicking on, if we can and should override the resulting full
   * page navigation. Returns null otherwise.
   *
   * @param {MouseEvent} event .
   * @return {string?} .
   */
  _getSameOriginLinkHref: function(event) {
    // We only care about left-clicks.
    if (event.button !== 0) {
      return null;
    }

    // We don't want modified clicks, where the intent is to open the page
    // in a new tab.
    if (event.metaKey || event.ctrlKey) {
      return null;
    }

    var eventPath = dom(event).path;
    var anchor = null;

    for (var i = 0; i < eventPath.length; i++) {
      var element = eventPath[i];

      if (element.tagName === 'A' && element.href) {
        anchor = element;
        break;
      }
    }

    // If there's no link there's nothing to do.
    if (!anchor) {
      return null;
    }

    // Target blank is a new tab, don't intercept.
    if (anchor.target === '_blank') {
      return null;
    }

    // If the link is for an existing parent frame, don't intercept.
    if ((anchor.target === '_top' || anchor.target === '_parent') &&
        window.top !== window) {
      return null;
    }

    // If the link is a download, don't intercept.
    if (anchor.download) {
      return null;
    }

    var href = anchor.href;

    // It only makes sense for us to intercept same-origin navigations.
    // pushState/replaceState don't work with cross-origin links.
    var url;

    if (document.baseURI != null) {
      url = new URL(href, /** @type {string} */ (document.baseURI));
    } else {
      url = new URL(href);
    }

    var origin;

    // IE Polyfill
    if (this.__location.origin) {
      origin = this.__location.origin;
    } else {
      origin = this.__location.protocol + '//' + this.__location.host;
    }

    var urlOrigin;

    if (url.origin) {
      urlOrigin = url.origin;
    } else {
      // IE always adds port number on HTTP and HTTPS on <a>.host but not on
      // window.location.host
      var urlHost = url.host;
      var urlPort = url.port;
      var urlProtocol = url.protocol;
      var isExtraneousHTTPS = urlProtocol === 'https:' && urlPort === '443';
      var isExtraneousHTTP = urlProtocol === 'http:' && urlPort === '80';

      if (isExtraneousHTTPS || isExtraneousHTTP) {
        urlHost = url.hostname;
      }
      urlOrigin = urlProtocol + '//' + urlHost;
    }

    if (urlOrigin !== origin) {
      return null;
    }

    var normalizedHref = url.pathname + url.search + url.hash;

    // pathname should start with '/', but may not if `new URL` is not supported
    if (normalizedHref[0] !== '/') {
      normalizedHref = '/' + normalizedHref;
    }

    // If we've been configured not to handle this url... don't handle it!
    if (this._urlSpaceRegExp && !this._urlSpaceRegExp.test(normalizedHref)) {
      return null;
    }

    // Need to use a full URL in case the containing page has a base URI.
    var fullNormalizedHref = new URL(normalizedHref, this.__location.href).href;
    return fullNormalizedHref;
  },

  _makeRegExp: function(urlSpaceRegex) {
    return RegExp(urlSpaceRegex);
  }
});

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
/**
 * @demo demo/iron-query-params.html
 */
Polymer({
  is: 'iron-query-params',

  properties: {
    /**
     * @type{string|undefined}
     */
    paramsString: {
      type: String,
      notify: true,
      observer: 'paramsStringChanged',
    },

    /**
     * @type{Object|undefined}
     */
    paramsObject: {
      type: Object,
      notify: true,
    },

    _dontReact: {type: Boolean, value: false}
  },

  hostAttributes: {hidden: true},

  observers: ['paramsObjectChanged(paramsObject.*)'],

  paramsStringChanged: function() {
    this._dontReact = true;
    this.paramsObject = this._decodeParams(this.paramsString);
    this._dontReact = false;
  },

  paramsObjectChanged: function() {
    if (this._dontReact) {
      return;
    }
    this.paramsString = this._encodeParams(this.paramsObject)
                            .replace(/%3F/g, '?')
                            .replace(/%2F/g, '/')
                            .replace(/'/g, '%27');
  },

  _encodeParams: function(params) {
    var encodedParams = [];

    for (var key in params) {
      var value = params[key];

      if (value === '') {
        encodedParams.push(encodeURIComponent(key));

      } else if (value) {
        encodedParams.push(
            encodeURIComponent(key) + '=' +
            encodeURIComponent(value.toString()));
      }
    }
    return encodedParams.join('&');
  },

  _decodeParams: function(paramString) {
    var params = {};
    // Work around a bug in decodeURIComponent where + is not
    // converted to spaces:
    paramString = (paramString || '').replace(/\+/g, '%20');
    var paramList = paramString.split('&');
    for (var i = 0; i < paramList.length; i++) {
      var param = paramList[i].split('=');
      if (param[0]) {
        params[decodeURIComponent(param[0])] =
            decodeURIComponent(param[1] || '');
      }
    }
    return params;
  }
});

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

/**
 * @fileoverview Assertion support.
 */

/**
 * Note: This method is deprecated. Use the equvalent method in assert_ts.ts
 * instead.
 * Verify |condition| is truthy and return |condition| if so.
 * @template T
 * @param {T} condition A condition to check for truthiness.  Note that this
 *     may be used to test whether a value is defined or not, and we don't want
 *     to force a cast to Boolean.
 * @param {string=} opt_message A message to show on failure.
 * @return {T} A non-null |condition|.
 * @closurePrimitive {asserts.truthy}
 * @suppress {reportUnknownTypes} because T is not sufficiently constrained.
 */
function assert(condition, opt_message) {
  if (!condition) {
    let message = 'Assertion failed';
    if (opt_message) {
      message = message + ': ' + opt_message;
    }
    const error = new Error(message);
    const global = function() {
      const thisOrSelf = this || self;
      /** @type {boolean} */
      thisOrSelf.traceAssertionsForTesting;
      return thisOrSelf;
    }();
    if (global.traceAssertionsForTesting) {
      console.warn(error.stack);
    }
    throw error;
  }
  return condition;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Getters for all of the loadTimeData booleans used throughout
 * SeaPen.
 * Export them as functions so they reload the values when overridden in test.
 */
function isSeaPenEnabled() {
    return loadTimeData.getBoolean('isSeaPenEnabled');
}
function isSeaPenTextInputEnabled() {
    return loadTimeData.getBoolean('isSeaPenTextInputEnabled');
}
function isSeaPenUseExptTemplateEnabled() {
    return loadTimeData.getBoolean('isSeaPenUseExptTemplateEnabled');
}
function isVcResizeThumbnailEnabled() {
    return loadTimeData.getBoolean('isVcResizeThumbnailEnabled');
}
function isManagedSeaPenEnabled() {
    return loadTimeData.getBoolean('isManagedSeaPenEnabled');
}
function isManagedSeaPenFeedbackEnabled() {
    return loadTimeData.getBoolean('isManagedSeaPenFeedbackEnabled');
}

// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let transitionsEnabled = true;
function getTransitionEnabled() {
    return transitionsEnabled;
}
function setTransitionsEnabled(enabled) {
    transitionsEnabled = enabled;
}
/**
 * Wait a small amount before resolving with `value`. This can be used to
 * prevent awkward visual jank when entering a loading state so that the loading
 * state is always shown a minimum amount of time.
 */
async function withMinimumDelay(value) {
    if (transitionsEnabled) {
        return new Promise(resolve => window.setTimeout(() => resolve(value), 1000));
    }
    return value;
}
async function maybeDoPageTransition(func) {
    if (transitionsEnabled) {
        return document.startViewTransition(func).finished;
    }
    func();
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Getters for all of the loadTimeData booleans used throughout
 * personalization app.
 * @see //ash/webui/personalization_app/personalization_app_ui.cc
 * Export them as functions so they reload the values when overridden in test.
 */
function isGooglePhotosIntegrationEnabled() {
    return loadTimeData.getBoolean('isGooglePhotosIntegrationEnabled');
}
function isGooglePhotosSharedAlbumsEnabled() {
    return loadTimeData.getBoolean('isGooglePhotosSharedAlbumsEnabled');
}
function isAmbientModeAllowed() {
    return loadTimeData.getBoolean('isAmbientModeAllowed');
}
function isRgbKeyboardSupported() {
    return loadTimeData.getBoolean('isRgbKeyboardSupported');
}
function isMultiZoneRgbKeyboardSupported() {
    return loadTimeData.getInteger('keyboardBacklightZoneCount') > 1;
}
function isUserAvatarCustomizationSelectorsEnabled() {
    return loadTimeData.getBoolean('isUserAvatarCustomizationSelectorsEnabled');
}
function isTimeOfDayScreenSaverEnabled() {
    return loadTimeData.getBoolean('isTimeOfDayScreenSaverEnabled');
}
function isTimeOfDayWallpaperEnabled() {
    return loadTimeData.getBoolean('isTimeOfDayWallpaperEnabled');
}
function isCrosPrivacyHubLocationEnabled() {
    return loadTimeData.getBoolean('isCrosPrivacyHubLocationEnabled');
}

function getTemplate$17() {
    return html `<!--_html_template_start_--><style include="common">#container{display:flex;flex-flow:column nowrap;position:relative;width:100%}#breadcrumbArea{background-color:var(--cros-sys-app_base_shaded);display:grid;grid-template-areas:'. . breadcrumb . .';grid-template-columns:1fr 10px minmax(568px,920px) 10px 1fr;grid-template-rows:var(--personalization-app-breadcrumb-height);position:sticky;top:0;width:100%;z-index:3}personalization-breadcrumb{grid-area:breadcrumb}personalization-toast{bottom:16px;left:16px;max-width:380px;position:sticky}sea-pen-router{--sea-pen-router-min-height:var(--personalization-app-subpage-container-min-height)}wallpaper-fullscreen{bottom:0;height:100%;left:0;pointer-events:none;position:absolute;width:100%}sea-pen-router .wallpaperSelectedHidden{height:1px;left:-2px;overflow:hidden;position:fixed;top:-2px;width:1px}</style>
<div id="container">
  <!-- dwell-time is set to 200ms to populate history state more quickly while
       still respecting the grace period defined in iron-location.  -->
  <iron-location path="{{path_}}" query="{{query_}}" dwell-time="200">
  </iron-location>
  <iron-query-params params-object="{{queryParams_}}"
    params-string="{{query_}}">
  </iron-query-params>
  <template is="dom-if" if="[[shouldShowBreadcrumb_(path_)]]">
    <div id="breadcrumbArea">
      <personalization-breadcrumb path="[[path_]]"
          collection-id="[[queryParams_.id]]"
          google-photos-album-id="[[queryParams_.googlePhotosAlbumId]]"
          topic-source="[[queryParams_.topicSource]]"
          sea-pen-template-id="[[queryParams_.seaPenTemplateId]]">
      </personalization-breadcrumb>
    </div>
  </template>
  <template is="dom-if" if="[[shouldShowRootPage_(path_)]]">
    <personalization-main path="[[path_]]"></personalization-main>
  </template>
  <template is="dom-if" if="[[shouldShowAmbientSubpage_(path_)]]" restamp>
    <ambient-subpage path="[[path_]]" query-params="[[queryParams_]]">
    </ambient-subpage>
  </template>
  <template is="dom-if" if="[[shouldShowUserSubpage_(path_)]]" restamp>
    <user-subpage path="[[path_]]"></user-subpage>
  </template>
  <template is="dom-if" if="[[shouldShowWallpaperSubpage_(path_)]]" restamp>
    <wallpaper-subpage path="[[path_]]" query-params="[[queryParams_]]">
    </wallpaper-subpage>
  </template>
  <template is="dom-if" if="[[shouldShowSeaPen_(path_)]]" restamp>
    <sea-pen-router base-path="[[seaPenBasePath_]]" class="always-show-top">
      <wallpaper-selected id="wallpaperSelected" class$="[[getWallpaperSelectedClass_(path_)]]">
      </wallpaper-selected>
    </sea-pen-router>
  </template>
  <personalization-toast></personalization-toast>
  <wallpaper-fullscreen></wallpaper-fullscreen>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview contains all of the functions to interact with C++ side through
 * mojom calls. Handles setting |PersonalizationStore| state in response to
 * mojom data.
 */
/** Fetch wallpaper collections and save them to the store. */
async function fetchCollections(provider, store) {
    let { collections } = await provider.fetchCollections();
    if (!isNonEmptyArray(collections)) {
        console.warn('Failed to fetch wallpaper collections');
        collections = null;
    }
    store.dispatch(setCollectionsAction(collections));
}
/** Helper function to fetch and dispatch images for a single collection. */
async function fetchAndDispatchCollectionImages(provider, store, collection) {
    let { images } = await provider.fetchImagesForCollection(collection.id);
    if (!isNonEmptyArray(images)) {
        console.warn('Failed to fetch images for collection id', collection.id);
        images = null;
    }
    store.dispatch(setImagesForCollectionAction(collection.id, images));
}
/** Fetch all of the wallpaper collection images in parallel. */
async function fetchAllImagesForCollections(provider, store) {
    const collections = store.data.wallpaper.backdrop.collections;
    if (!Array.isArray(collections)) {
        console.warn('Cannot fetch data for collections when it is not initialized');
        return;
    }
    store.dispatch(beginLoadImagesForCollectionsAction(collections));
    await Promise.all(collections.map(collection => fetchAndDispatchCollectionImages(provider, store, collection)));
}
/**
 * Appends a suffix to request wallpaper images with the longest of width or
 * height being 512 pixels. This should ensure that the wallpaper image is
 * large enough to cover a grid item but not significantly more so.
 */
function appendMaxResolutionSuffix(value) {
    return { ...value, url: value.url + '=s512' };
}
/**
 * Fetches the list of Google Photos photos for the album associated with the
 * specified id and saves it to the store.
 */
async function fetchGooglePhotosAlbum(provider, store, albumId) {
    // Photos should only be fetched after determining whether access is allowed.
    const enabled = store.data.wallpaper.googlePhotos.enabled;
    assert$1(enabled !== undefined);
    store.dispatch(beginLoadGooglePhotosAlbumAction(albumId));
    // If access is *not* allowed, short-circuit the request.
    if (enabled !== GooglePhotosEnablementState.kEnabled) {
        store.dispatch(appendGooglePhotosPhotosAction(
        /*photos=*/ null, /*resumeToken=*/ null));
        return;
    }
    let photos = [];
    let resumeToken = store.data.wallpaper.googlePhotos.resumeTokens.photosByAlbumId[albumId] ||
        null;
    const { response } = await provider.fetchGooglePhotosPhotos(
    /*itemId=*/ null, albumId, resumeToken);
    if (Array.isArray(response.photos)) {
        photos.push(...response.photos);
        resumeToken = response.resumeToken || null;
    }
    else {
        console.warn('Failed to fetch Google Photos album');
        photos = null;
        // NOTE: `resumeToken` is intentionally *not* modified so that the request
        // which failed can be reattempted.
    }
    // Impose max resolution.
    if (photos !== null) {
        photos = photos.map(photo => ({ ...photo, url: appendMaxResolutionSuffix(photo.url) }));
    }
    store.dispatch(appendGooglePhotosAlbumAction(albumId, photos, resumeToken));
}
/** Fetches the list of Google Photos owned albums and saves it to the store. */
async function fetchGooglePhotosAlbums(provider, store) {
    // Albums should only be fetched after determining whether access is allowed.
    const enabled = store.data.wallpaper.googlePhotos.enabled;
    assert$1(enabled !== undefined, 'Google Photos albums not enabled.');
    store.dispatch(beginLoadGooglePhotosAlbumsAction());
    // If access is *not* allowed, short-circuit the request.
    if (enabled !== GooglePhotosEnablementState.kEnabled) {
        store.dispatch(appendGooglePhotosAlbumsAction(
        /*albums=*/ null, /*resumeToken=*/ null));
        return;
    }
    let albums = [];
    let resumeToken = store.data.wallpaper.googlePhotos.resumeTokens.albums;
    const { response } = await provider.fetchGooglePhotosAlbums(resumeToken);
    if (Array.isArray(response.albums)) {
        albums.push(...response.albums);
        resumeToken = response.resumeToken || null;
    }
    else {
        console.warn('Failed to fetch Google Photos owned albums');
        albums = null;
        // NOTE: `resumeToken` is intentionally *not* modified so that the request
        // which failed can be reattempted.
    }
    // Impose max resolution.
    if (albums !== null) {
        albums = albums.map(album => ({ ...album, preview: appendMaxResolutionSuffix(album.preview) }));
    }
    store.dispatch(appendGooglePhotosAlbumsAction(albums, resumeToken));
}
/**
 * Fetches the list of Google Photos shared albums and saves it to the store.
 */
async function fetchGooglePhotosSharedAlbums(provider, store) {
    // Albums should only be fetched after determining whether access is allowed.
    const enabled = store.data.wallpaper.googlePhotos.enabled;
    assert$1(enabled !== undefined, 'Google photos enablement state not initialized.');
    store.dispatch(beginLoadGooglePhotosSharedAlbumsAction());
    // If access is *not* allowed, short-circuit the request.
    if (enabled !== GooglePhotosEnablementState.kEnabled) {
        store.dispatch(appendGooglePhotosSharedAlbumsAction(
        /*albums=*/ null, /*resumeToken=*/ null));
        return;
    }
    let albums = [];
    let resumeToken = store.data.wallpaper.googlePhotos.resumeTokens.albumsShared;
    const { response } = await provider.fetchGooglePhotosSharedAlbums(resumeToken);
    if (Array.isArray(response.albums)) {
        albums.push(...response.albums);
        resumeToken = response.resumeToken || null;
    }
    else {
        console.warn('Failed to fetch Google Photos shared albums');
        albums = null;
        // NOTE: `resumeToken` is intentionally *not* modified so that the request
        // which failed can be reattempted.
    }
    // Impose max resolution.
    if (albums !== null) {
        albums = albums.map(album => ({ ...album, preview: appendMaxResolutionSuffix(album.preview) }));
    }
    store.dispatch(appendGooglePhotosSharedAlbumsAction(albums, resumeToken));
}
/** Fetches whether the user is allowed to access Google Photos. */
async function fetchGooglePhotosEnabled(provider, store) {
    // Whether access is allowed should only be fetched once.
    if (store.data.wallpaper.googlePhotos.enabled !== undefined) {
        return;
    }
    store.dispatch(beginLoadGooglePhotosEnabledAction());
    const { state } = await provider.fetchGooglePhotosEnabled();
    if (state === GooglePhotosEnablementState.kError) {
        console.warn('Failed to fetch Google Photos enabled');
    }
    store.dispatch(setGooglePhotosEnabledAction(state));
}
/** Fetches the list of Google Photos photos and saves it to the store. */
async function fetchGooglePhotosPhotos(provider, store) {
    // Photos should only be fetched after determining whether access is allowed.
    const enabled = store.data.wallpaper.googlePhotos.enabled;
    assert$1(enabled !== undefined);
    store.dispatch(beginLoadGooglePhotosPhotosAction());
    // If access is *not* allowed, short-circuit the request.
    if (enabled !== GooglePhotosEnablementState.kEnabled) {
        store.dispatch(appendGooglePhotosPhotosAction(
        /*photos=*/ null, /*resumeToken=*/ null));
        return;
    }
    let photos = [];
    let resumeToken = store.data.wallpaper.googlePhotos.resumeTokens.photos;
    const { response } = await provider.fetchGooglePhotosPhotos(
    /*itemId=*/ null, /*albumId=*/ null, resumeToken);
    if (Array.isArray(response.photos)) {
        photos.push(...response.photos);
        resumeToken = response.resumeToken || null;
    }
    else {
        console.warn('Failed to fetch Google Photos photos');
        photos = null;
        // NOTE: `resumeToken` is intentionally *not* modified so that the request
        // which failed can be reattempted.
    }
    // Impose max resolution.
    if (photos !== null) {
        photos = photos.map(photo => ({ ...photo, url: appendMaxResolutionSuffix(photo.url) }));
    }
    store.dispatch(appendGooglePhotosPhotosAction(photos, resumeToken));
}
async function getDefaultImageThumbnail(provider, store) {
    store.dispatch(beginLoadDefaultImageThubmnailAction());
    const { data } = await provider.getDefaultImageThumbnail();
    if (data.url.length === 0) {
        console.error('Failed to load default image thumbnail');
    }
    store.dispatch(setDefaultImageThumbnailAction(data));
}
/** Get list of local images from disk and save it to the store. */
async function getLocalImages(provider, store) {
    store.dispatch(beginLoadLocalImagesAction());
    const { images } = await provider.getLocalImages();
    if (images == null) {
        console.warn('Failed to fetch local images');
    }
    store.dispatch(setLocalImagesAction(images));
}
/**
 * Because thumbnail loading can happen asynchronously and is triggered
 * on page load and on window focus, multiple "threads" can be fetching
 * thumbnails simultaneously. Synchronize them with a task queue.
 */
const imageThumbnailsToFetch = new Set();
/**
 * Get an image thumbnail one at a time for every local image that does not have
 * a thumbnail yet.
 */
async function getMissingLocalImageThumbnails(provider, store) {
    if (!Array.isArray(store.data.wallpaper.local.images)) {
        console.warn('Cannot fetch thumbnails with invalid image list');
        return;
    }
    // Set correct loading state for each image thumbnail. Do in a batch update to
    // reduce number of times that polymer must re-render.
    store.beginBatchUpdate();
    for (const image of store.data.wallpaper.local.images) {
        if (isDefaultImage(image)) {
            continue;
        }
        if (store.data.wallpaper.local.data[image.path] ||
            store.data.wallpaper.loading.local.data[image.path] ||
            imageThumbnailsToFetch.has(image.path)) {
            // Do not re-load thumbnail if already present, or already loading.
            continue;
        }
        imageThumbnailsToFetch.add(image.path);
        store.dispatch(beginLoadLocalImageDataAction(image));
    }
    store.endBatchUpdate();
    // There may be multiple async tasks triggered that pull off this queue.
    while (imageThumbnailsToFetch.size) {
        await Promise.all(Array.from(imageThumbnailsToFetch).map(async (path) => {
            imageThumbnailsToFetch.delete(path);
            const { data } = await provider.getLocalImageThumbnail({ path });
            if (!data) {
                console.warn('Failed to fetch local image data', path);
            }
            store.dispatch(setLocalImageDataAction({ path }, data));
        }));
    }
}
async function selectWallpaper(image, provider, store, layout = WallpaperLayout.kCenterCropped) {
    const currentWallpaper = store.data.wallpaper.currentSelected;
    if (currentWallpaper && isImageEqualToSelected(image, currentWallpaper)) {
        return;
    }
    // Batch these changes together to reduce polymer churn as multiple state
    // fields change quickly.
    store.beginBatchUpdate();
    store.dispatch(beginSelectImageAction(image));
    store.dispatch(beginLoadSelectedImageAction());
    const { tabletMode } = await provider.isInTabletMode();
    const shouldPreview = tabletMode && !isDefaultImage(image);
    if (shouldPreview) {
        provider.makeTransparent();
        store.dispatch(setFullscreenStateAction(FullscreenPreviewState.LOADING));
    }
    store.endBatchUpdate();
    const { success } = await (() => {
        if (isWallpaperImage(image)) {
            return provider.selectWallpaper(image.unitId, /*preview_mode=*/ shouldPreview);
        }
        else if (isDefaultImage(image)) {
            return provider.selectDefaultImage();
        }
        else if (isNonEmptyFilePath(image)) {
            return provider.selectLocalImage(image, layout, /*preview_mode=*/ shouldPreview);
        }
        else if (isGooglePhotosPhoto(image)) {
            return provider.selectGooglePhotosPhoto(image.id, layout, /*preview_mode=*/ shouldPreview);
        }
        else {
            console.warn('Image must be a local image or a WallpaperImage');
            return { success: false };
        }
    })();
    store.beginBatchUpdate();
    store.dispatch(endSelectImageAction(image, success));
    if (!success) {
        console.warn('Error setting wallpaper');
        store.dispatch(setFullscreenStateAction(FullscreenPreviewState.OFF));
        store.dispatch(setAttributionAction(store.data.wallpaper.attribution));
        store.dispatch(setSelectedImageAction(store.data.wallpaper.currentSelected));
    }
    store.endBatchUpdate();
}
async function setCurrentWallpaperLayout(layout, provider, store) {
    const image = store.data.wallpaper.currentSelected;
    assert$1(image);
    assert$1(image.type === WallpaperType.kCustomized ||
        image.type === WallpaperType.kOnceGooglePhotos);
    assert$1(layout === WallpaperLayout.kCenter ||
        layout === WallpaperLayout.kCenterCropped);
    if (image.layout === layout) {
        return;
    }
    store.dispatch(beginLoadSelectedImageAction());
    await provider.setCurrentWallpaperLayout(layout);
}
// Do not trigger the loading UI if the currently selected wallpaper is a
// matching type for the incoming selection and if the currently selected
// wallpaper is in the chosen album.
function dailyRefreshShouldTriggerLoading(id, types, currentSelected, imagesById) {
    if (!id) {
        // No loading shown if clearing daily refresh state.
        return false;
    }
    if (!currentSelected) {
        return true;
    }
    if (types.has(currentSelected.type)) {
        return !imagesById[id]?.some(image => isImageAMatchForKey(image, currentSelected.key));
    }
    return true;
}
async function setDailyRefreshCollectionId(collectionId, provider, store) {
    if (dailyRefreshShouldTriggerLoading(collectionId, new Set([WallpaperType.kOnline, WallpaperType.kDaily]), store.data.wallpaper.currentSelected, store.data.wallpaper.backdrop.images)) {
        store.dispatch(beginUpdateDailyRefreshImageAction());
    }
    const { success } = await provider.setDailyRefreshCollectionId(collectionId);
    if (!success) {
        store.dispatch(setErrorAction({ message: loadTimeData.getString('setWallpaperError') }));
    }
    await getDailyRefreshState(provider, store);
}
async function selectGooglePhotosAlbum(albumId, provider, store) {
    if (dailyRefreshShouldTriggerLoading(albumId, new Set([
        WallpaperType.kOnceGooglePhotos,
        WallpaperType.kDailyGooglePhotos,
    ]), store.data.wallpaper.currentSelected, store.data.wallpaper.googlePhotos.photosByAlbumId)) {
        store.dispatch(beginUpdateDailyRefreshImageAction());
    }
    const { success } = await provider.selectGooglePhotosAlbum(albumId);
    if (!success) {
        store.dispatch(setErrorAction({ message: loadTimeData.getString('googlePhotosError') }));
    }
    await getDailyRefreshState(provider, store);
}
/**
 * Get the currently active daily refresh id for Backdrop and Google Photos.
 * One or both will be empty, depending on which, if either, is enabled.
 */
async function getDailyRefreshState(provider, store) {
    const [{ collectionId }, { albumId }] = await Promise.all([
        provider.getDailyRefreshCollectionId(),
        provider.getGooglePhotosDailyRefreshAlbumId(),
    ]);
    // Daily refresh should only be active for either Backdrop or Google Photos
    assert$1(!collectionId || !albumId);
    if (collectionId) {
        store.dispatch(setDailyRefreshCollectionIdAction(collectionId));
    }
    else if (albumId) {
        store.dispatch(setGooglePhotosDailyRefreshAlbumIdAction(albumId));
    }
    else {
        store.dispatch(clearDailyRefreshAction());
    }
}
/** Refresh the wallpaper. Noop if daily refresh is not enabled. */
async function updateDailyRefreshWallpaper(provider, store) {
    store.dispatch(beginUpdateDailyRefreshImageAction());
    store.dispatch(beginLoadSelectedImageAction());
    const { success } = await provider.updateDailyRefreshWallpaper();
    if (success) {
        store.dispatch(setUpdatedDailyRefreshImageAction());
    }
    else {
        const currentAttribution = store.data.wallpaper.attribution;
        const currentWallpaper = store.data.wallpaper.currentSelected;
        const dailyRefresh = store.data.wallpaper.dailyRefresh;
        // Displays error if daily refresh is activated for Google Photos album
        // and refresh failed to fetch a new Google Photo wallpaper.
        // Also dispatches setUpdatedDailyRefreshImageAction() and
        // setSelectedImageAction() to avoid pending UI.
        // TODO (b/266257678): displays error message when daily refresh fails for
        // online wallpaper collections.
        if (!!dailyRefresh && dailyRefresh.type == DailyRefreshType.GOOGLE_PHOTOS) {
            store.dispatch(setUpdatedDailyRefreshImageAction());
            store.dispatch(setAttributionAction(currentAttribution));
            store.dispatch(setSelectedImageAction(currentWallpaper));
            store.dispatch(setErrorAction({ message: loadTimeData.getString('googlePhotosError') }));
        }
    }
}
/** Confirm and set preview wallpaper as actual wallpaper. */
function confirmPreviewWallpaper(provider) {
    provider.makeOpaque();
    provider.confirmPreviewWallpaper();
}
/** Cancel preview wallpaper and show the previous wallpaper. */
function cancelPreviewWallpaper(provider) {
    provider.makeOpaque();
    provider.cancelPreviewWallpaper();
}
async function getShouldShowTimeOfDayWallpaperDialog(provider, store) {
    const { shouldShowDialog } = await provider.shouldShowTimeOfDayWallpaperDialog();
    // Dispatch action to set the should show dialog boolean.
    store.dispatch(setShouldShowTimeOfDayWallpaperDialog(shouldShowDialog));
}
/**
 * Fetches list of collections, then fetches list of images for each
 * collection.
 */
async function initializeBackdropData(provider, store) {
    await fetchCollections(provider, store);
    await fetchAllImagesForCollections(provider, store);
}
/**
 * Gets list of local images, then fetches image thumbnails for each local
 * image.
 */
async function fetchLocalData(provider, store) {
    // Do not restart loading local image list if a load is already in progress.
    if (!store.data.wallpaper.loading.local.images) {
        await getLocalImages(provider, store);
    }
    await getMissingLocalImageThumbnails(provider, store);
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview a singleton getter for the wallpaper mojom interface used in
 * the Personalization SWA. Also contains utility function for mocking out the
 * implementation for testing.
 */
let wallpaperProvider = null;
function setWallpaperProviderForTesting(testProvider) {
    wallpaperProvider = testProvider;
}
/** Returns a singleton for the WallpaperProvider mojom interface. */
function getWallpaperProvider() {
    if (!wallpaperProvider) {
        wallpaperProvider = WallpaperProvider.getRemote();
    }
    return wallpaperProvider;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
let instance$9 = null;
let initialLoadTimeout = null;
const setTimeout$1 = window.setTimeout;
const clearTimeout$1 = window.clearTimeout;
/**
 * Set up the observer to listen for wallpaper changes.
 */
function initWallpaperObserver(wallpaperProvider, target) {
    const receiver = new WallpaperObserverReceiver(target);
    wallpaperProvider.setWallpaperObserver(receiver.$.bindNewPipeAndPassRemote());
    return receiver;
}
/**
 * @classdesc Implements interface |WallpaperObserver| generated from
 * |personalization_app.mojom|. See comments there for method descriptions.
 */
class WallpaperObserver {
    constructor() {
        this.receiver_ = initWallpaperObserver(getWallpaperProvider(), this);
    }
    /**
     * Create a new wallpaper observer instance if no instance currently running.
     */
    static initWallpaperObserverIfNeeded() {
        if (!instance$9) {
            instance$9 = new WallpaperObserver();
            initialLoadTimeout = setTimeout$1(() => {
                const store = PersonalizationStore.getInstance();
                // If still loading the initial currently selected wallpaper image after
                // 120 seconds, consider this an error and update the store.
                store.dispatch(setSelectedImageAction(null));
                initialLoadTimeout = null;
            }, 120 * 1000);
        }
    }
    onWallpaperPreviewEnded() {
        const store = PersonalizationStore.getInstance();
        store.dispatch(setFullscreenStateAction(FullscreenPreviewState.OFF));
    }
    onAttributionChanged(attribution) {
        const store = PersonalizationStore.getInstance();
        store.dispatch(setAttributionAction(attribution));
    }
    onWallpaperChanged(currentWallpaper) {
        const store = PersonalizationStore.getInstance();
        if (store.data.wallpaper.fullscreen === FullscreenPreviewState.LOADING) {
            // Ignore current wallpaper updates while in fullscreen preview mode. The
            // attribution information is for the old (non-preview) wallpaper. This is
            // because setting an image in preview mode updates the image but not the
            // stored WallpaperInfo. The wallpaper app should treat the duration of
            // preview mode as loading. Another onWallpaperChanged will fire when
            // preview mode is canceled or confirmed.
            store.dispatch(setFullscreenStateAction(FullscreenPreviewState.VISIBLE));
            return;
        }
        if (initialLoadTimeout) {
            clearTimeout$1(initialLoadTimeout);
            initialLoadTimeout = null;
        }
        store.dispatch(setSelectedImageAction(currentWallpaper));
        if (currentWallpaper &&
            (currentWallpaper.type == WallpaperType.kDailyGooglePhotos ||
                currentWallpaper.type == WallpaperType.kDaily ||
                currentWallpaper.type == WallpaperType.kDefault)) {
            store.dispatch(setUpdatedDailyRefreshImageAction());
        }
        // Daily Refresh state should also get updated when wallpaper changes.
        getDailyRefreshState(getWallpaperProvider(), store);
    }
    static shutdown() {
        if (instance$9) {
            instance$9.receiver_.$.close();
            instance$9 = null;
        }
    }
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview This router component hooks into the current url path and query
 * parameters to display sections of the personalization SWA.
 */
var Paths;
(function (Paths) {
    Paths["AMBIENT"] = "/ambient";
    Paths["AMBIENT_ALBUMS"] = "/ambient/albums";
    Paths["COLLECTION_IMAGES"] = "/wallpaper/collection";
    Paths["COLLECTIONS"] = "/wallpaper";
    Paths["GOOGLE_PHOTOS_COLLECTION"] = "/wallpaper/google-photos";
    Paths["LOCAL_COLLECTION"] = "/wallpaper/local";
    Paths["ROOT"] = "/";
    Paths["SEA_PEN_COLLECTION"] = "/wallpaper/sea-pen";
    Paths["SEA_PEN_RESULTS"] = "/wallpaper/sea-pen/results";
    Paths["SEA_PEN_FREEFORM"] = "/wallpaper/sea-pen/freeform";
    Paths["USER"] = "/user";
})(Paths || (Paths = {}));
var ScrollableTarget;
(function (ScrollableTarget) {
    ScrollableTarget["TOPIC_SOURCE_LIST"] = "topic-source-list";
})(ScrollableTarget || (ScrollableTarget = {}));
function isPathValid(path) {
    return !!path && Object.values(Paths).includes(path);
}
function isAmbientPath(path) {
    return !!path && path.startsWith(Paths.AMBIENT);
}
function isAmbientPathAllowed(path) {
    return isAmbientPath(path) && isAmbientModeAllowed();
}
function isAmbientPathNotAllowed(path) {
    return isAmbientPath(path) && !isAmbientModeAllowed();
}
function isSeaPenPath(path) {
    return !!path && path.startsWith(Paths.SEA_PEN_COLLECTION);
}
function isSeaPenAllowed() {
    return isSeaPenEnabled() && isManagedSeaPenEnabled();
}
function isSeaPenPathNotAllowed(path) {
    return isSeaPenPath(path) && !isSeaPenAllowed();
}
class PersonalizationRouterElement extends PolymerElement {
    static get is() {
        return 'personalization-router';
    }
    static get template() {
        return getTemplate$17();
    }
    static get properties() {
        return {
            path_: {
                type: String,
                observer: 'onPathChanged_',
            },
            query_: {
                type: String,
            },
            queryParams_: {
                type: Object,
            },
            seaPenBasePath_: {
                type: String,
                value() {
                    return Paths.SEA_PEN_COLLECTION;
                },
            },
        };
    }
    static instance() {
        return document.querySelector(PersonalizationRouterElement.is);
    }
    static reloadAtRoot() {
        window.location.replace(Paths.ROOT);
    }
    /**
     * Reload the application at the collections page.
     */
    static reloadAtWallpaper() {
        window.location.replace(Paths.COLLECTIONS);
    }
    /**
     * Reload the application at the ambient subpage.
     */
    static reloadAtAmbient() {
        window.location.replace(Paths.AMBIENT);
    }
    connectedCallback() {
        super.connectedCallback();
        WallpaperObserver.initWallpaperObserverIfNeeded();
    }
    get collectionId() {
        if (this.path_ !== Paths.COLLECTION_IMAGES) {
            return null;
        }
        return this.queryParams_.id;
    }
    /**
     * Navigate to the selected collection id. Assumes validation of the
     * collection has already happened.
     */
    selectCollection(collection) {
        document.title = collection.name;
        this.goToRoute(Paths.COLLECTION_IMAGES, { id: collection.id });
    }
    /** Navigate to a specific album in the Google Photos collection page. */
    selectGooglePhotosAlbum(album) {
        this.goToRoute(Paths.GOOGLE_PHOTOS_COLLECTION, {
            googlePhotosAlbumId: album.id,
            // Only include key if album is shared.
            ...(album.isShared ? { googlePhotosAlbumIsShared: 'true' } : false),
        });
    }
    /** Navigate to albums subpage of specific topic source. */
    selectAmbientAlbums(topicSource) {
        this.goToRoute(Paths.AMBIENT_ALBUMS, { topicSource: topicSource.toString() });
    }
    async goToRoute(path, queryParams = {}) {
        return maybeDoPageTransition(() => this.setProperties({ path_: path, queryParams_: queryParams }));
    }
    shouldShowRootPage_(path) {
        // If the ambient mode is not allowed, will not show Ambient/AmbientAlbums
        // subpages.
        return (path === Paths.ROOT) || (isAmbientPathNotAllowed(path));
    }
    shouldShowAmbientSubpage_(path) {
        return isAmbientPathAllowed(path);
    }
    shouldShowUserSubpage_(path) {
        return path === Paths.USER;
    }
    shouldShowWallpaperSubpage_(path) {
        return !!path && path.startsWith(Paths.COLLECTIONS) &&
            !path.startsWith(Paths.SEA_PEN_COLLECTION);
    }
    shouldShowSeaPen_(path) {
        return isSeaPenAllowed() && isSeaPenPath(path);
    }
    getWallpaperSelectedClass_(path) {
        return path !== Paths.SEA_PEN_COLLECTION ? 'wallpaperSelectedHidden' : '';
    }
    shouldShowBreadcrumb_(path) {
        return path !== Paths.ROOT;
    }
    /**
     * When entering a wrong path or navigating to Ambient/AmbientAlbums
     * subpages, but the ambient mode is not allowed, reset path to root.
     */
    onPathChanged_(path) {
        // Navigates to the top of the subpage.
        window.scrollTo(0, 0);
        if (!isPathValid(path) || isAmbientPathNotAllowed(path) ||
            isSeaPenPathNotAllowed(path)) {
            // Reset the path to root.
            this.setProperties({ path_: Paths.ROOT, queryParams_: {} });
        }
        if (isPathValid(path)) {
            logPersonalizationPathUMA(path);
        }
        // Update the page title when the path changes.
        // TODO(b/228967523): Wallpaper related pages have been handled in their
        // specific Polymer elements so they are skipped here. See if we can move
        // them here.
        switch (path) {
            case Paths.ROOT:
                document.title = loadTimeData.getString('personalizationTitle');
                break;
            case Paths.AMBIENT:
                document.title = loadTimeData.getString('screensaverLabel');
                break;
            case Paths.AMBIENT_ALBUMS: {
                assert(!!this.queryParams_.topicSource);
                const topicSource = parseInt(this.queryParams_.topicSource, 10);
                if (!isNaN(topicSource) && topicSource in TopicSource) {
                    logAmbientAlbumsPathUMA(topicSource);
                }
                if (this.queryParams_.topicSource ===
                    TopicSource.kGooglePhotos.toString()) {
                    document.title =
                        loadTimeData.getString('ambientModeTopicSourceGooglePhotos');
                }
                else {
                    document.title =
                        loadTimeData.getString('ambientModeTopicSourceArtGallery');
                }
                break;
            }
            case Paths.GOOGLE_PHOTOS_COLLECTION: {
                document.title = loadTimeData.getString('googlePhotosLabel');
                break;
            }
            case Paths.LOCAL_COLLECTION: {
                document.title = loadTimeData.getString('myImagesLabel');
                break;
            }
            case Paths.USER:
                document.title = loadTimeData.getString('avatarLabel');
                break;
        }
    }
}
customElements.define(PersonalizationRouterElement.is, PersonalizationRouterElement);

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
function toMetricsEnum(path) {
    switch (path) {
        case Paths.AMBIENT:
            return 0 /* MetricsPath.AMBIENT */;
        case Paths.AMBIENT_ALBUMS:
            return 1 /* MetricsPath.AMBIENT_ALBUMS */;
        case Paths.COLLECTION_IMAGES:
            return 2 /* MetricsPath.WALLPAPER_COLLECTION_IMAGES */;
        case Paths.COLLECTIONS:
            return 3 /* MetricsPath.WALLPAPER */;
        case Paths.GOOGLE_PHOTOS_COLLECTION:
            return 4 /* MetricsPath.WALLPAPER_GOOGLE_PHOTO_COLLECTION */;
        case Paths.LOCAL_COLLECTION:
            return 5 /* MetricsPath.WALLPAPER_LOCAL_COLLECTION */;
        case Paths.ROOT:
            return 6 /* MetricsPath.ROOT */;
        case Paths.USER:
            return 7 /* MetricsPath.USER */;
        case Paths.SEA_PEN_COLLECTION:
            return 8 /* MetricsPath.WALLPAPER_SEA_PEN_COLLECTION */;
        case Paths.SEA_PEN_RESULTS:
            return 9 /* MetricsPath.WALLPAPER_SEA_PEN_RESULTS */;
        case Paths.SEA_PEN_FREEFORM:
            return 10 /* MetricsPath.WALLPAPER_SEA_PEN_FREEFORM */;
    }
}
function logPersonalizationPathUMA(path) {
    const metricsPath = toMetricsEnum(path);
    assert$1(metricsPath <= 10 /* MetricsPath.MAX_VALUE */);
    chrome.metricsPrivate.recordEnumerationValue("Ash.Personalization.Path" /* HistogramName.PATH */, metricsPath, 10 /* MetricsPath.MAX_VALUE */ + 1);
}
function logAmbientAlbumsPathUMA(topicSource) {
    chrome.metricsPrivate.recordEnumerationValue("Ash.Personalization.AmbientMode.AlbumsPath" /* HistogramName.AMBIENT_ALBUMS_PATH */, topicSource, TopicSource.MAX_VALUE + 1);
}
function logAmbientModeOptInUMA() {
    chrome.metricsPrivate.recordBoolean("Ash.Personalization.AmbientMode.OptIn" /* HistogramName.AMBIENT_OPTIN */, true);
}
function logGooglePhotosPreviewsLoadTime() {
    // Get elapsed time in ms since the page initialized.
    const timeMs = Math.round(performance.now());
    console.debug("Ash.Personalization.Ambient.GooglePhotosPreviewsLoadTime" /* HistogramName.AMBIENT_PERFORMANCE_GOOGLE_PHOTOS_PREVIEWS */, timeMs);
    chrome.metricsPrivate.recordTime("Ash.Personalization.Ambient.GooglePhotosPreviewsLoadTime" /* HistogramName.AMBIENT_PERFORMANCE_GOOGLE_PHOTOS_PREVIEWS */, timeMs);
}
function logKeyboardBacklightOpenZoneCustomizationUMA() {
    chrome.metricsPrivate.recordBoolean("Ash.Personalization.KeyboardBacklight.OpenZoneCustomization" /* HistogramName.KEYBOARD_BACKLIGHT_OPEN_ZONE_CUSTOMIZATION */, true);
}
function logDynamicColorToggleButtonClick(enabled) {
    chrome.metricsPrivate.recordBoolean("Ash.Personalization.DynamicColor.ToggleButton" /* HistogramName.DYNAMIC_COLOR_TOGGLE_BUTTON */, enabled);
}
function logDynamicColorStaticColorButtonClick(color) {
    chrome.metricsPrivate.recordEnumerationValue("Ash.Personalization.DynamicColor.StaticColorButton" /* HistogramName.DYNAMIC_COLOR_STATIC_COLOR_BUTTON */, color, StaticColor.MAX_VALUE);
}
function logDynamicColorColorSchemeButtonClick(color) {
    chrome.metricsPrivate.recordEnumerationValue("Ash.Personalization.DynamicColor.ColorSchemeButton" /* HistogramName.DYNAMIC_COLOR_COLOR_SCHEME_BUTTON */, color, ColorScheme.MAX_VALUE);
}
function logAmbientModeLinkToGooglePhotosClick() {
    chrome.metricsPrivate.recordBoolean("Ash.Personalization.Ambient.LinkToGooglePhotosClicked" /* HistogramName.AMBIENT_LINK_TO_GOOGLE_PHOTOS_CLICKED */, true);
}
function logSystemLocationPermissionChange(accessLevel) {
    chrome.metricsPrivate.recordEnumerationValue("ChromeOS.PrivacyHub.Geolocation.AccessLevelChanged.GeolocationDialog" /* HistogramName.LOCATION_PERMISSION_CHANGE_FROM_DIALOG */, accessLevel, GeolocationAccessLevel.MAX_VALUE + 1);
}

function getTemplate$16() {
    return html `<!--_html_template_start_--><style include="cr-shared-style common">:host{height:auto}#pageDescription,#descPlaceholderContainer{margin-inline-start:10px;min-height:32px}#noAlbumText{display:inline}#descriptionPlaceholder{height:20px;width:50%}#albumsPlaceholderContainer{display:grid;gap:calc(var(--personalization-app-grid-item-spacing)) calc(var(--personalization-app-grid-item-spacing) / 2);grid-template-columns:repeat(3,1fr 0.34px);grid-template-rows:repeat(auto-fit,calc(var(--personalization-app-grid-item-height)));height:100%;overflow:hidden;padding:calc(var(--personalization-app-grid-item-spacing) / 2)}@media (min-width:720px){#albumsPlaceholderContainer{grid-template-columns:repeat(4,1fr 0.25px)}}#albumItemPlaceholder{height:100%;position:relative;width:100%}</style>
<template is="dom-if" if="[[shouldShowContent_(ambientModeEnabled_)]]">
  <template is="dom-if" if="[[loadingAlbums_(albums, topicSource)]]">
    <div id="descPlaceholderContainer">
      <div id="descriptionPlaceholder" class="placeholder"></div>
    </div>
    <div id="albumsPlaceholderContainer">
      <template is="dom-repeat" items="[[getLoadingTiles_()]]">
        <div id="albumItemPlaceholder" class="placeholder"></div>
        <div class="filler"></div>
      </template>
    </div>
  </template>

  <template is="dom-if" if="[[!loadingAlbums_(albums, topicSource)]]">
    <localized-link id="pageDescription"
        on-link-clicked="onGooglePhotosLinkClicked_"
        localized-string="[[getTitleInnerHtml_(topicSource)]]">
    </localized-link>

    <!-- Only Google Photos may not have albums -->
    <template is="dom-if" if="[[showNoGoogleAlbums_(topicSource, albums)]]">
      <localized-link id="noAlbumText" class="cr-row first"
          on-link-clicked="onGooglePhotosLinkClicked_"
          localized-string=
              "[[i18nAdvanced('ambientModeAlbumsSubpageGooglePhotosNoAlbum')]]">
      </localized-link>
    </template>

    <template is="dom-if" if="[[showArtAlbumDialog_]]" restamp>
      <art-album-dialog on-close="onArtAlbumDialogClose_"></art-album-dialog>
    </template>

    <album-list albums="[[albums]]" topic-source="[[topicSource]]"></album-list>
  </template>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview a singleton getter for the ambient mojom interface used in
 * the Personalization SWA. Also contains utility functions around fetching
 * mojom data and mocking out the implementation for testing.
 */
let ambientProvider = null;
function setAmbientProviderForTesting(testProvider) {
    ambientProvider = testProvider;
}
/** Returns a singleton for the AmbientProvider mojom interface. */
function getAmbientProvider() {
    if (!ambientProvider) {
        ambientProvider = AmbientProvider.getRemote();
    }
    return ambientProvider;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Utility functions to be used for ambient mode.
 */
/**
 * Returns photo count string.
 */
function getPhotoCount(photoCount) {
    if (photoCount <= 1) {
        return loadTimeData.getStringF('ambientModeAlbumsSubpagePhotosNumSingularDesc', photoCount);
    }
    return loadTimeData.getStringF('ambientModeAlbumsSubpagePhotosNumPluralDesc', photoCount);
}
/**
 * Returns the topic source name.
 */
function getTopicSourceName(topicSource) {
    switch (topicSource) {
        case TopicSource.kGooglePhotos:
            return loadTimeData.getString('ambientModeTopicSourceGooglePhotos');
        case TopicSource.kArtGallery:
            return loadTimeData.getString('ambientModeTopicSourceArtGallery');
        case TopicSource.kVideo:
            return loadTimeData.getString('ambientModeTopicSourceVideo');
        default:
            console.warn('Invalid TopicSource value.');
            return '';
    }
}
/**
 * Returns whether the params represent a valid ambient state.
 *
 * Note: TopicSource.kVideo is exclusively paired with AmbientTheme.kVideo
 */
function isValidTopicSourceAndTheme(topicSource, ambientTheme) {
    return (ambientTheme === AmbientTheme.kVideo &&
        topicSource === TopicSource.kVideo) ||
        (ambientTheme !== AmbientTheme.kVideo &&
            topicSource !== TopicSource.kVideo);
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview contains all of the functions to interact with ambient mode
 * related C++ side through mojom calls. Handles setting |PersonalizationStore|
 * state in response to mojom data.
 */
async function initializeData$1(provider, store) {
    const [{ geolocationEnabled }, { geolocationIsUserModifiable }] = await Promise.all([
        provider.isGeolocationEnabledForSystemServices(),
        provider.isGeolocationUserModifiable(),
    ]);
    store.beginBatchUpdate();
    store.dispatch(setGeolocationPermissionEnabledAction$1(geolocationEnabled));
    store.dispatch(setGeolocationIsUserModifiableAction$1(geolocationIsUserModifiable));
    store.endBatchUpdate();
}
// Enable or disable ambient mode.
function setAmbientModeEnabled(ambientModeEnabled, provider, store) {
    provider.setAmbientModeEnabled(ambientModeEnabled);
    // Dispatch action to toggle the button to indicate if the ambient mode is
    // enabled.
    store.dispatch(setAmbientModeEnabledAction(ambientModeEnabled));
}
// Set the ambient theme.
function setAmbientTheme(ambientTheme, provider, store) {
    provider.setAmbientTheme(ambientTheme);
    store.dispatch(setAmbientThemeAction(ambientTheme));
}
// Set ambient mode screen saver running duration in minutes.
function setScreenSaverDuration(minutes, provider, store) {
    provider.setScreenSaverDuration(minutes);
    store.dispatch(setScreenSaverDurationAction(minutes));
}
// Set ambient mode topic source.
function setTopicSource(topicSource, provider, store) {
    assert$1(isValidTopicSourceAndTheme(topicSource, store.data.ambient.ambientTheme), 'invalid topic source and ambient theme combination');
    provider.setTopicSource(topicSource);
    // Dispatch action to select topic source.
    store.dispatch(setTopicSourceAction(topicSource));
}
// Set ambient mode temperature unit.
function setTemperatureUnit(temperatureUnit, provider, store) {
    // Dispatch action to select temperature unit.
    store.dispatch(setTemperatureUnitAction(temperatureUnit));
    provider.setTemperatureUnit(temperatureUnit);
}
// Set one album as selected or not.
function setAlbumSelected(album, provider, store) {
    // Dispatch action to update albums info with the changed album.
    store.dispatch(setAlbumSelectedAction());
    provider.setAlbumSelected(album.id, album.topicSource, album.checked);
}
// Start screen saver preview.
function startScreenSaverPreview(provider) {
    provider.startScreenSaverPreview();
}
async function getShouldShowTimeOfDayBanner(store) {
    const { shouldShowBanner } = await getAmbientProvider().shouldShowTimeOfDayBanner();
    // Dispatch action to set the should show banner boolean.
    store.dispatch(setShouldShowTimeOfDayBannerAction(shouldShowBanner));
}
// Sets shouldShowTimeOfDayBanner to false.
function dismissTimeOfDayBanner(store) {
    if (!store.data.ambient.shouldShowTimeOfDayBanner) {
        // Do nothing if the banner is already dismissed;
        return;
    }
    getAmbientProvider().handleTimeOfDayBannerDismissed();
    store.dispatch(setShouldShowTimeOfDayBannerAction(false));
}
function enableGeolocationForSystemServices$1(store) {
    getAmbientProvider().enableGeolocationForSystemServices();
    store.dispatch(setGeolocationPermissionEnabledAction$1(true));
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/** @fileoverview listens for updates on ambient mode changes. */
let instance$8 = null;
/**
 * Observes ambient mode changes and saves updates to PersonalizationStore.
 */
class AmbientObserver {
    // Allow logging first load performance if the user began on a page where
    // preview images are loaded immediately.
    static { this.shouldLogPreviewsLoadPerformance = window.location.pathname === Paths.ROOT ||
        window.location.pathname === Paths.AMBIENT; }
    static initAmbientObserverIfNeeded() {
        if (isAmbientModeAllowed() && !instance$8) {
            instance$8 = new AmbientObserver();
        }
    }
    static shutdown() {
        if (instance$8) {
            instance$8.receiver_.$.close();
            instance$8 = null;
        }
    }
    constructor() {
        const provider = getAmbientProvider();
        this.receiver_ = this.initReceiver_(provider);
        provider.fetchSettingsAndAlbums();
    }
    initReceiver_(ambientProvider) {
        const receiver = new AmbientObserverReceiver(this);
        ambientProvider.setAmbientObserver(receiver.$.bindNewPipeAndPassRemote());
        return receiver;
    }
    onAmbientModeEnabledChanged(ambientModeEnabled) {
        // Only record google photos previews load performance if ambient mode
        // starts enabled.
        AmbientObserver.shouldLogPreviewsLoadPerformance =
            AmbientObserver.shouldLogPreviewsLoadPerformance && ambientModeEnabled;
        const store = PersonalizationStore.getInstance();
        store.dispatch(setAmbientModeEnabledAction(ambientModeEnabled));
    }
    onAmbientThemePreviewImagesChanged(previews) {
        const store = PersonalizationStore.getInstance();
        store.dispatch(setAmbientThemePreviewsAction(previews));
    }
    onAmbientThemeChanged(ambientTheme) {
        const store = PersonalizationStore.getInstance();
        store.dispatch(setAmbientThemeAction(ambientTheme));
    }
    onScreenSaverDurationChanged(minutes) {
        const store = PersonalizationStore.getInstance();
        store.dispatch(setScreenSaverDurationAction(minutes));
    }
    onTopicSourceChanged(topicSource) {
        const store = PersonalizationStore.getInstance();
        // If the first time receiving `topicSource`, allow logging load
        // performance.
        AmbientObserver.shouldLogPreviewsLoadPerformance =
            AmbientObserver.shouldLogPreviewsLoadPerformance &&
                store.data.ambient.topicSource === null;
        store.dispatch(setTopicSourceAction(topicSource));
    }
    onTemperatureUnitChanged(temperatureUnit) {
        const store = PersonalizationStore.getInstance();
        store.dispatch(setTemperatureUnitAction(temperatureUnit));
    }
    onAlbumsChanged(albums) {
        const store = PersonalizationStore.getInstance();
        // Prevent recent highlights album from constantly changing preview image
        // when albums are refreshed during a single session.
        const oldRecentHighlightsAlbum = (store.data.ambient.albums ||
            []).find(album => isRecentHighlightsAlbum(album));
        if (oldRecentHighlightsAlbum) {
            const newRecentHighlightsAlbum = albums.find(album => isRecentHighlightsAlbum(album));
            if (newRecentHighlightsAlbum) {
                // Edit by reference.
                newRecentHighlightsAlbum.url = oldRecentHighlightsAlbum.url;
            }
        }
        store.dispatch(setAlbumsAction(albums));
    }
    onPreviewsFetched(previews) {
        const store = PersonalizationStore.getInstance();
        // Only log performance metrics if this is the first time receiving
        // thumbnails.
        AmbientObserver.shouldLogPreviewsLoadPerformance =
            AmbientObserver.shouldLogPreviewsLoadPerformance &&
                (!store.data.ambient.previews ||
                    store.data.ambient.previews.length === 0);
        store.dispatch(setPreviewsAction(previews));
        if (AmbientObserver.shouldLogPreviewsLoadPerformance &&
            isNonEmptyArray(previews)) {
            logGooglePhotosPreviewsLoadTime();
            AmbientObserver.shouldLogPreviewsLoadPerformance = false;
        }
    }
    onAmbientUiVisibilityChanged(ambientUiVisibility) {
        const store = PersonalizationStore.getInstance();
        store.dispatch(setAmbientUiVisibilityAction(ambientUiVisibility));
    }
    onGeolocationPermissionForSystemServicesChanged(enabled, isUserModifiable) {
        const store = PersonalizationStore.getInstance();
        store.beginBatchUpdate();
        store.dispatch(setGeolocationPermissionEnabledAction$1(enabled));
        store.dispatch(setGeolocationIsUserModifiableAction$1(isUserModifiable));
        store.endBatchUpdate();
    }
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview The ambient albums subpage is to select personal albums in
 * Google Photos or categories in Art gallery.
 */
/** Height in pixels of a tile. */
const kTileHeightPx = 136;
class AlbumsSubpageElement extends WithPersonalizationStore {
    constructor() {
        super(...arguments);
        this.albums = null;
    }
    static get is() {
        return 'albums-subpage';
    }
    static get template() {
        return getTemplate$16();
    }
    static get properties() {
        return {
            topicSource: TopicSource,
            albums: {
                type: Array,
                // Set to null to differentiate from an empty album.
                value: null,
            },
            ambientModeEnabled_: {
                type: Boolean,
                observer: 'onAmbientModeEnabledChanged_',
            },
            showArtAlbumDialog_: {
                type: Boolean,
                value: false,
            },
        };
    }
    ready() {
        super.ready();
        this.addEventListener('album_selected_changed', this.onAlbumSelectedChanged_.bind(this));
    }
    connectedCallback() {
        super.connectedCallback();
        AmbientObserver.initAmbientObserverIfNeeded();
        this.watch('ambientModeEnabled_', state => state.ambient.ambientModeEnabled);
        this.updateFromStore();
        getAmbientProvider().fetchSettingsAndAlbums();
    }
    shouldShowContent_() {
        return this.ambientModeEnabled_ !== null && this.ambientModeEnabled_;
    }
    getTitleInnerHtml_() {
        switch (this.topicSource) {
            case TopicSource.kGooglePhotos:
                return this.i18nAdvanced('ambientModeAlbumsSubpageGooglePhotosTitle');
            case TopicSource.kArtGallery:
                return this.i18n('ambientModeTopicSourceArtGalleryDescription');
            case TopicSource.kVideo:
                return this.i18n('ambientModeTopicSourceVideoDescription');
        }
    }
    /**
     * List of loading tiles to be displayed to the user when albums are loading.
     */
    getLoadingTiles_() {
        const x = getNumberOfGridItemsPerRow();
        const y = Math.floor(this.offsetHeight / kTileHeightPx);
        return new Array(x * y).fill(0);
    }
    loadingAlbums_() {
        return this.albums === null || this.topicSource === null;
    }
    showNoGoogleAlbums_() {
        if (this.topicSource !== TopicSource.kGooglePhotos) {
            return false;
        }
        return !isNonEmptyArray(this.albums);
    }
    onAlbumSelectedChanged_(event) {
        const albumChanged = event.detail.album;
        if (this.topicSource === TopicSource.kArtGallery) {
            const anySelected = this.albums.some(album => album.checked);
            // For art gallery, cannot deselect all the albums. Show a dialog to users
            // and select the album automatically.
            if (!anySelected) {
                this.showArtAlbumDialog_ = true;
                const albumIndex = this.albums.findIndex(album => album.id === albumChanged.id);
                assert$1(albumIndex >= 0);
                this.set(`albums.${albumIndex}.checked`, true);
                return;
            }
        }
        setAlbumSelected(albumChanged, getAmbientProvider(), this.getStore());
    }
    onArtAlbumDialogClose_() {
        this.showArtAlbumDialog_ = false;
    }
    onAmbientModeEnabledChanged_(ambientModeEnabled) {
        if (ambientModeEnabled !== null && !ambientModeEnabled) {
            PersonalizationRouterElement.reloadAtAmbient();
        }
    }
    onGooglePhotosLinkClicked_(event) {
        event.stopPropagation();
        logAmbientModeLinkToGooglePhotosClick();
    }
}
customElements.define(AlbumsSubpageElement.is, AlbumsSubpageElement);

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview <cr-auto-img> is a specialized <img> that facilitates embedding
 * images into WebUIs via its auto-src attribute. <cr-auto-img> automatically
 * determines if the image is local (e.g. data: or chrome://) or external (e.g.
 * https://), and embeds the image directly or via the chrome://image data
 * source accordingly. Usage:
 *
 *   1. In C++ register |SanitizedImageSource| for your WebUI.
 *
 *   2. In HTML instantiate
 *
 *      <img is="cr-auto-img" auto-src="https://foo.com/bar.png">
 *
 *      If your image URL points to Google Photos storage, meaning it needs an
 *      auth token, you can use the is-google-photos attribute as follows:
 *
 *      <img is="cr-auto-img" auto-src="https://foo.com/bar.png"
 *          is-google-photos>
 *
 *      If you want the image to reset to an empty state when auto-src changes
 *      and the new image is still loading, set the clear-src attribute:
 *
 *      <img is="cr-auto-img" auto-src="[[calculateSrc()]]" clear-src>
 *
 *      If you want your image to be always encoded as a static image (even if
 *      the source image is animated), set the static-encode attribute:
 *
 *      <img is="cr-auto-img" auto-src="https://foo.com/bar.png"
 *          static-encode>
 *
 *      Static images are encoded as PNG by default. If you want your image to
 *      be encoded as a Webp image, set the encode-type attribute to "webp".
 *
 *      <img is="cr-auto-img" auto-src="https://foo.com/bar.png"
 *          static-encode encode-type="webp">
 *
 * NOTE: Since <cr-auto-img> may use the chrome://image data source some images
 * may be transcoded to PNG.
 *
 * Forked from ui/webui/resources/cr_elements/cr_auto_img/cr_auto_img.ts
 */
const AUTO_SRC = 'auto-src';
const CLEAR_SRC = 'clear-src';
const IS_GOOGLE_PHOTOS = 'is-google-photos';
const STATIC_ENCODE = 'static-encode';
const ENCODE_TYPE = 'encode-type';
class CrAutoImgElement extends HTMLImageElement {
    static get observedAttributes() {
        return [AUTO_SRC, IS_GOOGLE_PHOTOS, STATIC_ENCODE, ENCODE_TYPE];
    }
    attributeChangedCallback(name, oldValue, newValue) {
        if (name !== AUTO_SRC && name !== IS_GOOGLE_PHOTOS &&
            name !== STATIC_ENCODE && name !== ENCODE_TYPE) {
            return;
        }
        // Changes to |IS_GOOGLE_PHOTOS| are only interesting when the attribute is
        // being added or removed.
        if (name === IS_GOOGLE_PHOTOS &&
            ((oldValue === null) === (newValue === null))) {
            return;
        }
        if (this.hasAttribute(CLEAR_SRC)) {
            // Remove the src attribute so that the old image is not shown while the
            // new one is loading.
            this.removeAttribute('src');
        }
        let url = null;
        try {
            url = new URL(this.getAttribute(AUTO_SRC) || '');
        }
        catch (_) {
        }
        if (!url || url.protocol === 'chrome-untrusted:') {
            // Loading chrome-untrusted:// directly kills the renderer process.
            // Loading chrome-untrusted:// via the chrome://image data source
            // results in a broken image.
            this.removeAttribute('src');
            return;
        }
        if (url.protocol === 'data:' || url.protocol === 'chrome:') {
            this.src = url.href;
            return;
        }
        if (!this.hasAttribute(IS_GOOGLE_PHOTOS) &&
            !this.hasAttribute(STATIC_ENCODE) && !this.hasAttribute(ENCODE_TYPE)) {
            this.src = 'chrome://image?' + url.href;
            return;
        }
        this.src = `chrome://image?url=${encodeURIComponent(url.href)}`;
        if (this.hasAttribute(IS_GOOGLE_PHOTOS)) {
            this.src += `&isGooglePhotos=true`;
        }
        if (this.hasAttribute(STATIC_ENCODE)) {
            this.src += `&staticEncode=true`;
        }
        if (this.hasAttribute(ENCODE_TYPE)) {
            this.src += `&encodeType=${this.getAttribute(ENCODE_TYPE)}`;
        }
    }
    set autoSrc(src) {
        this.setAttribute(AUTO_SRC, src);
    }
    get autoSrc() {
        return this.getAttribute(AUTO_SRC) || '';
    }
    set clearSrc(_) {
        this.setAttribute(CLEAR_SRC, '');
    }
    get clearSrc() {
        return this.getAttribute(CLEAR_SRC) || '';
    }
    set isGooglePhotos(enabled) {
        if (enabled) {
            this.setAttribute(IS_GOOGLE_PHOTOS, '');
        }
        else {
            this.removeAttribute(IS_GOOGLE_PHOTOS);
        }
    }
    get isGooglePhotos() {
        return this.hasAttribute(IS_GOOGLE_PHOTOS);
    }
    set staticEncode(enabled) {
        if (enabled) {
            this.setAttribute(STATIC_ENCODE, '');
        }
        else {
            this.removeAttribute(STATIC_ENCODE);
        }
    }
    get staticEncode() {
        return this.hasAttribute(STATIC_ENCODE);
    }
    set encodeType(type) {
        if (type) {
            this.setAttribute(ENCODE_TYPE, type);
        }
        else {
            this.removeAttribute(ENCODE_TYPE);
        }
    }
    get encodeType() {
        return this.getAttribute(ENCODE_TYPE) || '';
    }
}
customElements.define('cr-auto-img', CrAutoImgElement, { extends: 'img' });

function getTemplate$15() {
    return html `<!--_html_template_start_--><style include="common">:host{-webkit-tap-highlight-color:transparent;box-sizing:border-box;cursor:pointer;overflow:hidden;padding:calc(var(--personalization-app-grid-item-spacing) / 2);width:calc(100% / 3 - 0.34px)}@media (min-width:720px){:host{width:calc(100% / 4 - 0.25px)}}:host(:focus-visible){outline:none}.item{align-items:center;background-color:rgba(0,0,0,0.12);border-radius:var(--personalization-app-grid-item-border-radius);box-sizing:border-box;display:flex;flex-direction:column;height:120px;justify-content:center;overflow:hidden;position:relative;width:100%}:host(:focus-visible) .item{outline:2px solid var(--cros-focus-ring-color)}:host([aria-checked='true']) .item{background-color:var(--cros-sys-highlight_shape,rgba(var(--cros-color-prominent-rgb),var(--personalization-app-second-tone-opacity)));border-radius:calc(var(--personalization-app-grid-item-border-radius) + 4px)}img{border-radius:var(--personalization-app-grid-item-border-radius);height:100%;object-fit:cover;width:100%}:host([aria-checked='true']) .item img{animation-duration:200ms;animation-fill-mode:forwards;animation-name:img-resize;animation-timing-function:cubic-bezier(0.4,0,0.2,1.0)}@keyframes img-resize{100%{height:calc(100% - 8px);width:calc(100% - 8px)}}.text{color:var(--cros-text-color-secondary);display:flex;flex-direction:column;font:var(--cros-body-2-font);margin:8px 0 0 0}iron-icon{--iron-icon-height:20px;--iron-icon-width:20px;animation-duration:200ms;animation-name:iron-icon-scale;animation-timing-function:cubic-bezier(0.4,0,0.2,1.0);left:8px;position:absolute;top:8px}:host(:not([aria-checked='true'])) .item iron-icon{display:none}@keyframes iron-icon-scale{from{transform:scale(0)}to{transform:scale(1)}}</style>
<div class="item">
  <img is="cr-auto-img" auto-src="[[imgSrc_]]"></img>
  <iron-icon icon="personalization-shared:circle-checkmark"></iron-icon>
</div>
<p class="text" title$="[[itemDescription_]]">[[itemDescription_]]</p>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview The element for displaying an ambient theme.
 */
class AmbientThemeItemElement extends WithPersonalizationStore {
    static get is() {
        return 'ambient-theme-item';
    }
    static get template() {
        return getTemplate$15();
    }
    static get properties() {
        return {
            ambientTheme: AmbientTheme,
            itemDescription_: {
                type: String,
                computed: 'computeItemDescription_(ambientTheme)',
            },
            imgSrc_: {
                type: String,
                computed: 'computeImgSrc_(ambientTheme)',
            },
        };
    }
    ready() {
        super.ready();
        this.addEventListener('click', this.onItemSelected_.bind(this));
        this.addEventListener('keydown', this.onItemSelected_.bind(this));
    }
    connectedCallback() {
        super.connectedCallback();
        this.watch('ambientThemePreviews_', state => state.ambient.ambientThemePreviews);
        this.updateFromStore();
    }
    /** Compute the ambient theme description. */
    computeItemDescription_() {
        switch (this.ambientTheme) {
            case AmbientTheme.kSlideshow:
                return this.i18n('ambientModeAnimationSlideshowLabel');
            case AmbientTheme.kFeelTheBreeze:
                return this.i18n('ambientModeAnimationFeelTheBreezeLabel');
            case AmbientTheme.kFloatOnBy:
                return this.i18n('ambientModeAnimationFloatOnByLabel');
            case AmbientTheme.kVideo:
                return this.i18n('ambientModeAnimationVideoLabel');
            default:
                assertNotReached('Invalid AmbientTheme value: ${this.ambientTheme}');
        }
    }
    /** Return the display image for ambient theme option. */
    computeImgSrc_(ambientTheme) {
        if (this.ambientThemePreviews_ === null) {
            return '';
        }
        return this.ambientThemePreviews_[ambientTheme]?.url || '';
    }
    /** Invoked when item is selected. */
    onItemSelected_(event) {
        if (!isSelectionEvent$1(event)) {
            return;
        }
        event.preventDefault();
        event.stopPropagation();
        setAmbientTheme(this.ambientTheme, getAmbientProvider(), this.getStore());
    }
}
customElements.define(AmbientThemeItemElement.is, AmbientThemeItemElement);

function getTemplate$14() {
    return html `<!--_html_template_start_--><style include="common">:host{--theme-item-padding:24px;--theme-item-width:156px}iron-list{width:calc(var(--theme-item-width)*3 + var(--theme-item-padding)*2)}@media (min-width:720px){iron-list{width:calc(var(--theme-item-width)*4 + var(--theme-item-padding)*3)}}</style>

<h3 id="ambientThemeDescription" class="ambient-subpage-element-title">
  $i18n{ambientModeAnimationTitle}
</h3>
<iron-list items="[[ambientThemes]]" as="theme" grid id="grid"
    role="radiogroup" aria-describedby="ambientThemeDescription">
  <template>
    <ambient-theme-item tabindex$="[[tabIndex]]"
        role="radio"
        ambient-theme="[[theme]]"
        aria-checked$="[[getAriaChecked_(theme, selectedAmbientTheme)]]">
      </ambient-theme-item>
  </template>
</iron-list>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview The element for displaying a list of ambient themes.
 */
class AmbientThemeListElement extends WithPersonalizationStore {
    static get is() {
        return 'ambient-theme-list';
    }
    static get template() {
        return getTemplate$14();
    }
    static get properties() {
        return {
            ambientThemes: {
                type: Array,
                value() {
                    const themes = [
                        AmbientTheme.kSlideshow,
                        AmbientTheme.kFeelTheBreeze,
                        AmbientTheme.kFloatOnBy,
                    ];
                    if (isTimeOfDayScreenSaverEnabled()) {
                        themes.push(AmbientTheme.kVideo);
                    }
                    return themes;
                },
            },
            selectedAmbientTheme: AmbientTheme,
        };
    }
    getAriaChecked_(ambientTheme, selectedAmbientTheme) {
        return (ambientTheme === selectedAmbientTheme).toString();
    }
}
customElements.define(AmbientThemeListElement.is, AmbientThemeListElement);

const styleMod$4 = document.createElement('dom-module');
styleMod$4.appendChild(html `
  <template>
    <style>
:host{--cr-radio-button-checked-color:var(--google-blue-600);--cr-radio-button-checked-ripple-color:rgba(var(--google-blue-600-rgb),.2);--cr-radio-button-ink-size:40px;--cr-radio-button-size:16px;--cr-radio-button-unchecked-color:var(--google-grey-700);--cr-radio-button-unchecked-ripple-color:rgba(var(--google-grey-600-rgb),.15);--ink-to-circle:calc((var(--cr-radio-button-ink-size) - var(--cr-radio-button-size)) / 2);align-items:center;display:flex;flex-shrink:0;gap:var(--cr-radio-button-label-spacing,20px);outline:none}@media (prefers-color-scheme:dark){:host{--cr-radio-button-checked-color:var(--google-blue-300);--cr-radio-button-checked-ripple-color:rgba(var(--google-blue-300-rgb),.4);--cr-radio-button-unchecked-color:var(--google-grey-500);--cr-radio-button-unchecked-ripple-color:rgba(var(--google-grey-300-rgb),.4)}}:host-context([chrome-refresh-2023]):host{--cr-radio-button-ink-size:32px;--cr-radio-button-checked-color:var(--color-radio-button-foreground-checked,var(--cr-fallback-color-primary));--cr-radio-button-checked-ripple-color:var(--cr-active-background-color);--cr-radio-button-unchecked-color:var(--color-radio-button-foreground-unchecked,var(--cr-fallback-color-outline));--cr-radio-button-unchecked-ripple-color:var(--cr-active-background-color)}@media (forced-colors:active){:host{--cr-radio-button-checked-color:SelectedItem}}:host([disabled]){opacity:var(--cr-disabled-opacity);pointer-events:none}:host-context([chrome-refresh-2023]):host([disabled]){opacity:1;--cr-radio-button-checked-color:var(--color-radio-foreground-disabled,var(--cr-fallback-color-disabled-background));--cr-radio-button-unchecked-color:var(--color-radio-foreground-disabled,var(--cr-fallback-color-disabled-background))}:host(:not([disabled])){cursor:pointer}:host(.label-first){flex-direction:row-reverse}#labelWrapper{flex:1}:host-context([chrome-refresh-2023]):host([disabled]) #labelWrapper{opacity:var(--cr-disabled-opacity)}#label{color:inherit}:host([hide-label-text]) #label{clip:rect(0,0,0,0);display:block;position:fixed}.disc-border,.disc,.disc-wrapper,paper-ripple{border-radius:50%}.disc-wrapper{height:var(--cr-radio-button-size);margin-block-start:var(--cr-radio-button-disc-margin-block-start,0);position:relative;width:var(--cr-radio-button-size)}.disc-border,.disc{box-sizing:border-box;height:var(--cr-radio-button-size);width:var(--cr-radio-button-size)}.disc-border{border:2px solid var(--cr-radio-button-unchecked-color)}:host([checked]) .disc-border{border-color:var(--cr-radio-button-checked-color)}#button:focus{outline:none}.disc{background-color:transparent;position:absolute;top:0;transform:scale(0);transition:border-color 200ms,transform 200ms}:host([checked]) .disc{background-color:var(--cr-radio-button-checked-color);transform:scale(0.5)}:host-context([chrome-refresh-2023]) #overlay{border-radius:50%;box-sizing:border-box;display:none;height:var(--cr-radio-button-ink-size);left:50%;pointer-events:none;position:absolute;top:50%;transform:translate(-50%,-50%);width:var(--cr-radio-button-ink-size)}:host-context([chrome-refresh-2023]) #button:hover #overlay{background-color:var(--cr-hover-background-color);display:block}:host-context([chrome-refresh-2023]) #button:focus-visible #overlay{border:2px solid var(--cr-focus-outline-color);display:block}paper-ripple{--paper-ripple-opacity:1;color:var(--cr-radio-button-unchecked-ripple-color);height:var(--cr-radio-button-ink-size);left:calc(-1 * var(--ink-to-circle));pointer-events:none;position:absolute;top:calc(-1 * var(--ink-to-circle));transition:color linear 80ms;width:var(--cr-radio-button-ink-size)}:host-context([dir=rtl]) paper-ripple{left:auto;right:calc(-1 * var(--ink-to-circle))}:host([checked]) paper-ripple{color:var(--cr-radio-button-checked-ripple-color)}
    </style>
  </template>
`.content);
styleMod$4.register('cr-radio-button-style');

function getTemplate$13() {
    return html `<!--_html_template_start_--><style include="cr-radio-button-style cr-hidden-style"></style>

<div aria-checked$="[[getAriaChecked_(checked)]]"
    aria-describedby="slotted-content"
    aria-disabled$="[[getAriaDisabled_(disabled)]]"
    aria-labelledby="label"
    class="disc-wrapper"
    id="button"
    role="radio"
    tabindex$="[[buttonTabIndex_]]"
    on-keydown="onInputKeydown_">
  <div class="disc-border"></div>
  <div class="disc"></div>
  <div id="overlay"></div>
</div>

<div id="labelWrapper">
  <span id="label" hidden$="[[!label]]" aria-hidden="true">[[label]]</span>
  <span id="slotted-content">
    <slot></slot>
  </span>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
const CrRadioButtonMixin = dedupingMixin((superClass) => {
    class CrRadioButtonMixin extends superClass {
        static get properties() {
            return {
                checked: {
                    type: Boolean,
                    value: false,
                    reflectToAttribute: true,
                },
                disabled: {
                    type: Boolean,
                    value: false,
                    reflectToAttribute: true,
                    notify: true,
                },
                /**
                 * Whether the radio button should be focusable or not. Toggling
                 * this property sets the corresponding tabindex of the button
                 * itself as well as any links in the button description.
                 */
                focusable: {
                    type: Boolean,
                    value: false,
                    observer: 'onFocusableChanged_',
                },
                hideLabelText: {
                    type: Boolean,
                    value: false,
                    reflectToAttribute: true,
                },
                label: {
                    type: String,
                    value: '', // Allows hidden$= binding to run without being set.
                },
                name: {
                    type: String,
                    notify: true,
                    reflectToAttribute: true,
                },
                /**
                 * Holds the tabIndex for the radio button.
                 */
                buttonTabIndex_: {
                    type: Number,
                    computed: 'getTabIndex_(focusable)',
                },
            };
        }
        connectedCallback() {
            super.connectedCallback();
            this.addEventListener('blur', this.hideRipple_.bind(this));
            if (!document.documentElement.hasAttribute('chrome-refresh-2023')) {
                this.addEventListener('focus', this.onFocus_.bind(this));
            }
            this.addEventListener('up', this.hideRipple_.bind(this));
        }
        focus() {
            const button = this.shadowRoot.querySelector('#button');
            assert$1(button);
            button.focus();
        }
        getPaperRipple() {
            assertNotReached();
        }
        onFocus_() {
            this.getPaperRipple().showAndHoldDown();
        }
        hideRipple_() {
            this.getPaperRipple().clear();
        }
        onFocusableChanged_() {
            const links = this.querySelectorAll('a');
            links.forEach((link) => {
                // Remove the tab stop on any links when the row is unchecked.
                // Since the row is not tabbable, any links within the row
                // should not be either.
                link.tabIndex = this.checked ? 0 : -1;
            });
        }
        getAriaChecked_() {
            return this.checked ? 'true' : 'false';
        }
        getAriaDisabled_() {
            return this.disabled ? 'true' : 'false';
        }
        getTabIndex_() {
            return this.focusable ? 0 : -1;
        }
        /**
         * When shift-tab is pressed, first bring the focus to the host
         * element. This accomplishes 2 things:
         * 1) Host doesn't get focused when the browser moves the focus
         *    backward.
         * 2) focus now escaped the shadow-dom of this element, so that
         *    it'll correctly obey non-zero tabindex ordering of the
         *    containing document.
         */
        onInputKeydown_(e) {
            if (e.shiftKey && e.key === 'Tab') {
                this.focus();
            }
        }
    }
    return CrRadioButtonMixin;
});

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Forked from
// ui/webui/resources/cr_elements/cr_radio_button/cr_radio_button.ts
const CrRadioButtonElementBase = PaperRippleMixin(CrRadioButtonMixin(PolymerElement));
class CrRadioButtonElement extends CrRadioButtonElementBase {
    static get is() {
        return 'cr-radio-button';
    }
    static get template() {
        return getTemplate$13();
    }
    // Overridden from CrRadioButtonMixin
    getPaperRipple() {
        return this.getRipple();
    }
    // Overridden from PaperRippleMixin
    /* eslint-disable-next-line @typescript-eslint/naming-convention */
    _createRipple() {
        this._rippleContainer = this.shadowRoot.querySelector('.disc-wrapper');
        const ripple = super._createRipple();
        ripple.id = 'ink';
        ripple.setAttribute('recenters', '');
        ripple.classList.add('circle');
        return ripple;
    }
}
customElements.define(CrRadioButtonElement.is, CrRadioButtonElement);

// Copyright 2011 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview EventTracker is a simple class that manages the addition and
 * removal of DOM event listeners. In particular, it keeps track of all
 * listeners that have been added and makes it easy to remove some or all of
 * them without requiring all the information again. This is particularly handy
 * when the listener is a generated function such as a lambda or the result of
 * calling Function.bind.
 */
class EventTracker {
    listeners_ = [];
    /**
     * Add an event listener - replacement for EventTarget.addEventListener.
     * @param target The DOM target to add a listener to.
     * @param eventType The type of event to subscribe to.
     * @param listener The listener to add.
     * @param capture Whether to invoke during the capture phase. Defaults to
     *     false.
     */
    add(target, eventType, listener, capture = false) {
        const h = {
            target: target,
            eventType: eventType,
            listener: listener,
            capture: capture,
        };
        this.listeners_.push(h);
        target.addEventListener(eventType, listener, capture);
    }
    /**
     * Remove any specified event listeners added with this EventTracker.
     * @param target The DOM target to remove a listener from.
     * @param eventType The type of event to remove.
     */
    remove(target, eventType) {
        this.listeners_ = this.listeners_.filter(listener => {
            if (listener.target === target &&
                (!eventType || (listener.eventType === eventType))) {
                EventTracker.removeEventListener(listener);
                return false;
            }
            return true;
        });
    }
    /** Remove all event listeners added with this EventTracker. */
    removeAll() {
        this.listeners_.forEach(listener => EventTracker.removeEventListener(listener));
        this.listeners_ = [];
    }
    /**
     * Remove a single event listener given it's tracking entry. It's up to the
     * caller to ensure the entry is removed from listeners_.
     * @param entry The entry describing the listener to
     * remove.
     */
    static removeEventListener(entry) {
        entry.target.removeEventListener(entry.eventType, entry.listener, entry.capture);
    }
}

function getTemplate$12() {
    return html `<!--_html_template_start_--><style>:host{display:inline-block}:host ::slotted(*){padding:var(--cr-radio-group-item-padding,12px)}:host([disabled]){cursor:initial;pointer-events:none;user-select:none}:host([disabled]) ::slotted(*){opacity:var(--cr-disabled-opacity)}</style>
<slot></slot>
<!--_html_template_end_-->`;
}

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Forked from
// ui/webui/resources/cr_elements/cr_radio_group/cr_radio_group.ts
function isEnabled(radio) {
    return radio.matches(':not([disabled]):not([hidden])') &&
        radio.style.display !== 'none' && radio.style.visibility !== 'hidden';
}
class CrRadioGroupElement extends PolymerElement {
    constructor() {
        super(...arguments);
        this.buttons_ = null;
        this.buttonEventTracker_ = new EventTracker();
        this.deltaKeyMap_ = null;
        this.isRtl_ = false;
        this.populateBound_ = null;
    }
    static get is() {
        return 'cr-radio-group';
    }
    static get template() {
        return getTemplate$12();
    }
    static get properties() {
        return {
            disabled: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
                observer: 'update_',
            },
            selected: {
                type: String,
                notify: true,
                observer: 'update_',
            },
            selectableElements: {
                type: String,
                value: 'cr-radio-button, cr-card-radio-button, controlled-radio-button',
            },
            nestedSelectable: {
                type: Boolean,
                value: false,
                observer: 'populate_',
            },
            selectableRegExp_: {
                value: Object,
                computed: 'computeSelectableRegExp_(selectableElements)',
            },
        };
    }
    ready() {
        super.ready();
        this.addEventListener('keydown', e => this.onKeyDown_(/** @type {!KeyboardEvent} */ (e)));
        this.addEventListener('click', this.onClick_.bind(this));
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'radiogroup');
        }
        this.setAttribute('aria-disabled', 'false');
    }
    connectedCallback() {
        super.connectedCallback();
        this.isRtl_ = this.matches(':host-context([dir=rtl]) cr-radio-group');
        this.deltaKeyMap_ = new Map([
            ['ArrowDown', 1],
            ['ArrowLeft', this.isRtl_ ? 1 : -1],
            ['ArrowRight', this.isRtl_ ? -1 : 1],
            ['ArrowUp', -1],
            ['PageDown', 1],
            ['PageUp', -1],
        ]);
        this.populateBound_ = () => this.populate_();
        assert$1(this.populateBound_);
        this.shadowRoot.querySelector('slot').addEventListener('slotchange', this.populateBound_);
        this.populate_();
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        assert$1(this.populateBound_);
        this.shadowRoot.querySelector('slot').removeEventListener('slotchange', this.populateBound_);
        this.buttonEventTracker_.removeAll();
    }
    focus() {
        if (this.disabled || !this.buttons_) {
            return;
        }
        const radio = this.buttons_.find(radio => this.isButtonEnabledAndSelected_(radio));
        if (radio) {
            radio.focus();
        }
    }
    onKeyDown_(event) {
        if (this.disabled) {
            return;
        }
        if (event.ctrlKey || event.shiftKey || event.metaKey || event.altKey) {
            return;
        }
        const targetElement = event.target;
        if (!this.buttons_ || !this.buttons_.includes(targetElement)) {
            return;
        }
        if (event.key === ' ' || event.key === 'Enter') {
            event.preventDefault();
            this.select_(targetElement);
            return;
        }
        const enabledRadios = this.buttons_.filter(isEnabled);
        if (enabledRadios.length === 0) {
            return;
        }
        assert$1(this.deltaKeyMap_);
        let selectedIndex;
        const max = enabledRadios.length - 1;
        if (event.key === 'Home') {
            selectedIndex = 0;
        }
        else if (event.key === 'End') {
            selectedIndex = max;
        }
        else if (this.deltaKeyMap_.has(event.key)) {
            const delta = this.deltaKeyMap_.get(event.key);
            // If nothing selected, start from the first radio then add |delta|.
            const lastSelection = enabledRadios.findIndex(radio => radio.checked);
            selectedIndex = Math.max(0, lastSelection) + delta;
            // Wrap the selection, if needed.
            if (selectedIndex > max) {
                selectedIndex = 0;
            }
            else if (selectedIndex < 0) {
                selectedIndex = max;
            }
        }
        else {
            return;
        }
        const radio = enabledRadios[selectedIndex];
        const name = `${radio.name}`;
        if (this.selected !== name) {
            event.preventDefault();
            event.stopPropagation();
            this.selected = name;
            radio.focus();
        }
    }
    computeSelectableRegExp_() {
        const tags = this.selectableElements.split(', ').join('|');
        return new RegExp(`^(${tags})$`, 'i');
    }
    onClick_(event) {
        const path = event.composedPath();
        if (path.some(target => /^a$/i.test(target.tagName))) {
            return;
        }
        const target = path.find(n => this.selectableRegExp_.test(n.tagName));
        if (target && this.buttons_ && this.buttons_.includes(target)) {
            this.select_(target);
        }
    }
    populate_() {
        const nodes = this.shadowRoot.querySelector('slot').assignedNodes({ flatten: true });
        this.buttons_ = Array.from(nodes).flatMap(node => {
            if (node.nodeType !== Node.ELEMENT_NODE) {
                return [];
            }
            const el = node;
            let result = [];
            if (el.matches(this.selectableElements)) {
                result.push(el);
            }
            if (this.nestedSelectable) {
                result = result.concat(Array.from(el.querySelectorAll(this.selectableElements)));
            }
            return result;
        });
        this.buttonEventTracker_.removeAll();
        this.buttons_.forEach(el => {
            this.buttonEventTracker_.add(el, 'disabled-changed', () => this.populate_());
            this.buttonEventTracker_.add(el, 'name-changed', () => this.populate_());
        });
        this.update_();
    }
    select_(button) {
        if (!isEnabled(button)) {
            return;
        }
        const name = `${button.name}`;
        if (this.selected !== name) {
            this.selected = name;
        }
    }
    isButtonEnabledAndSelected_(button) {
        return !this.disabled && button.checked && isEnabled(button);
    }
    update_() {
        if (!this.buttons_) {
            return;
        }
        let noneMadeFocusable = true;
        this.buttons_.forEach(radio => {
            radio.checked =
                this.selected !== undefined && `${radio.name}` === `${this.selected}`;
            const disabled = this.disabled || !isEnabled(radio);
            const canBeFocused = radio.checked && !disabled;
            if (canBeFocused) {
                radio.focusable = true;
                noneMadeFocusable = false;
            }
            else {
                radio.focusable = false;
            }
            radio.setAttribute('aria-disabled', `${disabled}`);
        });
        this.setAttribute('aria-disabled', `${this.disabled}`);
        if (noneMadeFocusable && !this.disabled) {
            const radio = this.buttons_.find(isEnabled);
            if (radio) {
                radio.focusable = true;
            }
        }
    }
}
customElements.define(CrRadioGroupElement.is, CrRadioGroupElement);

const styleMod$3 = document.createElement('dom-module');
styleMod$3.appendChild(html `
  <template>
    <style>
.md-select{--md-arrow-width:10px;--md-select-bg-color:var(--cros-sys-input_field_on_base);--md-select-focus-shadow-color:var(--cros-sys-primary);--md-select-option-bg-color:var(--cros-sys-base_elevated);--md-select-side-padding:8px;--md-select-text-color:var(--cros-sys-on_surface);-webkit-appearance:none;background:url(//resources/images/arrow_down.svg) calc(100% - var(--md-select-side-padding)) center no-repeat;background-color:var(--md-select-bg-color);background-size:var(--md-arrow-width);border:none;border-radius:4px;color:var(--md-select-text-color);cursor:pointer;font-family:inherit;font-size:inherit;line-height:inherit;max-width:100%;outline:none;padding-bottom:6px;padding-inline-end:calc(var(--md-select-side-padding) + var(--md-arrow-width) + 3px);padding-inline-start:var(--md-select-side-padding);padding-top:6px;width:var(--md-select-width,200px)}@media (prefers-color-scheme:dark){.md-select{background-image:url(//resources/images/dark/arrow_down.svg)}}:host-context([chrome-refresh-2023]) .md-select{--md-select-bg-color:transparent;--md-arrow-width:7px;--md-select-side-padding:10px;--md-select-text-color:inherit;border:solid 1px var(--color-combobox-container-outline,var(--cr-fallback-color-neutral-outline));border-radius:8px;box-sizing:border-box;font-size:12px;height:36px;line-height:36px;padding-bottom:0;padding-top:0}:host-context([chrome-refresh-2023]) .md-select:hover{background-color:var(--color-comboxbox-ink-drop-hovered,var(--cr-hover-on-subtle-background-color))}.md-select :-webkit-any(option,optgroup){background-color:var(--md-select-option-bg-color)}.md-select[disabled]{opacity:var(--cr-disabled-opacity);pointer-events:none}:host-context([chrome-refresh-2023]) .md-select[disabled]{background-color:var(--color-combobox-background-disabled,var(--cr-fallback-color-disabled-background));border-color:transparent;color:var(--color-textfield-foreground-disabled,var(--cr-fallback-color-disabled-foreground));opacity:1}.md-select:focus{box-shadow:0 0 0 2px var(--md-select-focus-shadow-color)}:host-context([chrome-refresh-2023]) .md-select:focus{box-shadow:none;outline:solid 2px var(--cr-focus-outline-color);outline-offset:-1px}@media (forced-colors:active){.md-select:focus{outline:var(--cr-focus-outline-hcm)}}.md-select:active{box-shadow:none}:host-context([dir=rtl]) .md-select{background-position-x:var(--md-select-side-padding)}
    </style>
  </template>
`.content);
styleMod$3.register('md-select');

function getTemplate$11() {
    return html `<!--_html_template_start_--><style include="common md-select">.ambient-subpage-element-title{margin-bottom:0;margin-inline-start:0px}.md-select{margin-block-start:20px;margin-inline-end:8px}</style>
<div class="ambient-toggle-row">
  <span class="ambient-subpage-element-title" id="ambientDurationTitle">
    $i18n{ambientModeDurationTitle}
  </span>
  <select id="durationOptions" class="md-select"
      on-change="onOptionChanged_" aria-labelledby="ambientDurationTitle">
    <template is="dom-repeat" items="[[options_]]" as="option">
      <option value="[[option]]"
          selected="[[isEqual_(option, selectedDuration_)]]">
        [[getDurationLabel_(option)]]
      </option>
    </template>
  </select>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A polymer element that presents ambient duration settings in
 * the ambient subpage element.
 */
class AmbientDurationElement extends WithPersonalizationStore {
    static get is() {
        return 'ambient-duration';
    }
    static get template() {
        return getTemplate$11();
    }
    static get properties() {
        return {
            /**
             * Used to refer to the enum values in HTML file.
             */
            duration: {
                type: Number,
                observer: 'onDurationChanged_',
            },
            options_: {
                type: Array,
                value: ['5', '10', '30', '60', '0'],
            },
            selectedDuration_: {
                type: String,
                observer: 'onSelectedDurationChanged_',
            },
        };
    }
    getDurationLabel_(name) {
        switch (name) {
            case '5':
                return this.i18n('ambientModeDurationMinutes', 5);
            case '10':
                return this.i18n('ambientModeDurationMinutes', 10);
            case '30':
                return this.i18n('ambientModeDurationMinutes', 30);
            case '60':
                return this.i18n('ambientModeDurationOneHour');
            case '0':
                return this.i18n('ambientModeDurationForever');
            default:
                console.error('Unknown screen saver duration value.');
                return '';
        }
    }
    onDurationChanged_(value) {
        if (typeof value === 'number') {
            this.selectedDuration_ = value.toString();
        }
    }
    onOptionChanged_() {
        const elem = this.shadowRoot.querySelector('#durationOptions');
        if (elem) {
            this.selectedDuration_ = elem.value;
        }
    }
    setScreenSaverDuration_(minutes) {
        setScreenSaverDuration(minutes, getAmbientProvider(), this.getStore());
    }
    onSelectedDurationChanged_(value) {
        const minutes = parseInt(value, 10);
        if (isNaN(minutes)) {
            console.warn('Unexpected duration value received', value);
            return;
        }
        this.setScreenSaverDuration_(minutes);
    }
    isEqual_(lhs, rhs) {
        return lhs === rhs;
    }
}
customElements.define(AmbientDurationElement.is, AmbientDurationElement);

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/

const template$5 = html`<dom-module id="paper-spinner-styles">
  <template>
    <style>
      /*
      /**************************/
      /* STYLES FOR THE SPINNER */
      /**************************/

      /*
       * Constants:
       *      ARCSIZE     = 270 degrees (amount of circle the arc takes up)
       *      ARCTIME     = 1333ms (time it takes to expand and contract arc)
       *      ARCSTARTROT = 216 degrees (how much the start location of the arc
       *                                should rotate each time, 216 gives us a
       *                                5 pointed star shape (it's 360/5 * 3).
       *                                For a 7 pointed star, we might do
       *                                360/7 * 3 = 154.286)
       *      SHRINK_TIME = 400ms
       */

      :host {
        display: inline-block;
        position: relative;
        width: 28px;
        height: 28px;

        /* 360 * ARCTIME / (ARCSTARTROT + (360-ARCSIZE)) */
        --paper-spinner-container-rotation-duration: 1568ms;

        /* ARCTIME */
        --paper-spinner-expand-contract-duration: 1333ms;

        /* 4 * ARCTIME */
        --paper-spinner-full-cycle-duration: 5332ms;

        /* SHRINK_TIME */
        --paper-spinner-cooldown-duration: 400ms;

        /* Colors */
        --google-red-500: #db4437;
        --google-blue-500: #4285f4;
        --google-green-500: #0f9d58;
        --google-yellow-500: #f4b400;
      }

      #spinnerContainer {
        width: 100%;
        height: 100%;

        /* The spinner does not have any contents that would have to be
         * flipped if the direction changes. Always use ltr so that the
         * style works out correctly in both cases. */
        direction: ltr;
      }

      #spinnerContainer.active {
        animation: container-rotate var(--paper-spinner-container-rotation-duration) linear infinite;
      }

      @-webkit-keyframes container-rotate {
        to { -webkit-transform: rotate(360deg) }
      }

      @keyframes container-rotate {
        to { transform: rotate(360deg) }
      }

      .spinner-layer {
        position: absolute;
        width: 100%;
        height: 100%;
        opacity: 0;
        white-space: nowrap;
        color: var(--paper-spinner-color, var(--google-blue-500));
      }

      .layer-1 {
        color: var(--paper-spinner-layer-1-color, var(--google-blue-500));
      }

      .layer-2 {
        color: var(--paper-spinner-layer-2-color, var(--google-red-500));
      }

      .layer-3 {
        color: var(--paper-spinner-layer-3-color, var(--google-yellow-500));
      }

      .layer-4 {
        color: var(--paper-spinner-layer-4-color, var(--google-green-500));
      }

      /**
       * IMPORTANT NOTE ABOUT CSS ANIMATION PROPERTIES (keanulee):
       *
       * iOS Safari (tested on iOS 8.1) does not handle animation-delay very well - it doesn't
       * guarantee that the animation will start _exactly_ after that value. So we avoid using
       * animation-delay and instead set custom keyframes for each color (as layer-2undant as it
       * seems).
       */
      .active .spinner-layer {
        animation-name: fill-unfill-rotate;
        animation-duration: var(--paper-spinner-full-cycle-duration);
        animation-timing-function: cubic-bezier(0.4, 0.0, 0.2, 1);
        animation-iteration-count: infinite;
        opacity: 1;
      }

      .active .spinner-layer.layer-1 {
        animation-name: fill-unfill-rotate, layer-1-fade-in-out;
      }

      .active .spinner-layer.layer-2 {
        animation-name: fill-unfill-rotate, layer-2-fade-in-out;
      }

      .active .spinner-layer.layer-3 {
        animation-name: fill-unfill-rotate, layer-3-fade-in-out;
      }

      .active .spinner-layer.layer-4 {
        animation-name: fill-unfill-rotate, layer-4-fade-in-out;
      }

      @-webkit-keyframes fill-unfill-rotate {
        12.5% { -webkit-transform: rotate(135deg) } /* 0.5 * ARCSIZE */
        25%   { -webkit-transform: rotate(270deg) } /* 1   * ARCSIZE */
        37.5% { -webkit-transform: rotate(405deg) } /* 1.5 * ARCSIZE */
        50%   { -webkit-transform: rotate(540deg) } /* 2   * ARCSIZE */
        62.5% { -webkit-transform: rotate(675deg) } /* 2.5 * ARCSIZE */
        75%   { -webkit-transform: rotate(810deg) } /* 3   * ARCSIZE */
        87.5% { -webkit-transform: rotate(945deg) } /* 3.5 * ARCSIZE */
        to    { -webkit-transform: rotate(1080deg) } /* 4   * ARCSIZE */
      }

      @keyframes fill-unfill-rotate {
        12.5% { transform: rotate(135deg) } /* 0.5 * ARCSIZE */
        25%   { transform: rotate(270deg) } /* 1   * ARCSIZE */
        37.5% { transform: rotate(405deg) } /* 1.5 * ARCSIZE */
        50%   { transform: rotate(540deg) } /* 2   * ARCSIZE */
        62.5% { transform: rotate(675deg) } /* 2.5 * ARCSIZE */
        75%   { transform: rotate(810deg) } /* 3   * ARCSIZE */
        87.5% { transform: rotate(945deg) } /* 3.5 * ARCSIZE */
        to    { transform: rotate(1080deg) } /* 4   * ARCSIZE */
      }

      @-webkit-keyframes layer-1-fade-in-out {
        0% { opacity: 1 }
        25% { opacity: 1 }
        26% { opacity: 0 }
        89% { opacity: 0 }
        90% { opacity: 1 }
        to { opacity: 1 }
      }

      @keyframes layer-1-fade-in-out {
        0% { opacity: 1 }
        25% { opacity: 1 }
        26% { opacity: 0 }
        89% { opacity: 0 }
        90% { opacity: 1 }
        to { opacity: 1 }
      }

      @-webkit-keyframes layer-2-fade-in-out {
        0% { opacity: 0 }
        15% { opacity: 0 }
        25% { opacity: 1 }
        50% { opacity: 1 }
        51% { opacity: 0 }
        to { opacity: 0 }
      }

      @keyframes layer-2-fade-in-out {
        0% { opacity: 0 }
        15% { opacity: 0 }
        25% { opacity: 1 }
        50% { opacity: 1 }
        51% { opacity: 0 }
        to { opacity: 0 }
      }

      @-webkit-keyframes layer-3-fade-in-out {
        0% { opacity: 0 }
        40% { opacity: 0 }
        50% { opacity: 1 }
        75% { opacity: 1 }
        76% { opacity: 0 }
        to { opacity: 0 }
      }

      @keyframes layer-3-fade-in-out {
        0% { opacity: 0 }
        40% { opacity: 0 }
        50% { opacity: 1 }
        75% { opacity: 1 }
        76% { opacity: 0 }
        to { opacity: 0 }
      }

      @-webkit-keyframes layer-4-fade-in-out {
        0% { opacity: 0 }
        65% { opacity: 0 }
        75% { opacity: 1 }
        90% { opacity: 1 }
        to { opacity: 0 }
      }

      @keyframes layer-4-fade-in-out {
        0% { opacity: 0 }
        65% { opacity: 0 }
        75% { opacity: 1 }
        90% { opacity: 1 }
        to { opacity: 0 }
      }

      .circle-clipper {
        display: inline-block;
        position: relative;
        width: 50%;
        height: 100%;
        overflow: hidden;
      }

      /**
       * Patch the gap that appear between the two adjacent div.circle-clipper while the
       * spinner is rotating (appears on Chrome 50, Safari 9.1.1, and Edge).
       */
      .spinner-layer::after {
        content: '';
        left: 45%;
        width: 10%;
        border-top-style: solid;
      }

      .spinner-layer::after,
      .circle-clipper .circle {
        box-sizing: border-box;
        position: absolute;
        top: 0;
        border-width: var(--paper-spinner-stroke-width, 3px);
        border-radius: 50%;
      }

      .circle-clipper .circle {
        bottom: 0;
        width: 200%;
        border-style: solid;
        border-bottom-color: transparent !important;
      }

      .circle-clipper.left .circle {
        left: 0;
        border-right-color: transparent !important;
        transform: rotate(129deg);
      }

      .circle-clipper.right .circle {
        left: -100%;
        border-left-color: transparent !important;
        transform: rotate(-129deg);
      }

      .active .gap-patch::after,
      .active .circle-clipper .circle {
        animation-duration: var(--paper-spinner-expand-contract-duration);
        animation-timing-function: cubic-bezier(0.4, 0.0, 0.2, 1);
        animation-iteration-count: infinite;
      }

      .active .circle-clipper.left .circle {
        animation-name: left-spin;
      }

      .active .circle-clipper.right .circle {
        animation-name: right-spin;
      }

      @-webkit-keyframes left-spin {
        0% { -webkit-transform: rotate(130deg) }
        50% { -webkit-transform: rotate(-5deg) }
        to { -webkit-transform: rotate(130deg) }
      }

      @keyframes left-spin {
        0% { transform: rotate(130deg) }
        50% { transform: rotate(-5deg) }
        to { transform: rotate(130deg) }
      }

      @-webkit-keyframes right-spin {
        0% { -webkit-transform: rotate(-130deg) }
        50% { -webkit-transform: rotate(5deg) }
        to { -webkit-transform: rotate(-130deg) }
      }

      @keyframes right-spin {
        0% { transform: rotate(-130deg) }
        50% { transform: rotate(5deg) }
        to { transform: rotate(-130deg) }
      }

      #spinnerContainer.cooldown {
        animation: container-rotate var(--paper-spinner-container-rotation-duration) linear infinite, fade-out var(--paper-spinner-cooldown-duration) cubic-bezier(0.4, 0.0, 0.2, 1);
      }

      @-webkit-keyframes fade-out {
        0% { opacity: 1 }
        to { opacity: 0 }
      }

      @keyframes fade-out {
        0% { opacity: 1 }
        to { opacity: 0 }
      }
    </style>
  </template>
</dom-module>`;

document.head.appendChild(template$5.content);

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/

/** @polymerBehavior */
const PaperSpinnerBehavior = {

  properties: {
    /**
     * Displays the spinner.
     */
    active: {
      type: Boolean,
      value: false,
      reflectToAttribute: true,
      observer: '__activeChanged'
    },

    /**
     * Alternative text content for accessibility support.
     * If alt is present, it will add an aria-label whose content matches alt
     * when active. If alt is not present, it will default to 'loading' as the
     * alt value.
     */
    alt: {type: String, value: 'loading', observer: '__altChanged'},

    __coolingDown: {type: Boolean, value: false}
  },

  __computeContainerClasses: function(active, coolingDown) {
    return [
      active || coolingDown ? 'active' : '',
      coolingDown ? 'cooldown' : ''
    ].join(' ');
  },

  __activeChanged: function(active, old) {
    this.__setAriaHidden(!active);
    this.__coolingDown = !active && old;
  },

  __altChanged: function(alt) {
    // user-provided `aria-label` takes precedence over prototype default
    if (alt === 'loading') {
      this.alt = this.getAttribute('aria-label') || alt;
    } else {
      this.__setAriaHidden(alt === '');
      this.setAttribute('aria-label', alt);
    }
  },

  __setAriaHidden: function(hidden) {
    var attr = 'aria-hidden';
    if (hidden) {
      this.setAttribute(attr, 'true');
    } else {
      this.removeAttribute(attr);
    }
  },

  __reset: function() {
    this.active = false;
    this.__coolingDown = false;
  }
};

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/

const template$4 = html`
  <style include="paper-spinner-styles"></style>

  <div id="spinnerContainer" class-name="[[__computeContainerClasses(active, __coolingDown)]]" on-animationend="__reset" on-webkit-animation-end="__reset">
    <div class="spinner-layer">
      <div class="circle-clipper left">
        <div class="circle"></div>
      </div>
      <div class="circle-clipper right">
        <div class="circle"></div>
      </div>
    </div>
  </div>
`;
template$4.setAttribute('strip-whitespace', '');

/**
Material design: [Progress &
activity](https://www.google.com/design/spec/components/progress-activity.html)

Element providing a single color material design circular spinner.

    <paper-spinner-lite active></paper-spinner-lite>

The default spinner is blue. It can be customized to be a different color.

### Accessibility

Alt attribute should be set to provide adequate context for accessibility. If
not provided, it defaults to 'loading'. Empty alt can be provided to mark the
element as decorative if alternative content is provided in another form (e.g. a
text block following the spinner).

    <paper-spinner-lite alt="Loading contacts list" active></paper-spinner-lite>

### Styling

The following custom properties and mixins are available for styling:

Custom property | Description | Default
----------------|-------------|----------
`--paper-spinner-color` | Color of the spinner | `--google-blue-500`
`--paper-spinner-stroke-width` | The width of the spinner stroke | 3px

@group Paper Elements
@element paper-spinner-lite
@hero hero.svg
@demo demo/index.html
*/
Polymer({
  _template: template$4,

  is: 'paper-spinner-lite',

  behaviors: [PaperSpinnerBehavior]
});

function getTemplate$10() {
    return html `<!--_html_template_start_--><style>path{fill:var(--cros-sys-primary_container,var(--cros-highlight-color))}</style>
<svg width="192" height="190" viewBox="0 0 192 190" fill="none" xmlns="http://www.w3.org/2000/svg">
  <path d="M2.12279 105.772C-0.49169 101.433 -0.704305 96.0783 1.55808 91.5495L4.73978 85.1805C6.09266 82.4724 6.58103 79.421 6.14004 76.4317L5.10292 69.4015C4.36546 64.4025 6.23989 59.3745 10.0814 56.0473L15.4839 51.368C17.781 49.3783 19.4122 46.7442 20.1608 43.8154L21.9213 36.9275C23.1731 32.0299 26.8493 28.0945 31.685 26.4752L38.4858 24.198C41.3775 23.2297 43.9032 21.4139 45.7274 18.9915L50.0175 13.2947C53.068 9.24384 57.9862 7.00016 63.08 7.33548L70.2437 7.80705C73.2898 8.00757 76.3255 7.28637 78.9475 5.73923L85.1141 2.10067C89.4989 -0.486566 94.9104 -0.696967 99.4868 1.54185L105.923 4.69041C108.66 6.02919 111.743 6.51248 114.764 6.07608L121.868 5.04976C126.92 4.31999 132 6.17489 135.363 9.97637L140.091 15.3226C142.102 17.5958 144.764 19.21 147.723 19.9508L154.684 21.6929C159.633 22.9317 163.61 26.5696 165.246 31.355L167.547 38.0849C168.526 40.9465 170.361 43.4459 172.809 45.2511L178.565 49.4965C182.659 52.5152 184.926 57.3822 184.587 62.423L184.111 69.512C183.908 72.5264 184.637 75.5304 186.2 78.1252L189.877 84.2275C192.492 88.5667 192.704 93.9217 190.442 98.4505L187.26 104.82C185.907 107.528 185.419 110.579 185.86 113.568L186.897 120.599C187.635 125.597 185.76 130.625 181.919 133.953L176.516 138.632C174.219 140.622 172.588 143.256 171.839 146.185L170.079 153.072C168.827 157.97 165.151 161.906 160.315 163.525L153.514 165.802C150.622 166.77 148.097 168.586 146.273 171.008L141.982 176.705C138.932 180.756 134.014 183 128.92 182.665L121.756 182.193C118.71 181.992 115.675 182.714 113.052 184.261L106.886 187.899C102.501 190.487 97.0896 190.697 92.5132 188.458L86.0771 185.31C83.3405 183.971 80.257 183.488 77.2362 183.924L70.132 184.95C65.0804 185.68 59.9995 183.825 56.6372 180.024L51.9087 174.677C49.8981 172.404 47.2362 170.79 44.2766 170.049L37.3163 168.307C32.367 167.068 28.3902 163.43 26.7539 158.645L24.4527 151.915C23.4743 149.053 21.6393 146.554 19.1914 144.749L13.4346 140.504C9.34115 137.485 7.07385 132.618 7.4127 127.577L7.88923 120.488C8.09186 117.474 7.36307 114.47 5.79964 111.875L2.12279 105.772Z">
  </path>
</svg>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A polymer component that displays the wavy message container
 * in the ambient preview element.
 */
class AmbientZeroStateSvgElement extends PolymerElement {
    static get is() {
        return 'ambient-zero-state-svg';
    }
    static get template() {
        return getTemplate$10();
    }
}
customElements.define(AmbientZeroStateSvgElement.is, AmbientZeroStateSvgElement);

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A base polymer element that previews the current selected
 * screensaver. Extend this element and provide a template to make a full
 * polymer element.
 */
const AMBIENT_ERROR_ID = 'AmbientPreviewBase';
/**
 * Removes the resolution suffix at the end of an image (from character '=' to
 * the end) and replace it with a new resolution suffix.
 */
function replaceResolutionSuffix(url, resolution) {
    return url.replace(/=w[\w-]+$/, resolution);
}
class AmbientPreviewBase extends WithPersonalizationStore {
    constructor() {
        super(...arguments);
        this.loadingTimeoutIds_ = null;
    }
    static { this.timeoutsMs = {
        refresh: 30 * 1000,
        timeout: 60 * 1000,
    }; }
    static get properties() {
        return {
            ambientModeEnabled_: Boolean,
            albums_: {
                type: Array,
                value: null,
            },
            topicSource_: {
                type: Object,
                value: null,
            },
            previewAlbums_: {
                type: Array,
                computed: 'computePreviewAlbums_(albums_, topicSource_)',
            },
            firstPreviewAlbum_: {
                type: Object,
                computed: 'computeFirstPreviewAlbum_(previewAlbums_)',
            },
            loading_: {
                type: Boolean,
                computed: 'computeLoading_(isAmbientModeAllowed_, ambientModeEnabled_, albums_, topicSource_, previewImages_)',
                observer: 'onLoadingChanged_',
            },
            shouldShowLoadingAnimation_: {
                type: Boolean,
                value: true,
            },
            previewImages_: {
                type: Array,
                value: null,
            },
            isAmbientModeAllowed_: {
                type: Boolean,
                value() {
                    return isAmbientModeAllowed();
                },
            },
        };
    }
    ready() {
        super.ready();
        AmbientObserver.initAmbientObserverIfNeeded();
    }
    connectedCallback() {
        super.connectedCallback();
        this.watch('ambientModeEnabled_', state => state.ambient.ambientModeEnabled);
        this.watch('albums_', state => state.ambient.albums);
        this.watch('previewImages_', state => state.ambient.previews);
        this.watch('topicSource_', state => state.ambient.topicSource);
        this.updateFromStore();
    }
    disconnectedCallback() {
        this.cleanUpTimeoutIds_();
    }
    cleanUpTimeoutIds_() {
        if (!this.loadingTimeoutIds_) {
            return;
        }
        window.clearTimeout(this.loadingTimeoutIds_.refresh);
        window.clearTimeout(this.loadingTimeoutIds_.timeout);
        this.loadingTimeoutIds_ = null;
    }
    computeLoading_() {
        if (!this.isAmbientModeAllowed_ || this.ambientModeEnabled_ === false) {
            return false;
        }
        return this.ambientModeEnabled_ === null || this.albums_ === null ||
            this.topicSource_ === null || this.previewImages_ === null;
    }
    onLoadingChanged_(value) {
        if (!value && this.loadingTimeoutIds_) {
            this.cleanUpTimeoutIds_();
            this.shouldShowLoadingAnimation_ = false;
            if (this.getState().error) {
                this.dispatch(dismissErrorAction(AMBIENT_ERROR_ID, false));
            }
            return;
        }
        if (value && !this.loadingTimeoutIds_) {
            this.shouldShowLoadingAnimation_ = true;
            this.loadingTimeoutIds_ = {
                // Show an error and stop the loading animation.
                timeout: window.setTimeout(() => {
                    this.shouldShowLoadingAnimation_ = false;
                    this.dispatch(setErrorAction({
                        id: AMBIENT_ERROR_ID,
                        message: this.i18n('ambientModeNetworkError')
                    }));
                }, AmbientPreviewBase.timeoutsMs.timeout),
                // Restart AmbientObserver if loading has not finished.
                refresh: window.setTimeout(() => {
                    AmbientObserver.shutdown();
                    AmbientObserver.initAmbientObserverIfNeeded();
                }, AmbientPreviewBase.timeoutsMs.refresh)
            };
        }
    }
    computePreviewAlbums_() {
        return (this.albums_ || [])
            .filter(album => album.topicSource === this.topicSource_ && album.checked &&
            album.url);
    }
    computeFirstPreviewAlbum_() {
        if (isNonEmptyArray(this.previewAlbums_)) {
            return this.previewAlbums_[0];
        }
        return null;
    }
    getPreviewContainerClass_() {
        const classes = [];
        if (this.ambientModeEnabled_ || this.loading_) {
            classes.push('ambient-mode-enabled');
        }
        if (!this.ambientModeEnabled_) {
            classes.push('ambient-mode-disabled');
        }
        return classes.join(' ');
    }
    getPreviewImage_(album) {
        // Replace the resolution suffix appended at the end of the images
        // with a new resolution suffix of 512px so that we do not download very
        // large images. This won't impact images with no resolution suffix.
        return album && album.url ?
            replaceResolutionSuffix(album.url.url, '=s512') :
            '';
    }
    getPreviewTextAriaLabel_() {
        return `${this.i18n('currentlySet')} ${this.getAlbumTitle_()} ${this.getAlbumDescription_()}`;
    }
    getAlbumTitle_() {
        return this.firstPreviewAlbum_ ? this.firstPreviewAlbum_.title : '';
    }
    getAlbumDescription_() {
        if (!isNonEmptyArray(this.previewAlbums_) || this.topicSource_ === null) {
            return '';
        }
        switch (this.previewAlbums_.length) {
            case 1:
                // For only 1 selected album, album description includes image source
                // and number of photos in the album (only applicable for Google
                // Photos).
                const topicSourceDesc = getTopicSourceName(this.topicSource_);
                if (this.topicSource_ === TopicSource.kArtGallery) {
                    return topicSourceDesc;
                }
                else if (this.topicSource_ === TopicSource.kVideo) {
                    return this.previewAlbums_[0].description;
                }
                else {
                    // TODO(b/223834394): replace dot separator symbol • with an
                    // icon/image.
                    return `${topicSourceDesc} • ${getPhotoCount(this.previewAlbums_[0].numberOfPhotos)}`;
                }
            case 2:
            case 3:
                // For 2-3 selected albums, album description includes the titles of all
                // selected albums except the first one already shown in album title
                // text.
                const albumTitles = this.previewAlbums_.slice(1).map(album => album.title);
                return albumTitles.join(', ');
            default:
                // For more than 3 selected albums, album description includes the title
                // of the second album and the number of remaining albums.
                // For example: Sweden 2020, +2 more albums.
                return this.i18n('ambientModeMultipleAlbumsDesc', this.previewAlbums_[1].title, this.previewAlbums_.length - 2);
        }
    }
    getPlaceholderClasses_(shouldShowLoadingAnimation) {
        const classes = ['placeholder'];
        if (!shouldShowLoadingAnimation) {
            classes.push('placeholder-no-animation');
        }
        return classes.join(' ');
    }
}

function getTemplate$$() {
    return html `<!--_html_template_start_--><style include="common cros-button-style">#container{background-color:var(--cros-bg-color);border:none;border-radius:16px;display:grid;grid-template-areas:'. slot           slot    slot      .' '. image          image   image     .' '. .              .       .         .' '. message        message message   .' '. mainpage-desc  .       thumbnail .' '. .              .       .         .';grid-template-columns:20px auto 192px auto 20px;grid-template-rows:auto auto 20px 192px 1fr 20px;height:100%}#container.ambient-mode-enabled{grid-template-areas:'. slot          .' '. image         .' '. .             .' '. thumbnail     .' '. mainpage-desc .' '. .             .';grid-template-columns:20px minmax(0,1fr) 20px;grid-template-rows:auto auto 20px 130px 1fr 18px}#ambientLabel{align-items:center;background:none;border:none;display:flex;flex-flow:row nowrap;grid-area:slot;justify-content:space-between;margin-top:12px}#ambientLabel>cr-icon-button{--cr-icon-button-size:44px;margin-inline-end:-18px}#ambientLabel>h2{color:var(--cros-text-color-primary);font:var(--personalization-app-label-font);margin:12px 0}#messageContainer{align-items:center;display:flex;flex-direction:column;grid-area:message;justify-content:space-between}#messageContainer .text{color:var(--cros-sys-on_primary_container);font:var(--cros-body-2-font);line-height:1.5;margin-top:56px;position:relative;text-align:center;width:128px}#messageContainer cr-button{margin-bottom:50px;margin-top:8px}ambient-zero-state-svg{position:absolute}#imageContainer,#imagePlaceholder{aspect-ratio:340/220;display:flex;height:100%;justify-self:center;max-width:460px;min-width:278px;width:100%}.album-info-mainpage,#textPlaceholder{align-items:center;display:flex;grid-area:mainpage-desc;justify-content:center}#textPlaceholder .placeholder:first-child{margin-top:8px}#imageContainer,#imagePlaceholder{grid-area:image}#albumTitle{color:var(--cros-text-color-primary);font:var(--cros-display-7-font);margin-top:10px}#albumDescription{color:var(--cros-text-color-secondary);font:var(--cros-body-2-font);margin-top:2px}#buttonContainer{grid-area:buttons}#buttonContainer .text{margin-inline-start:8px}#buttonContainer .preview-button-disabled{cursor:wait;pointer-events:none}#buttonContainer cr-button{border-color:var(--cros-button-stroke-color-secondary);border-radius:16px}#buttonContainer .spinner{height:20px;width:20px}#thumbnailContainer,#thumbnailPlaceholder{display:grid;grid-area:thumbnail;justify-self:center;max-width:460px;min-width:278px;overflow:hidden;width:100%}.thumbnail-item{height:100%;overflow:hidden;width:100%}.thumbnail-item img{height:100%;object-fit:cover;width:100%}#thumbnailContainer.thumbnail-0{background-color:var(--personalization-app-grid-item-background-color);border-radius:12px}#thumbnailContainer.thumbnail-1 .thumbnail-item{border-radius:60px}#thumbnailContainer.thumbnail-2{column-gap:12px;grid-template-columns:130px minmax(0,1fr)}#thumbnailContainer.thumbnail-2 .thumbnail-item:first-of-type{clip-path:url(#squiggleClip)}#thumbnailContainer.thumbnail-2 .thumbnail-item:last-of-type{border-radius:60px}#thumbnailContainer.thumbnail-3{column-gap:8px;grid-template-columns:minmax(0,1fr) 32px 32px}#thumbnailContainer.thumbnail-3 .thumbnail-item:first-of-type{border-radius:60px}#thumbnailContainer.thumbnail-3 .thumbnail-item:last-of-type img,#thumbnailContainer.thumbnail-3 .thumbnail-item:nth-last-of-type(2) img{border-radius:16px}#helpLink{color:var(--text-color-action);text-decoration:none}</style>
<div class$="[[getPreviewContainerClass_(ambientModeEnabled_, loading_)]]" id="container">
  <!-- Use inline svg in order to reference the clip path by url() -->
  <svg fill="none"
      height="0"
      viewBox="0 0 130 130"
      width="0"
      xmlns="http://www.w3.org/2000/svg">
    <defs>
      <clipPath id="squiggleClip">
        <path d="M 1.4375 72.371094 C -0.332031 69.402344 -0.476562 65.738281 1.054688 62.640625 L 3.210938 58.28125 C 4.125 56.429688 4.457031 54.339844 4.15625 52.296875 L 3.457031 47.484375 C 2.957031 44.066406 4.226562 40.625 6.824219 38.347656 L 10.484375 35.148438 C 12.039062 33.785156 13.144531 31.984375 13.652344 29.980469 L 14.84375 25.265625 C 15.691406 21.914062 18.179688 19.222656 21.453125 18.113281 L 26.058594 16.554688 C 28.015625 15.894531 29.726562 14.652344 30.960938 12.996094 L 33.867188 9.097656 C 35.929688 6.324219 39.261719 4.789062 42.710938 5.019531 L 47.5625 5.339844 C 49.625 5.480469 51.679688 4.984375 53.453125 3.925781 L 57.628906 1.4375 C 60.597656 -0.332031 64.261719 -0.476562 67.359375 1.054688 L 71.71875 3.210938 C 73.570312 4.125 75.660156 4.457031 77.703125 4.15625 L 82.515625 3.457031 C 85.933594 2.957031 89.375 4.226562 91.652344 6.824219 L 94.851562 10.484375 C 96.214844 12.039062 98.015625 13.144531 100.019531 13.652344 L 104.734375 14.84375 C 108.085938 15.691406 110.777344 18.179688 111.886719 21.453125 L 113.445312 26.058594 C 114.105469 28.015625 115.347656 29.726562 117.003906 30.960938 L 120.902344 33.867188 C 123.675781 35.929688 125.210938 39.261719 124.980469 42.710938 L 124.660156 47.5625 C 124.519531 49.625 125.015625 51.679688 126.074219 53.453125 L 128.5625 57.628906 C 130.332031 60.597656 130.476562 64.261719 128.945312 67.359375 L 126.792969 71.71875 C 125.875 73.570312 125.542969 75.660156 125.84375 77.703125 L 126.542969 82.515625 C 127.042969 85.933594 125.773438 89.375 123.175781 91.652344 L 119.515625 94.851562 C 117.960938 96.214844 116.855469 98.015625 116.347656 100.019531 L 115.15625 104.734375 C 114.308594 108.085938 111.820312 110.777344 108.546875 111.886719 L 103.941406 113.445312 C 101.984375 114.105469 100.273438 115.347656 99.039062 117.003906 L 96.132812 120.902344 C 94.070312 123.675781 90.738281 125.210938 87.289062 124.980469 L 82.4375 124.660156 C 80.375 124.519531 78.320312 125.015625 76.546875 126.074219 L 72.371094 128.5625 C 69.402344 130.332031 65.738281 130.476562 62.640625 128.945312 L 58.28125 126.792969 C 56.429688 125.875 54.339844 125.542969 52.296875 125.84375 L 47.484375 126.542969 C 44.066406 127.042969 40.625 125.773438 38.347656 123.175781 L 35.148438 119.515625 C 33.785156 117.960938 31.984375 116.855469 29.980469 116.347656 L 25.265625 115.15625 C 21.914062 114.308594 19.222656 111.820312 18.113281 108.546875 L 16.554688 103.941406 C 15.894531 101.984375 14.652344 100.273438 12.996094 99.039062 L 9.097656 96.132812 C 6.324219 94.070312 4.789062 90.738281 5.019531 87.289062 L 5.339844 82.4375 C 5.480469 80.375 4.984375 78.320312 3.925781 76.546875 Z M 1.4375 72.371094 ">
        </path>
      </clipPath>
    </defs>
  </svg>
  <template is="dom-if" if="[[!isAmbientModeAllowed_]]">
    <div id="ambientLabel" class="disabled">
      <h2>$i18n{screensaverLabel}</h2>
      <cr-icon-button disabled
          iron-icon="cr:chevron-right">
      </cr-icon-button>
    </div>
    <div ambient-mode-managed
        aria-hidden="true"
        class="preview-image-container"
        id="imageContainer">
      <div class="preview-image-border"></div>
      <img class="preview-image disabled"
          src="//personalization/images/slideshow.png">
    </div>
    <div id="messageContainer">
      <ambient-zero-state-svg></ambient-zero-state-svg>
      <span class="text" id="turnOnDescription">
        $i18n{ambientModeMainPageEnterpriseUserMessage}
      </span>
      <cr-button class="primary action-button">
        <!-- TODO(b/282827734): create new p-link for the support page -->
        <a id="helpLink" href="https://support.google.com/chromebook?p=wallpaper_fileerror"
            target="_blank">$i18n{ambientModeLearnMoreLabel}</a>
      </cr-button>
    </div>
  </template>
  <template is="dom-if" if="[[isAmbientModeAllowed_]]">
    <div id="ambientLabel">
      <h2 class="clickable" on-click="onClickAmbientSubpageLink_">
        $i18n{screensaverLabel}
      </h2>
      <cr-icon-button aria-label="$i18n{ariaLabelChangeScreensaver}"
          class="tast-open-subpage"
          iron-icon="cr:chevron-right"
          on-click="onClickAmbientSubpageLink_">
      </cr-icon-button>
    </div>
    <template is="dom-if" if="[[loading_]]" restamp>
      <div id="imagePlaceholder" class$="[[getPlaceholderClasses_(shouldShowLoadingAnimation_)]]"></div>
      <div id="thumbnailPlaceholder" class$="[[getPlaceholderClasses_(shouldShowLoadingAnimation_)]]"></div>
      <div id="textPlaceholder"
          class="preview-text-placeholder album-info-mainpage">
        <div class$="[[getPlaceholderClasses_(shouldShowLoadingAnimation_)]]"></div>
        <div class$="[[getPlaceholderClasses_(shouldShowLoadingAnimation_)]]"></div>
      </div>
    </template>
    <template is="dom-if" if="[[!loading_]]">
      <template is="dom-if" if="[[!ambientModeEnabled_]]" restamp>
        <div aria-hidden="true"
            class="preview-image-container"
            id="imageContainer">
          <div class="preview-image-border"></div>
          <img class="preview-image disabled"
              src="//personalization/images/slideshow.png">
        </div>
        <div id="messageContainer">
          <ambient-zero-state-svg></ambient-zero-state-svg>
          <span class="text" id="turnOnDescription">
            $i18n{ambientModeMainPageZeroStateMessageV2}
          </span>
          <cr-button aria-describedby="turnOnDescription"
              class="primary action-button"
              on-click="onClickAmbientModeButton_">
            <span>$i18n{ambientModeTurnOnLabel}</span>
          </cr-button>
        </div>
      </template>
      <template is="dom-if" if="[[ambientModeEnabled_]]">
        <!-- TODO(b/226235802) - Add failed/error state when no previewAlbums
              available. Currently, we show blank containers -->
        <template is="dom-if" if="[[previewAlbums_]]">
          <div id="imageContainer" class="preview-image-container">
            <div class="preview-image-border"></div>
            <img alt$="[[getAlbumTitle_(firstPreviewAlbum_)]]"
                auto-src="[[getPreviewImage_(firstPreviewAlbum_)]]"
                class="preview-image clickable"
                is-google-photos is="cr-auto-img"
                on-click="onClickPreviewImage_"
                on-keypress="onClickPreviewImage_">
          </div>
          <div aria-hidden="true"
              class$="[[getThumbnailContainerClass_(thumbnailImages_)]]"
              id="thumbnailContainer"
              on-click="onClickThumbnails_"
              on-keypress="onClickThumbnails_">
            <template is="dom-repeat" items="[[thumbnailImages_]]">
              <div class="thumbnail-item">
                <img auto-src="[[item.url]]"
                    is-google-photos
                    is="cr-auto-img">
              </div>
            </template>
          </div>
          <div aria-label$="[[getPreviewTextAriaLabel_(firstPreviewAlbum_, topicSource_, previewAlbums_)]]"
              class="preview-text-container album-info-mainpage"
              id="textContainer">
            <span aria-hidden="true"
                id="albumTitle"
                title="[[getAlbumTitle_(firstPreviewAlbum_)]]">
              [[getAlbumTitle_(firstPreviewAlbum_)]]
            </span>
            <span aria-hidden="true" id="albumDescription">
              [[getAlbumDescription_(topicSource_, previewAlbums_)]]
            </span>
          </div>
        </template>
      </template>
    </template>
  </template>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A polymer element that previews ambient settings in a large
 * card. Shows an album cover image, some additional preview images in a
 * collage, and informational text about the selected albums. Currently used on
 * the personalization app main page.
 */
class AmbientPreviewLargeElement extends AmbientPreviewBase {
    static get is() {
        return 'ambient-preview-large';
    }
    static get template() {
        return getTemplate$$();
    }
    static get properties() {
        return {
            previewImages_: {
                type: Array,
                value: null,
            },
            thumbnailImages_: {
                type: Array,
                computed: 'computeThumbnailImages_(topicSource_, previewImages_)',
            },
        };
    }
    /** Returns the array of thumbnail images. */
    computeThumbnailImages_() {
        if (isNonEmptyArray(this.previewImages_)) {
            const maxLength = Math.min(this.previewImages_.length, this.topicSource_ === TopicSource.kArtGallery ? 2 : 3);
            return this.previewImages_.slice(0, maxLength);
        }
        return [];
    }
    onClickAmbientSubpageLink_() {
        PersonalizationRouterElement.instance().goToRoute(Paths.AMBIENT);
    }
    /** Enable ambient mode and navigates to the ambient subpage. */
    async onClickAmbientModeButton_(event) {
        assert$1(this.ambientModeEnabled_ === false);
        event.stopPropagation();
        logAmbientModeOptInUMA();
        await setAmbientModeEnabled(
        /*ambientModeEnabled=*/ true, getAmbientProvider(), this.getStore());
        PersonalizationRouterElement.instance().goToRoute(Paths.AMBIENT);
    }
    /** Navigates to the ambient subpage. */
    onClickPreviewImage_(event) {
        event.stopPropagation();
        PersonalizationRouterElement.instance().goToRoute(Paths.AMBIENT);
    }
    /**
     * Navigate to ambient subpage and scroll down to image source section.
     */
    onClickThumbnails_(event) {
        event.stopPropagation();
        PersonalizationRouterElement.instance().goToRoute(Paths.AMBIENT, { scrollTo: ScrollableTarget.TOPIC_SOURCE_LIST });
    }
    getThumbnailContainerClass_() {
        return `thumbnail-${this.thumbnailImages_.length} clickable`;
    }
}
customElements.define(AmbientPreviewLargeElement.is, AmbientPreviewLargeElement);

function getTemplate$_() {
    return html `<!--_html_template_start_--><style include="common cros-button-style">#container{border:none;display:grid;grid-template-areas:'image          . subpage-desc' 'image          . buttons' '.              . .';grid-template-columns:224px 32px minmax(0,1fr);grid-template-rows:118px 34px 20px}#container.ambient-mode-disabled{grid-template-areas:'image          . subpage-desc' '.              . .';grid-template-columns:224px 32px minmax(0,1fr);grid-template-rows:152px 20px}#buttonContainer,.currently-set-text{display:inline-flex}.album-info-subpage,.zero-state-info-subpage{display:flex;grid-area:subpage-desc;justify-content:center}#imageContainer,#imagePlaceholder{grid-area:image}#imageContainer img.disabled{opacity:50%}#buttonContainer{grid-area:buttons}#buttonContainer .text{margin-inline-start:8px}#buttonContainer .disabled{cursor:wait;pointer-events:none}#buttonContainer .spinner{--paper-spinner-color:var(--cros-sys-primary,--cros-button-label-color-primary);height:20px;width:20px}
</style>
<div class$="[[getPreviewContainerClass_(ambientModeEnabled_, loading_)]]"
    id="container">
  <template is="dom-if" if="[[loading_]]" restamp>
    <div id="imagePlaceholder" class$="[[getPlaceholderClasses_(shouldShowLoadingAnimation_)]]"></div>
    <div id="textPlaceholder"
        class="preview-text-placeholder album-info-subpage">
      <div class$="[[getPlaceholderClasses_(shouldShowLoadingAnimation_)]] currently-set-text"></div>
      <div class$="[[getPlaceholderClasses_(shouldShowLoadingAnimation_)]]"></div>
      <div class$="[[getPlaceholderClasses_(shouldShowLoadingAnimation_)]]"></div>
    </div>
  </template>
  <template is="dom-if" if="[[!loading_]]" restamp>
    <template is="dom-if" if="[[!ambientModeEnabled_]]" restamp>
      <div aria-hidden="true"
          class="preview-image-container"
          id="imageContainer">
        <div class="preview-image-border"></div>
        <img class="preview-image disabled" src="//personalization/images/slideshow.png">
      </div>
      <h2 id="zeroStateTextContainer"
          class="preview-text-container zero-state-info-subpage"
          aria-label="$i18n{ambientModeMainPageZeroStateMessage}">
        <span class="text">
          $i18n{ambientModeMainPageZeroStateMessage}
        </span>
      </h2>
    </template>
    <template is="dom-if" if="[[ambientModeEnabled_]]">
      <!-- TODO(b/226235802) - Add failed/error state when no previewAlbums available.
            Currently, we show blank containers -->
      <template is="dom-if" if="[[previewAlbums_]]">
        <div id="imageContainer" class="preview-image-container">
          <div class="preview-image-border"></div>
          <img class="preview-image" is="cr-auto-img"
              auto-src="[[getPreviewImage_(firstPreviewAlbum_)]]"
              alt$="[[getAlbumTitle_(firstPreviewAlbum_)]]"
              is-google-photos>
        </div>
        <h2 aria-label$="[[getPreviewTextAriaLabel_(firstPreviewAlbum_, topicSource_, previewAlbums_)]]"
            class="preview-text-container album-info-subpage"
            id="textContainer"
            role="alert">
          <span id="currentlySet" class="currently-set-text" aria-hidden="true">
            $i18n{currentlySet}
          </span>
          <span id="albumTitle" aria-hidden="true"
              title="[[getAlbumTitle_(firstPreviewAlbum_)]]">
            [[getAlbumTitle_(firstPreviewAlbum_)]]
          </span>
          <span id="albumDescription" aria-hidden="true">
            [[getAlbumDescription_(topicSource_, previewAlbums_)]]
          </span>
        </h2>
        <div id="buttonContainer">
          <cr-button
              class$="[[getScreenSaverPreviewClass_(ambientUiVisibility_)]]"
              aria-label$="[[getScreenSaverPreviewAriaLabel_(ambientUiVisibility_)]]"
              role$="[[getScreenSaverPreviewRole_(ambientUiVisibility_)]]"
              on-click="startScreenSaverPreview_">
            <iron-icon icon="personalization:fullscreen"
                hidden$="[[screenSaverPreviewActive_]]"></iron-icon>
            <paper-spinner-lite active class="spinner"
                hidden$="[[!screenSaverPreviewActive_]]"></paper-spinner-lite>
            <div class="text">
              [[getScreenSaverPreviewText_(ambientUiVisibility_)]]
            </div>
          </cr-button>
        </div>
      </template>
    </template>
  </template>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2023 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview A polymer element that previews ambient settings in a small
 * container. Shows a cover image from a chosen album and text describing it.
 * Currently used on the ambient settings page.
 */
class AmbientPreviewSmallElement extends AmbientPreviewBase {
    static get is() {
        return 'ambient-preview-small';
    }
    static get template() {
        return getTemplate$_();
    }
    static get properties() {
        return {
            screenSaverPreviewActive_: {
                type: Boolean,
                computed: 'computeScreenSaverPreviewActive_(ambientUiVisibility_)',
            },
            ambientUiVisibility_: {
                type: Number,
                value: null,
            },
        };
    }
    connectedCallback() {
        assert$1(isAmbientModeAllowed(), 'ambient-preview-small requires ambient mode allowed');
        super.connectedCallback();
        this.watch('ambientUiVisibility_', state => state.ambient.ambientUiVisibility);
        this.updateFromStore();
    }
    computeScreenSaverPreviewActive_() {
        return this.ambientUiVisibility_ === AmbientUiVisibility.kPreview;
    }
    startScreenSaverPreview_(event) {
        event.stopPropagation();
        startScreenSaverPreview(getAmbientProvider());
    }
    getScreenSaverPreviewClass_() {
        return this.screenSaverPreviewActive_ ?
            'preview-button-disabled secondary' :
            'preview-button secondary';
    }
    getScreenSaverPreviewText_() {
        return this.screenSaverPreviewActive_ ?
            this.i18n('screenSaverPreviewDownloading') :
            this.i18n('screenSaverPreviewButton');
    }
    getScreenSaverPreviewAriaLabel_() {
        return this.screenSaverPreviewActive_ ?
            this.i18n('screenSaverPreviewDownloadingAriaLabel') :
            this.i18n('screenSaverPreviewButtonAriaLabel');
    }
    getScreenSaverPreviewRole_() {
        return this.screenSaverPreviewActive_ ? 'none' : 'button';
    }
}
customElements.define(AmbientPreviewSmallElement.is, AmbientPreviewSmallElement);

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
/**
 * The `iron-iconset-svg` element allows users to define their own icon sets
 * that contain svg icons. The svg icon elements should be children of the
 * `iron-iconset-svg` element. Multiple icons should be given distinct id's.
 *
 * Using svg elements to create icons has a few advantages over traditional
 * bitmap graphics like jpg or png. Icons that use svg are vector based so
 * they are resolution independent and should look good on any device. They
 * are stylable via css. Icons can be themed, colorized, and even animated.
 *
 * Example:
 *
 *     <iron-iconset-svg name="my-svg-icons" size="24">
 *       <svg>
 *         <defs>
 *           <g id="shape">
 *             <rect x="12" y="0" width="12" height="24" />
 *             <circle cx="12" cy="12" r="12" />
 *           </g>
 *         </defs>
 *       </svg>
 *     </iron-iconset-svg>
 *
 * This will automatically register the icon set "my-svg-icons" to the iconset
 * database.  To use these icons from within another element, make a
 * `iron-iconset` element and call the `byId` method
 * to retrieve a given iconset. To apply a particular icon inside an
 * element use the `applyIcon` method. For example:
 *
 *     iconset.applyIcon(iconNode, 'car');
 *
 * @element iron-iconset-svg
 * @demo demo/index.html
 * @implements {Polymer.Iconset}
 */
Polymer({
  is: 'iron-iconset-svg',

  properties: {

    /**
     * The name of the iconset.
     */
    name: {type: String, observer: '_nameChanged'},

    /**
     * The size of an individual icon. Note that icons must be square.
     */
    size: {type: Number, value: 24},

    /**
     * Set to true to enable mirroring of icons where specified when they are
     * stamped. Icons that should be mirrored should be decorated with a
     * `mirror-in-rtl` attribute.
     *
     * NOTE: For performance reasons, direction will be resolved once per
     * document per iconset, so moving icons in and out of RTL subtrees will
     * not cause their mirrored state to change.
     */
    rtlMirroring: {type: Boolean, value: false},

    /**
     * Set to true to measure RTL based on the dir attribute on the body or
     * html elements (measured on document.body or document.documentElement as
     * available).
     */
    useGlobalRtlAttribute: {type: Boolean, value: false}
  },

  created: function() {
    this._meta = new IronMeta({type: 'iconset', key: null, value: null});
  },

  attached: function() {
    this.style.display = 'none';
  },

  /**
   * Construct an array of all icon names in this iconset.
   *
   * @return {!Array} Array of icon names.
   */
  getIconNames: function() {
    this._icons = this._createIconMap();
    return Object.keys(this._icons).map(function(n) {
      return this.name + ':' + n;
    }, this);
  },

  /**
   * Applies an icon to the given element.
   *
   * An svg icon is prepended to the element's shadowRoot if it exists,
   * otherwise to the element itself.
   *
   * If RTL mirroring is enabled, and the icon is marked to be mirrored in
   * RTL, the element will be tested (once and only once ever for each
   * iconset) to determine the direction of the subtree the element is in.
   * This direction will apply to all future icon applications, although only
   * icons marked to be mirrored will be affected.
   *
   * @method applyIcon
   * @param {Element} element Element to which the icon is applied.
   * @param {string} iconName Name of the icon to apply.
   * @return {?Element} The svg element which renders the icon.
   */
  applyIcon: function(element, iconName) {
    // Remove old svg element
    this.removeIcon(element);
    // install new svg element
    var svg = this._cloneIcon(
        iconName, this.rtlMirroring && this._targetIsRTL(element));
    if (svg) {
      // insert svg element into shadow root, if it exists
      var pde = element.shadowRoot ?
          element.shadowRoot : dom(element.root || element);
      pde.insertBefore(svg, pde.childNodes[0]);
      return element._svgIcon = svg;
    }
    return null;
  },

  /**
   * Produce installable clone of the SVG element matching `id` in this
   * iconset, or `undefined` if there is no matching element.
   * @param {string} iconName Name of the icon to apply.
   * @param {boolean} targetIsRTL Whether the target element is RTL.
   * @return {Element} Returns an installable clone of the SVG element
   *     matching `id`.
   */
  createIcon: function(iconName, targetIsRTL) {
    return this._cloneIcon(iconName, this.rtlMirroring && targetIsRTL);
  },

  /**
   * Remove an icon from the given element by undoing the changes effected
   * by `applyIcon`.
   *
   * @param {Element} element The element from which the icon is removed.
   */
  removeIcon: function(element) {
    // Remove old svg element
    if (element._svgIcon) {
      var root = element.shadowRoot ?
          element.shadowRoot : dom(element.root || element);
      root.removeChild(element._svgIcon);
      element._svgIcon = null;
    }
  },

  /**
   * Measures and memoizes the direction of the element. Note that this
   * measurement is only done once and the result is memoized for future
   * invocations.
   */
  _targetIsRTL: function(target) {
    if (this.__targetIsRTL == null) {
      if (this.useGlobalRtlAttribute) {
        var globalElement =
            (document.body && document.body.hasAttribute('dir')) ?
            document.body :
            document.documentElement;

        this.__targetIsRTL = globalElement.getAttribute('dir') === 'rtl';
      } else {
        if (target && target.nodeType !== Node.ELEMENT_NODE) {
          target = target.host;
        }

        this.__targetIsRTL =
            target && window.getComputedStyle(target)['direction'] === 'rtl';
      }
    }

    return this.__targetIsRTL;
  },

  /**
   *
   * When name is changed, register iconset metadata
   *
   */
  _nameChanged: function() {
    this._meta.value = null;
    this._meta.key = this.name;
    this._meta.value = this;

    this.fire('iron-iconset-added', this, {node: window});
  },

  /**
   * Create a map of child SVG elements by id.
   *
   * @return {!Object} Map of id's to SVG elements.
   */
  _createIconMap: function() {
    // Objects chained to Object.prototype (`{}`) have members. Specifically,
    // on FF there is a `watch` method that confuses the icon map, so we
    // need to use a null-based object here.
    var icons = Object.create(null);
    dom(this).querySelectorAll('[id]').forEach(function(icon) {
      icons[icon.id] = icon;
    });
    return icons;
  },

  /**
   * Produce installable clone of the SVG element matching `id` in this
   * iconset, or `undefined` if there is no matching element.
   *
   * @return {Element} Returns an installable clone of the SVG element
   * matching `id`.
   */
  _cloneIcon: function(id, mirrorAllowed) {
    // create the icon map on-demand, since the iconset itself has no discrete
    // signal to know when it's children are fully parsed
    this._icons = this._icons || this._createIconMap();
    return this._prepareSvgClone(this._icons[id], this.size, mirrorAllowed);
  },

  /**
   * @param {Element} sourceSvg
   * @param {number} size
   * @param {Boolean} mirrorAllowed
   * @return {Element}
   */
  _prepareSvgClone: function(sourceSvg, size, mirrorAllowed) {
    if (sourceSvg) {
      var content = sourceSvg.cloneNode(true),
          svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg'),
          viewBox =
              content.getAttribute('viewBox') || '0 0 ' + size + ' ' + size,
          cssText =
              'pointer-events: none; display: block; width: 100%; height: 100%;';

      if (mirrorAllowed && content.hasAttribute('mirror-in-rtl')) {
        cssText +=
            '-webkit-transform:scale(-1,1);transform:scale(-1,1);transform-origin:center;';
      }

      svg.setAttribute('viewBox', viewBox);
      svg.setAttribute('preserveAspectRatio', 'xMidYMid meet');
      svg.setAttribute('focusable', 'false');
      // TODO(dfreedm): `pointer-events: none` works around
      // https://crbug.com/370136
      // TODO(sjmiles): inline style may not be ideal, but avoids requiring a
      // shadow-root
      svg.style.cssText = cssText;
      svg.appendChild(content).removeAttribute('id');
      return svg;
    }
    return null;
  }

});

const template$3 = html `<!--
List commonly used icons here to prevent duplication.
Do not add rarely used icons here; place those in your application.
Note that 20px and 24px icons are specified separately (size="", below).

Icons are rendered at 20x20 px, but we don't have 20 px SVGs for everything.
The 24 px icons are used where 20 px icons are unavailable (which may appear
blurry at 20 px). Please use 20 px icons when available.
-->
<iron-iconset-svg name="cr20" size="20">
  <svg>
    <defs>
      <!--
      Keep these in sorted order by id="".
      -->
      <g id="block">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M10 0C4.48 0 0 4.48 0 10C0 15.52 4.48 20 10 20C15.52 20 20 15.52 20 10C20 4.48 15.52 0 10 0ZM2 10C2 5.58 5.58 2 10 2C11.85 2 13.55 2.63 14.9 3.69L3.69 14.9C2.63 13.55 2 11.85 2 10ZM5.1 16.31C6.45 17.37 8.15 18 10 18C14.42 18 18 14.42 18 10C18 8.15 17.37 6.45 16.31 5.1L5.1 16.31Z">
        </path>
      </g>
      <g id="cloud-off">
        <path
          d="M16 18.125L13.875 16H5C3.88889 16 2.94444 15.6111 2.16667 14.8333C1.38889 14.0556 1 13.1111 1 12C1 10.9444 1.36111 10.0347 2.08333 9.27083C2.80556 8.50694 3.6875 8.09028 4.72917 8.02083C4.77083 7.86805 4.8125 7.72222 4.85417 7.58333C4.90972 7.44444 4.97222 7.30555 5.04167 7.16667L1.875 4L2.9375 2.9375L17.0625 17.0625L16 18.125ZM5 14.5H12.375L6.20833 8.33333C6.15278 8.51389 6.09722 8.70139 6.04167 8.89583C6 9.07639 5.95139 9.25694 5.89583 9.4375L4.83333 9.52083C4.16667 9.57639 3.61111 9.84028 3.16667 10.3125C2.72222 10.7708 2.5 11.3333 2.5 12C2.5 12.6944 2.74306 13.2847 3.22917 13.7708C3.71528 14.2569 4.30556 14.5 5 14.5ZM17.5 15.375L16.3958 14.2917C16.7153 14.125 16.9792 13.8819 17.1875 13.5625C17.3958 13.2431 17.5 12.8889 17.5 12.5C17.5 11.9444 17.3056 11.4722 16.9167 11.0833C16.5278 10.6944 16.0556 10.5 15.5 10.5H14.125L14 9.14583C13.9028 8.11806 13.4722 7.25694 12.7083 6.5625C11.9444 5.85417 11.0417 5.5 10 5.5C9.65278 5.5 9.31944 5.54167 9 5.625C8.69444 5.70833 8.39583 5.82639 8.10417 5.97917L7.02083 4.89583C7.46528 4.61806 7.93056 4.40278 8.41667 4.25C8.91667 4.08333 9.44444 4 10 4C11.4306 4 12.6736 4.48611 13.7292 5.45833C14.7847 6.41667 15.375 7.59722 15.5 9C16.4722 9 17.2986 9.34028 17.9792 10.0208C18.6597 10.7014 19 11.5278 19 12.5C19 13.0972 18.8611 13.6458 18.5833 14.1458C18.3194 14.6458 17.9583 15.0556 17.5 15.375Z">
        </path>
      </g>
      <g id="domain">
        <path
          d="M2,3 L2,17 L11.8267655,17 L13.7904799,17 L18,17 L18,7 L12,7 L12,3 L2,3 Z M8,13 L10,13 L10,15 L8,15 L8,13 Z M4,13 L6,13 L6,15 L4,15 L4,13 Z M8,9 L10,9 L10,11 L8,11 L8,9 Z M4,9 L6,9 L6,11 L4,11 L4,9 Z M12,9 L16,9 L16,15 L12,15 L12,9 Z M12,11 L14,11 L14,13 L12,13 L12,11 Z M8,5 L10,5 L10,7 L8,7 L8,5 Z M4,5 L6,5 L6,7 L4,7 L4,5 Z">
        </path>
      </g>
      <g id="kite">
        <path fill-rule="evenodd" clip-rule="evenodd"
          d="M4.6327 8.00094L10.3199 2L16 8.00094L10.1848 16.8673C10.0995 16.9873 10.0071 17.1074 9.90047 17.2199C9.42417 17.7225 8.79147 18 8.11611 18C7.44076 18 6.80806 17.7225 6.33175 17.2199C5.85545 16.7173 5.59242 16.0497 5.59242 15.3371C5.59242 14.977 5.46445 14.647 5.22275 14.3919C4.98104 14.1369 4.66825 14.0019 4.32701 14.0019H4V12.6667H4.32701C5.00237 12.6667 5.63507 12.9442 6.11137 13.4468C6.58768 13.9494 6.85071 14.617 6.85071 15.3296C6.85071 15.6896 6.97867 16.0197 7.22038 16.2747C7.46209 16.5298 7.77488 16.6648 8.11611 16.6648C8.45735 16.6648 8.77014 16.5223 9.01185 16.2747C9.02396 16.2601 9.03607 16.246 9.04808 16.2319C9.08541 16.1883 9.12176 16.1458 9.15403 16.0947L9.55213 15.4946L4.6327 8.00094ZM10.3199 13.9371L6.53802 8.17116L10.3199 4.1814L14.0963 8.17103L10.3199 13.9371Z">
        </path>
      </g>
      <g id="menu">
        <path d="M2 4h16v2H2zM2 9h16v2H2zM2 14h16v2H2z"></path>
      </g>
        <g id="banner-warning">
          <path fill-rule="evenodd" clip-rule="evenodd"
            d="M9.13177 1.50386C9.51566 0.832046 10.4844 0.832046 10.8683 1.50386L18.8683 15.5039C19.2492 16.1705 18.7678 17 18 17H2.00001C1.23219 17 0.750823 16.1705 1.13177 15.5039L9.13177 1.50386ZM10 4.01556L3.72321 15H16.2768L10 4.01556ZM9 11H11V7H9V11ZM11 14H9V12H11V14Z">
          </path>
        </g>
        <g id="warning">
          <path fill-rule="evenodd" clip-rule="evenodd"
            d="M9.13177 1.50386C9.51566 0.832046 10.4844 0.832046 10.8683 1.50386L18.8683 15.5039C19.2492 16.1705 18.7678 17 18 17H2.00001C1.23219 17 0.750823 16.1705 1.13177 15.5039L9.13177 1.50386ZM10 4.01556L3.72321 15H16.2768L10 4.01556ZM9 11H11V7H9V11ZM11 14H9V12H11V14Z">
          </path>
        </g>
  </svg>
</iron-iconset-svg>

<!-- NOTE: In the common case that the final icon will be 20x20, export the SVG
     at 20px and place it in the section above. -->
<iron-iconset-svg name="cr" size="24">
  <svg>
    <defs>
      <!--
      These icons are copied from Polymer's iron-icons and kept in sorted order.
      -->
      <g id="account-child-invert" viewBox="0 0 48 48">
        <path d="M24 4c3.31 0 6 2.69 6 6s-2.69 6-6 6-6-2.69-6-6 2.69-6 6-6z"></path>
        <path fill="none" d="M0 0h48v48H0V0z"></path>
        <circle fill="none" cx="24" cy="26" r="4"></circle>
        <path
          d="M24 18c-6.16 0-13 3.12-13 7.23v11.54c0 2.32 2.19 4.33 5.2 5.63 2.32 1 5.12 1.59 7.8 1.59.66 0 1.33-.06 2-.14v-5.2c-.67.08-1.34.14-2 .14-2.63 0-5.39-.57-7.68-1.55.67-2.12 4.34-3.65 7.68-3.65.86 0 1.75.11 2.6.29 2.79.62 5.2 2.15 5.2 4.04v4.47c3.01-1.31 5.2-3.31 5.2-5.63V25.23C37 21.12 30.16 18 24 18zm0 12c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4z">
        </path>
      </g>
      <g id="add">
        <path d="M19 13h-6v6h-2v-6H5v-2h6V5h2v6h6v2z" />
      </g>
      <g id="arrow-back">
        <path
          d="M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z">
        </path>
      </g>
      <g id="arrow-drop-up">
        <path d="M7 14l5-5 5 5z"></path>
      </g>
      <g id="arrow-drop-down">
        <path d="M7 10l5 5 5-5z"></path>
      </g>
      <g id="arrow-forward">
        <path
          d="M12 4l-1.41 1.41L16.17 11H4v2h12.17l-5.58 5.59L12 20l8-8z">
        </path>
      </g>
      <g id="arrow-right">
        <path d="M10 7l5 5-5 5z"></path>
      </g>
        <g id="bluetooth">
          <path
            d="M17.71 7.71L12 2h-1v7.59L6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 11 14.41V22h1l5.71-5.71-4.3-4.29 4.3-4.29zM13 5.83l1.88 1.88L13 9.59V5.83zm1.88 10.46L13 18.17v-3.76l1.88 1.88z">
          </path>
        </g>
        <g id="camera-alt">
          <circle cx="12" cy="12" r="3.2"></circle>
          <path
            d="M9 2L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2h-3.17L15 2H9zm3 15c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z">
          </path>
        </g>
        <g id="work">
          <path
            d="M20 6h-4V4c0-1.11-.89-2-2-2h-4c-1.11 0-2 .89-2 2v2H4c-1.11 0-1.99.89-1.99 2L2 19c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V8c0-1.11-.89-2-2-2zm-6 0h-4V4h4v2z">
          </path>
        </g>
      <g id="cancel">
        <path
          d="M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm5 13.59L15.59 17 12 13.41 8.41 17 7 15.59 10.59 12 7 8.41 8.41 7 12 10.59 15.59 7 17 8.41 13.41 12 17 15.59z">
        </path>
      </g>
      <g id="check">
        <path d="M9 16.17L4.83 12l-1.42 1.41L9 19 21 7l-1.41-1.41z"></path>
      </g>
      <g id="check-circle">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z">
        </path>
      </g>
      <g id="chevron-left">
        <path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"></path>
      </g>
      <g id="chevron-right">
        <path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"></path>
      </g>
      <g id="clear">
        <path
          d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z">
        </path>
      </g>
      <g id="close">
        <path
          d="M19 6.41L17.59 5 12 10.59 6.41 5 5 6.41 10.59 12 5 17.59 6.41 19 12 13.41 17.59 19 19 17.59 13.41 12z">
        </path>
      </g>
      <g id="computer">
        <path
          d="M20 18c1.1 0 1.99-.9 1.99-2L22 6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2H0v2h24v-2h-4zM4 6h16v10H4V6z">
        </path>
      </g>
      <g id="create">
        <path
          d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z">
        </path>
      </g>
      <g id="delete">
        <path
          d="M6 19c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V7H6v12zM19 4h-3.5l-1-1h-5l-1 1H5v2h14V4z">
        </path>
      </g>
      <g id="domain">
        <path
          d="M12 7V3H2v18h20V7H12zM6 19H4v-2h2v2zm0-4H4v-2h2v2zm0-4H4V9h2v2zm0-4H4V5h2v2zm4 12H8v-2h2v2zm0-4H8v-2h2v2zm0-4H8V9h2v2zm0-4H8V5h2v2zm10 12h-8v-2h2v-2h-2v-2h2v-2h-2V9h8v10zm-2-8h-2v2h2v-2zm0 4h-2v2h2v-2z">
        </path>
      </g>
      <g id="error">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z">
        </path>
      </g>
      <g id="error-outline">
        <path
          d="M11 15h2v2h-2zm0-8h2v6h-2zm.99-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z">
        </path>
      </g>
      <g id="expand-less">
        <path d="M12 8l-6 6 1.41 1.41L12 10.83l4.59 4.58L18 14z"></path>
      </g>
      <g id="expand-more">
        <path d="M16.59 8.59L12 13.17 7.41 8.59 6 10l6 6 6-6z"></path>
      </g>
      <g id="extension">
        <path
          d="M20.5 11H19V7c0-1.1-.9-2-2-2h-4V3.5C13 2.12 11.88 1 10.5 1S8 2.12 8 3.5V5H4c-1.1 0-1.99.9-1.99 2v3.8H3.5c1.49 0 2.7 1.21 2.7 2.7s-1.21 2.7-2.7 2.7H2V20c0 1.1.9 2 2 2h3.8v-1.5c0-1.49 1.21-2.7 2.7-2.7 1.49 0 2.7 1.21 2.7 2.7V22H17c1.1 0 2-.9 2-2v-4h1.5c1.38 0 2.5-1.12 2.5-2.5S21.88 11 20.5 11z">
        </path>
      </g>
      <g id="file-download">
        <path d="M19 9h-4V3H9v6H5l7 7 7-7zM5 18v2h14v-2H5z"></path>
      </g>
        <g id="folder-filled">
          <path
            d="M10 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2h-8l-2-2z">
          </path>
        </g>
      <g id="fullscreen">
        <path
          d="M7 14H5v5h5v-2H7v-3zm-2-4h2V7h3V5H5v5zm12 7h-3v2h5v-5h-2v3zM14 5v2h3v3h2V5h-5z">
        </path>
      </g>
      <g id="group">
        <path
          d="M16 11c1.66 0 2.99-1.34 2.99-3S17.66 5 16 5c-1.66 0-3 1.34-3 3s1.34 3 3 3zm-8 0c1.66 0 2.99-1.34 2.99-3S9.66 5 8 5C6.34 5 5 6.34 5 8s1.34 3 3 3zm0 2c-2.33 0-7 1.17-7 3.5V19h14v-2.5c0-2.33-4.67-3.5-7-3.5zm8 0c-.29 0-.62.02-.97.05 1.16.84 1.97 1.97 1.97 3.45V19h6v-2.5c0-2.33-4.67-3.5-7-3.5z">
        </path>
      </g>
      <g id="help-outline">
        <path
          d="M11 18h2v-2h-2v2zm1-16C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-14c-2.21 0-4 1.79-4 4h2c0-1.1.9-2 2-2s2 .9 2 2c0 2-3 1.75-3 5h2c0-2.25 3-2.5 3-5 0-2.21-1.79-4-4-4z">
        </path>
      </g>
      <g id="history">
        <path
          d="M12.945312 22.75 C 10.320312 22.75 8.074219 21.839844 6.207031 20.019531 C 4.335938 18.199219 3.359375 15.972656 3.269531 13.34375 L 5.089844 13.34375 C 5.175781 15.472656 5.972656 17.273438 7.480469 18.742188 C 8.988281 20.210938 10.808594 20.945312 12.945312 20.945312 C 15.179688 20.945312 17.070312 20.164062 18.621094 18.601562 C 20.167969 17.039062 20.945312 15.144531 20.945312 12.910156 C 20.945312 10.714844 20.164062 8.855469 18.601562 7.335938 C 17.039062 5.816406 15.15625 5.054688 12.945312 5.054688 C 11.710938 5.054688 10.554688 5.339844 9.480469 5.902344 C 8.402344 6.46875 7.476562 7.226562 6.699219 8.179688 L 9.585938 8.179688 L 9.585938 9.984375 L 3.648438 9.984375 L 3.648438 4.0625 L 5.453125 4.0625 L 5.453125 6.824219 C 6.386719 5.707031 7.503906 4.828125 8.804688 4.199219 C 10.109375 3.566406 11.488281 3.25 12.945312 3.25 C 14.300781 3.25 15.570312 3.503906 16.761719 4.011719 C 17.949219 4.519531 18.988281 5.214844 19.875 6.089844 C 20.761719 6.964844 21.464844 7.992188 21.976562 9.167969 C 22.492188 10.34375 22.75 11.609375 22.75 12.964844 C 22.75 14.316406 22.492188 15.589844 21.976562 16.777344 C 21.464844 17.964844 20.761719 19.003906 19.875 19.882812 C 18.988281 20.765625 17.949219 21.464844 16.761719 21.976562 C 15.570312 22.492188 14.300781 22.75 12.945312 22.75 Z M 16.269531 17.460938 L 12.117188 13.34375 L 12.117188 7.527344 L 13.921875 7.527344 L 13.921875 12.601562 L 17.550781 16.179688 Z M 16.269531 17.460938">
        </path>
      </g>
      <g id="info">
        <path
          d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z">
        </path>
      </g>
      <g id="info-outline">
        <path
          d="M11 17h2v-6h-2v6zm1-15C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zM11 9h2V7h-2v2z">
        </path>
      </g>
      <g id="insert-drive-file">
        <path
          d="M6 2c-1.1 0-1.99.9-1.99 2L4 20c0 1.1.89 2 1.99 2H18c1.1 0 2-.9 2-2V8l-6-6H6zm7 7V3.5L18.5 9H13z">
        </path>
      </g>
      <g id="location-on">
        <path
          d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z">
        </path>
      </g>
      <g id="mic">
        <path
          d="M12 14c1.66 0 2.99-1.34 2.99-3L15 5c0-1.66-1.34-3-3-3S9 3.34 9 5v6c0 1.66 1.34 3 3 3zm5.3-3c0 3-2.54 5.1-5.3 5.1S6.7 14 6.7 11H5c0 3.41 2.72 6.23 6 6.72V21h2v-3.28c3.28-.48 6-3.3 6-6.72h-1.7z">
        </path>
      </g>
      <g id="more-vert">
        <path
          d="M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z">
        </path>
      </g>
      <g id="open-in-new">
        <path
          d="M19 19H5V5h7V3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2v-7h-2v7zM14 3v2h3.59l-9.83 9.83 1.41 1.41L19 6.41V10h2V3h-7z">
        </path>
      </g>
      <g id="person">
        <path
          d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z">
        </path>
      </g>
      <g id="phonelink">
        <path
          d="M4 6h18V4H4c-1.1 0-2 .9-2 2v11H0v3h14v-3H4V6zm19 2h-6c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h6c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1zm-1 9h-4v-7h4v7z">
        </path>
      </g>
      <g id="print">
        <path
          d="M19 8H5c-1.66 0-3 1.34-3 3v6h4v4h12v-4h4v-6c0-1.66-1.34-3-3-3zm-3 11H8v-5h8v5zm3-7c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-1-9H6v4h12V3z">
        </path>
      </g>
      <g id="schedule">
        <path
          d="M11.99 2C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm.5-13H11v6l5.25 3.15.75-1.23-4.5-2.67z">
        </path>
      </g>
      <g id="search">
        <path
          d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z">
        </path>
      </g>
      <g id="security">
        <path
          d="M12 1L3 5v6c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V5l-9-4zm0 10.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z">
        </path>
      </g>
        <g id="sim-card-alert">
          <path
            d="M18 2h-8L4.02 8 4 20c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-5 15h-2v-2h2v2zm0-4h-2V8h2v5z">
          </path>
        </g>
        <g id="sim-lock">
          <path
            d="M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zm-6 9c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm3.1-9H8.9V6c0-1.71 1.39-3.1 3.1-3.1 1.71 0 3.1 1.39 3.1 3.1v2z">
          </path>
        </g>
        <g id="sms-connect">
          <path
            d="M20,2C21.1,2 22,2.9 22,4L22,16C22,17.1 21.1,18 20,18L6,18L2,22L2.01,4C2.01,2.9 2.9,2 4,2L20,2ZM8,8L4,12L8,16L8,13L14,13L14,11L8,11L8,8ZM19.666,7.872L16.038,4.372L16.038,6.997L10,6.997L10,9L16.038,9L16.038,11.372L19.666,7.872Z">
          </path>
        </g>
      <!-- The <g> IDs are exposed as global variables in Vulcanized mode, which
        conflicts with the "settings" namespace of MD Settings. Using an "_icon"
        suffix prevents the naming conflict. -->
      <g id="settings_icon">
        <path
          d="M19.43 12.98c.04-.32.07-.64.07-.98s-.03-.66-.07-.98l2.11-1.65c.19-.15.24-.42.12-.64l-2-3.46c-.12-.22-.39-.3-.61-.22l-2.49 1c-.52-.4-1.08-.73-1.69-.98l-.38-2.65C14.46 2.18 14.25 2 14 2h-4c-.25 0-.46.18-.49.42l-.38 2.65c-.61.25-1.17.59-1.69.98l-2.49-1c-.23-.09-.49 0-.61.22l-2 3.46c-.13.22-.07.49.12.64l2.11 1.65c-.04.32-.07.65-.07.98s.03.66.07.98l-2.11 1.65c-.19.15-.24.42-.12.64l2 3.46c.12.22.39.3.61.22l2.49-1c.52.4 1.08.73 1.69.98l.38 2.65c.03.24.24.42.49.42h4c.25 0 .46-.18.49-.42l.38-2.65c.61-.25 1.17-.59 1.69-.98l2.49 1c.23.09.49 0 .61-.22l2-3.46c.12-.22.07-.49-.12-.64l-2.11-1.65zM12 15.5c-1.93 0-3.5-1.57-3.5-3.5s1.57-3.5 3.5-3.5 3.5 1.57 3.5 3.5-1.57 3.5-3.5 3.5z">
        </path>
      </g>
      <g id="star">
        <path
          d="M12 17.27L18.18 21l-1.64-7.03L22 9.24l-7.19-.61L12 2 9.19 8.63 2 9.24l5.46 4.73L5.82 21z">
        </path>
      </g>
      <g id="sync">
        <path
          d="M12 4V1L8 5l4 4V6c3.31 0 6 2.69 6 6 0 1.01-.25 1.97-.7 2.8l1.46 1.46C19.54 15.03 20 13.57 20 12c0-4.42-3.58-8-8-8zm0 14c-3.31 0-6-2.69-6-6 0-1.01.25-1.97.7-2.8L5.24 7.74C4.46 8.97 4 10.43 4 12c0 4.42 3.58 8 8 8v3l4-4-4-4v3z">
        </path>
      </g>
      <g id="thumbs-down">
        <path
            d="M6 3h11v13l-7 7-1.25-1.25a1.454 1.454 0 0 1-.3-.475c-.067-.2-.1-.392-.1-.575v-.35L9.45 16H3c-.533 0-1-.2-1.4-.6-.4-.4-.6-.867-.6-1.4v-2c0-.117.017-.242.05-.375s.067-.258.1-.375l3-7.05c.15-.333.4-.617.75-.85C5.25 3.117 5.617 3 6 3Zm9 2H6l-3 7v2h9l-1.35 5.5L15 15.15V5Zm0 10.15V5v10.15Zm2 .85v-2h3V5h-3V3h5v13h-5Z">
        </path>
      </g>
      <g id="thumbs-down-filled">
        <path
            d="M6 3h10v13l-7 7-1.25-1.25a1.336 1.336 0 0 1-.29-.477 1.66 1.66 0 0 1-.108-.574v-.347L8.449 16H3c-.535 0-1-.2-1.398-.602C1.199 15 1 14.535 1 14v-2c0-.117.012-.242.04-.375.022-.133.062-.258.108-.375l3-7.05c.153-.333.403-.618.75-.848A1.957 1.957 0 0 1 6 3Zm12 13V3h4v13Zm0 0">
        </path>
      </g>
      <g id="thumbs-up">
        <path
            d="M18 21H7V8l7-7 1.25 1.25c.117.117.208.275.275.475.083.2.125.392.125.575v.35L14.55 8H21c.533 0 1 .2 1.4.6.4.4.6.867.6 1.4v2c0 .117-.017.242-.05.375s-.067.258-.1.375l-3 7.05c-.15.333-.4.617-.75.85-.35.233-.717.35-1.1.35Zm-9-2h9l3-7v-2h-9l1.35-5.5L9 8.85V19ZM9 8.85V19 8.85ZM7 8v2H4v9h3v2H2V8h5Z">
        </path>
      </g>
      <g id="thumbs-up-filled">
        <path
            d="M18 21H8V8l7-7 1.25 1.25c.117.117.21.273.29.477.073.199.108.39.108.574v.347L15.551 8H21c.535 0 1 .2 1.398.602C22.801 9 23 9.465 23 10v2c0 .117-.012.242-.04.375a1.897 1.897 0 0 1-.108.375l-3 7.05a2.037 2.037 0 0 1-.75.848A1.957 1.957 0 0 1 18 21ZM6 8v13H2V8Zm0 0">
      </g>
      <g id="videocam">
        <path
          d="M17 10.5V7c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h12c.55 0 1-.45 1-1v-3.5l4 4v-11l-4 4z">
        </path>
      </g>
      <g id="warning">
        <path d="M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z"></path>
      </g>
    </defs>
  </svg>
</iron-iconset-svg>
`;
document.head.appendChild(template$3.content);

/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/

/**
Material design:
[Tooltips](https://www.google.com/design/spec/components/tooltips.html)
`<paper-tooltip>` is a label that appears on hover and focus when the user
hovers over an element with the cursor or with the keyboard. It will be centered
to an anchor element specified in the `for` attribute, or, if that doesn't
exist, centered to the parent node containing it.
Example:
    <div style="display:inline-block">
      <button>Click me!</button>
      <paper-tooltip>Tooltip text</paper-tooltip>
    </div>
    <div>
      <button id="btn">Click me!</button>
      <paper-tooltip for="btn">Tooltip text</paper-tooltip>
    </div>
The tooltip can be positioned on the top|bottom|left|right of the anchor using
the `position` attribute. The default position is bottom.
    <paper-tooltip for="btn" position="left">Tooltip text</paper-tooltip>
    <paper-tooltip for="btn" position="top">Tooltip text</paper-tooltip>

### Styling
The following custom properties and mixins are available for styling:
Custom property | Description | Default
----------------|-------------|----------
`--paper-tooltip-background` | The background color of the tooltip | `#616161`
`--paper-tooltip-opacity` | The opacity of the tooltip | `0.9`
`--paper-tooltip-text-color` | The text color of the tooltip | `white`
`--paper-tooltip-delay-in` | Delay before tooltip starts to fade in | `500`
`--paper-tooltip-delay-out` | Delay before tooltip starts to fade out | `0`
`--paper-tooltip-duration-in` | Timing for animation when showing tooltip | `500`
`--paper-tooltip-duration-out` | Timing for animation when hiding tooltip | `0`

Also prefer using the exposed CSS part as follows where possible
paper-tooltip::part(tooltip) {...}

@group Paper Elements
@element paper-tooltip
@demo demo/index.html
*/
Polymer({
  _template: html`
    <style>
      :host {
        display: block;
        position: absolute;
        outline: none;
        z-index: 1002;
        user-select: none;
        cursor: default;
      }

      #tooltip {
        display: block;
        outline: none;
        font-size: 10px;
        line-height: 1;
        background-color: var(--paper-tooltip-background, #616161);
        color: var(--paper-tooltip-text-color, white);
        padding: 8px;
        border-radius: 2px;
      }

      @keyframes keyFrameScaleUp {
        0% {
          transform: scale(0.0);
        }
        100% {
          transform: scale(1.0);
        }
      }

      @keyframes keyFrameScaleDown {
        0% {
          transform: scale(1.0);
        }
        100% {
          transform: scale(0.0);
        }
      }

      @keyframes keyFrameFadeInOpacity {
        0% {
          opacity: 0;
        }
        100% {
          opacity: var(--paper-tooltip-opacity, 0.9);
        }
      }

      @keyframes keyFrameFadeOutOpacity {
        0% {
          opacity: var(--paper-tooltip-opacity, 0.9);
        }
        100% {
          opacity: 0;
        }
      }

      @keyframes keyFrameSlideDownIn {
        0% {
          transform: translateY(-2000px);
          opacity: 0;
        }
        10% {
          opacity: 0.2;
        }
        100% {
          transform: translateY(0);
          opacity: var(--paper-tooltip-opacity, 0.9);
        }
      }

      @keyframes keyFrameSlideDownOut {
        0% {
          transform: translateY(0);
          opacity: var(--paper-tooltip-opacity, 0.9);
        }
        10% {
          opacity: 0.2;
        }
        100% {
          transform: translateY(-2000px);
          opacity: 0;
        }
      }

      .fade-in-animation {
        opacity: 0;
        animation-delay: var(--paper-tooltip-delay-in, 500ms);
        animation-name: keyFrameFadeInOpacity;
        animation-iteration-count: 1;
        animation-timing-function: ease-in;
        animation-duration: var(--paper-tooltip-duration-in, 500ms);
        animation-fill-mode: forwards;
      }

      .fade-out-animation {
        opacity: var(--paper-tooltip-opacity, 0.9);
        animation-delay: var(--paper-tooltip-delay-out, 0ms);
        animation-name: keyFrameFadeOutOpacity;
        animation-iteration-count: 1;
        animation-timing-function: ease-in;
        animation-duration: var(--paper-tooltip-duration-out, 500ms);
        animation-fill-mode: forwards;
      }

      .scale-up-animation {
        transform: scale(0);
        opacity: var(--paper-tooltip-opacity, 0.9);
        animation-delay: var(--paper-tooltip-delay-in, 500ms);
        animation-name: keyFrameScaleUp;
        animation-iteration-count: 1;
        animation-timing-function: ease-in;
        animation-duration: var(--paper-tooltip-duration-in, 500ms);
        animation-fill-mode: forwards;
      }

      .scale-down-animation {
        transform: scale(1);
        opacity: var(--paper-tooltip-opacity, 0.9);
        animation-delay: var(--paper-tooltip-delay-out, 500ms);
        animation-name: keyFrameScaleDown;
        animation-iteration-count: 1;
        animation-timing-function: ease-in;
        animation-duration: var(--paper-tooltip-duration-out, 500ms);
        animation-fill-mode: forwards;
      }

      .slide-down-animation {
        transform: translateY(-2000px);
        opacity: 0;
        animation-delay: var(--paper-tooltip-delay-out, 500ms);
        animation-name: keyFrameSlideDownIn;
        animation-iteration-count: 1;
        animation-timing-function: cubic-bezier(0.0, 0.0, 0.2, 1);
        animation-duration: var(--paper-tooltip-duration-out, 500ms);
        animation-fill-mode: forwards;
      }

      .slide-down-animation-out {
        transform: translateY(0);
        opacity: var(--paper-tooltip-opacity, 0.9);
        animation-delay: var(--paper-tooltip-delay-out, 500ms);
        animation-name: keyFrameSlideDownOut;
        animation-iteration-count: 1;
        animation-timing-function: cubic-bezier(0.4, 0.0, 1, 1);
        animation-duration: var(--paper-tooltip-duration-out, 500ms);
        animation-fill-mode: forwards;
      }

      .cancel-animation {
        animation-delay: -30s !important;
      }

      /* Thanks IE 10. */

      .hidden {
        display: none !important;
      }
    </style>

    <div id="tooltip" class="hidden" part="tooltip">
      <slot></slot>
    </div>
`,

  is: 'paper-tooltip',
  hostAttributes: {role: 'tooltip', tabindex: -1},

  properties: {
    /**
     * The id of the element that the tooltip is anchored to. This element
     * must be a sibling of the tooltip. If this property is not set,
     * then the tooltip will be centered to the parent node containing it.
     */
    for: {type: String, observer: '_findTarget'},
    /**
     * Set this to true if you want to manually control when the tooltip
     * is shown or hidden.
     */
    manualMode: {type: Boolean, value: false, observer: '_manualModeChanged'},
    /**
     * Positions the tooltip to the top, right, bottom, left of its content.
     */
    position: {type: String, value: 'bottom'},
    /**
     * If true, no parts of the tooltip will ever be shown offscreen.
     */
    fitToVisibleBounds: {type: Boolean, value: false},
    /**
     * The spacing between the top of the tooltip and the element it is
     * anchored to.
     */
    offset: {type: Number, value: 14},
    /**
     * This property is deprecated, but left over so that it doesn't
     * break exiting code. Please use `offset` instead. If both `offset` and
     * `marginTop` are provided, `marginTop` will be ignored.
     * @deprecated since version 1.0.3
     */
    marginTop: {type: Number, value: 14},
    /**
     * The delay that will be applied before the `entry` animation is
     * played when showing the tooltip.
     */
    animationDelay: {type: Number, value: 500, observer: '_delayChange'},
    /**
     * The animation that will be played on entry.  This replaces the
     * deprecated animationConfig.  Entries here will override the
     * animationConfig settings.  You can enter your own animation
     * by setting it to the css class name.
     */
    animationEntry: {type: String, value: ''},
    /**
     * The animation that will be played on exit.  This replaces the
     * deprecated animationConfig.  Entries here will override the
     * animationConfig settings.  You can enter your own animation
     * by setting it to the css class name.
     */
    animationExit: {type: String, value: ''},
    /**
     * This property is deprecated.
     * The entry and exit animations that will be played when showing
     * and hiding the tooltip. If you want to override this, you must ensure
     * that your animationConfig has the exact format below.
     * @deprecated since version
     *
     * The entry and exit animations that will be played when showing and
     * hiding the tooltip. If you want to override this, you must ensure
     * that your animationConfig has the exact format below.
     */
    animationConfig: {
      type: Object,
      value: function() {
        return {
          'entry':
              [{name: 'fade-in-animation', node: this, timing: {delay: 0}}],
              'exit': [{name: 'fade-out-animation', node: this}]
        }
      }
    },
    _showing: {type: Boolean, value: false}
  },

  listeners: {
    'webkitAnimationEnd': '_onAnimationEnd',
  },

  /**
   * Returns the target element that this tooltip is anchored to. It is
   * either the element given by the `for` attribute, the element manually
   * specified through the `target` attribute, or the immediate parent of
   * the tooltip.
   *
   * @type {Node}
   */
  get target() {
    if (this._manualTarget)
      return this._manualTarget;

    var parentNode = dom(this).parentNode;
    // If the parentNode is a document fragment, then we need to use the host.
    var ownerRoot = dom(this).getOwnerRoot();
    var target;
    if (this.for) {
      target = dom(ownerRoot).querySelector('#' + this.for);
    } else {
      target = parentNode.nodeType == Node.DOCUMENT_FRAGMENT_NODE ?
          ownerRoot.host :
          parentNode;
    }
    return target;
  },

  /**
   * Sets the target element that this tooltip will be anchored to.
   * @param {Node} target
   */
  set target(target) {
    this._manualTarget = target;
    this._findTarget();
  },

  /**
   * @return {void}
   */
  attached: function() {
    this._findTarget();
  },

  /**
   * @return {void}
   */
  detached: function() {
    if (!this.manualMode)
      this._removeListeners();
  },

  /**
   * Replaces Neon-Animation playAnimation - just calls show and hide.
   * @deprecated Use show and hide instead.
   * @param {string} type Either `entry` or `exit`
   */
  playAnimation: function(type) {
    if (type === 'entry') {
      this.show();
    } else if (type === 'exit') {
      this.hide();
    }
  },

  /**
   * Cancels the animation and either fully shows or fully hides tooltip
   */
  cancelAnimation: function() {
    // Short-cut and cancel all animations and hide
    this.$.tooltip.classList.add('cancel-animation');
  },

  /**
   * Shows the tooltip programatically
   * @return {void}
   */
  show: function() {
    // If the tooltip is already showing, there's nothing to do.
    if (this._showing)
      return;

    if (dom(this).textContent.trim() === '') {
      // Check if effective children are also empty
      var allChildrenEmpty = true;
      var effectiveChildren = dom(this).getEffectiveChildNodes();
      for (var i = 0; i < effectiveChildren.length; i++) {
        if (effectiveChildren[i].textContent.trim() !== '') {
          allChildrenEmpty = false;
          break;
        }
      }
      if (allChildrenEmpty) {
        return;
      }
    }

    this._showing = true;
    this.$.tooltip.classList.remove('hidden');
    this.$.tooltip.classList.remove('cancel-animation');
    this.$.tooltip.classList.remove(this._getAnimationType('exit'));
    this.updatePosition();
    this._animationPlaying = true;
    this.$.tooltip.classList.add(this._getAnimationType('entry'));
  },

  /**
   * Hides the tooltip programatically
   * @return {void}
   */
  hide: function() {
    // If the tooltip is already hidden, there's nothing to do.
    if (!this._showing) {
      return;
    }

    // If the entry animation is still playing, don't try to play the exit
    // animation since this will reset the opacity to 1. Just end the animation.
    if (this._animationPlaying) {
      this._showing = false;
      this._cancelAnimation();
      return;
    } else {
      // Play Exit Animation
      this._onAnimationFinish();
    }

    this._showing = false;
    this._animationPlaying = true;
  },

  /**
   * @return {void}
   */
  updatePosition: function() {
    if (!this._target)
      return;
    var offsetParent = this._composedOffsetParent();
    if (!offsetParent)
      return;
    var offset = this.offset;
    // If a marginTop has been provided by the user (pre 1.0.3), use it.
    if (this.marginTop != 14 && this.offset == 14)
      offset = this.marginTop;
    var parentRect = offsetParent.getBoundingClientRect();
    var targetRect = this._target.getBoundingClientRect();
    var thisRect = this.getBoundingClientRect();
    var horizontalCenterOffset = (targetRect.width - thisRect.width) / 2;
    var verticalCenterOffset = (targetRect.height - thisRect.height) / 2;
    var targetLeft = targetRect.left - parentRect.left;
    var targetTop = targetRect.top - parentRect.top;
    var tooltipLeft, tooltipTop;
    switch (this.position) {
      case 'top':
        tooltipLeft = targetLeft + horizontalCenterOffset;
        tooltipTop = targetTop - thisRect.height - offset;
        break;
      case 'bottom':
        tooltipLeft = targetLeft + horizontalCenterOffset;
        tooltipTop = targetTop + targetRect.height + offset;
        break;
      case 'left':
        tooltipLeft = targetLeft - thisRect.width - offset;
        tooltipTop = targetTop + verticalCenterOffset;
        break;
      case 'right':
        tooltipLeft = targetLeft + targetRect.width + offset;
        tooltipTop = targetTop + verticalCenterOffset;
        break;
    }
    // TODO(noms): This should use IronFitBehavior if possible.
    if (this.fitToVisibleBounds) {
      // Clip the left/right side
      if (parentRect.left + tooltipLeft + thisRect.width > window.innerWidth) {
        this.style.right = '0px';
        this.style.left = 'auto';
      } else {
        this.style.left = Math.max(0, tooltipLeft) + 'px';
        this.style.right = 'auto';
      }
      // Clip the top/bottom side.
      if (parentRect.top + tooltipTop + thisRect.height > window.innerHeight) {
        this.style.bottom = (parentRect.height - targetTop + offset) + 'px';
        this.style.top = 'auto';
      } else {
        this.style.top = Math.max(-parentRect.top, tooltipTop) + 'px';
        this.style.bottom = 'auto';
      }
    } else {
      this.style.left = tooltipLeft + 'px';
      this.style.top = tooltipTop + 'px';
    }
  },

  _addListeners: function() {
    if (this._target) {
      this.listen(this._target, 'mouseenter', 'show');
      this.listen(this._target, 'focus', 'show');
      this.listen(this._target, 'mouseleave', 'hide');
      this.listen(this._target, 'blur', 'hide');
      this.listen(this._target, 'tap', 'hide');
    }
    this.listen(this.$.tooltip, 'animationend', '_onAnimationEnd');
    this.listen(this, 'mouseenter', 'hide');
  },

  _findTarget: function() {
    if (!this.manualMode)
      this._removeListeners();
    this._target = this.target;
    if (!this.manualMode)
      this._addListeners();
  },

  _delayChange: function(newValue) {
    // Only Update delay if different value set
    if (newValue !== 500) {
      this.updateStyles({'--paper-tooltip-delay-in': newValue + 'ms'});
    }
  },

  _manualModeChanged: function() {
    if (this.manualMode)
      this._removeListeners();
    else
      this._addListeners();
  },

  _cancelAnimation: function() {
    // Short-cut and cancel all animations and hide
    this.$.tooltip.classList.remove(this._getAnimationType('entry'));
    this.$.tooltip.classList.remove(this._getAnimationType('exit'));
    this.$.tooltip.classList.remove('cancel-animation');
    this.$.tooltip.classList.add('hidden');
  },

  _onAnimationFinish: function() {
    if (this._showing) {
      this.$.tooltip.classList.remove(this._getAnimationType('entry'));
      this.$.tooltip.classList.remove('cancel-animation');
      this.$.tooltip.classList.add(this._getAnimationType('exit'));
    }
  },

  _onAnimationEnd: function() {
    // If no longer showing add class hidden to completely hide tooltip
    this._animationPlaying = false;
    if (!this._showing) {
      this.$.tooltip.classList.remove(this._getAnimationType('exit'));
      this.$.tooltip.classList.add('hidden');
    }
  },

  _getAnimationType: function(type) {
    // These properties have priority over animationConfig values
    if ((type === 'entry') && (this.animationEntry !== '')) {
      return this.animationEntry;
    }
    if ((type === 'exit') && (this.animationExit !== '')) {
      return this.animationExit;
    }
    // If no results then return the legacy value from animationConfig
    if (this.animationConfig[type] &&
        typeof this.animationConfig[type][0].name === 'string') {
      // Checking Timing and Update if necessary - Legacy for animationConfig
      if (this.animationConfig[type][0].timing &&
          this.animationConfig[type][0].timing.delay &&
          this.animationConfig[type][0].timing.delay !== 0) {
        var timingDelay = this.animationConfig[type][0].timing.delay;
        // Has Timing Change - Update CSS
        if (type === 'entry') {
          this.updateStyles({'--paper-tooltip-delay-in': timingDelay + 'ms'});
        } else if (type === 'exit') {
          this.updateStyles({'--paper-tooltip-delay-out': timingDelay + 'ms'});
        }
      }
      return this.animationConfig[type][0].name;
    }
  },

  _removeListeners: function() {
    if (this._target) {
      this.unlisten(this._target, 'mouseenter', 'show');
      this.unlisten(this._target, 'focus', 'show');
      this.unlisten(this._target, 'mouseleave', 'hide');
      this.unlisten(this._target, 'blur', 'hide');
      this.unlisten(this._target, 'tap', 'hide');
    }
    this.unlisten(this.$.tooltip, 'animationend', '_onAnimationEnd');
    this.unlisten(this, 'mouseenter', 'hide');
  },

  /**
   * Polyfills the old offsetParent behavior from before the spec was changed:
   * https://github.com/w3c/csswg-drafts/issues/159
   */
  _composedOffsetParent: function() {
    // Do an initial walk to check for display:none ancestors.
    for (let ancestor = this; ancestor; ancestor = flatTreeParent(ancestor)) {
      if (!(ancestor instanceof Element))
        continue;
      if (getComputedStyle(ancestor).display === 'none')
        return null;
    }

    for (let ancestor = flatTreeParent(this); ancestor; ancestor = flatTreeParent(ancestor)) {
      if (!(ancestor instanceof Element))
        continue;
      const style = getComputedStyle(ancestor);
      if (style.display === 'contents') {
        // display:contents nodes aren't in the layout tree so they should be skipped.
        continue;
      }
      if (style.position !== 'static') {
        return ancestor;
      }
      if (ancestor.tagName === 'BODY')
        return ancestor;
    }
    return null;

    function flatTreeParent(element) {
      if (element.assignedSlot) {
        return element.assignedSlot;
      }
      if (element.parentNode instanceof ShadowRoot) {
        return element.parentNode.host;
      }
      return element.parentNode;
    }
  }
});

function getTemplate$Z() {
    return html `<!--_html_template_start_--><style include="cr-shared-style">:host{--cr-link-color:var(--cros-tooltip-link-color);--cr-tooltip-icon-fill-color:var(--cros-sys-on_surface_variant);display:flex}iron-icon{--iron-icon-fill-color:var(--cr-tooltip-icon-fill-color);--iron-icon-height:var(--cr-icon-size);--iron-icon-width:var(--cr-icon-size)}#tooltip{--paper-tooltip-background:var(--cros-tooltip-background-color);--paper-tooltip-border-radius:4px;--paper-tooltip-padding:5px 8px;--paper-tooltip-text-color:var(--cros-tooltip-label-color);font:var(--cros-annotation-1-font)}</style>
<iron-icon id="indicator" tabindex="0" aria-label$="[[iconAriaLabel]]"
    aria-describedby="tooltip" icon="[[iconClass]]" role="img">
</iron-icon>
<paper-tooltip id="tooltip"
    for="indicator" position="[[tooltipPosition]]"
    fit-to-visible-bounds part="tooltip" aria-hidden="true">
  <slot name="tooltip-text">[[tooltipText]]</slot>
</paper-tooltip>
<!--_html_template_end_-->`;
}

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Forked from ui/webui/resources/cr_elements/policy/cr_tooltip_icon.ts
class CrTooltipIconElement extends PolymerElement {
    static get is() {
        return 'cr-tooltip-icon';
    }
    static get template() {
        return getTemplate$Z();
    }
    static get properties() {
        return {
            iconAriaLabel: String,
            iconClass: String,
            tooltipText: String,
            /** Position of tooltip popup related to the icon. */
            tooltipPosition: {
                type: String,
                value: 'top',
            },
        };
    }
    getFocusableElement() {
        return this.$.indicator;
    }
}
customElements.define(CrTooltipIconElement.is, CrTooltipIconElement);

function getTemplate$Y() {
    return html `<!--_html_template_start_--><style include="cr-hidden-style"></style>
<cr-tooltip-icon hidden$="[[!indicatorVisible]]"
    tooltip-text="[[indicatorTooltip_]]" icon-class="[[indicatorIcon]]"
    icon-aria-label="[[iconAriaLabel]]">
</cr-tooltip-icon>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Mixin for policy controlled indicators.
 * TODO(michaelpg): Since extensions can also control settings and be indicated,
 * rework the "policy" naming scheme throughout this directory.
 * Forked from
 * ui/webui/resources/cr_elements/policy/cr_policy_indicator_mixin.ts
 */
/**
 * Possible policy indicators that can be shown in settings.
 */
var CrPolicyIndicatorType;
(function (CrPolicyIndicatorType) {
    CrPolicyIndicatorType["DEVICE_POLICY"] = "devicePolicy";
    CrPolicyIndicatorType["EXTENSION"] = "extension";
    CrPolicyIndicatorType["NONE"] = "none";
    CrPolicyIndicatorType["OWNER"] = "owner";
    CrPolicyIndicatorType["PRIMARY_USER"] = "primary_user";
    CrPolicyIndicatorType["RECOMMENDED"] = "recommended";
    CrPolicyIndicatorType["USER_POLICY"] = "userPolicy";
    CrPolicyIndicatorType["PARENT"] = "parent";
    CrPolicyIndicatorType["CHILD_RESTRICTION"] = "childRestriction";
})(CrPolicyIndicatorType || (CrPolicyIndicatorType = {}));
const CrPolicyIndicatorMixin = dedupingMixin((superClass) => {
    class CrPolicyIndicatorMixin extends superClass {
        // Properties exposed to all policy indicators.
        static get properties() {
            return {
                /**
                 * Which indicator type to show (or NONE).
                 */
                indicatorType: {
                    type: String,
                    value: CrPolicyIndicatorType.NONE,
                },
                /**
                 * The name associated with the policy source. See
                 * chrome.settingsPrivate.PrefObject.controlledByName.
                 */
                indicatorSourceName: {
                    type: String,
                    value: '',
                },
                // Computed properties based on indicatorType and
                // indicatorSourceName. Override to provide different values.
                indicatorVisible: {
                    type: Boolean,
                    computed: 'getIndicatorVisible_(indicatorType)',
                },
                indicatorIcon: {
                    type: String,
                    computed: 'getIndicatorIcon_(indicatorType)',
                },
            };
        }
        /**
         * @return True if the indicator should be shown.
         */
        getIndicatorVisible_(type) {
            return type !== CrPolicyIndicatorType.NONE;
        }
        /**
         * @return {string} The iron-icon icon name.
         */
        getIndicatorIcon_(type) {
            switch (type) {
                case CrPolicyIndicatorType.EXTENSION:
                    return 'cr:extension';
                case CrPolicyIndicatorType.NONE:
                    return '';
                case CrPolicyIndicatorType.PRIMARY_USER:
                    return 'cr:group';
                case CrPolicyIndicatorType.OWNER:
                    return 'cr:person';
                case CrPolicyIndicatorType.USER_POLICY:
                case CrPolicyIndicatorType.DEVICE_POLICY:
                case CrPolicyIndicatorType.RECOMMENDED:
                    return 'cr20:domain';
                case CrPolicyIndicatorType.PARENT:
                case CrPolicyIndicatorType.CHILD_RESTRICTION:
                    return 'cr20:kite';
                default:
                    assertNotReached();
            }
        }
        /**
         * @param name The name associated with the indicator. See
         *     chrome.settingsPrivate.PrefObject.controlledByName
         * @param matches For RECOMMENDED only, whether the indicator
         *     value matches the recommended value.
         * @return The tooltip text for |type|.
         */
        getIndicatorTooltip(type, name, matches) {
            if (!window.CrPolicyStrings) {
                return '';
            } // Tooltips may not be defined, e.g. in OOBE.
            const CrPolicyStrings = window.CrPolicyStrings;
            switch (type) {
                case CrPolicyIndicatorType.EXTENSION:
                    return name.length > 0 ?
                        CrPolicyStrings.controlledSettingExtension.replace('$1', name) :
                        CrPolicyStrings.controlledSettingExtensionWithoutName;
                case CrPolicyIndicatorType.PRIMARY_USER:
                    return CrPolicyStrings.controlledSettingShared.replace('$1', name);
                case CrPolicyIndicatorType.OWNER:
                    return name.length > 0 ?
                        CrPolicyStrings.controlledSettingWithOwner.replace('$1', name) :
                        CrPolicyStrings.controlledSettingNoOwner;
                case CrPolicyIndicatorType.USER_POLICY:
                case CrPolicyIndicatorType.DEVICE_POLICY:
                    return CrPolicyStrings.controlledSettingPolicy;
                case CrPolicyIndicatorType.RECOMMENDED:
                    return matches ?
                        CrPolicyStrings.controlledSettingRecommendedMatches :
                        CrPolicyStrings.controlledSettingRecommendedDiffers;
                case CrPolicyIndicatorType.PARENT:
                    return CrPolicyStrings.controlledSettingParent;
                case CrPolicyIndicatorType.CHILD_RESTRICTION:
                    return CrPolicyStrings.controlledSettingChildRestriction;
            }
            return '';
        }
    }
    return CrPolicyIndicatorMixin;
});

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview Polymer element for indicating policies by type.
 * Forked from
 * ui/webui/resources/cr_elements/policy/cr_policy_indicator.ts
 */
const CrPolicyIndicatorElementBase = CrPolicyIndicatorMixin(PolymerElement);
class CrPolicyIndicatorElement extends CrPolicyIndicatorElementBase {
    static get is() {
        return 'cr-policy-indicator';
    }
    static get template() {
        return getTemplate$Y();
    }
    static get properties() {
        return {
            iconAriaLabel: String,
            indicatorTooltip_: {
                type: String,
                computed: 'getIndicatorTooltip_(indicatorType, indicatorSourceName)',
            },
        };
    }
    /**
     * @param indicatorSourceName The name associated with the indicator.
     *     See chrome.settingsPrivate.PrefObject.controlledByName
     * @return The tooltip text for |type|.
     */
    getIndicatorTooltip_(indicatorType, indicatorSourceName) {
        return this.getIndicatorTooltip(indicatorType, indicatorSourceName);
    }
}
customElements.define(CrPolicyIndicatorElement.is, CrPolicyIndicatorElement);

function getTemplate$X() {
    return html `<!--_html_template_start_--><style include="common cros-button-style">cr-radio-group{width:100%}cr-radio-button{height:48px;padding:0 14px;margin:0 10px}cr-radio-button+cr-radio-button{border-top:var(--cr-separator-line)}#geolocationWarningDiv{display:flex;align-items:center;width:inherit;margin:0 10px;font:var(--cros-body-2-font);color:var(--cros-text-color-secondary)}#policyIcon{margin-inline-start:auto;margin-inline-end:10px}</style>
<div id="weatherDiv">
  <h3 id="weatherTitle" class="ambient-subpage-element-title">
    $i18n{ambientModeWeatherTitle}
  </h3>
  <template is="dom-if" if="[[shouldShowGeolocationWarningText_]]" restamp>
    <div id="geolocationWarningDiv">
      <template is="dom-if" if="[[geolocationIsUserModifiable_]]" restamp>
        <localized-link
            on-link-clicked="openGeolocationDialog_"
            localized-string="$i18n{geolocationWarningTextForWeather}">
        </localized-link>
      </template>
      <template is="dom-if" if="[[!geolocationIsUserModifiable_]]" restamp>
        $i18n{geolocationWarningManagedTextForWeather}
        <cr-policy-indicator
            id="policyIcon"
            indicator-type="userPolicy"
            title="$i18n{managedSetting}">
        </cr-policy-indicator>
      </template>
    </div>
  </template>
  <template is="dom-if" if="[[!shouldShowGeolocationWarningText_]]" restamp>
    <div class="weather-unit-list">
      <cr-radio-group
          id="ambientTemperatureUnit"
          selected="{{selectedTemperatureUnit}}"
          aria-description="$i18n{ambientModeAriaDescriptionWeather}"
          aria-labelledby="weatherTitle">
        <cr-radio-button
            name="[[temperatureUnit_.kFahrenheit]]"
            class="weather-unit-item"
            label="$i18n{ambientModeWeatherUnitFahrenheit}">
        </cr-radio-button>
        <cr-radio-button
            name="[[temperatureUnit_.kCelsius]]"
            class="weather-unit-item"
            label="$i18n{ambientModeWeatherUnitCelsius}">
        </cr-radio-button>
      </cr-radio-group>
    </div>
  </template>
</div>

<template is="dom-if" if="[[shouldShowGeolocationDialog_]]" restamp>
  <geolocation-dialog id="geolocationDialog"
      body-text-paragraph1="$i18n{systemGeolocationDialogBodyParagraph1}"
      body-text-paragraph2="$i18n{systemGeolocationDialogBodyParagraph2}"
      confirm-button-text="$i18n{systemGeolocationDialogConfirmButton}"
      cancel-button-text="$i18n{systemGeolocationDialogCancelButton}"
      on-geolocation-enabled="onGeolocationEnabled_"
      on-close="onGeolocationDialogClose_">
  </geolocation-dialog>
</template>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview This component displays a list of weather units. It
 * behaviors similar to a radio button group, e.g. single selection.
 */
class AmbientWeatherUnitElement extends WithPersonalizationStore {
    static get is() {
        return 'ambient-weather-unit';
    }
    static get template() {
        return getTemplate$X();
    }
    static get properties() {
        return {
            /**
             * Used to refer to the enum values in HTML file.
             */
            temperatureUnit_: {
                type: Object,
                value: TemperatureUnit,
            },
            selectedTemperatureUnit: {
                type: String,
                observer: 'onSelectedTemperatureUnitChanged_',
            },
            geolocationPermissionEnabled_: {
                type: Boolean,
                value: null,
            },
            geolocationIsUserModifiable_: {
                type: Boolean,
                value: null,
            },
            shouldShowGeolocationWarningText_: {
                type: Boolean,
                computed: 'computeShouldShowGeolocationWarningText_(' +
                    'geolocationPermissionEnabled_),',
                value: false,
            },
        };
    }
    connectedCallback() {
        super.connectedCallback();
        AmbientObserver.initAmbientObserverIfNeeded();
        this.watch('geolocationPermissionEnabled_', state => state.ambient.geolocationPermissionEnabled);
        this.watch('geolocationIsUserModifiable_', state => state.ambient.geolocationIsUserModifiable);
        this.updateFromStore();
        initializeData$1(getAmbientProvider(), this.getStore());
    }
    onSelectedTemperatureUnitChanged_(value) {
        const num = parseInt(value, 10);
        if (isNaN(num) ||
            !inBetween(num, TemperatureUnit.MIN_VALUE, TemperatureUnit.MAX_VALUE)) {
            console.warn('Unexpected temperature unit received', value);
            return;
        }
        setTemperatureUnit(num, getAmbientProvider(), this.getStore());
    }
    computeShouldShowGeolocationWarningText_() {
        // Warning text should be guarded with the Privacy Hub feature flag.
        return isCrosPrivacyHubLocationEnabled() &&
            this.geolocationPermissionEnabled_ === false;
    }
    openGeolocationDialog_(e) {
        // A place holder href with the value "#" is used to have a compliant link.
        // This prevents the browser from navigating the window to "#".
        e.detail.event.preventDefault();
        e.stopPropagation();
        // Geolocation Dialog only exists in the Privacy Hub context.
        if (!isCrosPrivacyHubLocationEnabled()) {
            console.error('Geolocation Dialog triggered when the Privacy Hub flag is disabled');
            return;
        }
        // Show the dialog to let users enable system location inline.
        this.shouldShowGeolocationDialog_ = true;
    }
    onGeolocationDialogClose_() {
        this.shouldShowGeolocationDialog_ = false;
    }
    // Callback for user clicking 'Allow' on the geolocation dialog.
    onGeolocationEnabled_() {
        // Enable system geolocation permission for all system services.
        enableGeolocationForSystemServices$1(this.getStore());
    }
}
customElements.define(AmbientWeatherUnitElement.is, AmbientWeatherUnitElement);

function getTemplate$W() {
    return html `<!--_html_template_start_--><style>:host{--cr-toggle-checked-bar-color:var(--google-blue-600);--cr-toggle-checked-button-color:var(--google-blue-600);--cr-toggle-checked-ripple-color:rgba(var(--google-blue-600-rgb),.2);--cr-toggle-ripple-diameter:40px;--cr-toggle-unchecked-bar-color:var(--google-grey-400);--cr-toggle-unchecked-button-color:white;--cr-toggle-unchecked-ripple-color:rgba(var(--google-grey-600-rgb),.15);-webkit-tap-highlight-color:transparent;cursor:pointer;display:block;min-width:34px;outline:none;position:relative;width:34px}:host-context([chrome-refresh-2023]):host{--cr-toggle-checked-bar-color:var(--color-toggle-button-track-on,var(--cr-fallback-color-primary));--cr-toggle-checked-button-color:var(--color-toggle-button-thumb-on,var(--cr-fallback-color-on-primary));--cr-toggle-unchecked-bar-color:var(--color-toggle-button-track-off,var(--cr-fallback-color-surface-variant));--cr-toggle-unchecked-button-color:var(--color-toggle-button-thumb-off,var(--cr-fallback-color-outline));--cr-toggle-disabled-opacity:1;--cr-toggle-checked-ripple-color:var(--cr-active-background-color);--cr-toggle-unchecked-ripple-color:var(--cr-active-background-color);--cr-toggle-ripple-diameter:20px;--cr-toggle-bar-border-color:var(--cr-toggle-unchecked-button-color);--cr-toggle-bar-border:1px solid var(--cr-toggle-bar-border-color);--cr-toggle-bar-width:26px;--cr-toggle-knob-diameter:8px;height:fit-content;isolation:isolate;min-width:initial;width:fit-content}@media (forced-colors:active){:host{forced-color-adjust:none}}@media (prefers-color-scheme:dark){:host{--cr-toggle-checked-bar-color:var(--google-blue-300);--cr-toggle-checked-button-color:var(--google-blue-300);--cr-toggle-checked-ripple-color:rgba(var(--google-blue-300-rgb),.4);--cr-toggle-unchecked-bar-color:var(--google-grey-500);--cr-toggle-unchecked-button-color:var(--google-grey-300);--cr-toggle-unchecked-ripple-color:rgba(var(--google-grey-300-rgb),.4)}}:host([dark]){--cr-toggle-checked-bar-color:var(--google-blue-300);--cr-toggle-checked-button-color:var(--google-blue-300);--cr-toggle-checked-ripple-color:rgba(var(--google-blue-300-rgb),.4);--cr-toggle-unchecked-bar-color:var(--google-grey-500);--cr-toggle-unchecked-button-color:var(--google-grey-300);--cr-toggle-unchecked-ripple-color:rgba(var(--google-grey-300-rgb),.4)}:host-context([chrome-refresh-2023]):host(:active){--cr-toggle-knob-diameter:10px}:host-context([chrome-refresh-2023]):host([checked]){--cr-toggle-bar-border-color:var(--cr-toggle-checked-bar-color);--cr-toggle-knob-diameter:12px}:host-context([chrome-refresh-2023]):host([checked]:active){--cr-toggle-knob-diameter:14px}:host([disabled]){cursor:initial;opacity:var(--cr-disabled-opacity);pointer-events:none}:host-context([chrome-refresh-2023]):host([disabled]){--cr-toggle-checked-bar-color:var(--color-toggle-button-track-on-disabled,var(--cr-fallback-color-disabled-background));--cr-toggle-checked-button-color:var(--color-toggle-button-thumb-on-disabled,var(--cr-fallback-color-surface));--cr-toggle-unchecked-bar-color:transparent;--cr-toggle-unchecked-button-color:var(--color-toggle-button-thumb-off-disabled,var(--cr-fallback-color-disabled-foreground));--cr-toggle-bar-border-color:var(--cr-toggle-unchecked-button-color);opacity:var(--cr-toggle-disabled-opacity)}:host-context([chrome-refresh-2023]):host([checked][disabled]){--cr-toggle-bar-border:none}#bar{background-color:var(--cr-toggle-unchecked-bar-color);border-radius:8px;height:12px;left:3px;position:absolute;top:2px;transition:background-color linear 80ms;width:28px;z-index:0}:host([checked]) #bar{background-color:var(--cr-toggle-checked-bar-color);opacity:var(--cr-toggle-checked-bar-opacity,0.5)}:host-context([chrome-refresh-2023]) #bar{border:var(--cr-toggle-bar-border);border-radius:50px;box-sizing:border-box;display:block;height:16px;opacity:1;position:initial;width:var(--cr-toggle-bar-width)}:host-context([chrome-refresh-2023]):host(:focus-visible) #bar{outline:2px solid var(--cr-toggle-checked-bar-color);outline-offset:2px}#knob{background-color:var(--cr-toggle-unchecked-button-color);border-radius:50%;box-shadow:var(--cr-toggle-box-shadow,0 1px 3px 0 rgba(0,0,0,.4));display:block;height:16px;position:relative;transition:transform linear 80ms,background-color linear 80ms;width:16px;z-index:1}:host([checked]) #knob{background-color:var(--cr-toggle-checked-button-color);transform:translate3d(18px,0,0)}:host-context([dir=rtl]):host([checked]) #knob{transform:translate3d(-18px,0,0)}:host-context([chrome-refresh-2023]) #knob{--cr-toggle-knob-center-edge-distance_:8px;--cr-toggle-knob-direction_:1;--cr-toggle-knob-travel-distance_:calc(0.5 * var(--cr-toggle-bar-width) - var(--cr-toggle-knob-center-edge-distance_));--cr-toggle-knob-position-center_:calc(0.5 * var(--cr-toggle-bar-width) + -50%);--cr-toggle-knob-position-start_:calc(var(--cr-toggle-knob-position-center_) - var(--cr-toggle-knob-direction_) * var(--cr-toggle-knob-travel-distance_));--cr-toggle-knob-position-end_:calc(var(--cr-toggle-knob-position-center_) + var(--cr-toggle-knob-direction_) * var(--cr-toggle-knob-travel-distance_));box-shadow:none;height:var(--cr-toggle-knob-diameter);position:absolute;top:50%;transform:translate(var(--cr-toggle-knob-position-start_),-50%);transition:transform linear 80ms,background-color linear 80ms,width linear 80ms,height linear 80ms;width:var(--cr-toggle-knob-diameter)}:host-context([dir=rtl][chrome-refresh-2023]) #knob{left:0;--cr-toggle-knob-direction_:-1}:host-context([chrome-refresh-2023]):host([checked]) #knob{transform:translate(var(--cr-toggle-knob-position-end_),-50%)}:host-context([chrome-refresh-2023]):host([checked]:active) #knob,:host-context([chrome-refresh-2023]):host([checked]:hover) #knob{--cr-toggle-checked-button-color:var(--color-toggle-button-thumb-on-hover,var(--cr-fallback-color-primary-container))}:host-context([chrome-refresh-2023]):host(:hover) #knob::before{background-color:var(--cr-hover-background-color);border-radius:50%;content:'';height:var(--cr-toggle-ripple-diameter);left:calc(var(--cr-toggle-knob-diameter) / 2);position:absolute;top:calc(var(--cr-toggle-knob-diameter) / 2);transform:translate(-50%,-50%);width:var(--cr-toggle-ripple-diameter)}paper-ripple{--paper-ripple-opacity:1;color:var(--cr-toggle-unchecked-ripple-color);height:var(--cr-toggle-ripple-diameter);left:50%;outline:var(--cr-toggle-ripple-ring,none);pointer-events:none;position:absolute;top:50%;transform:translate(-50%,-50%);transition:color linear 80ms;width:var(--cr-toggle-ripple-diameter)}:host([checked]) paper-ripple{color:var(--cr-toggle-checked-ripple-color)}:host-context([dir=rtl]) paper-ripple{left:auto;right:50%;transform:translate(50%,-50%)}</style>
<span id="bar"></span>
<span id="knob"></span>
<!--_html_template_end_-->`;
}

// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * Number of pixels required to move to consider the pointermove event as
 * intentional.
 */
const MOVE_THRESHOLD_PX = 5;
const CrToggleElementBase = PaperRippleMixin(PolymerElement);
class CrToggleElement extends CrToggleElementBase {
    constructor() {
        super(...arguments);
        this.boundPointerMove_ = null;
        /**
         * Whether the state of the toggle has already taken into account by
         * |pointeremove| handlers. Used in the 'click' handler.
         */
        this.handledInPointerMove_ = false;
        this.pointerDownX_ = 0;
    }
    static get is() {
        return 'cr-toggle';
    }
    static get template() {
        return getTemplate$W();
    }
    static get properties() {
        return {
            checked: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
                observer: 'checkedChanged_',
                notify: true,
            },
            dark: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            disabled: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
                observer: 'disabledChanged_',
            },
        };
    }
    ready() {
        super.ready();
        if (!this.hasAttribute('role')) {
            this.setAttribute('role', 'button');
        }
        if (!this.hasAttribute('tabindex')) {
            this.setAttribute('tabindex', '0');
        }
        this.setAttribute('aria-pressed', this.checked ? 'true' : 'false');
        this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
        if (!document.documentElement.hasAttribute('chrome-refresh-2023')) {
            this.addEventListener('blur', this.hideRipple_.bind(this));
            this.addEventListener('focus', this.onFocus_.bind(this));
        }
        this.addEventListener('click', this.onClick_.bind(this));
        this.addEventListener('keydown', this.onKeyDown_.bind(this));
        this.addEventListener('keyup', this.onKeyUp_.bind(this));
        this.addEventListener('pointerdown', this.onPointerDown_.bind(this));
        this.addEventListener('pointerup', this.onPointerUp_.bind(this));
    }
    connectedCallback() {
        super.connectedCallback();
        const direction = this.matches(':host-context([dir=rtl]) cr-toggle') ? -1 : 1;
        this.boundPointerMove_ = (e) => {
            // Prevent unwanted text selection to occur while moving the pointer, this
            // is important.
            e.preventDefault();
            const diff = e.clientX - this.pointerDownX_;
            if (Math.abs(diff) < MOVE_THRESHOLD_PX) {
                return;
            }
            this.handledInPointerMove_ = true;
            const shouldToggle = (diff * direction < 0 && this.checked) ||
                (diff * direction > 0 && !this.checked);
            if (shouldToggle) {
                this.toggleState_(/* fromKeyboard= */ false);
            }
        };
    }
    checkedChanged_() {
        this.setAttribute('aria-pressed', this.checked ? 'true' : 'false');
    }
    disabledChanged_() {
        this.setAttribute('tabindex', this.disabled ? '-1' : '0');
        this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
    }
    onFocus_() {
        this.getRipple().showAndHoldDown();
    }
    hideRipple_() {
        this.getRipple().clear();
    }
    onPointerUp_() {
        assert$1(this.boundPointerMove_);
        this.removeEventListener('pointermove', this.boundPointerMove_);
        this.hideRipple_();
    }
    onPointerDown_(e) {
        // Don't do anything if this was not a primary button click or touch event.
        if (e.button !== 0) {
            return;
        }
        // This is necessary to have follow up pointer events fire on |this|, even
        // if they occur outside of its bounds.
        this.setPointerCapture(e.pointerId);
        this.pointerDownX_ = e.clientX;
        this.handledInPointerMove_ = false;
        assert$1(this.boundPointerMove_);
        this.addEventListener('pointermove', this.boundPointerMove_);
    }
    onClick_(e) {
        // Prevent |click| event from bubbling. It can cause parents of this
        // elements to erroneously re-toggle this control.
        e.stopPropagation();
        e.preventDefault();
        // User gesture has already been taken care of inside |pointermove|
        // handlers, Do nothing here.
        if (this.handledInPointerMove_) {
            return;
        }
        // If no pointermove event fired, then user just clicked on the
        // toggle button and therefore it should be toggled.
        this.toggleState_(/* fromKeyboard= */ false);
    }
    toggleState_(fromKeyboard) {
        // Ignore cases where the 'click' or 'keypress' handlers are triggered while
        // disabled.
        if (this.disabled) {
            return;
        }
        if (!fromKeyboard) {
            this.hideRipple_();
        }
        this.checked = !this.checked;
        this.dispatchEvent(new CustomEvent('change', { bubbles: true, composed: true, detail: this.checked }));
    }
    onKeyDown_(e) {
        if (e.key !== ' ' && e.key !== 'Enter') {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        if (e.repeat) {
            return;
        }
        if (e.key === 'Enter') {
            this.toggleState_(/* fromKeyboard= */ true);
        }
    }
    onKeyUp_(e) {
        if (e.key !== ' ' && e.key !== 'Enter') {
            return;
        }
        e.preventDefault();
        e.stopPropagation();
        if (e.key === ' ') {
            this.toggleState_(/* fromKeyboard= */ true);
        }
    }
    // Overridden from PaperRippleMixin
    /* eslint-disable-next-line @typescript-eslint/naming-convention */
    _createRipple() {
        this._rippleContainer = this.$.knob;
        const ripple = super._createRipple();
        ripple.id = 'ink';
        ripple.setAttribute('recenters', '');
        ripple.classList.add('circle');
        return ripple;
    }
}
customElements.define(CrToggleElement.is, CrToggleElement);

function getTemplate$V() {
    return html `<!--_html_template_start_--><style include="common">#toggleRowTitle{margin:0 8px 2px 0}#toggle{margin-inline-end:8px}</style>
<h3 id="toggleRowTitle" class="ambient-subpage-element-title" aria-hidden="true">
  [[getToggleRowTitle_(ambientModeEnabled_)]]
</h3>
<div class="ambient-toggle-row-container">
  <div class="ambient-toggle-row">
    <p id="toggleDescription">$i18n{ambientModePageDescription}</p>
    <cr-toggle id="toggle" class="clickable" checked="[[ambientModeEnabled_]]"
        aria-labelledby="toggleDescription"
        on-change="onAmbientModeToggled_">
    </cr-toggle>
  </div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview This component displays a description text and a toggle button.
 */
class ToggleRowElement extends WithPersonalizationStore {
    static get is() {
        return 'toggle-row';
    }
    static get template() {
        return getTemplate$V();
    }
    static get properties() {
        return {
            ambientModeEnabled_: Boolean,
        };
    }
    focus() {
        this.$.toggle.focus();
    }
    connectedCallback() {
        super.connectedCallback();
        this.watch('ambientModeEnabled_', state => state.ambient.ambientModeEnabled);
        this.updateFromStore();
    }
    getAriaLabel_() {
        return this.i18n(this.ambientModeEnabled_ ? 'ambientModeOn' : 'ambientModeOff');
    }
    getToggleRowTitle_() {
        return this.getAriaLabel_().toUpperCase();
    }
    onAmbientModeToggled_(event) {
        const toggleButton = event.currentTarget;
        const ambientModeEnabled = toggleButton.checked;
        setAmbientModeEnabled(ambientModeEnabled, getAmbientProvider(), this.getStore());
    }
}
customElements.define(ToggleRowElement.is, ToggleRowElement);

function getTemplate$U() {
    return html `<!--_html_template_start_--><style include="common cr-shared-style cr-radio-button-style">#container{align-items:center;display:flex;flex:1;flex-flow:row nowrap;height:100%;justify-content:space-between;padding-inline-end:var(--cr-icon-ripple-padding);padding-inline-start:14px}#labelWrapper{margin-inline-start:var(--cr-radio-button-label-spacing,20px)}.primary-text{color:var(--cros-text-color-primary);font:var(--cros-body-2-font)}iron-icon{height:20px;width:20px}</style>

<div id="container">
  <!-- This item behaves similar to a radio button and reuses disc and label
       style in cr-radio-button-style. -->
  <div class="disc-wrapper" aria-hidden="true">
    <div class="disc-border"></div>
    <div class="disc"></div>
  </div>

  <div id="labelWrapper" aria-hidden="true">
    <div class="primary-text">[[getItemName_(topicSource)]]</div>
    <div class="cr-secondary-text">
      [[getItemDescription_(topicSource, hasGooglePhotosAlbums)]]
    </div>
  </div>

  <iron-icon icon="cr:chevron-right" aria-hidden="true"></iron-icon>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview This component displays a topic (image) source.
 */
class TopicSourceItemElement extends WithPersonalizationStore {
    static get is() {
        return 'topic-source-item';
    }
    static get template() {
        return getTemplate$U();
    }
    static get properties() {
        return {
            /**
             * Whether this item is selected. This property is related to
             * cr_radio_button_style and used to style the disc appearance.
             */
            checked: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
                observer: 'onCheckedChanged_',
            },
            disabled: {
                type: Boolean,
                value: false,
                reflectToAttribute: true,
            },
            topicSource: TopicSource,
            hasGooglePhotosAlbums: {
                type: Boolean,
                value: null,
            },
            ariaLabel: {
                type: String,
                computed: 'computeAriaLabel_(topicSource, checked)',
                reflectToAttribute: true,
            },
        };
    }
    ready() {
        super.ready();
        this.addEventListener('click', this.onItemSelected_.bind(this));
        this.addEventListener('keydown', this.onItemSelected_.bind(this));
    }
    onCheckedChanged_(value) {
        this.setAttribute('aria-checked', value.toString());
    }
    onItemSelected_(event) {
        if (!isSelectionEvent$1(event)) {
            return;
        }
        event.preventDefault();
        event.stopPropagation();
        setTopicSource(this.topicSource, getAmbientProvider(), this.getStore());
        PersonalizationRouterElement.instance().selectAmbientAlbums(this.topicSource);
    }
    getItemName_() {
        return getTopicSourceName(this.topicSource);
    }
    getItemDescription_() {
        if (this.topicSource === TopicSource.kGooglePhotos) {
            if (!this.hasGooglePhotosAlbums) {
                return '';
            }
            if (this.hasGooglePhotosAlbums) {
                return this.i18n('ambientModeTopicSourceGooglePhotosDescription');
            }
            else {
                return this.i18n('ambientModeTopicSourceGooglePhotosDescriptionNoAlbum');
            }
        }
        else if (this.topicSource === TopicSource.kArtGallery) {
            return this.i18n('ambientModeTopicSourceArtGalleryDescription');
        }
        else if (this.topicSource === TopicSource.kVideo) {
            return this.i18n('ambientModeTopicSourceVideoDescription');
        }
        else {
            return '';
        }
    }
    computeAriaLabel_() {
        // topicSource may be undefined when aria label is computed the first time.
        if (this.topicSource === undefined) {
            return '';
        }
        if (this.checked) {
            return this.i18n('ambientModeTopicSourceSelectedRow', this.getItemName_(), this.getItemDescription_());
        }
        return this.i18n('ambientModeTopicSourceUnselectedRow', this.getItemName_(), this.getItemDescription_());
    }
}
customElements.define(TopicSourceItemElement.is, TopicSourceItemElement);

function getTemplate$T() {
    return html `<!--_html_template_start_--><style include="common">topic-source-item{align-items:center;height:64px;margin:0 10px;width:calc(100% - 20px)}iron-list>*:not(:first-of-type){border-top:var(--cr-separator-line)}iron-list>:focus{background-color:var(--cros-sys-hover_on_subtle,--cr-focused-item-color)}</style>

<h3 id="topicSourceTitle" class="ambient-subpage-element-title">
  $i18n{ambientModeTopicSourceTitle}
</h3>

<iron-list id="topicSourceList" items="[[topicSources]]"
    aria-describedby="topicSourceTitle" role="radiogroup">
  <template>
    <topic-source-item topic-source="[[item]]"
        disabled="[[isTopicSourceDisabled_(item, selectedAmbientTheme)]]"
        role="radio"
        tabindex$="[[tabIndex]]"
        has-google-photos-albums="[[hasGooglePhotosAlbums]]"
        checked="[[isSelected_(item, selectedTopicSource)]]">
    </topic-source-item>
  </template>
</iron-list>
<!--_html_template_end_-->`;
}

// Copyright 2022 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview This component displays a list of topic (image) sources. It
 * behaviors similar to a radio button group, e.g. single selection.
 */
class TopicSourceListElement extends WithPersonalizationStore {
    static get is() {
        return 'topic-source-list';
    }
    static get template() {
        return getTemplate$T();
    }
    static get properties() {
        return {
            topicSources: {
                type: Array,
                value() {
                    const topicSources = [TopicSource.kGooglePhotos, TopicSource.kArtGallery];
                    // Pushes the video image source to the front to highlight exclusive
                    // content.
                    if (isTimeOfDayScreenSaverEnabled()) {
                        topicSources.unshift(TopicSource.kVideo);
                    }
                    return topicSources;
                },
            },
            selectedAmbientTheme: AmbientTheme,
            selectedTopicSource: TopicSource,
            hasGooglePhotosAlbums: Boolean,
        };
    }
    focus() {
        const elem = this.shadowRoot.querySelector('topic-source-item[checked]');
        if (elem) {
            elem.focus();
        }
    }
    isTopicSourceDisabled_(topicSource, selectedAmbientTheme) {
        return !isValidTopicSourceAndTheme(topicSource, selectedAmbientTheme);
    }
    isSelected_(topicSource, selectedTopicSource) {
        return selectedTopicSource === topicSource;
    }
}
customElements.define(TopicSourceListElement.is, TopicSourceListElement);

function getTemplate$S() {
    return html `<!--_html_template_start_--><style include="common">#container{display:grid;grid-template-areas:'leftspacertop    preview rightspacertop   ' 'leftspacerbottom content rightspacerbottom';grid-template-columns:minmax(10px,1fr) minmax(568px,920px) minmax(10px,1fr);grid-template-rows:auto minmax(0,1fr);height:100%;margin-block-end:0;min-height:var(--personalization-app-subpage-container-min-height)}#mainSettings{background-color:var(--cros-bg-color);display:flex;flex-direction:column;grid-area:content;padding:20px 0 20px 0}toggle-row,#toggleRowPlaceholder{margin:0 10px}ambient-duration,#durationPlaceholder{border-top:var(--cr-separator-line);margin:0 10px}.ambient-toggle-label-placeholder{height:20px;margin-bottom:2px;width:10%}ambient-preview-small{grid-area:preview;margin:0 10px}albums-subpage{background-color:var(--cros-bg-color);grid-area:content;padding:20px 0 20px 0}.ambient-theme-placeholder-list{width:516px}.ambient-theme-placeholder-container{box-sizing:border-box;overflow:hidden;padding:calc(var(--personalization-app-grid-item-spacing) / 2);width:calc(100% / 3 - 0.34px)}.ambient-theme-item-placeholder{align-items:center;border-radius:var(--personalization-app-grid-item-border-radius);box-sizing:border-box;display:flex;flex-direction:column;height:120px;justify-content:center;overflow:hidden;position:relative;width:100%}.ambient-theme-item-title-placeholder{margin-top:8px}div[class^='ambient-text-placeholder']{align-items:flex-start;box-sizing:border-box;display:flex;flex-direction:column;justify-content:center;overflow:hidden;padding-inline:var(--cr-section-padding) var(--cr-icon-ripple-padding);width:100%}.topic-source-placeholder{height:64px}.weather-unit-placeholder{height:48px}.ambient-text-placeholder-0{border-bottom:1px solid var(--cros-separator-color)}div[class^='ambient-text-placeholder']>*+*{margin-top:8px}.ambient-primary-text-placeholder{height:20px;width:75%}.ambient-secondary-text-placeholder{height:20px;width:50%}</style>
<div id="container">
  <div class="leftspacertop"></div>
  <div class="leftspacerbottom"></div>
  <ambient-preview-small></ambient-preview-small>
  <!-- restamp to avoid layout issues with iron-list resizing while hidden -->
  <template is="dom-if" if="[[shouldShowMainSettings_(path)]]" restamp>
    <div id="mainSettings">
      <template is="dom-if" if="[[loading_]]">
        <div id="toggleRowPlaceholder">
          <div class="ambient-toggle-label-placeholder placeholder"></div>
          <div class="ambient-toggle-row-container">
            <div class="ambient-toggle-row">
              <div class="ambient-primary-text-placeholder placeholder"></div>
            </div>
          </div>
        </div>
        <div id="durationPlaceholder">
          <div class="ambient-toggle-row">
            <h3 class="ambient-subpage-element-title" aria-hidden="true">
              $i18n{ambientModeDurationTitle}
            </h3>
            <div class="ambient-secondary-text-placeholder placeholder"></div>
          </div>
        </div>
        <div id="ambientThemePlaceholder">
          <h3 id="ambientThemeTitle" class="ambient-subpage-element-title" aria-hidden="true">
            $i18n{ambientModeAnimationTitle}
          </h3>
          <iron-list class="ambient-theme-placeholder-list" items="[[getPlaceholders_(3)]]" grid>
            <template>
              <div class="ambient-theme-placeholder-container">
                <div class="ambient-theme-item-placeholder placeholder"></div>
                <div class="ambient-theme-item-title-placeholder
                    ambient-primary-text-placeholder placeholder"></div>
              </div>
            </template>
          </iron-list>
        </div>
        <div id="topicSourcePlaceholder">
          <h3 id="topicSourceTitle" class="ambient-subpage-element-title" aria-hidden="true">
            $i18n{ambientModeTopicSourceTitle}
          </h3>
          <div class="ambient-text-placeholder-0 topic-source-placeholder">
            <div class="ambient-primary-text-placeholder placeholder"></div>
            <div class="ambient-secondary-text-placeholder placeholder"></div>
          </div>
          <div class="ambient-text-placeholder-1 topic-source-placeholder">
            <div class="ambient-primary-text-placeholder placeholder"></div>
            <div class="ambient-secondary-text-placeholder placeholder"></div>
          </div>
        </div>
        <div id="weatherUnitPlaceholder">
          <h3 id="weatherTitle" class="ambient-subpage-element-title" aria-hidden="true">
            $i18n{ambientModeWeatherTitle}
          </h3>
          <div class="ambient-text-placeholder-0 weather-unit-placeholder">
            <div class="ambient-secondary-text-placeholder placeholder"></div>
          </div>
          <div class="ambient-text-placeholder-1 weather-unit-placeholder">
            <div class="ambient-secondary-text-placeholder placeholder"></div>
          </div>
        </div>
      </template>
      <template is="dom-if" if="[[!loading_]]">
        <toggle-row id="ambientToggleRow"></toggle-row>
        <template is="dom-if" if="[[ambientModeEnabled_]]">
          <ambient-duration duration="[[duration_]]">
          </ambient-duration>
          <ambient-theme-list
              selected-ambient-theme="[[ambientTheme_]]">
          </ambient-theme-list>
          <topic-source-list selected-topic-source="[[topicSource_]]"
              selected-ambient-theme="[[ambientTheme_]]"
              has-google-photos-albums="[[hasGooglePhotosAlbums_(albums_)]]">
          </topic-source-list>
          <ambient-weather-unit
              selected-temperature-unit="[[temperatureUnitToString_(temperatureUnit_)]]">
          </ambient-weather-unit>
        </template>
      </template>
    </div>
  </template>
  <template is="dom-if" if="[[shouldShowAlbums_(path)]]" restamp>
    <albums-subpage topic-source="[[getTopicSource_(queryParams)]]"
        albums="[[getAlbums_(albums_, queryParams)]]">
    </albums-subpage>
  </template>
  <div class="rightspacertop"></div>
  <div class="rightspacerbottom"></div>
</div>
<!--_html_template_end_-->`;
}

// Copyright 2021 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview The ambient-subpage component displays the main content of
 * the ambient mode settings.
 */
class AmbientSubpageElement extends WithPersonalizationStore {
    constructor() {
        super(...arguments);
      