import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="common cros-button-style">#container{background-color:var(--cros-bg-color);border:none;border-radius:16px;display:grid;grid-template-areas:'. slot           slot    slot      .' '. image          image   image     .' '. .              .       .         .' '. message        message message   .' '. mainpage-desc  .       thumbnail .' '. .              .       .         .';grid-template-columns:20px auto 192px auto 20px;grid-template-rows:auto auto 20px 192px 1fr 20px;height:100%}#container.ambient-mode-enabled{grid-template-areas:'. slot          .' '. image         .' '. .             .' '. thumbnail     .' '. mainpage-desc .' '. .             .';grid-template-columns:20px minmax(0,1fr) 20px;grid-template-rows:auto auto 20px 130px 1fr 18px}#ambientLabel{align-items:center;background:none;border:none;display:flex;flex-flow:row nowrap;grid-area:slot;justify-content:space-between;margin-top:12px}#ambientLabel>cr-icon-button{--cr-icon-button-size:44px;margin-inline-end:-18px}#ambientLabel>h2{color:var(--cros-text-color-primary);font:var(--personalization-app-label-font);margin:12px 0}#messageContainer{align-items:center;display:flex;flex-direction:column;grid-area:message;justify-content:space-between}#messageContainer .text{color:var(--cros-sys-on_primary_container);font:var(--cros-body-2-font);line-height:1.5;margin-top:56px;position:relative;text-align:center;width:128px}#messageContainer cr-button{margin-bottom:50px;margin-top:8px}ambient-zero-state-svg{position:absolute}#imageContainer,#imagePlaceholder{aspect-ratio:340/220;display:flex;height:100%;justify-self:center;max-width:460px;min-width:278px;width:100%}.album-info-mainpage,#textPlaceholder{align-items:center;display:flex;grid-area:mainpage-desc;justify-content:center}#textPlaceholder .placeholder:first-child{margin-top:8px}#imageContainer,#imagePlaceholder{grid-area:image}#albumTitle{color:var(--cros-text-color-primary);font:var(--cros-display-7-font);margin-top:10px}#albumDescription{color:var(--cros-text-color-secondary);font:var(--cros-body-2-font);margin-top:2px}#buttonContainer{grid-area:buttons}#buttonContainer .text{margin-inline-start:8px}#buttonContainer .preview-button-disabled{cursor:wait;pointer-events:none}#buttonContainer cr-button{border-color:var(--cros-button-stroke-color-secondary);border-radius:16px}#buttonContainer .spinner{height:20px;width:20px}#thumbnailContainer,#thumbnailPlaceholder{display:grid;grid-area:thumbnail;justify-self:center;max-width:460px;min-width:278px;overflow:hidden;width:100%}.thumbnail-item{height:100%;overflow:hidden;width:100%}.thumbnail-item img{height:100%;object-fit:cover;width:100%}#thumbnailContainer.thumbnail-0{background-color:var(--personalization-app-grid-item-background-color);border-radius:12px}#thumbnailContainer.thumbnail-1 .thumbnail-item{border-radius:60px}#thumbnailContainer.thumbnail-2{column-gap:12px;grid-template-columns:130px minmax(0,1fr)}#thumbnailContainer.thumbnail-2 .thumbnail-item:first-of-type{clip-path:url(#squiggleClip)}#thumbnailContainer.thumbnail-2 .thumbnail-item:last-of-type{border-radius:60px}#thumbnailContainer.thumbnail-3{column-gap:8px;grid-template-columns:minmax(0,1fr) 32px 32px}#thumbnailContainer.thumbnail-3 .thumbnail-item:first-of-type{border-radius:60px}#thumbnailContainer.thumbnail-3 .thumbnail-item:last-of-type img,#thumbnailContainer.thumbnail-3 .thumbnail-item:nth-last-of-type(2) img{border-radius:16px}#helpLink{color:var(--text-color-action);text-decoration:none}</style>
<div class$="[[getPreviewContainerClass_(ambientModeEnabled_, loading_)]]" id="container">
  <!-- Use inline svg in order to reference the clip path by url() -->
  <svg fill="none"
      height="0"
      viewBox="0 0 130 130"
      width="0"
      xmlns="http://www.w3.org/2000/svg">
    <defs>
      <clipPath id="squiggleClip">
        <path d="M 1.4375 72.371094 C -0.332031 69.402344 -0.476562 65.738281 1.054688 62.640625 L 3.210938 58.28125 C 4.125 56.429688 4.457031 54.339844 4.15625 52.296875 L 3.457031 47.484375 C 2.957031 44.066406 4.226562 40.625 6.824219 38.347656 L 10.484375 35.148438 C 12.039062 33.785156 13.144531 31.984375 13.652344 29.980469 L 14.84375 25.265625 C 15.691406 21.914062 18.179688 19.222656 21.453125 18.113281 L 26.058594 16.554688 C 28.015625 15.894531 29.726562 14.652344 30.960938 12.996094 L 33.867188 9.097656 C 35.929688 6.324219 39.261719 4.789062 42.710938 5.019531 L 47.5625 5.339844 C 49.625 5.480469 51.679688 4.984375 53.453125 3.925781 L 57.628906 1.4375 C 60.597656 -0.332031 64.261719 -0.476562 67.359375 1.054688 L 71.71875 3.210938 C 73.570312 4.125 75.660156 4.457031 77.703125 4.15625 L 82.515625 3.457031 C 85.933594 2.957031 89.375 4.226562 91.652344 6.824219 L 94.851562 10.484375 C 96.214844 12.039062 98.015625 13.144531 100.019531 13.652344 L 104.734375 14.84375 C 108.085938 15.691406 110.777344 18.179688 111.886719 21.453125 L 113.445312 26.058594 C 114.105469 28.015625 115.347656 29.726562 117.003906 30.960938 L 120.902344 33.867188 C 123.675781 35.929688 125.210938 39.261719 124.980469 42.710938 L 124.660156 47.5625 C 124.519531 49.625 125.015625 51.679688 126.074219 53.453125 L 128.5625 57.628906 C 130.332031 60.597656 130.476562 64.261719 128.945312 67.359375 L 126.792969 71.71875 C 125.875 73.570312 125.542969 75.660156 125.84375 77.703125 L 126.542969 82.515625 C 127.042969 85.933594 125.773438 89.375 123.175781 91.652344 L 119.515625 94.851562 C 117.960938 96.214844 116.855469 98.015625 116.347656 100.019531 L 115.15625 104.734375 C 114.308594 108.085938 111.820312 110.777344 108.546875 111.886719 L 103.941406 113.445312 C 101.984375 114.105469 100.273438 115.347656 99.039062 117.003906 L 96.132812 120.902344 C 94.070312 123.675781 90.738281 125.210938 87.289062 124.980469 L 82.4375 124.660156 C 80.375 124.519531 78.320312 125.015625 76.546875 126.074219 L 72.371094 128.5625 C 69.402344 130.332031 65.738281 130.476562 62.640625 128.945312 L 58.28125 126.792969 C 56.429688 125.875 54.339844 125.542969 52.296875 125.84375 L 47.484375 126.542969 C 44.066406 127.042969 40.625 125.773438 38.347656 123.175781 L 35.148438 119.515625 C 33.785156 117.960938 31.984375 116.855469 29.980469 116.347656 L 25.265625 115.15625 C 21.914062 114.308594 19.222656 111.820312 18.113281 108.546875 L 16.554688 103.941406 C 15.894531 101.984375 14.652344 100.273438 12.996094 99.039062 L 9.097656 96.132812 C 6.324219 94.070312 4.789062 90.738281 5.019531 87.289062 L 5.339844 82.4375 C 5.480469 80.375 4.984375 78.320312 3.925781 76.546875 Z M 1.4375 72.371094 ">
        </path>
      </clipPath>
    </defs>
  </svg>
  <template is="dom-if" if="[[!isAmbientModeAllowed_]]">
    <div id="ambientLabel" class="disabled">
      <h2>$i18n{screensaverLabel}</h2>
      <cr-icon-button disabled
          iron-icon="cr:chevron-right">
      </cr-icon-button>
    </div>
    <div ambient-mode-managed
        aria-hidden="true"
        class="preview-image-container"
        id="imageContainer">
      <div class="preview-image-border"></div>
      <img class="preview-image disabled"
          src="//personalization/images/slideshow.png">
    </div>
    <div id="messageContainer">
      <ambient-zero-state-svg></ambient-zero-state-svg>
      <span class="text" id="turnOnDescription">
        $i18n{ambientModeMainPageEnterpriseUserMessage}
      </span>
      <cr-button class="primary action-button">
        <!-- TODO(b/282827734): create new p-link for the support page -->
        <a id="helpLink" href="https://support.google.com/chromebook?p=wallpaper_fileerror"
            target="_blank">$i18n{ambientModeLearnMoreLabel}</a>
      </cr-button>
    </div>
  </template>
  <template is="dom-if" if="[[isAmbientModeAllowed_]]">
    <div id="ambientLabel">
      <h2 class="clickable" on-click="onClickAmbientSubpageLink_">
        $i18n{screensaverLabel}
      </h2>
      <cr-icon-button aria-label="$i18n{ariaLabelChangeScreensaver}"
          class="tast-open-subpage"
          iron-icon="cr:chevron-right"
          on-click="onClickAmbientSubpageLink_">
      </cr-icon-button>
    </div>
    <template is="dom-if" if="[[loading_]]" restamp>
      <div id="imagePlaceholder" class$="[[getPlaceholderClasses_(shouldShowLoadingAnimation_)]]"></div>
      <div id="thumbnailPlaceholder" class$="[[getPlaceholderClasses_(shouldShowLoadingAnimation_)]]"></div>
      <div id="textPlaceholder"
          class="preview-text-placeholder album-info-mainpage">
        <div class$="[[getPlaceholderClasses_(shouldShowLoadingAnimation_)]]"></div>
        <div class$="[[getPlaceholderClasses_(shouldShowLoadingAnimation_)]]"></div>
      </div>
    </template>
    <template is="dom-if" if="[[!loading_]]">
      <template is="dom-if" if="[[!ambientModeEnabled_]]" restamp>
        <div aria-hidden="true"
            class="preview-image-container"
            id="imageContainer">
          <div class="preview-image-border"></div>
          <img class="preview-image disabled"
              src="//personalization/images/slideshow.png">
        </div>
        <div id="messageContainer">
          <ambient-zero-state-svg></ambient-zero-state-svg>
          <span class="text" id="turnOnDescription">
            $i18n{ambientModeMainPageZeroStateMessageV2}
          </span>
          <cr-button aria-describedby="turnOnDescription"
              class="primary action-button"
              on-click="onClickAmbientModeButton_">
            <span>$i18n{ambientModeTurnOnLabel}</span>
          </cr-button>
        </div>
      </template>
      <template is="dom-if" if="[[ambientModeEnabled_]]">
        <!-- TODO(b/226235802) - Add failed/error state when no previewAlbums
              available. Currently, we show blank containers -->
        <template is="dom-if" if="[[previewAlbums_]]">
          <div id="imageContainer" class="preview-image-container">
            <div class="preview-image-border"></div>
            <img alt$="[[getAlbumTitle_(firstPreviewAlbum_)]]"
                auto-src="[[getPreviewImage_(firstPreviewAlbum_)]]"
                class="preview-image clickable"
                is-google-photos is="cr-auto-img"
                on-click="onClickPreviewImage_"
                on-keypress="onClickPreviewImage_">
          </div>
          <div aria-hidden="true"
              class$="[[getThumbnailContainerClass_(thumbnailImages_)]]"
              id="thumbnailContainer"
              on-click="onClickThumbnails_"
              on-keypress="onClickThumbnails_">
            <template is="dom-repeat" items="[[thumbnailImages_]]">
              <div class="thumbnail-item">
                <img auto-src="[[item.url]]"
                    is-google-photos
                    is="cr-auto-img">
              </div>
            </template>
          </div>
          <div aria-label$="[[getPreviewTextAriaLabel_(firstPreviewAlbum_, topicSource_, previewAlbums_)]]"
              class="preview-text-container album-info-mainpage"
              id="textContainer">
            <span aria-hidden="true"
                id="albumTitle"
                title="[[getAlbumTitle_(firstPreviewAlbum_)]]">
              [[getAlbumTitle_(firstPreviewAlbum_)]]
            </span>
            <span aria-hidden="true" id="albumDescription">
              [[getAlbumDescription_(topicSource_, previewAlbums_)]]
            </span>
          </div>
        </template>
      </template>
    </template>
  </template>
</div>
<!--_html_template_end_-->`;
}
