import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="common cros-button-style">#container{border:none;display:grid;grid-template-areas:'image          . subpage-desc' 'image          . buttons' '.              . .';grid-template-columns:224px 32px minmax(0,1fr);grid-template-rows:118px 34px 20px}#container.ambient-mode-disabled{grid-template-areas:'image          . subpage-desc' '.              . .';grid-template-columns:224px 32px minmax(0,1fr);grid-template-rows:152px 20px}#buttonContainer,.currently-set-text{display:inline-flex}.album-info-subpage,.zero-state-info-subpage{display:flex;grid-area:subpage-desc;justify-content:center}#imageContainer,#imagePlaceholder{grid-area:image}#imageContainer img.disabled{opacity:50%}#buttonContainer{grid-area:buttons}#buttonContainer .text{margin-inline-start:8px}#buttonContainer .disabled{cursor:wait;pointer-events:none}#buttonContainer .spinner{--paper-spinner-color:var(--cros-sys-primary,--cros-button-label-color-primary);height:20px;width:20px}
</style>
<div class$="[[getPreviewContainerClass_(ambientModeEnabled_, loading_)]]"
    id="container">
  <template is="dom-if" if="[[loading_]]" restamp>
    <div id="imagePlaceholder" class$="[[getPlaceholderClasses_(shouldShowLoadingAnimation_)]]"></div>
    <div id="textPlaceholder"
        class="preview-text-placeholder album-info-subpage">
      <div class$="[[getPlaceholderClasses_(shouldShowLoadingAnimation_)]] currently-set-text"></div>
      <div class$="[[getPlaceholderClasses_(shouldShowLoadingAnimation_)]]"></div>
      <div class$="[[getPlaceholderClasses_(shouldShowLoadingAnimation_)]]"></div>
    </div>
  </template>
  <template is="dom-if" if="[[!loading_]]" restamp>
    <template is="dom-if" if="[[!ambientModeEnabled_]]" restamp>
      <div aria-hidden="true"
          class="preview-image-container"
          id="imageContainer">
        <div class="preview-image-border"></div>
        <img class="preview-image disabled" src="//personalization/images/slideshow.png">
      </div>
      <h2 id="zeroStateTextContainer"
          class="preview-text-container zero-state-info-subpage"
          aria-label="$i18n{ambientModeMainPageZeroStateMessage}">
        <span class="text">
          $i18n{ambientModeMainPageZeroStateMessage}
        </span>
      </h2>
    </template>
    <template is="dom-if" if="[[ambientModeEnabled_]]">
      <!-- TODO(b/226235802) - Add failed/error state when no previewAlbums available.
            Currently, we show blank containers -->
      <template is="dom-if" if="[[previewAlbums_]]">
        <div id="imageContainer" class="preview-image-container">
          <div class="preview-image-border"></div>
          <img class="preview-image" is="cr-auto-img"
              auto-src="[[getPreviewImage_(firstPreviewAlbum_)]]"
              alt$="[[getAlbumTitle_(firstPreviewAlbum_)]]"
              is-google-photos>
        </div>
        <h2 aria-label$="[[getPreviewTextAriaLabel_(firstPreviewAlbum_, topicSource_, previewAlbums_)]]"
            class="preview-text-container album-info-subpage"
            id="textContainer"
            role="alert">
          <span id="currentlySet" class="currently-set-text" aria-hidden="true">
            $i18n{currentlySet}
          </span>
          <span id="albumTitle" aria-hidden="true"
              title="[[getAlbumTitle_(firstPreviewAlbum_)]]">
            [[getAlbumTitle_(firstPreviewAlbum_)]]
          </span>
          <span id="albumDescription" aria-hidden="true">
            [[getAlbumDescription_(topicSource_, previewAlbums_)]]
          </span>
        </h2>
        <div id="buttonContainer">
          <cr-button
              class$="[[getScreenSaverPreviewClass_(ambientUiVisibility_)]]"
              aria-label$="[[getScreenSaverPreviewAriaLabel_(ambientUiVisibility_)]]"
              role$="[[getScreenSaverPreviewRole_(ambientUiVisibility_)]]"
              on-click="startScreenSaverPreview_">
            <iron-icon icon="personalization:fullscreen"
                hidden$="[[screenSaverPreviewActive_]]"></iron-icon>
            <paper-spinner-lite active class="spinner"
                hidden$="[[!screenSaverPreviewActive_]]"></paper-spinner-lite>
            <div class="text">
              [[getScreenSaverPreviewText_(ambientUiVisibility_)]]
            </div>
          </cr-button>
        </div>
      </template>
    </template>
  </template>
</div>
<!--_html_template_end_-->`;
}
