import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="common">#container{display:grid;grid-template-areas:'leftspacertop    preview rightspacertop   ' 'leftspacerbottom content rightspacerbottom';grid-template-columns:minmax(10px,1fr) minmax(568px,920px) minmax(10px,1fr);grid-template-rows:auto minmax(0,1fr);height:100%;margin-block-end:0;min-height:var(--personalization-app-subpage-container-min-height)}#mainSettings{background-color:var(--cros-bg-color);display:flex;flex-direction:column;grid-area:content;padding:20px 0 20px 0}toggle-row,#toggleRowPlaceholder{margin:0 10px}ambient-duration,#durationPlaceholder{border-top:var(--cr-separator-line);margin:0 10px}.ambient-toggle-label-placeholder{height:20px;margin-bottom:2px;width:10%}ambient-preview-small{grid-area:preview;margin:0 10px}albums-subpage{background-color:var(--cros-bg-color);grid-area:content;padding:20px 0 20px 0}.ambient-theme-placeholder-list{width:516px}.ambient-theme-placeholder-container{box-sizing:border-box;overflow:hidden;padding:calc(var(--personalization-app-grid-item-spacing) / 2);width:calc(100% / 3 - 0.34px)}.ambient-theme-item-placeholder{align-items:center;border-radius:var(--personalization-app-grid-item-border-radius);box-sizing:border-box;display:flex;flex-direction:column;height:120px;justify-content:center;overflow:hidden;position:relative;width:100%}.ambient-theme-item-title-placeholder{margin-top:8px}div[class^='ambient-text-placeholder']{align-items:flex-start;box-sizing:border-box;display:flex;flex-direction:column;justify-content:center;overflow:hidden;padding-inline:var(--cr-section-padding) var(--cr-icon-ripple-padding);width:100%}.topic-source-placeholder{height:64px}.weather-unit-placeholder{height:48px}.ambient-text-placeholder-0{border-bottom:1px solid var(--cros-separator-color)}div[class^='ambient-text-placeholder']>*+*{margin-top:8px}.ambient-primary-text-placeholder{height:20px;width:75%}.ambient-secondary-text-placeholder{height:20px;width:50%}</style>
<div id="container">
  <div class="leftspacertop"></div>
  <div class="leftspacerbottom"></div>
  <ambient-preview-small></ambient-preview-small>
  <!-- restamp to avoid layout issues with iron-list resizing while hidden -->
  <template is="dom-if" if="[[shouldShowMainSettings_(path)]]" restamp>
    <div id="mainSettings">
      <template is="dom-if" if="[[loading_]]">
        <div id="toggleRowPlaceholder">
          <div class="ambient-toggle-label-placeholder placeholder"></div>
          <div class="ambient-toggle-row-container">
            <div class="ambient-toggle-row">
              <div class="ambient-primary-text-placeholder placeholder"></div>
            </div>
          </div>
        </div>
        <div id="durationPlaceholder">
          <div class="ambient-toggle-row">
            <h3 class="ambient-subpage-element-title" aria-hidden="true">
              $i18n{ambientModeDurationTitle}
            </h3>
            <div class="ambient-secondary-text-placeholder placeholder"></div>
          </div>
        </div>
        <div id="ambientThemePlaceholder">
          <h3 id="ambientThemeTitle" class="ambient-subpage-element-title" aria-hidden="true">
            $i18n{ambientModeAnimationTitle}
          </h3>
          <iron-list class="ambient-theme-placeholder-list" items="[[getPlaceholders_(3)]]" grid>
            <template>
              <div class="ambient-theme-placeholder-container">
                <div class="ambient-theme-item-placeholder placeholder"></div>
                <div class="ambient-theme-item-title-placeholder
                    ambient-primary-text-placeholder placeholder"></div>
              </div>
            </template>
          </iron-list>
        </div>
        <div id="topicSourcePlaceholder">
          <h3 id="topicSourceTitle" class="ambient-subpage-element-title" aria-hidden="true">
            $i18n{ambientModeTopicSourceTitle}
          </h3>
          <div class="ambient-text-placeholder-0 topic-source-placeholder">
            <div class="ambient-primary-text-placeholder placeholder"></div>
            <div class="ambient-secondary-text-placeholder placeholder"></div>
          </div>
          <div class="ambient-text-placeholder-1 topic-source-placeholder">
            <div class="ambient-primary-text-placeholder placeholder"></div>
            <div class="ambient-secondary-text-placeholder placeholder"></div>
          </div>
        </div>
        <div id="weatherUnitPlaceholder">
          <h3 id="weatherTitle" class="ambient-subpage-element-title" aria-hidden="true">
            $i18n{ambientModeWeatherTitle}
          </h3>
          <div class="ambient-text-placeholder-0 weather-unit-placeholder">
            <div class="ambient-secondary-text-placeholder placeholder"></div>
          </div>
          <div class="ambient-text-placeholder-1 weather-unit-placeholder">
            <div class="ambient-secondary-text-placeholder placeholder"></div>
          </div>
        </div>
      </template>
      <template is="dom-if" if="[[!loading_]]">
        <toggle-row id="ambientToggleRow"></toggle-row>
        <template is="dom-if" if="[[ambientModeEnabled_]]">
          <ambient-duration duration="[[duration_]]">
          </ambient-duration>
          <ambient-theme-list
              selected-ambient-theme="[[ambientTheme_]]">
          </ambient-theme-list>
          <topic-source-list selected-topic-source="[[topicSource_]]"
              selected-ambient-theme="[[ambientTheme_]]"
              has-google-photos-albums="[[hasGooglePhotosAlbums_(albums_)]]">
          </topic-source-list>
          <ambient-weather-unit
              selected-temperature-unit="[[temperatureUnitToString_(temperatureUnit_)]]">
          </ambient-weather-unit>
        </template>
      </template>
    </div>
  </template>
  <template is="dom-if" if="[[shouldShowAlbums_(path)]]" restamp>
    <albums-subpage topic-source="[[getTopicSource_(queryParams)]]"
        albums="[[getAlbums_(albums_, queryParams)]]">
    </albums-subpage>
  </template>
  <div class="rightspacertop"></div>
  <div class="rightspacerbottom"></div>
</div>
<!--_html_template_end_-->`;
}
