import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="common cros-button-style">cr-radio-group{width:100%}cr-radio-button{height:48px;padding:0 14px;margin:0 10px}cr-radio-button+cr-radio-button{border-top:var(--cr-separator-line)}#geolocationWarningDiv{display:flex;align-items:center;width:inherit;margin:0 10px;font:var(--cros-body-2-font);color:var(--cros-text-color-secondary)}#policyIcon{margin-inline-start:auto;margin-inline-end:10px}</style>
<div id="weatherDiv">
  <h3 id="weatherTitle" class="ambient-subpage-element-title">
    $i18n{ambientModeWeatherTitle}
  </h3>
  <template is="dom-if" if="[[shouldShowGeolocationWarningText_]]" restamp>
    <div id="geolocationWarningDiv">
      <template is="dom-if" if="[[geolocationIsUserModifiable_]]" restamp>
        <localized-link
            on-link-clicked="openGeolocationDialog_"
            localized-string="$i18n{geolocationWarningTextForWeather}">
        </localized-link>
      </template>
      <template is="dom-if" if="[[!geolocationIsUserModifiable_]]" restamp>
        $i18n{geolocationWarningManagedTextForWeather}
        <cr-policy-indicator
            id="policyIcon"
            indicator-type="userPolicy"
            title="$i18n{managedSetting}">
        </cr-policy-indicator>
      </template>
    </div>
  </template>
  <template is="dom-if" if="[[!shouldShowGeolocationWarningText_]]" restamp>
    <div class="weather-unit-list">
      <cr-radio-group
          id="ambientTemperatureUnit"
          selected="{{selectedTemperatureUnit}}"
          aria-description="$i18n{ambientModeAriaDescriptionWeather}"
          aria-labelledby="weatherTitle">
        <cr-radio-button
            name="[[temperatureUnit_.kFahrenheit]]"
            class="weather-unit-item"
            label="$i18n{ambientModeWeatherUnitFahrenheit}">
        </cr-radio-button>
        <cr-radio-button
            name="[[temperatureUnit_.kCelsius]]"
            class="weather-unit-item"
            label="$i18n{ambientModeWeatherUnitCelsius}">
        </cr-radio-button>
      </cr-radio-group>
    </div>
  </template>
</div>

<template is="dom-if" if="[[shouldShowGeolocationDialog_]]" restamp>
  <geolocation-dialog id="geolocationDialog"
      body-text-paragraph1="$i18n{systemGeolocationDialogBodyParagraph1}"
      body-text-paragraph2="$i18n{systemGeolocationDialogBodyParagraph2}"
      confirm-button-text="$i18n{systemGeolocationDialogConfirmButton}"
      cancel-button-text="$i18n{systemGeolocationDialogCancelButton}"
      on-geolocation-enabled="onGeolocationEnabled_"
      on-close="onGeolocationDialogClose_">
  </geolocation-dialog>
</template>
<!--_html_template_end_-->`;
}
